/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.pifimpl;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.DataSourceResolver;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.LightHashMap;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.pif.ui.UIRuntimeException;
import com.biglybt.pif.ui.toolbar.UIToolBarEnablerBase;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.common.updater.UIUpdater;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.debug.ObfuscateImage;
import com.biglybt.ui.swt.pif.PluginUISWTSkinObject;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pif.UISWTViewEventListener;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.pifimpl.UISWTViewCore;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.pifimpl.UISWTViewEventCancelledException;
import com.biglybt.ui.swt.pifimpl.UISWTViewEventImpl;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.uiupdater.UIUpdaterSWT;
import com.biglybt.ui.swt.views.IViewAlwaysInitialize;
import com.biglybt.ui.swt.views.IViewRequiresPeriodicUpdates;
import com.biglybt.util.DataSourceUtils;
import com.biglybt.util.MapUtils;
import java.awt.Frame;
import java.awt.Panel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;

public class UISWTViewImpl
implements UISWTViewCore,
UIPluginViewToolBarListener {
    public static final String CFG_PREFIX = "Views.plugins.";
    protected static final String SO_ID_ENTRY_WRAPPER = "mdi.content.item";
    protected static long uniqueNumber = 0L;
    private boolean delayInitializeToFirstActivate = true;
    private static final boolean DEBUG_TRIGGERS = false;
    protected PluginUISWTSkinObject skinObject;
    private Object initialDatasource;
    private UISWTView parentView;
    protected SWTSkin skin;
    protected Object datasource = DataSourceResolver.DEFAULT_DATASOURCE;
    private boolean useCoreDataSource = false;
    private UISWTViewEventListener eventListener;
    protected Composite composite;
    protected final String id;
    private String titleID;
    private int iControlType = 0;
    private Boolean isShown = null;
    private Map<Object, Object> user_data;
    private boolean haveSentInitialize = false;
    private boolean created = false;
    private boolean destroyOnDeactivate = true;
    private Composite masterComposite;
    private final Set<UIPluginViewToolBarListener> setToolBarEnablers = new HashSet<UIPluginViewToolBarListener>();
    private UISWTViewBuilderCore eventListenerBuilder;
    private ViewTitleInfo viewTitleInfo;

    public UISWTViewImpl(String id) {
        this.id = id;
    }

    public UISWTViewImpl(UISWTViewBuilderCore builder, boolean doCreate) throws UISWTViewEventCancelledException {
        this(builder.getViewID());
        this.eventListenerBuilder = builder;
        UISWTViewEventListener eventListener = builder.createEventListener(this);
        if (eventListener == null) {
            throw new UISWTViewEventCancelledException(new NullPointerException("Could not create " + this.id));
        }
        this.datasource = this.initialDatasource = builder.getInitialDataSource();
        eventListener.eventOccurred(new UISWTViewEventImpl(this, 10, null));
        this.setEventListener(eventListener, builder, doCreate);
    }

    public void setEventListener(UISWTViewEventListener _eventListener, UISWTViewBuilderCore builder, boolean doCreate) throws UISWTViewEventCancelledException {
        String initialTitle;
        this.eventListener = _eventListener;
        this.eventListenerBuilder = builder;
        if (this.eventListener == null) {
            return;
        }
        if (this.eventListener instanceof IViewAlwaysInitialize) {
            this.delayInitializeToFirstActivate = false;
        }
        if (this.eventListener instanceof UISWTViewCoreEventListener) {
            this.setUseCoreDataSource(true);
        }
        if (builder != null && this.titleID == null && (initialTitle = builder.getInitialTitle()) != null) {
            this.setTitle(initialTitle);
        }
        if (builder != null) {
            this.initialDatasource = builder.getInitialDataSource();
        }
        if (doCreate && !this.triggerBooleanEvent(0, this)) {
            throw new UISWTViewEventCancelledException();
        }
    }

    public void create() throws UISWTViewEventCancelledException {
        if (this.created) {
            throw new UISWTViewEventCancelledException(String.valueOf(this.id) + " already created");
        }
        if (!this.triggerBooleanEvent(0, this)) {
            throw new UISWTViewEventCancelledException();
        }
    }

    @Override
    public UISWTViewEventListener getEventListener() {
        return this.eventListener;
    }

    @Override
    public UISWTViewBuilderCore getEventListenerBuilder() {
        return this.eventListenerBuilder;
    }

    @Override
    public void setViewTitleInfo(ViewTitleInfo info) {
        this.viewTitleInfo = info;
    }

    @Override
    public ViewTitleInfo getViewTitleInfo() {
        if (this.viewTitleInfo != null) {
            return this.viewTitleInfo;
        }
        if (this.eventListener instanceof ViewTitleInfo) {
            return (ViewTitleInfo)((Object)this.eventListener);
        }
        return null;
    }

    @Override
    public Object getInitialDataSource() {
        return this.initialDatasource;
    }

    public void setDatasource(Object datasource) {
        this.triggerEvent(1, datasource);
    }

    @Override
    public Object getDataSource() {
        return PluginCoreUtils.convert(this.datasource, this.useCoreDataSource());
    }

    @Override
    public void setParentView(UISWTView parentView) {
        this.parentView = parentView;
    }

    @Override
    public UISWTView getParentView() {
        return this.parentView;
    }

    @Override
    public String getViewID() {
        return this.id;
    }

    @Override
    public void closeView() {
        this.triggerEvent(7, null);
    }

    @Override
    public void setControlType(int iControlType) {
        if (iControlType == 1 || iControlType == 0 || iControlType == 257) {
            this.iControlType = iControlType;
        }
    }

    @Override
    public int getControlType() {
        return this.iControlType;
    }

    @Override
    public void triggerEvent(int eventType, Object data) {
        if (eventType == 7) {
            if (Utils.isDisplayDisposed()) {
                return;
            }
            if (Utils.runIfNotSWTThread(() -> this.triggerEvent(eventType, data))) {
                return;
            }
        }
        try {
            this.triggerBooleanEvent(eventType, data);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    @Override
    public boolean isContentDisposed() {
        return this.masterComposite == null || this.masterComposite.isDisposed();
    }

    private static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    private boolean triggerBooleanEvent(int eventType, Object data) {
        if (eventType == 6) {
            this.refreshTitle();
            Messages.updateLanguageForControl((Widget)this.getComposite());
        }
        if (this.eventListener == null && eventType != 1) {
            return false;
        }
        if (eventType == 2) {
            if (this.haveSentInitialize) {
                return false;
            }
            if (!this.created) {
                this.triggerBooleanEvent(0, this);
            } else if (this.datasource != null) {
                this.triggerBooleanEvent(1, this.datasource);
            }
            this.haveSentInitialize = true;
        }
        if (eventType == 0) {
            this.created = true;
        }
        if (this.delayInitializeToFirstActivate && eventType == 3 && !this.haveSentInitialize) {
            this.swt_triggerInitialize();
        }
        if (eventType == 3 && this.isShown != null && this.isShown.booleanValue()) {
            return true;
        }
        if (eventType == 4 && this.isShown != null && !this.isShown.booleanValue()) {
            return true;
        }
        if (eventType == 1) {
            Object newDataSource = PluginCoreUtils.convert(data, true);
            if (DataSourceUtils.areSame(this.datasource, newDataSource) && (this.eventListener == null || !this.eventListener.informOfDuplicates(1))) {
                return true;
            }
            this.datasource = newDataSource;
            data = PluginCoreUtils.convert(this.datasource, this.useCoreDataSource);
            if (this.skinObject instanceof SWTSkinObject) {
                ((SWTSkinObject)this.skinObject).triggerListeners(7, data);
            }
            if (this.eventListener == null) {
                return true;
            }
        } else if (eventType == 9 && this.eventListener instanceof ObfuscateImage) {
            if (data instanceof Map) {
                ((ObfuscateImage)((Object)this.eventListener)).obfuscatedImage((Image)MapUtils.getMapObject((Map)data, "image", null, Image.class));
            }
        } else if (eventType == 3) {
            this.isShown = true;
            if (!this.haveSentInitialize) {
                this.swt_triggerInitialize();
            }
        } else if (eventType == 4) {
            this.isShown = false;
            if (this.destroyOnDeactivate) {
                this.triggerEvent(7, null);
            }
        } else if (eventType == 7) {
            if (this.isShown != null && this.isShown.booleanValue()) {
                this.triggerEvent(4, null);
            }
            if (!this.created && !this.haveSentInitialize && this.getComposite() == null) {
                return true;
            }
        }
        boolean result = false;
        try {
            result = this.eventListener.eventOccurred(new UISWTViewEventImpl(this, eventType, data));
        }
        catch (Throwable t) {
            Debug.out("ViewID=" + this.id + "; EventID=" + UISWTViewEvent.getEventDebug(eventType) + "; data=" + DataSourceUtils.toDebugString(data), t);
        }
        if (eventType == 7) {
            if (this.masterComposite != null && !this.masterComposite.isDisposed()) {
                Composite parent = this.masterComposite.getParent();
                Utils.disposeComposite(this.masterComposite);
                Utils.relayoutUp(parent);
            }
            this.setMasterComposite(null);
            this.composite = null;
            this.haveSentInitialize = false;
            this.isShown = false;
            this.created = false;
        } else if (eventType == 0) {
            data = PluginCoreUtils.convert(this.datasource, this.useCoreDataSource);
            this.triggerEventRaw(1, data);
            if (this.skinObject instanceof SWTSkinObject) {
                ((SWTSkinObject)this.skinObject).triggerListeners(7, data);
            }
        }
        return result;
    }

    protected boolean triggerEventRaw(int eventType, Object data) {
        if (this.eventListener == null) {
            System.err.println("null eventListener for " + UISWTViewEvent.getEventDebug(eventType) + " " + Debug.getCompressedStackTrace());
            return eventType == 8;
        }
        try {
            return this.eventListener.eventOccurred(new UISWTViewEventImpl(this, eventType, data));
        }
        catch (Throwable t) {
            throw new UIRuntimeException("UISWTView.triggerEvent:: ViewID=" + this.id + "; EventID=" + eventType + "; data=" + DataSourceUtils.toDebugString(data), t);
        }
    }

    @Override
    public void setTitle(String title) {
        this.setTitleSupport(title);
    }

    protected boolean setTitleSupport(String title) {
        if (title == null) {
            return false;
        }
        String newTitleID = title.startsWith("{") && title.endsWith("}") && title.length() > 2 ? title.substring(1, title.length() - 1) : (title.contains(".") && MessageText.keyExists(title) ? title : "!" + title + "!");
        return this.setTitleIDSupport(newTitleID);
    }

    protected void setTitleID(String titleID) {
        this.setTitleIDSupport(titleID);
    }

    protected boolean setTitleIDSupport(String titleID) {
        if (titleID == null) {
            return false;
        }
        if (titleID.equals(this.titleID)) {
            return false;
        }
        this.titleID = titleID;
        return true;
    }

    protected void refreshTitle() {
    }

    @Override
    public PluginInterface getPluginInterface() {
        return this.eventListenerBuilder == null ? null : this.eventListenerBuilder.getPluginInterface();
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public String getTitleID() {
        return this.titleID;
    }

    @Override
    public String getFullTitle() {
        return MessageText.getString(this.getTitleID());
    }

    @Override
    public void initialize(Composite parent) {
        this.setMasterComposite(parent);
        if (this.iControlType == 0) {
            Layout parentLayout = parent.getLayout();
            if (parentLayout instanceof FormLayout) {
                this.composite = parent;
            } else {
                this.composite = new Composite(parent, 0);
                GridLayout layout = new GridLayout(1, false);
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                this.composite.setLayout((Layout)layout);
                GridData gridData = new GridData(1808);
                this.composite.setLayoutData((Object)gridData);
            }
            Listener showListener = event2 -> {
                TabItem[] selectedControl;
                CTabFolder tabFolder;
                CTabItem selection;
                if (this.composite == null || this.composite.isDisposed()) {
                    return;
                }
                Composite parent1 = this.composite.getParent();
                if (parent1 instanceof CTabFolder ? (selection = (tabFolder = (CTabFolder)parent1).getSelection()) != null && selection.getControl() != this.composite : parent1 instanceof TabFolder && (selectedControl = (tabFolder = (TabFolder)parent1).getSelection()) != null && selectedControl.length == 1 && selectedControl[0].getControl() != this.composite) {
                    return;
                }
                Utils.execSWTThreadLater(0, () -> this.triggerEvent(3, null));
            };
            this.composite.addListener(22, showListener);
            if (parent != this.composite) {
                parent.addListener(22, showListener);
            }
            if (this.composite.isVisible()) {
                boolean visible = true;
                if (parent instanceof CTabFolder || parent instanceof TabFolder) {
                    visible = false;
                }
                if (visible) {
                    this.triggerEvent(3, null);
                }
            }
            if (this.delayInitializeToFirstActivate) {
                return;
            }
            this.swt_triggerInitialize();
        } else if (this.iControlType == 1) {
            this.composite = new Composite(parent, 0x1000000);
            FillLayout layout = new FillLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.composite.setLayout((Layout)layout);
            GridData gridData = new GridData(1808);
            this.composite.setLayoutData((Object)gridData);
            Frame f = SWT_AWT.new_Frame((Composite)this.composite);
            Panel pan = new Panel();
            f.add(pan);
            this.triggerEvent(2, pan);
        } else if (this.iControlType == 257) {
            this.triggerEvent(2, this.getPluginSkinObject());
        }
    }

    private void swt_triggerInitialize() {
        if (this.haveSentInitialize) {
            return;
        }
        if (!this.created) {
            this.triggerBooleanEvent(0, this);
        }
        if (this.composite != null) {
            this.composite.setRedraw(false);
            this.composite.setLayoutDeferred(true);
            this.triggerEvent(2, this.composite);
            if (this.composite.getLayout() instanceof GridLayout) {
                Control[] children = this.composite.getChildren();
                int i = 0;
                while (i < children.length) {
                    Control control = children[i];
                    Object layoutData = control.getLayoutData();
                    if (layoutData == null || !(layoutData instanceof GridData)) {
                        if (layoutData != null) {
                            Logger.log(new LogEvent(LogIDs.PLUGIN, 1, "Plugin View '" + this.id + "' tried to setLayoutData of " + control + " to a " + layoutData.getClass().getName()));
                        }
                        GridData gridData = children.length == 1 ? new GridData(4, 4, true, true) : new GridData();
                        control.setLayoutData((Object)gridData);
                    }
                    ++i;
                }
            }
            this.composite.layout();
            this.composite.setLayoutDeferred(false);
            Utils.relayoutUp(this.composite);
            this.composite.setRedraw(true);
        }
    }

    @Override
    public boolean useCoreDataSource() {
        return this.useCoreDataSource;
    }

    @Override
    public void setUseCoreDataSource(boolean useCoreDataSource) {
        if (this.useCoreDataSource == useCoreDataSource) {
            return;
        }
        this.useCoreDataSource = useCoreDataSource;
        if (this.datasource != null) {
            this.setDatasource(this.datasource);
        }
    }

    @Override
    public PluginUISWTSkinObject getPluginSkinObject() {
        return this.skinObject;
    }

    @Override
    public void setPluginSkinObject(PluginUISWTSkinObject so) {
        this.skinObject = so;
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        UIToolBarEnablerBase[] toolbarEnablers;
        UIToolBarEnablerBase[] uIToolBarEnablerBaseArray = toolbarEnablers = this.getToolbarEnablers();
        int n = toolbarEnablers.length;
        int n2 = 0;
        while (n2 < n) {
            UIPluginViewToolBarListener tbEnabler;
            UIToolBarEnablerBase tbEnablerBase = uIToolBarEnablerBaseArray[n2];
            if (tbEnablerBase instanceof UIPluginViewToolBarListener && (tbEnabler = (UIPluginViewToolBarListener)tbEnablerBase).toolBarItemActivated(item, activationType, datasource)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        UIToolBarEnablerBase[] toolbarEnablers;
        UIToolBarEnablerBase[] uIToolBarEnablerBaseArray = toolbarEnablers = this.getToolbarEnablers();
        int n = toolbarEnablers.length;
        int n2 = 0;
        while (n2 < n) {
            UIToolBarEnablerBase tbEnablerBase = uIToolBarEnablerBaseArray[n2];
            if (tbEnablerBase instanceof UIPluginViewToolBarListener) {
                UIPluginViewToolBarListener tbEnabler = (UIPluginViewToolBarListener)tbEnablerBase;
                tbEnabler.refreshToolBarItems(list);
            }
            ++n2;
        }
    }

    @Override
    public void setToolBarListener(UIPluginViewToolBarListener l) {
        this.addToolbarEnabler(l);
    }

    @Override
    public UIPluginViewToolBarListener getToolBarListener() {
        return this.setToolBarEnablers.size() == 0 ? null : this.setToolBarEnablers.iterator().next();
    }

    public UIToolBarEnablerBase[] getToolbarEnablers() {
        return this.setToolBarEnablers.toArray(new UIToolBarEnablerBase[0]);
    }

    public boolean hasToolbarEnableers() {
        return this.setToolBarEnablers.size() > 0;
    }

    public void addToolbarEnabler(UIToolBarEnablerBase enabler) {
        if (this.setToolBarEnablers.contains(enabler)) {
            return;
        }
        this.setToolBarEnablers.add((UIPluginViewToolBarListener)enabler);
        this.setToolbarVisibility(this.setToolBarEnablers.size() > 0);
    }

    public void removeToolbarEnabler(UIToolBarEnablerBase enabler) {
        this.setToolBarEnablers.remove(enabler);
        this.setToolbarVisibility(this.setToolBarEnablers.size() > 0);
    }

    protected void setToolbarVisibility(boolean visible) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserData(Object key, Object data) {
        UISWTViewImpl uISWTViewImpl = this;
        synchronized (uISWTViewImpl) {
            if (this.user_data == null) {
                this.user_data = new LightHashMap<Object, Object>();
            }
            if (data == null) {
                this.user_data.remove(key);
                if (this.user_data.isEmpty()) {
                    this.user_data = null;
                }
            } else {
                this.user_data.put(key, data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUserData(Object key) {
        UISWTViewImpl uISWTViewImpl = this;
        synchronized (uISWTViewImpl) {
            block4: {
                if (this.user_data != null) break block4;
                return null;
            }
            return this.user_data.get(key);
        }
    }

    @Override
    public void setDestroyOnDeactivate(boolean b) {
        this.destroyOnDeactivate = b;
    }

    @Override
    public boolean isDestroyOnDeactivate() {
        return this.destroyOnDeactivate;
    }

    public boolean isDelayInitializeToFirstActivate() {
        return this.delayInitializeToFirstActivate;
    }

    public void setDelayInitializeToFirstActivate(boolean delayInitializeToFirstActivate) {
        this.delayInitializeToFirstActivate = delayInitializeToFirstActivate;
    }

    protected void setMasterComposite(Composite masterComposite) {
        this.masterComposite = masterComposite;
    }

    @Override
    public SWTSkinObjectContainer buildStandAlone(SWTSkinObjectContainer soParent) {
        SWTSkin skin = this.skin == null ? soParent.getSkin() : this.skin;
        return UISWTViewImpl.buildStandAlone(soParent, skin, this.id, this.getDataSource(), this.getControlType(), this.getEventListenerBuilder());
    }

    public static SWTSkinObjectContainer buildStandAlone(SWTSkinObjectContainer soParent, SWTSkin skin, String id, Object datasource, int controlType, UISWTViewBuilderCore original_builder) {
        Composite parent = soParent.getComposite();
        if (parent == null) {
            return null;
        }
        if (original_builder != null && original_builder.isListenerCloneable()) {
            UISWTViewEventListener event_listener;
            UISWTViewImpl view;
            try {
                UISWTViewBuilderCore builder;
                if (datasource == original_builder.getInitialDataSource()) {
                    builder = original_builder;
                } else {
                    builder = original_builder.cloneBuilder();
                    builder.setInitialDatasource(datasource);
                }
                view = new UISWTViewImpl(builder, false);
                event_listener = view.getEventListener();
            }
            catch (Throwable e) {
                Debug.out(e);
                return null;
            }
            try {
                SWTSkinObjectContainer soContents = (SWTSkinObjectContainer)skin.createSkinObject("MdiIView." + uniqueNumber++, SO_ID_ENTRY_WRAPPER, soParent);
                final Composite viewComposite = soContents.getComposite();
                boolean doGridLayout = true;
                if (controlType == 257) {
                    doGridLayout = false;
                }
                if (doGridLayout) {
                    GridLayout gridLayout = new GridLayout();
                    gridLayout.marginWidth = 0;
                    gridLayout.marginHeight = 0;
                    gridLayout.verticalSpacing = 0;
                    gridLayout.horizontalSpacing = 0;
                    viewComposite.setLayout((Layout)gridLayout);
                    viewComposite.setLayoutData((Object)Utils.getFilledFormData());
                }
                view.setPluginSkinObject(soContents);
                view.initialize(viewComposite);
                viewComposite.setData("com.biglybt.ui.swt.Utils.RELAYOUT_UP_STOP_HERE", (Object)true);
                viewComposite.setData("UISWTView", (Object)view);
                soContents.addListener((skinObject, eventType, params) -> {
                    if (eventType == 8) {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("image", (Image)params);
                        data.put("obfuscateTitle", false);
                        view.triggerEvent(9, data);
                    }
                    return null;
                });
                Composite iviewComposite = view.getComposite();
                if (doGridLayout) {
                    Object existingLayoutData = iviewComposite.getLayoutData();
                    Object existingParentLayoutData = iviewComposite.getParent().getLayoutData();
                    if (existingLayoutData == null || !(existingLayoutData instanceof GridData) && existingParentLayoutData instanceof GridLayout) {
                        GridData gridData = new GridData(1808);
                        iviewComposite.setLayoutData((Object)gridData);
                    }
                }
                parent.layout(true, true);
                final UIUpdater updater = UIUpdaterSWT.getInstance();
                if (updater != null) {
                    updater.addUpdater(new UIUpdatable(){

                        @Override
                        public void updateUI() {
                            if (viewComposite.isDisposed()) {
                                updater.removeUpdater(this);
                            } else {
                                view.triggerEvent(5, null);
                            }
                        }

                        @Override
                        public String getUpdateUIName() {
                            return "StandAlone:" + view.getFullTitle();
                        }
                    });
                    if (event_listener instanceof IViewRequiresPeriodicUpdates) {
                        updater.addPeriodicUpdater(new UIUpdatable(){

                            @Override
                            public void updateUI() {
                                if (viewComposite.isDisposed()) {
                                    updater.removePeriodicUpdater(this);
                                } else {
                                    event_listener.eventOccurred(new UISWTViewEventImpl(view, 256, null));
                                }
                            }

                            @Override
                            public String getUpdateUIName() {
                                return "StandAlone:" + view.getFullTitle();
                            }
                        });
                    }
                }
                soContents.setVisible(true);
                iviewComposite.addDisposeListener(arg0 -> view.closeView());
                return soContents;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        } else {
            Debug.out("Can't buildStandAlone '" + id + "'. Invalid skinref or builder (" + original_builder + ")");
        }
        return null;
    }

    @Override
    public boolean canBuildStandAlone() {
        return this.eventListenerBuilder != null && this.eventListenerBuilder.isListenerCloneable();
    }
}

