/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.plugin.net.buddy.swt;

import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.menus.MenuManager;
import com.biglybt.plugin.net.buddy.BuddyPluginBeta;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.biglybt.ui.mdi.MdiCloseListener;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MdiEntryDropListener;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.plugin.net.buddy.swt.ChatView;
import com.biglybt.ui.swt.plugin.net.buddy.swt.SBC_ChatOverview;
import java.util.Arrays;

public class ChatMDIEntry
implements ViewTitleInfo {
    private final MdiEntry mdi_entry;
    private final BuddyPluginBeta.ChatInstance chat;
    private ChatView view;
    private String drop_outstanding;
    private String last_text;
    private int[] last_colour;
    private final BuddyPluginBeta.ChatAdapter adapter = new BuddyPluginBeta.ChatAdapter(){

        @Override
        public void updated() {
            ChatMDIEntry.this.update();
        }

        @Override
        public void stateChanged(boolean avail) {
            if (ChatMDIEntry.this.chat.isDestroyed()) {
                ChatMDIEntry.this.mdi_entry.closeView();
            }
        }
    };

    public ChatMDIEntry(UIManager _ui_manager, BuddyPluginBeta.ChatInstance _chat, MdiEntry _entry) {
        this.chat = _chat;
        this.mdi_entry = _entry;
        this.setupMdiEntry(_ui_manager);
    }

    private void setupMdiEntry(UIManager ui_manager) {
        this.mdi_entry.setViewTitleInfo(this);
        MdiEntryDropListener drop_listener = new MdiEntryDropListener(){

            @Override
            public boolean mdiEntryDrop(MdiEntry entry, Object payload) {
                String[] derp;
                if (payload instanceof String[] && (derp = (String[])payload).length > 0) {
                    payload = derp[0];
                }
                if (!(payload instanceof String)) {
                    return false;
                }
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                if (mdi != null) {
                    String drop = (String)payload;
                    if (ChatMDIEntry.this.view == null) {
                        ChatMDIEntry.this.drop_outstanding = drop;
                    } else {
                        ChatMDIEntry.this.view.handleDrop(drop);
                    }
                    mdi.showEntry(ChatMDIEntry.this.mdi_entry);
                    return true;
                }
                return false;
            }
        };
        this.mdi_entry.addListener(drop_listener);
        this.mdi_entry.addListener(new MdiCloseListener(){

            @Override
            public void mdiEntryClosed(MdiEntry entry, boolean user) {
                ChatMDIEntry.this.chat.removeListener(ChatMDIEntry.this.adapter);
                ChatMDIEntry.this.chat.destroy();
            }
        });
        String menu_key = "sidebar." + this.mdi_entry.getViewID();
        MenuManager menu_manager = ui_manager.getMenuManager();
        MenuItem menu_item = menu_manager.addMenuItem(menu_key, "iconBar.remove");
        Utils.setMenuItemImage(menu_item, "delete");
        menu_item.setDisposeWithUIDetach("swt");
        menu_item.addListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                ChatMDIEntry.this.chat.remove();
            }
        });
        menu_item = menu_manager.addMenuItem(menu_key, "sep");
        menu_item.setStyle(4);
        this.mdi_entry.setImageLeftID("image.sidebar.chat-overview");
        this.chat.addListener(this.adapter);
    }

    protected void setView(ChatView _view) {
        this.view = _view;
        String drop = this.drop_outstanding;
        if (drop != null) {
            this.drop_outstanding = null;
            this.view.handleDrop(drop);
        }
    }

    private void update() {
        boolean changed;
        String text = (String)this.getTitleInfoProperty(0);
        int[] colour = (int[])this.getTitleInfoProperty(8);
        boolean bl = changed = text != this.last_text && (text == null || this.last_text == null || !text.equals(this.last_text));
        if (!changed) {
            boolean bl2 = changed = colour != this.last_colour && (colour == null || this.last_colour == null || !Arrays.equals(colour, this.last_colour));
        }
        if (changed) {
            this.last_text = text;
            this.last_colour = colour;
            this.mdi_entry.redraw();
        }
        ViewTitleInfoManager.refreshTitleInfo(this.mdi_entry.getViewTitleInfo());
    }

    @Override
    public Object getTitleInfoProperty(int propertyID) {
        switch (propertyID) {
            case 1: {
                return this.chat.getName();
            }
            case 5: {
                return this.chat.getName(true);
            }
            case 8: {
                if (this.chat.getMessageOutstanding() && this.chat.hasUnseenMessageWithNick()) {
                    return SBC_ChatOverview.COLOR_MESSAGE_WITH_NICK;
                }
                return null;
            }
            case 0: {
                if (this.chat.getMessageOutstanding()) {
                    return "*";
                }
                return null;
            }
        }
        return null;
    }
}

