/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.plugin.net.buddy.swt;

import com.biglybt.core.util.Debug;
import com.biglybt.plugin.net.buddy.BuddyPluginBeta;
import com.biglybt.plugin.net.buddy.BuddyPluginUtils;
import com.biglybt.plugin.net.buddy.BuddyPluginViewInterface;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.plugin.net.buddy.swt.ChatMDIEntry;
import com.biglybt.ui.swt.plugin.net.buddy.swt.SBC_ChatOverview;
import java.util.HashMap;
import org.eclipse.swt.widgets.Composite;

public class ChatView
implements UISWTViewCoreEventListener {
    private BuddyPluginBeta.ChatInstance current_chat;
    private BuddyPluginBeta.ChatInstance initialized_chat;
    private BuddyPluginViewInterface.View chat_view;

    private void initialize(Composite _parent_composite) {
        try {
            if (this.current_chat != null) {
                HashMap<String, Object> chat_properties = new HashMap<String, Object>();
                chat_properties.put("swt_comp", _parent_composite);
                chat_properties.put("chat", this.current_chat.getClone());
                this.chat_view = BuddyPluginUtils.buildChatView(chat_properties, new BuddyPluginViewInterface.ViewListener(){

                    @Override
                    public void chatActivated(BuddyPluginBeta.ChatInstance chat) {
                    }
                });
                ChatMDIEntry mdi_entry = (ChatMDIEntry)this.current_chat.getUserData(SBC_ChatOverview.MDI_KEY);
                if (mdi_entry != null) {
                    mdi_entry.setView(this);
                }
            } else {
                Debug.out("No current chat");
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected void handleDrop(String drop) {
        this.chat_view.handleDrop(drop);
    }

    private void viewActivated() {
        if (this.chat_view != null) {
            this.chat_view.activate();
        }
    }

    private void viewDeactivated() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataSourceChanged(Object data) {
        ChatView chatView = this;
        synchronized (chatView) {
            if (data instanceof BuddyPluginBeta.ChatInstance) {
                BuddyPluginBeta.ChatInstance chat;
                this.current_chat = chat = (BuddyPluginBeta.ChatInstance)data;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                break;
            }
            case 7: {
                ChatView chatView = this;
                synchronized (chatView) {
                    if (this.current_chat != null) {
                        this.current_chat.destroy();
                        this.current_chat = null;
                    }
                    break;
                }
            }
            case 2: {
                ChatView chatView = this;
                synchronized (chatView) {
                    if (this.current_chat != null) {
                        try {
                            this.current_chat.getClone();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    } else {
                        this.dataSourceChanged(event2.getView().getInitialDataSource());
                    }
                }
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                this.viewActivated();
                break;
            }
            case 4: {
                this.viewDeactivated();
                break;
            }
        }
        return true;
    }
}

