/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.plugin.net.buddy.swt.columns;

import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.plugin.net.buddy.BuddyPluginBeta;
import com.biglybt.plugin.net.buddy.BuddyPluginUtils;
import java.util.Map;

public class ColumnChatMessageCount
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "chat.msg.count";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnChatMessageCount(TableColumn column) {
        column.setWidth(60);
        column.setAlignment(2);
        column.setRefreshInterval(-2);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        Object dataSource = cell.getDataSource();
        int num = -1;
        if (dataSource instanceof Download) {
            Download dl = (Download)dataSource;
            BuddyPluginBeta beta = BuddyPluginUtils.getBetaPlugin();
            if (beta != null && beta.getEnableAutoDownloadChats()) {
                BuddyPluginBeta.ChatInstance chat = beta.peekChatInstance(dl);
                if (chat != null) {
                    num = chat.getMessageCount(true);
                } else {
                    Number message_count;
                    Map<String, Object> peek_data = beta.peekChat(dl, true);
                    if (peek_data != null && (message_count = (Number)peek_data.get("m")) != null) {
                        num = message_count.intValue();
                    }
                }
            }
        } else {
            BuddyPluginBeta.ChatInstance chat = (BuddyPluginBeta.ChatInstance)cell.getDataSource();
            if (chat != null) {
                num = chat.getMessageCount(true);
            }
        }
        if (!cell.setSortValue(num) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(num == -1 ? "" : (num < 100 ? String.valueOf(num) : "100+"));
    }
}

