/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.progress;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.FrequencyLimitedDispatcher;
import com.biglybt.ui.swt.AZProgressBar;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.progress.IMessage;
import com.biglybt.ui.swt.progress.IProgressReport;
import com.biglybt.ui.swt.progress.IProgressReportConstants;
import com.biglybt.ui.swt.progress.IProgressReporter;
import com.biglybt.ui.swt.progress.IProgressReporterListener;
import com.biglybt.ui.swt.progress.ProgressReporterWindow;
import com.biglybt.ui.swt.progress.ProgressReportingManager;
import com.biglybt.ui.swt.twistie.ITwistieListener;
import com.biglybt.ui.swt.twistie.TwistieSection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ProgressReporterPanel
extends Composite
implements IProgressReportConstants,
IProgressReporterListener {
    private final ProgressReporterWindow window;
    private Color normalColor = null;
    private Color errorColor = null;
    public IProgressReporter pReporter = null;
    private Label imageLabel = null;
    private Label nameLabel = null;
    private Label statusLabel = null;
    private StyledText detailListWidget = null;
    private GridData detailSectionData = null;
    private AZProgressBar pBar = null;
    private Composite progressPanel = null;
    private TwistieSection detailSection = null;
    private int style;
    private Label actionLabel_cancel = null;
    private Label actionLabel_remove = null;
    private Label actionLabel_retry = null;
    private int maxPreferredDetailPanelHeight = 200;
    private int maxPreferredDetailPanelHeight_Standalone = 600;
    private int maxPreferredWidth = 900;
    private String lastStatusError = null;
    FrequencyLimitedDispatcher disp = new FrequencyLimitedDispatcher(AERunnable.create(() -> Utils.execSWTThread(() -> this.resizeContentSupport())), 250);

    public ProgressReporterPanel(ProgressReporterWindow _window, Composite parent, IProgressReporter reporter, int style) {
        super(parent, (style & 0x10) != 0 ? (Utils.isDarkAppearanceNativeWindows() ? 0 : 2048) : 0);
        if (reporter == null) {
            throw new NullPointerException("IProgressReporter can not be null");
        }
        this.window = _window;
        this.pReporter = reporter;
        this.style = style;
        this.normalColor = Utils.isDarkAppearanceNative() ? Colors.blues[9] : Colors.blue;
        this.errorColor = Colors.colorError;
        this.setLayoutData(new GridData(4, 128, true, false));
        GridLayout gLayout = new GridLayout(2, false);
        gLayout.marginWidth = 25;
        gLayout.marginTop = 15;
        gLayout.marginBottom = 10;
        this.setLayout((Layout)gLayout);
        this.createControls(this.pReporter.getProgressReport());
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                ProgressReporterPanel.this.resizeContent();
            }
        });
        this.pReporter.addListener(this);
    }

    @Override
    public int report(IProgressReport pReport) {
        return this.handleEvents(pReport);
    }

    private void createControls(IProgressReport pReport) {
        this.imageLabel = new Label((Composite)this, 0);
        this.imageLabel.setLayoutData((Object)new GridData(1, 128, false, false, 1, 3));
        this.progressPanel = new Composite((Composite)this, 0);
        this.progressPanel.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout rightLayout = new GridLayout(4, false);
        rightLayout.marginHeight = 0;
        rightLayout.marginWidth = 0;
        this.progressPanel.setLayout((Layout)rightLayout);
        this.nameLabel = new Label(this.progressPanel, 64);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        this.nameLabel.setLayoutData((Object)gd);
        this.pBar = new AZProgressBar(this.progressPanel, pReport.isIndeterminate());
        this.pBar.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.actionLabel_cancel = new Label(this.progressPanel, 0);
        this.actionLabel_cancel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.actionLabel_remove = new Label(this.progressPanel, 0);
        this.actionLabel_remove.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.actionLabel_retry = new Label(this.progressPanel, 0);
        this.actionLabel_retry.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.statusLabel = new Label(this.progressPanel, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        this.statusLabel.setLayoutData((Object)gd);
        this.createDetailSection(pReport);
        this.initControls(pReport);
        this.actionLabel_cancel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ProgressReporterPanel.this.pReporter.cancel();
            }
        });
        this.actionLabel_retry.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ProgressReporterPanel.this.pReporter.retry();
            }
        });
        this.actionLabel_remove.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ProgressReportingManager.getInstance().remove(ProgressReporterPanel.this.pReporter);
                ProgressReporterPanel.this.dispose();
            }
        });
    }

    private void initControls(IProgressReport pReport) {
        if (pReport.getImage() != null) {
            this.imageLabel.setImage(pReport.getImage());
        } else {
            this.imageLabel.setImage(this.getDisplay().getSystemImage(2));
        }
        this.nameLabel.setText(this.formatForDisplay(pReport.getName()));
        ImageLoader imageLoader = ImageLoader.getInstance();
        imageLoader.setLabelImage(this.actionLabel_cancel, "progress_cancel");
        imageLoader.setLabelImage(this.actionLabel_remove, "progress_remove");
        imageLoader.setLabelImage(this.actionLabel_retry, "progress_retry");
        Utils.setTT((Control)this.actionLabel_cancel, MessageText.getString("Progress.reporting.action.label.cancel.tooltip"));
        Utils.setTT((Control)this.actionLabel_remove, MessageText.getString("Progress.reporting.action.label.remove.tooltip"));
        Utils.setTT((Control)this.actionLabel_retry, MessageText.getString("Progress.reporting.action.label.retry.tooltip"));
        if (pReport.isInErrorState()) {
            this.updateStatusLabel(MessageText.getString("Progress.reporting.default.error"), true);
        } else if (pReport.isDone()) {
            this.updateStatusLabel(MessageText.getString("Progress.reporting.status.finished"), false);
        } else if (pReport.isCanceled()) {
            this.updateStatusLabel(MessageText.getString("Progress.reporting.status.canceled"), false);
        } else if (pReport.isIndeterminate()) {
            this.updateStatusLabel("\u221e", false);
        } else {
            this.updateStatusLabel(String.valueOf(pReport.getPercentage()) + "%", false);
        }
        this.synchProgressBar(pReport);
        this.synchActionLabels(pReport);
    }

    private void createDetailSection(IProgressReport pReport) {
        Control separator = Utils.createSkinnedLabelSeparator(this, 256);
        separator.setLayoutData((Object)new GridData(4, 128, true, false));
        this.detailSection = new TwistieSection(this, 2);
        this.detailSection.setTitle(MessageText.getString("label.details"));
        Composite sectionContent = this.detailSection.getContent();
        this.detailSectionData = new GridData(4, 4, true, true);
        this.detailSection.setLayoutData(this.detailSectionData);
        GridLayout sectionLayout = new GridLayout();
        sectionLayout.marginHeight = 0;
        sectionLayout.marginWidth = 0;
        sectionContent.setLayout((Layout)sectionLayout);
        this.detailSection.setEnabled(false);
        if ((this.window.getStyle() & 8) != 0 && COConfigurationManager.getBooleanParameter("com.biglybt.ui.swt.progress.details.expanded", false)) {
            this.detailSection.setCollapsed(false);
        }
        this.detailListWidget = new StyledText(sectionContent, 2624);
        this.detailListWidget.setLayoutData((Object)new GridData(4, 4, true, true));
        this.detailListWidget.setEditable(false);
        this.detailListWidget.setIndent(4);
        this.detailListWidget.addListener(1, event2 -> {
            int key = event2.character;
            if (key <= 26 && key > 0) {
                key += 96;
            }
            if (key == 97 && event2.stateMask == SWT.MOD1) {
                event2.doit = false;
                this.detailListWidget.selectAll();
            }
        });
        if (Utils.isDarkAppearanceNativeWindows()) {
            Control sep = Utils.createSkinnedLabelSeparator(this, 256, Colors.getSystemColor((Device)this.detailListWidget.getDisplay(), 19));
            GridData setGD = new GridData(768);
            setGD.horizontalSpan = 2;
            sep.setLayoutData((Object)setGD);
        }
        IMessage[] messages = this.pReporter.getMessageHistory();
        int i = 0;
        while (i < messages.length) {
            if (messages[i].getType() == 4) {
                this.appendToDetail(this.formatForDisplay(messages[i].getValue()), true);
            } else {
                this.appendToDetail(this.formatForDisplay(messages[i].getValue()), false);
            }
            ++i;
        }
        this.resizeDetailSection();
        this.detailSection.addTwistieListener(new ITwistieListener(){

            @Override
            public void isCollapsed(boolean value) {
                if ((ProgressReporterPanel.this.window.getStyle() & 8) != 0) {
                    COConfigurationManager.setParameter("com.biglybt.ui.swt.progress.details.expanded", !value);
                }
                ProgressReporterPanel.this.resizeDetailSection();
                ProgressReporterPanel.this.getParent().layout(true, true);
            }
        });
    }

    private void resizeDetailSection() {
        Point computedSize = this.detailSection.computeSize(-1, -1);
        this.detailSectionData.heightHint = computedSize.y;
        if ((8 & this.style) != 0) {
            if (computedSize.y > this.maxPreferredDetailPanelHeight_Standalone) {
                this.detailSectionData.heightHint = this.maxPreferredDetailPanelHeight_Standalone;
            }
        } else if (computedSize.y > this.maxPreferredDetailPanelHeight) {
            this.detailSectionData.heightHint = this.maxPreferredDetailPanelHeight;
        }
        if (computedSize.x > this.maxPreferredWidth) {
            this.detailSectionData.widthHint = this.maxPreferredWidth;
        }
    }

    public Point computeSize(int hint, int hint2, boolean changed) {
        Point newSize = super.computeSize(hint, hint2, changed);
        if (newSize.x > this.maxPreferredWidth) {
            newSize.x = this.maxPreferredWidth;
        }
        return newSize;
    }

    private int handleEvents(final IProgressReport pReport) {
        if (pReport == null || this.isDisposed() || this.getDisplay() == null) {
            return 0;
        }
        switch (pReport.getReportType()) {
            case 6: {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        boolean changed = false;
                        if (ProgressReporterPanel.this.nameLabel != null && !ProgressReporterPanel.this.nameLabel.isDisposed()) {
                            ProgressReporterPanel.this.nameLabel.setText(ProgressReporterPanel.this.formatForDisplay(pReport.getName()));
                        }
                        if (pReport.isIndeterminate()) {
                            ProgressReporterPanel.this.updateStatusLabel("\u221e", false);
                        } else {
                            ProgressReporterPanel.this.updateStatusLabel(String.valueOf(pReport.getPercentage()) + "%", false);
                        }
                        ProgressReporterPanel.this.appendToDetail(pReport.getMessage(), false);
                        ProgressReporterPanel.this.appendToDetail(pReport.getDetailMessage(), false);
                        ProgressReporterPanel.this.synchProgressBar(pReport);
                        if (changed |= ProgressReporterPanel.this.synchActionLabels(pReport)) {
                            ProgressReporterPanel.this.resizeContent();
                        }
                    }
                });
                break;
            }
            case 1: {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (pReport.getReporter().getCancelCloses()) {
                            ProgressReporterPanel.this.dispose();
                        } else {
                            ProgressReporterPanel.this.synchProgressBar(pReport);
                            ProgressReporterPanel.this.updateStatusLabel(MessageText.getString("Progress.reporting.status.canceled"), false);
                            ProgressReporterPanel.this.appendToDetail(pReport.getMessage(), false);
                            ProgressReporterPanel.this.synchActionLabels(pReport);
                            ProgressReporterPanel.this.resizeContent();
                        }
                    }
                });
                break;
            }
            case 2: {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((ProgressReporterPanel.this.style & 2) != 0) {
                            ProgressReporterPanel.this.dispose();
                        } else {
                            ProgressReporterPanel.this.synchProgressBar(pReport);
                            ProgressReporterPanel.this.updateStatusLabel(MessageText.getString("Progress.reporting.status.finished"), false);
                            ProgressReporterPanel.this.appendToDetail(MessageText.getString("Progress.reporting.status.finished"), false);
                            ProgressReporterPanel.this.synchActionLabels(pReport);
                            ProgressReporterPanel.this.resizeContent();
                        }
                    }
                });
                return 1;
            }
            case 3: {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ProgressReporterPanel.this.pBar != null && !ProgressReporterPanel.this.pBar.isDisposed()) {
                            ProgressReporterPanel.this.pBar.setIndeterminate(pReport.isIndeterminate());
                        }
                    }
                });
                break;
            }
            case 4: {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProgressReporterPanel.this.updateStatusLabel(MessageText.getString("Progress.reporting.default.error"), true);
                        ProgressReporterPanel.this.appendToDetail(pReport.getErrorMessage(), true);
                        ProgressReporterPanel.this.synchActionLabels(pReport);
                        ProgressReporterPanel.this.synchProgressBar(pReport);
                        ProgressReporterPanel.this.resizeContent();
                    }
                });
                break;
            }
            case 5: {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProgressReporterPanel.this.lastStatusError = null;
                        ProgressReporterPanel.this.updateStatusLabel(pReport.getMessage(), false);
                        ProgressReporterPanel.this.appendToDetail(MessageText.getString("Progress.reporting.status.retrying"), false);
                        ProgressReporterPanel.this.synchActionLabels(pReport);
                        ProgressReporterPanel.this.synchProgressBar(pReport);
                        ProgressReporterPanel.this.resizeContent();
                    }
                });
                break;
            }
        }
        return 0;
    }

    private void synchProgressBar(IProgressReport pReport) {
        if (this.pBar == null || this.pBar.isDisposed() || pReport == null) {
            return;
        }
        if (pReport.isInErrorState()) {
            this.pBar.setIndeterminate(false);
            this.pBar.setSelection(pReport.getMinimum());
        } else {
            this.pBar.setIndeterminate(pReport.isIndeterminate());
            if (!pReport.isIndeterminate()) {
                this.pBar.setMinimum(pReport.getMinimum());
                this.pBar.setMaximum(pReport.getMaximum());
            }
            this.pBar.setSelection(pReport.getSelection());
        }
    }

    private void updateStatusLabel(String text, boolean showAsError) {
        if (this.statusLabel == null || this.statusLabel.isDisposed()) {
            return;
        }
        if (showAsError) {
            this.lastStatusError = text;
        }
        if (this.lastStatusError != null) {
            showAsError = true;
            text = this.lastStatusError;
        }
        this.statusLabel.setText(this.formatForDisplay(text));
        if (!showAsError) {
            this.statusLabel.setForeground(this.normalColor);
        } else {
            this.statusLabel.setForeground(this.errorColor);
        }
        this.statusLabel.update();
    }

    private boolean synchActionLabels(IProgressReport pReport) {
        if (this.actionLabel_remove == null || this.actionLabel_cancel == null || this.actionLabel_retry == null || this.actionLabel_remove.isDisposed() || this.actionLabel_cancel.isDisposed() || this.actionLabel_retry.isDisposed()) {
            return false;
        }
        boolean show_remove = false;
        boolean show_retry = false;
        boolean show_cancel = false;
        if (pReport.isDone()) {
            show_remove = true;
        } else if (pReport.isInErrorState()) {
            show_remove = true;
            if (pReport.isRetryAllowed()) {
                show_retry = true;
            }
        } else if (pReport.isCanceled()) {
            show_remove = true;
            if (pReport.isRetryAllowed()) {
                show_retry = true;
            }
        } else {
            show_cancel = true;
        }
        boolean changed = false;
        changed |= this.showActionLabel(this.actionLabel_remove, show_remove);
        changed |= this.showActionLabel(this.actionLabel_retry, show_retry);
        changed |= this.showActionLabel(this.actionLabel_cancel, show_cancel);
        if (show_cancel) {
            boolean ok = pReport.isCancelAllowed();
            if (this.actionLabel_cancel.isEnabled() != ok) {
                this.actionLabel_cancel.setEnabled(ok);
                changed = true;
            }
        }
        return changed;
    }

    private boolean showActionLabel(Label label, boolean showIt) {
        int wh;
        GridData gd = (GridData)label.getLayoutData();
        int n = wh = showIt ? 16 : 0;
        if (gd.widthHint != wh) {
            gd.widthHint = wh;
            return true;
        }
        return false;
    }

    public void resizeContent() {
        if (!this.isDisposed()) {
            this.disp.dispatch();
        }
    }

    private void resizeContentSupport() {
        if (!this.isDisposed()) {
            this.layout(true, true);
        }
    }

    private String formatForDisplay(String string) {
        string = string == null ? "" : string;
        return string.replaceAll("&", "&&");
    }

    public void addTwistieListener(ITwistieListener listener) {
        this.detailSection.addTwistieListener(listener);
    }

    public void removeTwistieListener(ITwistieListener listener) {
        this.detailSection.removeTwistieListener(listener);
    }

    private void appendToDetail(String value, boolean isError) {
        if (value == null || value.length() < 1) {
            return;
        }
        if (this.detailListWidget == null || this.detailListWidget.isDisposed()) {
            return;
        }
        int charCount = this.detailListWidget.getCharCount();
        this.detailListWidget.append(String.valueOf(value) + "\n");
        if (isError) {
            StyleRange style2 = new StyleRange();
            style2.start = charCount;
            style2.length = value.length();
            style2.foreground = this.errorColor;
            this.detailListWidget.setStyleRange(style2);
        }
        this.detailSection.setEnabled(true);
        if (isError) {
            this.detailSection.setCollapsed(false);
            this.detailListWidget.setSelection(this.detailListWidget.getCharCount(), this.detailListWidget.getCharCount());
        }
    }

    public IProgressReporter getProgressReporter() {
        return this.pReporter;
    }

    public int getStyle() {
        return this.style;
    }
}

