/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.progress;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreOperation;
import com.biglybt.core.CoreOperationListener;
import com.biglybt.core.CoreOperationTask;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DelayedEvent;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.ThreadPool;
import com.biglybt.ui.swt.UIExitUtilsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class ProgressWindow {
    private static UIExitUtilsSWT.canCloseListener canCloseListener;
    private static final AtomicInteger window_id_next;
    private static List<ProgressWindow> active_windows;
    private static final ThreadPool<AERunnable> core_op_pool;
    private final int window_id = window_id_next.incrementAndGet();
    private volatile Shell shell;
    private volatile boolean task_complete;
    private final String resource;
    private Image[] spinImages;
    private int curSpinIndex = 0;
    private ProgressBar progress_bar;
    private Label subtask_label;
    private boolean task_paused;

    static {
        window_id_next = new AtomicInteger();
        active_windows = new ArrayList<ProgressWindow>();
        core_op_pool = new ThreadPool("ProgressWindow:coreops", 32, true);
    }

    public static void register(final Core core) {
        canCloseListener = new UIExitUtilsSWT.canCloseListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canClose() {
                boolean[] close_on_idle;
                block8: {
                    String active;
                    Supplier<String> getActiveOps;
                    block7: {
                        try {
                            getActiveOps = () -> {
                                List<CoreOperation> ops = core.getOperations();
                                String active = "";
                                for (CoreOperation op : ops) {
                                    int state;
                                    CoreOperationTask.ProgressCallback cb;
                                    CoreOperationTask task2;
                                    int type;
                                    if (op.isRemoved() || (type = op.getOperationType()) != 6 && type != 7 && type != 4 && type != 2 || (task2 = op.getTask()) == null || (cb = task2.getProgressCallback()) != null && (state = cb.getTaskState()) == 4) continue;
                                    if (active.length() > 128) {
                                        active = String.valueOf(active) + ", ...";
                                        break;
                                    }
                                    active = String.valueOf(active) + (active.isEmpty() ? "" : ", ") + task2.getName();
                                }
                                return active;
                            };
                            active = getActiveOps.get();
                            if (!active.isEmpty()) break block7;
                            return true;
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                            return true;
                        }
                    }
                    String title = MessageText.getString("coreops.active.quit.title");
                    String text = MessageText.getString("coreops.active.quit.text", new String[]{active});
                    MessageBoxShell mb = new MessageBoxShell(title, text, new String[]{MessageText.getString("UpdateWindow.quit"), MessageText.getString("Content.alert.notuploaded.button.abort")}, 1);
                    mb.open(null);
                    close_on_idle = new boolean[1];
                    AEThread2.createAndStartDaemon("opschecker", () -> {
                        long idle_start = -1L;
                        while (true) {
                            try {
                                Thread.sleep(250L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (((String)getActiveOps.get()).isEmpty()) {
                                long now = SystemTime.getMonotonousTime();
                                if (idle_start == -1L) {
                                    idle_start = now;
                                    continue;
                                }
                                if (now - idle_start <= 2500L) continue;
                                boolean[] blArray2 = close_on_idle;
                                synchronized (close_on_idle) {
                                    blArray[0] = true;
                                    // ** MonitorExit[var7_6] (shouldn't be in output)
                                    break;
                                }
                            }
                            idle_start = -1L;
                        }
                        {
                            mb.close();
                            return;
                        }
                    });
                    mb.waitUntilClosed();
                    int result = mb.getResult();
                    if (result != 0) break block8;
                    return true;
                }
                boolean[] blArray = close_on_idle;
                synchronized (close_on_idle) {
                    // ** MonitorExit[var8_9] (shouldn't be in output)
                    return close_on_idle[0];
                }
            }
        };
        UIExitUtilsSWT.addListener(canCloseListener);
        core.addOperationListener(new CoreOperationListener(){

            @Override
            public boolean operationExecuteRequest(final CoreOperation operation) {
                CoreOperationTask task2;
                int type = operation.getOperationType();
                if ((type == 2 || type == 4 || type == 7 || type == 3) && Utils.isThisThreadSWT() && (task2 = operation.getTask()) != null) {
                    if (Utils.getDispatchLoopDepth() > 20 || type == 2 && COConfigurationManager.getBooleanParameter("Suppress File Move Dialog")) {
                        core_op_pool.run(new AERunnable(){

                            @Override
                            public void runSupport() {
                                block6: {
                                    boolean done = true;
                                    try {
                                        done = task2.runOperation(operation);
                                        if (done) break block6;
                                        try {
                                            Thread.sleep(50L);
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                        core_op_pool.run(this);
                                    }
                                    finally {
                                        if (done) {
                                            core.removeOperation(operation);
                                        }
                                    }
                                }
                            }
                        });
                    } else {
                        new ProgressWindow(operation, null);
                    }
                    return true;
                }
                return false;
            }

            @Override
            public void operationAdded(CoreOperation operation) {
            }

            @Override
            public void operationRemoved(CoreOperation operation) {
            }
        });
    }

    public static void unregister() {
        UIExitUtilsSWT.removeListener(canCloseListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProgressWindow(final CoreOperation operation) {
        final RuntimeException[] error = new RuntimeException[1];
        final int op_type = operation.getOperationType();
        int delay = 1000;
        if (op_type == 2) {
            this.resource = "progress.window.msg.filemove";
        } else if (op_type == 4) {
            this.resource = "progress.window.msg.dlexport";
        } else if (op_type == 7) {
            this.resource = "progress.window.msg.dlcopy";
        } else {
            int del;
            this.resource = "progress.window.msg.progress";
            delay = 10;
            CoreOperationTask.ProgressCallback cb = operation.getTask().getProgressCallback();
            if (cb != null && (del = cb.getDelay()) > 10) {
                delay = del;
            }
        }
        new DelayedEvent("ProgWin", delay, new AERunnable(){

            @Override
            public void runSupport() {
                if (!ProgressWindow.this.task_complete) {
                    Utils.execSWTThread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            ProgressWindow progressWindow = ProgressWindow.this;
                            synchronized (progressWindow) {
                                if (!ProgressWindow.this.task_complete) {
                                    CoreOperationTask.ProgressCallback cb;
                                    int style = 2160;
                                    if (op_type == 3 && (cb = operation.getTask().getProgressCallback()) != null) {
                                        int s = cb.getStyle();
                                        if ((s & 1) != 0) {
                                            style &= 0xFFFFFFBF;
                                        }
                                        if ((s & 2) != 0) {
                                            style |= 0x10000;
                                        }
                                        if ((s & 4) != 0) {
                                            style |= 0x80;
                                        }
                                    }
                                    Shell shell = ShellFactory.createMainShell(style);
                                    ProgressWindow.this.showDialog(shell, operation);
                                }
                            }
                        }
                    }, false);
                }
            }
        });
        new AEThread2("ProgressWindow", true){

            @Override
            public void run() {
                block10: {
                    try {
                        CoreOperationTask task2 = operation.getTask();
                        if (task2 == null) {
                            throw new RuntimeException("Task not available");
                        }
                        while (!task2.runOperation(operation)) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    catch (RuntimeException e) {
                        error[0] = e;
                        CoreFactory.getSingleton().removeOperation(operation);
                        Utils.execSWTThread(new Runnable(){

                            @Override
                            public void run() {
                                ProgressWindow.this.destroy();
                            }
                        });
                        break block10;
                    }
                    catch (Throwable e) {
                        try {
                            error[0] = new RuntimeException(e);
                            CoreFactory.getSingleton().removeOperation(operation);
                        }
                        catch (Throwable throwable) {
                            CoreFactory.getSingleton().removeOperation(operation);
                            Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */);
                            throw throwable;
                        }
                        Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */);
                        break block10;
                    }
                    CoreFactory.getSingleton().removeOperation(operation);
                    Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */);
                }
            }
        }.start();
        try {
            Utils.readAndDispatchLoop(() -> this.task_complete);
        }
        catch (Throwable throwable) {
            ProgressWindow del = this;
            synchronized (del) {
                this.task_complete = true;
            }
            try {
                if (this.shell != null && !this.shell.isDisposed()) {
                    this.shell.dispose();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            throw throwable;
        }
        ProgressWindow e = this;
        synchronized (e) {
            this.task_complete = true;
        }
        try {
            if (this.shell != null && !this.shell.isDisposed()) {
                this.shell.dispose();
            }
        }
        catch (Throwable e2) {
            Debug.printStackTrace(e2);
        }
        if (error[0] != null) {
            throw error[0];
        }
    }

    public ProgressWindow(Shell _parent, String _resource, int _style, int _delay_millis) {
        this.resource = _resource;
        final Shell shell = new Shell(_parent, _style);
        if (_delay_millis <= 0) {
            this.showDialog(shell, null);
        } else {
            new DelayedEvent("ProgWin", _delay_millis, new AERunnable(){

                @Override
                public void runSupport() {
                    if (!ProgressWindow.this.task_complete) {
                        Utils.execSWTThread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                ProgressWindow progressWindow = ProgressWindow.this;
                                synchronized (progressWindow) {
                                    if (!ProgressWindow.this.task_complete) {
                                        ProgressWindow.this.showDialog(shell, null);
                                    }
                                }
                            }
                        }, false);
                    }
                }
            });
        }
    }

    private Shell getShell() {
        return this.shell;
    }

    protected void showDialog(Shell _shell, CoreOperation _core_op) {
        String name;
        boolean closeable;
        this.shell = _shell;
        if (this.shell == null || this.shell.isDisposed()) {
            return;
        }
        this.shell.setText(MessageText.getString("progress.window.title"));
        CoreOperationTask task2 = _core_op == null ? null : _core_op.getTask();
        final CoreOperationTask.ProgressCallback progress = task2 == null ? null : task2.getProgressCallback();
        boolean bl = closeable = (this.shell.getStyle() & 0x40) != 0;
        if (progress != null) {
            int s = progress.getStyle();
            if ((s & 1) != 0) {
                closeable = false;
            }
            if ((s & 4) != 0) {
                this.shell.addShellListener((ShellListener)new ShellAdapter(){

                    public void shellIconified(ShellEvent e) {
                        progress.setTaskState(32);
                        e.doit = false;
                    }
                });
            }
        }
        boolean alreadyPositioned = Utils.linkShellMetricsToConfig(this.shell, "com.biglybt.ui.swt.progress.ProgressWindow." + _core_op.getOperationType());
        Utils.setShellIcon(this.shell);
        if (!closeable) {
            this.shell.addListener(21, ev -> {
                ev.doit = false;
            });
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.shell.setLayout((Layout)layout);
        Color bg = Utils.isDarkAppearanceNative() || Utils.isDarkAppearancePartial() ? null : Colors.white;
        this.shell.setBackground(bg);
        if (task2 != null && (name = task2.getName()) != null) {
            Label lName = new Label((Composite)this.shell, 0);
            FontData fontData = lName.getFont().getFontData()[0];
            final Font bold_font = new Font((Device)this.shell.getDisplay(), new FontData(fontData.getName(), fontData.getHeight(), 1));
            lName.setText(name);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            lName.setLayoutData((Object)gridData);
            lName.setBackground(bg);
            lName.setFont(bold_font);
            lName.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent arg0) {
                    bold_font.dispose();
                }
            });
            if (progress != null && (progress.getSupportedTaskStates() & 8) != 0) {
                this.subtask_label = new Label((Composite)this.shell, 0);
                gridData = new GridData(768);
                gridData.horizontalSpan = 2;
                gridData.horizontalIndent = 25;
                this.subtask_label.setLayoutData((Object)gridData);
                this.subtask_label.setBackground(bg);
            }
        }
        this.spinImages = ImageLoader.getInstance().getImages("working");
        if (this.spinImages == null || this.spinImages.length == 0) {
            new Label((Composite)this.shell, 0);
        } else {
            final Rectangle spinBounds = this.spinImages[0].getBounds();
            final Canvas canvas = new Canvas((Composite)this.shell, 0x20000000){

                public Point computeSize(int wHint, int hHint, boolean changed) {
                    return new Point(spinBounds.width, spinBounds.height);
                }
            };
            canvas.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.drawImage(ProgressWindow.this.spinImages[ProgressWindow.this.curSpinIndex], 0, 0);
                }
            });
            Utils.execSWTThreadLater(100, new AERunnable(){

                @Override
                public void runSupport() {
                    if (canvas == null || canvas.isDisposed()) {
                        return;
                    }
                    canvas.redraw();
                    if (ProgressWindow.this.curSpinIndex == ProgressWindow.this.spinImages.length - 1) {
                        ProgressWindow.this.curSpinIndex = 0;
                    } else {
                        ProgressWindow progressWindow = ProgressWindow.this;
                        progressWindow.curSpinIndex = progressWindow.curSpinIndex + 1;
                    }
                    if (progress != null && ProgressWindow.this.progress_bar != null) {
                        if (ProgressWindow.this.progress_bar.isDisposed()) {
                            return;
                        }
                        int p = progress.getProgress();
                        ProgressWindow.this.progress_bar.setSelection(p);
                        if (ProgressWindow.this.subtask_label != null) {
                            String st = progress.getSubTaskName();
                            if (st == null) {
                                st = "";
                            }
                            ProgressWindow.this.subtask_label.setText(st);
                        }
                    }
                    Utils.execSWTThreadLater(100, this);
                }
            });
            canvas.setBackground(bg);
        }
        Label label = new Label((Composite)this.shell, 0);
        label.setText(MessageText.getString(this.resource));
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setBackground(bg);
        if (progress != null) {
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 2;
            Composite compProg = Utils.createSkinnedComposite((Composite)this.shell, 2048, gridData);
            GridLayout layoutProgress = new GridLayout();
            layoutProgress.numColumns = 1;
            layoutProgress.marginHeight = 0;
            layoutProgress.marginWidth = 0;
            compProg.setLayout((Layout)layoutProgress);
            compProg.setBackground(bg);
            this.progress_bar = new ProgressBar(compProg, 256);
            this.progress_bar.setMinimum(0);
            this.progress_bar.setMaximum(1000);
            this.progress_bar.setBackground(bg);
            gridData = new GridData(768);
            gridData.widthHint = 400;
            this.progress_bar.setLayoutData((Object)gridData);
            int states = progress.getSupportedTaskStates();
            if ((states & 7) != 0) {
                Button bCancel;
                Button bResume;
                Button bPause;
                boolean has_cancel;
                Control labelSeparator = Utils.createSkinnedLabelSeparator((Composite)this.shell, 256);
                gridData = new GridData(768);
                gridData.horizontalSpan = 2;
                labelSeparator.setLayoutData((Object)gridData);
                final boolean has_pause_resume = (states & 3) != 0;
                boolean bl2 = has_cancel = (states & 4) != 0;
                if (!has_pause_resume) {
                    has_cancel = true;
                }
                int num_buttons = 0;
                if (has_pause_resume) {
                    num_buttons += 2;
                }
                if (has_cancel) {
                    ++num_buttons;
                }
                final Composite comp2 = new Composite((Composite)this.shell, 0);
                gridData = new GridData(896);
                gridData.grabExcessHorizontalSpace = true;
                gridData.horizontalSpan = 2;
                comp2.setLayoutData((Object)gridData);
                GridLayout layoutButtons = new GridLayout();
                layoutButtons.numColumns = num_buttons;
                comp2.setLayout((Layout)layoutButtons);
                comp2.setBackground(bg);
                ArrayList<Button> buttons = new ArrayList<Button>();
                if (has_pause_resume) {
                    bPause = new Button(comp2, 8);
                    bPause.setText(MessageText.getString("v3.MainWindow.button.pause"));
                    gridData = new GridData(896);
                    gridData.grabExcessHorizontalSpace = true;
                    bPause.setLayoutData((Object)gridData);
                    buttons.add(bPause);
                    bResume = new Button(comp2, 8);
                    bResume.setText(MessageText.getString("v3.MainWindow.button.resume"));
                    gridData = new GridData(896);
                    gridData.grabExcessHorizontalSpace = false;
                    bResume.setLayoutData((Object)gridData);
                    buttons.add(bResume);
                } else {
                    bPause = null;
                    bResume = null;
                }
                if (has_cancel) {
                    bCancel = new Button(comp2, 8);
                    bCancel.setText(MessageText.getString("UpdateWindow.cancel"));
                    gridData = new GridData(128);
                    gridData.grabExcessHorizontalSpace = false;
                    bCancel.setLayoutData((Object)gridData);
                    buttons.add(bCancel);
                } else {
                    bCancel = null;
                }
                Utils.makeButtonsEqualWidth(buttons);
                if (has_pause_resume) {
                    bResume.setEnabled(false);
                    bPause.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            ProgressWindow.this.task_paused = true;
                            bPause.setEnabled(false);
                            bResume.setEnabled(true);
                            ProgressWindow.this.shell.setDefaultButton(bResume);
                            progress.setTaskState(1);
                        }
                    });
                    bResume.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            ProgressWindow.this.task_paused = false;
                            bPause.setEnabled(true);
                            bResume.setEnabled(false);
                            ProgressWindow.this.shell.setDefaultButton(bPause);
                            progress.setTaskState(2);
                        }
                    });
                }
                if (bCancel != null) {
                    bCancel.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            if (has_pause_resume) {
                                bPause.setEnabled(false);
                                bResume.setEnabled(false);
                            }
                            bCancel.setEnabled(false);
                            progress.setTaskState(4);
                        }
                    });
                }
                Utils.execSWTThreadLater(250, new Runnable(){

                    @Override
                    public void run() {
                        if (comp2.isDisposed()) {
                            return;
                        }
                        int state = progress.getTaskState();
                        if (state == 4) {
                            ProgressWindow.this.shell.dispose();
                        } else {
                            if (has_pause_resume) {
                                if (state == 1) {
                                    bPause.setEnabled(false);
                                    bResume.setEnabled(true);
                                } else {
                                    bPause.setEnabled(true);
                                    bResume.setEnabled(false);
                                }
                            }
                            Utils.execSWTThreadLater(250, this);
                        }
                    }
                });
                this.shell.setDefaultButton(has_pause_resume ? bPause : bCancel);
                this.shell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent arg0) {
                        if (ProgressWindow.this.task_paused) {
                            progress.setTaskState(2);
                        }
                    }
                });
            }
        }
        this.shell.pack();
        if (!alreadyPositioned) {
            Composite parent = this.shell.getParent();
            if (parent != null) {
                Utils.centerWindowRelativeTo(this.shell, (Control)parent);
            } else {
                Utils.centreWindow(this.shell);
            }
        }
        ProgressWindow moveBelow = null;
        for (ProgressWindow window : active_windows) {
            if (moveBelow != null && moveBelow.window_id >= window.window_id) continue;
            moveBelow = window;
        }
        active_windows.add(this);
        this.shell.addListener(12, ev -> active_windows.remove(this));
        if (moveBelow == null) {
            this.shell.open();
        } else {
            this.shell.moveBelow((Control)moveBelow.getShell());
            this.shell.setVisible(true);
        }
        int num_active_windows = active_windows.size();
        if (num_active_windows > 1) {
            int max_x = Integer.MIN_VALUE;
            int max_y = Integer.MIN_VALUE;
            for (ProgressWindow window : active_windows) {
                Rectangle rect = window.getShell().getBounds();
                max_x = Math.max(max_x, rect.x);
                max_y = Math.max(max_y, rect.y);
            }
            if (max_x > Integer.MIN_VALUE) {
                Rectangle rect = this.shell.getBounds();
                rect.x = max_x + 16;
                rect.y = max_y + 16;
                try {
                    Utils.setShellMetricsConfigEnabled(this.shell, false);
                    this.shell.setBounds(rect);
                }
                finally {
                    Utils.setShellMetricsConfigEnabled(this.shell, true);
                }
            }
        }
        Utils.verifyShellRect(this.shell, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ProgressWindow progressWindow = this;
        synchronized (progressWindow) {
            this.task_complete = true;
        }
        try {
            if (this.shell != null && !this.shell.isDisposed()) {
                this.shell.dispose();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        if (this.spinImages != null) {
            ImageLoader.getInstance().releaseImage("working");
            this.spinImages = null;
        }
    }

    /* synthetic */ ProgressWindow(CoreOperation coreOperation, ProgressWindow progressWindow) {
        this(coreOperation);
    }
}

