/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.search;

import com.biglybt.core.metasearch.Engine;
import com.biglybt.core.metasearch.Result;
import com.biglybt.core.subs.util.SearchSubsResultBase;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.LightHashMap;
import com.biglybt.ui.swt.search.SBC_SearchResultsView;
import java.util.Date;

public class SBC_SearchResult
implements SearchSubsResultBase {
    private final SBC_SearchResultsView view;
    private final Engine engine;
    private final Result result;
    private final int content_type;
    private final String seeds_peers;
    private final long seeds_peers_sort;
    private final int seed_count;
    private final int peer_count;
    private final int completed_count;
    private final long votes_comments_sort;
    private final String votes_comments;
    private LightHashMap<Object, Object> user_data;

    public SBC_SearchResult(SBC_SearchResultsView _view, Engine _engine, Result _result) {
        char c;
        this.view = _view;
        this.engine = _engine;
        this.result = _result;
        String type = this.result.getContentType();
        this.content_type = type == null || type.length() == 0 ? 0 : ((c = type.charAt(0)) == 'v' ? 1 : (c == 'a' ? 2 : (c == 'g' ? 3 : 0)));
        int seeds = this.result.getNbSeeds();
        int leechers = this.result.getNbPeers();
        int super_seeds = this.result.getNbSuperSeeds();
        if (super_seeds > 0) {
            seeds += super_seeds * 10;
        }
        this.seed_count = seeds < 0 ? 0 : seeds;
        this.peer_count = leechers < 0 ? 0 : leechers;
        this.seeds_peers = String.valueOf(seeds < 0 ? "--" : String.valueOf(seeds)) + "/" + (leechers < 0 ? "--" : String.valueOf(leechers));
        seeds = seeds < 0 ? 0 : ++seeds;
        leechers = leechers < 0 ? 0 : ++leechers;
        this.seeds_peers_sort = (seeds & Integer.MAX_VALUE) << 32 | leechers & 0xFFFFFFFF;
        this.completed_count = this.result.getNbCompleted();
        long votes = this.result.getVotes();
        long comments = this.result.getComments();
        if (votes < 0L && comments < 0L) {
            this.votes_comments_sort = 0L;
            this.votes_comments = null;
        } else {
            this.votes_comments = String.valueOf(votes < 0L ? "--" : String.valueOf(votes)) + "/" + (comments < 0L ? "--" : String.valueOf(comments));
            votes = votes < 0L ? 0L : ++votes;
            comments = comments < 0L ? 0L : ++comments;
            this.votes_comments_sort = (votes & Integer.MAX_VALUE) << 32 | comments & 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public Engine getEngine() {
        return this.engine;
    }

    @Override
    public String getID() {
        return this.result.getUID();
    }

    @Override
    public final String getName() {
        return this.result.getName();
    }

    @Override
    public byte[] getHash() {
        String base32_hash = this.result.getHash();
        if (base32_hash != null) {
            return Base32.decode(base32_hash);
        }
        return null;
    }

    @Override
    public int getContentType() {
        return this.content_type;
    }

    @Override
    public long getSize() {
        return this.result.getSize();
    }

    @Override
    public int getNbSeeds() {
        return this.seed_count;
    }

    @Override
    public int getNbPeers() {
        return this.peer_count;
    }

    @Override
    public String getSeedsPeers() {
        return this.seeds_peers;
    }

    @Override
    public long getSeedsPeersSortValue() {
        return this.seeds_peers_sort;
    }

    @Override
    public int getNbCompleted() {
        return this.completed_count;
    }

    @Override
    public String getVotesComments() {
        return this.votes_comments;
    }

    @Override
    public long getVotesCommentsSortValue() {
        return this.votes_comments_sort;
    }

    @Override
    public int getRank() {
        float rank = this.result.getRank();
        return (int)(rank * 100.0f);
    }

    @Override
    public String getTorrentLink() {
        String r = this.result.getTorrentLink();
        if (r == null) {
            r = this.result.getDownloadLink();
        }
        return r;
    }

    @Override
    public String getDetailsLink() {
        return this.result.getCDPLink();
    }

    @Override
    public String getCategory() {
        return this.result.getCategory();
    }

    @Override
    public String[] getTags() {
        return this.result.getTags();
    }

    @Override
    public String getDescription() {
        return this.result.getDescription();
    }

    @Override
    public long getTime() {
        return this.result.getTime();
    }

    @Override
    public long getAssetDate() {
        Date d = this.result.getAssetDate();
        return d == null ? 0L : d.getTime();
    }

    public void getIcon(SBC_SearchResultsView.ImageLoadListener listener) {
        this.view.getIcon(this.engine, img -> {
            try {
                listener.imageLoaded(img);
            }
            finally {
                this.view.invalidate(this);
            }
        });
    }

    @Override
    public boolean getRead() {
        return false;
    }

    @Override
    public void setRead(boolean read) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserData(Object key, Object data) {
        SBC_SearchResult sBC_SearchResult = this;
        synchronized (sBC_SearchResult) {
            if (this.user_data == null) {
                this.user_data = new LightHashMap();
            }
            this.user_data.put(key, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUserData(Object key) {
        SBC_SearchResult sBC_SearchResult = this;
        synchronized (sBC_SearchResult) {
            block4: {
                if (this.user_data != null) break block4;
                return null;
            }
            return this.user_data.get(key);
        }
    }
}

