/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.search;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.metasearch.Engine;
import com.biglybt.core.metasearch.MetaSearchListener;
import com.biglybt.core.metasearch.MetaSearchManager;
import com.biglybt.core.metasearch.MetaSearchManagerFactory;
import com.biglybt.core.metasearch.Result;
import com.biglybt.core.metasearch.ResultListener;
import com.biglybt.core.metasearch.SearchParameter;
import com.biglybt.core.metasearch.impl.web.WebEngine;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.util.SearchSubsResultBase;
import com.biglybt.core.subs.util.SubscriptionResultFilterable;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.CopyOnWriteSet;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FrequencyLimitedDispatcher;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.versioncheck.VersionCheckClient;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnCreationListener;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.common.RememberedDecisionsManager;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableSelectionListener;
import com.biglybt.ui.common.table.TableViewFilterCheck;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.selectedcontent.DownloadUrlInfo;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.columns.search.ColumnSearchResultSite;
import com.biglybt.ui.swt.columns.searchsubs.ColumnSearchSubResultActions;
import com.biglybt.ui.swt.columns.searchsubs.ColumnSearchSubResultAge;
import com.biglybt.ui.swt.columns.searchsubs.ColumnSearchSubResultCategory;
import com.biglybt.ui.swt.columns.searchsubs.ColumnSearchSubResultExisting;
import com.biglybt.ui.swt.columns.searchsubs.ColumnSearchSubResultGrabbed;
import com.biglybt.ui.swt.columns.searchsubs.ColumnSearchSubResultHash;
import com.biglybt.ui.swt.columns.searchsubs.ColumnSearchSubResultName;
import com.biglybt.ui.swt.columns.searchsubs.ColumnSearchSubResultPeers;
import com.biglybt.ui.swt.columns.searchsubs.ColumnSearchSubResultRank;
import com.biglybt.ui.swt.columns.searchsubs.ColumnSearchSubResultRatings;
import com.biglybt.ui.swt.columns.searchsubs.ColumnSearchSubResultSeeds;
import com.biglybt.ui.swt.columns.searchsubs.ColumnSearchSubResultSeedsPeers;
import com.biglybt.ui.swt.columns.searchsubs.ColumnSearchSubResultSize;
import com.biglybt.ui.swt.columns.searchsubs.ColumnSearchSubResultType;
import com.biglybt.ui.swt.components.BubbleTextBox;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.search.SBC_SearchResult;
import com.biglybt.ui.swt.search.SearchResultsTabArea;
import com.biglybt.ui.swt.search.SearchResultsTabAreaBase;
import com.biglybt.ui.swt.search.SearchUtils;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinCheckboxListener;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectCheckbox;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinObjectText;
import com.biglybt.ui.swt.skin.SWTSkinObjectTextbox;
import com.biglybt.ui.swt.skin.SWTSkinObjectToggle;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import com.biglybt.ui.swt.skin.SWTSkinToggleListener;
import com.biglybt.ui.swt.utils.SearchSubsUtils;
import com.biglybt.ui.swt.views.skin.VuzeMessageBox;
import com.biglybt.ui.swt.views.skin.VuzeMessageBoxListener;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.TableViewSWTMenuFillListener;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import com.biglybt.ui.swt.views.table.utils.TableColumnFilterHelper;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SBC_SearchResultsView
implements SearchResultsTabAreaBase,
TableViewFilterCheck<SBC_SearchResult>,
MetaSearchListener {
    public static final String TABLE_SR = "SearchResults";
    private static boolean columnsAdded = false;
    private static Image[] vitality_images;
    private static Image ok_image;
    private static Image fail_image;
    private static Image auth_image;
    private SearchResultsTabArea parent;
    private TableViewSWT<SBC_SearchResult> tv_subs_results;
    private TableColumnFilterHelper<SBC_SearchResult> col_filter_helper;
    private Composite table_parent;
    private final Object filter_lock = new Object();
    private Spinner spinMinSize;
    private Spinner spinMaxSize;
    private Text textWithKW;
    private Text textWithoutKW;
    private int minSize;
    private int maxSize;
    private String[] with_keywords = new String[0];
    private String[] without_keywords = new String[0];
    private FrequencyLimitedDispatcher refilter_dispatcher = new FrequencyLimitedDispatcher(new AERunnable(){

        @Override
        public void runSupport() {
            SBC_SearchResultsView.this.refilter();
        }
    }, 250);
    private final CopyOnWriteSet<String> deselected_engines = new CopyOnWriteSet(false);
    private Composite engine_area;
    private List<SBC_SearchResult> last_selected_content = new ArrayList<SBC_SearchResult>();
    private Object search_lock = new Object();
    private SearchInstance current_search;
    private List<String> loadedImageIDs = new ArrayList<String>();

    protected SBC_SearchResultsView(SearchResultsTabArea _parent) {
        this.parent = _parent;
    }

    private SWTSkinObject getSkinObject(String viewID) {
        return this.parent.getSkinObject(viewID);
    }

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        SWTSkinObject soFilterArea;
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                SBC_SearchResultsView.this.initColumns(core);
            }
        });
        if (vitality_images == null) {
            ImageLoader loader = ImageLoader.getInstance();
            vitality_images = loader.getImages("image.sidebar.vitality.dots");
            ok_image = loader.getImage("tick_mark");
            fail_image = loader.getImage("progress_cancel");
            auth_image = loader.getImage("image.sidebar.vitality.auth");
        }
        if ((soFilterArea = this.getSkinObject("filterarea")) != null) {
            Label label;
            SWTSkinObjectToggle soFilterButton = (SWTSkinObjectToggle)this.getSkinObject("filter-button");
            if (soFilterButton != null) {
                boolean toggled = COConfigurationManager.getBooleanParameter("Search View Filter Options Expanded", false);
                if (toggled) {
                    soFilterButton.setToggled(true);
                    soFilterArea.setVisible(true);
                }
                soFilterButton.addSelectionListener(new SWTSkinToggleListener(){

                    @Override
                    public void toggleChanged(SWTSkinObjectToggle so, boolean toggled) {
                        COConfigurationManager.setParameter("Search View Filter Options Expanded", toggled);
                        soFilterArea.setVisible(toggled);
                        Utils.relayout((Control)soFilterArea.getControl().getParent());
                    }
                });
            }
            Composite parent = (Composite)soFilterArea.getControl();
            Composite filter_area = new Composite(parent, 0);
            FormData fd = Utils.getFilledFormData();
            filter_area.setLayoutData((Object)fd);
            GridLayout layout = new GridLayout();
            layout.marginRight = 0;
            layout.marginLeft = 0;
            layout.marginTop = 0;
            layout.marginBottom = 0;
            filter_area.setLayout((Layout)layout);
            int sepHeight = 20;
            Composite cRow = new Composite(filter_area, 0);
            cRow.setLayoutData((Object)new GridData(768));
            RowLayout rowLayout = new RowLayout(256);
            rowLayout.spacing = 5;
            rowLayout.marginRight = 0;
            rowLayout.marginLeft = 0;
            rowLayout.marginTop = 0;
            rowLayout.marginBottom = 0;
            rowLayout.center = true;
            cRow.setLayout((Layout)rowLayout);
            ImageLoader imageLoader = ImageLoader.getInstance();
            int i = 0;
            while (i < 2) {
                boolean with;
                boolean bl = with = i == 0;
                if (!with) {
                    label = new Label(cRow, 514);
                    label.setLayoutData((Object)new RowData(-1, sepHeight));
                }
                Composite cWithKW = new Composite(cRow, 0);
                layout = new GridLayout(2, false);
                layout.marginWidth = 0;
                layout.marginRight = 0;
                layout.marginLeft = 0;
                layout.marginTop = 0;
                layout.marginBottom = 0;
                cWithKW.setLayout((Layout)layout);
                Label lblWithKWImg = new Label(cWithKW, 0);
                lblWithKWImg.setImage(imageLoader.getImage(with ? "icon_filter_plus" : "icon_filter_minus"));
                final Text textWidget = new Text(cWithKW, 2048);
                if (with) {
                    this.textWithKW = textWidget;
                } else {
                    this.textWithoutKW = textWidget;
                }
                textWidget.setMessage(MessageText.getString(with ? "SubscriptionResults.filter.with.words" : "SubscriptionResults.filter.without.words"));
                GridData gd = new GridData();
                gd.widthHint = 100;
                textWidget.setLayoutData((Object)gd);
                textWidget.addModifyListener(new ModifyListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void modifyText(ModifyEvent e) {
                        String text = textWidget.getText().toLowerCase(Locale.US);
                        String[] bits = text.split("\\s+");
                        HashSet<String> temp = new HashSet<String>();
                        String[] stringArray = bits;
                        int n = bits.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String bit = stringArray[n2];
                            if ((bit = bit.trim()).length() > 0) {
                                temp.add(bit);
                            }
                            ++n2;
                        }
                        String[] words = temp.toArray(new String[temp.size()]);
                        Object object = SBC_SearchResultsView.this.filter_lock;
                        synchronized (object) {
                            if (with) {
                                SBC_SearchResultsView.this.with_keywords = words;
                            } else {
                                SBC_SearchResultsView.this.without_keywords = words;
                            }
                        }
                        SBC_SearchResultsView.this.refilter_dispatcher.dispatch();
                    }
                });
                ++i;
            }
            int kinb = DisplayFormatters.getKinB();
            label = new Label(cRow, 514);
            label.setLayoutData((Object)new RowData(-1, sepHeight));
            Composite cMinSize = new Composite(cRow, 0);
            layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginRight = 0;
            layout.marginLeft = 0;
            layout.marginTop = 0;
            layout.marginBottom = 0;
            cMinSize.setLayout((Layout)layout);
            Label lblMinSize = new Label(cMinSize, 0);
            lblMinSize.setText(MessageText.getString("SubscriptionResults.filter.min_size"));
            this.spinMinSize = new Spinner(cMinSize, 2048);
            this.spinMinSize.setMinimum(0);
            this.spinMinSize.setMaximum(100 * kinb * kinb);
            this.spinMinSize.setSelection(this.minSize);
            this.spinMinSize.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    SBC_SearchResultsView.this.minSize = ((Spinner)event2.widget).getSelection();
                    SBC_SearchResultsView.this.refilter();
                }
            });
            label = new Label(cRow, 514);
            label.setLayoutData((Object)new RowData(-1, sepHeight));
            Composite cMaxSize = new Composite(cRow, 0);
            layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginRight = 0;
            layout.marginLeft = 0;
            layout.marginTop = 0;
            layout.marginBottom = 0;
            cMaxSize.setLayout((Layout)layout);
            Label lblMaxSize = new Label(cMaxSize, 0);
            lblMaxSize.setText(MessageText.getString("SubscriptionResults.filter.max_size"));
            this.spinMaxSize = new Spinner(cMaxSize, 2048);
            this.spinMaxSize.setMinimum(0);
            this.spinMaxSize.setMaximum(100 * kinb * kinb);
            this.spinMaxSize.setSelection(this.maxSize);
            this.spinMaxSize.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    SBC_SearchResultsView.this.maxSize = ((Spinner)event2.widget).getSelection();
                    SBC_SearchResultsView.this.refilter();
                }
            });
            this.engine_area = new Composite(filter_area, 0);
            this.engine_area.setLayoutData((Object)new GridData(768));
            this.buildEngineArea(null);
            parent.layout(true);
        }
        return null;
    }

    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        ImageLoader instance = ImageLoader.getInstance();
        for (String loadedImageID : this.loadedImageIDs) {
            instance.releaseImage(loadedImageID);
        }
        this.loadedImageIDs.clear();
        return null;
    }

    private void buildEngineArea(final SearchInstance search) {
        if (this.engine_area.isDisposed()) {
            return;
        }
        final Engine[] engines = search == null ? new Engine[]{} : search.getEngines();
        Utils.disposeComposite(this.engine_area, false);
        Arrays.sort(engines, new Comparator<Engine>(){

            @Override
            public int compare(Engine o1, Engine o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.spacing = 3;
        rowLayout.marginRight = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        rowLayout.pack = false;
        this.engine_area.setLayout((Layout)rowLayout);
        final Composite label_comp = new Composite(this.engine_area, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 1;
        layout.marginLeft = 1;
        layout.marginTop = 1;
        layout.marginBottom = 1;
        label_comp.setLayout((Layout)layout);
        Label label = new Label(label_comp, 0);
        Messages.setLanguageText((Widget)label, "label.show.results.from");
        GridData grid_data = new GridData(16384, 0x1000000, true, true);
        label.setLayoutData((Object)grid_data);
        final ArrayList<Button> buttons = new ArrayList<Button>();
        final ArrayList<Label> result_counts = new ArrayList<Label>();
        final ArrayList<ImageLabel> indicators = new ArrayList<ImageLabel>();
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SBC_SearchResultsView.this.deselected_engines.clear();
                for (Button b : buttons) {
                    b.setSelection(true);
                }
                SBC_SearchResultsView.this.refilter();
            }
        });
        Engine[] engineArray = engines;
        int n = engines.length;
        int n2 = 0;
        while (n2 < n) {
            final Engine engine = engineArray[n2];
            final Composite engine_comp = new Composite(this.engine_area, 0);
            layout = new GridLayout(3, false);
            layout.marginRight = 1;
            layout.marginLeft = 1;
            layout.marginTop = 1;
            layout.marginBottom = 1;
            engine_comp.setLayout((Layout)layout);
            engine_comp.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    GC gc = e.gc;
                    gc.setForeground(Colors.grey);
                    Point size = engine_comp.getSize();
                    gc.drawRectangle(new Rectangle(0, 0, size.x - 1, size.y - 1));
                }
            });
            final Button button = new Button(engine_comp, 32);
            button.setData((Object)engine);
            buttons.add(button);
            button.setText(engine.getName());
            button.setSelection(!this.deselected_engines.contains(engine.getUID()));
            this.getIcon(engine, new ImageLoadListener(){

                @Override
                public void imageLoaded(Image image) {
                    button.setImage(image);
                }
            });
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String id = engine.getUID();
                    if (button.getSelection()) {
                        SBC_SearchResultsView.this.deselected_engines.remove(id);
                    } else {
                        SBC_SearchResultsView.this.deselected_engines.add(id);
                    }
                    SBC_SearchResultsView.this.refilter();
                }
            });
            Menu menu = new Menu((Control)button);
            button.setMenu(menu);
            MenuItem mi = new MenuItem(menu, 8);
            mi.setText(MessageText.getString("label.this.site.only"));
            mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SBC_SearchResultsView.this.deselected_engines.clear();
                    button.setSelection(true);
                    for (Button b : buttons) {
                        if (b == button) continue;
                        b.setSelection(false);
                        SBC_SearchResultsView.this.deselected_engines.add(((Engine)b.getData()).getUID());
                    }
                    SBC_SearchResultsView.this.refilter();
                }
            });
            MenuItem miCreateSubscription = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)miCreateSubscription, "menu.search.create.subscription");
            miCreateSubscription.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Map filterMap = SBC_SearchResultsView.this.buildFilterMap();
                    SearchUtils.showCreateSubscriptionDialog(engine.getId(), ((SearchInstance)((SBC_SearchResultsView)SBC_SearchResultsView.this).current_search).sq.term, filterMap);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            SearchUtils.addMenus(menu, engine, true);
            Label results = new Label(engine_comp, 0);
            GC temp = new GC((Drawable)results);
            Point size = temp.textExtent("(888)");
            temp.dispose();
            GridData gd = new GridData();
            gd.widthHint = size.x;
            results.setLayoutData((Object)gd);
            result_counts.add(results);
            ImageLabel indicator = new ImageLabel(engine_comp, vitality_images[0]);
            indicators.add(indicator);
            indicator.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    SBC_SearchResultsView.this.deselected_engines.clear();
                    boolean only_me_selected = button.getSelection();
                    if (only_me_selected) {
                        for (Button b : buttons) {
                            if (b == button || !b.getSelection()) continue;
                            only_me_selected = false;
                        }
                    }
                    if (only_me_selected) {
                        button.setSelection(false);
                        SBC_SearchResultsView.this.deselected_engines.add(engine.getUID());
                        for (Button b : buttons) {
                            if (b == button) continue;
                            b.setSelection(true);
                        }
                    } else {
                        button.setSelection(true);
                        for (Button b : buttons) {
                            if (b == button) continue;
                            b.setSelection(false);
                            SBC_SearchResultsView.this.deselected_engines.add(((Engine)b.getData()).getUID());
                        }
                    }
                    SBC_SearchResultsView.this.refilter();
                }
            });
            ++n2;
        }
        Composite cAddEdit = new Composite(this.engine_area, 0);
        cAddEdit.setLayout((Layout)new GridLayout());
        Button btnAddEdit = new Button(cAddEdit, 8);
        btnAddEdit.setLayoutData((Object)new GridData(0x1000000, 0, true, true));
        Messages.setLanguageText((Widget)btnAddEdit, "button.add.edit.search.templates");
        btnAddEdit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UIFunctions functions = UIFunctionsManager.getUIFunctions();
                if (functions != null) {
                    String server = "http://client.vuze.com/xsearch/addedit.php?azid=anonymous&azv=5.7.5.0&locale=en_US&os.name=Windows%207&vzemb=1";
                    try {
                        byte[] b_ss;
                        Map vc_data = VersionCheckClient.getSingleton().getMostRecentVersionCheckData();
                        if (vc_data != null && (b_ss = (byte[])vc_data.get("search_server")) != null) {
                            String ss;
                            server = ss = new String(b_ss, "UTF-8");
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    functions.viewURL(server, null, "");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite cCreateTemplate = new Composite(this.engine_area, 0);
        cCreateTemplate.setLayout((Layout)new GridLayout());
        Button btnCreateTemplate = new Button(cCreateTemplate, 8);
        btnCreateTemplate.setLayoutData((Object)new GridData(0x1000000, 0, true, true));
        Messages.setLanguageText((Widget)btnCreateTemplate, "menu.search.create.subscription");
        btnCreateTemplate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Map filterMap = SBC_SearchResultsView.this.buildFilterMap();
                SearchUtils.showCreateSubscriptionDialog(-1L, ((SearchInstance)((SBC_SearchResultsView)SBC_SearchResultsView.this).current_search).sq.term, SBC_SearchResultsView.this.buildFilterMap());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (engines.length > 0) {
            new AEThread2("updater"){
                int ticks;
                int image_index;
                volatile boolean running;
                {
                    super($anonymous0);
                    this.image_index = 0;
                    this.running = true;
                }

                @Override
                public void run() {
                    while (this.running) {
                        if (label_comp.isDisposed()) {
                            return;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        Utils.execSWTThread(new Runnable(){

                            @Override
                            public void run() {
                                boolean do_results;
                                if (label_comp.isDisposed()) {
                                    return;
                                }
                                ++ticks;
                                ++image_index;
                                if (image_index == vitality_images.length) {
                                    image_index = 0;
                                }
                                boolean all_done = do_results = ticks % 5 == 0;
                                int i = 0;
                                while (i < engines.length) {
                                    Object[] status = search.getEngineStatus(engines[i]);
                                    int state = (Integer)status[0];
                                    ImageLabel indicator = (ImageLabel)((Object)indicators.get(i));
                                    if (state == 0) {
                                        indicator.setImage(vitality_images[image_index]);
                                    } else if (state == 1) {
                                        indicator.setImage(ok_image);
                                    } else if (state == 2) {
                                        indicator.setImage(fail_image);
                                        String msg = (String)status[2];
                                        if (msg != null) {
                                            Utils.setTT((Control)indicator, msg);
                                        }
                                    } else {
                                        indicator.setImage(auth_image);
                                    }
                                    if (do_results) {
                                        Label rc;
                                        String str;
                                        if (state == 0) {
                                            all_done = false;
                                        }
                                        if (!(str = "(" + status[1] + ")").equals((rc = (Label)result_counts.get(i)).getText())) {
                                            rc.setText(str);
                                        }
                                    }
                                    ++i;
                                }
                                if (all_done) {
                                    running = false;
                                }
                            }
                        });
                    }
                }
            }.start();
        }
        this.engine_area.layout(true);
    }

    protected Map buildFilterMap() {
        HashMap<String, Object> mapFilter = new HashMap<String, Object>();
        if (this.without_keywords != null && this.without_keywords.length > 0) {
            mapFilter.put("text_filter_out", GeneralUtils.stringJoin(Arrays.asList(this.without_keywords), " "));
        }
        if (this.with_keywords != null && this.with_keywords.length > 0) {
            mapFilter.put("text_filter", GeneralUtils.stringJoin(Arrays.asList(this.with_keywords), " "));
        }
        long kinb = DisplayFormatters.getKinB();
        if (this.maxSize > 0) {
            mapFilter.put("max_size", (long)this.maxSize * kinb * kinb);
        }
        if (this.minSize > 0) {
            mapFilter.put("min_size", (long)this.minSize * kinb * kinb);
        }
        return mapFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetFilters() {
        Object object = this.filter_lock;
        synchronized (object) {
            this.minSize = 0;
            this.maxSize = 0;
            this.with_keywords = new String[0];
            this.without_keywords = new String[0];
            this.deselected_engines.clear();
        }
        Utils.execSWTThread(new Runnable(){

            @Override
            public void run() {
                if (SBC_SearchResultsView.this.spinMinSize != null && !SBC_SearchResultsView.this.spinMinSize.isDisposed()) {
                    SBC_SearchResultsView.this.spinMinSize.setSelection(0);
                }
                if (SBC_SearchResultsView.this.spinMaxSize != null && !SBC_SearchResultsView.this.spinMaxSize.isDisposed()) {
                    SBC_SearchResultsView.this.spinMaxSize.setSelection(0);
                }
                if (SBC_SearchResultsView.this.textWithKW != null && !SBC_SearchResultsView.this.textWithKW.isDisposed()) {
                    SBC_SearchResultsView.this.textWithKW.setText("");
                }
                if (SBC_SearchResultsView.this.textWithoutKW != null && !SBC_SearchResultsView.this.textWithoutKW.isDisposed()) {
                    SBC_SearchResultsView.this.textWithoutKW.setText("");
                }
                if (SBC_SearchResultsView.this.tv_subs_results != null) {
                    SBC_SearchResultsView.this.tv_subs_results.setFilterText("", false);
                }
            }
        });
    }

    private void setSearchEngines(final SearchInstance si) {
        Utils.execSWTThread(new Runnable(){

            @Override
            public void run() {
                SBC_SearchResultsView.this.buildEngineArea(si);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isOurContent(SBC_SearchResult result) {
        String engine_id;
        long size = result.getSize();
        long kInB = DisplayFormatters.getKinB();
        long mInB = kInB * kInB;
        if (size != -1L) {
            if (size < mInB * (long)this.minSize) return false;
        }
        if (size != -1L && this.maxSize != 0) {
            if (size > mInB * (long)this.maxSize) return false;
        }
        boolean bl = true;
        boolean size_ok = bl;
        if (!size_ok) {
            return false;
        }
        if (this.with_keywords.length > 0 || this.without_keywords.length > 0) {
            Object object = this.filter_lock;
            synchronized (object) {
                String name = result.getName().toLowerCase(Locale.US);
                int i = 0;
                while (i < this.with_keywords.length) {
                    if (!name.contains(this.with_keywords[i])) {
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.without_keywords.length) {
                    if (name.contains(this.without_keywords[i])) {
                        return false;
                    }
                    ++i;
                }
            }
        }
        if (!this.deselected_engines.contains(engine_id = result.getEngine().getUID())) return true;
        return false;
    }

    protected void refilter() {
        if (this.tv_subs_results != null) {
            this.tv_subs_results.refilter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumns(Core core) {
        Class<SBC_SearchResultsView> clazz = SBC_SearchResultsView.class;
        synchronized (SBC_SearchResultsView.class) {
            if (columnsAdded) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            columnsAdded = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            TableColumnManager tableManager = TableColumnManager.getInstance();
            tableManager.registerColumn(SBC_SearchResult.class, "type", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultType(column);
                }
            });
            tableManager.registerColumn(SBC_SearchResult.class, ColumnSearchSubResultName.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultName(column);
                }
            });
            tableManager.registerColumn(SBC_SearchResult.class, "actions", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultActions(column);
                }
            });
            tableManager.registerColumn(SBC_SearchResult.class, "size", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultSize(column);
                }
            });
            tableManager.registerColumn(SBC_SearchResult.class, ColumnSearchSubResultSeedsPeers.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultSeedsPeers(column);
                }
            });
            tableManager.registerColumn(SBC_SearchResult.class, ColumnSearchSubResultSeeds.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultSeeds(column);
                }
            });
            tableManager.registerColumn(SBC_SearchResult.class, ColumnSearchSubResultPeers.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultPeers(column);
                }
            });
            tableManager.registerColumn(SBC_SearchResult.class, ColumnSearchSubResultGrabbed.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultGrabbed(column);
                }
            });
            tableManager.registerColumn(SBC_SearchResult.class, ColumnSearchSubResultRatings.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultRatings(column);
                }
            });
            tableManager.registerColumn(SBC_SearchResult.class, "age", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultAge(column);
                }
            });
            tableManager.registerColumn(SBC_SearchResult.class, "rank", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultRank(column);
                }
            });
            tableManager.registerColumn(SBC_SearchResult.class, ColumnSearchSubResultCategory.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultCategory(column);
                }
            });
            tableManager.registerColumn(SBC_SearchResult.class, "site", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchResultSite(column);
                }
            });
            tableManager.registerColumn(SBC_SearchResult.class, ColumnSearchSubResultHash.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultHash(column);
                }
            });
            tableManager.registerColumn(SBC_SearchResult.class, ColumnSearchSubResultExisting.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnSearchSubResultExisting(column);
                }
            });
            return;
        }
    }

    @Override
    public void showView() {
        SWTSkinObject so_list = this.getSkinObject("search-results-list");
        if (so_list != null) {
            MetaSearchManagerFactory.getSingleton().getMetaSearch().addListener(this);
            so_list.setVisible(true);
            this.initTable((Composite)so_list.getControl());
        }
    }

    @Override
    public void refreshView() {
        if (this.tv_subs_results != null) {
            this.tv_subs_results.refreshTable(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hideView() {
        Object object = this.search_lock;
        synchronized (object) {
            if (this.current_search != null) {
                this.current_search.cancel();
                this.current_search = null;
            }
        }
        this.col_filter_helper = null;
        MetaSearchManagerFactory.getSingleton().getMetaSearch().removeListener(this);
        Utils.disposeSWTObjects(this.table_parent);
    }

    @Override
    public void engineAdded(Engine engine) {
        if (engine.isActive()) {
            this.autoSearchAgain();
        }
    }

    @Override
    public void engineUpdated(Engine engine) {
    }

    @Override
    public void engineRemoved(Engine engine) {
        SearchInstance si = this.current_search;
        if (si != null && si.getEngineIndex(engine) >= 0) {
            this.autoSearchAgain();
        }
    }

    @Override
    public void engineStateChanged(Engine engine) {
        SearchInstance si = this.current_search;
        if (si != null && si.getEngineIndex(engine) >= 0) {
            this.autoSearchAgain();
        }
    }

    private void initTable(Composite control) {
        this.tv_subs_results = TableViewFactory.createTableViewSWT(SBC_SearchResult.class, TABLE_SR, TABLE_SR, new TableColumnCore[0], ColumnSearchSubResultName.COLUMN_ID, 0x10010002);
        TableColumnManager tableManager = TableColumnManager.getInstance();
        tableManager.setDefaultColumnNames(TABLE_SR, new String[]{"type", ColumnSearchSubResultName.COLUMN_ID, "actions", "size", ColumnSearchSubResultSeedsPeers.COLUMN_ID, ColumnSearchSubResultRatings.COLUMN_ID, "age", "rank", ColumnSearchSubResultCategory.COLUMN_ID, "site"});
        tableManager.setDefaultSortColumnName(TABLE_SR, "rank");
        SWTSkinObjectTextbox soFilterBox = (SWTSkinObjectTextbox)this.getSkinObject("filterbox");
        if (soFilterBox != null) {
            BubbleTextBox bubbleTextBox = soFilterBox.getBubbleTextBox();
            this.tv_subs_results.enableFilterCheck(bubbleTextBox, (TableViewFilterCheck<SBC_SearchResult>)this);
            String tooltip = MessageText.getString("filter.tt.start");
            tooltip = String.valueOf(tooltip) + MessageText.getString("column.filter.tt.line1");
            tooltip = String.valueOf(tooltip) + MessageText.getString("column.filter.tt.line2");
            bubbleTextBox.setTooltip(tooltip);
            bubbleTextBox.setMessage(MessageText.getString("Button.search2"));
        }
        this.tv_subs_results.setRowDefaultHeight(COConfigurationManager.getIntParameter("Search Subs Row Height"));
        this.table_parent = new Composite(control, 0);
        this.table_parent.setLayoutData((Object)Utils.getFilledFormData());
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.table_parent.setLayout((Layout)layout);
        this.tv_subs_results.addSelectionListener(new TableSelectionListener(){

            @Override
            public void selected(TableRowCore[] _rows) {
                this.updateSelectedContent();
            }

            @Override
            public void mouseExit(TableRowCore row) {
            }

            @Override
            public void mouseEnter(TableRowCore row) {
            }

            @Override
            public void focusChanged(TableRowCore focus) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.refreshIconBar();
                }
            }

            @Override
            public void deselected(TableRowCore[] rows) {
                this.updateSelectedContent();
            }

            @Override
            public void defaultSelected(TableRowCore[] rows, int stateMask) {
                if (rows.length == 1) {
                    SBC_SearchResult rc = (SBC_SearchResult)rows[0].getDataSource();
                    SBC_SearchResultsView.downloadAction(rc);
                }
            }

            private void updateSelectedContent() {
                TableRowCore[] rows = SBC_SearchResultsView.this.tv_subs_results.getSelectedRows();
                ArrayList<SelectedContent> valid = new ArrayList<SelectedContent>();
                SBC_SearchResultsView.this.last_selected_content.clear();
                int i = 0;
                while (i < rows.length) {
                    SBC_SearchResult rc = (SBC_SearchResult)rows[i].getDataSource();
                    SBC_SearchResultsView.this.last_selected_content.add(rc);
                    byte[] hash = rc.getHash();
                    if (hash != null && hash.length > 0) {
                        SelectedContent sc = new SelectedContent(Base32.encode(hash), rc.getName());
                        sc.setDownloadInfo(new DownloadUrlInfo(SBC_SearchResultsView.this.getDownloadURI(rc)));
                        valid.add(sc);
                    }
                    ++i;
                }
                ISelectedContent[] sels = valid.toArray(new ISelectedContent[valid.size()]);
                SelectedContentManager.changeCurrentlySelectedContent("IconBarEnabler", sels, SBC_SearchResultsView.this.tv_subs_results);
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.refreshIconBar();
                }
            }
        }, false);
        this.tv_subs_results.addMenuFillListener(new TableViewSWTMenuFillListener(){

            @Override
            public void fillMenu(String sColumnName, Menu menu) {
                Object[] _related_content = SBC_SearchResultsView.this.tv_subs_results.getSelectedDataSources().toArray();
                SearchSubsResultBase[] results = new SBC_SearchResult[_related_content.length];
                System.arraycopy(_related_content, 0, results, 0, results.length);
                MenuItem item = new MenuItem(menu, 8);
                item.setText(MessageText.getString("label.copy.url.to.clip"));
                item.addSelectionListener((SelectionListener)new SelectionAdapter((SBC_SearchResult[])results){
                    private final /* synthetic */ SBC_SearchResult[] val$results;
                    {
                        this.val$results = sBC_SearchResultArray;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        StringBuffer buffer = new StringBuffer(1024);
                        SBC_SearchResult[] sBC_SearchResultArray = this.val$results;
                        int n = this.val$results.length;
                        int n2 = 0;
                        while (n2 < n) {
                            SBC_SearchResult result = sBC_SearchResultArray[n2];
                            byte[] hash = result.getHash();
                            if (hash != null && hash.length > 0) {
                                if (buffer.length() > 0) {
                                    buffer.append("\r\n");
                                }
                                buffer.append(SBC_SearchResultsView.this.getDownloadURI(result));
                            }
                            ++n2;
                        }
                        ClipboardCopy.copyToClipBoard(buffer.toString());
                    }
                });
                item.setEnabled(results.length > 0);
                SearchSubsUtils.addMenu(null, results, menu);
                new MenuItem(menu, 2);
                if (results.length == 1 && SearchSubsUtils.addMenu(results[0], menu)) {
                    new MenuItem(menu, 2);
                }
            }

            @Override
            public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
            }
        });
        this.col_filter_helper = new TableColumnFilterHelper<SBC_SearchResult>(this.tv_subs_results, "srv:search");
        this.tv_subs_results.initialize(this.table_parent);
        control.layout(true);
    }

    protected void invalidate(SBC_SearchResult result) {
        TableRowCore row = this.tv_subs_results.getRow(result);
        if (row != null) {
            row.invalidate(true);
        }
    }

    @Override
    public boolean filterCheck(SBC_SearchResult ds, String filter2, boolean regex, boolean confusable) {
        if (!this.isOurContent(ds)) {
            return false;
        }
        return SearchSubsUtils.filterCheck(this.col_filter_helper, ds, filter2, regex, confusable);
    }

    @Override
    public void filterSet(String filter2) {
    }

    private void autoSearchAgain() {
        SearchInstance si = this.current_search;
        if (si != null) {
            this.anotherSearch(si.getSearchQuery());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void anotherSearch(SearchResultsTabArea.SearchQuery sq) {
        Object object = this.search_lock;
        synchronized (object) {
            if (this.current_search != null) {
                this.current_search.cancel();
            }
            this.resetFilters();
            this.current_search = new SearchInstance(sq);
        }
    }

    public String getDownloadURI(SBC_SearchResult result) {
        String torrent_url = result.getTorrentLink();
        if (torrent_url != null && torrent_url.length() > 0) {
            return torrent_url;
        }
        String uri = UrlUtils.getMagnetURI(result.getHash(), result.getName(), new String[]{"Public"});
        return uri;
    }

    public void getIcon(Engine engine, ImageLoadListener listener) {
        String icon = engine.getIcon();
        if (icon == null) {
            listener.imageLoaded(null);
        }
        ImageLoader.getInstance().getUrlImage(icon, new Point(0, 16), (image, key, returnedImmediately) -> {
            this.loadedImageIDs.add(key);
            listener.imageLoaded(image);
        });
    }

    @Override
    public int getResultCount() {
        SearchInstance ci = this.current_search;
        if (ci == null) {
            return -1;
        }
        return this.current_search.getResultCount();
    }

    public static void downloadAction(final SearchSubsResultBase entry) {
        String link = entry.getTorrentLink();
        if (link == null) {
            return;
        }
        if (link.startsWith("chat:")) {
            Utils.launch(link);
            return;
        }
        SBC_SearchResultsView.showDownloadFTUX(entry, new UserPrompterResultListener(){

            @Override
            public void prompterClosed(int result) {
                if (result == 0) {
                    String referer_str = null;
                    String torrentUrl = entry.getTorrentLink();
                    try {
                        Map headers = UrlUtils.getBrowserHeaders(referer_str);
                        if (entry instanceof SubscriptionResultFilterable) {
                            SubscriptionResultFilterable sub_entry = (SubscriptionResultFilterable)entry;
                            Subscription subs = sub_entry.getSubscription();
                            try {
                                WebEngine webEngine;
                                Engine engine = subs.getEngine();
                                if (engine != null && engine instanceof WebEngine && (webEngine = (WebEngine)engine).isNeedsAuth()) {
                                    headers.put("Cookie", webEngine.getCookies());
                                }
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                            subs.addPotentialAssociation(sub_entry.getID(), torrentUrl);
                        } else {
                            SBC_SearchResult search_entry = (SBC_SearchResult)entry;
                            Engine engine = search_entry.getEngine();
                            if (engine != null) {
                                WebEngine webEngine;
                                engine.addPotentialAssociation(torrentUrl);
                                if (engine instanceof WebEngine && (webEngine = (WebEngine)engine).isNeedsAuth()) {
                                    headers.put("Cookie", webEngine.getCookies());
                                }
                            }
                        }
                        byte[] torrent_hash = entry.getHash();
                        if (torrent_hash != null && torrent_hash != null && !torrentUrl.toLowerCase().startsWith("magnet")) {
                            String title = entry.getName();
                            String magnet = UrlUtils.getMagnetURI(torrent_hash, title, null);
                            headers.put("X-Alternative-URI-1", magnet);
                        }
                        PluginInitializer.getDefaultInterface().getDownloadManager().addDownload(new URL(torrentUrl), headers);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    protected static void showDownloadFTUX(SearchSubsResultBase entry, final UserPrompterResultListener listener) {
        if (entry instanceof SubscriptionResultFilterable) {
            listener.prompterClosed(0);
            return;
        }
        if (RememberedDecisionsManager.getRememberedDecision("searchsubs.dl.ftux") == 1) {
            listener.prompterClosed(0);
            return;
        }
        VuzeMessageBox box = new VuzeMessageBox(MessageText.getString("searchsubs.dl.ftux.title"), null, new String[]{MessageText.getString("Button.ok"), MessageText.getString("Button.cancel")}, 0);
        box.setSubTitle(MessageText.getString("searchsubs.dl.ftux.heading"));
        final boolean[] check_state = new boolean[]{true};
        box.setListener(new VuzeMessageBoxListener(){

            @Override
            public void shellReady(Shell shell, SWTSkinObjectContainer soExtra) {
                SWTSkin skin = soExtra.getSkin();
                SBC_SearchResultsView.addResourceBundle(skin, "com/biglybt/ui/swt/columns/searchsubs/", "skin3_dl_ftux");
                String id = "searchsubs.dlftux.shell";
                skin.createSkinObject(id, id, soExtra);
                SWTSkinObjectCheckbox cb = (SWTSkinObjectCheckbox)skin.getSkinObject("agree-checkbox");
                cb.setChecked(true);
                cb.addSelectionListener(new SWTSkinCheckboxListener(){

                    @Override
                    public void checkboxChanged(SWTSkinObjectCheckbox so, boolean checked) {
                        check_state[0] = checked;
                    }
                });
            }
        });
        box.open(new UserPrompterResultListener(){

            @Override
            public void prompterClosed(int result) {
                if (result == 0 && check_state[0]) {
                    RememberedDecisionsManager.setRemembered("searchsubs.dl.ftux", 1);
                }
                listener.prompterClosed(result);
            }
        });
    }

    private static void addResourceBundle(SWTSkin skin, String path, String name) {
        String sFile = String.valueOf(path) + name;
        ClassLoader loader = ColumnSearchSubResultActions.class.getClassLoader();
        SWTSkinProperties skinProperties = skin.getSkinProperties();
        try {
            ResourceBundle subBundle = ResourceBundle.getBundle(sFile, Locale.getDefault(), loader);
            skinProperties.addResourceBundle(subBundle, path, loader);
        }
        catch (MissingResourceException mre) {
            Debug.out(mre);
        }
    }

    static class ImageLabel
    extends Canvas
    implements PaintListener {
        private Image image;

        public ImageLabel(Composite parent, Image _image) {
            super(parent, 0x20000000);
            this.image = _image;
            this.addPaintListener(this);
        }

        public void paintControl(PaintEvent e) {
            if (!this.image.isDisposed()) {
                Point size = this.getSize();
                Rectangle rect = this.image.getBounds();
                int x_offset = Math.max(0, (size.x - rect.width) / 2);
                int y_offset = Math.max(0, (size.y - rect.height) / 2);
                e.gc.drawImage(this.image, x_offset, y_offset);
            }
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            if (this.image.isDisposed()) {
                return new Point(0, 0);
            }
            Rectangle rect = this.image.getBounds();
            return new Point(rect.width, rect.height);
        }

        private void setImage(Image _image) {
            if (_image == this.image) {
                return;
            }
            this.image = _image;
            this.redraw();
        }
    }

    public static interface ImageLoadListener {
        public void imageLoaded(Image var1);
    }

    private class SearchInstance
    implements ResultListener {
        private final SearchResultsTabArea.SearchQuery sq;
        private final Engine[] engines;
        private final Object[][] engine_status;
        private boolean _cancelled;
        private Set<Engine> pending = new HashSet<Engine>();
        private AtomicInteger result_count = new AtomicInteger();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SearchInstance(SearchResultsTabArea.SearchQuery _sq) {
            this.sq = _sq;
            SBC_SearchResultsView.this.tv_subs_results.removeAllTableRows();
            SWTSkinObjectText title = (SWTSkinObjectText)SBC_SearchResultsView.this.parent.getSkinObject("title");
            if (title != null) {
                title.setText(MessageText.getString("search.results.view.title", new String[]{this.sq.term}));
            }
            MetaSearchManager metaSearchManager = MetaSearchManagerFactory.getSingleton();
            ArrayList<SearchParameter> sps = new ArrayList<SearchParameter>();
            sps.add(new SearchParameter("s", this.sq.term));
            SearchParameter[] parameters = sps.toArray(new SearchParameter[sps.size()]);
            HashMap<String, String> context2 = new HashMap<String, String>();
            context2.put("force_full", "true");
            context2.put("batch_millis", "250");
            context2.put("remove_dup_hash", "true");
            String headers = null;
            SBC_SearchResultsView.this.parent.setBusy(true);
            Set<Engine> set = this.pending;
            synchronized (set) {
                this.engines = metaSearchManager.getMetaSearch().search(this, parameters, headers, context2, 500);
                this.engine_status = new Object[this.engines.length][];
                int i = 0;
                while (i < this.engine_status.length) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = 0;
                    objectArray[1] = 0;
                    this.engine_status[i] = objectArray;
                    ++i;
                }
                SBC_SearchResultsView.this.setSearchEngines(this);
                if (this.engines.length == 0) {
                    SBC_SearchResultsView.this.parent.setBusy(false);
                } else {
                    this.pending.addAll(Arrays.asList(this.engines));
                }
            }
        }

        protected SearchResultsTabArea.SearchQuery getSearchQuery() {
            return this.sq;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Engine[] getEngines() {
            Set<Engine> set = this.pending;
            synchronized (set) {
                return this.engines;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int getEngineIndex(Engine e) {
            Set<Engine> set = this.pending;
            synchronized (set) {
                int i = 0;
                while (i < this.engines.length) {
                    if (this.engines[i] == e) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }
        }

        protected Object[] getEngineStatus(Engine engine) {
            int i = this.getEngineIndex(engine);
            if (i >= 0) {
                return this.engine_status[i];
            }
            return null;
        }

        protected void cancel() {
            this._cancelled = true;
            SBC_SearchResultsView.this.parent.setBusy(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isCancelled() {
            Object object = SBC_SearchResultsView.this.search_lock;
            synchronized (object) {
                return this._cancelled;
            }
        }

        @Override
        public void contentReceived(Engine engine, String content) {
        }

        @Override
        public void matchFound(Engine engine, String[] fields) {
        }

        @Override
        public void engineFailed(Engine engine, Throwable e) {
            if (this.isCancelled()) {
                return;
            }
            this.engineDone(engine, 2, Debug.getNestedExceptionMessage(e));
        }

        @Override
        public void engineRequiresLogin(Engine engine, Throwable e) {
            if (this.isCancelled()) {
                return;
            }
            this.engineDone(engine, 3, null);
        }

        @Override
        public void resultsComplete(Engine engine) {
            if (this.isCancelled()) {
                return;
            }
            this.engineDone(engine, 1, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void engineDone(Engine engine, int state, String msg) {
            int i = this.getEngineIndex(engine);
            if (i >= 0) {
                this.engine_status[i][0] = state;
                this.engine_status[i][2] = msg;
            }
            Set<Engine> set = this.pending;
            synchronized (set) {
                this.pending.remove(engine);
                if (this.pending.isEmpty()) {
                    SBC_SearchResultsView.this.parent.setBusy(false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resultsReceived(Engine engine, Result[] results) {
            Object object = SBC_SearchResultsView.this.search_lock;
            synchronized (object) {
                if (this.isCancelled()) {
                    return;
                }
                int index = this.getEngineIndex(engine);
                if (index >= 0) {
                    int count = (Integer)this.engine_status[index][1];
                    this.engine_status[index][1] = count + results.length;
                }
                SBC_SearchResult[] data_sources = new SBC_SearchResult[results.length];
                int i = 0;
                while (i < results.length) {
                    data_sources[i] = new SBC_SearchResult(SBC_SearchResultsView.this, engine, results[i]);
                    ++i;
                }
                SBC_SearchResultsView.this.tv_subs_results.addDataSources(data_sources);
                SBC_SearchResultsView.this.tv_subs_results.processDataSourceQueueSync();
                this.result_count.addAndGet(results.length);
                SBC_SearchResultsView.this.parent.resultsFound();
            }
        }

        protected int getResultCount() {
            return this.result_count.get();
        }
    }
}

