/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.search;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.PluginInterface;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.debug.ObfuscateTab;
import com.biglybt.ui.swt.search.SearchResultsTabArea;
import com.biglybt.ui.swt.views.skin.SkinViewManager;
import java.util.ArrayList;
import java.util.List;

public class SearchHandler {
    private static List<MdiEntry> active_searches = new ArrayList<MdiEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleSearch(String sSearchText, boolean toSubscribe) {
        String id;
        if (!toSubscribe) {
            try {
                PluginInterface pi;
                if (COConfigurationManager.getBooleanParameter("rcm.overall.enabled", true) && COConfigurationManager.getBooleanParameter("Plugin.aercm.rcm.search.enable", false) && COConfigurationManager.getBooleanParameter("search.showRCMView") && CoreFactory.isCoreRunning() && (pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("aercm")) != null && pi.getPluginState().isOperational() && pi.getIPC().canInvoke("lookupByExpression", new Object[]{""})) {
                    try {
                        pi.getIPC().invoke("lookupByExpression", new Object[]{sSearchText});
                    }
                    catch (Throwable e2) {
                        Debug.out(e2);
                    }
                }
            }
            catch (Throwable e3) {
                Debug.out(e3);
            }
        }
        SearchResultsTabArea.SearchQuery sq = new SearchResultsTabArea.SearchQuery(sSearchText, toSubscribe);
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        MdiEntry existingEntry = mdi.getEntry(id = "Search." + Integer.toHexString(sSearchText.hashCode()) + (toSubscribe ? ".s" : ""));
        if (existingEntry != null) {
            SearchResultsTabArea searchClass = (SearchResultsTabArea)SkinViewManager.getByClass(SearchResultsTabArea.class);
            if (searchClass != null) {
                searchClass.anotherSearch(sSearchText, toSubscribe);
            }
            existingEntry.setDatasource(sq);
            mdi.showEntry(existingEntry);
            return;
        }
        MdiEntry entry = mdi.createEntryFromSkinRef("header.discovery", id, "main.area.searchresultstab", sSearchText, null, sq, true, "");
        if (entry != null) {
            entry.setImageLeftID("image.sidebar.search");
            entry.setDatasource(sq);
            entry.setViewTitleInfo(new ViewTitleInfoImplementation());
            MdiEntry to_remove = null;
            entry.addListener((e, user) -> {
                List<MdiEntry> list = active_searches;
                synchronized (list) {
                    active_searches.remove(e);
                }
            });
            List<MdiEntry> list = active_searches;
            synchronized (list) {
                active_searches.add(entry);
                if (active_searches.size() > 5) {
                    to_remove = active_searches.remove(0);
                }
            }
            if (to_remove != null) {
                to_remove.closeView();
            }
        }
        mdi.showEntryByID(id);
    }

    private static final class ViewTitleInfoImplementation
    implements ViewTitleInfo,
    ObfuscateTab {
        private ViewTitleInfoImplementation() {
        }

        @Override
        public Object getTitleInfoProperty(int propertyID) {
            SearchResultsTabArea.SearchQuery sq;
            SearchResultsTabArea searchClass;
            if (propertyID == 5 && (searchClass = (SearchResultsTabArea)SkinViewManager.getByClass(SearchResultsTabArea.class)) != null && (sq = searchClass.getCurrentSearch()) != null) {
                return sq.term;
            }
            return null;
        }

        @Override
        public String getObfuscatedHeader() {
            return "";
        }
    }
}

