/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.sharing.progress;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.sharing.ShareException;
import com.biglybt.pif.sharing.ShareManager;
import com.biglybt.pif.sharing.ShareManagerListener;
import com.biglybt.pif.sharing.ShareResource;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProgressWindow
implements ShareManagerListener {
    private final ParameterListener paramSupressSharingDialogListener = new ParameterListener(){

        @Override
        public void parameterChanged(String parameterName) {
            ProgressWindow.this.window_disabled = COConfigurationManager.getBooleanParameter("Suppress Sharing Dialog");
        }
    };
    private boolean window_disabled;
    private ShareManager share_manager;
    private progressDialog dialog = null;
    private Display display;
    private StyledText tasks;
    private ProgressBar progress;
    private Button cancel_button;
    private boolean shell_opened;
    private boolean manually_hidden;

    public ProgressWindow(Display _display) {
        COConfigurationManager.addWeakParameterListener(this.paramSupressSharingDialogListener, true, "Suppress Sharing Dialog");
        try {
            this.share_manager = PluginInitializer.getDefaultInterface().getShareManager();
            this.display = _display;
            this.share_manager.addListener(this);
        }
        catch (ShareException e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public void resourceAdded(ShareResource resource) {
        if (!this.share_manager.isInitialising()) {
            this.reportCurrentTask("Resource added: " + resource.getName());
        }
    }

    @Override
    public void resourceModified(ShareResource old_resource, ShareResource new_resource) {
        this.reportCurrentTask("Resource modified: " + old_resource.getName());
    }

    @Override
    public void resourceDeleted(ShareResource resource) {
        this.reportCurrentTask("Resource deleted: " + resource.getName());
    }

    @Override
    public void reportProgress(final int percent_complete) {
        if (this.window_disabled) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (ProgressWindow.this.progress != null && !ProgressWindow.this.progress.isDisposed()) {
                    if (ProgressWindow.this.dialog == null) {
                        ProgressWindow.this.dialog = new progressDialog(ProgressWindow.this.display);
                        if (ProgressWindow.this.dialog == null) {
                            return;
                        }
                    }
                    if (!ProgressWindow.this.dialog.isShown() && !ProgressWindow.this.manually_hidden) {
                        ProgressWindow.this.dialog.showPanel();
                    }
                    ProgressWindow.this.cancel_button.setEnabled(percent_complete < 100);
                    ProgressWindow.this.progress.setSelection(percent_complete);
                }
            }
        });
    }

    @Override
    public void reportCurrentTask(final String task_description) {
        if (this.window_disabled) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (ProgressWindow.this.dialog == null) {
                    ProgressWindow.this.dialog = new progressDialog(ProgressWindow.this.display);
                    if (ProgressWindow.this.dialog == null) {
                        return;
                    }
                }
                if (ProgressWindow.this.tasks != null && !ProgressWindow.this.tasks.isDisposed()) {
                    ProgressWindow.this.dialog.showPanel();
                    ProgressWindow.this.tasks.append(String.valueOf(task_description) + Text.DELIMITER);
                    int lines = ProgressWindow.this.tasks.getLineCount();
                    ProgressWindow.this.tasks.setTopIndex(lines - 1);
                }
            }
        });
    }

    private class progressDialog {
        protected Shell shell;
        int x0;
        int y1;

        protected progressDialog(Display dialog_display) {
            if (dialog_display.isDisposed()) {
                return;
            }
            this.shell = new Shell(ProgressWindow.this.display, 16384);
            this.shell.setSize(250, 150);
            Utils.setShellIcon(this.shell);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            try {
                layout.spacing = 0;
            }
            catch (NoSuchFieldError noSuchFieldError) {
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            this.shell.setLayout((Layout)layout);
            this.shell.setText(MessageText.getString("sharing.progress.title"));
            ProgressWindow.this.tasks = new StyledText((Composite)this.shell, 2824);
            ProgressWindow.this.tasks.setBackground(Colors.getSystemColor((Device)dialog_display, 1));
            ProgressWindow.this.progress = new ProgressBar((Composite)this.shell, 0);
            ProgressWindow.this.progress.setMinimum(0);
            ProgressWindow.this.progress.setMaximum(100);
            Button hide_button = new Button((Composite)this.shell, 8);
            hide_button.setText(MessageText.getString("sharing.progress.hide"));
            ProgressWindow.this.cancel_button = new Button((Composite)this.shell, 8);
            ProgressWindow.this.cancel_button.setText(MessageText.getString("sharing.progress.cancel"));
            ProgressWindow.this.cancel_button.setEnabled(false);
            FormData formData = new FormData();
            formData.right = new FormAttachment(100, -5);
            formData.bottom = new FormAttachment(100, -10);
            hide_button.setLayoutData((Object)formData);
            formData = new FormData();
            formData.right = new FormAttachment((Control)hide_button, -5);
            formData.bottom = new FormAttachment(100, -10);
            ProgressWindow.this.cancel_button.setLayoutData((Object)formData);
            formData = new FormData();
            formData.right = new FormAttachment((Control)ProgressWindow.this.cancel_button, -5);
            formData.left = new FormAttachment(0, 50);
            formData.bottom = new FormAttachment(100, -10);
            ProgressWindow.this.progress.setLayoutData((Object)formData);
            formData = new FormData();
            formData.right = new FormAttachment(100, -5);
            formData.bottom = new FormAttachment(100, -50);
            formData.top = new FormAttachment(0, 5);
            formData.left = new FormAttachment(0, 5);
            ProgressWindow.this.tasks.setLayoutData((Object)formData);
            this.shell.layout();
            ProgressWindow.this.cancel_button.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ProgressWindow.this.cancel_button.setEnabled(false);
                    ProgressWindow.this.share_manager.cancelOperation();
                }
            });
            hide_button.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    progressDialog.this.hidePanel();
                }
            });
            this.shell.setDefaultButton(hide_button);
            this.shell.addListener(31, new Listener(){

                public void handleEvent(Event e) {
                    if (e.character == '\u001b') {
                        progressDialog.this.hidePanel();
                    }
                }
            });
            Rectangle bounds = this.shell.getMonitor().getClientArea();
            this.x0 = bounds.x + bounds.width - 255;
            this.y1 = bounds.y + bounds.height - 155;
            this.shell.setLocation(this.x0, this.y1);
        }

        protected void hidePanel() {
            ProgressWindow.this.manually_hidden = true;
            this.shell.setVisible(false);
        }

        protected void showPanel() {
            ProgressWindow.this.manually_hidden = false;
            if (!ProgressWindow.this.shell_opened) {
                ProgressWindow.this.shell_opened = true;
                this.shell.open();
            }
            if (!this.shell.isVisible()) {
                this.shell.setVisible(true);
            }
            this.shell.moveAbove(null);
        }

        protected boolean isShown() {
            return this.shell.isVisible();
        }
    }
}

