/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells;

import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.SWTThread;
import com.biglybt.ui.swt.mainwindow.SWTThreadAlreadyInstanciatedException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class GCStringPrinter {
    private static final char ELLIPSIS = '\u2026';
    private static final boolean DEBUG = false;
    private static final String GOOD_STRING = "(/|,jI~`gy";
    public static final int FLAG_SKIPCLIP = 1;
    public static final int FLAG_FULLLINESONLY = 2;
    public static final int FLAG_NODRAW = 4;
    public static final int FLAG_KEEP_URL_INFO = 8;
    private static final Pattern patHREF = Pattern.compile("<\\s*?a\\s.*?href\\s*?=\\s*?\"(.+?)\".*?>(.*?)<\\s*?/a\\s*?>", 2);
    private static final Pattern patAHREF_TITLE = Pattern.compile("title=\\\"([^\\\"]+)", 2);
    private static final Pattern patAHREF_TARGET = Pattern.compile("target=\\\"([^\\\"]+)", 2);
    private static final int MAX_LINE_LEN = 4000;
    private static final int MAX_WORD_LEN = 4000;
    private boolean cutoff;
    private boolean truncated;
    private boolean isWordCut;
    private GC gc;
    private String string;
    private Rectangle printArea;
    private int swtFlags;
    private int printFlags;
    private Point size;
    private Point preferredSize;
    private Color urlColor;
    private List<URLInfo> listUrlInfo;
    private Image[] images;
    private float[] imageScales;
    private int iCurrentHeight;
    private boolean wrap;
    private Rectangle drawRect;

    public static boolean printString(GC gc, String string, Rectangle printArea) {
        return GCStringPrinter.printString(gc, string, printArea, false, false);
    }

    public static boolean printString(GC gc, String string, Rectangle printArea, boolean skipClip, boolean fullLinesOnly) {
        return GCStringPrinter.printString(gc, string, printArea, skipClip, fullLinesOnly, 192);
    }

    public static boolean printString(GC gc, String string, Rectangle printArea, boolean skipClip, boolean fullLinesOnly, int swtFlags) {
        try {
            GCStringPrinter sp = new GCStringPrinter(gc, string, printArea, skipClip, fullLinesOnly, swtFlags);
            return sp.printString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean _printString() {
        if (Constants.isWindows) {
            return this.swt_printString_NoAdvanced();
        }
        return this.swt_printString();
    }

    private boolean swt_printString_NoAdvanced() {
        boolean b = false;
        try {
            boolean wasAdvanced = this.gc.getAdvanced();
            Rectangle clipping = null;
            if (this.gc.getAdvanced() && this.gc.getTextAntialias() == -1 && this.gc.getAlpha() == 255) {
                clipping = this.gc.getClipping();
                this.gc.setAdvanced(false);
                Utils.setClipping(this.gc, clipping);
            }
            b = this.__printString();
            if (wasAdvanced) {
                this.gc.setAdvanced(true);
                Utils.setClipping(this.gc, clipping);
            }
        }
        catch (Throwable t) {
            Debug.out(t);
        }
        return b;
    }

    private boolean swt_printString() {
        boolean b = false;
        try {
            b = this.__printString();
        }
        catch (Throwable t) {
            Debug.out(t);
        }
        return b;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean __printString() {
        block46: {
            block47: {
                block48: {
                    this.size = new Point(0, 0);
                    this.preferredSize = new Point(0, 0);
                    this.isWordCut = false;
                    if (this.string == null) {
                        return false;
                    }
                    if (this.printArea == null) return false;
                    if (this.printArea.isEmpty()) {
                        return false;
                    }
                    lines = new ArrayList<LineInfo>(1);
                    while (this.string.indexOf(9) >= 0) {
                        this.string = this.string.replace('\t', ' ');
                    }
                    if (this.string.indexOf("  ") > 0) {
                        this.string = this.string.replaceAll("  +", " ");
                    }
                    hasSlashR = this.string.indexOf(13) > 0;
                    fullLinesOnly = (this.printFlags & 2) != 0;
                    skipClip = (this.printFlags & 1) != 0;
                    noDraw = (this.printFlags & 4) != 0;
                    v0 = this.wrap = (this.swtFlags & 64) != 0;
                    if ((this.swtFlags & 1152) == 0) {
                        fullLinesOnly = true;
                        this.printFlags |= 2;
                    }
                    if (this.string.indexOf(60) < 0) break block47;
                    if ((this.printFlags & 8) != 0) break block48;
                    htmlMatcher = GCStringPrinter.patHREF.matcher(this.string);
                    hasURL = htmlMatcher.find();
                    if (!hasURL) break block47;
                    this.listUrlInfo = new ArrayList<URLInfo>(1);
                    if (true) ** GOTO lbl51
                }
                htmlMatcher = GCStringPrinter.patHREF.matcher(this.string);
                this.string = htmlMatcher.replaceAll("$2");
                break block47;
                do {
                    urlInfo = new URLInfo();
                    urlInfo.fullString = htmlMatcher.group();
                    urlInfo.relStartPos = htmlMatcher.start(0);
                    urlInfo.url = this.string.substring(htmlMatcher.start(1), htmlMatcher.end(1));
                    urlInfo.text = this.string.substring(htmlMatcher.start(2), htmlMatcher.end(2));
                    urlInfo.titleLength = urlInfo.text.length();
                    matcherTitle = GCStringPrinter.patAHREF_TITLE.matcher(urlInfo.fullString);
                    if (matcherTitle.find()) {
                        urlInfo.title = this.string.substring(urlInfo.relStartPos + matcherTitle.start(1), urlInfo.relStartPos + matcherTitle.end(1));
                    }
                    if ((matcherTarget = GCStringPrinter.patAHREF_TARGET.matcher(urlInfo.fullString)).find()) {
                        urlInfo.target = this.string.substring(urlInfo.relStartPos + matcherTarget.start(1), urlInfo.relStartPos + matcherTarget.end(1));
                    }
                    this.string = htmlMatcher.replaceFirst(urlInfo.text.replaceAll("\\$", "\\\\\\$"));
                    this.listUrlInfo.add(urlInfo);
                    htmlMatcher = GCStringPrinter.patHREF.matcher(this.string);
                    hasURL = htmlMatcher.find(urlInfo.relStartPos);
lbl51:
                    // 2 sources

                } while (hasURL);
            }
            lineDrawRect = new Rectangle(this.printArea.x, this.printArea.y, this.printArea.width, this.printArea.height);
            this.drawRect = new Rectangle(this.printArea.x, this.printArea.y, this.printArea.width, this.printArea.height);
            oldClipping = null;
            try {
                if (!skipClip && !noDraw) {
                    oldClipping = this.gc.getClipping();
                    Utils.setClipping(this.gc, this.printArea);
                }
                this.iCurrentHeight = 0;
                currentCharPos = 0;
                posNewLine = this.string.indexOf(10);
                if (hasSlashR) {
                    posR = this.string.indexOf(13);
                    if (posR == -1) {
                        posR = posNewLine;
                    }
                    posNewLine = Math.min(posNewLine, posR);
                }
                if (posNewLine < 0) {
                    posNewLine = this.string.length();
                }
                posLastNewLine = 0;
                if (true) ** GOTO lbl130
                do {
                    sLine = this.string.substring(posLastNewLine, posNewLine);
                    do {
                        block52: {
                            block50: {
                                block51: {
                                    block49: {
                                        lineInfo = new LineInfo(sLine, currentCharPos);
                                        lineInfo = this.processLine(this.gc, lineInfo, this.printArea, fullLinesOnly, false, this.wrap == false);
                                        sProcessedLine = lineInfo.lineOutputed;
                                        if (sProcessedLine == null || sProcessedLine.length() <= 0) break block49;
                                        if (lineInfo.outputLineExtent.x == 0 || lineInfo.outputLineExtent.y == 0) {
                                            lineInfo.outputLineExtent = GCStringPrinter.stringExtent(this.gc, sProcessedLine);
                                        }
                                        this.iCurrentHeight += lineInfo.outputLineExtent.y;
                                        v1 = isOverY = this.iCurrentHeight > this.printArea.height;
                                        if (isOverY && !fullLinesOnly) {
                                            lines.add(lineInfo);
                                        } else {
                                            if (isOverY && fullLinesOnly && lines.size() > 0) {
                                                prev = (LineInfo)lines.get(lines.size() - 1);
                                                if (this.wrap) {
                                                    prev = this.processLine(this.gc, prev, this.printArea, fullLinesOnly, false, true);
                                                    prev.outputLineExtent = GCStringPrinter.stringExtent(this.gc, prev.lineOutputed);
                                                    if (prev.excessPos == -1) {
                                                    }
                                                }
                                                if ((str = prev.lineOutputed).length() > 2 && prev.outputLineExtent.x + this.gc.stringExtent((String)"\u2026").x >= this.printArea.width) {
                                                    str = str.substring(0, str.length() - 2);
                                                }
                                                prev.lineOutputed = this.truncate(str);
                                                this.cutoff = true;
                                                this.truncated = true;
                                                return this.truncated;
                                            }
                                            lines.add(lineInfo);
                                        }
                                        v2 = sLine = lineInfo.excessPos >= 0 && this.wrap != false ? sLine.substring(lineInfo.excessPos) : null;
                                        if (lineInfo.excessPos < 0) break block50;
                                        break block51;
                                    }
                                    this.iCurrentHeight += lineInfo.outputLineExtent.y;
                                    lines.add(lineInfo);
                                    ++currentCharPos;
                                    break;
                                }
                                v3 = lineInfo.excessPos;
                                break block52;
                            }
                            v3 = lineInfo.lineOutputed.length();
                        }
                        currentCharPos += v3;
                    } while (sLine != null);
                    if (this.string.length() > posNewLine && this.string.charAt(posNewLine) == '\r' && this.string.charAt(posNewLine + 1) == '\n') {
                        ++posNewLine;
                    }
                    currentCharPos = posLastNewLine = posNewLine + 1;
                    posNewLine = this.string.indexOf(10, posLastNewLine);
                    if (hasSlashR) {
                        posR = this.string.indexOf(13, posLastNewLine);
                        if (posR == -1) {
                            posR = posNewLine;
                        }
                        posNewLine = Math.min(posNewLine, posR);
                    }
                    if (posNewLine < 0) {
                        posNewLine = this.string.length();
                    }
lbl130:
                    // 4 sources

                    if (posNewLine < 0) break;
                } while (posLastNewLine < this.string.length());
            }
            finally {
                if (lines.size() <= 0) break block46;
                ** for (lineInfo : lines)
            }
lbl-1000:
            // 1 sources

            {
                this.size.x = Math.max(lineInfo.outputLineExtent.x, this.size.x);
                this.size.y += lineInfo.outputLineExtent.y;
                this.preferredSize.x = Math.max(lineInfo.outputLinePreferredExtent.x, this.preferredSize.x);
                continue;
            }
lbl142:
            // 1 sources

            if ((this.swtFlags & 1024) != 0) {
                lineDrawRect.y = lineDrawRect.y + lineDrawRect.height - this.size.y;
            } else if ((this.swtFlags & 128) == 0) {
                lineDrawRect.y += (lineDrawRect.height - this.size.y) / 2;
            }
            this.drawRect.y = lineDrawRect.y;
            if (!noDraw || this.listUrlInfo != null) {
                this.drawRect.x = 0x7FFFFFFF;
                for (LineInfo lineInfo : lines) {
                    try {
                        this.drawLine(this.gc, lineInfo, this.swtFlags, lineDrawRect, noDraw);
                        this.drawRect.x = Math.min(this.drawRect.x, lineInfo.outputLineStartX);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                if (this.drawRect.x == 0x7FFFFFFF) {
                    this.drawRect.x = this.printArea.x;
                }
            }
            this.drawRect.height = this.size.y;
            this.drawRect.width = this.size.x;
            this.preferredSize.y = this.size.y;
        }
        if (skipClip != false) return true;
        if (noDraw != false) return true;
        Utils.setClipping(this.gc, oldClipping);
        return true;
    }

    private LineInfo processLine(GC gc, LineInfo lineInfo, Rectangle printArea, boolean fullLinesOnly, boolean hasMoreElements, boolean isLastLine) {
        boolean b;
        if (lineInfo.originalLine.length() == 0) {
            lineInfo.lineOutputed = "";
            lineInfo.outputLineExtent = new Point(0, GCStringPrinter.stringExtent((GC)gc, (String)GOOD_STRING).y);
            lineInfo.outputLinePreferredExtent = new Point(0, lineInfo.outputLineExtent.y);
            return lineInfo;
        }
        StringBuffer outputLine = null;
        int excessPos = -1;
        boolean bl = b = this.images != null || lineInfo.originalLine.length() > 4000;
        if (!b) {
            Point outputLineExtent = GCStringPrinter.stringExtent(gc, lineInfo.originalLine);
            lineInfo.outputLinePreferredExtent = new Point(outputLineExtent.x, outputLineExtent.y);
            boolean bl2 = b = outputLineExtent.x > printArea.width;
            if (!b) {
                lineInfo.outputLineExtent = outputLineExtent;
            }
        }
        if (b) {
            outputLine = new StringBuffer();
            StringBuffer space = new StringBuffer(1);
            if (!this.wrap && this.images == null) {
                String sProcessedLine = lineInfo.originalLine.length() > 4000 ? lineInfo.originalLine.substring(0, 4000) : lineInfo.originalLine;
                excessPos = this.processWord(gc, lineInfo.originalLine, sProcessedLine, printArea, lineInfo, outputLine, space, isLastLine);
            } else {
                int posLastWordStart = 0;
                int posWordStart = lineInfo.originalLine.indexOf(32);
                while (posWordStart == 0) {
                    posWordStart = lineInfo.originalLine.indexOf(32, posWordStart + 1);
                }
                if (posWordStart < 0) {
                    posWordStart = lineInfo.originalLine.length();
                }
                int curPos = 0;
                while (posWordStart >= 0 && posLastWordStart < lineInfo.originalLine.length()) {
                    String word = lineInfo.originalLine.substring(posLastWordStart, posWordStart);
                    if (word.length() == 0) {
                        excessPos = -1;
                        outputLine.append(' ');
                    }
                    int i = 0;
                    while (i < word.length()) {
                        int endPos = i + 4000;
                        String subWord = endPos > word.length() ? word.substring(i) : word.substring(i, endPos);
                        excessPos = this.processWord(gc, lineInfo.originalLine, subWord, printArea, lineInfo, outputLine, space, isLastLine);
                        if (excessPos >= 0) {
                            excessPos += curPos;
                            break;
                        }
                        if (endPos <= word.length()) {
                            space.setLength(0);
                        }
                        curPos += subWord.length() + 1;
                        i += 4000;
                    }
                    if (excessPos >= 0) break;
                    posLastWordStart = posWordStart + 1;
                    if ((posWordStart = lineInfo.originalLine.indexOf(32, posLastWordStart)) >= 0) continue;
                    posWordStart = lineInfo.originalLine.length();
                }
            }
        }
        if (!this.wrap && hasMoreElements && excessPos >= 0) {
            int len = outputLine.length();
            if (len > 2) {
                len -= 2;
            }
            this.truncate(outputLine, len);
            this.cutoff = true;
        }
        lineInfo.excessPos = excessPos;
        lineInfo.lineOutputed = outputLine == null ? lineInfo.originalLine : outputLine.toString();
        return lineInfo;
    }

    private void truncate(StringBuffer buffer, int len) {
        if (len > 0 && Character.isHighSurrogate(buffer.charAt(len - 1))) {
            --len;
        }
        buffer.setLength(len);
        buffer.append('\u2026');
    }

    private String truncate(String str) {
        int len = str.length();
        if (len > 0 && Character.isHighSurrogate(str.charAt(len - 1))) {
            str = str.substring(0, len - 1);
        }
        return String.valueOf(str) + '\u2026';
    }

    private int processWord(GC gc, String sLine, String word, Rectangle printArea, LineInfo lineInfo, StringBuffer outputLine, StringBuffer space, boolean isLastLine) {
        if (word.length() == 0) {
            space.append(' ');
            return -1;
        }
        if (this.images != null && word.length() >= 2 && word.charAt(0) == '%') {
            int imgIdx = word.charAt(1) - 48;
            if (this.images.length > imgIdx && imgIdx >= 0 && this.images[imgIdx] != null) {
                Image img = this.images[imgIdx];
                Rectangle bounds = img.getBounds();
                if (this.imageScales != null && this.imageScales.length > imgIdx) {
                    bounds.width = (int)((float)bounds.width * this.imageScales[imgIdx]);
                    bounds.height = (int)((float)bounds.height * this.imageScales[imgIdx]);
                }
                Point spaceExtent = GCStringPrinter.stringExtent(gc, space.toString());
                int newWidth = lineInfo.outputLineExtent.x + bounds.width + spaceExtent.x;
                if (newWidth > printArea.width && (bounds.width + spaceExtent.x < printArea.width || lineInfo.outputLineExtent.x > 0)) {
                    return 0;
                }
                if (lineInfo.imageIndexes == null) {
                    lineInfo.imageIndexes = new int[]{imgIdx};
                }
                lineInfo.outputLineExtent = new Point(newWidth, Math.max(bounds.height, lineInfo.outputLineExtent.y));
                Point ptWordSize = GCStringPrinter.stringExtent(gc, String.valueOf(word.substring(2)) + " ");
                if (lineInfo.outputLineExtent.x + ptWordSize.x > printArea.width) {
                    outputLine.append(space);
                    outputLine.append(word.substring(0, 2));
                    return 2;
                }
                outputLine.append(space);
                space.setLength(0);
                outputLine.append(word.substring(0, 2));
                word = word.substring(2);
            }
            if (word.length() == 0) {
                space.append(' ');
                return -1;
            }
        }
        Point ptLineAndWordSize = GCStringPrinter.stringExtent(gc, outputLine + word + " ");
        if (ptLineAndWordSize.x > printArea.width) {
            int nextLineHeight;
            boolean nothingFit;
            boolean bWordLargerThanWidth;
            Point ptWordSize2 = GCStringPrinter.stringExtent(gc, String.valueOf(word) + " ");
            boolean bl = bWordLargerThanWidth = ptWordSize2.x > printArea.width;
            if (bWordLargerThanWidth) {
                this.isWordCut = true;
            }
            if (bWordLargerThanWidth && lineInfo.outputLineExtent.x > 0 && !isLastLine) {
                return 0;
            }
            int endIndex = word.length();
            long diff = endIndex;
            while (ptLineAndWordSize.x != printArea.width) {
                if ((diff = (diff >> 1) + diff % 2L) <= 0L) {
                    diff = 1L;
                }
                if (ptLineAndWordSize.x > printArea.width) {
                    if ((endIndex = (int)((long)endIndex - diff)) < 1) {
                        endIndex = 1;
                    }
                } else if ((endIndex = (int)((long)endIndex + diff)) > word.length()) {
                    endIndex = word.length();
                }
                ptLineAndWordSize = GCStringPrinter.stringExtent(gc, outputLine + word.substring(0, endIndex) + " ");
                if (diff <= 1L) break;
            }
            boolean bl2 = nothingFit = endIndex == 0;
            if (nothingFit) {
                endIndex = 1;
            }
            if (ptLineAndWordSize.x > printArea.width && endIndex > 1) {
                ptLineAndWordSize = GCStringPrinter.stringExtent(gc, outputLine + word.substring(0, --endIndex) + " ");
            }
            if (this.wrap && (this.printFlags & 2) != 0 && this.iCurrentHeight + ptLineAndWordSize.y + (nextLineHeight = GCStringPrinter.stringExtent((GC)gc, (String)GOOD_STRING).y) > printArea.height) {
                this.wrap = false;
            }
            if (endIndex > 0 && outputLine.length() > 0 && !nothingFit) {
                outputLine.append(space);
            }
            if (this.wrap && !nothingFit && !bWordLargerThanWidth && !isLastLine) {
                return 0;
            }
            outputLine.append(word.substring(0, endIndex));
            if (!this.wrap) {
                int len = outputLine.length();
                if (len == 0) {
                    if (word.length() > 0) {
                        outputLine.append(word.charAt(0));
                    } else if (sLine.length() > 0) {
                        outputLine.append(sLine.charAt(0));
                    }
                } else {
                    if (len > 2) {
                        len -= 2;
                    }
                    this.truncate(outputLine, len);
                    this.cutoff = true;
                }
            }
            return endIndex;
        }
        lineInfo.outputLineExtent.x = ptLineAndWordSize.x;
        if (lineInfo.outputLineExtent.x > printArea.width) {
            if (space.length() > 0) {
                space.delete(0, space.length());
            }
            if (!this.wrap) {
                int len = outputLine.length();
                if (len == 0) {
                    if (word.length() > 0) {
                        outputLine.append(word.charAt(0));
                    } else if (sLine.length() > 0) {
                        outputLine.append(sLine.charAt(0));
                    }
                } else {
                    if (len > 2) {
                        len -= 2;
                    }
                    this.truncate(outputLine, len);
                    this.cutoff = true;
                }
                return -1;
            }
            return 0;
        }
        if (outputLine.length() > 0) {
            outputLine.append(space);
        }
        outputLine.append(word);
        if (space.length() > 0) {
            space.delete(0, space.length());
        }
        space.append(' ');
        return -1;
    }

    private void drawLine(GC gc, LineInfo lineInfo, int swtFlags, Rectangle printArea, boolean noDraw) {
        String text = lineInfo.lineOutputed;
        if (lineInfo.outputLineExtent.x == 0 || lineInfo.outputLineExtent.y == 0) {
            lineInfo.outputLineExtent = GCStringPrinter.stringExtent(gc, text);
        }
        int x0 = (swtFlags & 0x20000) != 0 ? printArea.x + printArea.width - lineInfo.outputLineExtent.x : ((swtFlags & 0x1000000) != 0 ? printArea.x + (printArea.width - lineInfo.outputLineExtent.x + 1) / 2 : printArea.x);
        lineInfo.outputLineStartX = x0;
        int y0 = printArea.y;
        int lineInfoRelEndPos = lineInfo.relStartPos + lineInfo.lineOutputed.length();
        int relStartPos = lineInfo.relStartPos;
        int lineStartPos = 0;
        URLInfo urlInfo = null;
        boolean drawURL = this.hasHitUrl();
        if (drawURL) {
            URLInfo[] hitUrlInfo = this.getHitUrlInfo();
            int nextHitUrlInfoPos = 0;
            while (drawURL) {
                drawURL = false;
                int i = nextHitUrlInfoPos;
                while (i < hitUrlInfo.length) {
                    urlInfo = hitUrlInfo[i];
                    boolean bl = drawURL = urlInfo.relStartPos < lineInfoRelEndPos && urlInfo.relStartPos + urlInfo.titleLength > relStartPos && relStartPos >= lineInfo.relStartPos && relStartPos < lineInfoRelEndPos;
                    if (drawURL) {
                        nextHitUrlInfoPos = i + 1;
                        break;
                    }
                    ++i;
                }
                if (!drawURL) break;
                i = lineStartPos + urlInfo.relStartPos - relStartPos;
                if (i > 0 && i > lineStartPos && i <= text.length()) {
                    String s = text.substring(lineStartPos, i);
                    x0 += this.drawText((GC)gc, (String)s, (int)x0, (int)y0, (int)lineInfo.outputLineExtent.y, null, (boolean)noDraw, (boolean)true).x;
                    relStartPos += i - lineStartPos;
                    lineStartPos += i - lineStartPos;
                }
                int end = i + urlInfo.titleLength;
                if (i < 0) {
                    i = 0;
                }
                if (end > text.length()) {
                    end = text.length();
                }
                String s = text.substring(i, end);
                relStartPos += end - i;
                lineStartPos += end - i;
                Point pt = null;
                Color fgColor = null;
                if (!noDraw) {
                    fgColor = gc.getForeground();
                    if (urlInfo.urlColor != null) {
                        gc.setForeground(urlInfo.urlColor);
                    } else if (this.urlColor != null) {
                        gc.setForeground(this.urlColor);
                    }
                }
                if (urlInfo.hitAreas == null) {
                    urlInfo.hitAreas = new ArrayList<Rectangle>(1);
                }
                pt = this.drawText(gc, s, x0, y0, lineInfo.outputLineExtent.y, urlInfo.hitAreas, noDraw, true);
                if (!noDraw) {
                    if (urlInfo.urlUnderline) {
                        gc.drawLine(x0, y0 + pt.y - 1, x0 + pt.x - 1, y0 + pt.y - 1);
                    }
                    gc.setForeground(fgColor);
                }
                if (urlInfo.hitAreas == null) {
                    urlInfo.hitAreas = new ArrayList<Rectangle>(1);
                }
                x0 += pt.x;
            }
        }
        if (lineStartPos < text.length()) {
            String s = text.substring(lineStartPos);
            if (!noDraw) {
                this.drawText(gc, s, x0, y0, lineInfo.outputLineExtent.y, null, noDraw, false);
            }
        }
        printArea.y += lineInfo.outputLineExtent.y;
    }

    private Point drawText(GC gc, String s, int x, int y, int height, List<Rectangle> hitAreas, boolean nodraw, boolean calcExtent) {
        if (this.images != null) {
            Point textExtent;
            int pctPos = s.indexOf(37);
            int lastPos = 0;
            int w = 0;
            int h = 0;
            while (pctPos >= 0) {
                if (pctPos >= 0 && s.length() > pctPos + 1) {
                    int centerY;
                    String sStart;
                    int imgIdx = s.charAt(pctPos + 1) - 48;
                    if (imgIdx >= this.images.length || imgIdx < 0 || this.images[imgIdx] == null) {
                        sStart = s.substring(lastPos, pctPos + 1);
                        textExtent = GCStringPrinter.textExtent(gc, sStart);
                        centerY = y + (height / 2 - textExtent.y / 2);
                        if (hitAreas != null) {
                            hitAreas.add(new Rectangle(x, centerY, textExtent.x, textExtent.y));
                        }
                        if (!nodraw) {
                            GCStringPrinter.drawText(gc, sStart, x, centerY, true);
                        }
                        x += textExtent.x;
                        w += textExtent.x;
                        h = Math.max(h, textExtent.y);
                        lastPos = pctPos + 1;
                        pctPos = s.indexOf(37, pctPos + 1);
                        continue;
                    }
                    sStart = s.substring(lastPos, pctPos);
                    textExtent = GCStringPrinter.textExtent(gc, sStart);
                    centerY = y + (height / 2 - textExtent.y / 2);
                    if (!nodraw) {
                        GCStringPrinter.drawText(gc, sStart, x, centerY, true);
                    }
                    x += textExtent.x;
                    w += textExtent.x;
                    h = Math.max(h, textExtent.y);
                    if (hitAreas != null) {
                        hitAreas.add(new Rectangle(x, centerY, textExtent.x, textExtent.y));
                    }
                    Rectangle imgBounds = this.images[imgIdx].getBounds();
                    float scale = 1.0f;
                    if (this.imageScales != null && this.imageScales.length > imgIdx) {
                        scale = this.imageScales[imgIdx];
                    }
                    int scaleImageWidth = (int)((float)imgBounds.width * scale);
                    int scaleImageHeight = (int)((float)imgBounds.height * scale);
                    centerY = y + (height / 2 - scaleImageHeight / 2);
                    if (hitAreas != null) {
                        hitAreas.add(new Rectangle(x, centerY, scaleImageWidth, scaleImageHeight));
                    }
                    if (!nodraw) {
                        gc.drawImage(this.images[imgIdx], 0, 0, imgBounds.width, imgBounds.height, x, centerY, scaleImageWidth, scaleImageHeight);
                    }
                    x += scaleImageWidth;
                    w += scaleImageWidth;
                    h = Math.max(h, scaleImageHeight);
                }
                lastPos = pctPos + 2;
                pctPos = s.indexOf(37, lastPos);
            }
            if (s.length() >= lastPos) {
                String sEnd = s.substring(lastPos);
                textExtent = GCStringPrinter.textExtent(gc, sEnd);
                int centerY = y + (height / 2 - textExtent.y / 2);
                if (hitAreas != null) {
                    hitAreas.add(new Rectangle(x, centerY, textExtent.x, textExtent.y));
                }
                if (!nodraw) {
                    GCStringPrinter.drawText(gc, sEnd, x, centerY, true);
                }
                w += textExtent.x;
                h = Math.max(h, textExtent.y);
            }
            return new Point(w, h);
        }
        if (!nodraw) {
            GCStringPrinter.drawText(gc, s, x, y, true);
        }
        if (!calcExtent && hitAreas == null) {
            return null;
        }
        Point textExtent = GCStringPrinter.textExtent(gc, s);
        if (hitAreas != null) {
            hitAreas.add(new Rectangle(x, y, textExtent.x, textExtent.y));
        }
        return textExtent;
    }

    public static Point stringExtent(GC gc, String text) {
        char[] chars;
        char[] cArray = chars = text.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isHighSurrogate(c)) {
                TextLayout tl = new TextLayout(gc.getDevice());
                tl.setText(text);
                tl.setFont(gc.getFont());
                Rectangle bounds = tl.getLineBounds(0);
                tl.dispose();
                Point temp = gc.stringExtent(text);
                return new Point(bounds.width, Math.max(temp.y, bounds.height));
            }
            ++n2;
        }
        return gc.stringExtent(text);
    }

    private static Point textExtent(GC gc, String text) {
        char[] chars;
        char[] cArray = chars = text.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isHighSurrogate(c)) {
                TextLayout tl = new TextLayout(gc.getDevice());
                tl.setText(text);
                tl.setFont(gc.getFont());
                Rectangle bounds = tl.getBounds();
                tl.dispose();
                Point temp = gc.textExtent(text);
                return new Point(bounds.width, Math.max(temp.y, bounds.height));
            }
            ++n2;
        }
        return gc.textExtent(text);
    }

    private static void drawText(GC gc, String text, int x, int y, boolean transparent) {
        char[] chars;
        char[] cArray = chars = text.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isHighSurrogate(c)) {
                TextLayout tl = new TextLayout(gc.getDevice());
                tl.setText(text);
                tl.setFont(gc.getFont());
                tl.draw(gc, x, y);
                tl.dispose();
                return;
            }
            ++n2;
        }
        gc.drawText(text, x, y, transparent);
    }

    public static void main(String[] args) {
        System.out.println("main start");
        final Display display = Display.getDefault();
        final Shell shell = new Shell(display, 1264);
        try {
            SWTThread.createInstance(null);
        }
        catch (SWTThreadAlreadyInstanciatedException e) {
            e.printStackTrace();
        }
        ImageLoader imageLoader = ImageLoader.getInstance();
        final Image[] images = new Image[]{imageLoader.getImage("logo32"), imageLoader.getImage("logo64"), imageLoader.getImage("logo16"), imageLoader.getImage("logo128")};
        String text = "Apple <A HREF=\"aa\">Banana</a>, Cow <A HREF=\"ss\">Dug Ergo</a>, Flip Only. test of the string printer averlongwordthisisyesindeed \u221e";
        shell.setSize(500, 600);
        GridLayout gridLayout = new GridLayout(2, false);
        shell.setLayout((Layout)gridLayout);
        int initHeight = 67;
        Composite cButtons = new Composite((Composite)shell, 0);
        GridData gridData = new GridData(0, 4, false, true);
        cButtons.setLayoutData((Object)gridData);
        final Canvas cPaint = new Canvas((Composite)shell, 0x20000000);
        gridData = new GridData(4, 0, true, false);
        gridData.heightHint = initHeight;
        cPaint.setLayoutData((Object)gridData);
        cButtons.setLayout((Layout)new RowLayout(512));
        Listener l = new Listener(){

            public void handleEvent(Event event2) {
                cPaint.redraw();
            }
        };
        final Text txtText = new Text(cButtons, 2114);
        txtText.setText("Apple <A HREF=\"aa\">Banana</a>, Cow <A HREF=\"ss\">Dug Ergo</a>, Flip Only. test of the string printer averlongwordthisisyesindeed \u221e");
        txtText.addListener(24, l);
        txtText.setLayoutData((Object)new RowData(100, 200));
        txtText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 97 && e.stateMask == 262144) {
                    txtText.selectAll();
                }
            }
        });
        final Button btnSkipClip = new Button(cButtons, 32);
        btnSkipClip.setText("Skip Clip");
        btnSkipClip.setSelection(true);
        btnSkipClip.addListener(13, l);
        final Button btnFullOnly = new Button(cButtons, 32);
        btnFullOnly.setText("Full Lines Only");
        btnFullOnly.setSelection(true);
        btnFullOnly.addListener(13, l);
        final Combo cboVAlign = new Combo(cButtons, 8);
        cboVAlign.add("Top");
        cboVAlign.add("Bottom");
        cboVAlign.add("None");
        cboVAlign.addListener(13, l);
        cboVAlign.select(0);
        final Combo cboHAlign = new Combo(cButtons, 8);
        cboHAlign.add("Left");
        cboHAlign.add("Center");
        cboHAlign.add("Right");
        cboHAlign.add("None");
        cboHAlign.addListener(13, l);
        cboHAlign.select(0);
        final Button btnWrap = new Button(cButtons, 32);
        btnWrap.setText("Wrap");
        btnWrap.setSelection(true);
        btnWrap.addListener(13, l);
        final Button btnGCAdvanced = new Button(cButtons, 32);
        btnGCAdvanced.setText("gc.Advanced");
        btnGCAdvanced.setSelection(true);
        btnGCAdvanced.addListener(13, l);
        Spinner spinnerHeight = new Spinner(cButtons, 2048);
        spinnerHeight.setSelection(initHeight);
        spinnerHeight.addListener(13, event2 -> {
            GridData gridData1 = (GridData)cPaint.getLayoutData();
            gridData1.heightHint = spinnerHeight.getSelection();
            cPaint.setLayoutData((Object)gridData1);
            shell.layout();
        });
        final Label lblInfo = new Label((Composite)shell, 64);
        lblInfo.setLayoutData((Object)Utils.getWrappableLabelGridData(2, 0));
        lblInfo.setText("Welcome");
        Listener l2 = new Listener(){
            URLInfo lastHitInfo = null;

            public void handleEvent(Event event2) {
                boolean ourGC;
                GC gc = event2.gc;
                boolean bl = ourGC = gc == null;
                if (ourGC) {
                    gc = new GC((Drawable)cPaint);
                }
                try {
                    gc.setAdvanced(btnGCAdvanced.getSelection());
                    GCStringPrinter sp = this.buildSP(gc);
                    Color colorURL = gc.getDevice().getSystemColor(3);
                    Color colorURL2 = gc.getDevice().getSystemColor(12);
                    if (event2.type == 5) {
                        String url2;
                        Point pt = cPaint.toControl(display.getCursorLocation());
                        URLInfo hitUrl = sp.getHitUrl(pt.x, pt.y);
                        String url1 = hitUrl == null || hitUrl.url == null ? "" : hitUrl.url;
                        String string = url2 = this.lastHitInfo == null || this.lastHitInfo.url == null ? "" : this.lastHitInfo.url;
                        if (url1.equals(url2)) {
                            return;
                        }
                        cPaint.redraw();
                        this.lastHitInfo = hitUrl;
                        return;
                    }
                    try {
                        Rectangle bounds = cPaint.getClientArea();
                        Color colorBox = gc.getDevice().getSystemColor(7);
                        Color colorText = gc.getDevice().getSystemColor(2);
                        gc.setForeground(colorText);
                        Point pt = cPaint.toControl(display.getCursorLocation());
                        sp.setUrlColor(colorURL);
                        URLInfo hitUrl = sp.getHitUrl(pt.x, pt.y);
                        if (hitUrl != null) {
                            shell.setCursor(shell.getDisplay().getSystemCursor(21));
                            hitUrl.urlColor = colorURL2;
                        } else {
                            shell.setCursor(null);
                        }
                        boolean fit = sp.printString();
                        String info = fit ? "fit" : "no fit";
                        info = String.valueOf(info) + "; Calculated Size=" + sp.getCalculatedSize() + "\nDrawRect " + sp.getCalculatedDrawRect() + "\nOrig Rect " + sp.getPrintArea();
                        lblInfo.setText(info);
                        --bounds.width;
                        --bounds.height;
                        gc.setForeground(colorBox);
                        gc.drawRectangle(bounds);
                        bounds.height -= 20;
                        bounds.y += 10;
                        gc.setLineStyle(3);
                        gc.drawRectangle(bounds);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                finally {
                    if (ourGC) {
                        gc.dispose();
                    }
                }
            }

            private GCStringPrinter buildSP(GC gc) {
                int style;
                Rectangle bounds = cPaint.getClientArea();
                bounds.y += 10;
                bounds.height -= 20;
                int n = style = btnWrap.getSelection() ? 64 : 0;
                if (cboVAlign.getSelectionIndex() == 0) {
                    style |= 0x80;
                } else if (cboVAlign.getSelectionIndex() == 1) {
                    style |= 0x400;
                }
                if (cboHAlign.getSelectionIndex() == 0) {
                    style |= 0x4000;
                } else if (cboHAlign.getSelectionIndex() == 1) {
                    style |= 0x1000000;
                } else if (cboHAlign.getSelectionIndex() == 2) {
                    style |= 0x20000;
                }
                String text = txtText.getText();
                text = text.replaceAll("\r\n", "\n");
                GCStringPrinter sp = new GCStringPrinter(gc, text, bounds, btnSkipClip.getSelection(), btnFullOnly.getSelection(), style);
                sp.setImages(images);
                sp.calculateMetrics();
                return sp;
            }
        };
        cPaint.addListener(9, l2);
        cPaint.addListener(5, l2);
        shell.open();
        System.out.println("shell is open " + shell.getClientArea());
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public GCStringPrinter(GC gc, String string, Rectangle printArea, boolean skipClip, boolean fullLinesOnly, int swtFlags) {
        this.gc = gc;
        this.string = string;
        this.printArea = printArea;
        this.swtFlags = swtFlags;
        this.printFlags = 0;
        if (skipClip) {
            this.printFlags |= 1;
        }
        if (fullLinesOnly) {
            this.printFlags |= 2;
        }
    }

    public GCStringPrinter(GC gc, String string, Rectangle printArea, int printFlags, int swtFlags) {
        this.gc = gc;
        this.string = string;
        this.printArea = printArea;
        this.swtFlags = swtFlags;
        this.printFlags = printFlags;
    }

    public boolean printString() {
        return this._printString();
    }

    public boolean printString(int _printFlags) {
        int oldPrintFlags = this.printFlags;
        this.printFlags |= _printFlags;
        boolean b = this._printString();
        this.printFlags = oldPrintFlags;
        return b;
    }

    public void calculateMetrics() {
        int oldPrintFlags = this.printFlags;
        this.printFlags |= 4;
        this._printString();
        this.printFlags = oldPrintFlags;
    }

    public void printString(GC gc, Rectangle rectangle, int swtFlags) {
        this.printString2(gc, rectangle, swtFlags);
    }

    public boolean printString2(GC gc, Rectangle rectangle, int swtFlags) {
        this.gc = gc;
        int printFlags = this.printFlags;
        if (this.printArea.width == rectangle.width) {
            printFlags |= 8;
        }
        this.printArea = rectangle;
        this.swtFlags = swtFlags;
        return this.printString(printFlags);
    }

    public Point getCalculatedSize() {
        return this.size;
    }

    public Point getCalculatedPreferredSize() {
        return this.preferredSize;
    }

    public Color getUrlColor() {
        return this.urlColor;
    }

    public void setUrlColor(Color urlColor) {
        this.urlColor = urlColor;
    }

    public URLInfo getHitUrl(int x, int y) {
        if (this.listUrlInfo == null || this.listUrlInfo.size() == 0) {
            return null;
        }
        for (URLInfo urlInfo : this.listUrlInfo) {
            if (urlInfo.hitAreas == null) continue;
            for (Rectangle r : urlInfo.hitAreas) {
                if (!r.contains(x, y)) continue;
                return urlInfo;
            }
        }
        return null;
    }

    public URLInfo[] getHitUrlInfo() {
        if (this.listUrlInfo == null) {
            return new URLInfo[0];
        }
        return this.listUrlInfo.toArray(new URLInfo[0]);
    }

    public boolean hasHitUrl() {
        return this.listUrlInfo != null && this.listUrlInfo.size() > 0;
    }

    public boolean isCutoff() {
        return this.cutoff;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public void setImages(Image[] images) {
        this.images = images;
    }

    public float[] getImageScales() {
        return this.imageScales;
    }

    public void setImageScales(float[] imageScales) {
        this.imageScales = imageScales;
    }

    public String getText() {
        return this.string;
    }

    public boolean isWordCut() {
        return this.isWordCut;
    }

    public Rectangle getCalculatedDrawRect() {
        return this.drawRect;
    }

    public Rectangle getPrintArea() {
        return this.printArea;
    }

    private static class LineInfo {
        String originalLine;
        String lineOutputed;
        int excessPos;
        public int relStartPos;
        public int[] imageIndexes;
        public Point outputLineExtent = new Point(0, 0);
        public Point outputLinePreferredExtent = new Point(0, 0);
        public int outputLineStartX;

        public LineInfo(String originalLine, int relStartPos) {
            this.originalLine = originalLine;
            this.relStartPos = relStartPos;
        }

        public String toString() {
            return String.valueOf(super.toString()) + ": relStart=" + this.relStartPos + ";xcess=" + this.excessPos + ";orig=" + this.originalLine + ";output=" + this.lineOutputed;
        }
    }

    public static class URLInfo {
        public String url;
        public String text;
        public Color urlColor;
        int relStartPos;
        public List<Rectangle> hitAreas = null;
        int titleLength;
        public String fullString;
        public String title;
        public String target;
        public boolean urlUnderline;

        public String toString() {
            return String.valueOf(super.toString()) + ": relStart=" + this.relStartPos + ";url=" + this.url + ";title=" + this.text + ";hit=" + (this.hitAreas == null ? 0 : this.hitAreas.size());
        }
    }
}

