/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.ui.UIFunctionsUserPrompter;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.common.RememberedDecisionsManager;
import com.biglybt.ui.swt.BrowserWrapper;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.UISkinnableManagerSWT;
import com.biglybt.ui.swt.UISkinnableSWTListener;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BufferedLabel;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MessageBoxShell
implements UIFunctionsUserPrompter {
    public static final String STATUS_TEXT_CLOSE = "__VUZE__MessageBoxShell__CLOSE";
    private static final int MIN_SIZE_X_DEFAULT = 300;
    private static final int MIN_SIZE_Y_DEFAULT = 120;
    private static final int MAX_SIZE_X_DEFAULT = 600;
    private static final int MIN_BUTTON_SIZE = 70;
    private static int numOpen = 0;
    private Shell parent;
    private int min_size_x = 300;
    private int min_size_y = 120;
    private int max_size_x = 600;
    private final String title;
    private final String text;
    private String[] buttons;
    private Integer[] buttonVals;
    private int defaultButtonPos;
    private String rememberID = null;
    private String rememberText = null;
    private boolean rememberByDefault = false;
    private int rememberOnlyIfButtonPos = -1;
    private int autoCloseInMS = 0;
    private String html;
    private String url;
    private boolean squish;
    private boolean autoClosed = false;
    private Object[] relatedObjects;
    private Image imgLeft;
    protected Color urlColor;
    private boolean handleHTML = true;
    private Image iconImage;
    private boolean browser_follow_links;
    protected boolean isRemembered;
    private boolean supportsApplyToAll;
    private boolean applyToAll;
    private String iconImageID;
    private UserPrompterResultListener resultListener;
    private int result;
    private Listener filterListener;
    private Shell shell;
    private boolean opened;
    private boolean useTextBox;
    private String cbMessageID;
    private int cbMinUserMode;
    private boolean cbEnabled;
    private String instanceID;
    private boolean modal;
    private int explicit_style;
    private static Map<String, MessageBoxShell> mapInstances = new HashMap<String, MessageBoxShell>(1);

    public static void open(Shell parent, String title, String text, String[] buttons, int defaultOption, String rememberID, String rememberText, boolean bRememberByDefault, int autoCloseInMS, UserPrompterResultListener l) {
        MessageBoxShell messageBoxShell = new MessageBoxShell(title, text, buttons, defaultOption);
        messageBoxShell.setRemember(rememberID, bRememberByDefault, rememberText);
        messageBoxShell.setAutoCloseInMS(autoCloseInMS);
        messageBoxShell.setParent(parent);
        messageBoxShell.open(l);
    }

    public static boolean isOpen() {
        return numOpen > 0;
    }

    public MessageBoxShell(String title, String text, String[] buttons, int defaultOption) {
        this.title = title;
        this.text = text;
        this.buttons = buttons == null ? new String[]{} : buttons;
        this.defaultButtonPos = defaultOption;
    }

    @Deprecated
    public MessageBoxShell(Shell parent, String title, String text, String[] buttons, int defaultOption) {
        this(title, text, buttons, defaultOption);
        this.parent = parent;
    }

    public MessageBoxShell(String title, String text) {
        this(title, text, null, 0);
    }

    public MessageBoxShell(int style, String keyPrefix, String[] textParams) {
        if ((style & 0xFE0) == 0) {
            style |= 0x20;
        }
        Object[] buttonInfo = MessageBoxShell.swtButtonStylesToText(style);
        this.title = MessageText.getString(String.valueOf(keyPrefix) + ".title");
        this.text = MessageText.getString(String.valueOf(keyPrefix) + ".text", textParams);
        this.buttons = (String[])buttonInfo[0];
        this.defaultButtonPos = 0;
        this.rememberID = null;
        this.rememberText = null;
        this.rememberByDefault = false;
        this.autoCloseInMS = -1;
        this.buttonVals = (Integer[])buttonInfo[1];
        this.setLeftImage(style & 0x1F);
    }

    public MessageBoxShell(int style, String title, String text) {
        if ((style & 0xFE0) == 0) {
            style |= 0x20;
        }
        Object[] buttonInfo = MessageBoxShell.swtButtonStylesToText(style);
        this.title = title;
        this.text = text;
        this.buttons = (String[])buttonInfo[0];
        this.defaultButtonPos = 0;
        this.rememberID = null;
        this.rememberText = null;
        this.rememberByDefault = false;
        this.autoCloseInMS = -1;
        this.buttonVals = (Integer[])buttonInfo[1];
        this.setLeftImage(style & 0x1F);
    }

    public void setDefaultButtonUsingStyle(int defaultStyle) {
        Object[] defaultButtonInfo = MessageBoxShell.swtButtonStylesToText(defaultStyle);
        int defaultIndex = 0;
        if (defaultButtonInfo.length > 0) {
            String name = ((String[])defaultButtonInfo[0])[0];
            int i = 0;
            while (i < this.buttons.length) {
                if (this.buttons[i].equals(name)) {
                    defaultIndex = i;
                    break;
                }
                ++i;
            }
        }
        this.defaultButtonPos = defaultIndex;
    }

    @Deprecated
    public int open() {
        this.open(false);
        return this.waitUntilClosed();
    }

    @Override
    public void open(UserPrompterResultListener l) {
        this.resultListener = l;
        this.open(false);
    }

    private void triggerResultListener(final int returnVal) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                if (MessageBoxShell.this.resultListener == null) {
                    return;
                }
                int realResult = MessageBoxShell.this.getButtonVal(returnVal);
                MessageBoxShell.this.resultListener.prompterClosed(realResult);
            }
        });
    }

    private int getButtonVal(int buttonPos) {
        if (this.buttonVals == null) {
            return buttonPos;
        }
        if (buttonPos < 0 || buttonPos >= this.buttonVals.length) {
            return 256;
        }
        return this.buttonVals[buttonPos];
    }

    private int getButtonPos(int buttonVal) {
        if (this.buttonVals == null) {
            return buttonVal;
        }
        int i = 0;
        while (i < this.buttonVals.length) {
            if (this.buttonVals[i] == buttonVal) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void open(boolean useCustomShell) {
        int rememberedDecision;
        if (this.rememberID != null && (rememberedDecision = RememberedDecisionsManager.getRememberedDecision(this.rememberID)) >= 0 && (this.rememberOnlyIfButtonPos == -1 || this.rememberOnlyIfButtonPos == this.getButtonPos(rememberedDecision))) {
            this.result = this.getButtonPos(rememberedDecision);
            this.triggerResultListener(this.result);
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                MessageBoxShell.this._open();
            }
        });
    }

    private void _open() {
        Control cursorControl;
        GridData gridData;
        GridLayout gl;
        if (this.instanceID != null) {
            if (mapInstances.containsKey(this.instanceID)) {
                MessageBoxShell mb = mapInstances.get(this.instanceID);
                if (mb.shell != null && !mb.shell.isDisposed()) {
                    mb.shell.open();
                    return;
                }
            }
            mapInstances.put(this.instanceID, this);
        }
        this.result = -1;
        boolean ourParent = false;
        if (this.parent == null || this.parent.isDisposed()) {
            this.parent = Utils.findAnyShell();
            ourParent = true;
            if (this.parent == null || this.parent.isDisposed()) {
                this.triggerResultListener(this.result);
                return;
            }
        }
        final Display display = this.parent.getDisplay();
        int shell_style = 2160;
        if (this.explicit_style != 0) {
            shell_style |= this.explicit_style;
        }
        if (this.modal) {
            shell_style |= 0x10000;
        }
        this.shell = ShellFactory.createShell(this.parent, shell_style);
        if (this.title != null) {
            this.shell.setText(this.title);
        }
        this.shell.addListener(12, new Listener(){

            public void handleEvent(Event event2) {
                mapInstances.remove(MessageBoxShell.this.instanceID);
                if (MessageBoxShell.this.iconImageID != null) {
                    ImageLoader.getInstance().releaseImage(MessageBoxShell.this.iconImageID);
                }
                MessageBoxShell.this.triggerResultListener(MessageBoxShell.this.result);
                if (display != null && !display.isDisposed() && MessageBoxShell.this.filterListener != null) {
                    display.removeFilter(31, MessageBoxShell.this.filterListener);
                }
                numOpen = numOpen - 1;
            }
        });
        GridLayout gridLayout = new GridLayout();
        if (this.squish) {
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.marginLeft = 0;
            gridLayout.marginRight = 0;
            gridLayout.marginTop = 0;
            gridLayout.marginBottom = 0;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
        }
        this.shell.setLayout((Layout)gridLayout);
        Utils.setShellIcon(this.shell);
        UISkinnableSWTListener[] listeners = UISkinnableManagerSWT.getInstance().getSkinnableListeners(MessageBoxShell.class.toString());
        int i = 0;
        while (i < listeners.length) {
            listeners[i].skinBeforeComponents((Composite)this.shell, this, this.relatedObjects);
            ++i;
        }
        Shell textComposite = this.shell;
        if (this.imgLeft != null) {
            textComposite = new Composite((Composite)this.shell, 0);
            textComposite.setForeground(this.shell.getForeground());
            gl = new GridLayout(2, false);
            gl.horizontalSpacing = 10;
            textComposite.setLayout((Layout)gl);
            textComposite.setLayoutData((Object)new GridData(1808));
            Label lblImage = new Label((Composite)textComposite, 0);
            lblImage.setImage(this.imgLeft);
            lblImage.setLayoutData((Object)new GridData(2));
        } else if (!this.squish) {
            textComposite = new Composite((Composite)this.shell, 0);
            gl = new GridLayout(2, false);
            gl.marginWidth = 5;
            textComposite.setLayout((Layout)gl);
            textComposite.setLayoutData((Object)new GridData(1808));
        }
        Object linkControl = this.text != null && this.text.length() > 0 ? (this.useTextBox() ? this.createTextBox((Composite)textComposite, this.text) : this.createLinkLabel((Composite)textComposite, this.text)) : null;
        if (this.html != null && this.html.length() > 0 || this.url != null && this.url.length() > 0) {
            block44: {
                try {
                    final BrowserWrapper browser = Utils.createSafeBrowser((Composite)this.shell, 0);
                    if (this.url != null && this.url.length() > 0) {
                        browser.setUrl(this.url);
                    } else {
                        browser.setText(this.html);
                    }
                    GridData gd = new GridData(1808);
                    gd.heightHint = 200;
                    browser.getControl().setLayoutData((Object)gd);
                    browser.addProgressListener(new ProgressListener(){

                        public void completed(ProgressEvent event2) {
                            if (MessageBoxShell.this.shell == null || MessageBoxShell.this.shell.isDisposed()) {
                                return;
                            }
                            browser.addLocationListener(new LocationListener(){

                                public void changing(LocationEvent event2) {
                                    event2.doit = MessageBoxShell.this.browser_follow_links;
                                }

                                public void changed(LocationEvent event2) {
                                }
                            });
                            browser.addOpenWindowListener(new BrowserWrapper.OpenWindowListener(){

                                @Override
                                public void open(BrowserWrapper.WindowEvent event2) {
                                    event2.setRequired(true);
                                }
                            });
                        }

                        public void changed(ProgressEvent event2) {
                        }
                    });
                    browser.addStatusTextListener(new StatusTextListener(){

                        public void changed(StatusTextEvent event2) {
                            if (MessageBoxShell.STATUS_TEXT_CLOSE.equals(event2.text)) {
                                Utils.execSWTThreadLater(0, new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!browser.isDisposed() && !MessageBoxShell.this.shell.isDisposed()) {
                                            MessageBoxShell.this.shell.close();
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Debug.out(e);
                    if (this.html == null) break block44;
                    Text text = new Text((Composite)this.shell, 2120);
                    text.setText(this.html);
                    GridData gd = new GridData(1808);
                    gd.heightHint = 200;
                    text.setLayoutData((Object)gd);
                }
            }
            if (linkControl != null) {
                gridData = new GridData(768);
                linkControl.setLayoutData((Object)gridData);
            }
        } else if (linkControl != null) {
            gridData = new GridData(1808);
            linkControl.setLayoutData((Object)gridData);
        }
        if (!this.squish && (this.autoCloseInMS > 0 || this.rememberID != null || this.cbMessageID != null && Utils.getUserMode() >= this.cbMinUserMode)) {
            Label lblPadding = new Label((Composite)this.shell, 0);
            gridData = new GridData(768);
            gridData.heightHint = 5;
            lblPadding.setLayoutData((Object)gridData);
        }
        if (this.autoCloseInMS > 0) {
            final BufferedLabel lblCloseIn = new BufferedLabel((Composite)this.shell, 0x20000040);
            lblCloseIn.setForeground(this.shell.getForeground());
            gridData = new GridData(768);
            if (!this.squish) {
                gridData.horizontalIndent = 5;
            }
            lblCloseIn.setText(MessageText.getString("popup.closing.in", new String[]{String.valueOf(this.autoCloseInMS / 1000)}));
            lblCloseIn.setLayoutData(gridData);
            long endOn = SystemTime.getCurrentTime() + (long)this.autoCloseInMS;
            lblCloseIn.setData("CloseOn", new Long(endOn));
            SimpleTimer.addPeriodicEvent("autoclose", 500L, new TimerEventPerformer(){

                @Override
                public void perform(TimerEvent event2) {
                    if (MessageBoxShell.this.shell.isDisposed()) {
                        event2.cancel();
                        return;
                    }
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            if (!MessageBoxShell.this.shell.isDisposed()) {
                                boolean bDelayPaused;
                                boolean bl = bDelayPaused = lblCloseIn.getData("DelayPaused") != null;
                                if (bDelayPaused) {
                                    return;
                                }
                                long endOn = (Long)lblCloseIn.getData("CloseOn");
                                if (SystemTime.getCurrentTime() > endOn) {
                                    MessageBoxShell.this.result = MessageBoxShell.this.defaultButtonPos;
                                    MessageBoxShell.this.autoClosed = true;
                                    MessageBoxShell.this.shell.dispose();
                                } else {
                                    String sText = "";
                                    if (lblCloseIn.isDisposed()) {
                                        return;
                                    }
                                    if (!bDelayPaused) {
                                        long delaySecs = (endOn - SystemTime.getCurrentTime()) / 1000L;
                                        sText = MessageText.getString("popup.closing.in", new String[]{String.valueOf(delaySecs)});
                                    }
                                    lblCloseIn.setText(sText);
                                }
                            }
                        }
                    });
                }
            });
            SimpleTimer.addPeriodicEvent("OverPopup", 100L, new TimerEventPerformer(){
                boolean wasOver = true;
                long lEnterOn = 0L;

                @Override
                public void perform(final TimerEvent event2) {
                    if (MessageBoxShell.this.shell.isDisposed()) {
                        event2.cancel();
                        return;
                    }
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            if (MessageBoxShell.this.shell.isDisposed()) {
                                event2.cancel();
                                return;
                            }
                            boolean isOver = MessageBoxShell.this.shell.getBounds().contains(MessageBoxShell.this.shell.getDisplay().getCursorLocation());
                            if (isOver != wasOver) {
                                wasOver = isOver;
                                if (isOver) {
                                    lblCloseIn.setData("DelayPaused", "");
                                    lEnterOn = SystemTime.getCurrentTime();
                                    lblCloseIn.setText("");
                                } else {
                                    lblCloseIn.setData("DelayPaused", null);
                                    if (lEnterOn > 0L) {
                                        long diff = SystemTime.getCurrentTime() - lEnterOn;
                                        long endOn = (Long)lblCloseIn.getData("CloseOn") + diff;
                                        lblCloseIn.setData("CloseOn", new Long(endOn));
                                    }
                                }
                            }
                        }
                    });
                }
            });
        }
        boolean needSpacer = true;
        if (this.cbMessageID != null && Utils.getUserMode() >= this.cbMinUserMode) {
            needSpacer = false;
            Button cb = new Button((Composite)this.shell, 32);
            cb.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MessageBoxShell.this.cbEnabled = ((Button)e.widget).getSelection();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Messages.setLanguageText((Widget)cb, this.cbMessageID);
            cb.setSelection(this.cbEnabled);
        }
        if (this.rememberID != null) {
            Button checkRemember = new Button((Composite)this.shell, 32);
            checkRemember.setText(this.rememberText);
            checkRemember.setSelection(this.rememberByDefault);
            this.isRemembered = this.rememberByDefault;
            checkRemember.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    Button checkRemember = (Button)event2.widget;
                    MessageBoxShell.this.isRemembered = checkRemember.getSelection();
                }
            });
            checkRemember.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Button checkRemember = (Button)e.widget;
                    boolean bl = MessageBoxShell.this.isRemembered = checkRemember != null && checkRemember.getSelection();
                    if (MessageBoxShell.this.rememberID != null && MessageBoxShell.this.isRemembered && (MessageBoxShell.this.rememberOnlyIfButtonPos == -1 || MessageBoxShell.this.rememberOnlyIfButtonPos == MessageBoxShell.this.result)) {
                        RememberedDecisionsManager.setRemembered(MessageBoxShell.this.rememberID, MessageBoxShell.this.getButtonVal(MessageBoxShell.this.result));
                    }
                }
            });
        } else if (this.supportsApplyToAll) {
            Button appkyToAll = new Button((Composite)this.shell, 32);
            appkyToAll.setText(MessageText.getString("label.apply.to.all"));
            appkyToAll.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    Button button = (Button)event2.widget;
                    MessageBoxShell.this.applyToAll = button.getSelection();
                }
            });
        } else if (needSpacer) {
            Button spacer = new Button((Composite)this.shell, 32);
            spacer.setVisible(false);
        }
        if (this.buttons.length > 0) {
            Canvas line = new Canvas((Composite)this.shell, 262144);
            line.addListener(9, new Listener(){

                public void handleEvent(Event e) {
                    Rectangle clientArea = ((Canvas)e.widget).getClientArea();
                    e.gc.setForeground(Colors.getSystemColor((Device)e.display, 18));
                    e.gc.drawRectangle(clientArea);
                    ++clientArea.y;
                    e.gc.setForeground(Colors.getSystemColor((Device)e.display, 20));
                    e.gc.drawRectangle(clientArea);
                }
            });
            gridData = new GridData(768);
            gridData.heightHint = 2;
            line.setLayoutData((Object)gridData);
            Composite cButtons = new Composite((Composite)this.shell, 0);
            FormLayout layout = new FormLayout();
            cButtons.setLayout((Layout)layout);
            gridData = new GridData(128);
            cButtons.setLayoutData((Object)gridData);
            Button lastButton = null;
            Listener buttonListener = new Listener(){

                public void handleEvent(Event event2) {
                    MessageBoxShell.this.result = (Integer)event2.widget.getData();
                    MessageBoxShell.this.shell.dispose();
                }
            };
            int buttonWidth = 0;
            Button[] swtButtons = new Button[this.buttons.length];
            int i2 = 0;
            while (i2 < this.buttons.length) {
                Button button;
                swtButtons[i2] = button = new Button(cButtons, 8);
                button.setData((Object)i2);
                button.setText(this.buttons[i2]);
                button.addListener(13, buttonListener);
                FormData formData = new FormData();
                if (lastButton != null) {
                    formData.left = new FormAttachment(lastButton, 5);
                }
                button.setLayoutData((Object)formData);
                Point size = button.computeSize(-1, -1);
                if (size.x > buttonWidth) {
                    buttonWidth = size.x;
                }
                if (i2 == this.defaultButtonPos) {
                    button.setFocus();
                    this.shell.setDefaultButton(button);
                }
                lastButton = button;
                ++i2;
            }
            if (buttonWidth > 0) {
                if (buttonWidth < 70) {
                    buttonWidth = 70;
                }
                i2 = 0;
                while (i2 < this.buttons.length) {
                    Point size = swtButtons[i2].computeSize(buttonWidth, -1);
                    swtButtons[i2].setSize(size);
                    FormData formData = (FormData)swtButtons[i2].getLayoutData();
                    formData.width = buttonWidth;
                    ++i2;
                }
            }
        }
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event2) {
                if (event2.detail == 2) {
                    MessageBoxShell.this.shell.dispose();
                }
            }
        });
        this.filterListener = new Listener(){

            public void handleEvent(Event event2) {
                if (event2.detail == 64) {
                    event2.detail = 16;
                    event2.doit = true;
                } else if (event2.detail == 32) {
                    event2.detail = 8;
                    event2.doit = true;
                }
            }
        };
        display.addFilter(31, this.filterListener);
        this.shell.pack();
        Point size = this.shell.getSize();
        if (size.x < this.min_size_x) {
            size.x = this.min_size_x;
            this.shell.setSize(size);
        } else if (size.x > this.max_size_x) {
            size = this.shell.computeSize(this.max_size_x, -1);
            this.shell.setSize(size);
        }
        if (size.y < this.min_size_y) {
            size.y = this.min_size_y;
            this.shell.setSize(size);
        }
        Shell centerRelativeToShell = this.parent;
        if (ourParent && (cursorControl = display.getCursorControl()) != null) {
            centerRelativeToShell = cursorControl.getShell();
        }
        Utils.centerWindowRelativeTo(this.shell, (Control)centerRelativeToShell);
        int i3 = 0;
        while (i3 < listeners.length) {
            listeners[i3].skinAfterComponents((Composite)this.shell, this, this.relatedObjects);
            ++i3;
        }
        this.shell.open();
        this.opened = true;
        ++numOpen;
    }

    private Control createTextBox(Composite textComposite, String text2) {
        Text tb = new Text(textComposite, 2826);
        tb.setText(text2);
        return tb;
    }

    private Canvas createLinkLabel(final Composite shell, final String text) {
        final Canvas canvas = new Canvas(shell, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Rectangle area = new Rectangle(0, 0, wHint < 0 ? MessageBoxShell.this.max_size_x : wHint, 5000);
                GC gc = new GC((Drawable)this);
                GCStringPrinter sp = new GCStringPrinter(gc, text, area, true, false, 192);
                sp.calculateMetrics();
                gc.dispose();
                Point size = sp.getCalculatedSize();
                return size;
            }
        };
        Listener l = new Listener(){
            GCStringPrinter sp;

            public void handleEvent(Event e) {
                GCStringPrinter.URLInfo hitUrl;
                if (!MessageBoxShell.this.handleHTML) {
                    if (e.type == 9) {
                        Rectangle area = canvas.getClientArea();
                        e.gc.setForeground(shell.getForeground());
                        GCStringPrinter.printString(e.gc, text, area, true, false, 192);
                    }
                    return;
                }
                if (e.type == 9) {
                    Rectangle area = canvas.getClientArea();
                    this.sp = new GCStringPrinter(e.gc, text, area, true, false, 192);
                    this.sp.setUrlColor(e.gc.getDevice().getSystemColor(36));
                    if (MessageBoxShell.this.urlColor != null) {
                        this.sp.setUrlColor(MessageBoxShell.this.urlColor);
                    }
                    e.gc.setForeground(shell.getForeground());
                    this.sp.printString();
                } else if (e.type == 5) {
                    if (this.sp != null) {
                        GCStringPrinter.URLInfo hitUrl2 = this.sp.getHitUrl(e.x, e.y);
                        if (hitUrl2 != null) {
                            canvas.setCursor(canvas.getDisplay().getSystemCursor(21));
                            Utils.setTT((Control)canvas, hitUrl2.url);
                        } else {
                            canvas.setCursor(canvas.getDisplay().getSystemCursor(0));
                            Utils.setTT((Control)canvas, null);
                        }
                    }
                } else if (e.type == 4 && this.sp != null && (hitUrl = this.sp.getHitUrl(e.x, e.y)) != null && !hitUrl.url.startsWith(":")) {
                    Utils.launch(hitUrl.url);
                }
            }
        };
        canvas.addListener(9, l);
        if (this.handleHTML) {
            canvas.addListener(5, l);
            canvas.addListener(4, l);
        }
        ClipboardCopy.addCopyToClipMenu((Control)canvas, new ClipboardCopy.copyToClipProvider(){

            @Override
            public String getText() {
                return text;
            }
        });
        return canvas;
    }

    @Override
    public void setStyle(int style) {
        this.explicit_style = style;
    }

    @Override
    public String getHtml() {
        return this.html;
    }

    @Override
    public void setHtml(String html) {
        this.html = html;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    public void setSize(int width, int height) {
        this.min_size_x = width;
        this.max_size_x = width;
        this.min_size_y = height;
    }

    @Override
    public String getRememberID() {
        return this.rememberID;
    }

    @Override
    public void setRemember(String rememberID, boolean rememberByDefault, String rememberText) {
        this.rememberID = rememberID;
        this.rememberByDefault = rememberByDefault;
        this.rememberText = rememberText;
        if (this.rememberText == null) {
            this.rememberText = MessageText.getString("MessageBoxWindow.rememberdecision");
        }
    }

    @Override
    public String getRememberText() {
        return this.rememberText;
    }

    @Override
    public void setRememberText(String rememberText) {
        this.rememberText = rememberText;
    }

    @Override
    public int getAutoCloseInMS() {
        return this.autoCloseInMS;
    }

    @Override
    public void setAutoCloseInMS(int autoCloseInMS) {
        this.autoCloseInMS = autoCloseInMS;
    }

    public void setSquish(boolean b) {
        this.squish = b;
    }

    @Override
    public boolean isAutoClosed() {
        return this.autoClosed;
    }

    public void setModal(boolean m) {
        this.modal = m;
    }

    @Override
    public void setRelatedObject(Object relatedObject) {
        this.relatedObjects = new Object[]{relatedObject};
    }

    @Override
    public void setRelatedObjects(Object[] relatedObjects) {
        this.relatedObjects = relatedObjects;
    }

    public Object[] getRelatedObjects() {
        return this.relatedObjects;
    }

    public Object getLeftImage() {
        return this.imgLeft == this.iconImage ? null : this.imgLeft;
    }

    public void setLeftImage(Image imgLeft) {
        this.imgLeft = imgLeft;
    }

    public void setLeftImage(final int icon) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                MessageBoxShell.this.setLeftImage(Display.getDefault().getSystemImage(icon));
                MessageBoxShell.this.iconImage = Display.getDefault().getSystemImage(icon);
            }
        });
    }

    @Override
    public void setIconResource(String resource) {
        if (Utils.runIfNotSWTThread(() -> this.setIconResource(resource))) {
            return;
        }
        this.iconImageID = null;
        if (resource.equals("info")) {
            this.iconImage = Display.getDefault().getSystemImage(2);
        } else if (resource.equals("warning")) {
            this.iconImage = Display.getDefault().getSystemImage(8);
        } else if (resource.equals("error")) {
            this.iconImage = Display.getDefault().getSystemImage(1);
        } else {
            this.iconImage = ImageLoader.getInstance().getImage(resource);
            this.iconImageID = resource;
        }
        this.setLeftImage(this.iconImage);
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display, 1264);
        shell.open();
        MessageBoxShell messageBoxShell = new MessageBoxShell("Title", "Test\nTHis is a very long line that tests whether the box gets really wide which is something we don't want.\nA <A HREF=\"Link\">link</A> for <A HREF=\"http://moo.com\">you</a>", new String[]{"Okay", "Cancyyyyyy", "Maybe"}, 1);
        messageBoxShell.setRemember("test2", false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
        messageBoxShell.setAutoCloseInMS(15000);
        messageBoxShell.setParent(shell);
        messageBoxShell.setHtml("<b>Moo</b> goes the cow<p><hr>");
        messageBoxShell.open(new UserPrompterResultListener(){

            @Override
            public void prompterClosed(int returnVal) {
                System.out.println(returnVal);
            }
        });
        while (!shell.isDisposed()) {
            if (display.isDisposed() || display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public int getRememberOnlyIfButton() {
        return this.rememberOnlyIfButtonPos;
    }

    @Override
    public void setRememberOnlyIfButton(int rememberOnlyIfButton) {
        this.rememberOnlyIfButtonPos = rememberOnlyIfButton;
    }

    public Color getUrlColor() {
        return this.urlColor;
    }

    public void setBrowserFollowLinks(boolean follow) {
        this.browser_follow_links = follow;
    }

    public void setUrlColor(Color colorURL) {
        this.urlColor = colorURL;
    }

    public void setHandleHTML(boolean handleHTML) {
        this.handleHTML = handleHTML;
    }

    public boolean isRemembered() {
        return this.isRemembered;
    }

    @Override
    public int waitUntilClosed() {
        final AESemaphore sem = new AESemaphore("waitUntilClosed");
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                try {
                    if (MessageBoxShell.this.shell == null) {
                        return;
                    }
                    if (!MessageBoxShell.this.opened) {
                        MessageBoxShell.this.shell.open();
                    }
                    Utils.readAndDispatchLoop((Control)MessageBoxShell.this.shell);
                    return;
                }
                finally {
                    sem.releaseForever();
                }
            }
        });
        sem.reserve();
        int realResult = this.getButtonVal(this.result);
        return realResult;
    }

    public int getResult() {
        return this.result;
    }

    private static Object[] swtButtonStylesToText(int style) {
        ArrayList<String> buttons = new ArrayList<String>(2);
        ArrayList<Integer> buttonVal = new ArrayList<Integer>(2);
        int buttonCount = 0;
        if ((style & 0x20) > 0) {
            buttons.add(MessageText.getString("Button.ok"));
            buttonVal.add(32);
            ++buttonCount;
        }
        if ((style & 0x40) > 0) {
            buttons.add(MessageText.getString("Button.yes"));
            buttonVal.add(64);
            ++buttonCount;
        }
        if ((style & 0x80) > 0) {
            buttons.add(MessageText.getString("Button.no"));
            buttonVal.add(128);
            ++buttonCount;
        }
        if ((style & 0x100) > 0) {
            buttons.add(MessageText.getString("Button.cancel"));
            buttonVal.add(256);
            ++buttonCount;
        }
        if ((style & 0x200) > 0) {
            buttons.add(MessageText.getString("Button.abort"));
            buttonVal.add(512);
            ++buttonCount;
        }
        if ((style & 0x400) > 0) {
            buttons.add(MessageText.getString("Button.retry"));
            buttonVal.add(1024);
            ++buttonCount;
        }
        if ((style & 0x800) > 0) {
            buttons.add(MessageText.getString("Button.ignore"));
            buttonVal.add(2048);
            ++buttonCount;
        }
        return new Object[]{buttons.toArray(new String[buttonCount]), buttonVal.toArray(new Integer[buttonCount])};
    }

    public String[] getButtons() {
        return this.buttons;
    }

    public void setButtons(String[] buttons) {
        this.buttons = buttons;
    }

    public void setButtons(int defaltButtonPos, String[] buttons, Integer[] buttonVals) {
        this.defaultButtonPos = defaltButtonPos;
        this.buttons = buttons;
        this.buttonVals = buttonVals;
    }

    public void addCheckBox(String cbMessageID, int cbMinUserMode, boolean defaultOn) {
        this.cbMessageID = cbMessageID;
        this.cbMinUserMode = cbMinUserMode;
        this.cbEnabled = defaultOn;
    }

    public boolean getCheckBoxEnabled() {
        return this.cbEnabled;
    }

    public void setApplyToAllEnabled() {
        this.supportsApplyToAll = true;
    }

    public boolean getApplyToAll() {
        return this.applyToAll;
    }

    public Shell getParent() {
        return this.parent;
    }

    public void setParent(Shell parent) {
        this.parent = parent;
    }

    public void close() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (MessageBoxShell.this.shell != null && !MessageBoxShell.this.shell.isDisposed()) {
                    MessageBoxShell.this.shell.dispose();
                }
            }
        });
    }

    public void setUseTextBox(boolean useTextBox) {
        this.useTextBox = useTextBox;
    }

    public boolean useTextBox() {
        return this.useTextBox;
    }

    public void setLeftImage(final String id) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                MessageBoxShell.this.setLeftImage(ImageLoader.getInstance().getImage(id));
            }
        });
    }

    @Override
    public void setOneInstanceOf(String instanceID) {
        this.instanceID = instanceID;
    }
}

