/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells.main;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.category.Category;
import com.biglybt.core.category.CategoryManager;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.history.DownloadHistoryEvent;
import com.biglybt.core.history.DownloadHistoryListener;
import com.biglybt.core.history.DownloadHistoryManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.peermanager.control.PeerControlScheduler;
import com.biglybt.core.peermanager.control.PeerControlSchedulerFactory;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagManagerListener;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.TagTypeListener;
import com.biglybt.core.tracker.AllTrackersManager;
import com.biglybt.core.tracker.host.TRHost;
import com.biglybt.core.tracker.host.TRHostListener;
import com.biglybt.core.tracker.host.TRHostTorrent;
import com.biglybt.core.util.AsyncController;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadManager;
import com.biglybt.pif.download.DownloadStub;
import com.biglybt.pif.download.DownloadStubEvent;
import com.biglybt.pif.download.DownloadStubListener;
import com.biglybt.pif.sharing.ShareException;
import com.biglybt.pif.sharing.ShareManager;
import com.biglybt.pif.sharing.ShareManagerListener;
import com.biglybt.pif.sharing.ShareResource;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.menus.MenuManager;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.plugin.net.buddy.BuddyPluginBeta;
import com.biglybt.plugin.net.buddy.BuddyPluginUtils;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo2;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.biglybt.ui.mdi.MdiCloseListener;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MdiEntryCreationListener;
import com.biglybt.ui.mdi.MdiEntryCreationListener2;
import com.biglybt.ui.mdi.MdiEntryDropListener;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.devices.DeviceManagerUI;
import com.biglybt.ui.swt.mdi.MdiEntrySWT;
import com.biglybt.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.biglybt.ui.swt.pif.UISWTViewEventListener;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.plugin.net.buddy.swt.SBC_ChatOverview;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.views.ConfigShell;
import com.biglybt.ui.swt.views.ConfigView;
import com.biglybt.ui.swt.views.LoggerView;
import com.biglybt.ui.swt.views.MySharesView;
import com.biglybt.ui.swt.views.MyTrackerView;
import com.biglybt.ui.swt.views.PeersSuperView;
import com.biglybt.ui.swt.views.PieceBlocksView;
import com.biglybt.ui.swt.views.PiecesSuperView;
import com.biglybt.ui.swt.views.PiecesViewBase;
import com.biglybt.ui.swt.views.TorrentOptionsView;
import com.biglybt.ui.swt.views.clientstats.ClientStatsView;
import com.biglybt.ui.swt.views.skin.SBC_ActivityTableView;
import com.biglybt.ui.swt.views.skin.SBC_TorrentDetailsView;
import com.biglybt.ui.swt.views.skin.SB_Dashboard;
import com.biglybt.ui.swt.views.skin.SB_Discovery;
import com.biglybt.ui.swt.views.skin.SB_Transfers;
import com.biglybt.ui.swt.views.skin.SB_Vuze;
import com.biglybt.ui.swt.views.stats.StatsView;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MainMDISetup {
    private static ParameterListener configBetaEnabledListener;
    private static TRHostListener trackerHostListener;
    private static TRHostListener trackerHostListener2;
    private static SB_Dashboard sb_dashboard;
    private static SB_Transfers sb_transfers;
    private static ShareManagerListener shareManagerListener;
    private static ShareManagerListener shareManagerListener2;
    private static SB_Vuze sb_vuze;
    public static Set<String> hiddenTopLevelIDs;
    private static String[] preferredOrder;

    static {
        hiddenTopLevelIDs = new HashSet<String>();
        preferredOrder = MultipleDocumentInterface.SIDEBAR_HEADER_ORDER_DEFAULT;
        String order = COConfigurationManager.getStringParameter("Side Bar Top Level Order", "").trim();
        if (!order.isEmpty()) {
            String[] bits;
            hiddenTopLevelIDs.addAll(Arrays.asList(preferredOrder));
            ArrayList<String> newOrder = new ArrayList<String>();
            String[] stringArray = bits = order.split(",");
            int n = bits.length;
            int n2 = 0;
            while (n2 < n) {
                String bit = stringArray[n2];
                if (!(bit = bit.trim()).isEmpty()) {
                    try {
                        int pos = Integer.parseInt(bit);
                        String id = preferredOrder[pos - 1];
                        if (hiddenTopLevelIDs.remove(id)) {
                            newOrder.add(id);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            preferredOrder = newOrder.toArray(new String[newOrder.size()]);
        }
    }

    public static void setupSideBar(final MultipleDocumentInterfaceSWT mdi) {
        UIManager uim;
        mdi.setDefaultEntryID("Library");
        if (Utils.isAZ2UI()) {
            MainMDISetup.setupSidebarClassic(mdi);
        } else {
            MainMDISetup.setupSidebarVuzeUI(mdi);
        }
        SBC_TorrentDetailsView.TorrentDetailMdiEntry.register(mdi);
        configBetaEnabledListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                boolean closed;
                boolean enabled = COConfigurationManager.getBooleanParameter("Beta Programme Enabled");
                if (enabled && !(closed = COConfigurationManager.getBooleanParameter("Beta Programme Sidebar Closed"))) {
                    mdi.loadEntryByID("BetaProgramme", false);
                }
            }
        };
        COConfigurationManager.addAndFireParameterListener("Beta Programme Enabled", configBetaEnabledListener);
        final PluginInterface pi = PluginInitializer.getDefaultInterface();
        mdi.registerEntry(StatsView.VIEW_ID, id -> {
            MdiEntrySWT entry = mdi.createEntry(new UISWTViewBuilderCore(id, null, StatsView.class).setParentEntryID("header.plugins"), true);
            ViewTitleInfo title_info = new ViewTitleInfo(){

                @Override
                public Object getTitleInfoProperty(int propertyID) {
                    if (propertyID == 11) {
                        return "Stats.title.full";
                    }
                    return null;
                }
            };
            entry.setViewTitleInfo(title_info);
            entry.setImageLeftID("image.sidebar.stats2");
            return entry;
        });
        mdi.registerEntry("AllPeersView", id -> {
            UISWTViewBuilderCore builder = new UISWTViewBuilderCore(id, null, PeersSuperView.class);
            builder.setParentEntryID("header.transfers");
            builder.setPreferredAfterID(SB_Transfers.getSectionPosition(mdi, "AllPeersView"));
            final MdiEntrySWT entry = mdi.createEntry(builder, true);
            final PeerControlScheduler scheduler = PeerControlSchedulerFactory.getSingleton(0);
            final ViewTitleInfo title_info = new ViewTitleInfo(){

                @Override
                public Object getTitleInfoProperty(int propertyID) {
                    if (propertyID == 0) {
                        int[] counts = scheduler.getPeerCount();
                        return String.valueOf(counts[0]) + " | " + counts[1];
                    }
                    return null;
                }
            };
            entry.setViewTitleInfo(title_info);
            entry.setImageLeftID("image.sidebar.allpeers");
            final TimerEventPeriodic timer = SimpleTimer.addPeriodicEvent("sb:allpeers", 1000L, new TimerEventPerformer(){
                private int last_count1 = -1;
                private int last_count2 = -1;

                @Override
                public void perform(TimerEvent event2) {
                    int[] counts = scheduler.getPeerCount();
                    int c1 = counts[0];
                    int c2 = counts[1];
                    if (c1 != this.last_count1 || c2 != this.last_count2) {
                        this.last_count1 = c1;
                        this.last_count2 = c2;
                        entry.redraw();
                        ViewTitleInfoManager.refreshTitleInfo(title_info);
                        entry.redraw();
                    }
                }
            });
            entry.addListener(new MdiCloseListener(){

                @Override
                public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                    timer.cancel();
                }
            });
            return entry;
        });
        mdi.registerEntry("AllPiecesView", id -> {
            UISWTViewBuilderCore builder = new UISWTViewBuilderCore(id, null, PiecesSuperView.class);
            builder.setParentEntryID("header.transfers");
            builder.setPreferredAfterID(SB_Transfers.getSectionPosition(mdi, "AllPiecesView"));
            final MdiEntrySWT entry = mdi.createEntry(builder, true);
            final PeerControlScheduler scheduler = PeerControlSchedulerFactory.getSingleton(0);
            final ViewTitleInfo title_info = new ViewTitleInfo(){

                @Override
                public Object getTitleInfoProperty(int propertyID) {
                    if (propertyID == 0) {
                        int count;
                        int[] counts = scheduler.getPieceCount();
                        UISWTViewEventListener listener = entry.getEventListener();
                        if (listener instanceof PiecesViewBase && (count = ((PiecesViewBase)listener).getUploadingPieceCount()) >= 0) {
                            counts[1] = count;
                        }
                        return String.valueOf(counts[0]) + " | " + counts[1];
                    }
                    return null;
                }
            };
            entry.setViewTitleInfo(title_info);
            entry.setImageLeftID("image.sidebar.allpieces");
            final TimerEventPeriodic timer = SimpleTimer.addPeriodicEvent("sb:allpieces", 1000L, new TimerEventPerformer(){
                private int last_count1 = -1;
                private int last_count2 = -1;

                @Override
                public void perform(TimerEvent event2) {
                    int count;
                    int[] counts = scheduler.getPieceCount();
                    UISWTViewEventListener listener = entry.getEventListener();
                    if (listener instanceof PiecesViewBase && (count = ((PiecesViewBase)listener).getUploadingPieceCount()) >= 0) {
                        counts[1] = count;
                    }
                    int c1 = counts[0];
                    int c2 = counts[1];
                    if (c1 != this.last_count1 || c2 != this.last_count2) {
                        this.last_count1 = c1;
                        this.last_count2 = c2;
                        entry.redraw();
                        ViewTitleInfoManager.refreshTitleInfo(title_info);
                        entry.redraw();
                    }
                }
            });
            entry.addListener(new MdiCloseListener(){

                @Override
                public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                    timer.cancel();
                }
            });
            return entry;
        });
        mdi.registerEntry("AllBlocksView", id -> {
            UISWTViewBuilderCore builder = new UISWTViewBuilderCore(id, null, PieceBlocksView.class);
            builder.setParentEntryID("header.transfers");
            builder.setPreferredAfterID(SB_Transfers.getSectionPosition(mdi, "AllBlocksView"));
            builder.setInitialDatasource("");
            final MdiEntrySWT entry = mdi.createEntry(builder, true);
            final PeerControlScheduler scheduler = PeerControlSchedulerFactory.getSingleton(0);
            final ViewTitleInfo title_info = new ViewTitleInfo(){

                @Override
                public Object getTitleInfoProperty(int propertyID) {
                    if (propertyID == 5) {
                        return MessageText.getString("MainWindow.menu.view.allblocks");
                    }
                    if (propertyID == 0) {
                        int[] counts = scheduler.getPieceCount();
                        return "" + counts[0];
                    }
                    return null;
                }
            };
            entry.setViewTitleInfo(title_info);
            entry.setImageLeftID("image.sidebar.allblocks");
            final TimerEventPeriodic timer = SimpleTimer.addPeriodicEvent("sb:allblocks", 1000L, new TimerEventPerformer(){
                private int last_count1 = -1;

                @Override
                public void perform(TimerEvent event2) {
                    int[] counts = scheduler.getPieceCount();
                    int c1 = counts[0];
                    if (c1 != this.last_count1) {
                        this.last_count1 = c1;
                        entry.redraw();
                        ViewTitleInfoManager.refreshTitleInfo(title_info);
                        entry.redraw();
                    }
                }
            });
            entry.addListener(new MdiCloseListener(){

                @Override
                public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                    timer.cancel();
                }
            });
            return entry;
        });
        mdi.registerEntry("LoggerView", id -> {
            UISWTViewBuilderCore builder = new UISWTViewBuilderCore(id, null, LoggerView.class).setParentEntryID("header.plugins");
            return mdi.createEntry(builder, true);
        });
        mdi.registerEntry("TagsOverview", new MdiEntryCreationListener(){

            @Override
            public MdiEntry createMDiEntry(String id) {
                final MdiEntry entry = mdi.createEntryFromSkinRef("header.transfers", id, "tagsview", "{tags.view.heading}", null, null, true, SB_Transfers.getSectionPosition(mdi, "TagsOverview"));
                entry.setImageLeftID("image.sidebar.tag-overview");
                entry.setDefaultExpanded(true);
                final TagManager tm = TagManagerFactory.getTagManager();
                final ViewTitleInfo2 title_info = new ViewTitleInfo2(){

                    @Override
                    public Object getTitleInfoProperty(int propertyID) {
                        if (propertyID == 0) {
                            int num = 0;
                            for (TagType tt : tm.getTagTypes()) {
                                num += tt.getTagCount();
                            }
                            return String.valueOf(num);
                        }
                        return null;
                    }

                    @Override
                    public void titleInfoLinked(MultipleDocumentInterface mdi, MdiEntry mdiEntry) {
                    }

                    @Override
                    public MdiEntry getLinkedMdiEntry() {
                        return entry;
                    }
                };
                entry.setViewTitleInfo(title_info);
                final TagTypeListener ttl = new TagTypeListener(){

                    @Override
                    public void tagTypeChanged(TagType tag_type) {
                    }

                    @Override
                    public void tagEventOccurred(TagTypeListener.TagEvent event2) {
                        int type = event2.getEventType();
                        if (type == 0 || type == 2) {
                            ViewTitleInfoManager.refreshTitleInfo(title_info);
                        }
                    }
                };
                final TagManagerListener tml = new TagManagerListener(){

                    @Override
                    public void tagTypeAdded(TagManager manager, TagType tag_type) {
                        tag_type.addTagTypeListener(ttl, false);
                    }

                    @Override
                    public void tagTypeRemoved(TagManager manager, TagType tag_type) {
                    }
                };
                tm.addTagManagerListener(tml, true);
                entry.addListener(new MdiCloseListener(){

                    @Override
                    public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                        tm.removeTagManagerListener(tml);
                        for (TagType tt : tm.getTagTypes()) {
                            tt.removeTagTypeListener(ttl);
                        }
                    }
                });
                return entry;
            }
        });
        mdi.registerEntry("TagDiscovery", new MdiEntryCreationListener(){

            @Override
            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromSkinRef("TagsOverview", id, "tagdiscoveryview", "{mdi.entry.tagdiscovery}", null, null, true, null);
                entry.setImageLeftID("image.sidebar.tag-overview");
                return entry;
            }
        });
        if (BuddyPluginUtils.isBetaChatEnabled()) {
            mdi.registerEntry("ChatOverview", new MdiEntryCreationListener(){

                @Override
                public MdiEntry createMDiEntry(String id) {
                    final ViewTitleInfo title_info = new ViewTitleInfo(){

                        @Override
                        public Object getTitleInfoProperty(int propertyID) {
                            BuddyPluginBeta bp = BuddyPluginUtils.getBetaPlugin();
                            if (bp == null) {
                                return null;
                            }
                            if (propertyID == 5) {
                                return MessageText.getString("mdi.entry.chatsoverview");
                            }
                            if (propertyID == 11) {
                                return "mdi.entry.chatsoverview";
                            }
                            if (propertyID == 0) {
                                int num = 0;
                                for (BuddyPluginBeta.ChatInstance chat : bp.getChats()) {
                                    if (!chat.getMessageOutstanding()) continue;
                                    ++num;
                                }
                                if (num > 0) {
                                    return String.valueOf(num);
                                }
                                return null;
                            }
                            if (propertyID == 8) {
                                for (BuddyPluginBeta.ChatInstance chat : bp.getChats()) {
                                    if (!chat.getMessageOutstanding() || !chat.hasUnseenMessageWithNick()) continue;
                                    return SBC_ChatOverview.COLOR_MESSAGE_WITH_NICK;
                                }
                            }
                            return null;
                        }
                    };
                    final MdiEntry mdi_entry = mdi.createEntryFromSkinRef("header.discovery", "ChatOverview", "chatsview", "{mdi.entry.chatsoverview}", title_info, null, true, "Subscriptions");
                    mdi_entry.setImageLeftID("image.sidebar.chat-overview");
                    String parentID = "sidebar.ChatOverview";
                    MenuManager menu_manager = pi.getUIManager().getMenuManager();
                    final MenuItem mi = menu_manager.addMenuItem(parentID, "MainWindow.menu.view.configuration");
                    mi.setDisposeWithUIDetach("swt");
                    mi.addListener(new MenuItemListener(){

                        @Override
                        public void selected(MenuItem menu, Object target) {
                            UIFunctions uif = UIFunctionsManager.getUIFunctions();
                            if (uif != null) {
                                uif.getMDI().loadEntryByID("azbuddy", true, false, "SelectChatTab");
                            }
                        }
                    });
                    final TimerEventPeriodic timer = SimpleTimer.addPeriodicEvent("sb:chatup", 5000L, new TimerEventPerformer(){
                        private String last_text;
                        private int[] last_colour;

                        @Override
                        public void perform(TimerEvent event2) {
                            boolean changed;
                            String text = (String)title_info.getTitleInfoProperty(0);
                            int[] colour = (int[])title_info.getTitleInfoProperty(8);
                            boolean bl = changed = text != this.last_text && (text == null || this.last_text == null || !text.equals(this.last_text));
                            if (!changed) {
                                boolean bl2 = changed = colour != this.last_colour && (colour == null || this.last_colour == null || !Arrays.equals(colour, this.last_colour));
                            }
                            if (changed) {
                                this.last_text = text;
                                this.last_colour = colour;
                                mdi_entry.redraw();
                            }
                            ViewTitleInfoManager.refreshTitleInfo(title_info);
                        }
                    });
                    mdi_entry.addListener(new MdiCloseListener(){
                        boolean can_close = false;

                        @Override
                        public boolean midEntryCanClose(MdiEntry entry, boolean userClosed) {
                            if (this.can_close || !userClosed) {
                                return true;
                            }
                            String title = MessageText.getString("message.confirm.sb.close.title");
                            String text = MessageText.getString("message.confirm.sb.close.text");
                            MessageBoxShell prompter = new MessageBoxShell(title, text, new String[]{MessageText.getString("Button.cancel"), MessageText.getString("Button.ok")}, 0);
                            prompter.setAutoCloseInMS(0);
                            prompter.open(result -> {
                                if (result == 1) {
                                    this.can_close = true;
                                    List<MdiEntry> kids = mdi.getChildrenOf(mdi_entry.getViewID());
                                    for (MdiEntry k : kids) {
                                        mdi.closeEntry(k, false);
                                    }
                                    mdi.closeEntry(mdi_entry, true);
                                }
                            });
                            return false;
                        }

                        @Override
                        public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                            timer.cancel();
                            mi.remove();
                        }
                    });
                    return mdi_entry;
                }
            });
        }
        mdi.registerEntry("ArchivedDownloads", new MdiEntryCreationListener(){

            @Override
            public MdiEntry createMDiEntry(String id) {
                final DownloadManager download_manager = PluginInitializer.getDefaultInterface().getDownloadManager();
                final ViewTitleInfo title_info = new ViewTitleInfo(){

                    @Override
                    public Object getTitleInfoProperty(int propertyID) {
                        if (propertyID == 0) {
                            int num = download_manager.getDownloadStubCount();
                            return String.valueOf(num);
                        }
                        return null;
                    }
                };
                final MdiEntry entry = mdi.createEntryFromSkinRef("header.transfers", "ArchivedDownloads", "archivedlsview", "{mdi.entry.archiveddownloadsview}", title_info, null, true, SB_Transfers.getSectionPosition(mdi, "ArchivedDownloads"));
                entry.setImageLeftID("image.sidebar.archive");
                final DownloadStubListener stub_listener = new DownloadStubListener(){

                    @Override
                    public void downloadStubEventOccurred(DownloadStubEvent event2) {
                        ViewTitleInfoManager.refreshTitleInfo(title_info);
                        entry.redraw();
                    }
                };
                download_manager.addDownloadStubListener(stub_listener, false);
                entry.addListener(new MdiCloseListener(){

                    @Override
                    public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                        download_manager.removeDownloadStubListener(stub_listener);
                    }
                });
                entry.addListener(new MdiEntryDropListener(){

                    @Override
                    public boolean mdiEntryDrop(MdiEntry entry, Object data) {
                        if (data instanceof String) {
                            String str = (String)data;
                            if (str.startsWith("DownloadManager\n")) {
                                String[] bits = str.split("\n");
                                DownloadManager dm = PluginInitializer.getDefaultInterface().getDownloadManager();
                                ArrayList<Download> downloads = new ArrayList<Download>();
                                boolean failed = false;
                                int i = 1;
                                while (i < bits.length) {
                                    byte[] hash = Base32.decode(bits[i]);
                                    try {
                                        Download download = dm.getDownload(hash);
                                        if (download.canStubbify()) {
                                            downloads.add(download);
                                        } else {
                                            failed = true;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    ++i;
                                }
                                boolean f_failed = failed;
                                ManagerUtils.moveToArchive(downloads, new ManagerUtils.ArchiveCallback(f_failed){
                                    boolean error;
                                    {
                                        this.error = bl;
                                    }

                                    @Override
                                    public void failed(DownloadStub original, Throwable e) {
                                        this.error = true;
                                    }

                                    @Override
                                    public void completed() {
                                        if (this.error) {
                                            String title = MessageText.getString("archive.failed.title");
                                            String text = MessageText.getString("archive.failed.text");
                                            MessageBoxShell prompter = new MessageBoxShell(title, text, new String[]{MessageText.getString("Button.ok")}, 0);
                                            prompter.setAutoCloseInMS(0);
                                            prompter.open(null);
                                        }
                                    }
                                });
                            }
                            return true;
                        }
                        return false;
                    }
                });
                return entry;
            }
        });
        mdi.registerEntry("DownloadHistory", new MdiEntryCreationListener(){

            @Override
            public MdiEntry createMDiEntry(String id) {
                final DownloadHistoryManager history_manager = (DownloadHistoryManager)CoreFactory.getSingleton().getGlobalManager().getDownloadHistoryManager();
                final ViewTitleInfo title_info = new ViewTitleInfo(){

                    @Override
                    public Object getTitleInfoProperty(int propertyID) {
                        if (propertyID == 0) {
                            if (history_manager == null) {
                                return null;
                            }
                            if (history_manager.isEnabled()) {
                                int num = history_manager.getHistoryCount();
                                return String.valueOf(num);
                            }
                            return MessageText.getString("label.disabled");
                        }
                        return null;
                    }
                };
                MdiEntry entry = mdi.createEntryFromSkinRef("header.transfers", "DownloadHistory", "downloadhistoryview", "{mdi.entry.downloadhistoryview}", title_info, null, true, SB_Transfers.getSectionPosition(mdi, "DownloadHistory"));
                entry.setImageLeftID("image.sidebar.logview");
                if (history_manager != null) {
                    final DownloadHistoryListener history_listener = new DownloadHistoryListener(){

                        @Override
                        public void downloadHistoryEventOccurred(DownloadHistoryEvent event2) {
                            ViewTitleInfoManager.refreshTitleInfo(title_info);
                        }
                    };
                    history_manager.addListener(history_listener, false);
                    entry.addListener(new MdiCloseListener(){

                        @Override
                        public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                            history_manager.removeListener(history_listener);
                        }
                    });
                }
                return entry;
            }
        });
        mdi.registerEntry("AllTrackers", new MdiEntryCreationListener(){

            @Override
            public MdiEntry createMDiEntry(String id) {
                final AllTrackersManager.AllTrackers all_trackers = AllTrackersManager.getAllTrackers();
                final ViewTitleInfo title_info = new ViewTitleInfo(){

                    @Override
                    public Object getTitleInfoProperty(int propertyID) {
                        if (propertyID == 0) {
                            return String.valueOf(all_trackers.getTrackerCount());
                        }
                        return null;
                    }
                };
                MdiEntry entry = mdi.createEntryFromSkinRef("header.transfers", "AllTrackers", "alltrackersview", "{mdi.entry.alltrackersview}", title_info, null, true, SB_Transfers.getSectionPosition(mdi, "AllTrackers"));
                entry.setImageLeftID("image.sidebar.alltrackers");
                final AllTrackersManager.AllTrackersListener at_listener = new AllTrackersManager.AllTrackersListener(){

                    @Override
                    public void trackerEventOccurred(AllTrackersManager.AllTrackersEvent event2) {
                        int type = event2.getEventType();
                        if (type == 0 || type == 2) {
                            ViewTitleInfoManager.refreshTitleInfo(title_info);
                        }
                    }
                };
                all_trackers.addListener(at_listener, false);
                entry.addListener(new MdiCloseListener(){

                    @Override
                    public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                        all_trackers.removeListener(at_listener);
                    }
                });
                return entry;
            }
        });
        mdi.registerEntry("TorrentOptionsView", id -> {
            UISWTViewBuilderCore builder = new UISWTViewBuilderCore(id, null, TorrentOptionsView.class).setParentEntryID("header.transfers").setPreferredAfterID(SB_Transfers.getSectionPosition(mdi, id));
            MdiEntrySWT entry = mdi.createEntry(builder, true);
            entry.setImageLeftID("image.sidebar.torrentoptions");
            return entry;
        });
        mdi.registerEntry("MySharesView", id -> {
            ShareManager temp;
            try {
                temp = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getShareManager();
            }
            catch (Throwable e) {
                temp = null;
            }
            final ShareManager sm = temp;
            final ViewTitleInfo title_info = new ViewTitleInfo(){

                @Override
                public Object getTitleInfoProperty(int propertyID) {
                    if (propertyID == 0) {
                        return sm == null ? null : String.valueOf(sm.getShareCount());
                    }
                    return null;
                }
            };
            UISWTViewBuilderCore builder = new UISWTViewBuilderCore(id, null, MySharesView.class).setParentEntryID("header.transfers").setPreferredAfterID(SB_Transfers.getSectionPosition(mdi, id));
            final MdiEntrySWT entry = mdi.createEntry(builder, true);
            entry.setViewTitleInfo(title_info);
            entry.setImageLeftID("image.sidebar.myshares");
            if (sm != null) {
                shareManagerListener2 = new ShareManagerListener(){

                    @Override
                    public void resourceAdded(ShareResource resource) {
                        ViewTitleInfoManager.refreshTitleInfo(title_info);
                        entry.redraw();
                    }

                    @Override
                    public void resourceModified(ShareResource old_resource, ShareResource new_resource) {
                    }

                    @Override
                    public void resourceDeleted(ShareResource resource) {
                        ViewTitleInfoManager.refreshTitleInfo(title_info);
                        entry.redraw();
                    }

                    @Override
                    public void reportProgress(int percent_complete) {
                    }

                    @Override
                    public void reportCurrentTask(String task_description) {
                    }
                };
                sm.addListener(shareManagerListener2);
            }
            return entry;
        });
        mdi.registerEntry("MyTrackerView", id -> {
            final TRHost trackerHost = CoreFactory.getSingleton().getTrackerHost();
            UISWTViewBuilderCore builder = new UISWTViewBuilderCore(id, null, MyTrackerView.class).setParentEntryID("header.transfers").setPreferredAfterID(SB_Transfers.getSectionPosition(mdi, id));
            final MdiEntrySWT entry = mdi.createEntry(builder, true);
            entry.setImageLeftID("image.sidebar.mytracker");
            final ViewTitleInfo title_info = new ViewTitleInfo(){

                @Override
                public Object getTitleInfoProperty(int propertyID) {
                    if (propertyID == 0) {
                        return String.valueOf(trackerHost.getTorrentCount());
                    }
                    return null;
                }
            };
            entry.setViewTitleInfo(title_info);
            trackerHostListener2 = new TRHostListener(){

                @Override
                public void torrentRemoved(TRHostTorrent t) {
                    ViewTitleInfoManager.refreshTitleInfo(title_info);
                    entry.redraw();
                }

                @Override
                public void torrentChanged(TRHostTorrent t) {
                }

                @Override
                public void torrentAdded(TRHostTorrent t) {
                    ViewTitleInfoManager.refreshTitleInfo(title_info);
                    entry.redraw();
                }

                @Override
                public boolean handleExternalRequest(InetSocketAddress client_address, String user, String url, URL absolute_url, String header, InputStream is, OutputStream os, AsyncController async) throws IOException {
                    return false;
                }
            };
            trackerHost.addListener(trackerHostListener2);
            return entry;
        });
        mdi.registerEntry("ClientStatsView", id -> {
            UISWTViewBuilderCore builder = new UISWTViewBuilderCore(id, null, ClientStatsView.class).setParentEntryID("header.plugins");
            MdiEntrySWT entry = mdi.createEntry(builder, true);
            entry.setImageLeftID("image.sidebar.clientstats");
            return entry;
        });
        mdi.registerEntry("ConfigView", (mdi1, id, datasource, params) -> {
            String section;
            String string = section = datasource instanceof String ? (String)datasource : null;
            if (Utils.isAZ2UI() || COConfigurationManager.getBooleanParameter("Show Options In Side Bar")) {
                UISWTViewBuilderCore builder = new UISWTViewBuilderCore(id, null, ConfigView.class).setParentEntryID("header.plugins").setInitialDatasource(section);
                MdiEntrySWT entry = mdi.createEntry(builder, true);
                entry.setImageLeftID("image.sidebar.cog");
                return entry;
            }
            ConfigShell.getInstance().open(section);
            return null;
        });
        try {
            ShareManager share_manager;
            if (!COConfigurationManager.getBooleanParameter("my.shares.view.auto.open.done", false) && (share_manager = pi.getShareManager()).getShares().length <= 0) {
                shareManagerListener = new ShareManagerListener(){
                    boolean done = false;

                    @Override
                    public void resourceModified(ShareResource old_resource, ShareResource new_resource) {
                    }

                    @Override
                    public void resourceDeleted(ShareResource resource) {
                    }

                    @Override
                    public void resourceAdded(ShareResource resource) {
                        if (this.done) {
                            return;
                        }
                        this.done = true;
                        share_manager.removeListener(this);
                        COConfigurationManager.setParameter("my.shares.view.auto.open.done", true);
                        mdi.loadEntryByID("MySharesView", false);
                    }

                    @Override
                    public void reportProgress(int percent_complete) {
                    }

                    @Override
                    public void reportCurrentTask(String task_description) {
                    }
                };
                share_manager.addListener(shareManagerListener);
            }
        }
        catch (Throwable share_manager) {
            // empty catch block
        }
        try {
            if (!COConfigurationManager.getBooleanParameter("my.tracker.view.auto.open.done", false)) {
                final TRHost trackerHost = CoreFactory.getSingleton().getTrackerHost();
                trackerHostListener = new TRHostListener(){
                    boolean done = false;

                    @Override
                    public void torrentRemoved(TRHostTorrent t) {
                    }

                    @Override
                    public void torrentChanged(TRHostTorrent t) {
                    }

                    @Override
                    public void torrentAdded(TRHostTorrent t) {
                        if (this.done) {
                            return;
                        }
                        this.done = true;
                        trackerHost.removeListener(this);
                        COConfigurationManager.setParameter("my.tracker.view.auto.open.done", true);
                        mdi.loadEntryByID("MyTrackerView", false);
                    }

                    @Override
                    public boolean handleExternalRequest(InetSocketAddress client_address, String user, String url, URL absolute_url, String header, InputStream is, OutputStream os, AsyncController async) throws IOException {
                        return false;
                    }
                };
                trackerHost.addListener(trackerHostListener);
            }
        }
        catch (Throwable trackerHost) {
            // empty catch block
        }
        if ((uim = pi.getUIManager()) != null) {
            MenuItem menuItem = uim.getMenuManager().addMenuItem("mainmenu", "tags.view.heading");
            menuItem.setDisposeWithUIDetach("swt");
            menuItem.addListener(new MenuItemListener(){

                @Override
                public void selected(MenuItem menu, Object target) {
                    UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("TagsOverview");
                }
            });
            menuItem = uim.getMenuManager().addMenuItem("mainmenu", "tag.discovery.view.heading");
            menuItem.setDisposeWithUIDetach("swt");
            menuItem.addListener(new MenuItemListener(){

                @Override
                public void selected(MenuItem menu, Object target) {
                    UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("TagDiscovery");
                }
            });
            if (BuddyPluginUtils.isBetaChatEnabled()) {
                menuItem = uim.getMenuManager().addMenuItem("mainmenu", "chats.view.heading");
                menuItem.setDisposeWithUIDetach("swt");
                menuItem.addListener(new MenuItemListener(){

                    @Override
                    public void selected(MenuItem menu, Object target) {
                        UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("ChatOverview");
                    }
                });
            }
            menuItem = uim.getMenuManager().addMenuItem("mainmenu", "archivedlsview.view.heading");
            menuItem.setDisposeWithUIDetach("swt");
            menuItem.addListener(new MenuItemListener(){

                @Override
                public void selected(MenuItem menu, Object target) {
                    UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("ArchivedDownloads");
                }
            });
            menuItem = uim.getMenuManager().addMenuItem("mainmenu", "downloadhistoryview.view.heading");
            menuItem.setDisposeWithUIDetach("swt");
            menuItem.addListener(new MenuItemListener(){

                @Override
                public void selected(MenuItem menu, Object target) {
                    UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("DownloadHistory");
                }
            });
            menuItem = uim.getMenuManager().addMenuItem("mainmenu", "alltrackersview.view.heading");
            menuItem.setDisposeWithUIDetach("swt");
            menuItem.addListener(new MenuItemListener(){

                @Override
                public void selected(MenuItem menu, Object target) {
                    UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("AllTrackers");
                }
            });
            menuItem = uim.getMenuManager().addMenuItem("mainmenu", "MainWindow.menu.view.allpeers");
            menuItem.setDisposeWithUIDetach("swt");
            menuItem.addListener(new MenuItemListener(){

                @Override
                public void selected(MenuItem menu, Object target) {
                    UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("AllPeersView");
                }
            });
            menuItem = uim.getMenuManager().addMenuItem("mainmenu", "MainWindow.menu.view.allpieces");
            menuItem.setDisposeWithUIDetach("swt");
            menuItem.addListener(new MenuItemListener(){

                @Override
                public void selected(MenuItem menu, Object target) {
                    UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("AllPiecesView");
                }
            });
            menuItem = uim.getMenuManager().addMenuItem("mainmenu", "MainWindow.menu.view.allblocks");
            menuItem.setDisposeWithUIDetach("swt");
            menuItem.addListener(new MenuItemListener(){

                @Override
                public void selected(MenuItem menu, Object target) {
                    UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("AllBlocksView");
                }
            });
            menuItem = uim.getMenuManager().addMenuItem("mainmenu", "diskops.view.heading");
            menuItem.setDisposeWithUIDetach("swt");
            menuItem.addListener(new MenuItemListener(){

                @Override
                public void selected(MenuItem menu, Object target) {
                    UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("DiskOps");
                }
            });
        }
    }

    private static void setupSidebarClassic(final MultipleDocumentInterfaceSWT mdi) {
        mdi.registerEntry("Library", new MdiEntryCreationListener(){

            @Override
            public MdiEntry createMDiEntry(String id) {
                boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
                String title = uiClassic ? "{MyTorrentsView.mytorrents}" : "{sidebar.Library}";
                MdiEntry entry = mdi.createEntryFromSkinRef(null, "Library", "library", title, null, null, false, "");
                entry.setImageLeftID("image.sidebar.library");
                return entry;
            }
        });
        DeviceManagerUI.registerDiskOps(mdi, "header.transfers", true);
        MainMDISetup.setupCatsTags(mdi);
        sb_transfers = new SB_Transfers(mdi, false);
        sb_dashboard = new SB_Dashboard(mdi, false);
        SBC_ActivityTableView.setupSidebarEntry(mdi);
        mdi.showEntryByID("Library");
    }

    private static void setupSidebarVuzeUI(final MultipleDocumentInterfaceSWT mdi) {
        mdi.setPreferredOrder(preferredOrder);
        MainMDISetup.setupCatsTags(mdi);
        sb_dashboard = new SB_Dashboard(mdi, true);
        int i = 0;
        while (i < preferredOrder.length) {
            String id = preferredOrder[i];
            mdi.registerEntry(id, new MdiEntryCreationListener(){

                @Override
                public MdiEntry createMDiEntry(final String id) {
                    MdiEntry entry;
                    if (id.equals("header.dashboard")) {
                        entry = sb_dashboard.setupMDIEntry();
                    } else {
                        entry = mdi.createHeader(id, "sidebar." + id, null);
                        if (entry == null) {
                            return null;
                        }
                        ViewTitleInfo title_info = new ViewTitleInfo(){

                            @Override
                            public Object getTitleInfoProperty(int propertyID) {
                                if (propertyID == 11) {
                                    return "sidebar." + id;
                                }
                                if (propertyID == 5) {
                                    return MessageText.getString("sidebar." + id);
                                }
                                return null;
                            }
                        };
                        entry.setViewTitleInfo(title_info);
                        entry.setDefaultExpanded(true);
                        if (id.equals("header.plugins")) {
                            entry.addListener((parent, ch, user) -> {
                                if (mdi.getChildrenOf("header.plugins").isEmpty()) {
                                    mdi.closeEntry(parent, false);
                                }
                            });
                            PluginInterface pi = PluginInitializer.getDefaultInterface();
                            UIManager uim = pi.getUIManager();
                            MenuManager menuManager = uim.getMenuManager();
                            MenuItem menuItem = menuManager.addMenuItem("sidebar.header.plugins", "label.plugin.options");
                            menuItem.setDisposeWithUIDetach("swt");
                            menuItem.addListener(new MenuItemListener(){

                                @Override
                                public void selected(MenuItem menu, Object target) {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (uif != null) {
                                        uif.getMDI().showEntryByID("ConfigView", "plugins");
                                    }
                                }
                            });
                        }
                    }
                    return entry;
                }
            });
            ++i;
        }
        sb_transfers = new SB_Transfers(mdi, true);
        sb_vuze = new SB_Vuze(mdi);
        new SB_Discovery(mdi);
        mdi.loadEntryByID("header.dashboard", false);
        mdi.loadEntryByID("Library", false);
        if (COConfigurationManager.getBooleanParameter("Show New In Side Bar")) {
            mdi.loadEntryByID("LibraryUnopened", false);
        }
        mdi.loadEntryByID("Subscriptions", false);
        mdi.loadEntryByID("Devices", false);
        mdi.loadEntryByID("Activity", false);
    }

    private static void setupCatsTags(MultipleDocumentInterfaceSWT mdi) {
        mdi.registerEntry("Tag\\..*", new MdiEntryCreationListener2(){

            public MdiEntry createMDiEntry(MultipleDocumentInterface mdi, String id, Object datasource, Map params) {
                if (datasource instanceof Tag) {
                    Tag tag = (Tag)datasource;
                    return sb_transfers.setupTag(tag);
                }
                try {
                    TagManager tm = TagManagerFactory.getTagManager();
                    String[] bits = id.split("\\.");
                    int tag_type = Integer.parseInt(bits[1]);
                    int tag_id = Integer.parseInt(bits[2]);
                    Tag tag = tm.getTagType(tag_type).getTag(tag_id);
                    if (tag != null) {
                        return sb_transfers.setupTag(tag);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        });
        mdi.registerEntry("Cat\\..*", new MdiEntryCreationListener2(){

            public MdiEntry createMDiEntry(MultipleDocumentInterface mdi, String id, Object datasource, Map params) {
                if (datasource instanceof Category) {
                    return sb_transfers.setupCategory((Category)datasource);
                }
                try {
                    TagManager tm = TagManagerFactory.getTagManager();
                    String[] bits = id.split("\\.");
                    String cat_name = new String(Base32.decode(bits[1]));
                    Category cat = CategoryManager.getCategory(cat_name);
                    if (cat != null) {
                        return sb_transfers.setupCategory(cat);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public static SB_Transfers getSb_transfers() {
        return sb_transfers;
    }

    public static SB_Dashboard getSb_dashboard() {
        return sb_dashboard;
    }

    public static void dispose() {
        ShareManager share_manager2;
        TRHost trackerHost;
        Utils.isAZ2UI();
        if (sb_dashboard != null) {
            sb_dashboard.dispose();
            sb_dashboard = null;
        }
        if (sb_transfers != null) {
            sb_transfers.dispose();
            sb_transfers = null;
        }
        if (sb_vuze != null) {
            sb_vuze.dispose();
            sb_vuze = null;
        }
        if (trackerHostListener != null) {
            trackerHost = CoreFactory.getSingleton().getTrackerHost();
            trackerHost.removeListener(trackerHostListener);
            trackerHostListener = null;
        }
        if (trackerHostListener2 != null) {
            trackerHost = CoreFactory.getSingleton().getTrackerHost();
            trackerHost.removeListener(trackerHostListener2);
            trackerHostListener2 = null;
        }
        if (shareManagerListener != null) {
            try {
                share_manager2 = PluginInitializer.getDefaultInterface().getShareManager();
                if (share_manager2 != null) {
                    share_manager2.removeListener(shareManagerListener);
                }
                shareManagerListener = null;
            }
            catch (ShareException share_manager2) {
                // empty catch block
            }
        }
        if (shareManagerListener2 != null) {
            try {
                share_manager2 = PluginInitializer.getDefaultInterface().getShareManager();
                if (share_manager2 != null) {
                    share_manager2.removeListener(shareManagerListener2);
                }
                shareManagerListener2 = null;
            }
            catch (ShareException shareException) {
                // empty catch block
            }
        }
        if (configBetaEnabledListener != null) {
            COConfigurationManager.removeParameterListener("Beta Programme Enabled", configBetaEnabledListener);
            configBetaEnabledListener = null;
        }
    }
}

