/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells.main;

import com.biglybt.activities.ActivitiesManager;
import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.config.impl.ConfigurationChecker;
import com.biglybt.core.config.impl.ConfigurationDefaults;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerListener;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.LogRelationUtils;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AERunnableBoolean;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FeatureAvailability;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.core.versioncheck.VersionCheckClient;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.toolbar.UIToolBarItem;
import com.biglybt.pif.ui.toolbar.UIToolBarManager;
import com.biglybt.ui.IUIIntializer;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.Alerts;
import com.biglybt.ui.swt.Initializer;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.PasswordWindow;
import com.biglybt.ui.swt.TextWithHistory;
import com.biglybt.ui.swt.TrayWindow;
import com.biglybt.ui.swt.UIExitUtilsSWT;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.UISkinnableManagerSWT;
import com.biglybt.ui.swt.UISkinnableSWTListener;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.associations.AssociationChecker;
import com.biglybt.ui.swt.columns.utils.TableColumnCreatorV3;
import com.biglybt.ui.swt.components.shell.ShellManager;
import com.biglybt.ui.swt.config.wizard.ConfigureWizard;
import com.biglybt.ui.swt.debug.ObfuscateImage;
import com.biglybt.ui.swt.debug.ObfuscateShell;
import com.biglybt.ui.swt.debug.UIDebugGenerator;
import com.biglybt.ui.swt.donations.DonationWindow;
import com.biglybt.ui.swt.extlistener.StimulusRPC;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.IMainMenu;
import com.biglybt.ui.swt.mainwindow.MainStatusBar;
import com.biglybt.ui.swt.mainwindow.MenuFactory;
import com.biglybt.ui.swt.mainwindow.SWTThread;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.mdi.BaseMDI;
import com.biglybt.ui.swt.mdi.TabbedMDI;
import com.biglybt.ui.swt.minibar.AllTransfersBar;
import com.biglybt.ui.swt.minibar.MiniBarManager;
import com.biglybt.ui.swt.pifimpl.UISWTInstanceImpl;
import com.biglybt.ui.swt.search.SearchUtils;
import com.biglybt.ui.swt.sharing.progress.ProgressWindow;
import com.biglybt.ui.swt.shells.CoreWaiterSWT;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.shells.main.MainHelpers;
import com.biglybt.ui.swt.shells.main.MainMDISetup;
import com.biglybt.ui.swt.shells.main.MainMenuV3;
import com.biglybt.ui.swt.shells.main.MainWindow;
import com.biglybt.ui.swt.shells.main.UIFunctionsImpl;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinButtonUtility;
import com.biglybt.ui.swt.skin.SWTSkinFactory;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectButton;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import com.biglybt.ui.swt.skin.SWTSkinUtils;
import com.biglybt.ui.swt.speedtest.SpeedTestSelector;
import com.biglybt.ui.swt.systray.SystemTraySWT;
import com.biglybt.ui.swt.uiupdater.UIUpdaterSWT;
import com.biglybt.ui.swt.utils.DragDropUtils;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.ui.swt.utils.SWTRunnable;
import com.biglybt.ui.swt.views.QuickLinksView;
import com.biglybt.ui.swt.views.skin.WelcomeView;
import com.biglybt.ui.swt.views.skin.sidebar.SideBar;
import com.biglybt.ui.swt.views.utils.LocProvUtils;
import com.biglybt.ui.swt.welcome.WelcomeWindow;
import com.biglybt.util.MapUtils;
import com.biglybt.util.NavigationHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MainWindowImpl
implements MainWindow,
ObfuscateShell,
AEDiagnosticsEvidenceGenerator,
UIUpdatable {
    private static final LogIDs LOGID = LogIDs.GUI;
    private Shell shell;
    private Core core;
    private final IUIIntializer uiInitializer;
    private SWTSkin skin;
    private IMainMenu menu;
    private UISWTInstanceImpl uiSWTInstanceImpl;
    private UIFunctionsImpl uiFunctions;
    private SystemTraySWT systemTraySWT;
    private boolean disposedOrDisposing;
    private DownloadManager[] dms_Startup;
    private boolean isReady = false;
    private MainStatusBar statusBar;
    private String lastShellStatus = null;
    private final boolean delayedCore;
    private TrayWindow downloadBasket;
    private ParameterListener configIconBarEnabledListener;
    private ParameterListener configShowStatusInTitleListener;
    private ParameterListener configShowDLBasketListener;
    private ParameterListener configMonitorClipboardListener;
    private MainWindowGMListener gmListener;
    private NavigationHelper.navigationListener navigationListener;
    private UISkinnableSWTListener uiSkinnableSWTListener;
    private volatile boolean hide_all;
    private String last_eta_str = null;
    private long last_eta;
    private int eta_tick_count;
    private final Set<Shell> minimized_on_hide = new HashSet<Shell>();

    protected MainWindowImpl(Core core, final IUIIntializer uiInitializer) {
        this.delayedCore = false;
        this.core = core;
        this.uiInitializer = uiInitializer;
        AEDiagnostics.addWeakEvidenceGenerator(this);
        this.disposedOrDisposing = false;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                try {
                    MainWindowImpl.this.createWindow(uiInitializer);
                }
                catch (Throwable e) {
                    Logger.log(new LogAlert(false, "Error Initialize MainWindow", e));
                }
                if (uiInitializer != null) {
                    uiInitializer.abortProgress();
                }
            }
        });
        GlobalManager gm = core.getGlobalManager();
        this.dms_Startup = gm.getDownloadManagers().toArray(new DownloadManager[0]);
        this.gmListener = new MainWindowGMListener();
        gm.addListener(this.gmListener, false);
        Alerts.addListener(new MainWindowAlertListener());
    }

    protected MainWindowImpl(final IUIIntializer uiInitializer) {
        this.delayedCore = true;
        this.uiInitializer = uiInitializer;
        AEDiagnostics.addWeakEvidenceGenerator(this);
        Utils.execSWTThread(new SWTRunnable(){

            @Override
            public void runWithDisplay(Display display) {
                try {
                    MainWindowImpl.this.createWindow(uiInitializer);
                }
                catch (Throwable e) {
                    Logger.log(new LogAlert(false, "Error Initialize MainWindow", e));
                }
                Utils.readAndDispatchUntilIdle();
            }
        });
    }

    @Override
    public void init(final Core core) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                MainWindowImpl.this._init(core);
                if (MainWindowImpl.this.uiInitializer != null) {
                    MainWindowImpl.this.uiInitializer.abortProgress();
                }
            }
        });
        UIUpdaterSWT.getInstance().addUpdater(this);
    }

    @Override
    public void disposeOnlyUI() {
        MainMDISetup.dispose();
        this.isReady = false;
        UIExitUtilsSWT.uiShutdown();
        if (this.systemTraySWT != null) {
            this.systemTraySWT.dispose();
            this.systemTraySWT = null;
        }
        try {
            Control control;
            Display display = Display.getCurrent();
            if (display != null && !display.isDisposed() && (control = display.getFocusControl()) != null) {
                control.traverse(16);
            }
        }
        catch (Throwable display) {
            // empty catch block
        }
        try {
            AllTransfersBar transfer_bar;
            if (this.core != null && (transfer_bar = AllTransfersBar.getBarIfOpen(this.core.getGlobalManager())) != null) {
                transfer_bar.forceSaveLocation();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _init(Core core) {
        this.core = core;
        this.disposedOrDisposing = false;
        StimulusRPC.hookListeners(core, this);
        if (this.uiSWTInstanceImpl == null) {
            this.uiSWTInstanceImpl = new UISWTInstanceImpl();
            this.uiSWTInstanceImpl.init(this.uiInitializer);
        }
        this.postPluginSetup(core);
        GlobalManager gm = core.getGlobalManager();
        this.dms_Startup = gm.getDownloadManagers().toArray(new DownloadManager[0]);
        this.gmListener = new MainWindowGMListener();
        gm.addListener(this.gmListener, false);
        Alerts.addListener(new MainWindowAlertListener());
        core.triggerLifeCycleComponentCreated(this.uiFunctions);
        this.processStartupDMS();
    }

    private void postPluginSetup(Core core) {
        if (core == null) {
            return;
        }
        ActivitiesManager.initialize(core);
        LocProvUtils.initialise(core);
        if (!Constants.isSafeMode) {
            MainHelpers.initTransferBar();
            this.configIconBarEnabledListener = new ParameterListener(){

                @Override
                public void parameterChanged(String parameterName) {
                    MainWindowImpl.this.setVisible(2, COConfigurationManager.getBooleanParameter(parameterName));
                }
            };
            COConfigurationManager.addAndFireParameterListener("IconBar.enabled", this.configIconBarEnabledListener);
        }
        new ProgressWindow(Utils.getDisplay());
    }

    private void processStartupDMS() {
        AEThread2 thread = new AEThread2("v3.mw.dmAdded", true){

            @Override
            public void run() {
                long startTime = SystemTime.getCurrentTime();
                if (MainWindowImpl.this.dms_Startup == null || MainWindowImpl.this.dms_Startup.length == 0) {
                    MainWindowImpl.this.dms_Startup = null;
                    return;
                }
                MainWindowImpl.downloadAdded(MainWindowImpl.this.dms_Startup, false);
                MainWindowImpl.this.dms_Startup = null;
                System.out.println("psDMS " + (SystemTime.getCurrentTime() - startTime) + "ms");
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    private static void downloadAdded(DownloadManager[] dms, boolean allowDonationCheck) {
        boolean oneIsNotLowNoiseOrPersistent = false;
        DownloadManager[] downloadManagerArray = dms;
        int n = dms.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadManager dm = downloadManagerArray[n2];
            if (dm != null) {
                DownloadManagerState dmState = dm.getDownloadState();
                TOTorrent torrent = dm.getTorrent();
                if (torrent != null) {
                    int pfi = PlatformTorrentUtils.getContentPrimaryFileIndex(torrent);
                    if (pfi >= 0) {
                        dmState.setIntAttribute("primaryfileidx", pfi);
                    }
                    if (!oneIsNotLowNoiseOrPersistent && !dmState.getFlag(16L) && dm.isPersistent()) {
                        oneIsNotLowNoiseOrPersistent = true;
                    }
                }
            }
            ++n2;
        }
        if (oneIsNotLowNoiseOrPersistent && allowDonationCheck) {
            DonationWindow.checkForDonationPopup();
        }
    }

    private void createWindow(IUIIntializer uiInitializer) {
        block24: {
            long startTime = SystemTime.getCurrentTime();
            UIFunctionsSWT existing_uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
            this.uiFunctions = new UIFunctionsImpl(this);
            UIFunctionsManager.setUIFunctions(this.uiFunctions);
            Utils.disposeComposite((Composite)this.shell);
            this.increaseProgress(uiInitializer, "splash.initializeGui");
            System.out.println("UIFunctions/ImageLoad took " + (SystemTime.getCurrentTime() - startTime) + "ms");
            startTime = SystemTime.getCurrentTime();
            Shell shell = this.shell = existing_uif == null ? new Shell(Utils.getDisplay(), 1264) : existing_uif.getMainShell();
            if (Constants.isWindows) {
                try {
                    Class<?> ehancerClass = Class.forName("com.biglybt.ui.swt.win32.Win32UIEnhancer");
                    Method method = ehancerClass.getMethod("initMainShell", Shell.class);
                    method.invoke(null, this.shell);
                }
                catch (Exception e) {
                    Debug.outNoStack(Debug.getCompressedStackTrace(e, 0, 30), true);
                }
            }
            try {
                try {
                    this.shell.setData("class", (Object)this);
                    this.shell.setText(UIFunctions.MAIN_WINDOW_NAME);
                    Utils.setShellIcon(this.shell);
                    Utils.linkShellMetricsToConfig(this.shell, "window");
                    System.out.println("new shell took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    this.skin = SWTSkinFactory.getInstance();
                    if (Utils.isAZ2UI()) {
                        SWTSkinProperties skinProperties = this.skin.getSkinProperties();
                        String skinPath = "com/biglybt/ui/skin/skin3_classic";
                        ResourceBundle rb = ResourceBundle.getBundle(skinPath);
                        skinProperties.addResourceBundle(rb, skinPath);
                    }
                    this.uiFunctions.setSkin(this.skin);
                    System.out.println("new shell setup took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.initSkinListeners();
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    String startID = Utils.isAZ2UI() ? "classic.shell" : "main.shell";
                    this.skin.initialize((Composite)this.shell, startID, uiInitializer);
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    System.out.println("skin init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.menu = this.uiFunctions.createMainMenu(this.shell);
                    this.shell.setData("MainMenu", (Object)this.menu);
                    System.out.println("MainMenu init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    this.skin.layout();
                    try {
                        DragDropUtils.createTorrentDropTarget((Composite)this.shell, false);
                    }
                    catch (Throwable e) {
                        Logger.log(new LogEvent(LOGID, "Drag and Drop not available", e));
                    }
                    this.shell.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            if (MainWindowImpl.this.configIconBarEnabledListener != null) {
                                COConfigurationManager.removeParameterListener("IconBar.enabled", MainWindowImpl.this.configIconBarEnabledListener);
                            }
                            if (MainWindowImpl.this.configShowStatusInTitleListener != null) {
                                COConfigurationManager.removeParameterListener("Show Status In Window Title", MainWindowImpl.this.configShowStatusInTitleListener);
                            }
                            if (MainWindowImpl.this.configShowDLBasketListener != null) {
                                COConfigurationManager.removeParameterListener("Show Download Basket", MainWindowImpl.this.configShowDLBasketListener);
                            }
                            if (MainWindowImpl.this.configMonitorClipboardListener != null) {
                                COConfigurationManager.removeParameterListener("Monitor Clipboard For Torrents", MainWindowImpl.this.configMonitorClipboardListener);
                            }
                            if (MainWindowImpl.this.gmListener != null) {
                                GlobalManager gm = MainWindowImpl.this.core.getGlobalManager();
                                if (gm != null) {
                                    gm.removeListener(MainWindowImpl.this.gmListener);
                                }
                                MainWindowImpl.this.gmListener = null;
                            }
                            if (MainWindowImpl.this.uiFunctions != null) {
                                MainWindowImpl.this.uiFunctions.dispose();
                            }
                            if (MainWindowImpl.this.navigationListener != null) {
                                NavigationHelper.removeListener(MainWindowImpl.this.navigationListener);
                                MainWindowImpl.this.navigationListener = null;
                            }
                            StimulusRPC.unhookListeners();
                            UISkinnableManagerSWT skinnableManagerSWT = UISkinnableManagerSWT.getInstance();
                            skinnableManagerSWT.removeSkinnableListener(MessageBoxShell.class.toString(), MainWindowImpl.this.uiSkinnableSWTListener);
                        }
                    });
                    this.shell.addShellListener((ShellListener)new ShellAdapter(){

                        public void shellClosed(ShellEvent event2) {
                            if (MainWindowImpl.this.disposedOrDisposing) {
                                return;
                            }
                            if (COConfigurationManager.getBooleanParameter("Close To Tray") && (MainWindowImpl.this.systemTraySWT != null && COConfigurationManager.getBooleanParameter("Enable System Tray") || COConfigurationManager.getBooleanParameter("System Tray Disabled Override"))) {
                                MainWindowImpl.this.minimizeToTray(event2);
                            } else {
                                MainWindowImpl.this.dispose(false);
                                event2.doit = false;
                            }
                        }

                        public void shellActivated(ShellEvent e) {
                            Shell shellAppModal = Utils.findFirstShellWithStyle(65536);
                            if (shellAppModal != null) {
                                shellAppModal.forceActive();
                            } else {
                                MainWindowImpl.this.shell.forceActive();
                            }
                        }

                        public void shellIconified(ShellEvent event2) {
                            if (MainWindowImpl.this.disposedOrDisposing) {
                                return;
                            }
                            Utils.setUIVisible(false);
                            if (COConfigurationManager.getBooleanParameter("Minimize To Tray") && (MainWindowImpl.this.systemTraySWT != null && COConfigurationManager.getBooleanParameter("Enable System Tray") || COConfigurationManager.getBooleanParameter("System Tray Disabled Override"))) {
                                MainWindowImpl.this.minimizeToTray(event2);
                            }
                        }

                        public void shellDeiconified(ShellEvent e) {
                            Utils.setUIVisible(true);
                            if (Constants.isOSX && COConfigurationManager.getBooleanParameter("Password enabled")) {
                                MainWindowImpl.this.shell.setVisible(false);
                                if (PasswordWindow.showPasswordWindow(Utils.getDisplay())) {
                                    MainWindowImpl.this.shell.setVisible(true);
                                }
                            }
                        }
                    });
                    Utils.getDisplay().addFilter(1, new Listener(){

                        public void handleEvent(Event event2) {
                            if (event2.keyCode == 0x1000012) {
                                event2.doit = false;
                                event2.keyCode = 0;
                                event2.character = '\u0000';
                                MainWindowImpl.this.flipVisibility(9);
                                return;
                            }
                            Control focus_control = event2.display.getFocusControl();
                            if (focus_control != null && focus_control.getShell() != MainWindowImpl.this.shell) {
                                return;
                            }
                            int key = event2.character;
                            if ((event2.stateMask & SWT.MOD1) != 0 && event2.character <= '\u001a' && event2.character > '\u0000') {
                                key += 96;
                            }
                            if (key == 108 && (event2.stateMask & SWT.MOD1) != 0) {
                                if (MainWindowImpl.this.core == null) {
                                    return;
                                }
                                GlobalManager gm = MainWindowImpl.this.core.getGlobalManager();
                                if (gm != null) {
                                    UIFunctionsManagerSWT.getUIFunctionsSWT().openTorrentWindow();
                                    event2.doit = false;
                                }
                            } else if (key == 100 && (event2.stateMask & SWT.MOD1) != 0) {
                                if (Constants.isCVSVersion()) {
                                    Utils.dump((Control)MainWindowImpl.this.shell);
                                }
                            } else if (key == 102 && (event2.stateMask & SWT.MOD1 + 131072) == SWT.MOD1 + 131072) {
                                MainWindowImpl.this.shell.setFullScreen(!MainWindowImpl.this.shell.getFullScreen());
                            } else if (event2.keyCode == 0x100000A) {
                                Utils.launch("https://wiki.biglybt.com/");
                            }
                        }
                    });
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    System.out.println("pre skin widgets init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    if (this.core != null) {
                        StimulusRPC.hookListeners(this.core, this);
                    }
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    BaseMDI mdi = this.initMDI();
                    System.out.println("skin widgets (1/2) init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.initWidgets2(mdi);
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    System.out.println("skin widgets (2/2) init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    System.out.println("pre SWTInstance init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    this.increaseProgress(uiInitializer, "v3.splash.hookPluginUI");
                    startTime = SystemTime.getCurrentTime();
                    TableColumnCreatorV3.initCoreColumns();
                    System.out.println("Init Core Columns took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    this.increaseProgress(uiInitializer, "v3.splash.hookPluginUI");
                    startTime = SystemTime.getCurrentTime();
                    this.uiSWTInstanceImpl = new UISWTInstanceImpl();
                    this.uiSWTInstanceImpl.init(uiInitializer);
                    System.out.println("SWTInstance init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    this.increaseProgress(uiInitializer, "splash.initializeGui");
                    startTime = SystemTime.getCurrentTime();
                }
                catch (Throwable t) {
                    Debug.out(t);
                    String configID = "pluginbar.visible";
                    if (!ConfigurationDefaults.getInstance().doesParameterDefaultExist(configID)) {
                        COConfigurationManager.setBooleanDefault(configID, true);
                    }
                    this.setVisible(4, COConfigurationManager.getBooleanParameter(configID) && COConfigurationManager.getIntParameter("User Mode") > 1);
                    if (!Utils.isAZ2UI()) {
                        this.setVisible(9, COConfigurationManager.getBooleanParameter("rightbar.visible"));
                    }
                    this.setVisible(2, COConfigurationManager.getBooleanParameter("IconBar.enabled"));
                    this.shell.layout(true, true);
                    System.out.println("shell.layout took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.showMainWindow();
                    this.increaseProgress(uiInitializer, "splash.initializeGui");
                    System.out.println("shell.open took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.processStartupDMS();
                    System.out.println("processStartupDMS took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    if (this.core != null) {
                        this.postPluginSetup(this.core);
                    }
                    System.out.println("postPluginSetup init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.navigationListener = new NavigationHelper.navigationListener(){

                        @Override
                        public void processCommand(final int type, final String[] args) {
                            Utils.execSWTThread(new AERunnable(){

                                @Override
                                public void runSupport() {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (type == 1) {
                                        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                                        if (mdi == null) {
                                            return;
                                        }
                                        mdi.showEntryByID(args[0]);
                                        if (uif != null) {
                                            uif.bringToFront();
                                        }
                                    }
                                }
                            });
                        }
                    };
                    NavigationHelper.addListener(this.navigationListener);
                    if (!Constants.isOSX) {
                        this.configShowStatusInTitleListener = new ParameterListener(){
                            private TimerEventPeriodic timer;
                            private String old_text;
                            private String my_last_text;

                            @Override
                            public void parameterChanged(final String name) {
                                Utils.execSWTThread(new AERunnable(){

                                    @Override
                                    public void runSupport() {
                                        boolean enable = COConfigurationManager.getBooleanParameter(name);
                                        if (enable) {
                                            if (timer == null) {
                                                timer = SimpleTimer.addPeriodicEvent("window.title.updater", 1000L, new TimerEventPerformer(){

                                                    @Override
                                                    public void perform(TimerEvent event2) {
                                                        Utils.execSWTThread(new AERunnable(){

                                                            @Override
                                                            public void runSupport() {
                                                                String txt;
                                                                if (MainWindowImpl.this.shell.isDisposed()) {
                                                                    return;
                                                                }
                                                                String current_txt = MainWindowImpl.this.shell.getText();
                                                                if (current_txt != null && !current_txt.equals(my_last_text)) {
                                                                    old_text = current_txt;
                                                                }
                                                                if ((txt = MainWindowImpl.this.getCurrentTitleText()) != null) {
                                                                    if (!txt.equals(current_txt)) {
                                                                        MainWindowImpl.this.shell.setText(txt);
                                                                    }
                                                                    my_last_text = txt;
                                                                }
                                                            }
                                                        });
                                                    }
                                                });
                                            }
                                        } else {
                                            if (timer != null) {
                                                timer.cancel();
                                                timer = null;
                                            }
                                            if (old_text != null && !MainWindowImpl.this.shell.isDisposed()) {
                                                MainWindowImpl.this.shell.setText(old_text);
                                            }
                                        }
                                    }
                                });
                            }
                        };
                        COConfigurationManager.addAndFireParameterListener("Show Status In Window Title", this.configShowStatusInTitleListener);
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                String configID = "pluginbar.visible";
                if (!ConfigurationDefaults.getInstance().doesParameterDefaultExist(configID)) {
                    COConfigurationManager.setBooleanDefault(configID, true);
                }
                this.setVisible(4, COConfigurationManager.getBooleanParameter(configID) && COConfigurationManager.getIntParameter("User Mode") > 1);
                if (!Utils.isAZ2UI()) {
                    this.setVisible(9, COConfigurationManager.getBooleanParameter("rightbar.visible"));
                }
                this.setVisible(2, COConfigurationManager.getBooleanParameter("IconBar.enabled"));
                this.shell.layout(true, true);
                System.out.println("shell.layout took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                startTime = SystemTime.getCurrentTime();
                this.showMainWindow();
                this.increaseProgress(uiInitializer, "splash.initializeGui");
                System.out.println("shell.open took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                startTime = SystemTime.getCurrentTime();
                this.processStartupDMS();
                System.out.println("processStartupDMS took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                startTime = SystemTime.getCurrentTime();
                if (this.core != null) {
                    this.postPluginSetup(this.core);
                }
                System.out.println("postPluginSetup init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                startTime = SystemTime.getCurrentTime();
                this.navigationListener = new /* invalid duplicate definition of identical inner class */;
                NavigationHelper.addListener(this.navigationListener);
                if (!Constants.isOSX) {
                    this.configShowStatusInTitleListener = new /* invalid duplicate definition of identical inner class */;
                    COConfigurationManager.addAndFireParameterListener("Show Status In Window Title", this.configShowStatusInTitleListener);
                }
                throw throwable;
            }
            String configID = "pluginbar.visible";
            if (!ConfigurationDefaults.getInstance().doesParameterDefaultExist(configID)) {
                COConfigurationManager.setBooleanDefault(configID, true);
            }
            this.setVisible(4, COConfigurationManager.getBooleanParameter(configID) && COConfigurationManager.getIntParameter("User Mode") > 1);
            if (!Utils.isAZ2UI()) {
                this.setVisible(9, COConfigurationManager.getBooleanParameter("rightbar.visible"));
            }
            this.setVisible(2, COConfigurationManager.getBooleanParameter("IconBar.enabled"));
            this.shell.layout(true, true);
            System.out.println("shell.layout took " + (SystemTime.getCurrentTime() - startTime) + "ms");
            startTime = SystemTime.getCurrentTime();
            this.showMainWindow();
            this.increaseProgress(uiInitializer, "splash.initializeGui");
            System.out.println("shell.open took " + (SystemTime.getCurrentTime() - startTime) + "ms");
            startTime = SystemTime.getCurrentTime();
            this.processStartupDMS();
            System.out.println("processStartupDMS took " + (SystemTime.getCurrentTime() - startTime) + "ms");
            startTime = SystemTime.getCurrentTime();
            if (this.core != null) {
                this.postPluginSetup(this.core);
            }
            System.out.println("postPluginSetup init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
            startTime = SystemTime.getCurrentTime();
            this.navigationListener = new /* invalid duplicate definition of identical inner class */;
            NavigationHelper.addListener(this.navigationListener);
            if (!Constants.isOSX) {
                this.configShowStatusInTitleListener = new /* invalid duplicate definition of identical inner class */;
                COConfigurationManager.addAndFireParameterListener("Show Status In Window Title", this.configShowStatusInTitleListener);
            }
        }
    }

    private String getCurrentTitleText() {
        if (this.core == null) {
            return null;
        }
        GlobalManager gm = this.core.getGlobalManager();
        if (gm == null) {
            return null;
        }
        GlobalManagerStats stats2 = gm.getStats();
        int down = stats2.getDataReceiveRate() + stats2.getProtocolReceiveRate();
        int up = stats2.getDataSendRate() + stats2.getProtocolSendRate();
        ++this.eta_tick_count;
        String eta_str = this.last_eta_str;
        if (eta_str == null || this.last_eta < 120L || this.eta_tick_count % 10 == 0) {
            long min_eta = Long.MAX_VALUE;
            int num_downloading = 0;
            List<DownloadManager> dms = gm.getDownloadManagers();
            for (DownloadManager dm : dms) {
                if (dm.getState() != 50) continue;
                ++num_downloading;
                long dm_eta = dm.getStats().getSmoothedETA();
                if (dm_eta >= min_eta) continue;
                min_eta = dm_eta;
            }
            if (min_eta == Long.MAX_VALUE) {
                min_eta = 1827387392L;
            }
            this.last_eta = min_eta;
            this.last_eta_str = num_downloading == 0 ? "" : DisplayFormatters.formatETA(min_eta);
            eta_str = this.last_eta_str;
        }
        String down_str = this.formatRateCompact(down);
        String up_str = this.formatRateCompact(up);
        StringBuilder result = new StringBuilder(50);
        result.append(MessageText.getString("ConfigView.download.abbreviated"));
        result.append(" ");
        result.append(down_str);
        result.append(" ");
        result.append(MessageText.getString("ConfigView.upload.abbreviated"));
        result.append(" ");
        result.append(up_str);
        if (eta_str.length() > 0) {
            result.append(" ");
            result.append(MessageText.getString("ConfigView.eta.abbreviated"));
            result.append(" ");
            result.append(eta_str);
        }
        return result.toString();
    }

    private String formatRateCompact(int rate) {
        String[] bits;
        String str = DisplayFormatters.formatCustomRate("title.rate", rate);
        if (str == null && (bits = (str = DisplayFormatters.formatByteCountToKiBEtc(rate, false, true, 2, 1)).split(" ")).length == 2) {
            String sep = String.valueOf(DisplayFormatters.getDecimalSeparator());
            String num = bits[0];
            String unit = bits[1];
            int num_len = num.length();
            if (num_len < 4) {
                if (!num.contains(sep)) {
                    num = String.valueOf(num) + sep;
                    ++num_len;
                }
                while (num_len < 4) {
                    num = String.valueOf(num) + "0";
                    ++num_len;
                }
            } else if (num_len > 4) {
                num = num.substring(0, 4);
                num_len = 4;
            }
            if (num.endsWith(sep)) {
                num = String.valueOf(num.substring(0, num_len - 1)) + " ";
            }
            str = String.valueOf(num) + " " + unit.charAt(0);
        }
        return str;
    }

    private void increaseProgress(IUIIntializer uiInitializer, String taskKey) {
        if (uiInitializer != null) {
            uiInitializer.increaseProgress();
            if (taskKey != null) {
                uiInitializer.reportCurrentTask(MessageText.getString(taskKey));
            }
        }
    }

    @Override
    public boolean dispose(final boolean for_restart) {
        if (this.disposedOrDisposing) {
            return true;
        }
        Boolean b = Utils.execSWTThreadWithBool("v3.MainWindow.dispose", new AERunnableBoolean(){

            @Override
            public boolean runSupport() {
                return MainWindowImpl.this._dispose(for_restart);
            }
        }, 0L);
        return b == null || b != false;
    }

    boolean _dispose(final boolean bForRestart) {
        if (this.disposedOrDisposing) {
            return true;
        }
        this.disposedOrDisposing = true;
        if (this.core != null && !UIExitUtilsSWT.canClose(this.core.getGlobalManager(), bForRestart)) {
            this.disposedOrDisposing = false;
            return false;
        }
        this.disposeOnlyUI();
        SWTThread instance = SWTThread.getInstance();
        if (instance != null && !instance.isTerminated()) {
            Utils.getOffOfSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    SWTThread instance = SWTThread.getInstance();
                    if (instance != null && !instance.isTerminated()) {
                        instance.getInitializer().stopIt(bForRestart);
                    }
                }
            });
        }
        return true;
    }

    private void showMainWindow() {
        this.configShowDLBasketListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                MainWindowImpl.this.configureDownloadBasket();
            }
        };
        COConfigurationManager.addAndFireParameterListener("Show Download Basket", this.configShowDLBasketListener);
        boolean isOSX = Constants.isOSX;
        boolean bEnableTray = COConfigurationManager.getBooleanParameter("Enable System Tray");
        boolean bPassworded = COConfigurationManager.getBooleanParameter("Password enabled");
        boolean bStartMinimize = bEnableTray && (bPassworded || COConfigurationManager.getBooleanParameter("Start Minimized"));
        SWTSkinObject soMain = this.skin.getSkinObject("main");
        if (soMain != null) {
            soMain.getControl().setVisible(true);
        }
        this.shell.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                System.out.println("---------SHOWN AT " + SystemTime.getCurrentTime() + ";" + (SystemTime.getCurrentTime() - Initializer.startTime) + "ms");
                if (MainWindowImpl.this.statusBar != null) {
                    Utils.execSWTThreadLater(10, new Runnable(){

                        @Override
                        public void run() {
                            MainWindowImpl.this.statusBar.relayout();
                        }
                    });
                }
                ShellManager.sharedManager().performForShells(new Listener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleEvent(Event event2) {
                        Shell this_shell = (Shell)event2.widget;
                        if (this_shell.getParent() == null && !this_shell.isVisible()) {
                            boolean minimize;
                            Set set = MainWindowImpl.this.minimized_on_hide;
                            synchronized (set) {
                                minimize = MainWindowImpl.this.minimized_on_hide.remove(this_shell);
                            }
                            this_shell.setVisible(true);
                            if (minimize) {
                                this_shell.setMinimized(true);
                            } else {
                                this_shell.moveAbove((Control)MainWindowImpl.this.shell);
                            }
                        }
                    }
                });
            }
        });
        if (!bStartMinimize) {
            this.shell.open();
            if (!isOSX) {
                this.shell.forceActive();
            }
        }
        Utils.setUIVisible(!bStartMinimize);
        if (this.delayedCore) {
            Display display = Utils.getDisplay();
            if (display == null) {
                return;
            }
            try {
                Utils.readAndDispatchUntilIdleFor(5000L);
            }
            catch (Exception e) {
                Debug.out(e);
            }
            System.out.println("---------DONE DISPATCH AT " + SystemTime.getCurrentTime() + ";" + (SystemTime.getCurrentTime() - Initializer.startTime) + "ms");
            if (display.isDisposed()) {
                return;
            }
        }
        if (bEnableTray) {
            try {
                this.systemTraySWT = SystemTraySWT.getTray();
            }
            catch (Throwable e) {
                e.printStackTrace();
                Logger.log(new LogEvent(LOGID, 3, "Upgrade to SWT3.0M8 or later for system tray support."));
            }
            if (bStartMinimize) {
                this.minimizeToTray(null);
            } else if (bPassworded) {
                this.minimizeToTray(null);
                this.setVisible(true);
            }
        }
        if (this.uiInitializer != null) {
            this.uiInitializer.initializationComplete();
        }
        boolean run_speed_test = false;
        if (!Utils.isAZ2UI() && !COConfigurationManager.getBooleanParameter("SpeedTest Completed")) {
            if (ConfigurationChecker.isNewInstall()) {
                run_speed_test = true;
            } else if (FeatureAvailability.triggerSpeedTestV1()) {
                long upload_limit = COConfigurationManager.getLongParameter("Max Upload Speed KBs");
                boolean auto_up = COConfigurationManager.getBooleanParameter("Auto Upload Speed Enabled");
                if (auto_up) {
                    if (upload_limit <= 18L) {
                        run_speed_test = true;
                    }
                } else {
                    boolean up_seed_limit = COConfigurationManager.getBooleanParameter("enable.seedingonly.upload.rate");
                    if (upload_limit == 0L && !up_seed_limit) {
                        run_speed_test = true;
                    }
                }
            }
        }
        if (run_speed_test) {
            SpeedTestSelector.runMLABTest(new AERunnable(){

                @Override
                public void runSupport() {
                    WelcomeView.setWaitLoadingURL(false);
                }
            });
        } else {
            WelcomeView.setWaitLoadingURL(false);
        }
        if (Utils.isAZ2UI()) {
            if (!COConfigurationManager.getBooleanParameter("Wizard Completed")) {
                CoreWaiterSWT.waitForCoreRunning(new CoreRunningListener(){

                    @Override
                    public void coreRunning(Core core) {
                        new ConfigureWizard(false, 0);
                    }
                });
            }
            this.checkForWhatsNewWindow();
        }
        AssociationChecker.checkAssociations();
        Map map = VersionCheckClient.getSingleton().getMostRecentVersionCheckData();
        DonationWindow.setInitialAskHours(MapUtils.getMapInt(map, "donations.askhrs", DonationWindow.getInitialAskHours()));
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                core.triggerLifeCycleComponentCreated(MainWindowImpl.this.uiFunctions);
            }
        });
        System.out.println("---------READY AT " + SystemTime.getCurrentTime() + ";" + (SystemTime.getCurrentTime() - Initializer.startTime) + "ms");
        this.isReady = true;
    }

    private void configureDownloadBasket() {
        if (COConfigurationManager.getBooleanParameter("Show Download Basket")) {
            if (this.downloadBasket == null) {
                this.downloadBasket = new TrayWindow();
                this.downloadBasket.setVisible(true);
            }
        } else if (this.downloadBasket != null) {
            this.downloadBasket.setVisible(false);
            this.downloadBasket = null;
        }
    }

    private void checkForWhatsNewWindow() {
        String CONFIG_LASTSHOWN = "welcome.version.lastshown";
        try {
            int latestDisplayed;
            String lastShown = "";
            boolean bIsStringParam = true;
            try {
                lastShown = COConfigurationManager.getStringParameter("welcome.version.lastshown", "");
            }
            catch (Exception e) {
                bIsStringParam = false;
            }
            if (lastShown.length() == 0 && (latestDisplayed = COConfigurationManager.getIntParameter("welcome.version.lastshown", 0)) > 0) {
                bIsStringParam = false;
                String s = "" + latestDisplayed;
                int i = 0;
                while (i < s.length()) {
                    if (i != 0) {
                        lastShown = String.valueOf(lastShown) + ".";
                    }
                    lastShown = String.valueOf(lastShown) + s.charAt(i);
                    ++i;
                }
            }
            if (Constants.compareVersions(lastShown, Constants.getBaseVersion()) < 0) {
                new WelcomeWindow(this.shell);
                if (!bIsStringParam) {
                    COConfigurationManager.removeParameter("welcome.version.lastshown");
                }
                COConfigurationManager.setParameter("welcome.version.lastshown", Constants.getBaseVersion());
                COConfigurationManager.save();
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    @Override
    public void setHideAll(final boolean hide) {
        this.hide_all = hide;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (hide) {
                    MainWindowImpl.this.setVisible(false, true);
                    if (MainWindowImpl.this.systemTraySWT != null) {
                        MainWindowImpl.this.systemTraySWT.dispose();
                    }
                } else {
                    MainWindowImpl.this.setVisible(true, true);
                    if (COConfigurationManager.getBooleanParameter("Enable System Tray")) {
                        MainWindowImpl.this.systemTraySWT = SystemTraySWT.getTray();
                    }
                }
            }
        });
    }

    @Override
    public boolean getHideAll() {
        return this.hide_all;
    }

    private void setVisible(boolean visible) {
        this.setVisible(visible, true);
    }

    @Override
    public void setVisible(final boolean visible, boolean tryTricks) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                int i;
                Shell[] shells2;
                boolean currentlyVisible;
                Utils.setUIVisible(visible);
                boolean bl = currentlyVisible = MainWindowImpl.this.shell.getVisible() && !MainWindowImpl.this.shell.getMinimized();
                if (visible && !currentlyVisible && COConfigurationManager.getBooleanParameter("Password enabled") && !PasswordWindow.showPasswordWindow(Utils.getDisplay())) {
                    MainWindowImpl.this.shell.setVisible(false);
                    return;
                }
                if (!MainWindowImpl.this.isReady && visible) {
                    return;
                }
                ArrayList<Shell> wasVisibleList = null;
                boolean bHideAndShow = false;
                if (bHideAndShow) {
                    wasVisibleList = new ArrayList<Shell>();
                    try {
                        MainWindowImpl.this.shell.setMinimized(true);
                        shells2 = MainWindowImpl.this.shell.getDisplay().getShells();
                        i = 0;
                        while (i < shells2.length) {
                            if (shells2[i].isVisible()) {
                                wasVisibleList.add(shells2[i]);
                                shells2[i].setVisible(false);
                            }
                            ++i;
                        }
                    }
                    catch (Exception shells2) {
                        // empty catch block
                    }
                }
                if (visible) {
                    if (MainWindowImpl.this.shell.getMinimized()) {
                        MainWindowImpl.this.shell.setMinimized(false);
                    }
                    if (!currentlyVisible && COConfigurationManager.getBooleanParameter("window.maximized")) {
                        MainWindowImpl.this.shell.setMaximized(true);
                    }
                } else {
                    COConfigurationManager.setParameter("window.maximized", MainWindowImpl.this.shell.getMaximized());
                }
                MainWindowImpl.this.shell.setVisible(visible);
                if (visible) {
                    MainWindowImpl.this.shell.forceActive();
                    if (bHideAndShow) {
                        try {
                            shells2 = MainWindowImpl.this.shell.getDisplay().getShells();
                            i = 0;
                            while (i < shells2.length) {
                                if (shells2[i] != MainWindowImpl.this.shell) {
                                    if (wasVisibleList != null && wasVisibleList.contains(shells2[i])) {
                                        shells2[i].setVisible(visible);
                                    }
                                    shells2[i].setFocus();
                                }
                                ++i;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        });
    }

    private void minimizeToTray(ShellEvent event2) {
        if (event2 != null) {
            event2.doit = false;
        }
        COConfigurationManager.setParameter("window.maximized", this.shell.getMaximized());
        this.shell.setVisible(false);
        Utils.setUIVisible(false);
        ShellManager.sharedManager().performForShells(new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(Event event2) {
                final Shell shell = (Shell)event2.widget;
                if (shell.getParent() == null) {
                    if (shell.getMinimized()) {
                        Set set = MainWindowImpl.this.minimized_on_hide;
                        synchronized (set) {
                            MainWindowImpl.this.minimized_on_hide.add(shell);
                            shell.addDisposeListener(new DisposeListener(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void widgetDisposed(DisposeEvent e) {
                                    Set set = MainWindowImpl.this.minimized_on_hide;
                                    synchronized (set) {
                                        MainWindowImpl.this.minimized_on_hide.remove(shell);
                                    }
                                }
                            });
                        }
                    }
                    shell.setVisible(false);
                }
            }
        });
        MiniBarManager.getManager().setAllVisible(true);
    }

    private void initSkinListeners() {
        this.uiSkinnableSWTListener = new UISkinnableSWTListener(){

            @Override
            public void skinBeforeComponents(Composite composite, Object skinnableObject, Object[] relatedObjects) {
                byte[] contentThumbnail;
                MessageBoxShell shell = (MessageBoxShell)skinnableObject;
                TOTorrent torrent = null;
                DownloadManager dm = (DownloadManager)LogRelationUtils.queryForClass(relatedObjects, DownloadManager.class);
                torrent = dm != null ? dm.getTorrent() : (TOTorrent)LogRelationUtils.queryForClass(relatedObjects, TOTorrent.class);
                if (torrent != null && shell.getLeftImage() == null && (contentThumbnail = PlatformTorrentUtils.getContentThumbnail(torrent)) != null) {
                    try {
                        ByteArrayInputStream bis = new ByteArrayInputStream(contentThumbnail);
                        final Image img = new Image((Device)Display.getDefault(), (InputStream)bis);
                        shell.setLeftImage(img);
                        composite.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                if (!img.isDisposed()) {
                                    img.dispose();
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void skinAfterComponents(Composite composite, Object skinnableObject, Object[] relatedObjects) {
            }
        };
        UISkinnableManagerSWT skinnableManagerSWT = UISkinnableManagerSWT.getInstance();
        skinnableManagerSWT.addSkinnableListener(MessageBoxShell.class.toString(), this.uiSkinnableSWTListener);
    }

    private BaseMDI initMDI() {
        SWTSkinObject skinObject = this.skin.getSkinObject("mdi");
        if (skinObject != null) {
            BaseMDI mdi = Utils.isAZ2UI() ? new TabbedMDI() : new SideBar();
            mdi.buildMDI(skinObject);
            MainMDISetup.setupSideBar(mdi);
            return mdi;
        }
        return null;
    }

    private void initWidgets2(BaseMDI mdi) {
        SWTSkinObject skinObject = this.skin.getSkinObject("statusbar");
        if (skinObject != null) {
            Composite cArea = (Composite)skinObject.getControl();
            this.statusBar = new MainStatusBar();
            Composite composite = this.statusBar.initStatusBar(cArea);
            composite.setLayoutData((Object)Utils.getFilledFormData());
        }
        if ((skinObject = this.skin.getSkinObject("search-text")) != null) {
            this.attachSearchBox(skinObject);
        }
        if ((skinObject = this.skin.getSkinObject("add-torrent")) instanceof SWTSkinObjectButton) {
            SWTSkinObjectButton btn = (SWTSkinObjectButton)skinObject;
            btn.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                @Override
                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    UIFunctionsManagerSWT.getUIFunctionsSWT().openTorrentWindow();
                }
            });
        }
        if ((skinObject = this.skin.getSkinObject("quick-links")) != null && mdi != null) {
            QuickLinksView.init(mdi, skinObject);
        }
        if ((skinObject = this.skin.getSkinObject("pluginbar")) != null) {
            Menu topbarMenu = new Menu((Decorations)this.shell, 8);
            if (COConfigurationManager.getIntParameter("User Mode") > 1) {
                MenuItem mi = MainMenuV3.createPluginBarMenuItem(this.skin, topbarMenu, "v3.MainWindow.menu.view.pluginbar", "pluginbar.visible", "pluginbar");
                if (Utils.isAZ2UI()) {
                    String str = mi.getText();
                    int pos = str.indexOf("\t");
                    if (pos != -1) {
                        str = str.substring(0, pos).trim();
                        mi.setText(str);
                    }
                    mi.setAccelerator(0);
                }
            }
            new MenuItem(topbarMenu, 2);
            final MenuItem itemClipMon = new MenuItem(topbarMenu, 32);
            Messages.setLanguageText((Widget)itemClipMon, "label.monitor.clipboard");
            itemClipMon.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    COConfigurationManager.setParameter("Monitor Clipboard For Torrents", itemClipMon.getSelection());
                }
            });
            boolean enabled = COConfigurationManager.getBooleanParameter("Monitor Clipboard For Torrents");
            itemClipMon.setSelection(enabled);
            this.configMonitorClipboardListener = new ParameterListener(){
                private volatile AEThread2 monitor_thread;
                private String last_text;

                @Override
                public void parameterChanged(String parameterName) {
                    boolean enabled = COConfigurationManager.getBooleanParameter(parameterName);
                    if (enabled) {
                        if (this.monitor_thread == null) {
                            final AEThread2[] new_thread = new AEThread2[1];
                            this.monitor_thread = new_thread[0] = new AEThread2("Clipboard Monitor"){

                                @Override
                                public void run() {
                                    Runnable checker = new Runnable(){

                                        @Override
                                        public void run() {
                                            if (monitor_thread != new_thread[0]) {
                                                return;
                                            }
                                            String text = ClipboardCopy.copyFromClipboard();
                                            if (!(text == null || text.length() > 2048 || last_text != null && last_text.equals(text))) {
                                                last_text = text;
                                                PluginInterface pi = ClipboardCopy.getOriginator(text);
                                                boolean ignore = false;
                                                if (pi != null && pi.getPluginID().equals("azupnpav")) {
                                                    ignore = true;
                                                }
                                                if (!ignore) {
                                                    TorrentOpener.openTorrentsFromClipboard(text);
                                                }
                                            }
                                        }
                                    };
                                    while (true) {
                                        try {
                                            try {
                                                Utils.execSWTThread(checker);
                                            }
                                            catch (Throwable e) {
                                                Debug.out(e);
                                                if (monitor_thread != new_thread[0]) break;
                                                try {
                                                    Thread.sleep(500L);
                                                    continue;
                                                }
                                                catch (Throwable e2) {
                                                    Debug.out(e2);
                                                    break;
                                                }
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            if (monitor_thread != new_thread[0]) break;
                                            try {
                                                Thread.sleep(500L);
                                            }
                                            catch (Throwable e) {
                                                Debug.out(e);
                                                break;
                                            }
                                            throw throwable;
                                        }
                                        if (monitor_thread != new_thread[0]) break;
                                        try {
                                            Thread.sleep(500L);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                            break;
                                        }
                                    }
                                }
                            };
                            this.monitor_thread.start();
                        }
                    } else {
                        this.monitor_thread = null;
                        this.last_text = null;
                    }
                }
            };
            COConfigurationManager.addAndFireParameterListener("Monitor Clipboard For Torrents", this.configMonitorClipboardListener);
            new MenuItem(topbarMenu, 2);
            SearchUtils.addMenus(topbarMenu);
            this.addMenuAndNonTextChildren((Composite)skinObject.getControl(), topbarMenu);
            skinObject = this.skin.getSkinObject("global-toolbar");
            if (skinObject != null) {
                this.addMenuAndNonTextChildren((Composite)skinObject.getControl(), topbarMenu);
            }
        }
    }

    private void addMenuAndNonTextChildren(Composite parent, Menu menu) {
        Control[] children;
        parent.setMenu(menu);
        Control[] controlArray = children = parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                Composite c = (Composite)control;
                this.addMenuAndNonTextChildren(c, menu);
            } else if (!(control instanceof Text)) {
                control.setMenu(menu);
            }
            ++n2;
        }
    }

    private void attachSearchBox(SWTSkinObject skinObject) {
        SWTSkinObject so;
        Composite cArea = (Composite)skinObject.getControl();
        boolean DARK_MODE = Utils.isDarkAppearanceNative();
        final Text text = new Text(cArea, DARK_MODE && !Utils.isGTK3 ? 2048 : 0);
        text.setMessage(MessageText.getString("v3.MainWindow.search.defaultText"));
        FormData filledFormData = Utils.getFilledFormData();
        if (Utils.isGTK3) {
            if (DARK_MODE) {
                filledFormData.height = 20;
            } else {
                filledFormData.height = 19;
                filledFormData.bottom = new FormAttachment(100, -1);
            }
        } else if (Constants.isOSX && DARK_MODE) {
            filledFormData.height = 19;
        } else if (Constants.isWindows && DARK_MODE) {
            filledFormData.height = 20;
        }
        text.setLayoutData((Object)filledFormData);
        text.setData("ObfuscateImage", (Object)new ObfuscateImage(){

            @Override
            public Image obfuscatedImage(Image image) {
                Point location = Utils.getLocationRelativeToShell((Control)text);
                Point size = text.getSize();
                UIDebugGenerator.obfuscateArea(image, new Rectangle(location.x, location.y, size.x, size.y));
                return image;
            }
        });
        FontUtils.fontToWidgetHeight(text);
        text.setTextLimit(2048);
        if (Constants.isWindows) {
            text.addListener(3, new Listener(){

                public void handleEvent(Event event2) {
                    if (event2.count == 3) {
                        text.selectAll();
                    }
                }
            });
        }
        String tooltip = MessageText.getString("v3.MainWindow.search.tooltip");
        Utils.setTT((Control)text, tooltip);
        SWTSkinProperties properties = skinObject.getProperties();
        Color colorSearchTextBG = properties.getColor("color.search.text.bg");
        Color colorSearchTextFG = properties.getColor("color.search.text.fg");
        if (!Utils.isDarkAppearancePartial() && colorSearchTextBG != null) {
            text.setBackground(colorSearchTextBG);
        }
        final TextWithHistory twh = new TextWithHistory("mainwindow.search.history", text);
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                int key = e.character;
                if (e.stateMask == SWT.MOD1) {
                    if (key <= 26 && key > 0) {
                        key += 96;
                    }
                    if (key == 97) {
                        text.selectAll();
                    }
                }
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        text.addListener(1, new Listener(){

            public void handleEvent(Event event2) {
                Text text = (Text)event2.widget;
                if (event2.keyCode == 27) {
                    text.setText("");
                    return;
                }
                if ((event2.character == '\r' || event2.keyCode == 0x1000050) && event2.doit) {
                    String expression = text.getText();
                    if (expression.startsWith("test://")) {
                        MainWindowImpl.this.runTest(expression.substring(7));
                    } else {
                        MainWindowImpl.this.uiFunctions.doSearch(expression);
                        twh.addHistory(expression);
                    }
                }
            }
        });
        SWTSkinObject searchGo = this.skin.getSkinObject("search-go");
        if (searchGo != null) {
            SWTSkinButtonUtility btnGo = new SWTSkinButtonUtility(searchGo);
            btnGo.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                @Override
                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    String sSearchText = text.getText().trim();
                    MainWindowImpl.this.uiFunctions.doSearch(sSearchText);
                    twh.addHistory(sSearchText);
                }
            });
        }
        if ((so = this.skin.getSkinObject("search-dropdown")) != null) {
            SWTSkinButtonUtility btnSearchDD = new SWTSkinButtonUtility(so);
            btnSearchDD.setTooltipID("v3.MainWindow.search.tooltip");
            btnSearchDD.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                @Override
                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int button, int stateMask) {
                    if (button == 1) {
                        String sSearchText = text.getText().trim();
                        MainWindowImpl.this.uiFunctions.doSearch(sSearchText);
                        twh.addHistory(sSearchText);
                    }
                }
            });
        }
    }

    private void runTest(String cmd) {
        UIToolBarManager tbm = this.uiFunctions.getToolBarManager();
        if (cmd.equals("addTBI")) {
            UIToolBarItem item = tbm.createToolBarItem("mainwin:test");
            item.setGroupID("players");
            tbm.addToolBarItem(item);
        } else if (cmd.equals("removeTBI")) {
            tbm.removeToolBarItem("mainwin:test");
        } else if (cmd.equals("removeTBI2")) {
            tbm.removeToolBarItem("251290325");
        } else if (cmd.equals("listTBI")) {
            UIToolBarItem[] items;
            UIToolBarItem[] uIToolBarItemArray = items = tbm.getAllToolBarItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                UIToolBarItem item = uIToolBarItemArray[n2];
                System.out.println(String.valueOf(item.getGroupID()) + "/" + item.getID());
                ++n2;
            }
        }
    }

    @Override
    public Shell getShell() {
        return this.shell;
    }

    @Override
    public UISWTInstanceImpl getUISWTInstanceImpl() {
        return this.uiSWTInstanceImpl;
    }

    @Override
    public MainStatusBar getMainStatusBar() {
        return this.statusBar;
    }

    @Override
    public boolean isVisible(int windowElement) {
        switch (windowElement) {
            case 2: {
                SWTSkinObject skinObject = this.skin.getSkinObject("global-toolbar");
                if (skinObject == null) break;
                return skinObject.isVisible();
            }
            case 4: {
                SWTSkinObject skinObject = this.skin.getSkinObject("pluginbar");
                if (skinObject == null) break;
                return skinObject.isVisible();
            }
            case 9: {
                SWTSkinObject skinObject = this.skin.getSkinObject("rightbar");
                if (skinObject == null) break;
                return skinObject.isVisible();
            }
            case 8: {
                SWTSkinObject skinObject = this.skin.getSkinObject("quick-links");
                if (skinObject == null) break;
                return skinObject.isVisible();
            }
            case 3: {
                break;
            }
            case 1: {
                break;
            }
            case 100: {
                return !this.shell.getMinimized();
            }
        }
        return false;
    }

    @Override
    public void setVisible(int windowElement, boolean value) {
        switch (windowElement) {
            case 2: {
                SWTSkinUtils.setVisibility(this.skin, "IconBar.enabled", "global-toolbar", value, true);
                break;
            }
            case 4: {
                SWTSkinUtils.setVisibility(this.skin, "pluginbar.visible", "pluginbar", value, true);
                break;
            }
            case 9: {
                SWTSkinUtils.setVisibility(this.skin, "rightbar.visible", "rightbar", value, true);
                break;
            }
            case 8: {
                SWTSkinUtils.setVisibilityRelaxed(this.skin, "quick-links.visible", "quick-links", value, true);
                break;
            }
            case 3: {
                break;
            }
            case 1: {
                break;
            }
            case 100: {
                if (this.shell.isDisposed()) break;
                this.shell.setMinimized(true);
            }
        }
    }

    private void flipVisibility(int windowElement) {
        this.setVisible(windowElement, !this.isVisible(windowElement));
    }

    @Override
    public Rectangle getMetrics(int windowElement) {
        switch (windowElement) {
            case 2: {
                break;
            }
            case 4: {
                SWTSkinObject skinObject = this.skin.getSkinObject("pluginbar");
                if (skinObject == null) break;
                return skinObject.getControl().getBounds();
            }
            case 9: {
                SWTSkinObject skinObject = this.skin.getSkinObject("rightbar");
                if (skinObject == null) break;
                return skinObject.getControl().getBounds();
            }
            case 8: {
                break;
            }
            case 3: {
                return this.statusBar.getBounds();
            }
            case 6: {
                return this.shell.getClientArea();
            }
            case 7: {
                Rectangle r = this.getMetrics(6);
                r.height -= this.getMetrics((int)4).height;
                r.height -= this.getMetrics((int)2).height;
                r.height -= this.getMetrics((int)3).height;
                r.width -= this.getMetrics((int)9).width;
                return r;
            }
        }
        return new Rectangle(0, 0, 0, 0);
    }

    private SWTSkin getSkin() {
        return this.skin;
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }

    @Override
    public Image generateObfuscatedImage() {
        return UIDebugGenerator.generateObfuscatedImage(this.shell);
    }

    @Override
    public void generate(IndentWriter writer) {
        writer.println("SWT UI");
        try {
            writer.indent();
            TableColumnManager.getInstance().generateDiagnostics(writer);
        }
        finally {
            writer.exdent();
        }
    }

    @Override
    public void setSelectedLanguageItem() {
        if (!Utils.isThisThreadSWT()) {
            Utils.execSWTThread(this::setSelectedLanguageItem);
            return;
        }
        Messages.updateLanguageForControl((Widget)this.shell);
        if (this.systemTraySWT != null) {
            this.systemTraySWT.updateLanguage();
        }
        if (this.statusBar != null) {
            this.statusBar.refreshStatusText();
        }
        this.skin.triggerLanguageChange();
        if (this.statusBar != null) {
            this.statusBar.updateStatusText();
        }
        if (this.menu != null) {
            MenuFactory.updateMenuText(this.menu.getMenu("menu.bar"));
        }
    }

    @Override
    public IMainMenu getMainMenu() {
        return this.menu;
    }

    @Override
    public void updateUI() {
    }

    @Override
    public String getUpdateUIName() {
        return "MainWindow";
    }

    private static class MainWindowAlertListener
    implements Alerts.AlertListener {
        private MainWindowAlertListener() {
        }

        @Override
        public boolean allowPopup(Object[] relatedObjects, int configID) {
            DownloadManager dm = (DownloadManager)LogRelationUtils.queryForClass(relatedObjects, DownloadManager.class);
            return dm == null || !dm.getDownloadState().getFlag(16L);
        }
    }

    private static class MainWindowGMListener
    implements GlobalManagerListener {
        private MainWindowGMListener() {
        }

        @Override
        public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
        }

        @Override
        public void downloadManagerRemoved(DownloadManager dm) {
        }

        @Override
        public void downloadManagerAdded(DownloadManager dm) {
            MainWindowImpl.downloadAdded(new DownloadManager[]{dm}, true);
        }

        @Override
        public void destroyed() {
        }

        @Override
        public void destroyInitiated() {
        }
    }
}

