/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells.opentorrent;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.content.ContentException;
import com.biglybt.core.content.RelatedAttributeLookupListener;
import com.biglybt.core.content.RelatedContentManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerAvailability;
import com.biglybt.core.download.DownloadManagerFactory;
import com.biglybt.core.internat.LocaleTorrentUtil;
import com.biglybt.core.internat.LocaleUtilDecoder;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.peer.PEPeerSource;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagException;
import com.biglybt.core.tag.TagFeatureFileLocation;
import com.biglybt.core.tag.TagGroup;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.TagTypeListener;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.tag.impl.TagBase;
import com.biglybt.core.tag.impl.TagTypeBase;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.torrent.impl.TorrentOpenFileOptions;
import com.biglybt.core.torrent.impl.TorrentOpenOptions;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DelayedEvent;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.FrequencyLimitedDispatcher;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.StringInterner;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginManager;
import com.biglybt.pif.ipc.IPCInterface;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnCreationListener;
import com.biglybt.pifimpl.local.torrent.TorrentManagerImpl;
import com.biglybt.pifimpl.local.utils.FormattersImpl;
import com.biglybt.plugin.net.buddy.BuddyPluginBeta;
import com.biglybt.plugin.net.buddy.BuddyPluginUtils;
import com.biglybt.plugin.net.buddy.BuddyPluginViewInterface;
import com.biglybt.ui.IUIIntializer;
import com.biglybt.ui.InitializerListener;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableSelectionListener;
import com.biglybt.ui.common.table.TableViewFilterCheck;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.UIConfigDefaultsSWT;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BubbleTextBox;
import com.biglybt.ui.swt.components.BufferedLabel;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.config.BooleanSwtParameter;
import com.biglybt.ui.swt.config.IntSwtParameter;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mainwindow.SWTThread;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.maketorrent.MultiTrackerEditor;
import com.biglybt.ui.swt.maketorrent.TrackerEditorListener;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.shells.main.UIFunctionsImpl;
import com.biglybt.ui.swt.shells.opentorrent.TableColumnOTOF_Download;
import com.biglybt.ui.swt.shells.opentorrent.TableColumnOTOF_Ext;
import com.biglybt.ui.swt.shells.opentorrent.TableColumnOTOF_Name;
import com.biglybt.ui.swt.shells.opentorrent.TableColumnOTOF_Path;
import com.biglybt.ui.swt.shells.opentorrent.TableColumnOTOF_Position;
import com.biglybt.ui.swt.shells.opentorrent.TableColumnOTOF_PositionPlus1;
import com.biglybt.ui.swt.shells.opentorrent.TableColumnOTOF_Priority;
import com.biglybt.ui.swt.shells.opentorrent.TableColumnOTOF_Size;
import com.biglybt.ui.swt.shells.opentorrent.TableColumnOTOT_Name;
import com.biglybt.ui.swt.shells.opentorrent.TableColumnOTOT_Position;
import com.biglybt.ui.swt.shells.opentorrent.TableColumnOTOT_SaveLocation;
import com.biglybt.ui.swt.shells.opentorrent.TableColumnOTOT_Size;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinButtonUtility;
import com.biglybt.ui.swt.skin.SWTSkinCheckboxListener;
import com.biglybt.ui.swt.skin.SWTSkinFactory;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectButton;
import com.biglybt.ui.swt.skin.SWTSkinObjectCheckbox;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinObjectExpandBar;
import com.biglybt.ui.swt.skin.SWTSkinObjectExpandItem;
import com.biglybt.ui.swt.skin.SWTSkinObjectSash;
import com.biglybt.ui.swt.skin.SWTSkinObjectText;
import com.biglybt.ui.swt.skin.SWTSkinObjectTextbox;
import com.biglybt.ui.swt.subscriptions.SubscriptionListWindow;
import com.biglybt.ui.swt.uiupdater.UIUpdaterSWT;
import com.biglybt.ui.swt.utils.TagUIUtilsV3;
import com.biglybt.ui.swt.views.TrackerAvailView;
import com.biglybt.ui.swt.views.skin.SkinnedDialog;
import com.biglybt.ui.swt.views.skin.StandardButtonsArea;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.TableViewSWTMenuFillListener;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import com.biglybt.ui.swt.views.tableitems.mytorrents.TrackerNameItem;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import com.biglybt.ui.swt.views.utils.TagButtonsUI;
import com.biglybt.ui.swt.widgets.TagCanvas;
import com.biglybt.ui.swt.widgets.TagPainter;
import com.biglybt.util.JSONUtils;
import com.biglybt.util.MapUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.json.simple.JSONObject;

public class OpenTorrentOptionsWindow
implements UIUpdatable {
    private static final AtomicInteger window_id_next = new AtomicInteger();
    private static final Map<HashWrapper, OpenTorrentOptionsWindow> active_windows = new HashMap<HashWrapper, OpenTorrentOptionsWindow>();
    private static TimerEventPeriodic active_window_checker;
    private static final String PARAM_DEFSAVEPATH = "Default save path";
    private static final String[] MSGKEY_QUEUELOCATIONS;
    public static final String TABLEID_TORRENTS = "OpenTorrentTorrent";
    public static final String TABLEID_FILES = "OpenTorrentFile";
    private static final String SP_KEY = "oto:tag:initsp";
    private static final String CONFIG_FILE = "oto.config";
    private static volatile boolean initialised;
    private static AsyncDispatcher dispatcher;
    private static FrequencyLimitedDispatcher freq_disp;
    private final int window_id = window_id_next.incrementAndGet();
    private SkinnedDialog dlg;
    private ImageLoader image_loader;
    private SWTSkinObjectSash sash_object;
    private StackLayout expand_stack;
    private Composite expand_stack_area;
    private StandardButtonsArea buttonsArea;
    private boolean window_initialised;
    private Button buttonTorrentUp;
    private Button buttonTorrentDown;
    private Button buttonTorrentRemove;
    private Button buttonTorrentAccept;
    private List<String> images_to_dispose = new ArrayList<String>();
    private TableViewSWT<OpenTorrentInstance> tvTorrents;
    private Label torrents_info_label;
    private OpenTorrentInstanceListener optionListener;
    private CopyOnWriteList<OpenTorrentInstance> open_instances = new CopyOnWriteList();
    private List<OpenTorrentInstance> selected_instances = new ArrayList<OpenTorrentInstance>();
    private OpenTorrentInstance multi_selection_instance;
    AsyncDispatcher spaceUpdateDispatcher = new AsyncDispatcher();
    private List<Object[]> paramListeners = new ArrayList<Object[]>();
    private static Comparator tree_comp;

    static {
        MSGKEY_QUEUELOCATIONS = new String[]{"OpenTorrentWindow.addPosition.first", "OpenTorrentWindow.addPosition.last", "OpenTorrentWindow.addPosition.auto"};
        dispatcher = new AsyncDispatcher();
        freq_disp = new FrequencyLimitedDispatcher(AERunnable.create(() -> OpenTorrentOptionsWindow.saveActiveWindows()), 10000);
        tree_comp = new FormattersImpl().getAlphanumericComparator(true);
    }

    public static void main(String[] args) {
        try {
            SWTThread.createInstance(new IUIIntializer(){

                @Override
                public void stopIt(boolean isForRestart) {
                }

                @Override
                public void runInSWTThread() {
                }

                @Override
                public void shutdownUIOnly() {
                }

                @Override
                public void run() {
                    Core core = CoreFactory.create();
                    core.start();
                    UIConfigDefaultsSWT.initialize();
                    Colors.getInstance();
                    UIFunctionsImpl uiFunctions = new UIFunctionsImpl(null);
                    UIFunctionsManager.setUIFunctions(uiFunctions);
                    File file1 = new File("C:\\temp\\test.torrent");
                    File file2 = new File("C:\\temp\\test1.torrent");
                    TOTorrent torrent1 = null;
                    try {
                        torrent1 = TOTorrentFactory.deserialiseFromBEncodedFile(file1);
                    }
                    catch (TOTorrentException e) {
                        e.printStackTrace();
                    }
                    TOTorrent torrent2 = null;
                    try {
                        torrent2 = TOTorrentFactory.deserialiseFromBEncodedFile(file2);
                    }
                    catch (TOTorrentException e) {
                        e.printStackTrace();
                    }
                    COConfigurationManager.setParameter("ui.addtorrent.openoptions.sep", false);
                    COConfigurationManager.setParameter("User Mode", 2);
                    if (torrent1 != null) {
                        OpenTorrentOptionsWindow.addTorrent(new TorrentOpenOptions(null, torrent1, false, null));
                    }
                    if (torrent2 != null) {
                        OpenTorrentOptionsWindow.addTorrent(new TorrentOpenOptions(null, torrent2, false, null));
                    }
                }

                @Override
                public void reportPercent(int percent) {
                }

                @Override
                public void reportCurrentTask(String currentTaskString) {
                }

                @Override
                public void removeListener(InitializerListener listener) {
                }

                @Override
                public void initializationComplete() {
                }

                @Override
                public void increaseProgress() {
                }

                @Override
                public void addListener(InitializerListener listener) {
                }

                @Override
                public void abortProgress() {
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void setupTableTorrents() {
        TableColumnManager tcm = TableColumnManager.getInstance();
        if (tcm.getDefaultColumnNames(TABLEID_TORRENTS) == null) {
            tcm.registerColumn(OpenTorrentInstance.class, "#", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new TableColumnOTOT_Position(column);
                }
            });
            tcm.registerColumn(OpenTorrentInstance.class, "torrentname", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new TableColumnOTOT_Name(column);
                }
            });
            tcm.registerColumn(OpenTorrentInstance.class, "size", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new TableColumnOTOT_Size(column);
                }
            });
            tcm.registerColumn(OpenTorrentInstance.class, "path", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new TableColumnOTOT_SaveLocation(column);
                }
            });
            tcm.setDefaultColumnNames(TABLEID_TORRENTS, new String[]{"#", "torrentname", "size", "path"});
            tcm.setDefaultSortColumnName(TABLEID_TORRENTS, "#");
        }
    }

    private static void setupTableFiles() {
        TableColumnManager tcm = TableColumnManager.getInstance();
        if (tcm.getDefaultColumnNames(TABLEID_FILES) == null) {
            tcm.registerColumn(TorrentOpenFileOptions.class, "#", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new TableColumnOTOF_Position(column);
                }
            });
            tcm.registerColumn(TorrentOpenFileOptions.class, "download", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new TableColumnOTOF_Download(column);
                }
            });
            tcm.registerColumn(TorrentOpenFileOptions.class, "name", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new TableColumnOTOF_Name(column);
                }
            });
            tcm.registerColumn(TorrentOpenFileOptions.class, "size", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new TableColumnOTOF_Size(column);
                }
            });
            tcm.registerColumn(TorrentOpenFileOptions.class, "path", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new TableColumnOTOF_Path(column);
                }
            });
            tcm.registerColumn(TorrentOpenFileOptions.class, "fileext", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new TableColumnOTOF_Ext(column);
                }
            });
            tcm.registerColumn(TorrentOpenFileOptions.class, "priority", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new TableColumnOTOF_Priority(column);
                }
            });
            tcm.registerColumn(TorrentOpenFileOptions.class, "#1", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new TableColumnOTOF_PositionPlus1(column);
                }
            });
            tcm.setDefaultColumnNames(TABLEID_FILES, new String[]{"#", "download", "name", "size", "path", "priority"});
            tcm.setDefaultSortColumnName(TABLEID_FILES, "#");
        }
    }

    public static void initialise() {
        block9: {
            try {
                try {
                    List oto_list;
                    Map oto_map;
                    if (FileUtil.resilientConfigFileExists(CONFIG_FILE) && (oto_map = FileUtil.readResilientConfigFile(CONFIG_FILE)) != null && (oto_list = (List)oto_map.get("oto")) != null) {
                        for (Map map : oto_list) {
                            try {
                                OpenTorrentOptionsWindow.addTorrent(TorrentOpenOptions.importFromMap(map));
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                    Utils.execSWTThread(() -> {
                        initialised = true;
                    });
                    break block9;
                }
            }
            catch (Throwable throwable) {
                Utils.execSWTThread(() -> {
                    initialised = true;
                });
                throw throwable;
            }
            Utils.execSWTThread(() -> {
                initialised = true;
            });
        }
    }

    public static void close() {
        OpenTorrentOptionsWindow.saveActiveWindows();
    }

    private static void activeWindowsChanged(boolean delay) {
        if (initialised) {
            AERunnable run = AERunnable.create(() -> dispatcher.dispatch(() -> freq_disp.dispatch()));
            if (delay) {
                new DelayedEvent("oto:save", 10000L, run);
            } else {
                run.runSupport();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveActiveWindows() {
        try {
            Map<HashWrapper, OpenTorrentOptionsWindow> map = active_windows;
            synchronized (map) {
                ArrayList<Map<String, Object>> oto_list = new ArrayList<Map<String, Object>>();
                for (OpenTorrentOptionsWindow w : active_windows.values()) {
                    List<OpenTorrentInstance> instances = w.getInstances();
                    for (OpenTorrentInstance instance : instances) {
                        TorrentOpenOptions opts = instance.getOptions();
                        try {
                            Map<String, Object> map2 = opts.exportToMap();
                            oto_list.add(map2);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
                if (oto_list.isEmpty()) {
                    FileUtil.deleteResilientConfigFile(CONFIG_FILE);
                } else {
                    HashMap<String, ArrayList<Map<String, Object>>> oto_map = new HashMap<String, ArrayList<Map<String, Object>>>();
                    oto_map.put("oto", oto_list);
                    FileUtil.writeResilientConfigFile(CONFIG_FILE, oto_map);
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TorrentOpenOptions> getActiveTorrentOptions() {
        ArrayList<TorrentOpenOptions> result = new ArrayList<TorrentOpenOptions>();
        Map<HashWrapper, OpenTorrentOptionsWindow> map = active_windows;
        synchronized (map) {
            ArrayList oto_list = new ArrayList();
            for (OpenTorrentOptionsWindow w : active_windows.values()) {
                List<OpenTorrentInstance> instances = w.getInstances();
                for (OpenTorrentInstance instance : instances) {
                    TorrentOpenOptions opts = instance.getOptions();
                    result.add(opts);
                }
            }
        }
        return result;
    }

    public static void addTorrent(TorrentOpenOptions torrentOptions) {
        Utils.execSWTThread(() -> OpenTorrentOptionsWindow.addTorrentSupport(torrentOptions, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTorrentSupport(TorrentOpenOptions torrentOptions, int attempt_count) {
        HashWrapper hw;
        TOTorrent torrent = torrentOptions.getTorrent();
        try {
            hw = torrent.getHashWrapper();
        }
        catch (Throwable e) {
            Debug.out(e);
            torrentOptions.cancel();
            return;
        }
        FileUtil.log("OTO:addTorrent: " + ByteFormatter.encodeString(hw.getBytes()) + " - \"" + new String(torrent.getName(), Constants.UTF_8) + "\"");
        Map<HashWrapper, OpenTorrentOptionsWindow> map = active_windows;
        synchronized (map) {
            OpenTorrentOptionsWindow existing = active_windows.get(hw);
            if (existing != null) {
                if (existing.isDisposed()) {
                    String name = new String(torrent.getName(), Constants.UTF_8);
                    if (attempt_count > 5) {
                        Debug.out("Taking a long time to dispose of existing dialog when adding '" + name + "'...");
                    } else if (attempt_count > 30) {
                        Debug.out("Giving up on adding '" + name + "'");
                        torrentOptions.cancel();
                        return;
                    }
                    SimpleTimer.addEvent("awc", SystemTime.getOffsetTime(1000L), ev -> Utils.execSWTThread(() -> OpenTorrentOptionsWindow.addTorrentSupport(torrentOptions, attempt_count + 1)));
                    return;
                }
                existing.swt_activate();
                torrentOptions.cancel();
                return;
            }
            boolean separate_dialogs = COConfigurationManager.getBooleanParameter("ui.addtorrent.openoptions.sep");
            if (active_window_checker == null) {
                active_window_checker = SimpleTimer.addPeriodicEvent("awc", 250L, new TimerEventPerformer(){

                    @Override
                    public void perform(TimerEvent event2) {
                        Utils.execSWTThread(new AERunnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void runSupport() {
                                Map map = active_windows;
                                synchronized (map) {
                                    if (active_windows.size() == 0) {
                                        if (active_window_checker != null) {
                                            active_window_checker.cancel();
                                            active_window_checker = null;
                                        }
                                    } else {
                                        for (OpenTorrentOptionsWindow w : active_windows.values()) {
                                            List instances = w.getInstances();
                                            int num_reject = 0;
                                            int num_accept = 0;
                                            for (OpenTorrentInstance inst : instances) {
                                                TorrentOpenOptions opts = inst.getOptions();
                                                int act = opts.getCompleteAction();
                                                if (act == 2) {
                                                    w.removeInstance(inst, true);
                                                    ++num_reject;
                                                } else if (act == 1) {
                                                    ++num_accept;
                                                }
                                                if (!opts.getAndClearDirt()) continue;
                                                inst.refresh();
                                            }
                                            if (num_reject >= instances.size()) {
                                                w.cancelPressed();
                                                continue;
                                            }
                                            if (num_accept + num_reject < instances.size()) continue;
                                            w.okPressed(false);
                                        }
                                    }
                                }
                            }
                        });
                    }
                });
            }
            if (active_windows.size() >= 64) {
                Debug.out("Too many open-torrent windows, ignoring " + torrentOptions.getDisplayName());
                torrentOptions.cancel();
                return;
            }
            TorrentManagerImpl t_man = TorrentManagerImpl.getSingleton();
            if (!separate_dialogs && active_windows.size() > 0) {
                OpenTorrentOptionsWindow reuse_window = active_windows.values().iterator().next();
                active_windows.put(hw, reuse_window);
                t_man.optionsAdded(torrentOptions);
                reuse_window.swt_addTorrent(hw, torrentOptions);
                OpenTorrentOptionsWindow.activeWindowsChanged(true);
                return;
            }
            OpenTorrentOptionsWindow new_window = new OpenTorrentOptionsWindow();
            active_windows.put(hw, new_window);
            t_man.optionsAdded(torrentOptions);
            new_window.swt_addTorrent(hw, torrentOptions);
            OpenTorrentOptionsWindow.activeWindowsChanged(true);
            return;
        }
    }

    private static void rcmSearch(final HashWrapper hash, final String[] nets) {
        try {
            RelatedContentManager rcm = RelatedContentManager.getSingleton();
            rcm.lookupAttributes(hash.getBytes(), nets, new RelatedAttributeLookupListener(){

                @Override
                public void lookupStart() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void tagFound(String tag, String network) {
                    OpenTorrentOptionsWindow window;
                    Map map = active_windows;
                    synchronized (map) {
                        window = (OpenTorrentOptionsWindow)active_windows.get(hash);
                    }
                    if (window != null) {
                        window.rcmTagFound(hash, tag, nets);
                    }
                }

                @Override
                public void lookupComplete() {
                }

                @Override
                public void lookupFailed(ContentException error) {
                }
            });
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    private OpenTorrentOptionsWindow() {
        this.image_loader = SWTSkinFactory.getInstance().getImageLoader(SWTSkinFactory.getInstance().getSkinProperties());
        this.optionListener = new OpenTorrentInstanceListener(){

            @Override
            public void instanceChanged(OpenTorrentInstance instance) {
                OpenTorrentOptionsWindow.this.updateInstanceInfo();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void swt_addTorrent(HashWrapper hash, TorrentOpenOptions torrentOptions) {
        TorrentManagerImpl t_man = TorrentManagerImpl.getSingleton();
        try {
            if (this.dlg == null) {
                SWTSkinObject soButtonArea;
                SWTSkinObject soOptionsArea;
                SWTSkinObject so;
                this.dlg = new SkinnedDialog("skin3_dlg_opentorrent_options", "shell", 3184);
                SWTSkin skin_outter = this.dlg.getSkin();
                if (COConfigurationManager.hasParameter("ui.addtorrent.openoptions", true) && (so = skin_outter.getSkinObject("showagain-area")) != null) {
                    so.setVisible(false);
                }
                if ((soOptionsArea = skin_outter.getSkinObject("options-area")) != null) {
                    SWTSkinObjectButton opt_config = (SWTSkinObjectButton)skin_outter.getSkinObject("options-config");
                    opt_config.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                        @Override
                        public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int button, int stateMask) {
                            UIFunctions uif = UIFunctionsManager.getUIFunctions();
                            if (uif != null) {
                                JSONObject args = new JSONObject();
                                args.put("select", "default-dir-options");
                                String args_str = JSONUtils.encodeToJSON(args);
                                uif.getMDI().showEntryByID("ConfigView", "files" + args_str);
                            }
                        }
                    });
                    final SWTSkinObjectCheckbox opt_sep_dialog = (SWTSkinObjectCheckbox)skin_outter.getSkinObject("options-sep-dialog");
                    opt_sep_dialog.setChecked(COConfigurationManager.getBooleanParameter("ui.addtorrent.openoptions.sep"));
                    opt_sep_dialog.addSelectionListener((skinobj, checked) -> COConfigurationManager.setParameter("ui.addtorrent.openoptions.sep", checked));
                    ParameterListener listener = new ParameterListener(){

                        @Override
                        public void parameterChanged(String name) {
                            if (opt_sep_dialog.isDisposed()) {
                                COConfigurationManager.removeParameterListener(name, this);
                            } else {
                                opt_sep_dialog.setChecked(COConfigurationManager.getBooleanParameter(name));
                            }
                        }
                    };
                    COConfigurationManager.addParameterListener("ui.addtorrent.openoptions.sep", listener);
                    this.paramListeners.add(new Object[]{"ui.addtorrent.openoptions.sep", listener});
                }
                if ((soButtonArea = skin_outter.getSkinObject("button-area")) instanceof SWTSkinObjectContainer) {
                    this.buttonsArea = new StandardButtonsArea(){

                        @Override
                        protected void clicked(int intValue) {
                            if (intValue == 32) {
                                OpenTorrentOptionsWindow.this.okPressed(false);
                            } else {
                                OpenTorrentOptionsWindow.this.cancelPressed();
                            }
                        }
                    };
                    this.buttonsArea.setButtonIDs(new String[]{MessageText.getString("Button.ok"), MessageText.getString("Button.cancel")});
                    this.buttonsArea.setButtonVals(new Integer[]{32, 256});
                    this.buttonsArea.swt_createButtons(((SWTSkinObjectContainer)soButtonArea).getComposite());
                    int autoCloseSecs = COConfigurationManager.getIntParameter("ui.addtorrent.openoptions.auto.close.secs");
                    if (autoCloseSecs > 0) {
                        BufferedLabel label = this.buttonsArea.getLabel();
                        final boolean[] disabled = new boolean[1];
                        label.addMouseListener((MouseListener)new MouseAdapter(){

                            public void mouseDown(MouseEvent e) {
                                disabled[0] = !disabled[0];
                            }
                        });
                        AEThread2.createAndStartDaemon("AutoClose", () -> {
                            int rem = autoCloseSecs;
                            while (!label.isDisposed()) {
                                if (disabled[0]) {
                                    Utils.execSWTThread(() -> {
                                        if (label.isDisposed()) {
                                            return;
                                        }
                                        label.setForeground(Colors.dark_grey);
                                    });
                                } else {
                                    int f_rem = rem;
                                    Utils.execSWTThread(() -> {
                                        if (label.isDisposed()) {
                                            return;
                                        }
                                        label.setForeground(null);
                                        if (f_rem == 0) {
                                            this.okPressed(true);
                                        } else {
                                            label.setText(MessageText.getString("label.auto.accept.in", new String[]{TimeFormatter.format3(f_rem)}));
                                        }
                                    });
                                    if (rem == 0) break;
                                    --rem;
                                }
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                }
                this.sash_object = (SWTSkinObjectSash)skin_outter.getSkinObject("multi-sash");
                SWTSkinObjectContainer select_area = (SWTSkinObjectContainer)skin_outter.getSkinObject("torrents-table");
                this.setupTVTorrents(select_area.getComposite());
                SWTSkinObjectContainer torrents_info = (SWTSkinObjectContainer)skin_outter.getSkinObject("torrents-info");
                Composite info_area = torrents_info.getComposite();
                info_area.setLayout((Layout)new GridLayout());
                this.torrents_info_label = new Label(info_area, 0);
                this.torrents_info_label.setLayoutData((Object)new GridData(768));
                boolean separate_dialogs = COConfigurationManager.getBooleanParameter("ui.addtorrent.openoptions.sep");
                boolean always_show_sidebar = COConfigurationManager.getBooleanParameter("ui.addtorrent.openoptions.always.sidebar") && !separate_dialogs;
                this.sash_object.setVisible(always_show_sidebar);
                this.sash_object.setAboveVisible(always_show_sidebar);
                so = skin_outter.getSkinObject("expand-area");
                this.expand_stack_area = ((SWTSkinObjectContainer)so).getComposite();
                this.expand_stack = new StackLayout();
                this.expand_stack_area.setLayout((Layout)this.expand_stack);
                Composite expand_area = new Composite(this.expand_stack_area, 0);
                expand_area.setLayout((Layout)new FormLayout());
                this.expand_stack.topControl = expand_area;
                OpenTorrentInstance instance = new OpenTorrentInstance(hash, expand_area, torrentOptions, this.optionListener);
                this.addInstance(instance);
                this.selected_instances.add(instance);
                this.setSelectedRows();
                UIUpdaterSWT.getInstance().addUpdater(this);
                this.setupShowAgainOptions(skin_outter);
                final Runnable doOpen = () -> {
                    Map<HashWrapper, OpenTorrentOptionsWindow> map;
                    OpenTorrentOptionsWindow moveBelow = null;
                    if (separate_dialogs) {
                        map = active_windows;
                        synchronized (map) {
                            for (OpenTorrentOptionsWindow window : active_windows.values()) {
                                if (window == this || !window.isInitialised() || moveBelow != null && moveBelow.window_id >= window.window_id) continue;
                                moveBelow = window;
                            }
                        }
                    }
                    this.dlg.open("otow", false, moveBelow == null ? null : super.getShell());
                    if (separate_dialogs) {
                        map = active_windows;
                        synchronized (map) {
                            int num_active_windows = active_windows.size();
                            Shell shell = this.dlg.getShell();
                            if (num_active_windows > 1) {
                                int max_x = Integer.MIN_VALUE;
                                int max_y = Integer.MIN_VALUE;
                                for (OpenTorrentOptionsWindow window : active_windows.values()) {
                                    if (window == this || !window.isInitialised()) continue;
                                    Rectangle rect = window.getBounds();
                                    max_x = Math.max(max_x, rect.x);
                                    max_y = Math.max(max_y, rect.y);
                                }
                                if (max_x > Integer.MIN_VALUE) {
                                    Rectangle rect = shell.getBounds();
                                    rect.x = max_x + 16;
                                    rect.y = max_y + 16;
                                    try {
                                        Utils.setShellMetricsConfigEnabled(shell, false);
                                        shell.setBounds(rect);
                                    }
                                    finally {
                                        Utils.setShellMetricsConfigEnabled(shell, true);
                                    }
                                }
                            }
                            Utils.verifyShellRect(shell, true);
                        }
                    }
                };
                boolean wentAsync = false;
                final Shell mainShell = UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell();
                if (Constants.isOSX && mainShell.getMinimized()) {
                    wentAsync = true;
                    mainShell.addShellListener((ShellListener)new ShellAdapter(){

                        public void shellActivated(ShellEvent e) {
                            mainShell.removeShellListener((ShellListener)this);
                            if (!OpenTorrentOptionsWindow.this.dlg.isDisposed()) {
                                doOpen.run();
                                OpenTorrentOptionsWindow.this.window_initialised = true;
                            }
                        }
                    });
                } else {
                    doOpen.run();
                }
                this.dlg.addCloseListener(new SkinnedDialog.SkinnedDialogClosedListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void skinDialogClosed(SkinnedDialog dialog) {
                        block12: {
                            try {
                                OpenTorrentOptionsWindow.this.dispose();
                                break block12;
                            }
                            catch (Throwable throwable) {
                                Map map = active_windows;
                                synchronized (map) {
                                    Iterator it = active_windows.values().iterator();
                                    while (it.hasNext()) {
                                        OpenTorrentOptionsWindow window = (OpenTorrentOptionsWindow)it.next();
                                        if (window != OpenTorrentOptionsWindow.this) continue;
                                        it.remove();
                                    }
                                    TorrentManagerImpl t_man = TorrentManagerImpl.getSingleton();
                                    for (OpenTorrentInstance inst : OpenTorrentOptionsWindow.this.open_instances) {
                                        inst.cancelPressed();
                                        t_man.optionsRemoved(inst.getOptions());
                                    }
                                }
                            }
                            OpenTorrentOptionsWindow.activeWindowsChanged(false);
                            throw throwable;
                        }
                        Map map = active_windows;
                        synchronized (map) {
                            Iterator it = active_windows.values().iterator();
                            while (it.hasNext()) {
                                OpenTorrentOptionsWindow window = (OpenTorrentOptionsWindow)it.next();
                                if (window != OpenTorrentOptionsWindow.this) continue;
                                it.remove();
                            }
                            TorrentManagerImpl t_man = TorrentManagerImpl.getSingleton();
                            for (OpenTorrentInstance inst : OpenTorrentOptionsWindow.this.open_instances) {
                                inst.cancelPressed();
                                t_man.optionsRemoved(inst.getOptions());
                            }
                        }
                        OpenTorrentOptionsWindow.activeWindowsChanged(false);
                    }
                });
                if (!wentAsync) {
                    this.window_initialised = true;
                }
            } else {
                Composite expand_area = new Composite(this.expand_stack_area, 0);
                expand_area.setLayout((Layout)new FormLayout());
                OpenTorrentInstance instance = new OpenTorrentInstance(hash, expand_area, torrentOptions, this.optionListener);
                this.addInstance(instance);
                if (!this.sash_object.isVisible()) {
                    this.sash_object.setVisible(true);
                    this.sash_object.setAboveVisible(true);
                    this.setSelectedRows();
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
            Map<HashWrapper, OpenTorrentOptionsWindow> map = active_windows;
            synchronized (map) {
                active_windows.remove(hash);
                torrentOptions.cancel();
                t_man.optionsRemoved(torrentOptions);
            }
            OpenTorrentOptionsWindow.activeWindowsChanged(false);
        }
    }

    private void rcmTagFound(HashWrapper hash, String tag, String[] nets) {
        for (OpenTorrentInstance inst : this.open_instances) {
            if (!inst.getHash().equals(hash)) continue;
            inst.rcmTagFound(tag, nets);
        }
    }

    private void setSelectedRows() {
        Utils.execSWTThreadLater(0, new Runnable(){

            @Override
            public void run() {
                OpenTorrentOptionsWindow.this.tvTorrents.processDataSourceQueueSync();
                ArrayList<TableRowCore> rows = new ArrayList<TableRowCore>();
                for (OpenTorrentInstance instance : OpenTorrentOptionsWindow.this.selected_instances) {
                    TableRowCore row = OpenTorrentOptionsWindow.this.tvTorrents.getRow(instance);
                    if (row == null) continue;
                    rows.add(row);
                }
                if (rows.size() > 0) {
                    OpenTorrentOptionsWindow.this.tvTorrents.setSelectedRows(rows.toArray(new TableRowCore[rows.size()]));
                }
            }
        });
    }

    private boolean isDisposed() {
        return this.expand_stack_area.isDisposed();
    }

    private boolean isInitialised() {
        return this.window_initialised;
    }

    private List<OpenTorrentInstance> getInstances() {
        return new ArrayList<OpenTorrentInstance>(this.open_instances.getList());
    }

    private OpenTorrentInstance getInstance(TorrentOpenOptions options) {
        for (OpenTorrentInstance instance : this.open_instances) {
            if (instance.getOptions() != options) continue;
            return instance;
        }
        return null;
    }

    private void cancelPressed() {
        for (OpenTorrentInstance instance : this.open_instances) {
            instance.cancelPressed();
        }
        if (this.dlg != null) {
            this.dlg.close();
        }
    }

    private void okPressed(boolean auto) {
        TorrentManagerImpl t_man = TorrentManagerImpl.getSingleton();
        boolean all_ok = true;
        AsyncDispatcher dispatcher = new AsyncDispatcher();
        for (final OpenTorrentInstance instance : this.open_instances) {
            String dataDir;
            if (!instance.okPressed(dataDir = instance.cmbDataDir.getText(), auto)) {
                all_ok = false;
                continue;
            }
            t_man.optionsAccepted(instance.getOptions());
            dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    instance.getOptions().addToDownloadManager();
                }
            });
            this.removeInstance(instance, false);
        }
        if (all_ok && this.dlg != null) {
            this.dlg.close();
        }
    }

    private void setupShowAgainOptions(SWTSkin skin) {
        SWTSkinObjectCheckbox soAskLater = (SWTSkinObjectCheckbox)skin.getSkinObject("showagain-asklater");
        SWTSkinObjectCheckbox soNever = (SWTSkinObjectCheckbox)skin.getSkinObject("showagain-never");
        SWTSkinObjectCheckbox soAlways = (SWTSkinObjectCheckbox)skin.getSkinObject("showagain-always");
        SWTSkinObjectCheckbox soMany = (SWTSkinObjectCheckbox)skin.getSkinObject("showagain-manyfile");
        String showAgainMode = COConfigurationManager.getStringParameter("ui.addtorrent.openoptions");
        boolean hasUserChosen = COConfigurationManager.hasParameter("ui.addtorrent.openoptions", true);
        if (soAskLater != null && !hasUserChosen) {
            soAskLater.addSelectionListener(new SWTSkinCheckboxListener(){

                @Override
                public void checkboxChanged(SWTSkinObjectCheckbox so, boolean checked) {
                    COConfigurationManager.removeParameter("ui.addtorrent.openoptions");
                }
            });
            if (!hasUserChosen) {
                soAskLater.setChecked(true);
            }
        }
        if (soNever != null) {
            soNever.addSelectionListener(new SWTSkinCheckboxListener(){

                @Override
                public void checkboxChanged(SWTSkinObjectCheckbox so, boolean checked) {
                    COConfigurationManager.setParameter("ui.addtorrent.openoptions", "never");
                }
            });
            if (hasUserChosen) {
                soNever.setChecked("never".equals(showAgainMode));
            }
        }
        if (soAlways != null) {
            soAlways.addSelectionListener(new SWTSkinCheckboxListener(){

                @Override
                public void checkboxChanged(SWTSkinObjectCheckbox so, boolean checked) {
                    COConfigurationManager.setParameter("ui.addtorrent.openoptions", "always");
                }
            });
            if (hasUserChosen) {
                soAlways.setChecked("always".equals(showAgainMode));
            }
        }
        if (soMany != null) {
            soMany.addSelectionListener(new SWTSkinCheckboxListener(){

                @Override
                public void checkboxChanged(SWTSkinObjectCheckbox so, boolean checked) {
                    COConfigurationManager.setParameter("ui.addtorrent.openoptions", "many");
                }
            });
            if (hasUserChosen) {
                soMany.setChecked("many".equals(showAgainMode));
            }
        }
    }

    private void setupTVTorrents(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        parent.setLayout((Layout)layout);
        Composite table_area = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        table_area.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        table_area.setLayoutData((Object)gd);
        Composite button_area = new Composite(parent, 0);
        layout = new GridLayout(6, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginTop = 5;
        button_area.setLayout((Layout)layout);
        gd = new GridData(768);
        button_area.setLayoutData((Object)gd);
        Label label = new Label(button_area, 0);
        gd = new GridData(768);
        label.setLayoutData((Object)gd);
        this.buttonTorrentUp = new Button(button_area, 8);
        this.buttonTorrentUp.setImage(this.loadImage("image.toolbar.up"));
        Utils.setTT((Control)this.buttonTorrentUp, MessageText.getString("Button.moveUp"));
        this.buttonTorrentUp.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                List<Object> selected = OpenTorrentOptionsWindow.this.tvTorrents.getSelectedDataSources();
                if (selected.size() > 1) {
                    Collections.sort(selected, new Comparator<OpenTorrentInstance>(){

                        @Override
                        public int compare(OpenTorrentInstance o1, OpenTorrentInstance o2) {
                            return o1.getIndex() - o2.getIndex();
                        }
                    });
                }
                boolean modified = false;
                for (OpenTorrentInstance openTorrentInstance : selected) {
                    int index = openTorrentInstance.getIndex();
                    if (index <= 0) continue;
                    OpenTorrentOptionsWindow.this.open_instances.remove(openTorrentInstance);
                    OpenTorrentOptionsWindow.this.open_instances.add(index - 1, openTorrentInstance);
                    modified = true;
                }
                if (modified) {
                    OpenTorrentOptionsWindow.this.swt_updateTVTorrentButtons();
                    OpenTorrentOptionsWindow.this.refreshTVTorrentIndexes();
                }
            }
        });
        this.buttonTorrentDown = new Button(button_area, 8);
        this.buttonTorrentDown.setImage(this.loadImage("image.toolbar.down"));
        Utils.setTT((Control)this.buttonTorrentDown, MessageText.getString("Button.moveDown"));
        this.buttonTorrentDown.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                List<Object> selected = OpenTorrentOptionsWindow.this.tvTorrents.getSelectedDataSources();
                if (selected.size() > 1) {
                    Collections.sort(selected, new Comparator<OpenTorrentInstance>(){

                        @Override
                        public int compare(OpenTorrentInstance o1, OpenTorrentInstance o2) {
                            return o2.getIndex() - o1.getIndex();
                        }
                    });
                }
                boolean modified = false;
                for (Object obj : selected) {
                    OpenTorrentInstance instance = (OpenTorrentInstance)obj;
                    int index = instance.getIndex();
                    if (index >= OpenTorrentOptionsWindow.this.open_instances.size() - 1) continue;
                    OpenTorrentOptionsWindow.this.open_instances.remove(instance);
                    OpenTorrentOptionsWindow.this.open_instances.add(index + 1, instance);
                    modified = true;
                }
                if (modified) {
                    OpenTorrentOptionsWindow.this.swt_updateTVTorrentButtons();
                    OpenTorrentOptionsWindow.this.refreshTVTorrentIndexes();
                }
            }
        });
        this.buttonTorrentRemove = new Button(button_area, 8);
        Utils.setTT((Control)this.buttonTorrentRemove, MessageText.getString("OpenTorrentWindow.torrent.remove"));
        this.buttonTorrentRemove.setImage(this.loadImage("image.toolbar.remove"));
        this.buttonTorrentRemove.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                List<Object> selected = OpenTorrentOptionsWindow.this.tvTorrents.getSelectedDataSources();
                for (Object obj : selected) {
                    OpenTorrentInstance instance = (OpenTorrentInstance)obj;
                    OpenTorrentOptionsWindow.this.removeInstance(instance, true);
                }
            }
        });
        this.buttonTorrentAccept = new Button(button_area, 8);
        Utils.setTT((Control)this.buttonTorrentAccept, MessageText.getString("label.accept"));
        this.buttonTorrentAccept.setImage(this.loadImage("image.button.play"));
        this.buttonTorrentAccept.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                List<Object> selected = OpenTorrentOptionsWindow.this.tvTorrents.getSelectedDataSources();
                OpenTorrentOptionsWindow.this.acceptInstances(selected);
            }
        });
        this.buttonTorrentUp.setEnabled(false);
        this.buttonTorrentDown.setEnabled(false);
        this.buttonTorrentRemove.setEnabled(false);
        this.buttonTorrentAccept.setEnabled(false);
        label = new Label(button_area, 0);
        gd = new GridData(768);
        label.setLayoutData((Object)gd);
        OpenTorrentOptionsWindow.setupTableTorrents();
        this.tvTorrents = TableViewFactory.createTableViewSWT(OpenTorrentInstance.class, TABLEID_TORRENTS, TABLEID_TORRENTS, null, "#", 67586);
        this.tvTorrents.initialize(table_area);
        this.tvTorrents.setRowDefaultHeightEM(1.4f);
        this.tvTorrents.addMenuFillListener(new TableViewSWTMenuFillListener(){

            @Override
            public void fillMenu(String sColumnName, Menu menu) {
                final List<Object> selected = OpenTorrentOptionsWindow.this.tvTorrents.getSelectedDataSources();
                if (selected.size() > 0) {
                    ArrayList<OpenTorrentInstance> instances = new ArrayList<OpenTorrentInstance>(selected.size());
                    ArrayList<OpenTorrentInstance> non_simple_instances = new ArrayList<OpenTorrentInstance>();
                    boolean can_rtlf = false;
                    for (Object o : selected) {
                        OpenTorrentInstance oti = (OpenTorrentInstance)o;
                        instances.add(oti);
                        if (oti.getOptions().isSimpleTorrent()) continue;
                        non_simple_instances.add(oti);
                        if (!oti.canRemoveTopLevelFolder()) continue;
                        can_rtlf = true;
                    }
                    MenuItem item = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)item, "OpenTorrentWindow.fileList.changeDestination");
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            for (Object obj : selected) {
                                OpenTorrentInstance instance = (OpenTorrentInstance)obj;
                                instance.setSavePath();
                            }
                        }
                    });
                    item = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)item, "OpenTorrentWindow.tlf.remove");
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            for (Object obj : selected) {
                                OpenTorrentInstance instance = (OpenTorrentInstance)obj;
                                if (!instance.canRemoveTopLevelFolder()) continue;
                                instance.removeTopLevelFolder();
                            }
                        }
                    });
                    item.setEnabled(can_rtlf);
                    item = new MenuItem(menu, 32);
                    item.setSelection(COConfigurationManager.getBooleanParameter("open.torrent.window.rename.on.tlf.change"));
                    Messages.setLanguageText((Widget)item, "OpenTorrentWindow.tlf.rename");
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            COConfigurationManager.setParameter("open.torrent.window.rename.on.tlf.change", ((MenuItem)e.widget).getSelection());
                        }
                    });
                    new MenuItem(menu, 2);
                    item = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)item, "Button.remove");
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            for (Object obj : selected) {
                                OpenTorrentInstance instance = (OpenTorrentInstance)obj;
                                OpenTorrentOptionsWindow.this.removeInstance(instance, true);
                            }
                        }
                    });
                    new MenuItem(menu, 2);
                }
            }

            @Override
            public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
            }
        });
        this.tvTorrents.addSelectionListener(new TableSelectionListener(){

            @Override
            public void selected(TableRowCore[] rows_not_used) {
                TableRowCore[] rows = OpenTorrentOptionsWindow.this.tvTorrents.getSelectedRows();
                ArrayList<OpenTorrentInstance> instances = new ArrayList<OpenTorrentInstance>();
                TableRowCore[] tableRowCoreArray = rows;
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    TableRowCore row = tableRowCoreArray[n2];
                    instances.add((OpenTorrentInstance)row.getDataSource());
                    ++n2;
                }
                OpenTorrentOptionsWindow.this.selectInstances(instances);
                this.updateButtons();
            }

            @Override
            public void mouseExit(TableRowCore row) {
            }

            @Override
            public void mouseEnter(TableRowCore row) {
            }

            @Override
            public void focusChanged(TableRowCore focus) {
            }

            @Override
            public void deselected(TableRowCore[] rows) {
                this.selected(rows);
            }

            private void updateButtons() {
                Utils.execSWTThread(new Runnable(){

                    @Override
                    public void run() {
                        OpenTorrentOptionsWindow.this.swt_updateTVTorrentButtons();
                    }
                });
            }

            @Override
            public void defaultSelected(TableRowCore[] rows, int stateMask) {
            }
        }, false);
    }

    private void addInstance(OpenTorrentInstance instance) {
        this.open_instances.add(instance);
        try {
            this.updateDialogTitle();
            instance.initialize();
            this.tvTorrents.addDataSources((OpenTorrentInstance[])new OpenTorrentInstance[]{instance});
            this.tvTorrents.processDataSourceQueueSync();
            this.tvTorrents.refreshTable(false);
            this.updateInstanceInfo();
            this.swt_updateTVTorrentButtons();
        }
        catch (Throwable e) {
            Debug.out(e);
            this.removeInstance(instance, true);
        }
    }

    private void selectInstance(OpenTorrentInstance instance) {
        ArrayList<OpenTorrentInstance> instances = new ArrayList<OpenTorrentInstance>();
        if (instance != null) {
            instances.add(instance);
        }
        this.selectInstances(instances);
    }

    private void selectInstances(List<OpenTorrentInstance> _instances) {
        if (_instances.equals(this.selected_instances)) {
            return;
        }
        final ArrayList<OpenTorrentInstance> instances = new ArrayList<OpenTorrentInstance>(_instances);
        Iterator it = instances.iterator();
        while (it.hasNext()) {
            if (this.open_instances.contains((OpenTorrentInstance)it.next())) continue;
            it.remove();
        }
        if (instances.size() == 0) {
            if (this.selected_instances.size() > 0 && this.open_instances.contains(this.selected_instances.get(0))) {
                instances.add(this.selected_instances.get(0));
            } else if (this.open_instances.size() > 0) {
                instances.add(this.open_instances.get(0));
            }
        }
        this.selected_instances.clear();
        this.selected_instances.addAll(instances);
        Utils.execSWTThread(new Runnable(){

            @Override
            public void run() {
                if (OpenTorrentOptionsWindow.this.expand_stack_area.isDisposed()) {
                    return;
                }
                if (OpenTorrentOptionsWindow.this.multi_selection_instance != null) {
                    OpenTorrentOptionsWindow.this.multi_selection_instance.getComposite().dispose();
                    OpenTorrentOptionsWindow.this.multi_selection_instance = null;
                }
                if (instances.size() == 1) {
                    OpenTorrentInstance first_instance = (OpenTorrentInstance)instances.get(0);
                    ((OpenTorrentOptionsWindow)OpenTorrentOptionsWindow.this).expand_stack.topControl = first_instance.getComposite();
                    OpenTorrentOptionsWindow.this.expand_stack_area.layout(true);
                    if (first_instance.tagButtonsUI != null) {
                        first_instance.tagButtonsUI.updateFields(null);
                    }
                    first_instance.layout();
                } else {
                    Composite expand_area = new Composite(OpenTorrentOptionsWindow.this.expand_stack_area, 0);
                    expand_area.setLayout((Layout)new FormLayout());
                    ArrayList<TorrentOpenOptions> toos = new ArrayList<TorrentOpenOptions>();
                    for (OpenTorrentInstance oti : instances) {
                        toos.add(oti.getOptions());
                    }
                    OpenTorrentOptionsWindow.this.multi_selection_instance = new OpenTorrentInstance(expand_area, toos, OpenTorrentOptionsWindow.this.optionListener);
                    OpenTorrentOptionsWindow.this.multi_selection_instance.initialize();
                    ((OpenTorrentOptionsWindow)OpenTorrentOptionsWindow.this).expand_stack.topControl = OpenTorrentOptionsWindow.this.multi_selection_instance.getComposite();
                    OpenTorrentOptionsWindow.this.expand_stack_area.layout(true);
                    OpenTorrentOptionsWindow.this.multi_selection_instance.layout();
                }
            }
        });
        ArrayList<TableRowCore> rows = new ArrayList<TableRowCore>();
        for (OpenTorrentInstance instance : instances) {
            TableRowCore row = this.tvTorrents.getRow(instance);
            if (row == null) continue;
            rows.add(row);
        }
        this.tvTorrents.setSelectedRows(rows.toArray(new TableRowCore[rows.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInstance(OpenTorrentInstance instance, boolean is_removal) {
        TorrentManagerImpl t_man = TorrentManagerImpl.getSingleton();
        Map<HashWrapper, OpenTorrentOptionsWindow> map = active_windows;
        synchronized (map) {
            active_windows.remove(instance.getHash());
            t_man.optionsRemoved(instance.getOptions());
        }
        OpenTorrentOptionsWindow.activeWindowsChanged(false);
        int index = this.open_instances.indexOf(instance);
        this.open_instances.remove(instance);
        try {
            this.updateDialogTitle();
            this.tvTorrents.removeDataSource(instance);
            instance.getComposite().dispose();
            this.updateInstanceInfo();
            if (this.selected_instances.contains(instance) && this.selected_instances.size() > 1) {
                ArrayList<OpenTorrentInstance> temp = new ArrayList<OpenTorrentInstance>(this.selected_instances);
                temp.remove(instance);
                this.selectInstances(temp);
            } else {
                int num_instances = this.open_instances.size();
                if (num_instances > index) {
                    this.selectInstance(this.open_instances.get(index));
                } else if (num_instances > 0) {
                    this.selectInstance(this.open_instances.get(num_instances - 1));
                } else {
                    this.selectInstance(null);
                }
            }
            this.swt_updateTVTorrentButtons();
            this.refreshTVTorrentIndexes();
        }
        finally {
            if (is_removal) {
                try {
                    instance.cancelPressed();
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            try {
                instance.dispose();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            if (this.open_instances.isEmpty() && this.dlg != null) {
                this.dlg.close();
            }
        }
    }

    private void acceptInstances(List<OpenTorrentInstance> instances) {
        TorrentManagerImpl t_man = TorrentManagerImpl.getSingleton();
        for (final OpenTorrentInstance instance : new ArrayList<OpenTorrentInstance>(instances)) {
            String dataDir;
            if (!instance.okPressed(dataDir = instance.cmbDataDir.getText(), false)) continue;
            t_man.optionsAccepted(instance.getOptions());
            dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    instance.getOptions().addToDownloadManager();
                }
            });
            this.removeInstance(instance, false);
        }
        if (this.open_instances.isEmpty()) {
            if (this.dlg != null) {
                this.dlg.close();
            }
        } else {
            this.swt_updateTVTorrentButtons();
            this.refreshTVTorrentIndexes();
        }
    }

    private void updateDialogTitle() {
        String text;
        int num = this.open_instances.size();
        if (num == 1) {
            TorrentOpenOptions options = this.open_instances.get(0).getOptions();
            text = options.getDisplayName();
        } else {
            text = MessageText.getString("label.num.torrents", new String[]{String.valueOf(this.open_instances.size())});
        }
        this.dlg.setTitle(String.valueOf(MessageText.getString("OpenTorrentOptions.title")) + " [" + text + "]");
    }

    private void swt_updateTVTorrentButtons() {
        if (this.buttonTorrentRemove.isDisposed()) {
            return;
        }
        List<Object> selected = this.tvTorrents.getSelectedDataSources();
        this.buttonTorrentRemove.setEnabled(selected.size() > 0);
        this.buttonTorrentAccept.setEnabled(selected.size() > 0);
        if (selected.size() > 0) {
            int min_index = Integer.MAX_VALUE;
            int max_index = -1;
            for (Object obj : selected) {
                OpenTorrentInstance instance = (OpenTorrentInstance)obj;
                int index = instance.getIndex();
                min_index = Math.min(min_index, index);
                max_index = Math.max(max_index, index);
            }
            this.buttonTorrentUp.setEnabled(min_index > 0);
            this.buttonTorrentDown.setEnabled(max_index < this.open_instances.size() - 1);
        } else {
            this.buttonTorrentUp.setEnabled(false);
            this.buttonTorrentDown.setEnabled(false);
        }
    }

    private void refreshTVTorrentIndexes() {
        Utils.execSWTThreadLater(0, new Runnable(){

            @Override
            public void run() {
                OpenTorrentOptionsWindow.this.tvTorrents.columnInvalidate("#");
                OpenTorrentOptionsWindow.this.tvTorrents.refreshTable(true);
            }
        });
    }

    private void updateInstanceInfo() {
        String tot_str;
        if (this.torrents_info_label == null) {
            return;
        }
        long total_size = 0L;
        long selected_size = 0L;
        for (OpenTorrentInstance instance : this.open_instances) {
            total_size += instance.getOptions().getTorrent().getSize();
            selected_size += instance.getSelectedDataSize();
        }
        String sel_str = DisplayFormatters.formatByteCountToKiBEtc(selected_size);
        String text = sel_str.equals(tot_str = DisplayFormatters.formatByteCountToKiBEtc(total_size)) ? MessageText.getString("label.n.will.be.downloaded", new String[]{tot_str}) : MessageText.getString("OpenTorrentWindow.filesInfo", new String[]{sel_str, tot_str});
        this.torrents_info_label.setText(text);
    }

    @Override
    public void updateUI() {
        if (this.tvTorrents != null) {
            this.tvTorrents.refreshTable(false);
        }
        for (OpenTorrentInstance instance : this.open_instances) {
            instance.updateUI();
        }
        if (this.multi_selection_instance != null) {
            this.multi_selection_instance.updateUI();
        }
    }

    @Override
    public String getUpdateUIName() {
        return null;
    }

    private void swt_activate() {
        Shell shell = this.dlg.getShell();
        if (!shell.isDisposed()) {
            if (!shell.isVisible()) {
                shell.setVisible(true);
            }
            shell.forceActive();
            shell.layout(true, true);
            Utils.verifyShellRect(shell, true);
        }
    }

    private Shell getShell() {
        return this.dlg.getShell();
    }

    private Rectangle getBounds() {
        return this.dlg.getShell().getBounds();
    }

    private Image loadImage(String key) {
        Image img = this.image_loader.getImage(key);
        if (img != null) {
            this.images_to_dispose.add(key);
        }
        return img;
    }

    private void unloadImage(String key) {
        this.image_loader.releaseImage(key);
    }

    protected void dispose() {
        UIUpdaterSWT.getInstance().removeUpdater(this);
        for (OpenTorrentInstance instance : this.open_instances) {
            instance.dispose();
        }
        for (String key : this.images_to_dispose) {
            this.unloadImage(key);
        }
        this.images_to_dispose.clear();
        this.tvTorrents.delete();
        this.tvTorrents = null;
        for (Object[] entry : this.paramListeners) {
            COConfigurationManager.removeParameterListener((String)entry[0], (ParameterListener)entry[1]);
        }
    }

    public static Tag getExistingTag(List<Tag> initialTags, String tagName) {
        for (Tag tag : initialTags) {
            if (!tagName.equalsIgnoreCase(tag.getTagName(false)) && !tagName.equalsIgnoreCase(tag.getTagName(true))) continue;
            return tag;
        }
        return null;
    }

    private static class DiscoveredTag
    extends TagBase {
        private static final AtomicInteger tag_ids = new AtomicInteger();
        private final String name;
        private final String[] networks;
        private Tag existingTag;

        private DiscoveredTag(String _name, String[] _networks) {
            super(new TagTypeDiscovery(), tag_ids.incrementAndGet(), _name);
            TagType tt_swarm;
            Tag st;
            this.name = _name;
            this.networks = _networks;
            this.setGroup(MessageText.getString("tag.discovery.view.heading"));
            this.setImageID("image.sidebar.rcm");
            TagManager tm = TagManagerFactory.getTagManager();
            TagType tt = tm.getTagType(3);
            List<Tag> tags = tt.getTags();
            this.existingTag = OpenTorrentOptionsWindow.getExistingTag(tags, _name);
            if (this.networks != null && this.networks.length > 0) {
                boolean boring = false;
                String nets_str = "";
                String[] stringArray = this.networks;
                int n = this.networks.length;
                int n2 = 0;
                while (n2 < n) {
                    String net = stringArray[n2];
                    if (net == "Public") {
                        boring = true;
                        break;
                    }
                    nets_str = String.valueOf(nets_str) + (nets_str.length() == 0 ? "" : "/") + net;
                    ++n2;
                }
                if (!boring && nets_str.length() > 0) {
                    this.setDescription("[" + nets_str + "]");
                }
            }
            if (!TagUtils.isInternalTagName(this.name) && (st = (tt_swarm = tm.getTagType(7)).getTag(this.name, true)) == null) {
                try {
                    tt_swarm.createTag(this.name, true);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }

        @Override
        public int getTaggableTypes() {
            return 0;
        }

        @Override
        public int getTaggedCount() {
            return 0;
        }

        @Override
        public Set<Taggable> getTagged() {
            return null;
        }

        @Override
        public boolean hasTaggable(Taggable t) {
            return false;
        }

        private static class TagTypeDiscovery
        extends TagTypeBase {
            private final int[] color_default;

            public TagTypeDiscovery() {
                super(6, 0, MessageText.getString("tagtype.discovered"));
                int[] nArray = new int[3];
                nArray[1] = 80;
                nArray[2] = 80;
                this.color_default = nArray;
            }

            @Override
            public List<Tag> getTags() {
                return new ArrayList<Tag>();
            }

            @Override
            public int getTagCount() {
                return 0;
            }

            @Override
            public int[] getColorDefault() {
                return this.color_default;
            }
        }
    }

    protected class OpenTorrentInstance
    implements TableViewFilterCheck<TorrentOpenFileOptions>,
    ParameterListener {
        private final HashWrapper hash;
        private final TorrentOpenOptions torrentOptions;
        private final List<TorrentOpenOptions> torrentOptionsMulti;
        private final boolean isSingleOptions;
        private final OpenTorrentInstanceListener changeListener;
        private final Composite parent;
        private final Shell shell;
        private SWTSkin skin;
        private boolean nativeExpandBar;
        protected boolean bSkipDataDirModify = false;
        private Button btnTreeView;
        private Button btnPrivacy;
        private Button btnCheckComments;
        private Button btnCheckAvailability;
        private Button btnSwarmIt;
        private List<BooleanSwtParameter> network_buttons = new ArrayList<BooleanSwtParameter>();
        private List<BooleanSwtParameter> peer_source_buttons = new ArrayList<BooleanSwtParameter>();
        private BooleanSwtParameter ip_filter_button;
        private IntSwtParameter max_up_speed_button;
        private IntSwtParameter max_down_speed_button;
        private boolean cmbDataDirEnabled = true;
        private Combo cmbDataDir;
        private Button btnDataDir;
        private Button btnSearch;
        private Combo cmbQueueLocation;
        private Button btnSequentialDownload;
        private Combo cmbStartMode;
        private volatile boolean diskFreeInfoRefreshPending = false;
        private volatile boolean diskFreeInfoRefreshRunning = false;
        private Composite diskspaceComp;
        private long currentSelectedDataSize;
        private Map<StringInterner.DirKey, FileStatsCacheItem> fileStatCache = new HashMap<StringInterner.DirKey, FileStatsCacheItem>();
        private Map<StringInterner.DirKey, String> parentToRootCache = new HashMap<StringInterner.DirKey, String>();
        private SWTSkinObjectExpandItem soExpandItemFiles;
        private SWTSkinObjectExpandItem soExpandItemSaveTo;
        private SWTSkinObjectExpandItem soExpandItemTorrentInfo;
        private SWTSkinObjectText soFileAreaInfo;
        private TableViewSWT<TorrentOpenFileOptions> tvFiles;
        private Text txtSubFolder;
        private SWTSkinObjectExpandItem soStartOptionsExpandItem;
        private AtomicInteger settingToDownload = new AtomicInteger(0);
        private Button btnSelectAll;
        private Button btnMarkSelected;
        private Button btnUnmarkSelected;
        private Button btnRename;
        private Button btnRetarget;
        protected Map<String, DiscoveredTag> listDiscoveredTags = new TreeMap<String, DiscoveredTag>();
        private Composite tagButtonsArea;
        private TagFeatureFileLocation tag_save_location;
        private boolean treeViewDisableUpdates;
        private Set<TreeNode> treePendingExpansions = new HashSet<TreeNode>();
        private TagButtonsUI tagButtonsUI;
        private boolean tbp_building = false;
        private boolean tbp_build_pending = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OpenTorrentInstance(HashWrapper _hash, Composite _parent, TorrentOpenOptions _torrentOptions, OpenTorrentInstanceListener _changeListener) {
            this.hash = _hash;
            this.parent = _parent;
            this.torrentOptions = _torrentOptions;
            this.torrentOptionsMulti = new ArrayList<TorrentOpenOptions>();
            this.torrentOptionsMulti.add(this.torrentOptions);
            this.isSingleOptions = true;
            this.changeListener = _changeListener;
            this.shell = this.parent.getShell();
            COConfigurationManager.addParameterListener(new String[]{"File.Torrent.AutoSkipExtensions", "File.Torrent.AutoSkipFiles", "File.Torrent.AutoSkipFiles.RegExp", "File.Torrent.AutoSkipMinSizeKB", "priorityExtensions", "priorityExtensionsIgnoreCase"}, (ParameterListener)this);
            this.torrentOptions.addListener(new TorrentOpenOptions.FileListener(){

                @Override
                public void toDownloadChanged(TorrentOpenFileOptions fo, boolean toDownload) {
                    TableRowCore row = OpenTorrentInstance.this.tvFiles.getRow(fo);
                    if (row != null) {
                        row.invalidate(true);
                        row.refresh(true);
                    }
                    if (OpenTorrentInstance.this.settingToDownload.get() == 0) {
                        OpenTorrentInstance.this.updateFileButtons();
                        OpenTorrentInstance.this.updateSize();
                    }
                }

                @Override
                public void priorityChanged(TorrentOpenFileOptions fo, int priority) {
                    TableRowCore row = OpenTorrentInstance.this.tvFiles.getRow(fo);
                    if (row != null) {
                        row.invalidate(true);
                        row.refresh(true);
                    }
                }

                @Override
                public void parentDirChanged() {
                    if (OpenTorrentInstance.this.isSingleOptions && OpenTorrentInstance.this.cmbDataDir != null) {
                        String toText = OpenTorrentInstance.this.torrentOptions.getParentDir();
                        String text = OpenTorrentInstance.this.cmbDataDir.getText();
                        if (!text.equals(toText)) {
                            OpenTorrentInstance.this.cmbDataDir.setText(toText);
                        }
                    }
                }

                @Override
                public void initialTagsChanged() {
                    OpenTorrentInstance.this.updateStartOptionsHeader();
                    OpenTorrentInstance.this.buildTagButtonPanel();
                }

                @Override
                public void startOptionsChanged() {
                    if (OpenTorrentInstance.this.isSingleOptions) {
                        OpenTorrentInstance.this.cmbStartMode.select(OpenTorrentInstance.this.torrentOptions.getStartMode());
                        OpenTorrentInstance.this.cmbQueueLocation.select(OpenTorrentInstance.this.torrentOptions.getQueueLocation());
                        OpenTorrentInstance.this.btnSequentialDownload.setSelection(OpenTorrentInstance.this.torrentOptions.getSequentialDownload());
                        OpenTorrentInstance.this.updateStartOptionsHeader();
                    }
                }
            });
            if (TagManagerFactory.getTagManager().isEnabled()) {
                Map<String, Boolean> enabledNetworks = this.torrentOptions.getEnabledNetworks();
                ArrayList<String> networks = new ArrayList<String>();
                for (Map.Entry<String, Boolean> entry : enabledNetworks.entrySet()) {
                    if (!entry.getValue().booleanValue()) continue;
                    networks.add(entry.getKey());
                }
                if (networks.size() > 0) {
                    String[] nets = networks.toArray(new String[networks.size()]);
                    List<String> tag_cache = TorrentUtils.getTagCache(this.torrentOptions.getTorrent());
                    Map<String, DiscoveredTag> map = this.listDiscoveredTags;
                    synchronized (map) {
                        for (String tag : tag_cache) {
                            String lcTag = tag.toLowerCase();
                            if (this.listDiscoveredTags.containsKey(lcTag)) continue;
                            this.listDiscoveredTags.put(lcTag, new DiscoveredTag(tag, nets));
                            this.torrentOptions.addSwarmTag(tag);
                        }
                    }
                    OpenTorrentOptionsWindow.rcmSearch(this.hash, nets);
                }
            }
        }

        private OpenTorrentInstance(Composite _parent, List<TorrentOpenOptions> _torrentOptionsMulti, OpenTorrentInstanceListener _changeListener) {
            this.hash = null;
            this.parent = _parent;
            this.torrentOptions = null;
            this.torrentOptionsMulti = new ArrayList<TorrentOpenOptions>(_torrentOptionsMulti);
            this.isSingleOptions = false;
            this.changeListener = _changeListener;
            this.diskFreeInfoRefreshPending = true;
            this.shell = this.parent.getShell();
        }

        private HashWrapper getHash() {
            return this.hash;
        }

        protected TorrentOpenOptions getOptions() {
            return this.torrentOptions;
        }

        protected int getIndex() {
            return OpenTorrentOptionsWindow.this.open_instances.indexOf(this);
        }

        protected Composite getComposite() {
            return this.parent;
        }

        @Override
        public void parameterChanged(String parameterName) {
            if (this.isSingleOptions) {
                this.torrentOptions.applyPriorityAndSkipConfig();
            }
        }

        private void initialize() {
            SWTSkinObject so;
            this.skin = SWTSkinFactory.getNonPersistentInstance(this.getClass().getClassLoader(), "com/biglybt/ui/skin", "skin3_dlg_opentorrent_options_instance.properties");
            this.skin.initialize(this.parent, "expandview");
            SWTSkinObjectExpandBar eb = (SWTSkinObjectExpandBar)((Object)this.skin.getSkinObject("expand-bar"));
            this.nativeExpandBar = eb.isNative();
            if (!this.nativeExpandBar && !Utils.isDarkAppearanceNative()) {
                this.skin.getShell().setBackground(Colors.white);
                this.skin.getShell().setBackgroundMode(2);
            }
            if (this.isSingleOptions) {
                so = this.skin.getSkinObject("filearea-table");
                if (so instanceof SWTSkinObjectContainer) {
                    this.setupTVFiles((SWTSkinObjectContainer)so, (SWTSkinObjectTextbox)this.skin.getSkinObject("filearea-filter"));
                }
                if ((so = this.skin.getSkinObject("filearea-buttons")) instanceof SWTSkinObjectContainer) {
                    this.setupFileAreaButtons((SWTSkinObjectContainer)so);
                }
            } else {
                SWTSkinObjectExpandItem expInfo = (SWTSkinObjectExpandItem)((Object)this.skin.getSkinObject("expanditem-torrentinfo"));
                SWTSkinObjectExpandItem expFiles = (SWTSkinObjectExpandItem)((Object)this.skin.getSkinObject("expanditem-files"));
                SWTSkinObjectExpandItem expPeer = (SWTSkinObjectExpandItem)((Object)this.skin.getSkinObject("expanditem-peer"));
                expInfo.setText("");
                expFiles.setText("");
            }
            if ((so = this.skin.getSkinObject("disk-space")) instanceof SWTSkinObjectContainer) {
                this.diskspaceComp = (Composite)so.getControl();
                GridLayout gl = new GridLayout(2, false);
                gl.marginWidth = 0;
                gl.marginHeight = 0;
                this.diskspaceComp.setLayout((Layout)gl);
                Label l = new Label(this.diskspaceComp, 0);
                l.setText("");
            }
            if (this.isSingleOptions) {
                so = this.skin.getSkinObject("filearea-info");
                if (so instanceof SWTSkinObjectText) {
                    this.setupFileAreaInfo((SWTSkinObjectText)so);
                }
            } else {
                this.skin.getSkinProperties().addProperty("toptions.filearea.fillheight", null);
                this.skin.getSkinProperties().addProperty("toptions.filearea.fillheightmin", null);
            }
            if ((so = this.skin.getSkinObject("start-options")) instanceof SWTSkinObjectExpandItem) {
                this.setupStartOptions((SWTSkinObjectExpandItem)((Object)so));
            }
            if ((so = this.skin.getSkinObject("peer-sources")) instanceof SWTSkinObjectContainer) {
                this.setupPeerSourcesAndNetworkOptions((SWTSkinObjectContainer)so);
            }
            if ((so = this.skin.getSkinObject("trackers")) instanceof SWTSkinObjectContainer) {
                this.setupTrackers((SWTSkinObjectContainer)so);
            }
            if ((so = this.skin.getSkinObject("updownlimit")) instanceof SWTSkinObjectContainer) {
                this.setupUpDownLimitOption((SWTSkinObjectContainer)so);
            }
            if ((so = this.skin.getSkinObject("ipfilter")) instanceof SWTSkinObjectContainer) {
                this.setupIPFilterOption((SWTSkinObjectContainer)so);
            }
            SWTSkinObject so_ta = this.skin.getSkinObject("saveto-textarea");
            SWTSkinObject so_b = this.skin.getSkinObject("saveto-browse");
            SWTSkinObject so_s = this.skin.getSkinObject("saveto-search");
            SWTSkinObject so_m = this.skin.getSkinObject("saveto-more");
            if (so_ta instanceof SWTSkinObjectContainer && so_b instanceof SWTSkinObjectButton && so_m instanceof SWTSkinObjectContainer) {
                this.setupSaveLocation((SWTSkinObjectContainer)so_ta, (SWTSkinObjectButton)so_b, (SWTSkinObjectButton)so_s, (SWTSkinObjectContainer)so_m);
            }
            if ((so = this.skin.getSkinObject("expanditem-saveto")) instanceof SWTSkinObjectExpandItem) {
                this.soExpandItemSaveTo = (SWTSkinObjectExpandItem)((Object)so);
            }
            if (this.isSingleOptions) {
                so = this.skin.getSkinObject("expanditem-files");
                if (so instanceof SWTSkinObjectExpandItem) {
                    this.soExpandItemFiles = (SWTSkinObjectExpandItem)((Object)so);
                }
                this.setupInfoSection(this.skin);
            }
            this.updateStartOptionsHeader();
            if (this.tagButtonsUI != null) {
                this.updateInitialSaveTags(this.tagButtonsUI.getSelectedTags(), null);
            }
            if (this.isSingleOptions) {
                this.cmbDataDirChanged();
                this.updateSize();
            } else {
                this.updateDataDirCombo();
            }
            this.skin.layout();
            if (this.btnDataDir != null && this.btnSearch != null) {
                Utils.makeButtonsEqualWidth(this.btnDataDir, this.btnSearch);
            }
        }

        private void layout() {
            SWTSkinObjectExpandItem so = (SWTSkinObjectExpandItem)((Object)this.skin.getSkinObject("expanditem-saveto"));
            if (so != null) {
                SWTSkinObjectExpandBar bar = (SWTSkinObjectExpandBar)((Object)so.getParent());
                bar.relayout();
                SWTSkinObjectExpandItem[] sWTSkinObjectExpandItemArray = bar.getChildren();
                int n = sWTSkinObjectExpandItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SWTSkinObjectExpandItem item = sWTSkinObjectExpandItemArray[n2];
                    item.relayout();
                    ++n2;
                }
            }
        }

        private void refresh() {
            if (this.tagButtonsArea == null || this.tagButtonsArea.isDisposed()) {
                return;
            }
            this.tagButtonsUI.updateFields(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rcmTagFound(String tag, String[] nets) {
            String lcTag = tag.toLowerCase();
            Map<String, DiscoveredTag> map = this.listDiscoveredTags;
            synchronized (map) {
                if (this.listDiscoveredTags.containsKey(lcTag)) {
                    return;
                }
                this.listDiscoveredTags.put(lcTag, new DiscoveredTag(tag, nets));
                this.torrentOptions.addSwarmTag(tag);
            }
            this.buildTagButtonPanel();
        }

        private void showTreeView() {
            final Shell tree_shell = ShellFactory.createShell(this.shell, 2160);
            Utils.setShellIcon(tree_shell);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            tree_shell.setLayout((Layout)layout);
            Utils.verifyShellRect(tree_shell, true);
            TOTorrent t = this.torrentOptions.getTorrent();
            Composite comp2 = new Composite((Composite)tree_shell, 0);
            GridData gridData = new GridData(1808);
            comp2.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            comp2.setLayout((Layout)layout);
            TOTorrentFile[] torrent_files = t.getFiles();
            TorrentOpenFileOptions[] files = this.torrentOptions.getFiles();
            char file_separator = File.separatorChar;
            final TreeNode root = new TreeNode(null, "");
            final HashMap<TorrentOpenFileOptions, TreeNode> file_map = new HashMap<TorrentOpenFileOptions, TreeNode>();
            TorrentOpenFileOptions[] torrentOpenFileOptionsArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isLeaf;
                TorrentOpenFileOptions file = torrentOpenFileOptionsArray[n2];
                TreeNode node = root;
                TOTorrentFile t_file = torrent_files[file.getIndex()];
                String path = t_file.getRelativePath();
                int pos = 0;
                int len = path.length();
                do {
                    String bit;
                    int p;
                    if ((p = path.indexOf(file_separator, pos)) == -1) {
                        bit = path.substring(pos);
                    } else {
                        bit = path.substring(pos, p);
                        pos = p + 1;
                    }
                    isLeaf = p == -1 || pos == len;
                    TreeNode n3 = node.getChild(bit);
                    if (n3 == null) {
                        n3 = new TreeNode(node, isLeaf ? bit : StringInterner.intern(bit));
                        node.addChild(n3);
                    }
                    node = n3;
                } while (!isLeaf);
                node.setFile(file);
                file_map.put(file, node);
                ++n2;
            }
            this.treePendingExpansions.clear();
            final Tree tree = new Tree(comp2, 268438306);
            gridData = new GridData(1808);
            tree.setLayoutData((Object)gridData);
            tree.setHeaderVisible(true);
            tree.setLinesVisible(true);
            int[] COL_WIDTHS = new int[]{600, 80, 80};
            TreeColumn column1 = new TreeColumn(tree, 16384);
            column1.setText(String.valueOf(MessageText.getString("TableColumn.header.name")) + " ");
            TreeColumn column2 = new TreeColumn(tree, 131072);
            column2.setText(String.valueOf(MessageText.getString("TableColumn.header.size")) + " ");
            TreeColumn column3 = new TreeColumn(tree, 131072);
            column3.setText(String.valueOf(MessageText.getString("SpeedView.stats.total")) + " ");
            TreeColumn[] columns = new TreeColumn[]{column1, column2, column3};
            SelectionAdapter column_listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TreeColumn column = (TreeColumn)e.widget;
                    int index = (Integer)column.getData("index");
                    boolean asc = (Boolean)column.getData("asc");
                    asc = !asc;
                    column.setData("asc", (Object)asc);
                    OpenTorrentInstance.this.sortTree(tree, root, index, asc);
                }
            };
            int i = 0;
            while (i < columns.length) {
                final TreeColumn column = columns[i];
                column.setData("asc", (Object)true);
                column.setData("index", (Object)i);
                column.addSelectionListener((SelectionListener)column_listener);
                final String key = "open.torrent.window.tree.col." + i;
                int width = COConfigurationManager.getIntParameter(key, COL_WIDTHS[i]);
                column.setWidth(Math.max(20, width));
                column.addListener(11, new Listener(){

                    public void handleEvent(Event event2) {
                        COConfigurationManager.setParameter(key, column.getWidth());
                    }
                });
                ++i;
            }
            tree.setData((Object)root);
            tree.addListener(36, new Listener(){

                public void handleEvent(Event event2) {
                    TreeItem item = (TreeItem)event2.item;
                    TreeItem parentItem = item.getParentItem();
                    TreeNode parent_node = parentItem == null ? root : (TreeNode)parentItem.getData();
                    TreeNode[] kids = parent_node.getChildren();
                    TreeNode node = kids[event2.index];
                    item.setData((Object)node);
                    OpenTorrentInstance.this.updateTreeItem(item, node);
                    TreeNode[] node_kids = node.getChildren();
                    if (node_kids.length > 0) {
                        item.setItemCount(node_kids.length);
                    }
                }
            });
            tree.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    if (event2.detail == 32) {
                        TreeItem item = (TreeItem)event2.item;
                        boolean checked = item.getChecked();
                        TreeNode node = (TreeNode)item.getData();
                        OpenTorrentInstance.this.updateNodeFromTree(tree, item, node, checked);
                    }
                }
            });
            final Menu menu = new Menu((Control)tree);
            tree.setMenu(menu);
            menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    TreeItem[] items;
                    MenuItem[] menu_items = menu.getItems();
                    int i = 0;
                    while (i < menu_items.length) {
                        menu_items[i].dispose();
                        ++i;
                    }
                    boolean has_selected = false;
                    boolean has_deselected = false;
                    TreeItem[] treeItemArray = items = tree.getSelection();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        if (item.getChecked()) {
                            has_selected = true;
                        } else {
                            has_deselected = true;
                        }
                        ++n2;
                    }
                    MenuItem select_item = new MenuItem(menu, 0);
                    select_item.setText(MessageText.getString("label.select"));
                    select_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            TreeItem[] treeItemArray = items;
                            int n = items.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TreeItem item = treeItemArray[n2];
                                item.setChecked(true);
                                TreeNode node = (TreeNode)item.getData();
                                OpenTorrentInstance.this.updateNodeFromTree(tree, item, node, true);
                                ++n2;
                            }
                        }
                    });
                    select_item.setEnabled(has_deselected);
                    MenuItem deselect_item = new MenuItem(menu, 0);
                    deselect_item.setText(MessageText.getString("label.deselect"));
                    deselect_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            TreeItem[] treeItemArray = items;
                            int n = items.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TreeItem item = treeItemArray[n2];
                                item.setChecked(false);
                                TreeNode node = (TreeNode)item.getData();
                                OpenTorrentInstance.this.updateNodeFromTree(tree, item, node, false);
                                ++n2;
                            }
                        }
                    });
                    deselect_item.setEnabled(has_selected);
                    final TreeItem[] ex_items = items.length == 0 ? tree.getItems() : items;
                    final Set unexpanded_nodes = OpenTorrentInstance.this.getUnExpandedNodes(ex_items);
                    MenuItem expand_item = new MenuItem(menu, 0);
                    expand_item.setText(MessageText.getString("label.expand.all"));
                    expand_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            OpenTorrentInstance.this.treePendingExpansions.addAll(unexpanded_nodes);
                            OpenTorrentInstance.this.expandItems(ex_items);
                        }
                    });
                    expand_item.setEnabled(unexpanded_nodes.size() > 0);
                }
            });
            tree.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int key = e.character;
                    if (key <= 26 && key > 0) {
                        key += 96;
                    }
                    if (e.stateMask == SWT.MOD1 && key == 97) {
                        tree.selectAll();
                    }
                }
            });
            tree.setItemCount(root.getChildren().length);
            Control labelSeparator = Utils.createSkinnedLabelSeparator(comp2, 256);
            gridData = new GridData(768);
            labelSeparator.setLayoutData((Object)gridData);
            Composite buttonComp = new Composite(comp2, 0);
            gridData = new GridData(768);
            buttonComp.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.numColumns = 2;
            buttonComp.setLayout((Layout)layout);
            new Label(buttonComp, 0);
            Composite buttonArea = new Composite(buttonComp, 0);
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            buttonArea.setLayoutData((Object)gridData);
            GridLayout layoutButtons = new GridLayout();
            layoutButtons.numColumns = 1;
            buttonArea.setLayout((Layout)layoutButtons);
            ArrayList<Button> buttons = new ArrayList<Button>();
            Button bOK = new Button(buttonArea, 8);
            buttons.add(bOK);
            bOK.setText(MessageText.getString("Button.ok"));
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 70;
            bOK.setLayoutData((Object)gridData);
            bOK.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    tree_shell.dispose();
                }
            });
            Utils.makeButtonsEqualWidth(buttons);
            tree_shell.setDefaultButton(bOK);
            this.btnTreeView.setEnabled(false);
            final TorrentOpenOptions.FileListener file_listener = new TorrentOpenOptions.FileListener(){

                @Override
                public void toDownloadChanged(TorrentOpenFileOptions file, boolean checked) {
                    OpenTorrentInstance.this.updateNodeFromTable(tree, (TreeNode)file_map.get(file), checked);
                }

                @Override
                public void priorityChanged(TorrentOpenFileOptions torrentOpenFileOptions, int priority) {
                }

                @Override
                public void parentDirChanged() {
                }

                @Override
                public void initialTagsChanged() {
                }
            };
            this.torrentOptions.addListener(file_listener);
            tree_shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (!OpenTorrentInstance.this.btnTreeView.isDisposed()) {
                        OpenTorrentInstance.this.btnTreeView.setEnabled(true);
                        OpenTorrentInstance.this.torrentOptions.removeListener(file_listener);
                    }
                }
            });
            tree_shell.addListener(11, new Listener(){

                public void handleEvent(Event event2) {
                    Rectangle bounds = tree_shell.getBounds();
                    COConfigurationManager.setParameter("open.torrent.window.tree.size", String.valueOf(bounds.width) + "," + bounds.height);
                }
            });
            int shell_width = 800;
            int shell_height = 400;
            try {
                String str = COConfigurationManager.getStringParameter("open.torrent.window.tree.size", "");
                String[] bits = str.split(",");
                if (bits.length == 2) {
                    shell_width = Math.max(300, Integer.parseInt(bits[0]));
                    shell_height = Math.max(200, Integer.parseInt(bits[1]));
                }
            }
            catch (Throwable str) {
                // empty catch block
            }
            tree_shell.setSize(shell_width, shell_height);
            tree_shell.layout(true, true);
            Utils.centerWindowRelativeTo(tree_shell, (Control)this.shell);
            String title = this.torrentOptions.getDisplayName();
            Messages.setLanguageText((Widget)tree_shell, "torrent.files.title", title);
            tree_shell.open();
        }

        private void sortTree(Tree tree, TreeNode root, final int col_index, final boolean asc) {
            Comparator<TreeNode> comparator = new Comparator<TreeNode>(){

                @Override
                public int compare(TreeNode n1, TreeNode n2) {
                    if (!asc) {
                        TreeNode temp = n1;
                        n1 = n2;
                        n2 = temp;
                    }
                    if (col_index == 0) {
                        String name1 = n1.getName();
                        String name2 = n2.getName();
                        return tree_comp.compare(name1, name2);
                    }
                    if (col_index == 1 || col_index == 2) {
                        long result;
                        long size1 = n1.getSize();
                        long size2 = n2.getSize();
                        if (size1 < 0L) {
                            size1 = -size1;
                        }
                        if (size2 < 0L) {
                            size2 = -size2;
                        }
                        if ((result = size1 - size2) == 0L) {
                            return 0;
                        }
                        if (result < 0L) {
                            return -1;
                        }
                        return 1;
                    }
                    return 0;
                }
            };
            this.getExpandedNodes(tree.getItems(), this.treePendingExpansions);
            tree.removeAll();
            root.sort(comparator);
            tree.setItemCount(root.getChildren().length);
        }

        private void getExpandedNodes(TreeItem[] items, Set<TreeNode> nodes) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getExpanded()) {
                    nodes.add((TreeNode)item.getData());
                }
                this.getExpandedNodes(item.getItems(), nodes);
                ++n2;
            }
        }

        private Set<TreeNode> getUnExpandedNodes(TreeItem[] items) {
            HashSet<TreeNode> all_nodes = new HashSet<TreeNode>();
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                this.getNodes((TreeNode)item.getData(), all_nodes, true);
                ++n2;
            }
            HashSet<TreeNode> expanded_nodes = new HashSet<TreeNode>();
            this.getExpandedNodes(items, expanded_nodes);
            all_nodes.removeAll(expanded_nodes);
            return all_nodes;
        }

        private void expandItems(TreeItem[] items) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                item.setExpanded(true);
                this.expandItems(item.getItems());
                ++n2;
            }
        }

        private void getNodes(TreeNode node, Set<TreeNode> nodes, boolean parents_only) {
            TreeNode[] kids = node.getChildren();
            if (parents_only && kids.length == 0) {
                return;
            }
            nodes.add(node);
            TreeNode[] treeNodeArray = kids;
            int n = kids.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode kid = treeNodeArray[n2];
                this.getNodes(kid, nodes, parents_only);
                ++n2;
            }
        }

        private void updateTreeItem(final TreeItem item, final TreeNode node) {
            String total_str;
            String size_str;
            long size = node.getSize();
            String abs_size_str = DisplayFormatters.formatByteCountToKiBEtc(Math.abs(size));
            if (size >= 0L) {
                size_str = abs_size_str;
                total_str = "";
            } else {
                size_str = "";
                total_str = abs_size_str;
            }
            item.setText(new String[]{node.getName(), size_str, total_str});
            item.setChecked(node.isChecked());
            item.setGrayed(node.isGrayed());
            item.setForeground(2, Colors.dark_grey);
            if (this.treePendingExpansions.contains(node)) {
                Utils.execSWTThreadLater(1, new Runnable(){

                    @Override
                    public void run() {
                        if (!item.isDisposed()) {
                            item.setExpanded(true);
                            OpenTorrentInstance.this.treePendingExpansions.remove(node);
                        }
                    }
                });
            }
        }

        private TreeItem getItemForNode(Tree tree, TreeNode node) {
            TreeNode parent;
            ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
            nodes.add(node);
            while ((parent = node.getParent()) != null) {
                nodes.add(parent);
                node = parent;
            }
            TreeItem target_item = null;
            int i = nodes.size() - 2;
            while (i >= 0) {
                block10: {
                    TreeItem[] items;
                    TreeNode n;
                    block9: {
                        block8: {
                            n = (TreeNode)nodes.get(i);
                            if (target_item != null) break block8;
                            items = tree.getItems();
                            break block9;
                        }
                        if (target_item.getItemCount() == 0) break block10;
                        items = target_item.getItems();
                    }
                    boolean found = false;
                    TreeItem[] treeItemArray = items;
                    int n2 = items.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        TreeItem item = treeItemArray[n3];
                        if (item.getData() == n) {
                            target_item = item;
                            found = true;
                            break;
                        }
                        ++n3;
                    }
                    if (!found) {
                        return null;
                    }
                }
                --i;
            }
            return target_item;
        }

        private void updateNodeFromTree(Tree tree, TreeItem item, TreeNode node, boolean selected) {
            block10: {
                try {
                    this.treeViewDisableUpdates = true;
                    boolean refresh_path = false;
                    TorrentOpenFileOptions file = node.getFile();
                    if (file != null) {
                        if (file.isToDownload() != selected) {
                            file.setToDownload(selected);
                            refresh_path = true;
                        }
                    } else {
                        item.setGrayed(false);
                        List files = node.getFiles();
                        for (TorrentOpenFileOptions f : files) {
                            if (f.isToDownload() == selected) continue;
                            f.setToDownload(selected);
                            refresh_path = true;
                        }
                        if (refresh_path) {
                            this.updateSubTree(item.getItems());
                        }
                    }
                    if (!refresh_path) break block10;
                    while ((item = item.getParentItem()) != null) {
                        node = node.getParent();
                        item.setChecked(node.isChecked());
                        item.setGrayed(node.isGrayed());
                    }
                }
                finally {
                    this.treeViewDisableUpdates = false;
                }
            }
        }

        private void updateSubTree(TreeItem[] items) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                TreeNode node = (TreeNode)item.getData();
                if (node != null) {
                    TreeItem[] sub_items;
                    boolean checked = node.isChecked();
                    if (item.getChecked() != checked) {
                        item.setChecked(checked);
                    }
                    boolean grayed = node.isGrayed();
                    if (item.getGrayed() != grayed) {
                        item.setGrayed(grayed);
                    }
                    if ((sub_items = item.getItems()).length > 0) {
                        this.updateSubTree(sub_items);
                    }
                }
                ++n2;
            }
        }

        private void updateNodeFromTable(Tree tree, TreeNode node, boolean selected) {
            block5: {
                TreeItem item;
                block6: {
                    if (this.treeViewDisableUpdates) {
                        return;
                    }
                    item = this.getItemForNode(tree, node);
                    if (item == null) break block6;
                    if (item.getChecked() == selected) break block5;
                    item.setChecked(selected);
                    while ((item = item.getParentItem()) != null) {
                        node = node.getParent();
                        item.setChecked(node.isChecked());
                        item.setGrayed(node.isGrayed());
                    }
                    break block5;
                }
                while ((node = node.getParent()) != null) {
                    item = this.getItemForNode(tree, node);
                    if (item == null) continue;
                    while (true) {
                        item.setChecked(node.isChecked());
                        item.setGrayed(node.isGrayed());
                        item = item.getParentItem();
                        if (item != null) {
                            node = node.getParent();
                            continue;
                        }
                        break block5;
                        break;
                    }
                }
            }
        }

        private void showAvailability() {
            final Shell avail_shell = ShellFactory.createShell(this.shell, 2160);
            Utils.setShellIcon(avail_shell);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            avail_shell.setLayout((Layout)layout);
            Utils.verifyShellRect(avail_shell, true);
            TOTorrent t = this.torrentOptions.getTorrent();
            final TrackerAvailView view = new TrackerAvailView();
            String[] enabled_peer_sources = PEPeerSource.PS_SOURCES;
            if (this.torrentOptions.peerSource != null) {
                ArrayList<String> temp = new ArrayList<String>(Arrays.asList(enabled_peer_sources));
                for (String peerSource : this.torrentOptions.peerSource.keySet()) {
                    boolean enable = this.torrentOptions.peerSource.get(peerSource);
                    if (enable) continue;
                    temp.remove(peerSource);
                }
                enabled_peer_sources = temp.toArray(new String[temp.size()]);
            }
            String[] enabled_networks = AENetworkClassifier.AT_NETWORKS;
            Map<String, Boolean> enabledNetworks = this.torrentOptions.getEnabledNetworks();
            if (enabledNetworks != null) {
                ArrayList<String> temp = new ArrayList<String>(Arrays.asList(enabled_networks));
                for (String net : enabledNetworks.keySet()) {
                    boolean enable = enabledNetworks.get(net);
                    if (enable) continue;
                    temp.remove(net);
                }
                enabled_networks = temp.toArray(new String[temp.size()]);
            }
            final DownloadManagerAvailability availability = DownloadManagerFactory.getAvailability(t, this.torrentOptions.getTrackers(true), enabled_peer_sources, enabled_networks);
            Composite comp2 = new Composite((Composite)avail_shell, 0);
            GridData gridData = new GridData(1808);
            comp2.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            comp2.setLayout((Layout)layout);
            view.setEnableTabViews(false);
            view.initialize(comp2);
            view.dataSourceChanged(availability);
            view.viewActivated();
            view.refresh();
            final UIUpdatable viewUpdater = new UIUpdatable(){

                @Override
                public void updateUI() {
                    view.refresh();
                }

                @Override
                public String getUpdateUIName() {
                    return view.getFullTitle();
                }
            };
            UIUpdaterSWT.getInstance().addUpdater(viewUpdater);
            Composite progressComp = new Composite(comp2, 0);
            gridData = new GridData(768);
            progressComp.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.numColumns = 2;
            progressComp.setLayout((Layout)layout);
            Label progLabel = new Label(progressComp, 0);
            progLabel.setText(MessageText.getString("label.checking.sources"));
            final Composite progBarComp = new Composite(progressComp, 0);
            gridData = new GridData(768);
            progBarComp.setLayoutData((Object)gridData);
            final StackLayout progStackLayout = new StackLayout();
            progBarComp.setLayout((Layout)progStackLayout);
            final ProgressBar progBarIndeterminate = new ProgressBar(progBarComp, 258);
            gridData = new GridData(768);
            progBarIndeterminate.setLayoutData((Object)gridData);
            final ProgressBar progBarComplete = new ProgressBar(progBarComp, 256);
            gridData = new GridData(768);
            progBarComplete.setLayoutData((Object)gridData);
            progBarComplete.setMaximum(1);
            progBarComplete.setSelection(1);
            progStackLayout.topControl = progBarIndeterminate;
            new AEThread2("ProgChecker"){

                @Override
                public void run() {
                    boolean currently_updating = true;
                    while (!avail_shell.isDisposed()) {
                        final boolean updating = view.isUpdating();
                        if (updating != currently_updating) {
                            currently_updating = updating;
                            Utils.execSWTThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (!avail_shell.isDisposed()) {
                                        progStackLayout.topControl = updating ? progBarIndeterminate : progBarComplete;
                                        progBarComp.layout();
                                    }
                                }
                            });
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    return;
                }
            }.start();
            Control labelSeparator = Utils.createSkinnedLabelSeparator(comp2, 256);
            gridData = new GridData(768);
            labelSeparator.setLayoutData((Object)gridData);
            Composite buttonComp = new Composite(comp2, 0);
            gridData = new GridData(768);
            buttonComp.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.numColumns = 2;
            buttonComp.setLayout((Layout)layout);
            new Label(buttonComp, 0);
            Composite buttonArea = new Composite(buttonComp, 0);
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            buttonArea.setLayoutData((Object)gridData);
            GridLayout layoutButtons = new GridLayout();
            layoutButtons.numColumns = 1;
            buttonArea.setLayout((Layout)layoutButtons);
            ArrayList<Button> buttons = new ArrayList<Button>();
            Button bOK = new Button(buttonArea, 8);
            buttons.add(bOK);
            bOK.setText(MessageText.getString("Button.ok"));
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 70;
            bOK.setLayoutData((Object)gridData);
            bOK.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    avail_shell.dispose();
                }
            });
            Utils.makeButtonsEqualWidth(buttons);
            avail_shell.setDefaultButton(bOK);
            avail_shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    try {
                        UIUpdaterSWT.getInstance().removeUpdater(viewUpdater);
                        if (!OpenTorrentInstance.this.btnCheckAvailability.isDisposed()) {
                            OpenTorrentInstance.this.btnCheckAvailability.setEnabled(true);
                        }
                    }
                    finally {
                        availability.destroy();
                    }
                }
            });
            this.btnCheckAvailability.setEnabled(false);
            avail_shell.setSize(800, 400);
            avail_shell.layout(true, true);
            Utils.centerWindowRelativeTo(avail_shell, (Control)this.shell);
            String title = this.torrentOptions.getDisplayName();
            Messages.setLanguageText((Widget)avail_shell, "torrent.avail.title", title);
            avail_shell.open();
        }

        private void showComments() {
            final Shell comments_shell = ShellFactory.createShell(this.shell, 2160);
            Utils.setShellIcon(comments_shell);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            comments_shell.setLayout((Layout)layout);
            Utils.verifyShellRect(comments_shell, true);
            TOTorrent torrent = this.torrentOptions.getTorrent();
            final String title = this.torrentOptions.getDisplayName();
            String[] enabled_networks = AENetworkClassifier.AT_NETWORKS;
            Map<String, Boolean> enabledNetworks = this.torrentOptions.getEnabledNetworks();
            if (enabledNetworks != null) {
                ArrayList<String> temp = new ArrayList<String>(Arrays.asList(enabled_networks));
                for (String net : enabledNetworks.keySet()) {
                    boolean enable = enabledNetworks.get(net);
                    if (enable) continue;
                    temp.remove(net);
                }
                enabled_networks = temp.toArray(new String[temp.size()]);
            }
            final String[] f_enabled_networks = enabled_networks;
            Composite comp2 = new Composite((Composite)comments_shell, 0);
            GridData gridData = new GridData(1808);
            comp2.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            comp2.setLayout((Layout)layout);
            Composite topComp = new Composite(comp2, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            topComp.setLayout((Layout)layout);
            gridData = new GridData(1808);
            topComp.setLayoutData((Object)gridData);
            String active_networks_str = "";
            String[] stringArray = enabled_networks;
            int n = enabled_networks.length;
            int n2 = 0;
            while (n2 < n) {
                String net = stringArray[n2];
                active_networks_str = String.valueOf(active_networks_str) + (active_networks_str.length() == 0 ? "" : ", ") + MessageText.getString("ConfigView.section.connection.networks." + net);
                ++n2;
            }
            if (active_networks_str.length() == 0) {
                active_networks_str = MessageText.getString("label.none");
            }
            Label info_label = new Label(topComp, 64);
            info_label.setText(MessageText.getString("torrent.comments.info", new String[]{active_networks_str}));
            gridData = new GridData(768);
            gridData.horizontalIndent = 8;
            gridData.verticalIndent = 8;
            info_label.setLayoutData((Object)gridData);
            Group ratingComp = Utils.createSkinnedGroup(topComp, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            ratingComp.setText("Rating Plugin");
            ratingComp.setLayout((Layout)layout);
            gridData = new GridData(768);
            ratingComp.setLayoutData((Object)gridData);
            Composite ratingComp2 = Utils.createSkinnedComposite((Composite)ratingComp, 2048, new GridData(768));
            layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginWidth = 4;
            layout.marginHeight = 4;
            ratingComp2.setLayout((Layout)layout);
            gridData = new GridData(1808);
            ratingComp2.setLayoutData((Object)gridData);
            if (!Utils.isDarkAppearanceNative()) {
                ratingComp2.setBackground(Colors.white);
            }
            final Label ratingText = new Label(ratingComp2, 64);
            gridData = new GridData(768);
            gridData.heightHint = ratingText.getFont().getFontData()[0].getHeight() * 2 + 16;
            ratingText.setLayoutData((Object)gridData);
            if (!Utils.isDarkAppearanceNative()) {
                ratingText.setBackground(Colors.white);
            }
            final boolean[] az_rating_in_progress = new boolean[1];
            try {
                PluginManager pm = CoreFactory.getSingleton().getPluginManager();
                PluginInterface rating_pi = pm.getPluginInterfaceByID("azrating");
                if (rating_pi != null) {
                    final IPCInterface ipc = rating_pi.getIPC();
                    if (ipc.canInvoke("lookupRatingByHash", new Object[]{new String[0], new byte[0]})) {
                        az_rating_in_progress[0] = true;
                        ratingText.setText(MessageText.getString("label.searching"));
                        new AEThread2("oto:rat"){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Override
                            public void run() {
                                Map result = null;
                                try {
                                    try {
                                        result = (Map)ipc.invoke("lookupRatingByHash", new Object[]{f_enabled_networks, OpenTorrentInstance.this.hash.getBytes()});
                                    }
                                    catch (Throwable e) {
                                        e.printStackTrace();
                                        boolean[] blArray = az_rating_in_progress;
                                        synchronized (az_rating_in_progress) {
                                            az_rating_in_progress[0] = false;
                                            // ** MonitorExit[var4_3] (shouldn't be in output)
                                            if (ratingText.isDisposed()) return;
                                            Map map = result;
                                            Utils.execSWTThread(new Runnable(ratingText, map){
                                                private final /* synthetic */ Label val$ratingText;
                                                private final /* synthetic */ Map val$f_result;
                                                {
                                                    this.val$ratingText = label;
                                                    this.val$f_result = map;
                                                }

                                                @Override
                                                public void run() {
                                                    if (!this.val$ratingText.isDisposed()) {
                                                        List ratings;
                                                        String text = "";
                                                        String tooltip = "";
                                                        if (this.val$f_result != null && (ratings = (List)this.val$f_result.get("ratings")) != null) {
                                                            String scores_str = "";
                                                            ArrayList<String> comments = new ArrayList<String>();
                                                            double total_score = 0.0;
                                                            int score_num = 0;
                                                            for (Map map : ratings) {
                                                                try {
                                                                    int score = ((Number)map.get("score")).intValue();
                                                                    total_score += (double)score;
                                                                    ++score_num;
                                                                    scores_str = String.valueOf(scores_str) + (scores_str.length() == 0 ? "" : ", ") + score;
                                                                    String comment = MapUtils.getMapString(map, "comment", null);
                                                                    if (comment == null || (comment = comment.trim()).length() <= 0) continue;
                                                                    comments.add(comment);
                                                                }
                                                                catch (Throwable score) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                            if (score_num > 0) {
                                                                double average = total_score / (double)score_num;
                                                                text = MessageText.getString("torrent.comment.rat1", new String[]{DisplayFormatters.formatDecimal(average, 1), scores_str});
                                                                int num_comments = comments.size();
                                                                if (num_comments > 0) {
                                                                    text = String.valueOf(text) + "\n    " + MessageText.getString("torrent.comment.rat2", new String[]{String.valueOf((String)comments.get(0)) + (num_comments == 1 ? "" : "...")});
                                                                    for (String comment : comments) {
                                                                        tooltip = String.valueOf(tooltip) + (tooltip.length() == 0 ? "" : "\n") + comment;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        if (text.length() == 0) {
                                                            text = MessageText.getString("label.none");
                                                        }
                                                        this.val$ratingText.setText(text);
                                                        Utils.setTT((Control)this.val$ratingText, tooltip);
                                                    }
                                                }
                                            });
                                            return;
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    boolean[] blArray = az_rating_in_progress;
                                    synchronized (az_rating_in_progress) {
                                        az_rating_in_progress[0] = false;
                                        // ** MonitorExit[var4_5] (shouldn't be in output)
                                        if (ratingText.isDisposed()) throw throwable;
                                        Map map = result;
                                        Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */);
                                        throw throwable;
                                    }
                                }
                                boolean[] blArray = az_rating_in_progress;
                                synchronized (az_rating_in_progress) {
                                    az_rating_in_progress[0] = false;
                                    // ** MonitorExit[var4_7] (shouldn't be in output)
                                    if (ratingText.isDisposed()) return;
                                    Map map = result;
                                    Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */);
                                    return;
                                }
                            }
                        }.start();
                    } else {
                        ratingText.setText("Rating Plugin needs updating");
                    }
                } else {
                    ratingText.setText(MessageText.getString("torrent.comment.azrating.install"));
                }
            }
            catch (Throwable e) {
                ratingText.setText("Rating Plugin failed: " + Debug.getNestedExceptionMessage(e));
            }
            Group chatComp = Utils.createSkinnedGroup(topComp, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            chatComp.setLayout((Layout)layout);
            gridData = new GridData(768);
            chatComp.setLayoutData((Object)gridData);
            chatComp.setText("Chat Plugin");
            HashMap<String, Object> chat_properties = new HashMap<String, Object>();
            chat_properties.put("swt_comp", chatComp);
            final String chat_key = BuddyPluginUtils.getChatKey(torrent);
            BuddyPluginViewInterface.DownloadAdapter adapter = new BuddyPluginViewInterface.DownloadAdapter(){

                @Override
                public String[] getNetworks() {
                    return f_enabled_networks;
                }

                @Override
                public DownloadManager getCoreDownload() {
                    return null;
                }

                @Override
                public String getChatKey() {
                    return chat_key;
                }
            };
            chat_properties.put("download", adapter);
            final HashSet activated_chats = new HashSet();
            final BuddyPluginViewInterface.View chat_view = BuddyPluginUtils.buildChatView(chat_properties, new BuddyPluginViewInterface.ViewListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void chatActivated(BuddyPluginBeta.ChatInstance chat) {
                    boolean[] blArray = az_rating_in_progress;
                    synchronized (az_rating_in_progress) {
                        activated_chats.add(chat);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
            if (chat_view == null) {
                Composite chatComp2 = new Composite((Composite)chatComp, 2048);
                layout = new GridLayout();
                layout.numColumns = 1;
                layout.marginWidth = 4;
                layout.marginHeight = 4;
                chatComp2.setLayout((Layout)layout);
                gridData = new GridData(1808);
                chatComp2.setLayoutData((Object)gridData);
                chatComp2.setBackground(Colors.white);
                Label chatText = new Label(chatComp2, 64);
                gridData = new GridData(768);
                gridData.heightHint = ratingText.getFont().getFontData()[0].getHeight() * 2 + 16;
                chatText.setLayoutData((Object)gridData);
                chatText.setBackground(Colors.white);
                chatText.setText(MessageText.getString("torrent.comment.azmsgsync.install"));
            }
            Composite progressComp = new Composite(comp2, 0);
            gridData = new GridData(768);
            progressComp.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.numColumns = 3;
            progressComp.setLayout((Layout)layout);
            Label progLabel = new Label(progressComp, 0);
            progLabel.setText(MessageText.getString("label.checking.comments"));
            final Composite progBarComp = new Composite(progressComp, 0);
            gridData = new GridData(768);
            progBarComp.setLayoutData((Object)gridData);
            final StackLayout progStackLayout = new StackLayout();
            progBarComp.setLayout((Layout)progStackLayout);
            final ProgressBar progBarIndeterminate = new ProgressBar(progBarComp, 258);
            gridData = new GridData(768);
            progBarIndeterminate.setLayoutData((Object)gridData);
            final ProgressBar progBarComplete = new ProgressBar(progBarComp, 256);
            gridData = new GridData(768);
            progBarComplete.setLayoutData((Object)gridData);
            progBarComplete.setMaximum(1);
            progBarComplete.setSelection(1);
            progStackLayout.topControl = progBarIndeterminate;
            new AEThread2("ProgChecker"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    boolean currently_updating = true;
                    while (!comments_shell.isDisposed()) {
                        boolean in_progress = false;
                        boolean[] blArray = az_rating_in_progress;
                        // MONITORENTER : az_rating_in_progress
                        if (az_rating_in_progress[0]) {
                            in_progress = true;
                        }
                        Iterator iterator = activated_chats.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                // MONITOREXIT : blArray
                                break;
                            }
                            BuddyPluginBeta.ChatInstance inst = (BuddyPluginBeta.ChatInstance)iterator.next();
                            if (inst.getIncomingSyncState() == 0) continue;
                            in_progress = true;
                        }
                        final boolean updating = in_progress;
                        if (updating != currently_updating) {
                            currently_updating = updating;
                            Utils.execSWTThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (!comments_shell.isDisposed()) {
                                        progStackLayout.topControl = updating ? progBarIndeterminate : progBarComplete;
                                        progBarComp.layout();
                                    }
                                }
                            });
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    return;
                }
            }.start();
            Button subscriptionLookup = new Button(progressComp, 8);
            subscriptionLookup.setText(MessageText.getString("ConfigView.section.Subscriptions"));
            subscriptionLookup.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    new SubscriptionListWindow(comments_shell, title, OpenTorrentInstance.this.hash.getBytes(), f_enabled_networks, false);
                }
            });
            Control labelSeparator = Utils.createSkinnedLabelSeparator(comp2, 256);
            gridData = new GridData(768);
            labelSeparator.setLayoutData((Object)gridData);
            Composite buttonComp = new Composite(comp2, 0);
            gridData = new GridData(768);
            buttonComp.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.numColumns = 2;
            buttonComp.setLayout((Layout)layout);
            new Label(buttonComp, 0);
            Composite buttonArea = new Composite(buttonComp, 0);
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            buttonArea.setLayoutData((Object)gridData);
            GridLayout layoutButtons = new GridLayout();
            layoutButtons.numColumns = 1;
            buttonArea.setLayout((Layout)layoutButtons);
            ArrayList<Button> buttons = new ArrayList<Button>();
            Button bOK = new Button(buttonArea, 8);
            buttons.add(bOK);
            bOK.setText(MessageText.getString("Button.ok"));
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 70;
            bOK.setLayoutData((Object)gridData);
            bOK.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    comments_shell.dispose();
                }
            });
            Utils.makeButtonsEqualWidth(buttons);
            comments_shell.setDefaultButton(bOK);
            comments_shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (!OpenTorrentInstance.this.btnCheckComments.isDisposed()) {
                        OpenTorrentInstance.this.btnCheckComments.setEnabled(true);
                    }
                    if (chat_view != null) {
                        chat_view.destroy();
                    }
                }
            });
            this.btnCheckComments.setEnabled(false);
            comments_shell.setSize(600, 600);
            comments_shell.layout(true, true);
            Utils.centerWindowRelativeTo(comments_shell, (Control)this.shell);
            Messages.setLanguageText((Widget)comments_shell, "torrent.comments.title", title);
            comments_shell.open();
        }

        private void checkSeedingMode() {
            for (TorrentOpenOptions to : this.torrentOptionsMulti) {
                boolean bTorrentValid = true;
                if (to.getStartMode() == 4) {
                    File move_loc;
                    TorrentOpenFileOptions[] files = to.getFiles();
                    int j = 0;
                    while (j < files.length) {
                        TorrentOpenFileOptions fileInfo2 = files[j];
                        if (fileInfo2.isToDownload()) {
                            File file = fileInfo2.getInitialLink();
                            if (file == null) {
                                file = fileInfo2.getDestFileFullName();
                            }
                            if (!file.exists()) {
                                fileInfo2.setValid(false);
                                bTorrentValid = false;
                            } else if (!fileInfo2.isValid()) {
                                fileInfo2.setValid(true);
                            }
                        }
                        ++j;
                    }
                    if (!bTorrentValid && this.tag_save_location != null && this.tag_save_location.supportsTagMoveOnComplete() && (move_loc = this.tag_save_location.getTagMoveOnCompleteFolder()) != null && (this.tag_save_location.getTagMoveOnCompleteOptions() & 1L) != 0L) {
                        String current = this.getSavePath();
                        String move_path = move_loc.getAbsolutePath();
                        if (!move_path.equals(current)) {
                            to.isValid = false;
                            this.setSavePath(move_path);
                            continue;
                        }
                    }
                }
                to.isValid = bTorrentValid;
            }
        }

        protected void cmbDataDirChanged() {
            if (this.cmbDataDir == null) {
                return;
            }
            String dirText = this.cmbDataDir.getText();
            if (!this.bSkipDataDirModify) {
                for (TorrentOpenOptions too : this.torrentOptionsMulti) {
                    too.setParentDir(dirText);
                }
                this.checkSeedingMode();
                if (!Constants.isOSX) {
                    File file = FileUtil.newFile(dirText, new String[0]);
                    if (!file.isDirectory()) {
                        this.cmbDataDir.setBackground(Colors.colorErrorBG);
                        this.soExpandItemSaveTo.setExpanded(true);
                    } else {
                        Utils.setSkinnedBackground((Control)this.cmbDataDir, null);
                    }
                    this.cmbDataDir.redraw();
                    this.cmbDataDir.update();
                }
            }
            if (this.soExpandItemSaveTo != null) {
                File moc = null;
                boolean mocSame = true;
                for (TorrentOpenOptions too : this.torrentOptionsMulti) {
                    File m = too.getMoveOnComplete();
                    if (m == moc) continue;
                    if (m == null || moc == null || !m.equals(moc)) {
                        moc = m;
                        mocSame = false;
                        break;
                    }
                    moc = m;
                }
                String s = MessageText.getString("OpenTorrentOptions.header.saveto", new String[]{dirText});
                if (moc != null) {
                    s = String.valueOf(s) + "; " + MessageText.getString("label.move.on.comp");
                    if (mocSame) {
                        s = String.valueOf(s) + ": " + moc.getAbsolutePath();
                    }
                }
                this.soExpandItemSaveTo.setText(s);
            }
            this.diskFreeInfoRefreshPending = true;
        }

        protected void setSelectedQueueLocation(int iLocation) {
            for (TorrentOpenOptions to : this.torrentOptionsMulti) {
                to.setQueueLocation(iLocation);
            }
            this.updateStartOptionsHeader();
        }

        protected void setSequentalDownload(boolean seq) {
            for (TorrentOpenOptions to : this.torrentOptionsMulti) {
                to.setSequentialDownload(seq);
            }
            this.updateStartOptionsHeader();
        }

        private void updateStartOptionsHeader() {
            if (this.soStartOptionsExpandItem == null) {
                return;
            }
            if (this.isSingleOptions) {
                String optionText = String.valueOf(MessageText.getString(TorrentOpenOptions.STARTMODE_KEYS[this.torrentOptions.getStartMode()])) + ", " + MessageText.getString(MSGKEY_QUEUELOCATIONS[this.torrentOptions.getQueueLocation()]);
                String s = MessageText.getString("OpenTorrentOptions.header.startoptions", new String[]{optionText});
                List<Tag> initialtags = this.torrentOptions.getInitialTags();
                String tag_str = null;
                int numTags = 0;
                if (initialtags.size() > 0) {
                    tag_str = "";
                    for (Tag t : initialtags) {
                        if (t instanceof DiscoveredTag && ((DiscoveredTag)t).existingTag != null) continue;
                        ++numTags;
                        tag_str = String.valueOf(tag_str) + (tag_str == "" ? "" : ", ") + t.getTagName(true);
                    }
                }
                if (numTags == 0) {
                    tag_str = MessageText.getString("label.none");
                }
                s = String.valueOf(s) + "        " + MessageText.getString("OpenTorrentOptions.header.tags", new String[]{tag_str});
                if (this.torrentOptions.getSequentialDownload()) {
                    s = String.valueOf(s) + "        " + MessageText.getString("menu.sequential.download");
                }
                this.soStartOptionsExpandItem.setText(s);
            } else {
                int startMode = -1;
                int queueLocation = -1;
                int sequential = -1;
                for (TorrentOpenOptions to : this.torrentOptionsMulti) {
                    int s;
                    int sm = to.getStartMode();
                    int ql = to.getQueueLocation();
                    int n = s = to.getSequentialDownload() ? 1 : 0;
                    if (startMode == -1) {
                        startMode = sm;
                        queueLocation = ql;
                        sequential = s;
                        continue;
                    }
                    if (startMode != sm) {
                        startMode = -2;
                    }
                    if (queueLocation != ql) {
                        queueLocation = -2;
                    }
                    if (sequential == s) continue;
                    sequential = -2;
                }
                String smText = startMode < 0 ? "" : MessageText.getString(TorrentOpenOptions.STARTMODE_KEYS[startMode]);
                String qlText = queueLocation < 0 ? "" : MessageText.getString(MSGKEY_QUEUELOCATIONS[queueLocation]);
                String optionText = smText;
                if (!qlText.isEmpty()) {
                    if (!optionText.isEmpty()) {
                        optionText = String.valueOf(optionText) + ", ";
                    }
                    optionText = String.valueOf(optionText) + qlText;
                }
                String s = MessageText.getString("OpenTorrentOptions.header.startoptions", new String[]{optionText});
                if (sequential == 1) {
                    s = String.valueOf(s) + "        " + MessageText.getString("menu.sequential.download");
                }
                this.soStartOptionsExpandItem.setText(s);
            }
        }

        protected void setSelectedStartMode(int iStartID) {
            for (TorrentOpenOptions to : this.torrentOptionsMulti) {
                to.setStartMode(iStartID);
            }
            this.checkSeedingMode();
            this.updateStartOptionsHeader();
        }

        private void setupFileAreaButtons(SWTSkinObjectContainer so) {
            PluginInterface swarm_pi = null;
            try {
                PluginInterface pi;
                if (COConfigurationManager.getBooleanParameter("rcm.overall.enabled", true) && CoreFactory.isCoreRunning() && (pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("aercm")) != null && pi.getPluginState().isOperational() && pi.getIPC().canInvoke("lookupBySize", new Object[]{new Long(0L)})) {
                    swarm_pi = pi;
                }
            }
            catch (Throwable pi) {
                // empty catch block
            }
            Composite cButtonsArea = so.getComposite();
            GridLayout layout = new GridLayout(1, false);
            layout.marginRight = 0;
            layout.marginLeft = 0;
            layout.marginTop = 0;
            layout.marginBottom = 0;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cButtonsArea.setLayout((Layout)layout);
            Composite cButtonsTop = new Composite(cButtonsArea, 0);
            layout = new GridLayout(swarm_pi == null ? 6 : 7, false);
            layout.marginRight = 0;
            layout.marginLeft = 0;
            layout.marginTop = 0;
            layout.marginBottom = 0;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cButtonsTop.setLayout((Layout)layout);
            GridData gridData = new GridData(768);
            cButtonsTop.setLayoutData((Object)gridData);
            Canvas line = new Canvas(cButtonsArea, 262144);
            line.addListener(9, new Listener(){

                public void handleEvent(Event e) {
                    Rectangle clientArea = ((Canvas)e.widget).getClientArea();
                    e.gc.setForeground(Colors.getSystemColor((Device)e.display, 18));
                    e.gc.drawRectangle(clientArea);
                    ++clientArea.y;
                    e.gc.setForeground(Colors.getSystemColor((Device)e.display, 20));
                    e.gc.drawRectangle(clientArea);
                }
            });
            gridData = new GridData(768);
            gridData.heightHint = 2;
            line.setLayoutData((Object)gridData);
            Composite cButtonsBottom = new Composite(cButtonsArea, 0);
            layout = new GridLayout(7, false);
            layout.marginRight = 0;
            layout.marginLeft = 0;
            layout.marginTop = 0;
            layout.marginBottom = 0;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cButtonsBottom.setLayout((Layout)layout);
            gridData = new GridData(768);
            cButtonsBottom.setLayoutData((Object)gridData);
            ArrayList<Button> buttons = new ArrayList<Button>();
            this.btnSelectAll = new Button(cButtonsTop, 8);
            buttons.add(this.btnSelectAll);
            Messages.setLanguageText((Widget)this.btnSelectAll, "Button.selectAll");
            this.btnSelectAll.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    OpenTorrentInstance.this.tvFiles.selectAll();
                }
            });
            this.btnMarkSelected = new Button(cButtonsTop, 8);
            buttons.add(this.btnMarkSelected);
            Messages.setLanguageText((Widget)this.btnMarkSelected, "Button.mark");
            this.btnMarkSelected.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    TorrentOpenFileOptions[] infos = OpenTorrentInstance.this.tvFiles.getSelectedDataSources().toArray(new TorrentOpenFileOptions[0]);
                    OpenTorrentInstance.this.setToDownload(infos, true);
                }
            });
            this.btnUnmarkSelected = new Button(cButtonsTop, 8);
            buttons.add(this.btnUnmarkSelected);
            Messages.setLanguageText((Widget)this.btnUnmarkSelected, "Button.unmark");
            this.btnUnmarkSelected.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    TorrentOpenFileOptions[] infos = OpenTorrentInstance.this.tvFiles.getSelectedDataSources().toArray(new TorrentOpenFileOptions[0]);
                    OpenTorrentInstance.this.setToDownload(infos, false);
                }
            });
            this.btnRename = new Button(cButtonsTop, 8);
            buttons.add(this.btnRename);
            Messages.setLanguageText((Widget)this.btnRename, "Button.rename");
            this.btnRename.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    TorrentOpenFileOptions[] infos = OpenTorrentInstance.this.tvFiles.getSelectedDataSources().toArray(new TorrentOpenFileOptions[0]);
                    if (infos.length > 0) {
                        OpenTorrentInstance.this.renameFilenames(infos);
                    }
                }
            });
            this.btnRetarget = new Button(cButtonsTop, 8);
            buttons.add(this.btnRetarget);
            Messages.setLanguageText((Widget)this.btnRetarget, "Button.retarget");
            this.btnRetarget.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    TorrentOpenFileOptions[] infos = OpenTorrentInstance.this.tvFiles.getSelectedDataSources().toArray(new TorrentOpenFileOptions[0]);
                    OpenTorrentInstance.this.changeFileDestination(infos, false);
                }
            });
            Label pad1 = new Label(cButtonsTop, 0);
            gridData = new GridData(768);
            pad1.setLayoutData((Object)gridData);
            if (swarm_pi != null) {
                final PluginInterface f_pi = swarm_pi;
                this.btnSwarmIt = new Button(cButtonsTop, 8);
                buttons.add(this.btnSwarmIt);
                Messages.setLanguageText((Widget)this.btnSwarmIt, "Button.swarmit");
                this.btnSwarmIt.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        List<Object> selectedDataSources = OpenTorrentInstance.this.tvFiles.getSelectedDataSources();
                        Iterator<Object> iterator = selectedDataSources.iterator();
                        if (iterator.hasNext()) {
                            Object ds = iterator.next();
                            TorrentOpenFileOptions file = (TorrentOpenFileOptions)ds;
                            try {
                                try {
                                    f_pi.getIPC().invoke("lookupBySize", new Object[]{new Long(file.getSize()), new String[]{"Public"}, file.getDestFileName()});
                                }
                                catch (Throwable e) {
                                    f_pi.getIPC().invoke("lookupBySize", new Object[]{new Long(file.getSize())});
                                }
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                });
                this.btnSwarmIt.setEnabled(false);
            }
            this.btnTreeView = new Button(cButtonsBottom, 8);
            buttons.add(this.btnTreeView);
            Messages.setLanguageText((Widget)this.btnTreeView, "OpenTorrentWindow.tree.view");
            Utils.setTT((Control)this.btnTreeView, MessageText.getString("OpenTorrentWindow.tree.view.info"));
            this.btnTreeView.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    OpenTorrentInstance.this.showTreeView();
                }
            });
            Label pad2 = new Label(cButtonsBottom, 0);
            gridData = new GridData(768);
            pad2.setLayoutData((Object)gridData);
            Button local_comment = new Button(cButtonsBottom, 8);
            local_comment.setToolTipText(MessageText.getString("TableColumn.header.comment.info"));
            local_comment.setImage(ImageLoader.getInstance().getImage("no_comment"));
            local_comment.addListener(13, e -> TorrentUtil.promptUserForComment(this.torrentOptions.getUserComment(), str -> {
                this.torrentOptions.setUserComment((String)str);
                local_comment.setImage(ImageLoader.getInstance().getImage(str == null || str.isEmpty() ? "no_comment" : "comment"));
            }));
            Control sep = Utils.createSkinnedLabelSeparator(cButtonsBottom, 512);
            gridData = new GridData();
            gridData.heightHint = 15;
            sep.setLayoutData((Object)gridData);
            this.btnPrivacy = new Button(cButtonsBottom, 2);
            buttons.add(this.btnPrivacy);
            Messages.setLanguageText((Widget)this.btnPrivacy, "label.privacy");
            Utils.setTT((Control)this.btnPrivacy, MessageText.getString("OpenTorrentWindow.privacy.info"));
            this.btnPrivacy.addListener(13, new Listener(){
                private int saved_start_mode;
                private Map<String, Boolean> saved_nets;

                public void handleEvent(Event event2) {
                    if (OpenTorrentInstance.this.btnPrivacy.getSelection()) {
                        this.saved_nets = OpenTorrentInstance.this.torrentOptions.getEnabledNetworks();
                        this.saved_start_mode = OpenTorrentInstance.this.torrentOptions.getStartMode();
                        OpenTorrentInstance.this.setSelectedStartMode(1);
                        String[] stringArray = AENetworkClassifier.AT_NETWORKS;
                        int n = AENetworkClassifier.AT_NETWORKS.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String net = stringArray[n2];
                            OpenTorrentInstance.this.torrentOptions.setNetworkEnabled(net, false);
                            ++n2;
                        }
                        OpenTorrentInstance.this.updateNetworkOptions();
                    } else {
                        if (this.saved_nets != null) {
                            OpenTorrentInstance.this.setSelectedStartMode(this.saved_start_mode);
                            for (Map.Entry<String, Boolean> entry : this.saved_nets.entrySet()) {
                                OpenTorrentInstance.this.torrentOptions.setNetworkEnabled(entry.getKey(), entry.getValue());
                            }
                            this.saved_nets = null;
                        }
                        OpenTorrentInstance.this.updateNetworkOptions();
                    }
                }
            });
            this.btnCheckComments = new Button(cButtonsBottom, 8);
            buttons.add(this.btnCheckComments);
            Messages.setLanguageText((Widget)this.btnCheckComments, "label.comments");
            this.btnCheckComments.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    OpenTorrentInstance.this.showComments();
                }
            });
            this.btnCheckAvailability = new Button(cButtonsBottom, 8);
            buttons.add(this.btnCheckAvailability);
            Messages.setLanguageText((Widget)this.btnCheckAvailability, "label.check.avail");
            this.btnCheckAvailability.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    OpenTorrentInstance.this.showAvailability();
                }
            });
            Utils.makeButtonsEqualWidth(buttons);
            this.updateFileButtons();
        }

        private void setToDownload(TorrentOpenFileOptions[] infos, boolean download) {
            boolean changed = false;
            try {
                this.settingToDownload.incrementAndGet();
                TorrentOpenFileOptions[] torrentOpenFileOptionsArray = infos;
                int n = infos.length;
                int n2 = 0;
                while (n2 < n) {
                    TorrentOpenFileOptions info = torrentOpenFileOptionsArray[n2];
                    if (info.isToDownload() != download) {
                        info.setToDownload(download);
                        changed = true;
                    }
                    ++n2;
                }
            }
            finally {
                this.settingToDownload.decrementAndGet();
            }
            if (changed) {
                this.updateFileButtons();
                this.updateSize();
                this.torrentOptions.applyAutoTagging();
            }
        }

        private void setupFileAreaInfo(SWTSkinObjectText so) {
            this.soFileAreaInfo = so;
        }

        private void setupSaveLocation(SWTSkinObjectContainer soInputArea, SWTSkinObjectButton soBrowseButton, SWTSkinObjectButton soSearchButton, SWTSkinObjectContainer soMoreArea) {
            this.cmbDataDir = new Combo(soInputArea.getComposite(), 0);
            this.cmbDataDir.setLayoutData((Object)Utils.getFilledFormData());
            this.cmbDataDir.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 32 && (e.stateMask & SWT.MOD1) != 0) {
                        e.doit = false;
                    }
                }

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 32 && (e.stateMask & SWT.MOD1) != 0) {
                        e.doit = false;
                        Menu menu = OpenTorrentInstance.this.cmbDataDir.getMenu();
                        if (menu != null && !menu.isDisposed()) {
                            menu.dispose();
                        }
                        menu = new Menu((Control)OpenTorrentInstance.this.cmbDataDir);
                        String current_text = OpenTorrentInstance.this.cmbDataDir.getText();
                        String def = COConfigurationManager.getStringParameter(OpenTorrentOptionsWindow.PARAM_DEFSAVEPATH);
                        ArrayList<String> items = new ArrayList<String>(Arrays.asList(OpenTorrentInstance.this.cmbDataDir.getItems()));
                        if (!items.contains(def)) {
                            items.add(def);
                        }
                        ArrayList<String> suggestions = new ArrayList<String>();
                        for (String item : items) {
                            if (!item.toLowerCase(Locale.US).contains(current_text.toLowerCase(Locale.US))) continue;
                            suggestions.add(item);
                        }
                        if (suggestions.size() == 0) {
                            MenuItem mi = new MenuItem(menu, 8);
                            mi.setText(MessageText.getString("label.no.suggestions"));
                            mi.setEnabled(false);
                        } else {
                            for (final String str : suggestions) {
                                MenuItem mi = new MenuItem(menu, 8);
                                String mi_str = str.replaceAll("&", "&&");
                                mi.setText(mi_str);
                                mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        OpenTorrentInstance.this.cmbDataDir.setText(str);
                                    }
                                });
                            }
                        }
                        OpenTorrentInstance.this.cmbDataDir.setMenu(menu);
                        final Point cursorLocation = Display.getCurrent().getCursorLocation();
                        menu.setLocation(cursorLocation.x - 10, cursorLocation.y - 10);
                        menu.setVisible(true);
                        Utils.execSWTThread(new Runnable(){

                            @Override
                            public void run() {
                                Display.getCurrent().setCursorLocation(cursorLocation.x + 1, cursorLocation.y);
                            }
                        }, true);
                    }
                }
            });
            Utils.setTT((Control)this.cmbDataDir, MessageText.getString("label.ctrl.space.for.suggestion"));
            this.cmbDataDir.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OpenTorrentInstance.this.cmbDataDirChanged();
                }
            });
            this.cmbDataDir.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    OpenTorrentInstance.this.cmbDataDirChanged();
                }
            });
            this.updateDataDirCombo();
            List<String> dirList = COConfigurationManager.getStringListParameter("saveTo_list");
            for (String s : dirList) {
                if (this.torrentOptions != null && s.equals(this.torrentOptions.getParentDir())) continue;
                this.cmbDataDir.add(s);
            }
            soBrowseButton.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                @Override
                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    String sDefPath = OpenTorrentInstance.this.cmbDataDir.getText();
                    File f = FileUtil.newFile(sDefPath, new String[0]);
                    if (sDefPath.length() > 0) {
                        while (!f.exists()) {
                            if ((f = f.getParentFile()) != null) continue;
                            f = FileUtil.newFile(sDefPath, new String[0]);
                            break;
                        }
                    }
                    DirectoryDialog dDialog = new DirectoryDialog(OpenTorrentInstance.this.cmbDataDir.getShell(), 131072);
                    Utils.setFilterPathWithTimeout(dDialog, f.getAbsolutePath());
                    dDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.savepath_forallfiles"));
                    String sSavePath = dDialog.open();
                    if (sSavePath != null) {
                        OpenTorrentInstance.this.cmbDataDir.setText(sSavePath);
                    }
                }
            });
            soSearchButton.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                @Override
                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    ManagerUtils.locateSaveLocations(OpenTorrentInstance.this.torrentOptionsMulti, OpenTorrentInstance.this.shell, files -> {
                        int pos = 0;
                        for (TorrentOpenOptions too : OpenTorrentInstance.this.torrentOptionsMulti) {
                            if (files[pos] != null) {
                                File dir = files[pos];
                                if (too.isSimpleTorrent()) {
                                    too.setParentDir(dir.getAbsolutePath());
                                } else {
                                    String parent_dir = dir.getParentFile().getAbsolutePath();
                                    too.setParentDir(parent_dir);
                                    String sub_dir = dir.getName();
                                    if (sub_dir.equals(too.getDefaultSubDir())) {
                                        too.setSubDir(null);
                                    } else {
                                        too.setSubDir(sub_dir);
                                    }
                                }
                                too.setDisableAutoRename(true);
                            }
                            ++pos;
                        }
                        OpenTorrentInstance.this.updateDataDirCombo();
                    });
                }
            });
            this.btnDataDir = soBrowseButton.getButton();
            this.btnSearch = soSearchButton.getButton();
            if (!this.isSingleOptions) {
                for (TorrentOpenOptions to : this.torrentOptionsMulti) {
                    OpenTorrentInstance instance = OpenTorrentOptionsWindow.this.getInstance(to);
                    if (instance.tag_save_location == null) continue;
                    this.cmbDataDirEnabled = false;
                    break;
                }
            }
            this.cmbDataDir.setEnabled(this.cmbDataDirEnabled);
            this.btnDataDir.setEnabled(this.cmbDataDirEnabled);
            this.btnSearch.setEnabled(this.cmbDataDirEnabled);
            Composite more_outer = soMoreArea.getComposite();
            Composite more_comp = new Composite(more_outer, 0);
            more_comp.setLayoutData((Object)Utils.getFilledFormData());
            GridLayout more_layout = new GridLayout(4, false);
            Label sub_label = new Label(more_comp, 0);
            sub_label.setText(MessageText.getString("label.subfolder"));
            Text sub_text = new Text(more_comp, 2048);
            GridData grid_data = new GridData(1808);
            grid_data.verticalAlignment = 0x1000000;
            sub_text.setLayoutData((Object)grid_data);
            if (this.isSingleOptions && !this.torrentOptions.isSimpleTorrent()) {
                this.txtSubFolder = sub_text;
                String top = FileUtil.newFile(this.torrentOptions.getDataDir(), new String[0]).getName();
                this.txtSubFolder.setText(top);
                this.torrentOptions.addListener(() -> this.txtSubFolder.setText(FileUtil.newFile(this.torrentOptions.getDataDir(), new String[0]).getName()));
                this.txtSubFolder.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent e) {
                        String str = OpenTorrentInstance.this.txtSubFolder.getText().trim();
                        File data_dir = FileUtil.newFile(OpenTorrentInstance.this.torrentOptions.getDataDir(), new String[0]);
                        if (str.isEmpty()) {
                            String top = data_dir.getName();
                            OpenTorrentInstance.this.txtSubFolder.setText(top);
                        } else {
                            File new_dir = FileUtil.newFile(data_dir.getParentFile(), str);
                            OpenTorrentInstance.this.setTopLevelFolder(new_dir, false);
                        }
                    }

                    public void focusGained(FocusEvent e) {
                    }
                });
            } else {
                sub_label.setEnabled(false);
                sub_text.setEnabled(false);
            }
            more_layout.marginBottom = 0;
            more_layout.marginTop = 0;
            more_layout.marginHeight = 0;
            more_comp.setLayout((Layout)more_layout);
            Label more_label = new Label(more_comp, 0);
            grid_data = new GridData(1040);
            grid_data.verticalAlignment = 0x1000000;
            more_label.setLayoutData((Object)grid_data);
            more_label.setText(MessageText.getString("label.more"));
            Label more_icon = new Label(more_comp, 0);
            Image image = ImageLoader.getInstance().getImage("menu_down");
            more_icon.setImage(image);
            grid_data = new GridData();
            grid_data.widthHint = image.getBounds().width;
            grid_data.heightHint = image.getBounds().height;
            grid_data.verticalAlignment = 0x1000000;
            more_icon.setLayoutData((Object)grid_data);
            final Menu more_menu = new Menu((Control)more_comp);
            Control[] controlArray = new Control[]{more_label, more_icon};
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                final Control l = controlArray[n2];
                l.setCursor(more_comp.getDisplay().getSystemCursor(21));
                l.setMenu(more_menu);
                l.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent event2) {
                        try {
                            Point p = more_menu.getDisplay().map(l, null, event2.x, event2.y);
                            more_menu.setLocation(p);
                            more_menu.setVisible(true);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
                ++n2;
            }
            final Menu moc_menu = new Menu((Decorations)this.shell, 4);
            MenuItem moc_item = new MenuItem(more_menu, 64);
            Messages.setLanguageText((Widget)moc_item, "label.move.on.comp");
            moc_item.setMenu(moc_menu);
            moc_menu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent arg0) {
                    Utils.clearMenu(moc_menu);
                    boolean has_moc = false;
                    String existing_moc = null;
                    for (TorrentOpenOptions to : OpenTorrentInstance.this.torrentOptionsMulti) {
                        File moc = to.getMoveOnComplete();
                        if (moc == null) continue;
                        has_moc = true;
                        String moc_str = moc.getAbsolutePath();
                        if (existing_moc == null || existing_moc.equals(moc_str)) {
                            existing_moc = moc_str;
                            continue;
                        }
                        existing_moc = null;
                        break;
                    }
                    if (existing_moc != null) {
                        MenuItem existing_item = new MenuItem(moc_menu, 8);
                        existing_item.setText("[" + existing_moc + "]");
                        existing_item.setEnabled(false);
                        new MenuItem(moc_menu, 2);
                    }
                    MenuItem clear_item = new MenuItem(moc_menu, 8);
                    Messages.setLanguageText((Widget)clear_item, "Button.clear");
                    clear_item.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            for (TorrentOpenOptions to : OpenTorrentInstance.this.torrentOptionsMulti) {
                                to.setMoveOnComplete(null);
                            }
                            OpenTorrentInstance.this.cmbDataDirChanged();
                        }
                    });
                    clear_item.setEnabled(has_moc);
                    final Consumer<String> moc_setter = path -> {
                        MenuBuildUtils.addToMOCHistory(path);
                        TorrentOpener.setFilterPathData(path);
                        File target = FileUtil.newFile(path, new String[0]);
                        for (TorrentOpenOptions to : OpenTorrentInstance.this.torrentOptionsMulti) {
                            to.setMoveOnComplete(target);
                        }
                        OpenTorrentInstance.this.cmbDataDirChanged();
                    };
                    MenuItem set_item = new MenuItem(moc_menu, 8);
                    Messages.setLanguageText((Widget)set_item, "label.set");
                    set_item.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            DirectoryDialog dd = new DirectoryDialog(OpenTorrentInstance.this.shell);
                            String filter_path = TorrentOpener.getFilterPathData();
                            Utils.setFilterPathWithTimeout(dd, filter_path);
                            dd.setText(MessageText.getString("MyTorrentsView.menu.movedata.dialog"));
                            String path = dd.open();
                            if (path != null) {
                                moc_setter.accept(path);
                            }
                        }
                    });
                    MenuBuildUtils.addMOCHistory(moc_menu, moc_setter);
                }

                public void menuHidden(MenuEvent arg0) {
                }
            });
            MenuItem rename_dn_item = new MenuItem(more_menu, 8);
            rename_dn_item.setText(String.valueOf(MessageText.getString("MyTorrentsView.menu.rename.displayed")) + "...");
            rename_dn_item.addListener(13, ev -> {
                String msg_key_prefix = "MyTorrentsView.menu.rename.displayed.enter.";
                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow(String.valueOf(msg_key_prefix) + "title", String.valueOf(msg_key_prefix) + "message");
                entryWindow.setPreenteredText(this.torrentOptions.getDisplayName(), false);
                entryWindow.maintainWhitespace(true);
                entryWindow.prompt(new UIInputReceiverListener(){

                    @Override
                    public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                        if (!entryWindow.hasSubmittedInput()) {
                            return;
                        }
                        String value = entryWindow.getSubmittedInput();
                        if (value != null && value.length() > 0) {
                            OpenTorrentInstance.this.torrentOptions.setDisplayName(value);
                            OpenTorrentOptionsWindow.this.updateDialogTitle();
                        }
                    }
                });
            });
            rename_dn_item.setEnabled(this.isSingleOptions);
            new MenuItem(more_menu, 2);
            if (this.isSingleOptions && !this.torrentOptions.isSimpleTorrent()) {
                MenuItem item = new MenuItem(more_menu, 8);
                Messages.setLanguageText((Widget)item, "OpenTorrentWindow.set.savepath");
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        OpenTorrentInstance.this.setSavePath();
                    }
                });
                MenuItem tlfr = new MenuItem(more_menu, 8);
                Messages.setLanguageText((Widget)tlfr, "OpenTorrentWindow.tlf.remove");
                tlfr.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        OpenTorrentInstance.this.removeTopLevelFolder();
                    }
                });
                more_menu.addListener(22, ev -> tlfr.setEnabled(this.canRemoveTopLevelFolder()));
            }
            MenuItem opt = new MenuItem(more_menu, 32);
            opt.setSelection(COConfigurationManager.getBooleanParameter("open.torrent.window.rename.on.tlf.change"));
            Messages.setLanguageText((Widget)opt, "OpenTorrentWindow.tlf.rename");
            opt.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    COConfigurationManager.setParameter("open.torrent.window.rename.on.tlf.change", ((MenuItem)e.widget).getSelection());
                }
            });
            MenuItem save_torrent = new MenuItem(more_menu, 8);
            Messages.setLanguageText((Widget)save_torrent, "menu.save.torrent");
            save_torrent.addListener(13, ev -> {
                String[] names = new String[this.torrentOptionsMulti.size()];
                TOTorrent[] torrents = new TOTorrent[names.length];
                int pos = 0;
                for (TorrentOpenOptions to : this.torrentOptionsMulti) {
                    names[pos] = String.valueOf(to.getTorrentName()) + ".torrent";
                    torrents[pos] = to.getTorrent();
                    ++pos;
                }
                TorrentUtil.exportTorrents(names, torrents, more_menu.getShell());
            });
        }

        private void setupStartOptions(SWTSkinObjectExpandItem expandItem) {
            this.soStartOptionsExpandItem = expandItem;
            SWTSkinObjectContainer container = (SWTSkinObjectContainer)this.skin.getSkinObject("start-options-container");
            Composite cTorrentOptions = container == null ? expandItem.getComposite() : container.getComposite();
            Composite cTorrentModes = new Composite(cTorrentOptions, 0);
            GridData gridData = new GridData(768);
            cTorrentModes.setLayoutData((Object)Utils.getFilledFormData());
            GridLayout layout = new GridLayout();
            layout.numColumns = 5;
            layout.marginWidth = 5;
            layout.marginHeight = 5;
            cTorrentModes.setLayout((Layout)layout);
            Label label = new Label(cTorrentModes, 0);
            gridData = new GridData(4);
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "OpenTorrentWindow.startMode");
            this.cmbStartMode = new Combo(cTorrentModes, 2056);
            gridData = new GridData(768);
            this.cmbStartMode.setLayoutData((Object)gridData);
            this.updateStartModeCombo();
            this.cmbStartMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OpenTorrentInstance.this.setSelectedStartMode(OpenTorrentInstance.this.cmbStartMode.getSelectionIndex());
                }
            });
            label = new Label(cTorrentModes, 0);
            gridData = new GridData(4);
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "OpenTorrentWindow.addPosition");
            this.cmbQueueLocation = new Combo(cTorrentModes, 2056);
            gridData = new GridData(768);
            this.cmbQueueLocation.setLayoutData((Object)gridData);
            this.updateQueueLocationCombo();
            this.cmbQueueLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OpenTorrentInstance.this.setSelectedQueueLocation(OpenTorrentInstance.this.cmbQueueLocation.getSelectionIndex());
                }
            });
            this.btnSequentialDownload = new Button(cTorrentModes, 32);
            Messages.setLanguageText((Widget)this.btnSequentialDownload, "menu.sequential.download");
            gridData = new GridData(4);
            this.btnSequentialDownload.setLayoutData((Object)gridData);
            if (Constants.isWindows) {
                this.btnSequentialDownload.setBackground(Colors.white);
            }
            this.updateSequentialDownloadButton();
            this.btnSequentialDownload.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OpenTorrentInstance.this.btnSequentialDownload.setGrayed(false);
                    OpenTorrentInstance.this.setSequentalDownload(OpenTorrentInstance.this.btnSequentialDownload.getSelection());
                }
            });
            if (TagManagerFactory.getTagManager().isEnabled()) {
                Composite tagLeft = new Composite(cTorrentModes, 0);
                tagLeft.setLayoutData((Object)new GridData(4));
                Composite tagRight = new Composite(cTorrentModes, 0);
                gridData = new GridData(768);
                gridData.horizontalSpan = 4;
                tagRight.setLayoutData((Object)gridData);
                layout = new GridLayout();
                layout.numColumns = 1;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                tagLeft.setLayout((Layout)layout);
                layout = new GridLayout();
                layout.numColumns = 1;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                tagRight.setLayout((Layout)layout);
                label = new Label(tagLeft, 0);
                gridData = new GridData(4);
                Messages.setLanguageText((Widget)label, "label.initial_tags");
                Composite sc = this.nativeExpandBar ? Utils.createScrolledComposite(tagRight, (Control)this.soStartOptionsExpandItem.getParentComposite()) : tagRight;
                if (Constants.isWindows) {
                    sc.setBackground(Colors.white);
                    sc.setBackgroundMode(1);
                }
                layout = new GridLayout();
                layout.numColumns = 1;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                sc.setLayout((Layout)layout);
                this.tagButtonsArea = new Composite(sc, 0x20000000);
                this.tagButtonsArea.setLayout((Layout)new FillLayout());
                gridData = new GridData(4, 4, true, true);
                this.tagButtonsArea.setLayoutData((Object)gridData);
                this.buildTagButtonPanel();
                Button addTag = new Button(tagLeft, 0);
                addTag.setLayoutData((Object)new GridData(4));
                addTag.setText("+");
                addTag.addListener(13, event2 -> TagUIUtilsV3.showCreateTagDialog(tags -> {
                    if (this.isSingleOptions) {
                        List<Tag> initialTags = this.torrentOptions.getInitialTags();
                        boolean changed = false;
                        Tag[] tagArray = tags;
                        int n = tags.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Tag tag = tagArray[n2];
                            changed |= this.addInitialTag(initialTags, tag);
                            Tag otherTag = this.findOtherTag(tag);
                            if (otherTag != null) {
                                if (otherTag instanceof DiscoveredTag && ((DiscoveredTag)otherTag).existingTag == null) {
                                    ((DiscoveredTag)otherTag).existingTag = tag;
                                }
                                changed |= this.addInitialTag(initialTags, otherTag);
                            }
                            ++n2;
                        }
                        if (changed) {
                            this.torrentOptions.setInitialTags(initialTags);
                            this.updateStartOptionsHeader();
                            this.tagButtonsUI.updateFields(null);
                        }
                    }
                }));
            }
        }

        private void buildTagButtonPanel() {
            if (this.tagButtonsArea == null || this.tagButtonsArea.isDisposed()) {
                return;
            }
            if (!Utils.isThisThreadSWT()) {
                Utils.execSWTThread(this::buildTagButtonPanel);
                return;
            }
            if (this.tbp_building) {
                this.tbp_build_pending = true;
                return;
            }
            int i = 0;
            while (i < 10) {
                try {
                    this.tbp_building = true;
                    this.buildTagButtonPanelSupport();
                }
                finally {
                    this.tbp_building = false;
                    if (!this.tbp_build_pending) {
                        return;
                    }
                    this.tbp_build_pending = false;
                }
                ++i;
            }
            Debug.out("Tag Button Panel build abandoned, too many retries");
        }

        private void buildTagButtonPanelSupport() {
            List<Object> initialTagsCache;
            TagType tt;
            int n;
            int n2;
            TagType[] tagTypeArray;
            boolean is_rebuild;
            TagManager tm = TagManagerFactory.getTagManager();
            TagType[] tts = new TagType[]{tm.getTagType(3), tm.getTagType(1)};
            boolean bl = is_rebuild = this.tagButtonsArea.getData(OpenTorrentOptionsWindow.SP_KEY) != null;
            if (is_rebuild) {
                Utils.disposeComposite(this.tagButtonsArea, false);
            } else {
                this.tagButtonsArea.setData(OpenTorrentOptionsWindow.SP_KEY, (Object)this.getSavePath());
                this.tagButtonsUI = new TagButtonsUI();
                TagTypeListener tagTypeListener = new TagTypeListener(){

                    @Override
                    public void tagTypeChanged(TagType tag_type) {
                    }

                    @Override
                    public void tagEventOccurred(TagTypeListener.TagEvent event2) {
                        int type = event2.getEventType();
                        Tag tag = event2.getTag();
                        if (type == 0) {
                            this.tagAdded(tag);
                        } else if (type == 2) {
                            this.tagRemoved(tag);
                        }
                    }

                    public void tagRemoved(Tag tag) {
                        List<Tag> initialTags;
                        if (OpenTorrentInstance.this.isSingleOptions && OpenTorrentInstance.this.removeInitialTag(initialTags = OpenTorrentInstance.this.torrentOptions.getInitialTags(), tag)) {
                            Tag otherTag = OpenTorrentInstance.this.findOtherTag(tag);
                            if (otherTag != null) {
                                OpenTorrentInstance.this.removeInitialTag(initialTags, otherTag);
                            }
                            OpenTorrentInstance.this.torrentOptions.setInitialTags(initialTags);
                            OpenTorrentInstance.this.updateStartOptionsHeader();
                        }
                        OpenTorrentInstance.this.buildTagButtonPanel();
                    }

                    public void tagAdded(Tag tag) {
                        OpenTorrentInstance.this.buildTagButtonPanel();
                    }
                };
                tagTypeArray = tts;
                n2 = tts.length;
                n = 0;
                while (n < n2) {
                    tt = tagTypeArray[n];
                    tt.addTagTypeListener(tagTypeListener, false);
                    this.tagButtonsArea.addDisposeListener(e -> tt.removeTagTypeListener(tagTypeListener));
                    ++n;
                }
            }
            ArrayList<Tag> tags = new ArrayList<Tag>();
            tagTypeArray = tts;
            n2 = tts.length;
            n = 0;
            while (n < n2) {
                tt = tagTypeArray[n];
                tags.addAll(tt.getTags());
                ++n;
            }
            Iterator iter = tags.iterator();
            block2: while (iter.hasNext()) {
                Tag next = (Tag)iter.next();
                boolean[] auto = next.isTagAuto();
                boolean auto_add = auto[0];
                boolean auto_new = auto[2];
                if (auto_add || auto_new) {
                    iter.remove();
                    continue;
                }
                if (this.isSingleOptions) continue;
                for (TorrentOpenOptions to : this.torrentOptionsMulti) {
                    if (to.canDeselectTag(next)) continue;
                    iter.remove();
                    continue block2;
                }
            }
            if (this.isSingleOptions) {
                for (DiscoveredTag discoveredTag : this.listDiscoveredTags.values()) {
                    tags.add(discoveredTag);
                }
                initialTagsCache = this.torrentOptions.getInitialTags();
            } else {
                initialTagsCache = new ArrayList();
                boolean first = true;
                for (TorrentOpenOptions to : this.torrentOptionsMulti) {
                    List<Tag> initTags = to.getInitialTags();
                    if (first) {
                        initialTagsCache.addAll(initTags);
                        first = false;
                        continue;
                    }
                    Iterator<Object> it = initialTagsCache.iterator();
                    while (it.hasNext()) {
                        if (initTags.contains(it.next())) continue;
                        it.remove();
                    }
                }
            }
            final boolean[] building = new boolean[]{true};
            this.tagButtonsUI.buildTagGroup(tags, this.tagButtonsArea, false, new TagCanvas.TagButtonTrigger(){

                @Override
                public void tagButtonTriggered(TagPainter painter, int stateMask, boolean longPress) {
                    boolean tagSelected;
                    if (longPress) {
                        return;
                    }
                    Tag tag = painter.getTag();
                    boolean bl = tagSelected = !painter.isSelected();
                    if (OpenTorrentInstance.this.isSingleOptions) {
                        TagGroup tg;
                        boolean initialTagsChanged;
                        List<Tag> tags = OpenTorrentInstance.this.torrentOptions.getInitialTags();
                        if (!tagSelected && !OpenTorrentInstance.this.torrentOptions.canDeselectTag(tag)) {
                            painter.setSelected(true);
                            return;
                        }
                        boolean bl2 = initialTagsChanged = tagSelected ? OpenTorrentInstance.this.addInitialTag(tags, tag) : OpenTorrentInstance.this.removeInitialTag(tags, tag);
                        if (initialTagsChanged && tagSelected && (tg = tag.getGroupContainer()) != null && (tg.isExclusive() || tag.getTagType().getTagType() == 1)) {
                            Tag[] tagArray = tags.toArray(new Tag[0]);
                            int n = tagArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Tag t = tagArray[n2];
                                if (t.getGroupContainer() == tg && t != tag) {
                                    OpenTorrentInstance.this.removeInitialTag(tags, t);
                                }
                                ++n2;
                            }
                        }
                        if (initialTagsChanged) {
                            Tag otherTag = OpenTorrentInstance.this.findOtherTag(tag);
                            if (otherTag != null) {
                                if (tagSelected) {
                                    OpenTorrentInstance.this.addInitialTag(tags, otherTag);
                                } else {
                                    OpenTorrentInstance.this.removeInitialTag(tags, otherTag);
                                }
                            }
                            OpenTorrentInstance.this.torrentOptions.setInitialTags(tags);
                        }
                    } else {
                        boolean disable_sp = false;
                        for (TorrentOpenOptions to : OpenTorrentInstance.this.torrentOptionsMulti) {
                            TagGroup tg;
                            List<Tag> tags = to.getInitialTags();
                            OpenTorrentInstance instance = OpenTorrentOptionsWindow.this.getInstance(to);
                            if (tagSelected) {
                                instance.addInitialTag(tags, tag);
                            } else {
                                instance.removeInitialTag(tags, tag);
                            }
                            if (tagSelected && (tg = tag.getGroupContainer()) != null && (tg.isExclusive() || tag.getTagType().getTagType() == 1)) {
                                Tag[] tagArray = tags.toArray(new Tag[0]);
                                int n = tagArray.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    Tag t = tagArray[n3];
                                    if (t.getGroupContainer() == tg && t != tag) {
                                        instance.removeInitialTag(tags, t);
                                    }
                                    ++n3;
                                }
                            }
                            to.setInitialTags(tags);
                            if (instance.tag_save_location == null) continue;
                            disable_sp = true;
                        }
                        OpenTorrentInstance.this.setSavePathEnabled(!disable_sp);
                    }
                    OpenTorrentInstance.this.tagButtonsUI.updateFields(null);
                    OpenTorrentInstance.this.updateStartOptionsHeader();
                }

                @Override
                public Boolean tagSelectedOverride(Tag tag) {
                    if (OpenTorrentInstance.this.isSingleOptions) {
                        List<Tag> initialTags;
                        List<Tag> list = initialTags = building[0] ? initialTagsCache : OpenTorrentInstance.this.torrentOptions.getInitialTags();
                        if (initialTags.contains(tag)) {
                            return true;
                        }
                    } else {
                        ArrayList<Tag> initialTags;
                        if (building[0]) {
                            initialTags = initialTagsCache;
                        } else {
                            initialTags = new ArrayList<Tag>();
                            boolean first = true;
                            for (TorrentOpenOptions to : OpenTorrentInstance.this.torrentOptionsMulti) {
                                List<Tag> initTags = to.getInitialTags();
                                if (first) {
                                    initialTags.addAll(initTags);
                                    first = false;
                                    continue;
                                }
                                Iterator it = initialTags.iterator();
                                while (it.hasNext()) {
                                    if (initTags.contains(it.next())) continue;
                                    it.remove();
                                }
                            }
                        }
                        if (initialTags.contains(tag)) {
                            return true;
                        }
                    }
                    return null;
                }
            });
            this.tagButtonsUI.setEnableWhenNoTaggables(true);
            this.tagButtonsUI.updateFields(null);
            building[0] = false;
            this.updateInitialSaveTags(this.tagButtonsUI.getSelectedTags(), null);
            this.tagButtonsArea.getParent().layout(true, true);
            this.soStartOptionsExpandItem.setHeight(this.soStartOptionsExpandItem.getComposite().computeSize((int)-1, (int)-1).y);
        }

        private boolean removeInitialTag(List<Tag> tags, Tag tag) {
            if (tags.remove(tag)) {
                if (tag instanceof TagFeatureFileLocation) {
                    this.updateInitialSaveTags(tags, (TagFeatureFileLocation)((Object)tag));
                }
                return true;
            }
            return false;
        }

        private boolean addInitialTag(List<Tag> tags, Tag tag) {
            if (!tags.contains(tag)) {
                tags.add(tag);
                if (tag instanceof TagFeatureFileLocation) {
                    this.updateInitialSaveTags(tags, null);
                }
                return true;
            }
            return false;
        }

        private void updateInitialSaveTags(List<Tag> tags, TagFeatureFileLocation removed) {
            if (this.isSingleOptions) {
                TagFeatureFileLocation init = TagUtils.selectInitialDownloadLocation(tags);
                if (init != null && (init.getTagInitialSaveOptions() & 1L) == 0L) {
                    init = null;
                }
                if (init == null) {
                    String old;
                    File save_loc;
                    this.tag_save_location = null;
                    this.setSavePathEnabled(true);
                    if (removed != null && (save_loc = removed.getTagInitialSaveFolder()) != null && (removed.getTagInitialSaveOptions() & 1L) != 0L && this.getSavePath().equals(save_loc.getAbsolutePath()) && (old = (String)this.tagButtonsArea.getData(OpenTorrentOptionsWindow.SP_KEY)) != null) {
                        this.setSavePath(old);
                    }
                } else {
                    this.setSavePathEnabled(false);
                    this.tag_save_location = init;
                    File save_loc = init.getTagInitialSaveFolder();
                    this.setSavePath(save_loc.getAbsolutePath());
                }
            }
        }

        private Tag findOtherTag(Tag tagToFind) {
            if (tagToFind instanceof DiscoveredTag) {
                return ((DiscoveredTag)tagToFind).existingTag;
            }
            DiscoveredTag discoveredTag = this.listDiscoveredTags.get(tagToFind.getTagName(false).toLowerCase());
            if (discoveredTag == null) {
                discoveredTag = this.listDiscoveredTags.get(tagToFind.getTagName(true).toLowerCase());
            }
            return discoveredTag;
        }

        private void setupTVFiles(SWTSkinObjectContainer soFilesTable, SWTSkinObjectTextbox soFilesFilter) {
            OpenTorrentOptionsWindow.setupTableFiles();
            this.tvFiles = TableViewFactory.createTableViewSWT(TorrentOpenFileOptions.class, OpenTorrentOptionsWindow.TABLEID_FILES, OpenTorrentOptionsWindow.TABLEID_FILES, null, "#", 67586);
            this.tvFiles.initialize(soFilesTable.getComposite());
            this.tvFiles.setRowDefaultHeightEM(1.4f);
            if (this.torrentOptions.getFiles().length > 1 && soFilesFilter != null) {
                soFilesFilter.setVisible(true);
                BubbleTextBox bubbleTextBox = soFilesFilter.getBubbleTextBox();
                bubbleTextBox.setMessage(MessageText.getString("TorrentDetailsView.filter"));
                String tooltip = MessageText.getString("filter.tt.start");
                tooltip = String.valueOf(tooltip) + MessageText.getString("filesview.filter.tt.line1");
                bubbleTextBox.setTooltip(tooltip);
                this.tvFiles.enableFilterCheck(bubbleTextBox, (TableViewFilterCheck<TorrentOpenFileOptions>)this);
            } else if (soFilesFilter != null) {
                soFilesFilter.setVisible(false);
            }
            this.tvFiles.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    TableRowCore focusedRow;
                    if (e.keyCode == 32 && (focusedRow = OpenTorrentInstance.this.tvFiles.getFocusedRow()) != null) {
                        TorrentOpenFileOptions tfi_focus = (TorrentOpenFileOptions)focusedRow.getDataSource();
                        boolean download = !tfi_focus.isToDownload();
                        TorrentOpenFileOptions[] infos = OpenTorrentInstance.this.tvFiles.getSelectedDataSources().toArray(new TorrentOpenFileOptions[0]);
                        OpenTorrentInstance.this.setToDownload(infos, download);
                    }
                    if (e.keyCode == 0x100000B && (e.stateMask & SWT.MODIFIER_MASK) == 0) {
                        TorrentOpenFileOptions[] infos = OpenTorrentInstance.this.tvFiles.getSelectedDataSources().toArray(new TorrentOpenFileOptions[0]);
                        if (infos.length > 0) {
                            OpenTorrentInstance.this.renameFilenames(infos);
                        }
                        e.doit = false;
                        return;
                    }
                }
            });
            this.tvFiles.addMenuFillListener(new TableViewSWTMenuFillListener(){

                @Override
                public void fillMenu(String sColumnName, Menu menu) {
                    Shell shell = menu.getShell();
                    TableRowCore focusedRow = OpenTorrentInstance.this.tvFiles.getFocusedRow();
                    final TorrentOpenFileOptions[] infos = OpenTorrentInstance.this.tvFiles.getSelectedDataSources().toArray(new TorrentOpenFileOptions[0]);
                    TorrentOpenFileOptions tfi_focus = (TorrentOpenFileOptions)focusedRow.getDataSource();
                    boolean download = tfi_focus.isToDownload();
                    MenuItem item = new MenuItem(menu, 32);
                    Messages.setLanguageText((Widget)item, "label.download.file");
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            TableRowCore focusedRow = OpenTorrentInstance.this.tvFiles.getFocusedRow();
                            TorrentOpenFileOptions tfi_focus = (TorrentOpenFileOptions)focusedRow.getDataSource();
                            boolean download = !tfi_focus.isToDownload();
                            OpenTorrentInstance.this.setToDownload(infos, download);
                        }
                    });
                    item.setSelection(download);
                    boolean allPriorityAuto = true;
                    TorrentOpenFileOptions[] torrentOpenFileOptionsArray = infos;
                    int n = infos.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TorrentOpenFileOptions info = torrentOpenFileOptionsArray[n2];
                        if (!info.isPriorityAuto()) {
                            allPriorityAuto = false;
                            break;
                        }
                        ++n2;
                    }
                    MenuItem itemPriority = new MenuItem(menu, 64);
                    Messages.setLanguageText((Widget)itemPriority, "FilesView.menu.setpriority");
                    Menu menuPriority = new Menu((Decorations)shell, 4);
                    itemPriority.setMenu(menuPriority);
                    final MenuItem itemHigh = new MenuItem(menuPriority, 64);
                    Messages.setLanguageText((Widget)itemHigh, "FilesView.menu.setpriority.high");
                    final MenuItem itemNormal = new MenuItem(menuPriority, 64);
                    Messages.setLanguageText((Widget)itemNormal, "FilesView.menu.setpriority.normal");
                    final MenuItem itemLow = new MenuItem(menuPriority, 64);
                    Messages.setLanguageText((Widget)itemLow, "FileItem.low");
                    final MenuItem itemNumeric = new MenuItem(menuPriority, 64);
                    Messages.setLanguageText((Widget)itemNumeric, "FilesView.menu.setpriority.numeric");
                    final MenuItem itemNumericAuto = new MenuItem(menuPriority, 64);
                    Messages.setLanguageText((Widget)itemNumericAuto, "FilesView.menu.setpriority.numeric.auto");
                    Listener priorityListener = new Listener(){

                        public void handleEvent(Event event2) {
                            int priority;
                            Widget widget = event2.widget;
                            if (widget == itemHigh) {
                                priority = 1;
                            } else if (widget == itemNormal) {
                                priority = 0;
                            } else if (widget == itemLow) {
                                priority = -1;
                            } else {
                                if (widget == itemNumeric) {
                                    SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("FilesView.dialog.priority.title", "FilesView.dialog.priority.text");
                                    entryWindow.prompt(new UIInputReceiverListener(){

                                        @Override
                                        public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                                            if (!entryWindow.hasSubmittedInput()) {
                                                return;
                                            }
                                            String sReturn = entryWindow.getSubmittedInput();
                                            if (sReturn == null) {
                                                return;
                                            }
                                            int priority = 0;
                                            try {
                                                priority = Integer.valueOf(sReturn);
                                            }
                                            catch (NumberFormatException er) {
                                                Debug.out("Invalid priority: " + sReturn);
                                                new MessageBoxShell(33, MessageText.getString("FilePriority.invalid.title"), MessageText.getString("FilePriority.invalid.text", new String[]{sReturn})).open(null);
                                                return;
                                            }
                                            TorrentOpenFileOptions[] torrentOpenFileOptionsArray = infos;
                                            int n = infos.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                TorrentOpenFileOptions torrentFileInfo = torrentOpenFileOptionsArray[n2];
                                                torrentFileInfo.setPriority(priority, false);
                                                ++n2;
                                            }
                                        }
                                    });
                                    return;
                                }
                                if (widget == itemNumericAuto) {
                                    int n;
                                    int next_priority = 0;
                                    TorrentOpenFileOptions[] all_files = OpenTorrentInstance.this.torrentOptions.getFiles();
                                    if (all_files.length != infos.length) {
                                        TorrentOpenFileOptions file;
                                        HashSet<Integer> affected_indexes = new HashSet<Integer>();
                                        TorrentOpenFileOptions[] torrentOpenFileOptionsArray = infos;
                                        int n2 = infos.length;
                                        n = 0;
                                        while (n < n2) {
                                            file = torrentOpenFileOptionsArray[n];
                                            affected_indexes.add(file.getIndex());
                                            ++n;
                                        }
                                        torrentOpenFileOptionsArray = all_files;
                                        n2 = all_files.length;
                                        n = 0;
                                        while (n < n2) {
                                            file = torrentOpenFileOptionsArray[n];
                                            if (!affected_indexes.contains(file.getIndex()) && file.isToDownload()) {
                                                next_priority = Math.max(next_priority, file.getPriority() + 1);
                                            }
                                            ++n;
                                        }
                                    }
                                    next_priority += infos.length;
                                    TorrentOpenFileOptions[] torrentOpenFileOptionsArray = infos;
                                    n = infos.length;
                                    int n3 = 0;
                                    while (n3 < n) {
                                        TorrentOpenFileOptions file = torrentOpenFileOptionsArray[n3];
                                        if (!file.isPriorityAuto()) {
                                            file.setPriority(--next_priority, false);
                                        }
                                        ++n3;
                                    }
                                    return;
                                }
                                return;
                            }
                            TorrentOpenFileOptions[] torrentOpenFileOptionsArray = infos;
                            int n = infos.length;
                            int n4 = 0;
                            while (n4 < n) {
                                TorrentOpenFileOptions torrentFileInfo = torrentOpenFileOptionsArray[n4];
                                if (!torrentFileInfo.isPriorityAuto()) {
                                    torrentFileInfo.setPriority(priority, false);
                                }
                                ++n4;
                            }
                        }
                    };
                    itemPriority.setEnabled(!allPriorityAuto);
                    itemNumeric.addListener(13, priorityListener);
                    itemNumericAuto.addListener(13, priorityListener);
                    itemHigh.addListener(13, priorityListener);
                    itemNormal.addListener(13, priorityListener);
                    itemLow.addListener(13, priorityListener);
                    if (infos.length > 0) {
                        item = new MenuItem(menu, 8);
                        Messages.setLanguageText((Widget)item, "FilesView.menu.rename_only");
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                OpenTorrentInstance.this.renameFilenames(infos);
                            }
                        });
                    }
                    item = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)item, "OpenTorrentWindow.fileList.changeDestination");
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            OpenTorrentInstance.this.changeFileDestination(infos, false);
                        }
                    });
                    if (infos.length > 1 && OpenTorrentInstance.this.torrentOptions.getStartMode() != 4) {
                        item = new MenuItem(menu, 8);
                        Messages.setLanguageText((Widget)item, "OpenTorrentWindow.fileList.changeDestination.all", String.valueOf(infos.length));
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                OpenTorrentInstance.this.changeFileDestination(infos, true);
                            }
                        });
                    }
                    new MenuItem(menu, 2);
                    item = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)item, "Button.selectAll");
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            OpenTorrentInstance.this.tvFiles.selectAll();
                        }
                    });
                    String dest_path = tfi_focus.getDestPathName();
                    String parentDir = tfi_focus.getTorrentOptions().getParentDir();
                    ArrayList<String> folder_list = new ArrayList<String>();
                    folder_list.add(dest_path);
                    if (dest_path.startsWith(parentDir) && dest_path.length() > parentDir.length()) {
                        String relativePath = dest_path.substring(parentDir.length() + 1);
                        while (relativePath.contains(File.separator)) {
                            int pos = relativePath.lastIndexOf(File.separator);
                            relativePath = relativePath.substring(0, pos);
                            folder_list.add(String.valueOf(parentDir) + File.separator + relativePath);
                        }
                    }
                    int i = folder_list.size() - 1;
                    while (i >= 0) {
                        final String this_dest_path = (String)folder_list.get(i);
                        item = new MenuItem(menu, 8);
                        Messages.setLanguageText((Widget)item, "menu.selectfilesinfolder", this_dest_path);
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                TableRowCore[] rows;
                                TableRowCore[] tableRowCoreArray = rows = OpenTorrentInstance.this.tvFiles.getRows();
                                int n = rows.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    TorrentOpenFileOptions fileOptions;
                                    TableRowCore row = tableRowCoreArray[n2];
                                    Object dataSource = row.getDataSource();
                                    if (dataSource instanceof TorrentOpenFileOptions && (fileOptions = (TorrentOpenFileOptions)dataSource).getDestPathName().startsWith(this_dest_path)) {
                                        row.setSelected(true);
                                    }
                                    ++n2;
                                }
                            }
                        });
                        --i;
                    }
                    new MenuItem(menu, 2);
                    if (!OpenTorrentInstance.this.torrentOptions.isSimpleTorrent()) {
                        item = new MenuItem(menu, 8);
                        Messages.setLanguageText((Widget)item, "OpenTorrentWindow.set.savepath");
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                OpenTorrentInstance.this.setSavePath();
                            }
                        });
                        item = new MenuItem(menu, 8);
                        Messages.setLanguageText((Widget)item, "OpenTorrentWindow.tlf.remove");
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                OpenTorrentInstance.this.removeTopLevelFolder();
                            }
                        });
                        item.setEnabled(OpenTorrentInstance.this.canRemoveTopLevelFolder());
                        item = new MenuItem(menu, 32);
                        item.setSelection(COConfigurationManager.getBooleanParameter("open.torrent.window.rename.on.tlf.change"));
                        Messages.setLanguageText((Widget)item, "OpenTorrentWindow.tlf.rename");
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                COConfigurationManager.setParameter("open.torrent.window.rename.on.tlf.change", ((MenuItem)e.widget).getSelection());
                            }
                        });
                        new MenuItem(menu, 2);
                    }
                    item = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)item, "OpenTorrentWindow.show.priority.options");
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            UIFunctions uif = UIFunctionsManager.getUIFunctions();
                            if (uif != null) {
                                JSONObject args = new JSONObject();
                                args.put("select", "torrent-add-auto-priority");
                                String args_str = JSONUtils.encodeToJSON(args);
                                uif.getMDI().showEntryByID("ConfigView", "files" + args_str);
                            }
                        }
                    });
                    item = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)item, "OpenTorrentWindow.show.skip.options");
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            UIFunctions uif = UIFunctionsManager.getUIFunctions();
                            if (uif != null) {
                                JSONObject args = new JSONObject();
                                args.put("select", "torrent-add-auto-skip");
                                String args_str = JSONUtils.encodeToJSON(args);
                                uif.getMDI().showEntryByID("ConfigView", "files" + args_str);
                            }
                        }
                    });
                    item = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)item, "OpenTorrentWindow.show.autotag.options");
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            UIFunctions uif = UIFunctionsManager.getUIFunctions();
                            if (uif != null) {
                                JSONObject args = new JSONObject();
                                args.put("select", "torrent-add-auto-tag");
                                String args_str = JSONUtils.encodeToJSON(args);
                                uif.getMDI().showEntryByID("ConfigView", "style.tags" + args_str);
                            }
                        }
                    });
                    new MenuItem(menu, 2);
                }

                @Override
                public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
                }
            });
            this.tvFiles.addSelectionListener(new TableSelectionListener(){

                @Override
                public void selected(TableRowCore[] row) {
                    OpenTorrentInstance.this.updateFileButtons();
                }

                @Override
                public void mouseExit(TableRowCore row) {
                }

                @Override
                public void mouseEnter(TableRowCore row) {
                }

                @Override
                public void focusChanged(TableRowCore focus) {
                }

                @Override
                public void deselected(TableRowCore[] rows) {
                    OpenTorrentInstance.this.updateFileButtons();
                }

                @Override
                public void defaultSelected(TableRowCore[] rows, int stateMask) {
                    TorrentOpenFileOptions[] infos = new TorrentOpenFileOptions[rows.length];
                    int pos = 0;
                    TableRowCore[] tableRowCoreArray = rows;
                    int n = rows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableRowCore row = tableRowCoreArray[n2];
                        infos[pos++] = (TorrentOpenFileOptions)row.getDataSource();
                        ++n2;
                    }
                    OpenTorrentInstance.this.renameFilenames(infos);
                }
            }, false);
            TorrentOpenFileOptions[] files = this.torrentOptions.getFiles();
            TOTorrent torrent = this.torrentOptions.getTorrent();
            TOTorrentFile[] torrent_files = torrent.getFiles();
            ArrayList<TorrentOpenFileOptions> visible_files = new ArrayList<TorrentOpenFileOptions>(files.length);
            TorrentOpenFileOptions[] torrentOpenFileOptionsArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                TorrentOpenFileOptions file = torrentOpenFileOptionsArray[n2];
                if (!torrent_files[file.getIndex()].isPadFile()) {
                    visible_files.add(file);
                }
                ++n2;
            }
            this.tvFiles.addDataSources((TorrentOpenFileOptions[])visible_files.toArray(new TorrentOpenFileOptions[0]));
        }

        @Override
        public boolean filterCheck(TorrentOpenFileOptions ds, String filter2, boolean regex, boolean confusable) {
            Pattern pattern;
            String name;
            boolean filter_on_path;
            File file;
            block10: {
                if (filter2 == null || filter2.length() == 0) {
                    return true;
                }
                if (confusable) {
                    filter2 = GeneralUtils.getConfusableEquivalent(filter2, true);
                }
                try {
                    file = ds.getDestFileFullName();
                    filter_on_path = false;
                    if (filter2.startsWith("p:")) {
                        filter_on_path = true;
                        filter2 = filter2.substring(2);
                    } else if (filter2.startsWith(File.separator)) {
                        filter_on_path = true;
                        filter2 = filter2.substring(1);
                    }
                    if (!filter2.isEmpty()) break block10;
                    return true;
                }
                catch (Exception e) {
                    return true;
                }
            }
            String string = name = filter_on_path ? file.getAbsolutePath() : file.getName();
            if (confusable) {
                name = GeneralUtils.getConfusableEquivalent(name, false);
            }
            String s = regex ? filter2 : RegExUtil.splitAndQuote(filter2, "\\s*[|;]\\s*");
            boolean match_result = true;
            if (regex && s.startsWith("!")) {
                s = s.substring(1);
                match_result = false;
            }
            boolean result = (pattern = RegExUtil.getCachedPattern("fv:search", s, 66)).matcher(name).find() == match_result;
            return result;
        }

        @Override
        public void filterSet(String filter2) {
        }

        protected void updateFileButtons() {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    boolean hasRowsSelected;
                    TableRowCore[] rows = OpenTorrentInstance.this.tvFiles.getSelectedRows();
                    boolean bl = hasRowsSelected = rows.length > 0;
                    if (OpenTorrentInstance.this.btnRename != null && !OpenTorrentInstance.this.btnRename.isDisposed()) {
                        OpenTorrentInstance.this.btnRename.setEnabled(rows.length > 0);
                    }
                    if (OpenTorrentInstance.this.btnRetarget != null && !OpenTorrentInstance.this.btnRetarget.isDisposed()) {
                        OpenTorrentInstance.this.btnRetarget.setEnabled(hasRowsSelected);
                    }
                    boolean all_marked = true;
                    boolean all_unmarked = true;
                    TableRowCore[] tableRowCoreArray = rows;
                    int n = rows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableRowCore row = tableRowCoreArray[n2];
                        TorrentOpenFileOptions tfi = (TorrentOpenFileOptions)row.getDataSource();
                        if (tfi.isToDownload()) {
                            all_unmarked = false;
                        } else {
                            all_marked = false;
                        }
                        ++n2;
                    }
                    if (OpenTorrentInstance.this.btnSelectAll != null && !OpenTorrentInstance.this.btnSelectAll.isDisposed()) {
                        OpenTorrentInstance.this.btnSelectAll.setEnabled(rows.length < OpenTorrentInstance.this.torrentOptions.getFiles().length);
                    }
                    if (OpenTorrentInstance.this.btnMarkSelected != null && !OpenTorrentInstance.this.btnMarkSelected.isDisposed()) {
                        OpenTorrentInstance.this.btnMarkSelected.setEnabled(hasRowsSelected && !all_marked);
                    }
                    if (OpenTorrentInstance.this.btnUnmarkSelected != null && !OpenTorrentInstance.this.btnUnmarkSelected.isDisposed()) {
                        OpenTorrentInstance.this.btnUnmarkSelected.setEnabled(hasRowsSelected && !all_unmarked);
                    }
                    if (OpenTorrentInstance.this.btnSwarmIt != null && !OpenTorrentInstance.this.btnSwarmIt.isDisposed()) {
                        boolean enable = false;
                        if (rows.length == 1) {
                            TorrentOpenFileOptions tfi = (TorrentOpenFileOptions)rows[0].getDataSource();
                            enable = tfi.getSize() >= 0x3200000L;
                        }
                        OpenTorrentInstance.this.btnSwarmIt.setEnabled(enable);
                    }
                }
            });
        }

        protected void renameFilenames(TorrentOpenFileOptions[] torrentFileInfos) {
            this.renameFilenames(torrentFileInfos, 0);
        }

        protected void renameFilenames(final TorrentOpenFileOptions[] torrentFileInfos, final int index) {
            if (index >= torrentFileInfos.length) {
                return;
            }
            final TorrentOpenFileOptions torrentFileInfo = torrentFileInfos[index];
            SimpleTextEntryWindow dialog = new SimpleTextEntryWindow("FilesView.rename.filename.title", "FilesView.rename.filename.text");
            String fileName = torrentFileInfo.getOriginalFileName();
            dialog.setPreenteredText(fileName, false);
            int pos = fileName.lastIndexOf(46);
            if (pos > 0) {
                int[] nArray = new int[2];
                nArray[1] = pos;
                dialog.selectPreenteredTextRange(nArray);
            }
            dialog.allowEmptyInput(false);
            dialog.setRememberLocationSize("file.rename.dialog.pos");
            dialog.prompt(new UIInputReceiverListener(){

                @Override
                public void UIInputReceiverClosed(UIInputReceiver receiver) {
                    if (OpenTorrentInstance.this.shell.isDisposed() || !receiver.hasSubmittedInput()) {
                        return;
                    }
                    String renameFilename = receiver.getSubmittedInput();
                    if (renameFilename == null) {
                        return;
                    }
                    torrentFileInfo.setDestFileName(renameFilename, true);
                    TableRowCore row = OpenTorrentInstance.this.tvFiles.getRow(torrentFileInfo);
                    if (row != null) {
                        row.invalidate(true);
                        row.refresh(true);
                    }
                    Utils.execSWTThreadLater(1, () -> OpenTorrentInstance.this.renameFilenames(torrentFileInfos, index + 1));
                }
            });
        }

        private void setSavePath() {
            if (this.torrentOptions.isSimpleTorrent()) {
                this.changeFileDestination(this.torrentOptions.getFiles(), false);
            } else {
                DirectoryDialog dDialog = new DirectoryDialog(this.shell, 131072);
                File filterPath = FileUtil.newFile(this.torrentOptions.getDataDir(), new String[0]);
                if (!filterPath.exists()) {
                    filterPath = filterPath.getParentFile();
                }
                Utils.setFilterPathWithTimeout(dDialog, filterPath.getAbsolutePath());
                dDialog.setMessage(String.valueOf(MessageText.getString("MainWindow.dialog.choose.savepath")) + " (" + this.torrentOptions.getTorrentName() + ")");
                String sNewDir = dDialog.open();
                if (sNewDir == null) {
                    return;
                }
                File newDir = FileUtil.newFile(sNewDir, new String[0]).getAbsoluteFile();
                if (!newDir.isDirectory()) {
                    if (newDir.exists()) {
                        Debug.out("new dir isn't a dir!");
                        return;
                    }
                    if (!newDir.mkdirs()) {
                        Debug.out("Failed to create '" + newDir + "'");
                        return;
                    }
                }
                this.setTopLevelFolder(newDir, false);
            }
        }

        private boolean canRemoveTopLevelFolder() {
            if (this.torrentOptions.isSimpleTorrent()) {
                return false;
            }
            File oldDir = FileUtil.newFile(this.torrentOptions.getDataDir(), new String[0]);
            File newDir = oldDir.getParentFile();
            File newParent = newDir.getParentFile();
            return newParent != null;
        }

        private void removeTopLevelFolder() {
            if (!this.torrentOptions.isSimpleTorrent()) {
                File oldDir = FileUtil.newFile(this.torrentOptions.getDataDir(), new String[0]);
                File newDir = oldDir.getParentFile();
                this.setTopLevelFolder(newDir, true);
            }
        }

        private void setTopLevelFolder(File newDir, boolean removedTop) {
            File newParent = newDir.getParentFile();
            if (newParent == null) {
                Debug.out("Invalid save path, parent folder is null");
                return;
            }
            this.torrentOptions.setExplicitDataDir(newParent.getAbsolutePath(), newDir.getName(), removedTop);
            if (COConfigurationManager.getBooleanParameter("open.torrent.window.rename.on.tlf.change")) {
                TorrentOpenFileOptions[] files = this.torrentOptions.getFiles();
                TorrentOpenFileOptions single_file = null;
                TorrentOpenFileOptions[] torrentOpenFileOptionsArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    TorrentOpenFileOptions file = torrentOpenFileOptionsArray[n2];
                    if (file.isToDownload()) {
                        if (single_file == null) {
                            single_file = file;
                        } else {
                            single_file = null;
                            break;
                        }
                    }
                    ++n2;
                }
                String new_name = single_file == null ? newDir.getName() : single_file.getDestFileName();
                this.torrentOptions.setManualRename(new_name);
            } else {
                this.torrentOptions.setManualRename(null);
            }
            this.updateDataDirCombo();
            this.cmbDataDirChanged();
        }

        private void changeFileDestination(TorrentOpenFileOptions[] infos, boolean allAtOnce) {
            if (allAtOnce && infos.length > 1) {
                Object[] p_chars;
                String current_parent = null;
                TorrentOpenFileOptions[] torrentOpenFileOptionsArray = infos;
                int n = infos.length;
                int n2 = 0;
                while (n2 < n) {
                    TorrentOpenFileOptions fileInfo2 = torrentOpenFileOptionsArray[n2];
                    String dest = fileInfo2.getDestPathName();
                    if (current_parent == null) {
                        current_parent = dest;
                    } else if (!current_parent.equals(dest)) {
                        char[] cp_chars = current_parent.toCharArray();
                        p_chars = dest.toCharArray();
                        int cp_len = cp_chars.length;
                        int p_len = p_chars.length;
                        int min = Math.min(cp_len, p_len);
                        int pos = 0;
                        while (pos < min && cp_chars[pos] == p_chars[pos]) {
                            ++pos;
                        }
                        if (pos < cp_len) {
                            File f = FileUtil.newFile(String.valueOf(new String(cp_chars, 0, pos)) + "x", new String[0]);
                            File pf = f.getParentFile();
                            current_parent = pf == null ? "" : pf.toString();
                        }
                    }
                    ++n2;
                }
                DirectoryDialog dDialog = new DirectoryDialog(this.shell, 131072);
                if (current_parent.length() > 0) {
                    Utils.setFilterPathWithTimeout(dDialog, current_parent);
                }
                dDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.savepath_forallfiles"));
                String sSavePath = dDialog.open();
                if (sSavePath != null) {
                    if (sSavePath.endsWith(File.separator)) {
                        sSavePath = sSavePath.substring(0, sSavePath.length() - 1);
                    }
                    int prefix_len = current_parent.length();
                    p_chars = infos;
                    int cp_chars = infos.length;
                    int dest = 0;
                    while (dest < cp_chars) {
                        char fileInfo3 = p_chars[dest];
                        String dest2 = fileInfo3.getDestPathName();
                        if (prefix_len == 0) {
                            File f = FileUtil.newFile(dest2, new String[0]);
                            while (f.getParentFile() != null) {
                                f = f.getParentFile();
                            }
                            dest2 = dest2.substring(f.toString().length());
                        } else {
                            dest2 = dest2.substring(prefix_len);
                        }
                        if (dest2.startsWith(File.separator)) {
                            dest2 = dest2.substring(1);
                        }
                        if (dest2.length() > 0) {
                            fileInfo3.setDestPathName(String.valueOf(sSavePath) + File.separator + dest2);
                        } else {
                            fileInfo3.setDestPathName(sSavePath);
                        }
                        ++dest;
                    }
                }
            } else {
                TorrentOpenFileOptions[] torrentOpenFileOptionsArray = infos;
                int n = infos.length;
                int n3 = 0;
                while (n3 < n) {
                    TorrentOpenFileOptions fileInfo4 = torrentOpenFileOptionsArray[n3];
                    int style = fileInfo4.getTorrentOptions().getStartMode() == 4 ? 4096 : 8192;
                    FileDialog fDialog = new FileDialog(this.shell, 0x20000 | style);
                    String sFilterPath = fileInfo4.getDestPathName();
                    String sFileName = fileInfo4.getOriginalFileName();
                    File f = FileUtil.newFile(sFilterPath, new String[0]);
                    if (!f.isDirectory()) {
                        while (sFilterPath != null) {
                            String parentPath = f.getParent();
                            if (parentPath == null || (f = FileUtil.newFile(sFilterPath = parentPath, new String[0])).isDirectory()) break;
                        }
                    }
                    if (sFilterPath != null) {
                        Utils.setFilterPathWithTimeout(fDialog, sFilterPath);
                    }
                    fDialog.setFileName(sFileName);
                    fDialog.setText(String.valueOf(MessageText.getString("MainWindow.dialog.choose.savepath")) + " (" + fileInfo4.getOriginalFullName() + ")");
                    String sNewName = fDialog.open();
                    if (sNewName == null) {
                        return;
                    }
                    if (fileInfo4.getTorrentOptions().getStartMode() == 4) {
                        File file = FileUtil.newFile(sNewName, new String[0]);
                        if (file.length() == fileInfo4.getSize()) {
                            fileInfo4.setFullDestName(sNewName);
                        } else {
                            MessageBoxShell mb = new MessageBoxShell(32, "OpenTorrentWindow.mb.badSize", new String[]{file.getName(), fileInfo4.getOriginalFullName()});
                            mb.setParent(this.shell);
                            mb.open(null);
                        }
                    } else {
                        fileInfo4.setFullDestName(sNewName);
                    }
                    ++n3;
                }
            }
            this.checkSeedingMode();
            this.updateDataDirCombo();
            this.diskFreeInfoRefreshPending = true;
        }

        private void setupInfoSection(SWTSkin skin) {
            SWTSkinObject so = skin.getSkinObject("expanditem-torrentinfo");
            if (so instanceof SWTSkinObjectExpandItem) {
                this.soExpandItemTorrentInfo = (SWTSkinObjectExpandItem)((Object)so);
                this.soExpandItemTorrentInfo.setText(String.valueOf(MessageText.getString("OpenTorrentOptions.header.torrentinfo")) + ": " + this.torrentOptions.getTorrentName());
            }
            so = skin.getSkinObject("torrentinfo-name");
            final TOTorrent torrent = this.torrentOptions.getTorrent();
            if (so instanceof SWTSkinObjectText) {
                String hash_str = TorrentUtils.nicePrintTorrentHash(torrent);
                SWTSkinObjectText text = (SWTSkinObjectText)so;
                text.setText(String.valueOf(this.torrentOptions.getTorrentName()) + (torrent == null ? "" : "\u00a0\u00a0\u00a0\u00a0[" + hash_str + "]"));
                if (torrent != null) {
                    Control control = text.getControl();
                    Menu menu = new Menu(control);
                    control.setMenu(menu);
                    MenuItem save_torrent = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)save_torrent, "menu.save.torrent");
                    save_torrent.addListener(13, ev -> TorrentUtil.exportTorrent(String.valueOf(this.torrentOptions.getTorrentName()) + ".torrent", torrent, control.getShell()));
                    new MenuItem(menu, 2);
                    ClipboardCopy.addCopyToClipMenu(menu, (ClipboardCopy.copyToClipProvider)new ClipboardCopy.copyToClipProvider2(){

                        @Override
                        public String getMenuResource() {
                            return "menu.copy.hash.to.clipboard";
                        }

                        @Override
                        public String getText() {
                            return TorrentUtils.nicePrintTorrentHash(torrent, true);
                        }
                    });
                }
            }
            if (torrent != null) {
                so = skin.getSkinObject("torrentinfo-trackername");
                if (so instanceof SWTSkinObjectText) {
                    String trackerName = String.valueOf(MessageText.getString("label.tracker")) + ": " + TrackerNameItem.getTrackerName(torrent) + (torrent == null || !torrent.getPrivate() ? "" : " (" + MessageText.getString("label.private") + ")");
                    ((SWTSkinObjectText)so).setText(trackerName);
                }
                if ((so = skin.getSkinObject("torrentinfo-comment")) instanceof SWTSkinObjectText) {
                    try {
                        LocaleUtilDecoder decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
                        String s = decoder.decodeString(torrent.getComment());
                        s = String.valueOf(MessageText.getString("GeneralView.label.comment")) + " " + (s == null ? "" : s);
                        ((SWTSkinObjectText)so).setText(s);
                    }
                    catch (UnsupportedEncodingException decoder) {
                    }
                    catch (TOTorrentException decoder) {
                        // empty catch block
                    }
                }
                if ((so = skin.getSkinObject("torrentinfo-createdon")) instanceof SWTSkinObjectText) {
                    String creation_date = DisplayFormatters.formatDate(torrent.getCreationDate() * 1000L);
                    creation_date = String.valueOf(MessageText.getString("GeneralView.label.creationdate")) + " " + creation_date;
                    ((SWTSkinObjectText)so).setText(creation_date);
                }
                if ((so = skin.getSkinObject("torrentinfo-encoding")) instanceof SWTSkinObjectText) {
                    SWTSkinObjectText soTorrentEncoding = (SWTSkinObjectText)so;
                    String enc_str = String.valueOf(MessageText.getString("TorrentInfoView.torrent.encoding")) + ": " + this.getEncodingName(torrent);
                    int tt = torrent.getTorrentType();
                    int ett = torrent.getEffectiveTorrentType();
                    String extra = "";
                    if (tt == 2 && ett != tt) {
                        extra = ", " + MessageText.getString("label.effective") + " V" + (ett == 1 ? 1 : 2);
                    }
                    enc_str = String.valueOf(enc_str) + "; " + MessageText.getString("label.torrent.type") + ": " + MessageText.getString("label.torrent.type." + tt) + extra;
                    soTorrentEncoding.setText(enc_str);
                    final Runnable chooseEncoding = () -> {
                        try {
                            LocaleTorrentUtil.getTorrentEncoding(torrent, true, true);
                            this.torrentOptions.rebuildOriginalNames();
                            this.setupInfoSection(skin);
                            if (this.txtSubFolder != null) {
                                String top = FileUtil.newFile(this.torrentOptions.getDataDir(), new String[0]).getName();
                                this.txtSubFolder.setText(top);
                            }
                        }
                        catch (TOTorrentException ex) {
                            Debug.out(ex);
                        }
                    };
                    Control control = so.getControl();
                    if (control.getData("hasMouseL") == null) {
                        control.addMouseListener((MouseListener)new MouseAdapter(){

                            public void mouseUp(MouseEvent e) {
                                if (e.button != 1) {
                                    return;
                                }
                                chooseEncoding.run();
                            }
                        });
                        control.setData("hasMouseL", (Object)true);
                    }
                    Menu menu = new Menu(control);
                    control.setMenu(menu);
                    MenuItem mi = new MenuItem(menu, 8);
                    mi.setText(MessageText.getString("LocaleUtil.title"));
                    mi.addListener(13, ev -> chooseEncoding.run());
                    mi.setEnabled(LocaleTorrentUtil.canChangeTorrentEncoding(torrent));
                    mi = new MenuItem(menu, 8);
                    mi.setText(String.valueOf(MessageText.getString("label.effective")) + " -> V" + (tt == 2 ? (ett == 1 ? 2 : 1) : (tt == 1 ? 1 : 2)));
                    mi.addListener(13, ev -> {
                        try {
                            String file = TorrentUtils.getTorrentFileName(torrent);
                            TOTorrent new_torrent = torrent.selectHybridHashType(ett == 1 ? 3 : 1);
                            if (file != null) {
                                TorrentUtils.writeToFile(new_torrent, new File(file), false);
                            }
                            this.torrentOptions.setTorrent(new_torrent);
                            this.setupInfoSection(skin);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    });
                    mi.setEnabled(tt == 2);
                }
            }
        }

        private String getEncodingName(TOTorrent torrent) {
            LocaleUtilDecoder decoder;
            String encoding = torrent.getAdditionalStringProperty("encoding");
            if (encoding == null && (decoder = LocaleTorrentUtil.getTorrentEncodingIfAvailable(torrent)) != null) {
                encoding = decoder.getName();
            }
            return encoding;
        }

        private void setupTrackers(SWTSkinObjectContainer so) {
            Composite parent = so.getComposite();
            Button button = new Button(parent, 8);
            Messages.setLanguageText((Widget)button, "label.edit.trackers");
            if (this.isSingleOptions) {
                TOTorrent torrent = this.torrentOptions.getTorrent();
                button.setEnabled(torrent != null && !TorrentUtils.isReallyPrivate(torrent));
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        List<List<String>> trackers = OpenTorrentInstance.this.torrentOptions.getTrackers(false);
                        new MultiTrackerEditor(OpenTorrentInstance.this.shell, null, trackers, new TrackerEditorListener(){

                            @Override
                            public void trackersChanged(String str, String str2, List<List<String>> updatedTrackers) {
                                OpenTorrentInstance.this.torrentOptions.setTrackers(updatedTrackers);
                            }
                        }, true, true);
                    }
                });
            } else {
                ArrayList<TOTorrent> torrents = new ArrayList<TOTorrent>();
                boolean bad = false;
                for (TorrentOpenOptions to : this.torrentOptionsMulti) {
                    TOTorrent torrent = to.getTorrent();
                    if (torrent == null || TorrentUtils.isReallyPrivate(torrent)) {
                        bad = true;
                        break;
                    }
                    torrents.add(torrent);
                }
                button.setEnabled(!bad && !torrents.isEmpty());
                if (!bad) {
                    button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ArrayList<List<List<String>>> groups = new ArrayList<List<List<String>>>();
                            for (TorrentOpenOptions to : OpenTorrentInstance.this.torrentOptionsMulti) {
                                List<List<String>> trackers = to.getTrackers(false);
                                groups.add(trackers);
                            }
                            List<List<String>> merged_trackers = TorrentUtils.getMergedTrackersFromGroups(groups);
                            new MultiTrackerEditor(OpenTorrentInstance.this.shell, null, merged_trackers, new TrackerEditorListener(){

                                @Override
                                public void trackersChanged(String str, String str2, List<List<String>> updatedTrackers) {
                                    for (TorrentOpenOptions to : OpenTorrentInstance.this.torrentOptionsMulti) {
                                        to.setTrackers(updatedTrackers);
                                    }
                                }
                            }, true, true);
                        }
                    });
                }
            }
        }

        private void setupUpDownLimitOption(SWTSkinObjectContainer so) {
            Composite parent = so.getComposite();
            parent.setLayout((Layout)new GridLayout(6, false));
            this.max_up_speed_button = new IntSwtParameter(parent, null, "TableColumn.header.maxupspeed", "", 0, Integer.MAX_VALUE, new IntSwtParameter.ValueProcessor(){

                @Override
                public Integer getValue(IntSwtParameter p) {
                    if (OpenTorrentInstance.this.isSingleOptions) {
                        return OpenTorrentInstance.this.torrentOptions.getMaxUploadSpeed();
                    }
                    ArrayList<Integer> values = new ArrayList<Integer>();
                    for (TorrentOpenOptions to : OpenTorrentInstance.this.torrentOptionsMulti) {
                        values.add(to.getMaxUploadSpeed());
                    }
                    return this.getValue((List<Integer>)values);
                }

                @Override
                public boolean setValue(IntSwtParameter p, Integer value) {
                    if (OpenTorrentInstance.this.isSingleOptions) {
                        if (OpenTorrentInstance.this.torrentOptions.getMaxUploadSpeed() != value.intValue()) {
                            OpenTorrentInstance.this.torrentOptions.setMaxUploadSpeed(value);
                        }
                    } else {
                        for (TorrentOpenOptions to : OpenTorrentInstance.this.torrentOptionsMulti) {
                            to.setMaxUploadSpeed(value);
                            OpenTorrentOptionsWindow.this.getInstance(to).updateMaxUploadSpeed();
                        }
                    }
                    return true;
                }
            });
            Control sep1 = Utils.createSkinnedLabelSeparator(parent, 512);
            GridData gridData = new GridData();
            gridData.heightHint = 15;
            sep1.setLayoutData((Object)gridData);
            this.max_up_speed_button.setSuffixLabelText(DisplayFormatters.getRateUnit(1));
            this.max_down_speed_button = new IntSwtParameter(parent, null, "TableColumn.header.maxdownspeed", "adsadsad", 0, Integer.MAX_VALUE, new IntSwtParameter.ValueProcessor(){

                @Override
                public Integer getValue(IntSwtParameter p) {
                    if (OpenTorrentInstance.this.isSingleOptions) {
                        return OpenTorrentInstance.this.torrentOptions.getMaxDownloadSpeed();
                    }
                    ArrayList<Integer> values = new ArrayList<Integer>();
                    for (TorrentOpenOptions to : OpenTorrentInstance.this.torrentOptionsMulti) {
                        values.add(to.getMaxDownloadSpeed());
                    }
                    return this.getValue((List<Integer>)values);
                }

                @Override
                public boolean setValue(IntSwtParameter p, Integer value) {
                    if (OpenTorrentInstance.this.isSingleOptions) {
                        if (OpenTorrentInstance.this.torrentOptions.getMaxDownloadSpeed() != value.intValue()) {
                            OpenTorrentInstance.this.torrentOptions.setMaxDownloadSpeed(value);
                        }
                    } else {
                        for (TorrentOpenOptions to : OpenTorrentInstance.this.torrentOptionsMulti) {
                            to.setMaxDownloadSpeed(value);
                            OpenTorrentOptionsWindow.this.getInstance(to).updateMaxDownloadSpeed();
                        }
                    }
                    return true;
                }
            });
            this.max_down_speed_button.setSuffixLabelText(DisplayFormatters.getRateUnit(1));
            Control sep2 = Utils.createSkinnedLabelSeparator(parent, 512);
            gridData = new GridData();
            gridData.heightHint = 15;
            sep2.setLayoutData((Object)gridData);
        }

        private void setupIPFilterOption(SWTSkinObjectContainer so) {
            Composite parent = so.getComposite();
            parent.setLayout((Layout)new GridLayout(2, false));
            this.ip_filter_button = new BooleanSwtParameter(parent, null, "MyTorrentsView.menu.ipf_enable", null, new BooleanSwtParameter.ValueProcessor(){

                @Override
                public Boolean getValue(BooleanSwtParameter parameter) {
                    if (OpenTorrentInstance.this.isSingleOptions) {
                        Boolean value = !((OpenTorrentInstance)OpenTorrentInstance.this).torrentOptions.disableIPFilter;
                        return value;
                    }
                    ArrayList<Boolean> values = new ArrayList<Boolean>();
                    for (TorrentOpenOptions to : OpenTorrentInstance.this.torrentOptionsMulti) {
                        boolean value = !to.disableIPFilter;
                        values.add(value);
                    }
                    return this.getValue((List<Boolean>)values);
                }

                @Override
                public boolean setValue(BooleanSwtParameter parameter, Boolean value) {
                    if (OpenTorrentInstance.this.isSingleOptions) {
                        ((OpenTorrentInstance)OpenTorrentInstance.this).torrentOptions.disableIPFilter = value == false;
                        return true;
                    }
                    for (TorrentOpenOptions to : OpenTorrentInstance.this.torrentOptionsMulti) {
                        to.disableIPFilter = value == false;
                        OpenTorrentOptionsWindow.this.getInstance(to).updateIPFilter();
                    }
                    return true;
                }
            });
        }

        private void setupPeerSourcesAndNetworkOptions(SWTSkinObjectContainer so) {
            BooleanSwtParameter button;
            String msg_text;
            Composite parent = so.getComposite();
            Composite peer_sources_composite = new Composite(parent, 0);
            peer_sources_composite.setLayout((Layout)new RowLayout(256));
            Group peer_sources_group = Utils.createSkinnedGroup(peer_sources_composite, 0);
            Messages.setLanguageText((Widget)peer_sources_group, "ConfigView.section.connection.group.peersources");
            RowLayout peer_sources_layout = new RowLayout();
            peer_sources_layout.pack = true;
            peer_sources_layout.spacing = 10;
            peer_sources_group.setLayout((Layout)peer_sources_layout);
            FormData form_data = Utils.getFilledFormData();
            form_data.bottom = null;
            peer_sources_composite.setLayoutData((Object)form_data);
            int i = 0;
            while (i < PEPeerSource.PS_SOURCES.length) {
                final String p = PEPeerSource.PS_SOURCES[i];
                final String config_name = "Peer Source Selection Default." + p;
                msg_text = "ConfigView.section.connection.peersource." + p;
                button = new BooleanSwtParameter((Composite)peer_sources_group, null, msg_text, null, new BooleanSwtParameter.ValueProcessor(){

                    @Override
                    public Boolean getValue(BooleanSwtParameter parameter) {
                        if (OpenTorrentInstance.this.isSingleOptions) {
                            Boolean value = ((OpenTorrentInstance)OpenTorrentInstance.this).torrentOptions.peerSource.get(p);
                            if (value == null) {
                                value = COConfigurationManager.getBooleanParameter(config_name);
                            }
                            return value;
                        }
                        ArrayList<Boolean> values = new ArrayList<Boolean>();
                        for (TorrentOpenOptions to : OpenTorrentInstance.this.torrentOptionsMulti) {
                            Boolean value = to.peerSource.get(p);
                            if (value == null) {
                                value = COConfigurationManager.getBooleanParameter(config_name);
                            }
                            values.add(value);
                        }
                        return this.getValue((List<Boolean>)values);
                    }

                    @Override
                    public boolean setValue(BooleanSwtParameter parameter, Boolean value) {
                        if (OpenTorrentInstance.this.isSingleOptions) {
                            ((OpenTorrentInstance)OpenTorrentInstance.this).torrentOptions.peerSource.put(p, value);
                            return true;
                        }
                        for (TorrentOpenOptions to : OpenTorrentInstance.this.torrentOptionsMulti) {
                            to.peerSource.put(p, value);
                            OpenTorrentOptionsWindow.this.getInstance(to).updatePeerSourceOptions();
                        }
                        return true;
                    }
                });
                this.peer_source_buttons.add(button);
                ++i;
            }
            Composite network_group_parent = new Composite(parent, 0);
            network_group_parent.setLayout((Layout)new RowLayout(256));
            Group network_group = Utils.createSkinnedGroup(network_group_parent, 0);
            Messages.setLanguageText((Widget)network_group, "ConfigView.section.connection.group.networks");
            RowLayout network_layout = new RowLayout();
            network_layout.pack = true;
            network_layout.spacing = 10;
            network_group.setLayout((Layout)network_layout);
            FormData form_data2 = Utils.getFilledFormData();
            form_data2.top = new FormAttachment((Control)peer_sources_composite);
            network_group_parent.setLayoutData((Object)form_data2);
            int i2 = 0;
            while (i2 < AENetworkClassifier.AT_NETWORKS.length) {
                final String nn = AENetworkClassifier.AT_NETWORKS[i2];
                msg_text = "ConfigView.section.connection.networks." + nn;
                button = new BooleanSwtParameter((Composite)network_group, null, msg_text, null, new BooleanSwtParameter.ValueProcessor(){

                    @Override
                    public Boolean getValue(BooleanSwtParameter parameter) {
                        if (OpenTorrentInstance.this.isSingleOptions) {
                            Boolean value = OpenTorrentInstance.this.torrentOptions.getNetworkEnabled(nn);
                            return value;
                        }
                        ArrayList<Boolean> values = new ArrayList<Boolean>();
                        for (TorrentOpenOptions to : OpenTorrentInstance.this.torrentOptionsMulti) {
                            boolean value = to.getNetworkEnabled(nn);
                            values.add(value);
                        }
                        return this.getValue((List<Boolean>)values);
                    }

                    @Override
                    public boolean setValue(BooleanSwtParameter parameter, Boolean value) {
                        if (OpenTorrentInstance.this.isSingleOptions) {
                            OpenTorrentInstance.this.torrentOptions.setNetworkEnabled(nn, value);
                            return true;
                        }
                        for (TorrentOpenOptions to : OpenTorrentInstance.this.torrentOptionsMulti) {
                            to.setNetworkEnabled(nn, value);
                            OpenTorrentOptionsWindow.this.getInstance(to).updateNetworkOptions();
                        }
                        return true;
                    }
                });
                this.network_buttons.add(button);
                ++i2;
            }
        }

        private void updateIPFilter() {
            if (this.ip_filter_button == null) {
                return;
            }
            this.ip_filter_button.setValue(!this.torrentOptions.disableIPFilter);
        }

        private void updateMaxUploadSpeed() {
            if (this.max_up_speed_button == null) {
                return;
            }
            this.max_up_speed_button.setValue(this.torrentOptions.getMaxUploadSpeed());
        }

        private void updateMaxDownloadSpeed() {
            if (this.max_down_speed_button == null) {
                return;
            }
            this.max_down_speed_button.setValue(this.torrentOptions.getMaxDownloadSpeed());
        }

        private void updatePeerSourceOptions() {
            if (this.peer_source_buttons.size() != PEPeerSource.PS_SOURCES.length) {
                return;
            }
            Map<String, Boolean> ps = this.torrentOptions.peerSource;
            int i = 0;
            while (i < PEPeerSource.PS_SOURCES.length) {
                Boolean value = ps.get(PEPeerSource.PS_SOURCES[i]);
                if (value != null) {
                    this.peer_source_buttons.get(i).setValue(value);
                }
                ++i;
            }
        }

        private void updateNetworkOptions() {
            if (this.network_buttons.size() != AENetworkClassifier.AT_NETWORKS.length) {
                return;
            }
            Map<String, Boolean> enabledNetworks = this.torrentOptions.getEnabledNetworks();
            int i = 0;
            while (i < AENetworkClassifier.AT_NETWORKS.length) {
                this.network_buttons.get(i).setValue(enabledNetworks.get(AENetworkClassifier.AT_NETWORKS[i]));
                ++i;
            }
        }

        private void updateDataDirCombo() {
            if (this.cmbDataDir == null) {
                return;
            }
            try {
                this.bSkipDataDirModify = true;
                if (this.torrentOptions == null) {
                    String prev_parent = null;
                    boolean not_same = false;
                    for (TorrentOpenOptions to : this.torrentOptionsMulti) {
                        String parent = to.getParentDir();
                        if (prev_parent != null && !prev_parent.equals(parent)) {
                            not_same = true;
                            break;
                        }
                        prev_parent = parent;
                    }
                    if (not_same) {
                        this.cmbDataDir.setText(COConfigurationManager.getStringParameter(OpenTorrentOptionsWindow.PARAM_DEFSAVEPATH));
                    } else {
                        this.cmbDataDir.setText(prev_parent == null ? "" : prev_parent);
                    }
                } else {
                    this.cmbDataDir.setText(this.torrentOptions.getParentDir());
                }
            }
            finally {
                this.bSkipDataDirModify = false;
            }
        }

        private void setSavePath(String path) {
            if (this.cmbDataDir != null) {
                this.cmbDataDir.setText(path);
            }
        }

        private void setSavePathEnabled(boolean enabled) {
            this.cmbDataDirEnabled = enabled;
            if (this.cmbDataDir != null) {
                this.cmbDataDir.setEnabled(enabled);
                this.btnDataDir.setEnabled(enabled);
                this.btnSearch.setEnabled(enabled);
            }
        }

        private String getSavePath() {
            if (this.isSingleOptions) {
                return this.torrentOptions.getParentDir();
            }
            return "";
        }

        private void updateQueueLocationCombo() {
            if (this.cmbQueueLocation == null) {
                return;
            }
            boolean includeAuto = true;
            if (this.isSingleOptions) {
                includeAuto = this.torrentOptions.getAutoQueuePositionTime() > 0L;
            } else {
                for (TorrentOpenOptions to : this.torrentOptionsMulti) {
                    if (to.getAutoQueuePositionTime() > 0L) continue;
                    includeAuto = false;
                    break;
                }
            }
            ArrayList<String> sItemsText = new ArrayList<String>();
            int i = 0;
            while (i < MSGKEY_QUEUELOCATIONS.length) {
                if (includeAuto || i != 2) {
                    String sText = MessageText.getString(MSGKEY_QUEUELOCATIONS[i]);
                    sItemsText.add(sText);
                }
                ++i;
            }
            this.cmbQueueLocation.setItems(sItemsText.toArray(new String[0]));
            if (this.isSingleOptions) {
                this.cmbQueueLocation.select(this.torrentOptions.getQueueLocation());
            } else {
                int queueLocation = -1;
                for (TorrentOpenOptions to : this.torrentOptionsMulti) {
                    int ql = to.getQueueLocation();
                    if (queueLocation == -1) {
                        queueLocation = ql;
                        continue;
                    }
                    if (queueLocation == ql) continue;
                    queueLocation = -2;
                }
                if (queueLocation >= 0) {
                    this.cmbQueueLocation.select(queueLocation);
                } else {
                    this.cmbQueueLocation.deselectAll();
                }
            }
        }

        private void updateSequentialDownloadButton() {
            if (this.btnSequentialDownload == null) {
                return;
            }
            if (this.isSingleOptions) {
                this.btnSequentialDownload.setSelection(this.torrentOptions.getSequentialDownload());
            } else {
                int seq = -1;
                for (TorrentOpenOptions to : this.torrentOptionsMulti) {
                    int s;
                    int n = s = to.getSequentialDownload() ? 1 : 0;
                    if (seq == -1) {
                        seq = s;
                        continue;
                    }
                    if (seq == s) continue;
                    seq = -2;
                }
                if (seq >= 0) {
                    this.btnSequentialDownload.setSelection(seq == 1);
                    this.btnSequentialDownload.setGrayed(false);
                } else {
                    this.btnSequentialDownload.setSelection(true);
                    this.btnSequentialDownload.setGrayed(true);
                }
            }
        }

        private void updateSize() {
            TorrentOpenFileOptions[] dataFiles;
            if (this.soFileAreaInfo == null && this.soExpandItemFiles == null) {
                return;
            }
            long totalSize = 0L;
            long checkedSize = 0L;
            long numToDownload = 0L;
            TorrentOpenFileOptions[] torrentOpenFileOptionsArray = dataFiles = this.torrentOptions.getFiles();
            int n = dataFiles.length;
            int n2 = 0;
            while (n2 < n) {
                TorrentOpenFileOptions file = torrentOpenFileOptionsArray[n2];
                totalSize += file.getSize();
                if (file.isToDownload()) {
                    checkedSize += file.getSize();
                    ++numToDownload;
                }
                ++n2;
            }
            boolean changed = checkedSize != this.currentSelectedDataSize;
            this.currentSelectedDataSize = checkedSize;
            String text = totalSize == 0L ? "" : (checkedSize == totalSize ? DisplayFormatters.formatByteCountToKiBEtc(totalSize) : MessageText.getString("OpenTorrentWindow.filesInfo", new String[]{DisplayFormatters.formatByteCountToKiBEtc(checkedSize), DisplayFormatters.formatByteCountToKiBEtc(totalSize)}));
            if (this.soFileAreaInfo != null) {
                this.soFileAreaInfo.setText(text);
            }
            if (this.soExpandItemFiles != null) {
                String id = "OpenTorrentOptions.header.filesInfo." + (numToDownload == (long)dataFiles.length ? "all" : "some");
                this.soExpandItemFiles.setText(MessageText.getString(id, new String[]{String.valueOf(numToDownload), String.valueOf(dataFiles.length), text}));
            }
            this.diskFreeInfoRefreshPending = true;
            if (changed) {
                this.changeListener.instanceChanged(this);
            }
        }

        protected long getSelectedDataSize() {
            return this.currentSelectedDataSize;
        }

        private void updateStartModeCombo() {
            if (this.cmbStartMode == null) {
                return;
            }
            String[] sItemsText = new String[TorrentOpenOptions.STARTMODE_KEYS.length];
            int i = 0;
            while (i < sItemsText.length) {
                String sText;
                sItemsText[i] = sText = MessageText.getString(TorrentOpenOptions.STARTMODE_KEYS[i]);
                ++i;
            }
            this.cmbStartMode.setItems(sItemsText);
            if (this.isSingleOptions) {
                this.cmbStartMode.select(this.torrentOptions.getStartMode());
            } else {
                int startMode = -1;
                for (TorrentOpenOptions to : this.torrentOptionsMulti) {
                    int sm = to.getStartMode();
                    if (startMode == -1) {
                        startMode = sm;
                        continue;
                    }
                    if (startMode == sm) continue;
                    startMode = -2;
                }
                if (startMode >= 0) {
                    this.cmbStartMode.select(startMode);
                } else {
                    this.cmbStartMode.deselectAll();
                }
            }
            this.cmbStartMode.layout(true);
        }

        public void updateUI() {
            if (this.tvFiles != null) {
                this.tvFiles.refreshTable(false);
            }
            for (FileStatsCacheItem item : this.fileStatCache.values()) {
                item.update();
            }
            if (this.diskFreeInfoRefreshPending && !this.diskFreeInfoRefreshRunning) {
                this.diskFreeInfoRefreshRunning = true;
                this.diskFreeInfoRefreshPending = false;
                File[] FSfiles = Utils.listFileRootsWithTimeout();
                HashMap<File, File> FSroots = new HashMap<File, File>();
                File[] fileArray = FSfiles;
                int n = FSfiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    FSroots.put(f, f);
                    ++n2;
                }
                HashMap<String, Partition> partitions = new HashMap<String, Partition>();
                for (TorrentOpenOptions too : this.torrentOptionsMulti) {
                    TorrentOpenFileOptions[] files = too.getFiles();
                    int j = 0;
                    while (j < files.length) {
                        TorrentOpenFileOptions file = files[j];
                        if (file.isToDownload()) {
                            File rootFile = file.getDestFileFullName().getAbsoluteFile();
                            StringInterner.DirKey parentKey = new StringInterner.DirKey(rootFile.getParentFile());
                            Partition part = (Partition)partitions.get(this.parentToRootCache.get(parentKey));
                            if (part == null) {
                                while (true) {
                                    File rf;
                                    File next;
                                    if ((next = (rootFile = rootFile.getParentFile()).getParentFile()) == null) {
                                        rf = (File)FSroots.get(rootFile);
                                        if (rf == null) break;
                                        rootFile = rf;
                                        break;
                                    }
                                    if (!this.getCachedExistsStat(rootFile) || !rootFile.isDirectory()) continue;
                                    rf = (File)FSroots.get(rootFile);
                                    if (rf != null) {
                                        rootFile = rf;
                                        break;
                                    }
                                    if (rootFile.equals(next)) break;
                                }
                                String rootStr = StringInterner.intern(rootFile.getAbsolutePath());
                                this.parentToRootCache.put(parentKey, rootStr);
                                part = (Partition)partitions.get(rootStr);
                                if (part == null) {
                                    part = new Partition(rootFile);
                                    partitions.put(rootStr, part);
                                }
                            }
                            part.bytesToConsume += file.getSize();
                        }
                        ++j;
                    }
                }
                if (this.diskspaceComp != null && !this.diskspaceComp.isDisposed()) {
                    Control[] labels = this.diskspaceComp.getChildren();
                    int i = 0;
                    while (i < labels.length) {
                        labels[i].dispose();
                        ++i;
                    }
                    for (Partition part : partitions.values()) {
                        boolean filesTooBig = part.bytesToConsume > part.freeSpace.freeSpace;
                        String s = MessageText.getString("v3.MainWindow.xofx", new String[]{DisplayFormatters.formatByteCountToKiBEtc(part.bytesToConsume), DisplayFormatters.formatByteCountToKiBEtc(part.freeSpace.freeSpace)});
                        File root = part.root;
                        File rootFile = (File)FSroots.get(root);
                        if (rootFile == null) {
                            rootFile = root;
                        }
                        String rootStr = rootFile.getPath();
                        Label l = new Label(this.diskspaceComp, 0);
                        l.setForeground((Color)(filesTooBig ? Colors.colorError : null));
                        l.setText(rootStr);
                        l.setLayoutData((Object)new GridData(0x1000008, 128, false, false));
                        l = new Label(this.diskspaceComp, 0);
                        l.setForeground((Color)(filesTooBig ? Colors.colorError : null));
                        l.setLayoutData((Object)new GridData(0x1000008, 128, false, false));
                        l.setText(s);
                    }
                    this.diskspaceComp.layout(true);
                    this.soExpandItemSaveTo.relayout();
                }
                this.diskFreeInfoRefreshRunning = false;
            }
        }

        private void cancelPressed() {
            this.torrentOptions.cancel();
        }

        private boolean okPressed(String dataDirPassed, boolean auto) {
            int limit;
            String newSavePath;
            MessageBoxShell mb;
            boolean isPathInvalid;
            File fileDefSavePath;
            File filePassed = FileUtil.newFile(dataDirPassed, new String[0]);
            if (filePassed.equals(fileDefSavePath = FileUtil.newFile(COConfigurationManager.getStringParameter(OpenTorrentOptionsWindow.PARAM_DEFSAVEPATH), new String[0])) && !fileDefSavePath.isDirectory()) {
                FileUtil.mkdirs(fileDefSavePath);
            }
            boolean bl = isPathInvalid = dataDirPassed.length() == 0 || filePassed.isFile();
            if (!isPathInvalid && !filePassed.isDirectory()) {
                mb = new MessageBoxShell(196, "OpenTorrentWindow.mb.askCreateDir", new String[]{filePassed.toString()});
                mb.setParent(this.shell);
                mb.open(null);
                int doCreate = mb.waitUntilClosed();
                if (doCreate == 64) {
                    isPathInvalid = !FileUtil.mkdirs(filePassed);
                } else {
                    this.cmbDataDir.setFocus();
                    return false;
                }
            }
            if (isPathInvalid) {
                mb = new MessageBoxShell(33, "OpenTorrentWindow.mb.noGlobalDestDir", new String[]{filePassed.toString()});
                mb.setParent(this.shell);
                mb.open(null);
                this.cmbDataDir.setFocus();
                return false;
            }
            File torrentFile = FileUtil.newFile(this.torrentOptions.getTorrentFile(), new String[0]);
            if (!torrentFile.exists()) {
                TOTorrent torrent = this.torrentOptions.getTorrent();
                if (torrent != null) {
                    try {
                        TorrentUtils.writeToFile(torrent, torrentFile, false);
                        Debug.out("Managed to re-save torrent file to '" + torrentFile.getAbsolutePath() + "'");
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                if (!torrentFile.exists()) {
                    MessageBoxShell mb2 = new MessageBoxShell(33, "OpenTorrentWindow.mb.noTorrentFile", new String[]{torrentFile.getAbsolutePath()});
                    mb2.setParent(this.shell);
                    mb2.open(null);
                    return false;
                }
            }
            String sExistingFiles = "";
            int iNumExistingFiles = 0;
            File torrentOptionsDataDir = FileUtil.newFile(this.torrentOptions.getDataDir(), new String[0]);
            if (!this.torrentOptions.isSimpleTorrent()) {
                torrentOptionsDataDir = torrentOptionsDataDir.getParentFile();
            }
            if (!torrentOptionsDataDir.isDirectory() && !FileUtil.mkdirs(torrentOptionsDataDir)) {
                MessageBoxShell mb3 = new MessageBoxShell(33, "OpenTorrentWindow.mb.noDestDir", new String[]{torrentOptionsDataDir.toString(), this.torrentOptions.getTorrentName()});
                mb3.setParent(this.shell);
                mb3.open(null);
                return false;
            }
            if (!this.torrentOptions.isValid) {
                MessageBoxShell mb4 = new MessageBoxShell(33, "OpenTorrentWindow.mb.notValid", new String[]{this.torrentOptions.getTorrentName()});
                mb4.setParent(this.shell);
                mb4.open(null);
                return false;
            }
            TorrentOpenFileOptions[] files = this.torrentOptions.getFiles();
            int j = 0;
            while (j < files.length) {
                TorrentOpenFileOptions fileInfo2 = files[j];
                if (fileInfo2.getDestFileFullName().exists()) {
                    sExistingFiles = String.valueOf(sExistingFiles) + fileInfo2.getOriginalFullName() + " - " + this.torrentOptions.getTorrentName() + "\n";
                    if (++iNumExistingFiles > 5) break;
                }
                ++j;
            }
            if (sExistingFiles.length() > 0) {
                if (iNumExistingFiles > 5) {
                    sExistingFiles = String.valueOf(sExistingFiles) + MessageText.getString("OpenTorrentWindow.mb.existingFiles.partialList", new String[]{"" + iNumExistingFiles}) + "\n";
                }
                MessageBoxShell mb5 = new MessageBoxShell(296, "OpenTorrentWindow.mb.existingFiles", new String[]{sExistingFiles});
                mb5.setParent(this.shell);
                mb5.open(null);
                if (mb5.waitUntilClosed() != 32) {
                    return false;
                }
            }
            String sDefaultPath = COConfigurationManager.getStringParameter(OpenTorrentOptionsWindow.PARAM_DEFSAVEPATH);
            if (this.torrentOptions.isExplicitDataDir()) {
                newSavePath = this.torrentOptions.getDataDir();
                if (this.torrentOptions.getSubDir() != null && !this.torrentOptions.isSimpleTorrent() && !this.torrentOptions.isRemovedTopLevel()) {
                    newSavePath = FileUtil.newFile(newSavePath, new String[0]).getParent();
                }
            } else {
                newSavePath = this.torrentOptions.getParentDir();
            }
            if ((limit = COConfigurationManager.getIntParameter("saveTo_list.max_entries")) >= 0) {
                List<String> oldDirList = COConfigurationManager.getStringListParameter("saveTo_list");
                newSavePath = FileUtil.newFile(newSavePath, new String[0]).getAbsolutePath();
                LinkedList<String> newDirList = new LinkedList<String>();
                newDirList.add(newSavePath);
                HashSet<String> existing = new HashSet<String>();
                existing.addAll(newDirList);
                for (String entry : oldDirList) {
                    if (existing.contains(entry)) continue;
                    existing.add(entry);
                    newDirList.add(entry);
                }
                if (limit > 0) {
                    while (newDirList.size() > limit) {
                        newDirList.removeLast();
                    }
                }
                if (!oldDirList.equals(newDirList)) {
                    COConfigurationManager.setParameter("saveTo_list", newDirList);
                    COConfigurationManager.save();
                }
            }
            if (COConfigurationManager.getBooleanParameter("DefaultDir.AutoUpdate")) {
                COConfigurationManager.setParameter(OpenTorrentOptionsWindow.PARAM_DEFSAVEPATH, newSavePath);
            }
            TagManager tagManager = TagManagerFactory.getTagManager();
            TagType tagType = tagManager.getTagType(3);
            List<Tag> initialTags = this.torrentOptions.getInitialTags();
            boolean initialTagsChanged = false;
            ListIterator<Tag> iter = initialTags.listIterator();
            while (iter.hasNext()) {
                Tag tag = iter.next();
                if (!(tag instanceof DiscoveredTag)) continue;
                initialTagsChanged = true;
                iter.remove();
                if (((DiscoveredTag)tag).existingTag != null) continue;
                try {
                    Tag newTag = tagType.createTag(tag.getTagName(), true);
                    newTag.setPublic(true);
                    iter.add(newTag);
                }
                catch (TagException tagException) {
                    // empty catch block
                }
            }
            if (auto) {
                try {
                    String autoTagName = MessageText.getString("tag.auto.accepted");
                    Tag autoTag = tagType.getTag(autoTagName, true);
                    if (autoTag == null) {
                        autoTag = tagType.createTag(autoTagName, true);
                        autoTag.setPublic(false);
                    }
                    if (!initialTags.contains(autoTag)) {
                        initialTags.add(autoTag);
                        initialTagsChanged = true;
                    }
                }
                catch (TagException tagException) {
                    // empty catch block
                }
            }
            if (initialTagsChanged) {
                this.torrentOptions.setInitialTags(initialTags);
            }
            this.torrentOptions.setCancelDisabled(true);
            return true;
        }

        private void dispose() {
            this.tvFiles.delete();
            this.tvFiles = null;
            if (this.tagButtonsUI != null) {
                this.tagButtonsUI.dispose();
                this.tagButtonsUI = null;
            }
            COConfigurationManager.removeParameterListeners(new String[]{"File.Torrent.AutoSkipExtensions", "File.Torrent.AutoSkipFiles", "File.Torrent.AutoSkipFiles.RegExp", "File.Torrent.AutoSkipMinSizeKB", "priorityExtensions", "priorityExtensionsIgnoreCase"}, this);
        }

        private FileStatsCacheItem getCachedDirFreeSpace(File directory) {
            StringInterner.DirKey key = new StringInterner.DirKey(directory);
            FileStatsCacheItem item = this.fileStatCache.get(key);
            if (item == null) {
                item = new FileStatsCacheItem(key, directory);
                this.fileStatCache.put(key, item);
            }
            return item;
        }

        private boolean getCachedExistsStat(File directory) {
            StringInterner.DirKey key = new StringInterner.DirKey(directory);
            FileStatsCacheItem item = this.fileStatCache.get(key);
            if (item == null) {
                item = new FileStatsCacheItem(key, directory);
                this.fileStatCache.put(key, item);
            }
            return item.exists;
        }

        private class FileStatsCacheItem {
            final StringInterner.DirKey dirKey;
            final boolean exists;
            volatile long freeSpace;
            long last_update = SystemTime.getMonotonousTime();
            boolean updating;

            public FileStatsCacheItem(StringInterner.DirKey k, File dir) {
                this.dirKey = k;
                this.exists = dir.exists();
                this.freeSpace = this.exists ? FileUtil.getUsableSpace(dir) : -1L;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void update() {
                long now = SystemTime.getMonotonousTime();
                FileStatsCacheItem fileStatsCacheItem = this;
                synchronized (fileStatsCacheItem) {
                    if (this.updating || now - this.last_update < 3000L) {
                        return;
                    }
                    this.updating = true;
                }
                ((OpenTorrentInstance)OpenTorrentInstance.this).OpenTorrentOptionsWindow.this.spaceUpdateDispatcher.dispatch(() -> {
                    try {
                        File file = this.dirKey.getFile();
                        long space = FileUtil.getUsableSpace(file);
                        long min = 0x100000L;
                        if (space > 0x40000000L) {
                            min *= 10L;
                        }
                        if (Math.abs(space - this.freeSpace) > min) {
                            this.freeSpace = space;
                            OpenTorrentInstance.this.diskFreeInfoRefreshPending = true;
                        }
                    }
                    catch (Throwable throwable) {
                        FileStatsCacheItem fileStatsCacheItem = this;
                        synchronized (fileStatsCacheItem) {
                            this.updating = false;
                            this.last_update = SystemTime.getMonotonousTime();
                        }
                        throw throwable;
                    }
                    FileStatsCacheItem fileStatsCacheItem = this;
                    synchronized (fileStatsCacheItem) {
                        this.updating = false;
                        this.last_update = SystemTime.getMonotonousTime();
                    }
                });
            }
        }

        private final class Partition {
            final FileStatsCacheItem freeSpace;
            final File root;
            long bytesToConsume = 0L;

            public Partition(File root) {
                this.root = root;
                this.freeSpace = OpenTorrentInstance.this.getCachedDirFreeSpace(root);
            }
        }
    }

    public static interface OpenTorrentInstanceListener {
        public void instanceChanged(OpenTorrentInstance var1);
    }

    private static class TreeNode {
        private static TreeNode[] NO_KIDS = new TreeNode[0];
        private final TreeNode parent;
        private String name;
        private Object data = new TreeMap(OpenTorrentOptionsWindow.access$2());
        private long size = Long.MAX_VALUE;

        private TreeNode(TreeNode _parent, String _name) {
            this.parent = _parent;
            this.name = _name;
        }

        private String getName() {
            if (this.data instanceof TorrentOpenFileOptions) {
                return ((TorrentOpenFileOptions)this.data).getDestFileName();
            }
            return this.name;
        }

        private TreeNode getParent() {
            return this.parent;
        }

        private TreeNode getChild(String name) {
            return (TreeNode)((TreeMap)this.data).get(name);
        }

        private void addChild(TreeNode child) {
            ((TreeMap)this.data).put(child.getName(), child);
        }

        private void setFile(TorrentOpenFileOptions file) {
            this.data = file;
        }

        private boolean isChecked() {
            TreeNode[] kids;
            if (this.data instanceof TorrentOpenFileOptions) {
                return ((TorrentOpenFileOptions)this.data).isToDownload();
            }
            TreeNode[] treeNodeArray = kids = this.getChildren();
            int n = kids.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode kid = treeNodeArray[n2];
                if (kid.isChecked()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private boolean isGrayed() {
            if (this.data instanceof TorrentOpenFileOptions) {
                return false;
            }
            TreeNode[] kids = this.getChildren();
            int state = 0;
            TreeNode[] treeNodeArray = kids;
            int n = kids.length;
            int n2 = 0;
            while (n2 < n) {
                int kid_state;
                TreeNode kid = treeNodeArray[n2];
                if (kid.isGrayed()) {
                    return true;
                }
                int n3 = kid_state = kid.isChecked() ? 1 : 2;
                if (state == 0) {
                    state = kid_state;
                } else if (state != kid_state) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private TreeNode[] getChildren() {
            if (this.data instanceof Map) {
                TreeMap map = (TreeMap)this.data;
                this.data = map.values().toArray(new TreeNode[map.size()]);
            }
            if (this.data instanceof TreeNode[]) {
                return (TreeNode[])this.data;
            }
            return NO_KIDS;
        }

        private void sort(Comparator<TreeNode> comparator) {
            TreeNode[] kids = this.getChildren();
            int num_kids = kids.length;
            if (num_kids >= 2) {
                Arrays.sort(kids, comparator);
            }
            int i = 0;
            while (i < num_kids) {
                kids[i].sort(comparator);
                ++i;
            }
        }

        private TorrentOpenFileOptions getFile() {
            if (this.data instanceof TorrentOpenFileOptions) {
                return (TorrentOpenFileOptions)this.data;
            }
            return null;
        }

        private List<TorrentOpenFileOptions> getFiles() {
            ArrayList<TorrentOpenFileOptions> files = new ArrayList<TorrentOpenFileOptions>(1024);
            this.getFiles(files);
            return files;
        }

        private void getFiles(List<TorrentOpenFileOptions> files) {
            if (this.data instanceof TorrentOpenFileOptions) {
                files.add((TorrentOpenFileOptions)this.data);
            } else {
                TreeNode[] kids;
                TreeNode[] treeNodeArray = kids = this.getChildren();
                int n = kids.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeNode kid = treeNodeArray[n2];
                    kid.getFiles(files);
                    ++n2;
                }
            }
        }

        private long getSize() {
            if (this.size != Long.MAX_VALUE) {
                return this.size;
            }
            if (this.data instanceof TorrentOpenFileOptions) {
                this.size = ((TorrentOpenFileOptions)this.data).getSize();
            } else {
                TreeNode[] kids;
                this.size = 0L;
                TreeNode[] treeNodeArray = kids = this.getChildren();
                int n = kids.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeNode kid = treeNodeArray[n2];
                    this.size += Math.abs(kid.getSize());
                    ++n2;
                }
                this.size = -this.size;
            }
            return this.size;
        }
    }
}

