/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.skin;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.ui.IUIIntializer;
import com.biglybt.ui.skin.SkinProperties;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.skin.SWTSkinLayoutCompleteListener;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectBasic;
import com.biglybt.ui.swt.skin.SWTSkinObjectBrowser;
import com.biglybt.ui.swt.skin.SWTSkinObjectButton;
import com.biglybt.ui.swt.skin.SWTSkinObjectCheckbox;
import com.biglybt.ui.swt.skin.SWTSkinObjectCombo;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinObjectExpandBar1;
import com.biglybt.ui.swt.skin.SWTSkinObjectExpandBar2;
import com.biglybt.ui.swt.skin.SWTSkinObjectExpandItem1;
import com.biglybt.ui.swt.skin.SWTSkinObjectExpandItem2;
import com.biglybt.ui.swt.skin.SWTSkinObjectImage;
import com.biglybt.ui.swt.skin.SWTSkinObjectList;
import com.biglybt.ui.swt.skin.SWTSkinObjectListener;
import com.biglybt.ui.swt.skin.SWTSkinObjectSash;
import com.biglybt.ui.swt.skin.SWTSkinObjectSeparator;
import com.biglybt.ui.swt.skin.SWTSkinObjectSlider;
import com.biglybt.ui.swt.skin.SWTSkinObjectTab;
import com.biglybt.ui.swt.skin.SWTSkinObjectTabFolder;
import com.biglybt.ui.swt.skin.SWTSkinObjectText2;
import com.biglybt.ui.swt.skin.SWTSkinObjectTextbox;
import com.biglybt.ui.swt.skin.SWTSkinObjectToggle;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import com.biglybt.ui.swt.skin.SWTSkinPropertiesClone;
import com.biglybt.ui.swt.skin.SWTSkinPropertiesImpl;
import com.biglybt.ui.swt.skin.SWTSkinPropertiesParam;
import com.biglybt.ui.swt.skin.SWTSkinPropertiesParamImpl;
import com.biglybt.ui.swt.skin.SWTSkinTabSet;
import com.biglybt.ui.swt.skin.SWTSkinUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;

public class SWTSkin {
    public static final boolean DEBUG_VISIBILITIES = false;
    private static final SWTSkinObjectListener[] NOLISTENERS = new SWTSkinObjectListener[0];
    private static SWTSkin default_instance;
    public boolean DEBUGLAYOUT = System.getProperty("debuglayout") != null;
    private Map<SkinProperties, ImageLoader> mapImageLoaders = new ConcurrentHashMap<SkinProperties, ImageLoader>();
    private final SWTSkinProperties skinProperties;
    private final boolean is_default;
    private static Listener handCursorListener;
    private static Cursor handCursor;
    private HashMap<String, SWTSkinObject[]> mapIDsToSOs = new HashMap();
    private AEMonitor mon_MapIDsToSOs = new AEMonitor("mapIDsToControls");
    private HashMap<String, SWTSkinTabSet> mapTabSetToControls = new HashMap();
    private HashMap<String, SWTSkinObject[]> mapPublicViewIDsToSOs = new HashMap();
    private AEMonitor mon_mapPublicViewIDsToSOs = new AEMonitor("mapPVIDsToSOs");
    private HashMap<String, ArrayList<SWTSkinObjectListener>> mapPublicViewIDsToListeners = new HashMap();
    private AEMonitor mapPublicViewIDsToListeners_mon = new AEMonitor("mapPVIDsToListeners");
    private ArrayList<SWTSkinObjectBasic> ontopImages = new ArrayList();
    private Composite skinComposite;
    private boolean bLayoutComplete = false;
    private CopyOnWriteList<SWTSkinLayoutCompleteListener> listenersLayoutComplete = new CopyOnWriteList();
    private int currentSkinObjectcreationCount = 0;
    private String startID;
    private boolean autoSizeOnLayout = true;
    private boolean autoSizeOnLayoutForce = false;
    private int constructionDepth;
    private Cursor constructionCursor;

    protected static synchronized SWTSkin getDefaultInstance() {
        if (default_instance == null) {
            default_instance = new SWTSkin();
        }
        return default_instance;
    }

    protected SWTSkin() {
        this(new SWTSkinPropertiesImpl(), true);
    }

    protected SWTSkin(ClassLoader classLoader, String skinPath, String mainSkinFile) {
        this(new SWTSkinPropertiesImpl(classLoader, skinPath, mainSkinFile), false);
    }

    private SWTSkin(SWTSkinProperties skinProperties, boolean is_default) {
        this.skinProperties = skinProperties;
        this.is_default = is_default;
        if (is_default) {
            ImageLoader imageLoader = ImageLoader.getInstance();
            imageLoader.addSkinProperties(skinProperties);
        }
    }

    public String getSkinID() {
        return this.skinProperties.getSkinID();
    }

    public ImageLoader getImageLoader(SkinProperties properties) {
        if (this.is_default) {
            return ImageLoader.getInstance();
        }
        ImageLoader loader = this.mapImageLoaders.get(properties);
        if (loader != null) {
            return loader;
        }
        loader = new ImageLoader(Display.getDefault(), properties);
        this.mapImageLoaders.put(properties, loader);
        return loader;
    }

    public void addToControlMap(SWTSkinObject skinObject) {
        String sID = skinObject.getSkinObjectID();
        if (this.DEBUGLAYOUT) {
            System.out.println("addToControlMap: " + sID + " : " + skinObject);
        }
        this.addToSOArrayMap(this.mapIDsToSOs, this.mon_MapIDsToSOs, sID, skinObject);
        Control control = skinObject.getControl();
        if (control != null) {
            control.setData("ConfigID", (Object)skinObject.getConfigID());
            control.setData("SkinID", (Object)sID);
        }
    }

    private void addToSOArrayMap(Map<String, SWTSkinObject[]> arrayMap, AEMonitor mon, String key, SWTSkinObject object) {
        if (mon != null) {
            mon.enter();
        }
        try {
            SWTSkinObject[] existingObjects = arrayMap.get(key);
            if (existingObjects != null) {
                boolean bAlreadyPresent = false;
                int i = 0;
                while (i < existingObjects.length) {
                    if (existingObjects[i] != null && existingObjects[i].equals(object)) {
                        bAlreadyPresent = true;
                        System.err.println("already present: " + key + "; " + object + "; existing: " + existingObjects[i] + " via " + Debug.getCompressedStackTrace());
                        break;
                    }
                    ++i;
                }
                if (!bAlreadyPresent) {
                    int length = existingObjects.length;
                    SWTSkinObject[] newObjects = new SWTSkinObject[length + 1];
                    System.arraycopy(existingObjects, 0, newObjects, 0, length);
                    newObjects[length] = object;
                    arrayMap.put(key, newObjects);
                }
            } else {
                arrayMap.put(key, new SWTSkinObject[]{object});
            }
        }
        finally {
            if (mon != null) {
                mon.exit();
            }
        }
    }

    private Object getFromSOArrayMap(Map<String, SWTSkinObject[]> arrayMap, Object key, SWTSkinObject parent) {
        if (parent == null) {
            return null;
        }
        SWTSkinObject[] objects = arrayMap.get(key);
        if (objects == null) {
            return null;
        }
        int i = 0;
        while (i < objects.length) {
            SWTSkinObject object;
            SWTSkinObject thisParent = object = objects[i];
            while (thisParent != null) {
                if (thisParent.equals(parent)) {
                    return object;
                }
                thisParent = thisParent.getParent();
            }
            ++i;
        }
        return null;
    }

    private void setSkinObjectViewID(SWTSkinObject skinObject, String sViewID) {
        this.addToSOArrayMap(this.mapPublicViewIDsToSOs, this.mon_mapPublicViewIDsToSOs, sViewID, skinObject);
    }

    public SWTSkinObject getSkinObjectByID(String sID) {
        SWTSkinObject[] objects = this.mapIDsToSOs.get(sID);
        if (objects == null || objects.length == 0) {
            return null;
        }
        return objects[0];
    }

    public SWTSkinObject getSkinObjectByID(String sID, SWTSkinObject parent) {
        if (parent == null) {
            return this.getSkinObjectByID(sID);
        }
        return (SWTSkinObject)this.getFromSOArrayMap(this.mapIDsToSOs, sID, parent);
    }

    public SWTSkinObject getSkinObject(String sViewID) {
        SWTSkinObject[] objects = this.mapPublicViewIDsToSOs.get(sViewID);
        if (objects == null || objects.length == 0) {
            return this.createUnattachedView(sViewID, null);
        }
        return objects[0];
    }

    private SWTSkinObject createUnattachedView(String viewID, SWTSkinObject parent) {
        String unattachedView = this.skinProperties.getStringValue("UnattachedView." + viewID);
        if (unattachedView != null) {
            String[] split;
            String parentID;
            SWTSkinObject soParent;
            if (!Utils.isThisThreadSWT()) {
                Debug.out("View " + viewID + " does not exist.  Skipping unattach check because not in SWT thread");
                return null;
            }
            if (unattachedView.indexOf(44) > 0 && (soParent = this.getSkinObjectByID(parentID = (split = RegExUtil.PAT_SPLIT_COMMA.split(unattachedView))[1], parent)) != null) {
                String configID = split[0];
                return this.createSkinObject(configID, configID, soParent);
            }
            SWTSkinObjectListener[] listeners = this.getSkinObjectListeners(viewID);
            int i = 0;
            while (i < listeners.length) {
                SWTSkinObjectListener l = listeners[i];
                Object o = l.eventOccured(null, 5, new String[]{viewID, unattachedView});
                if (o instanceof SWTSkinObject) {
                    return (SWTSkinObject)o;
                }
                ++i;
            }
        }
        return null;
    }

    public SWTSkinObject getSkinObject(String sViewID, SWTSkinObject parent) {
        if (parent == null) {
            return this.getSkinObject(sViewID);
        }
        String parentViewID = parent.getViewID();
        if (parentViewID != null && parentViewID.equals(sViewID)) {
            return parent;
        }
        SWTSkinObject so = (SWTSkinObject)this.getFromSOArrayMap(this.mapPublicViewIDsToSOs, sViewID, parent);
        if (so == null) {
            so = this.createUnattachedView(sViewID, parent);
        }
        return so;
    }

    public SWTSkinTabSet getTabSet(String sID) {
        return this.mapTabSetToControls.get(sID);
    }

    public SWTSkinObjectTab activateTab(SWTSkinObject skinObjectInTab) {
        if (skinObjectInTab == null) {
            return null;
        }
        if (skinObjectInTab instanceof SWTSkinObjectTab) {
            SWTSkinObjectTab tab = (SWTSkinObjectTab)skinObjectInTab;
            tab.getTabset().setActiveTab(tab);
            return tab;
        }
        for (SWTSkinTabSet tabset : this.mapTabSetToControls.values()) {
            SWTSkinObjectTab[] tabs = tabset.getTabs();
            boolean bHasSkinObject = false;
            int i = 0;
            while (i < tabs.length) {
                SWTSkinObjectTab tab = tabs[i];
                SWTSkinObject[] activeWidgets = tab.getActiveWidgets(true);
                int j = 0;
                while (j < activeWidgets.length) {
                    SWTSkinObject object = activeWidgets[j];
                    if (this.hasSkinObject(object, skinObjectInTab)) {
                        tabset.setActiveTab(tab);
                        return tab;
                    }
                    ++j;
                }
                ++i;
            }
        }
        System.out.println("NOT FOUND" + skinObjectInTab);
        return null;
    }

    private boolean hasSkinObject(SWTSkinObject start, SWTSkinObject skinObject) {
        if (start instanceof SWTSkinObjectContainer) {
            SWTSkinObject[] children = ((SWTSkinObjectContainer)start).getChildren();
            int i = 0;
            while (i < children.length) {
                SWTSkinObject object = children[i];
                if (this.hasSkinObject(object, skinObject)) {
                    return true;
                }
                ++i;
            }
        }
        return skinObject.equals(start);
    }

    public SWTSkinTabSet getTabSet(SWTSkinObject skinObject) {
        String sTabSetID = skinObject.getProperties().getStringValue(String.valueOf(skinObject.getConfigID()) + ".tabset");
        return this.getTabSet(sTabSetID);
    }

    public boolean setActiveTab(String sTabSetID, String sTabViewID) {
        SWTSkinTabSet tabSet = this.getTabSet(sTabSetID);
        if (tabSet == null) {
            System.err.println(sTabSetID);
            return false;
        }
        return tabSet.setActiveTab(sTabViewID);
    }

    public void initialize(Composite skincomp, String startID) {
        this.initialize(skincomp, startID, null);
    }

    public void initialize(Composite skincomp, String startID, IUIIntializer uiInitializer) {
        String[] sMainGroups;
        Color fg;
        this.skinComposite = skincomp;
        this.startID = startID;
        FormLayout layout = new FormLayout();
        this.skinComposite.setLayout((Layout)layout);
        if (Constants.isOSX) {
            this.skinComposite.setBackgroundMode(1);
        }
        this.skinComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTSkin.this.disposeSkin();
            }
        });
        Listener l = new Listener(){
            Control lastControl = null;

            public void handleEvent(Event event2) {
                if (SWTSkin.this.skinComposite.isDisposed() && event2.display != null) {
                    event2.display.removeFilter(5, (Listener)this);
                    event2.display.removeFilter(7, (Listener)this);
                    return;
                }
                Control cursorControl = SWTSkin.this.skinComposite.getDisplay().getCursorControl();
                if (cursorControl != this.lastControl) {
                    Point cursorLocation = SWTSkin.this.skinComposite.getDisplay().getCursorLocation();
                    while (this.lastControl != null && !this.lastControl.isDisposed()) {
                        SWTSkinObjectBasic so;
                        Point cursorLocationInControl = this.lastControl.toControl(cursorLocation);
                        Point size = this.lastControl.getSize();
                        if (!new Rectangle(0, 0, size.x, size.y).contains(cursorLocationInControl) && (so = (SWTSkinObjectBasic)this.lastControl.getData("SkinObject")) != null) {
                            so.switchSuffix("", 3, false, false);
                        }
                        this.lastControl = this.lastControl.getParent();
                    }
                    this.lastControl = cursorControl;
                    while (cursorControl != null) {
                        SWTSkinObjectBasic so = (SWTSkinObjectBasic)cursorControl.getData("SkinObject");
                        if (so != null) {
                            so.switchSuffix("-over", 3, false, false);
                        }
                        cursorControl = cursorControl.getParent();
                    }
                }
            }
        };
        Display display = this.skinComposite.getDisplay();
        display.addFilter(5, l);
        display.addFilter(7, l);
        this.skinComposite.addListener(27, l);
        this.skinComposite.addListener(26, l);
        Color bg = this.skinProperties.getColor(String.valueOf(startID) + ".color");
        if (bg != null) {
            this.skinComposite.setBackground(bg);
        }
        if ((fg = this.skinProperties.getColor(String.valueOf(startID) + ".fgcolor")) != null) {
            this.skinComposite.setForeground(fg);
        }
        int width = this.skinProperties.getPxValue(String.valueOf(startID) + ".width", -1);
        int height = this.skinProperties.getPxValue(String.valueOf(startID) + ".height", -1);
        if (width > 0 && height > 0) {
            this.skinComposite.setSize(width, height);
        }
        if (this.skinComposite instanceof Shell) {
            String title;
            Shell shell = (Shell)this.skinComposite;
            int minWidth = this.skinProperties.getPxValue(String.valueOf(startID) + ".minwidth", -1);
            int minHeight = this.skinProperties.getPxValue(String.valueOf(startID) + ".minheight", -1);
            if (minWidth > 0 || minHeight > 0) {
                Point minimumSize = shell.getMinimumSize();
                shell.setMinimumSize(minWidth > 0 ? minWidth : minimumSize.x, minHeight > 0 ? minHeight : minimumSize.y);
            }
            if ((title = this.skinProperties.getStringValue(String.valueOf(startID) + ".title", (String)null)) != null) {
                ((Shell)this.skinComposite).setText(title);
            }
        }
        if ((sMainGroups = this.skinProperties.getStringArray(String.valueOf(startID) + ".widgets")) == null) {
            System.out.println("NO " + startID + ".widgets!!");
            sMainGroups = new String[]{};
        }
        int i = 0;
        while (i < sMainGroups.length) {
            String sID = sMainGroups[i];
            if (this.DEBUGLAYOUT) {
                System.out.println("Container: " + sID);
            }
            if (uiInitializer != null) {
                uiInitializer.increaseProgress();
            }
            this.linkIDtoParent(this.skinProperties, sID, sID, null, false, true, null);
            ++i;
        }
    }

    private void disposeSkin() {
        ImageLoader imageLoaderInstance = ImageLoader.getInstance();
        for (ImageLoader loader : this.mapImageLoaders.values()) {
            if (loader == imageLoaderInstance) {
                loader.unLoadImages();
                continue;
            }
            loader.dispose();
        }
        this.mapImageLoaders.clear();
    }

    public void layout(SWTSkinObject soStart) {
        if (soStart instanceof SWTSkinObjectContainer) {
            SWTSkinObject[] children;
            SWTSkinObjectContainer soContainer = (SWTSkinObjectContainer)soStart;
            SWTSkinObject[] sWTSkinObjectArray = children = soContainer.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                SWTSkinObject so = sWTSkinObjectArray[n2];
                this.layout(so);
                ++n2;
            }
        }
        if (this.DEBUGLAYOUT) {
            System.out.println("attachControl " + soStart.toString());
        }
        this.attachControl(soStart);
    }

    public void layout() {
        if (this.DEBUGLAYOUT) {
            System.out.println("==== Start Apply Layout");
        }
        Object[] values = this.mapIDsToSOs.values().toArray();
        int i = 0;
        while (i < values.length) {
            SWTSkinObject[] skinObjects = (SWTSkinObject[])values[i];
            if (skinObjects != null) {
                int j = 0;
                while (j < skinObjects.length) {
                    SWTSkinObject skinObject = skinObjects[j];
                    if (this.DEBUGLAYOUT) {
                        System.out.println("Apply Layout for " + skinObject);
                    }
                    this.attachControl(skinObject);
                    ++j;
                }
            }
            ++i;
        }
        if (this.DEBUGLAYOUT) {
            System.out.println("====  Applied Layout");
        }
        this.bLayoutComplete = true;
        int width = this.skinProperties.getPxValue(String.valueOf(this.startID) + ".width", -1);
        int height = this.skinProperties.getPxValue(String.valueOf(this.startID) + ".height", -1);
        if (this.autoSizeOnLayout) {
            if (width > 0 && height == -1) {
                Point computeSize = this.skinComposite.computeSize(width, -1);
                this.skinComposite.setSize(computeSize);
            } else if (height > 0 && width == -1) {
                Point computeSize = this.skinComposite.computeSize(-1, height);
                this.skinComposite.setSize(computeSize);
            } else if (height > 0 && width > 0) {
                this.skinComposite.setSize(width, height);
            } else if (this.autoSizeOnLayoutForce) {
                Point computeSize = this.skinComposite.computeSize(-1, -1);
                this.skinComposite.setSize(computeSize);
            }
        } else {
            try {
                this.skinComposite.requestLayout();
            }
            catch (Throwable computeSize) {
                // empty catch block
            }
        }
        for (SWTSkinLayoutCompleteListener l : this.listenersLayoutComplete) {
            l.skinLayoutCompleted();
        }
        this.listenersLayoutComplete.clear();
        if (this.DEBUGLAYOUT) {
            System.out.println("==== End Apply Layout");
        }
        this.skinProperties.clearCache();
    }

    void attachControl(SWTSkinObject skinObject) {
        if (skinObject == null) {
            return;
        }
        Control controlToLayout = skinObject.getControl();
        if (controlToLayout == null || controlToLayout.isDisposed()) {
            return;
        }
        if (controlToLayout.getData("skin.layedout") != null) {
            return;
        }
        String sConfigID = skinObject.getConfigID();
        SWTSkinProperties properties = skinObject.getProperties();
        String[] sDirections = new String[]{"top", "bottom", "left", "right"};
        Object data = controlToLayout.getLayoutData();
        if (data != null && !(data instanceof FormData)) {
            return;
        }
        FormData oldFormData = (FormData)controlToLayout.getLayoutData();
        if (oldFormData == null) {
            oldFormData = new FormData();
        }
        FormData newFormData = new FormData(oldFormData.width, oldFormData.height);
        String templateID = properties.getStringValue(String.valueOf(sConfigID) + ".attach.template");
        boolean debugControl = controlToLayout.getData("DEBUG") != null;
        int i = 0;
        while (i < sDirections.length) {
            FormAttachment attachment;
            Control control = null;
            int offset = 0;
            int percent = 0;
            String sAlign = null;
            int align = -1;
            switch (i) {
                case 0: {
                    attachment = oldFormData.top;
                    break;
                }
                case 1: {
                    attachment = oldFormData.bottom;
                    break;
                }
                case 2: {
                    attachment = oldFormData.left;
                    break;
                }
                case 3: {
                    attachment = oldFormData.right;
                    break;
                }
                default: {
                    attachment = null;
                }
            }
            if (attachment != null) {
                control = attachment.control;
                offset = attachment.offset;
                align = attachment.alignment;
                percent = attachment.numerator;
            }
            String suffix = ".attach." + sDirections[i];
            String prefix = sConfigID;
            String[] sParams = properties.getStringArray(String.valueOf(sConfigID) + suffix);
            if (sParams == null && templateID != null) {
                sParams = properties.getStringArray(String.valueOf(templateID) + suffix);
                prefix = templateID;
            }
            if (sParams == null) {
                if (attachment != null) {
                    attachment = control == null ? new FormAttachment(percent, offset) : new FormAttachment(control, offset, align);
                }
            } else if (sParams.length == 0 || sParams.length == 1 && sParams[0].length() == 0) {
                attachment = null;
            } else if (sParams[0].length() > 0 && Character.isDigit(sParams[0].charAt(0))) {
                try {
                    percent = Integer.parseInt(sParams[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (sParams.length > 1) {
                    try {
                        String value = sParams[1];
                        if (value.endsWith("rem")) {
                            float em = Float.parseFloat(value.substring(0, value.length() - 3));
                            offset = (int)((float)properties.getEmHeightPX() * em);
                        } else {
                            offset = Integer.parseInt(value);
                        }
                    }
                    catch (Exception value) {
                        // empty catch block
                    }
                }
                attachment = new FormAttachment(percent, offset);
            } else {
                int iNextPos;
                String sWidget = sParams[0];
                SWTSkinObject configSkinObject = this.getSkinObjectByID(sWidget, skinObject.getParent());
                if (configSkinObject != null) {
                    control = configSkinObject.getControl();
                    iNextPos = 1;
                } else {
                    iNextPos = 0;
                    if (sWidget.length() != 0) {
                        System.err.println("ERROR: Trying to attach " + sDirections[i] + " of widget '" + skinObject + "' to non-existant widget '" + sWidget + "'.  Attachment Parameters: " + properties.getStringValue(String.valueOf(prefix) + suffix));
                    }
                }
                int j = iNextPos;
                while (j < sParams.length) {
                    block53: {
                        if (sParams[j].length() > 0) {
                            char c = sParams[j].charAt(0);
                            if (Character.isDigit(c) || c == '-') {
                                try {
                                    String value = sParams[j];
                                    if (value.endsWith("rem")) {
                                        float em = Float.parseFloat(value.substring(0, value.length() - 3));
                                        offset = (int)((float)properties.getEmHeightPX() * em);
                                        break block53;
                                    }
                                    offset = Integer.parseInt(value);
                                }
                                catch (Exception exception) {}
                            } else {
                                sAlign = sParams[j];
                            }
                        }
                    }
                    ++j;
                }
                if (sAlign != null) {
                    align = SWTSkinUtils.getAlignment(sAlign, align);
                }
                attachment = new FormAttachment(control, offset, align);
            }
            if (debugControl && attachment != null && controlToLayout instanceof Group) {
                Group group = (Group)controlToLayout;
                String sValue = properties.getStringValue(String.valueOf(prefix) + suffix);
                String sText = String.valueOf(group.getText()) + "; " + sDirections[i].substring(0, 1) + "=" + (sValue == null ? "(def)" : sValue);
                if (sText.length() < 20) {
                    group.setText(sText);
                }
                Utils.setTT((Control)group, sText);
            }
            if (this.DEBUGLAYOUT) {
                System.out.println("Attach: " + sConfigID + suffix + ": " + properties.getStringValue(String.valueOf(prefix) + suffix) + "/" + attachment);
            }
            switch (i) {
                case 0: {
                    newFormData.top = attachment;
                    break;
                }
                case 1: {
                    newFormData.bottom = attachment;
                    break;
                }
                case 2: {
                    newFormData.left = attachment;
                    break;
                }
                case 3: {
                    newFormData.right = attachment;
                }
            }
            ++i;
        }
        if (!skinObject.getDefaultVisibility()) {
            if (controlToLayout.getData("oldSize") == null) {
                controlToLayout.setData("oldSize", (Object)new Point(properties.getPxValue(String.valueOf(sConfigID) + ".width", -1), properties.getPxValue(String.valueOf(sConfigID) + ".height", -1)));
            }
            newFormData.width = 0;
            newFormData.height = 0;
        } else {
            int h = properties.getPxValue(String.valueOf(sConfigID) + ".height", -2);
            int w = properties.getPxValue(String.valueOf(sConfigID) + ".width", -2);
            if (h != -2) {
                newFormData.height = h;
            }
            if (w != -2) {
                newFormData.width = w;
            }
        }
        controlToLayout.setLayoutData((Object)newFormData);
        controlToLayout.setData("skin.layedout", (Object)"");
        skinObject.layoutComplete();
    }

    private SWTSkinObject createContainer(SWTSkinProperties properties, String sID, String sConfigID, String[] sTypeParams, SWTSkinObject parentSkinObject, boolean bForceCreate, boolean bPropogate, SWTSkinObject intoSkinObject) {
        SWTSkinObject skinObject;
        String[] sItems = properties.getStringArray(String.valueOf(sConfigID) + ".widgets");
        if (sItems == null && !bForceCreate) {
            return null;
        }
        if (this.DEBUGLAYOUT) {
            System.out.println("createContainer: " + sID + ";" + properties.getStringValue(String.valueOf(sConfigID) + ".widgets") + " on " + parentSkinObject);
        }
        if ((skinObject = this.getSkinObjectByID(sID, parentSkinObject)) == null) {
            if (intoSkinObject == null) {
                skinObject = new SWTSkinObjectContainer(this, properties, sID, sConfigID, sTypeParams, parentSkinObject);
                this.addToControlMap(skinObject);
            } else {
                skinObject = intoSkinObject;
            }
        } else if (!(skinObject instanceof SWTSkinObjectContainer)) {
            return skinObject;
        }
        if (!bPropogate) {
            boolean bl = bPropogate = properties.getIntValue(String.valueOf(sConfigID) + ".propogate", 0) == 1;
        }
        if (!bPropogate && parentSkinObject instanceof SWTSkinObjectContainer) {
            bPropogate = ((SWTSkinObjectContainer)parentSkinObject).getPropogation();
        }
        if (bPropogate) {
            ((SWTSkinObjectContainer)skinObject).setPropogation(true);
        }
        if (sItems != null) {
            this.addContainerChildren(skinObject, sItems, properties);
        }
        return skinObject;
    }

    private void addContainerChildren(SWTSkinObject skinObject, String[] sItems, SWTSkinProperties properties) {
        String[] paramValues = null;
        if (properties instanceof SWTSkinPropertiesParam) {
            paramValues = ((SWTSkinPropertiesParam)properties).getParamValues();
        }
        if (properties instanceof SWTSkinPropertiesClone) {
            properties = ((SWTSkinPropertiesClone)properties).getOriginalProperties();
        }
        if (paramValues != null) {
            properties = new SWTSkinPropertiesParamImpl(properties, paramValues);
        }
        SWTSkinObject[] soChildren = new SWTSkinObject[sItems.length];
        int i = 0;
        while (i < sItems.length) {
            String sItemID = sItems[i];
            soChildren[i] = this.linkIDtoParent(properties, sItemID, sItemID, skinObject, false, true, null);
            ++i;
        }
        if (this.bLayoutComplete) {
            SWTSkinObject[] sWTSkinObjectArray = soChildren;
            int n = soChildren.length;
            int n2 = 0;
            while (n2 < n) {
                SWTSkinObject so = sWTSkinObjectArray[n2];
                if (so != null) {
                    this.attachControl(so);
                }
                ++n2;
            }
        }
    }

    private SWTSkinObject createSash(SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parentSkinObject, boolean bVertical) {
        SWTSkinObjectBasic skinObject;
        int style = bVertical ? 512 : 256;
        String[] sItems = properties.getStringArray(String.valueOf(sConfigID) + ".widgets");
        Composite createOn = parentSkinObject == null ? this.skinComposite : (Composite)parentSkinObject.getControl();
        if (sItems == null) {
            Sash sash = new Sash(createOn, style);
            skinObject = new SWTSkinObjectBasic(this, properties, (Control)sash, sID, sConfigID, "sash", parentSkinObject);
            this.addToControlMap(skinObject);
            sash.setBackground(Colors.getSystemColor((Device)sash.getDisplay(), 3));
            sash.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Sash sash = (Sash)e.widget;
                    boolean FASTDRAG = true;
                    if (e.detail == 1) {
                        return;
                    }
                    Rectangle parentArea = sash.getParent().getClientArea();
                    FormData formData = (FormData)sash.getLayoutData();
                    formData.left = new FormAttachment(e.x * 100 / parentArea.width);
                    sash.getParent().layout();
                }
            });
        } else {
            SashForm sashForm = new SashForm(createOn, style);
            skinObject = new SWTSkinObjectContainer(this, properties, (Control)sashForm, sID, sConfigID, "sash", parentSkinObject);
            this.addToControlMap(skinObject);
            int iSashWidth = properties.getIntValue(String.valueOf(sConfigID) + ".sash.width", -1);
            if (iSashWidth > 0) {
                sashForm.SASH_WIDTH = iSashWidth;
            }
            int i = 0;
            while (i < sItems.length) {
                String sChildID = sItems[i];
                this.linkIDtoParent(properties, sChildID, sChildID, skinObject, false, true, null);
                ++i;
            }
        }
        return skinObject;
    }

    private SWTSkinObject createMySash(SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parentSkinObject, boolean bVertical) {
        SWTSkinObjectSash skinObject = new SWTSkinObjectSash(this, properties, sID, sConfigID, typeParams, parentSkinObject, bVertical);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    public SWTSkinObjectTab createTab(String sID, String sTemplateKey, SWTSkinObject tabHolder) {
        String sTemplateID = SWTSkinTabSet.getTemplateID(this, tabHolder, sTemplateKey);
        if (sTemplateID == null) {
            return null;
        }
        SWTSkinObject skinObject = this.linkIDtoParent(this.skinProperties, sID, sTemplateID, tabHolder, true, true, null);
        if (this.bLayoutComplete && skinObject != null) {
            ((Composite)skinObject.getControl()).getParent().layout(true);
        }
        if (skinObject instanceof SWTSkinObjectTab) {
            return (SWTSkinObjectTab)skinObject;
        }
        System.err.println(skinObject + " not a SWTSkinObjectTab! Template: " + sTemplateID);
        return null;
    }

    private SWTSkinObjectTab _createTab(SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parentSkinObject) {
        SWTSkinObjectTab skinObjectTab = new SWTSkinObjectTab(this, properties, sID, sConfigID, parentSkinObject);
        this.createContainer(properties, sID, sConfigID, null, parentSkinObject, true, true, skinObjectTab);
        this.addToControlMap(skinObjectTab);
        String sTabSet = properties.getStringValue(String.valueOf(sConfigID) + ".tabset", "default");
        SWTSkinTabSet tabset = this.mapTabSetToControls.get(sTabSet);
        if (tabset == null) {
            tabset = new SWTSkinTabSet(this, sTabSet);
            this.mapTabSetToControls.put(sTabSet, tabset);
            if (this.DEBUGLAYOUT) {
                System.out.println("New TabSet: " + sTabSet);
            }
        }
        tabset.addTab(skinObjectTab);
        if (this.DEBUGLAYOUT) {
            System.out.println("Tab " + sID + " added");
        }
        return skinObjectTab;
    }

    private SWTSkinObject createTextLabel(SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parentSkinObject) {
        if (this.DEBUGLAYOUT) {
            System.out.println("createTextLabel: " + sID + " on " + parentSkinObject);
        }
        SWTSkinObjectText2 skinObject = new SWTSkinObjectText2(this, properties, sID, sConfigID, typeParams, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    private SWTSkinObject createSlider(SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObjectSlider skinObject = new SWTSkinObjectSlider(this, properties, sID, sConfigID, typeParams, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    public Composite getShell() {
        return this.skinComposite;
    }

    protected static Listener getHandCursorListener(Display display) {
        if (handCursorListener == null) {
            handCursor = new Cursor((Device)display, 21);
            handCursorListener = new Listener(){

                public void handleEvent(Event event2) {
                    if (event2.type == 6) {
                        ((Control)event2.widget).setCursor(handCursor);
                    }
                    if (event2.type == 7) {
                        ((Control)event2.widget).setCursor(null);
                    }
                }
            };
        }
        return handCursorListener;
    }

    public SWTSkinObject createSkinObject(String sID, String sConfigID, SWTSkinObject parentSkinObject) {
        return this.createSkinObject(sID, sConfigID, parentSkinObject, null);
    }

    public void constructionStart() {
        if (Constants.IS_CVS_VERSION && !Utils.isSWTThread()) {
            Debug.out("Must be SWT thread");
        }
        ++this.constructionDepth;
        if (this.constructionDepth == 1) {
            this.constructionCursor = this.skinComposite.getCursor();
            this.skinComposite.setCursor(this.skinComposite.getDisplay().getSystemCursor(1));
        }
    }

    public void constructionEnd() {
        if (Constants.IS_CVS_VERSION && !Utils.isSWTThread()) {
            Debug.out("Must be SWT thread");
        }
        --this.constructionDepth;
        if (this.constructionDepth == 0) {
            this.skinComposite.setCursor(this.constructionCursor);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SWTSkinObject createSkinObject(String sID, String sConfigID, SWTSkinObject parentSkinObject, Object datasource) {
        SWTSkinObject skinObject = null;
        if (this.constructionDepth == 0) {
            Cursor cursor = this.skinComposite.getCursor();
            try {
                try {
                    this.skinComposite.setCursor(this.skinComposite.getDisplay().getSystemCursor(1));
                    skinObject = this.linkIDtoParent(this.skinProperties, sID, sConfigID, parentSkinObject, true, true, datasource);
                    if (!this.bLayoutComplete) return skinObject;
                    this.layout(skinObject);
                    return skinObject;
                }
                catch (Exception e) {
                    Debug.out("Trying to create " + sID + "." + sConfigID + " on " + parentSkinObject, e);
                    this.skinComposite.setCursor(cursor);
                }
                return skinObject;
            }
            finally {
                this.skinComposite.setCursor(cursor);
            }
        }
        try {
            skinObject = this.linkIDtoParent(this.skinProperties, sID, sConfigID, parentSkinObject, true, true, datasource);
            if (!this.bLayoutComplete) return skinObject;
            this.layout(skinObject);
            return skinObject;
        }
        catch (Exception e) {
            Debug.out("Trying to create " + sID + "." + sConfigID + " on " + parentSkinObject, e);
        }
        return skinObject;
    }

    public void addSkinObject(SWTSkinObject skinObject) {
        String sViewID = skinObject.getViewID();
        if (sViewID != null) {
            this.setSkinObjectViewID(skinObject, sViewID);
        }
        this.attachControl(skinObject);
    }

    public void removeSkinObject(SWTSkinObject skinObject) {
        int x;
        SWTSkinObject[] objects;
        skinObject.triggerListeners(3);
        String id = skinObject.getSkinObjectID();
        this.mon_MapIDsToSOs.enter();
        try {
            objects = this.mapIDsToSOs.get(id);
            if (objects != null) {
                x = 0;
                int i = 0;
                while (i < objects.length) {
                    if (objects[i] != skinObject) {
                        objects[x++] = objects[i];
                    }
                    ++i;
                }
                if (x == 0) {
                    this.mapIDsToSOs.remove(id);
                } else {
                    SWTSkinObject[] newObjects = new SWTSkinObject[x];
                    System.arraycopy(objects, 0, newObjects, 0, x);
                    this.mapIDsToSOs.put(id, newObjects);
                }
            }
        }
        finally {
            this.mon_MapIDsToSOs.exit();
        }
        this.mon_mapPublicViewIDsToSOs.enter();
        try {
            id = skinObject.getViewID();
            objects = this.mapPublicViewIDsToSOs.get(id);
            if (objects != null) {
                x = 0;
                int i = 0;
                while (i < objects.length) {
                    if (objects[i] != skinObject) {
                        objects[x++] = objects[i];
                    }
                    ++i;
                }
                if (x == 0) {
                    this.mapPublicViewIDsToSOs.remove(id);
                } else {
                    SWTSkinObject[] newObjects = new SWTSkinObject[x];
                    System.arraycopy(objects, 0, newObjects, 0, x);
                    this.mapPublicViewIDsToSOs.put(id, newObjects);
                }
            }
        }
        finally {
            this.mon_mapPublicViewIDsToSOs.exit();
        }
        skinObject.dispose();
        if (this.mapIDsToSOs.size() == 0) {
            this.disposeSkin();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SWTSkinObject linkIDtoParent(SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parentSkinObject, boolean bForceCreate, boolean bAddView, Object datasource) {
        SWTSkinObject skinObject;
        block49: {
            block47: {
                String sType;
                String[] sTypeParams;
                block48: {
                    block46: {
                        int userMode;
                        ++this.currentSkinObjectcreationCount;
                        skinObject = null;
                        if (sConfigID == null) {
                            --this.currentSkinObjectcreationCount;
                            return null;
                        }
                        sTypeParams = properties.getStringArray(String.valueOf(sConfigID) + ".type");
                        if (sTypeParams != null && sTypeParams.length > 0) {
                            sType = sTypeParams[0];
                            bForceCreate = true;
                        } else {
                            sType = null;
                            String sImageLoc = properties.getStringValue(sConfigID);
                            if (sImageLoc != null) {
                                sType = "image";
                            } else {
                                String sText = properties.getStringValue(String.valueOf(sConfigID) + ".text");
                                if (sText != null) {
                                    sType = "text";
                                } else {
                                    String sWidgets = properties.getStringValue(String.valueOf(sConfigID) + ".widgets");
                                    if (sWidgets != null || bForceCreate) {
                                        sType = "container";
                                    }
                                }
                            }
                            if (sType == null) {
                                if (this.DEBUGLAYOUT) {
                                    System.err.println("no type defined for " + sConfigID);
                                }
                                --this.currentSkinObjectcreationCount;
                                return null;
                            }
                            sTypeParams = new String[]{sType};
                        }
                        int iMinUserMode = properties.getIntValue(String.valueOf(sConfigID) + ".minUserMode", -1);
                        if (iMinUserMode <= 0 || (userMode = COConfigurationManager.getIntParameter("User Mode")) > iMinUserMode) break block46;
                        --this.currentSkinObjectcreationCount;
                        return null;
                    }
                    if (sType.equals("image")) {
                        skinObject = this.createImageLabel(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                        break block47;
                    }
                    if (sType.equals("image2")) {
                        skinObject = this.createImageLabel2(properties, sID, parentSkinObject);
                        break block47;
                    }
                    if (sType.equals("container2")) {
                        skinObject = this.createContainer2(properties, sID, sConfigID, parentSkinObject, bForceCreate, false, null);
                        break block47;
                    }
                    if (sType.equals("container")) {
                        skinObject = this.createContainer(properties, sID, sConfigID, sTypeParams, parentSkinObject, bForceCreate, false, null);
                        break block47;
                    }
                    if (sType.equals("text")) {
                        skinObject = this.createTextLabel(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                        break block47;
                    }
                    if (sType.equals("tab")) {
                        skinObject = this._createTab(properties, sID, sConfigID, parentSkinObject);
                        break block47;
                    }
                    if (sType.equals("v-sash")) {
                        skinObject = this.createSash(properties, sID, sConfigID, parentSkinObject, true);
                        break block47;
                    }
                    if (sType.equals("h-sash")) {
                        skinObject = this.createSash(properties, sID, sConfigID, parentSkinObject, false);
                        break block47;
                    }
                    if (sType.equals("v-mysash")) {
                        skinObject = this.createMySash(properties, sID, sConfigID, sTypeParams, parentSkinObject, true);
                        break block47;
                    }
                    if (sType.equals("h-mysash")) {
                        skinObject = this.createMySash(properties, sID, sConfigID, sTypeParams, parentSkinObject, false);
                        break block47;
                    }
                    if (sType.equals("clone")) {
                        skinObject = this.createClone(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                        break block47;
                    }
                    if (sType.equals("slider")) {
                        skinObject = this.createSlider(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                        break block47;
                    }
                    if (!sType.equals("hidden")) break block48;
                    --this.currentSkinObjectcreationCount;
                    return null;
                }
                if (sType.equals("browser")) {
                    skinObject = this.createBrowser(properties, sID, sConfigID, parentSkinObject);
                    break block47;
                }
                if (sType.equals("separator")) {
                    skinObject = this.createSeparator(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                    break block47;
                }
                if (sType.equals("button")) {
                    skinObject = this.createButton(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                    break block47;
                }
                if (sType.equals("checkbox")) {
                    skinObject = this.createCheckbox(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                    break block47;
                }
                if (sType.equals("toggle")) {
                    skinObject = this.createToggle(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                    break block47;
                }
                if (sType.equals("textbox")) {
                    skinObject = this.createTextbox(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                    break block47;
                }
                if (sType.equals("combo")) {
                    skinObject = this.createCombo(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                    break block47;
                }
                if (sType.equals("list")) {
                    skinObject = this.createList(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                    break block47;
                }
                if (sType.equals("tabfolder")) {
                    skinObject = this.createTabFolder(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                    break block47;
                }
                if (sType.equals("expandbar")) {
                    skinObject = this.createExpandBar1(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                    break block47;
                }
                if (sType.equals("expanditem")) {
                    skinObject = this.createExpandItem1(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                    break block47;
                }
                if (sType.equals("expandbar2")) {
                    skinObject = this.createExpandBar2(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                    break block47;
                }
                if (!sType.equals("expanditem2")) {
                    System.err.println(String.valueOf(sConfigID) + ": Invalid type of " + sType);
                    --this.currentSkinObjectcreationCount;
                    return null;
                }
                skinObject = this.createExpandItem2(properties, sID, sConfigID, sTypeParams, parentSkinObject);
            }
            try {
                try {
                    String sViewID;
                    if (skinObject == null) break block49;
                    skinObject.setData("CreationParams", datasource);
                    if (datasource != null) {
                        skinObject.triggerListeners(7, datasource);
                    }
                    if (!bAddView || (sViewID = skinObject.getViewID()) == null) break block49;
                    this.setSkinObjectViewID(skinObject, sViewID);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    --this.currentSkinObjectcreationCount;
                }
            }
            catch (Throwable throwable) {
                --this.currentSkinObjectcreationCount;
                throw throwable;
            }
        }
        --this.currentSkinObjectcreationCount;
        if (skinObject != null) {
            skinObject.triggerListeners(4);
        }
        return skinObject;
    }

    private SWTSkinObject createButton(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObjectButton skinObject = new SWTSkinObjectButton(this, properties, id, configID, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    private SWTSkinObject createCheckbox(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObjectCheckbox skinObject = new SWTSkinObjectCheckbox(this, properties, id, configID, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    private SWTSkinObject createToggle(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObjectToggle skinObject = new SWTSkinObjectToggle(this, properties, id, configID, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    private SWTSkinObject createExpandBar1(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        String[] sItems = properties.getStringArray(String.valueOf(configID) + ".widgets");
        if (this.DEBUGLAYOUT) {
            System.out.println("createExpandBar: " + id + ";" + properties.getStringValue(String.valueOf(configID) + ".widgets"));
        }
        SWTSkinObjectExpandBar1 skinObject = new SWTSkinObjectExpandBar1(this, properties, id, configID, parentSkinObject);
        this.addToControlMap(skinObject);
        if (sItems != null) {
            this.addContainerChildren(skinObject, sItems, properties);
        }
        return skinObject;
    }

    private SWTSkinObject createExpandBar2(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        String[] sItems = properties.getStringArray(String.valueOf(configID) + ".widgets");
        if (this.DEBUGLAYOUT) {
            System.out.println("createExpandBar: " + id + ";" + properties.getStringValue(String.valueOf(configID) + ".widgets"));
        }
        SWTSkinObjectExpandBar2 skinObject = new SWTSkinObjectExpandBar2(this, properties, id, configID, parentSkinObject);
        this.addToControlMap(skinObject);
        if (sItems != null) {
            this.addContainerChildren(skinObject, sItems, properties);
        }
        return skinObject;
    }

    private SWTSkinObject createExpandItem1(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        String[] sItems = properties.getStringArray(String.valueOf(configID) + ".widgets");
        if (this.DEBUGLAYOUT) {
            System.out.println("createExpandItem: " + id + ";" + properties.getStringValue(String.valueOf(configID) + ".widgets"));
        }
        SWTSkinObjectExpandItem1 skinObject = new SWTSkinObjectExpandItem1(this, properties, id, configID, parentSkinObject);
        this.addToControlMap(skinObject);
        if (sItems != null) {
            this.addContainerChildren(skinObject, sItems, properties);
        }
        return skinObject;
    }

    private SWTSkinObject createExpandItem2(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        String[] sItems = properties.getStringArray(String.valueOf(configID) + ".widgets");
        if (this.DEBUGLAYOUT) {
            System.out.println("createExpandItem2: " + id + ";" + properties.getStringValue(String.valueOf(configID) + ".widgets"));
        }
        SWTSkinObjectExpandItem2 skinObject = new SWTSkinObjectExpandItem2(this, properties, id, configID, parentSkinObject);
        this.addToControlMap(skinObject);
        if (sItems != null) {
            this.addContainerChildren(skinObject, sItems, properties);
        }
        return skinObject;
    }

    private SWTSkinObject createTextbox(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObjectTextbox skinObject = new SWTSkinObjectTextbox(this, properties, id, configID, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    private SWTSkinObject createCombo(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObjectCombo skinObject = new SWTSkinObjectCombo(this, properties, id, configID, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    private SWTSkinObject createList(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObjectList skinObject = new SWTSkinObjectList(this, properties, id, configID, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    private SWTSkinObject createTabFolder(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObject skinObject;
        String[] sItems = properties.getStringArray(String.valueOf(configID) + ".widgets");
        if (this.DEBUGLAYOUT) {
            System.out.println("createTabFolder: " + id + ";" + properties.getStringValue(String.valueOf(configID) + ".widgets"));
        }
        if ((skinObject = this.getSkinObjectByID(id, parentSkinObject)) == null) {
            skinObject = new SWTSkinObjectTabFolder(this, properties, id, configID, parentSkinObject);
            this.addToControlMap(skinObject);
        } else if (!(skinObject instanceof SWTSkinObjectContainer)) {
            return skinObject;
        }
        if (sItems != null) {
            this.addContainerChildren(skinObject, sItems, properties);
        }
        return skinObject;
    }

    private SWTSkinObject createBrowser(SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parentSkinObject) {
        SWTSkinObjectBrowser skinObject = new SWTSkinObjectBrowser(this, properties, sID, sConfigID, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    private SWTSkinObject createClone(SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parentSkinObject) {
        String[] sCloneParams;
        if (sConfigID.length() == 0) {
            System.err.println("XXXXXXXX " + sID + " has no config ID.." + Debug.getStackTrace(false, false));
        }
        if (typeParams.length > 1) {
            int size = typeParams.length - 1;
            sCloneParams = new String[size];
            System.arraycopy(typeParams, 1, sCloneParams, 0, size);
        } else {
            sCloneParams = properties.getStringArray(String.valueOf(sConfigID) + ".clone");
            if (sCloneParams == null || sCloneParams.length < 1) {
                return null;
            }
        }
        if (properties instanceof SWTSkinPropertiesClone) {
            properties = ((SWTSkinPropertiesClone)properties).getOriginalProperties();
        }
        SWTSkinPropertiesClone cloneProperties = new SWTSkinPropertiesClone(properties, sConfigID, sCloneParams);
        return this.linkIDtoParent(cloneProperties, sID, "", parentSkinObject, false, false, null);
    }

    private SWTSkinObject createImageLabel(SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parentSkinObject) {
        if (typeParams.length > 1) {
            properties.addProperty(String.valueOf(sConfigID) + ".image", typeParams[1]);
        }
        SWTSkinObjectImage skinObject = new SWTSkinObjectImage(this, properties, sID, sConfigID, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    private SWTSkinObject createContainer2(SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parentSkinObject, boolean bForceCreate, boolean bPropogate, SWTSkinObject intoSkinObject) {
        SWTSkinObject skinObject;
        String[] sItems = properties.getStringArray(String.valueOf(sConfigID) + ".widgets");
        if (sItems == null && !bForceCreate) {
            return null;
        }
        if (this.DEBUGLAYOUT) {
            System.out.println("createContainer: " + sID + ";" + properties.getStringValue(String.valueOf(sConfigID) + ".widgets"));
        }
        if ((skinObject = this.getSkinObjectByID(sID, parentSkinObject)) == null) {
            if (intoSkinObject != null) {
                skinObject = intoSkinObject;
            }
        } else if (!(skinObject instanceof SWTSkinObjectContainer)) {
            return skinObject;
        }
        if (!bPropogate) {
            boolean bl = bPropogate = properties.getIntValue(String.valueOf(sConfigID) + ".propogate", 0) == 1;
        }
        if (!bPropogate && parentSkinObject instanceof SWTSkinObjectContainer) {
            bPropogate = ((SWTSkinObjectContainer)parentSkinObject).getPropogation();
        }
        if (bPropogate && skinObject != null) {
            ((SWTSkinObjectContainer)skinObject).setPropogation(true);
        }
        if (sItems != null) {
            String[] paramValues = null;
            if (properties instanceof SWTSkinPropertiesParam) {
                paramValues = ((SWTSkinPropertiesParam)properties).getParamValues();
            }
            if (properties instanceof SWTSkinPropertiesClone) {
                properties = ((SWTSkinPropertiesClone)properties).getOriginalProperties();
            }
            if (paramValues != null) {
                properties = new SWTSkinPropertiesParamImpl(properties, paramValues);
            }
            int i = 0;
            while (i < sItems.length) {
                String sItemID = sItems[i];
                this.linkIDtoParent(properties, sItemID, sItemID, skinObject, false, true, null);
                ++i;
            }
        }
        return skinObject;
    }

    private SWTSkinObject createImageLabel2(SWTSkinProperties properties, final String sConfigID, SWTSkinObject parentSkinObject) {
        Composite createOn = parentSkinObject == null ? this.skinComposite : (Composite)parentSkinObject.getControl();
        Canvas drawable = new Canvas(createOn, 262144);
        drawable.setVisible(false);
        final ImageLoader imageLoader = this.getImageLoader(properties);
        Image image = imageLoader.getImage(sConfigID);
        if (ImageLoader.isRealImage(image)) {
            imageLoader.releaseImage(sConfigID);
            image = imageLoader.getImage(String.valueOf(sConfigID) + ".image");
            drawable.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    imageLoader.releaseImage(String.valueOf(sConfigID) + ".image");
                }
            });
        } else {
            drawable.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    imageLoader.releaseImage(sConfigID);
                }
            });
        }
        drawable.setData("image", (Object)image);
        SWTSkinObjectBasic skinObject = new SWTSkinObjectBasic(this, properties, (Control)drawable, sConfigID, sConfigID, "image", parentSkinObject);
        this.addToControlMap(skinObject);
        this.ontopImages.add(skinObject);
        return skinObject;
    }

    private SWTSkinObject createSeparator(SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObjectSeparator skinObject = new SWTSkinObjectSeparator(this, properties, sID, sConfigID, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    public SWTSkinProperties getSkinProperties() {
        return this.skinProperties;
    }

    public void addListener(String viewID, SWTSkinObjectListener listener) {
        this.mapPublicViewIDsToListeners_mon.enter();
        try {
            ArrayList<SWTSkinObjectListener> list = this.mapPublicViewIDsToListeners.get(viewID);
            if (list != null) {
                list.add(listener);
            } else {
                list = new ArrayList();
                list.add(listener);
                this.mapPublicViewIDsToListeners.put(viewID, list);
            }
        }
        finally {
            this.mapPublicViewIDsToListeners_mon.exit();
        }
    }

    public void removeListener(String viewID, SWTSkinObjectListener listener) {
        this.mapPublicViewIDsToListeners_mon.enter();
        try {
            List list = this.mapPublicViewIDsToListeners.get(viewID);
            if (list != null) {
                list.remove(listener);
            }
        }
        finally {
            this.mapPublicViewIDsToListeners_mon.exit();
        }
    }

    public SWTSkinObjectListener[] getSkinObjectListeners(String viewID) {
        if (viewID == null) {
            return NOLISTENERS;
        }
        this.mapPublicViewIDsToListeners_mon.enter();
        try {
            ArrayList<SWTSkinObjectListener> existing = this.mapPublicViewIDsToListeners.get(viewID);
            if (existing != null) {
                SWTSkinObjectListener[] sWTSkinObjectListenerArray = existing.toArray(NOLISTENERS);
                return sWTSkinObjectListenerArray;
            }
            SWTSkinObjectListener[] sWTSkinObjectListenerArray = NOLISTENERS;
            return sWTSkinObjectListenerArray;
        }
        finally {
            this.mapPublicViewIDsToListeners_mon.exit();
        }
    }

    public boolean isLayoutComplete() {
        return this.bLayoutComplete;
    }

    public void addListener(SWTSkinLayoutCompleteListener l) {
        if (!this.listenersLayoutComplete.contains(l)) {
            this.listenersLayoutComplete.add(l);
        }
    }

    public static void main(String[] args) {
        Date d = new Date();
        long t = d.getTime();
        t -= 99878400000L;
        t -= 21600000L;
        Date then = new Date(t -= 1020000L);
        System.out.println(d + ";" + then);
    }

    public boolean isCreatingSO() {
        return this.currentSkinObjectcreationCount > 0;
    }

    public void triggerLanguageChange() {
        Object[] values = this.mapIDsToSOs.values().toArray();
        int i = 0;
        while (i < values.length) {
            SWTSkinObject[] skinObjects = (SWTSkinObject[])values[i];
            if (skinObjects != null) {
                int j = 0;
                while (j < skinObjects.length) {
                    SWTSkinObject so = skinObjects[j];
                    so.triggerListeners(6);
                    ++j;
                }
            }
            ++i;
        }
    }

    public void setAutoSizeOnLayout(boolean autoSizeOnLayout, boolean force) {
        this.autoSizeOnLayout = autoSizeOnLayout;
        this.autoSizeOnLayoutForce = force;
    }

    public boolean isAutoSizeOnLayout() {
        return this.autoSizeOnLayout;
    }

    public static void disposeDefault() {
        if (default_instance != null) {
            default_instance.disposeSkin();
            default_instance = null;
        }
        if (handCursor != null) {
            handCursor.dispose();
            handCursor = null;
        }
        handCursorListener = null;
    }
}

