/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.skin;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.common.updater.UIUpdater;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.debug.ObfuscateImage;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.skin.SWTBGImagePainter;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinObjectListener;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import com.biglybt.ui.swt.skin.SWTSkinUtils;
import com.biglybt.ui.swt.uiupdater.UIUpdaterSWT;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.views.skin.SkinView;
import com.biglybt.util.StringCompareUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SWTSkinObjectBasic
implements SWTSkinObject,
PaintListener,
ObfuscateImage {
    protected static final int BORDER_ROUNDED = 1;
    protected static final int BORDER_ROUNDED_FILL = 2;
    protected static final int BORDER_GRADIENT = 3;
    protected Control control;
    protected String type;
    protected String sConfigID;
    protected SWTBGImagePainter painter;
    protected SWTSkinProperties properties;
    protected String sID;
    protected SWTSkinObject parent;
    protected SWTSkin skin;
    protected String[] suffixes = null;
    protected ArrayList<SWTSkinObjectListener> listeners = new ArrayList();
    protected AEMonitor listeners_mon = new AEMonitor("SWTSkinObjectBasic::listener");
    private String sViewID;
    private int isVisible = -1;
    protected Color bgColor;
    private Color colorBorder;
    private int[] colorBorderParams = null;
    private int[] colorFillParams;
    private int colorFillType;
    boolean initialized = false;
    boolean paintListenerHooked = false;
    boolean alwaysHookPaintListener = false;
    private Map mapData = Collections.EMPTY_MAP;
    private boolean disposed = false;
    protected boolean debug = false;
    private List<GradientInfo> listGradients = new ArrayList<GradientInfo>();
    private Image bgImage;
    private String tooltipID;
    protected boolean customTooltipID = false;
    private Listener resizeGradientBGListener;
    private SkinView skinView;
    private Object datasource;
    private boolean firstVisibility = true;
    private boolean layoutComplete;
    private ObfuscateImage obfuscatedImageGenerator;

    public SWTSkinObjectBasic(SWTSkin skin, SWTSkinProperties properties, Control control, String sID, String sConfigID, String type, SWTSkinObject parent) {
        this(skin, properties, sID, sConfigID, type, parent);
        this.setControl(control);
    }

    public SWTSkinObjectBasic(SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, String type, SWTSkinObject parent) {
        this.skin = skin;
        this.properties = properties;
        this.sConfigID = sConfigID;
        this.sID = sID;
        this.type = type;
        this.parent = parent;
        this.setViewID(properties.getStringValue(String.valueOf(sConfigID) + ".view"));
        this.setDebug(properties.getBooleanValue(String.valueOf(sConfigID) + ".debug", false));
    }

    public void setControl(Control _control) {
        this.firstVisibility = this.properties.getBooleanValue(String.valueOf(this.sConfigID) + ".visible", true);
        if (!Utils.isThisThreadSWT()) {
            Debug.out("Warning: setControl not called in SWT thread for " + this);
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    SWTSkinObjectBasic.this.setControl(SWTSkinObjectBasic.this.control);
                }
            });
            return;
        }
        this.control = _control;
        this.control.setData("ConfigID", (Object)this.sConfigID);
        this.control.setData("SkinObject", (Object)this);
        SWTSkinUtils.addMouseImageChangeListeners(this.control);
        this.switchSuffix(null, 0, false);
        if (!this.properties.getBooleanValue(String.valueOf(this.sConfigID) + ".visible", true)) {
            this.setVisible(false);
        }
        Listener lShowHide = new Listener(){

            public void handleEvent(final Event event2) {
                final boolean toBeVisible = event2.type == 22;
                Utils.execSWTThreadLater(0, new AERunnable(){

                    @Override
                    public void runSupport() {
                        if ((this).SWTSkinObjectBasic.this.control == null || (this).SWTSkinObjectBasic.this.control.isDisposed()) {
                            SWTSkinObjectBasic.this.setIsVisible(false, true);
                            return;
                        }
                        if (event2.widget == (this).SWTSkinObjectBasic.this.control) {
                            if (toBeVisible == (this).SWTSkinObjectBasic.this.control.isVisible() && SWTSkinObjectBasic.this.isVisible == 1 == toBeVisible) {
                                return;
                            }
                            SWTSkinObjectBasic.this.setIsVisible(toBeVisible, true);
                        } else {
                            SWTSkinObjectBasic.this.setIsVisible((this).SWTSkinObjectBasic.this.control.isVisible(), false);
                        }
                    }
                });
            }
        };
        this.control.addListener(22, lShowHide);
        this.control.addListener(23, lShowHide);
        ArrayList<Composite> parents = new ArrayList<Composite>();
        Composite parentComposite = this.control.getParent();
        while (parentComposite != null && !parentComposite.isDisposed()) {
            parents.add(parentComposite);
            parentComposite.addListener(22, lShowHide);
            parentComposite.addListener(23, lShowHide);
            parentComposite = parentComposite.getParent();
        }
        this.control.addDisposeListener(e -> {
            this.disposed = true;
            for (Composite composite : parents) {
                composite.removeListener(22, lShowHide);
                composite.removeListener(23, lShowHide);
            }
            parents.clear();
            this.skin.removeSkinObject(this);
        });
        this.control.addListener(32, new Listener(){
            String lastID = null;

            public void handleEvent(Event event2) {
                String id = SWTSkinObjectBasic.this.getTooltipID(true);
                if (id == null) {
                    if (this.lastID != null) {
                        Utils.setTT(SWTSkinObjectBasic.this.control, null);
                    }
                } else if (id.startsWith("!") && id.endsWith("!")) {
                    Utils.setTT(SWTSkinObjectBasic.this.control, id.substring(1, id.length() - 1));
                } else {
                    Utils.setTT(SWTSkinObjectBasic.this.control, MessageText.getString(id, null));
                }
                this.lastID = id;
            }
        });
        if (this.parent instanceof SWTSkinObjectContainer) {
            ((SWTSkinObjectContainer)this.parent).childAdded(this);
        }
    }

    private Listener getResizeGradientBGListener() {
        if (this.resizeGradientBGListener != null) {
            return this.resizeGradientBGListener;
        }
        this.resizeGradientBGListener = event2 -> {
            if (Utils.isDisplayDisposed()) {
                return;
            }
            if (this.bgImage != null && !this.bgImage.isDisposed()) {
                this.bgImage.dispose();
            }
            Rectangle bounds = this.control.getBounds();
            if (bounds.height <= 0) {
                return;
            }
            this.bgImage = new Image((Device)this.control.getDisplay(), 5, bounds.height);
            GC gc = new GC((Drawable)this.bgImage);
            try {
                try {
                    gc.setAdvanced(true);
                    gc.setInterpolation(2);
                    gc.setAntialias(1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                GradientInfo lastGradInfo = new GradientInfo(this.bgColor, 0.0);
                for (GradientInfo gradInfo : this.listGradients) {
                    if (gradInfo.startPoint != lastGradInfo.startPoint) {
                        gc.setForeground(lastGradInfo.color);
                        gc.setBackground(gradInfo.color);
                        int y = (int)((double)bounds.height * lastGradInfo.startPoint);
                        int height = (int)((double)bounds.height * gradInfo.startPoint) - y;
                        gc.fillGradientRectangle(0, y, 5, height, true);
                    }
                    lastGradInfo = gradInfo;
                }
                if (lastGradInfo.startPoint < 1.0) {
                    gc.setForeground(lastGradInfo.color);
                    gc.setBackground(lastGradInfo.color);
                    int y = (int)((double)bounds.height * lastGradInfo.startPoint);
                    int height = bounds.height - y;
                    gc.fillGradientRectangle(0, y, 5, height, true);
                }
            }
            finally {
                gc.dispose();
            }
            if (this.painter == null) {
                this.painter = new SWTBGImagePainter(this.control, null, null, this.bgImage, 3);
            } else {
                this.painter.setImage(null, null, this.bgImage);
            }
        };
        return this.resizeGradientBGListener;
    }

    protected boolean setIsVisible(boolean visible, boolean walkup) {
        if ((visible ? 1 : 0) == this.isVisible) {
            return false;
        }
        this.isVisible = visible ? 1 : 0;
        this.switchSuffix(null, 0, false);
        this.triggerListeners(visible ? 0 : 1);
        if (walkup && visible) {
            SWTSkinObject p = this.parent;
            while (p instanceof SWTSkinObjectBasic) {
                ((SWTSkinObjectBasic)p).setIsVisible(visible, false);
                p = ((SWTSkinObjectBasic)p).getParent();
            }
        }
        return true;
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getConfigID() {
        return this.sConfigID;
    }

    @Override
    public String getSkinObjectID() {
        return this.sID;
    }

    @Override
    public SWTSkinObject getParent() {
        return this.parent;
    }

    @Override
    public void setBackground(String sConfigID, String sSuffix) {
        String idRight;
        String idLeft;
        String id;
        ImageLoader imageLoader;
        block14: {
            if (sConfigID == null) {
                return;
            }
            imageLoader = this.skin.getImageLoader(this.properties);
            id = null;
            idLeft = null;
            idRight = null;
            String s = this.properties.getStringValue(String.valueOf(sConfigID) + sSuffix, (String)null);
            if (s != null && s.length() > 0) {
                Image[] images = imageLoader.getImages(String.valueOf(sConfigID) + sSuffix);
                try {
                    if (images.length == 1 && ImageLoader.isRealImage(images[0])) {
                        id = String.valueOf(sConfigID) + sSuffix;
                        idLeft = String.valueOf(id) + "-left";
                        idRight = String.valueOf(id) + "-right";
                        break block14;
                    }
                    if (images.length == 3 && ImageLoader.isRealImage(images[2])) {
                        idLeft = id = String.valueOf(sConfigID) + sSuffix;
                        idRight = id;
                        break block14;
                    }
                    if (images.length == 2 && ImageLoader.isRealImage(images[1])) {
                        idLeft = id = String.valueOf(sConfigID) + sSuffix;
                        idRight = String.valueOf(id) + "-right";
                        break block14;
                    }
                    id = String.valueOf(sConfigID) + sSuffix;
                    return;
                }
                finally {
                    imageLoader.releaseImage(String.valueOf(sConfigID) + sSuffix);
                }
            }
            if (s != null && this.painter != null) {
                this.painter.dispose();
                this.painter = null;
            }
            return;
        }
        if (this.painter == null) {
            String sTileMode = this.properties.getStringValue(String.valueOf(sConfigID) + ".drawmode");
            int tileMode = SWTSkinUtils.getTileMode(sTileMode);
            this.painter = new SWTBGImagePainter(this.control, imageLoader, idLeft, idRight, id, tileMode, false);
        } else {
            this.painter.setImage(imageLoader, idLeft, idRight, id);
        }
        if (Utils.isGTK3 && this.control instanceof Composite) {
            ((Composite)this.control).setBackgroundMode(1);
        }
        if (this.control instanceof Composite) {
            Control[] swtChildren;
            Control[] controlArray = swtChildren = ((Composite)this.control).getChildren();
            int n = swtChildren.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.redraw();
                ++n2;
            }
        }
    }

    public String toString() {
        String s = String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(this.hashCode()) + " {" + this.sID;
        if (!this.sID.equals(this.sConfigID)) {
            s = String.valueOf(s) + "/" + this.sConfigID;
        }
        if (this.sViewID != null) {
            s = String.valueOf(s) + "/v=" + this.sViewID;
        }
        s = String.valueOf(s) + ", " + this.type + "; parent=" + (this.parent == null ? null : String.valueOf(this.parent.getSkinObjectID()) + "}");
        return s;
    }

    @Override
    public SWTSkin getSkin() {
        return this.skin;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SWTSkinObject) {
            SWTSkinObject skinObject = (SWTSkinObject)obj;
            boolean bEquals = skinObject.getSkinObjectID().equals(this.sID);
            if (this.parent != null) {
                return bEquals && this.parent.equals(skinObject.getParent());
            }
            return bEquals;
        }
        return super.equals(obj);
    }

    @Override
    public void setVisible(final boolean visible) {
        if (!this.layoutComplete) {
            this.firstVisibility = visible;
            this.setIsVisible(visible, true);
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectBasic.this.control != null && !SWTSkinObjectBasic.this.control.isDisposed()) {
                    boolean changed = visible != SWTSkinObjectBasic.this.control.isVisible() || (visible ? 1 : 0) != SWTSkinObjectBasic.this.isVisible;
                    Object ld = SWTSkinObjectBasic.this.control.getLayoutData();
                    if (ld instanceof FormData) {
                        FormData fd = (FormData)ld;
                        if (!visible) {
                            if (fd.width > 0 && fd.height > 0) {
                                SWTSkinObjectBasic.this.control.setData("oldSize", (Object)new Point(fd.width, fd.height));
                                changed = true;
                            }
                            fd.width = 0;
                            fd.height = 0;
                        } else {
                            Point oldSizePoint;
                            Object oldSize = SWTSkinObjectBasic.this.control.getData("oldSize");
                            Point point = oldSizePoint = oldSize instanceof Point ? (Point)oldSize : new Point(-1, -1);
                            if (fd.width <= 0) {
                                changed = true;
                                fd.width = oldSizePoint.x;
                            }
                            if (fd.height <= 0) {
                                changed = true;
                                fd.height = oldSizePoint.y;
                            }
                        }
                        if (changed) {
                            SWTSkinObjectBasic.this.control.setLayoutData((Object)fd);
                            SWTSkinObjectBasic.this.control.getParent().layout(true, true);
                        }
                    } else if (ld == null && !visible) {
                        FormData fd = new FormData();
                        fd.width = 0;
                        fd.height = 0;
                        SWTSkinObjectBasic.this.control.setLayoutData((Object)fd);
                    }
                    SWTSkinObjectBasic.this.control.setVisible(visible);
                    SWTSkinObjectBasic.this.setIsVisible(visible, true);
                }
            }
        });
    }

    @Override
    public void setDefaultVisibility() {
        if (this.sConfigID == null) {
            return;
        }
        this.setVisible(this.getDefaultVisibility());
    }

    @Override
    public boolean getDefaultVisibility() {
        return this.firstVisibility;
    }

    @Override
    public boolean isVisible() {
        if (this.control == null || this.control.isDisposed()) {
            return false;
        }
        if (!this.layoutComplete) {
            return this.firstVisibility;
        }
        return this.isVisible == -1 ? this.firstVisibility : this.isVisible == 1;
    }

    @Override
    public String switchSuffix(String suffix) {
        return this.switchSuffix(suffix, 1, false);
    }

    @Override
    public final String switchSuffix(String suffix, int level, boolean walkUp) {
        return this.switchSuffix(suffix, level, walkUp, true);
    }

    @Override
    public String switchSuffix(String newSuffixEntry, int level, boolean walkUp, boolean walkDown) {
        if (walkUp) {
            SWTSkinObject parentSkinObject = this.parent;
            SWTSkinObject skinObject = this;
            while (parentSkinObject instanceof SWTSkinObjectContainer && ((SWTSkinObjectContainer)parentSkinObject).getPropogation()) {
                skinObject = parentSkinObject;
                parentSkinObject = parentSkinObject.getParent();
            }
            if (skinObject != this) {
                skinObject.switchSuffix(newSuffixEntry, level, false);
                return null;
            }
        }
        String old = this.getSuffix();
        if (level > 0) {
            if (this.suffixes == null) {
                old = null;
                this.suffixes = new String[level];
            } else if (this.suffixes.length < level) {
                String[] newSuffixes = new String[level];
                System.arraycopy(this.suffixes, 0, newSuffixes, 0, this.suffixes.length);
                this.suffixes = newSuffixes;
            }
            this.suffixes[level - 1] = newSuffixEntry;
        }
        String fullSuffix = this.getSuffix();
        if (newSuffixEntry != null && (this.sConfigID == null || this.control == null || this.control.isDisposed() || !this.isVisible() || newSuffixEntry != null && fullSuffix.equals(old))) {
            return fullSuffix;
        }
        final String sSuffix = fullSuffix;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                String[] split;
                if (SWTSkinObjectBasic.this.control == null || SWTSkinObjectBasic.this.control.isDisposed()) {
                    return;
                }
                boolean needPaintHook = false;
                if (SWTSkinObjectBasic.this.properties.hasKey(String.valueOf(SWTSkinObjectBasic.this.sConfigID) + ".color" + sSuffix)) {
                    Color color;
                    if (SWTSkinObjectBasic.this.resizeGradientBGListener != null) {
                        SWTSkinObjectBasic.this.control.removeListener(11, SWTSkinObjectBasic.this.resizeGradientBGListener);
                    }
                    SWTSkinObjectBasic.this.bgColor = color = SWTSkinObjectBasic.this.properties.getColor(String.valueOf(SWTSkinObjectBasic.this.sConfigID) + ".color" + sSuffix);
                    String colorStyle = SWTSkinObjectBasic.this.properties.getStringValue(String.valueOf(SWTSkinObjectBasic.this.sConfigID) + ".color.style" + sSuffix);
                    if (colorStyle != null) {
                        split = RegExUtil.PAT_SPLIT_COMMA.split(colorStyle);
                        if (split.length > 2) {
                            try {
                                SWTSkinObjectBasic.this.colorFillParams = new int[]{Integer.parseInt(split[1]), Integer.parseInt(split[2])};
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (split[0].equals("rounded")) {
                            SWTSkinObjectBasic.this.colorFillType = 1;
                            needPaintHook = true;
                        } else if (split[0].equals("rounded-fill")) {
                            SWTSkinObjectBasic.this.colorFillType = 2;
                            needPaintHook = true;
                        } else if (split[0].equals("gradient")) {
                            SWTSkinObjectBasic.this.colorFillType = 3;
                            Display device = Display.getDefault();
                            int i = 1;
                            while (i < split.length) {
                                Color colorStop = ColorCache.getSchemedColor((Device)device, split[i]);
                                double posStop = 1.0;
                                if (i != split.length - 1) {
                                    try {
                                        posStop = Double.parseDouble(split[i + 1]);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                SWTSkinObjectBasic.this.listGradients.add(new GradientInfo(colorStop, posStop));
                                i += 2;
                            }
                            Listener resizeGradientBGListener = SWTSkinObjectBasic.this.getResizeGradientBGListener();
                            SWTSkinObjectBasic.this.control.addListener(11, resizeGradientBGListener);
                            resizeGradientBGListener.handleEvent(null);
                        }
                        SWTSkinObjectBasic.this.control.redraw();
                        SWTSkinObjectBasic.this.control.setBackground(null);
                    } else {
                        SWTSkinObjectBasic.this.control.setBackground(SWTSkinObjectBasic.this.bgColor);
                    }
                    if (color != null && Utils.isGTK3 && SWTSkinObjectBasic.this.control instanceof Composite) {
                        ((Composite)SWTSkinObjectBasic.this.control).setBackgroundMode(1);
                    }
                }
                Color fg = SWTSkinObjectBasic.this.getColor_SuffixWalkback(String.valueOf(SWTSkinObjectBasic.this.sConfigID) + ".fgcolor");
                Utils.setSkinnedForeground(SWTSkinObjectBasic.this.control, fg);
                String sBorderStyle = SWTSkinObjectBasic.this.properties.getStringValue(String.valueOf(SWTSkinObjectBasic.this.sConfigID) + ".border" + sSuffix);
                SWTSkinObjectBasic.this.colorBorder = null;
                SWTSkinObjectBasic.this.colorBorderParams = null;
                if (sBorderStyle != null) {
                    split = RegExUtil.PAT_SPLIT_COMMA.split(sBorderStyle);
                    SWTSkinObjectBasic.this.colorBorder = ColorCache.getSchemedColor((Device)SWTSkinObjectBasic.this.control.getDisplay(), split[0]);
                    needPaintHook |= SWTSkinObjectBasic.this.colorBorder != null;
                    if (split.length > 2) {
                        SWTSkinObjectBasic.this.colorBorderParams = new int[]{Integer.parseInt(split[1]), Integer.parseInt(split[2])};
                    }
                }
                SWTSkinObjectBasic.this.setBackground(String.valueOf(SWTSkinObjectBasic.this.sConfigID) + ".background", sSuffix);
                String sCursor = SWTSkinObjectBasic.this.properties.getStringValue(String.valueOf(SWTSkinObjectBasic.this.sConfigID) + ".cursor");
                if (sCursor != null && sCursor.length() > 0 && sCursor.equalsIgnoreCase("hand")) {
                    Listener handCursorListener = SWTSkin.getHandCursorListener(SWTSkinObjectBasic.this.control.getDisplay());
                    SWTSkinObjectBasic.this.control.removeListener(6, handCursorListener);
                    SWTSkinObjectBasic.this.control.removeListener(7, handCursorListener);
                    SWTSkinObjectBasic.this.control.addListener(6, handCursorListener);
                    SWTSkinObjectBasic.this.control.addListener(7, handCursorListener);
                }
                if (!SWTSkinObjectBasic.this.customTooltipID) {
                    String newToolTipID = SWTSkinObjectBasic.this.properties.getReferenceID(String.valueOf(SWTSkinObjectBasic.this.sConfigID) + ".tooltip" + sSuffix);
                    if (newToolTipID == null && sSuffix.length() > 0) {
                        newToolTipID = SWTSkinObjectBasic.this.properties.getReferenceID(String.valueOf(SWTSkinObjectBasic.this.sConfigID) + ".tooltip");
                    }
                    SWTSkinObjectBasic.this.tooltipID = newToolTipID;
                }
                if (!SWTSkinObjectBasic.this.alwaysHookPaintListener && needPaintHook != SWTSkinObjectBasic.this.paintListenerHooked) {
                    if (needPaintHook) {
                        SWTSkinObjectBasic.this.control.addPaintListener((PaintListener)SWTSkinObjectBasic.this);
                    } else {
                        SWTSkinObjectBasic.this.control.removePaintListener((PaintListener)SWTSkinObjectBasic.this);
                    }
                    SWTSkinObjectBasic.this.paintListenerHooked = needPaintHook;
                }
            }
        });
        return fullSuffix;
    }

    @Override
    public String getSuffix() {
        String suffix = "";
        if (this.suffixes == null) {
            return suffix;
        }
        int i = 0;
        while (i < this.suffixes.length) {
            if (this.suffixes[i] != null) {
                suffix = String.valueOf(suffix) + this.suffixes[i];
            }
            ++i;
        }
        if (suffix.contains("-down-over")) {
            return suffix.replaceAll("-down-over", "-down");
        }
        return suffix;
    }

    @Override
    public SWTSkinProperties getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(SWTSkinProperties skinProperties) {
        this.properties = skinProperties;
    }

    @Override
    public void addListener(final SWTSkinObjectListener listener) {
        int visibleStateAtAdd = this.isVisible;
        this.listeners_mon.enter();
        try {
            if (this.listeners.contains(listener)) {
                System.err.println("Already contains listener " + Debug.getCompressedStackTrace());
                return;
            }
            this.listeners.add(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
        if (this.initialized) {
            listener.eventOccured(this, 4, null);
        }
        if (this.datasource != null) {
            listener.eventOccured(this, 7, this.datasource);
        }
        if (visibleStateAtAdd == 1 && this.initialized) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    if (SWTSkinObjectBasic.this.isVisible != 1) {
                        return;
                    }
                    listener.eventOccured(SWTSkinObjectBasic.this, 0, null);
                }
            });
        }
    }

    @Override
    public void removeListener(SWTSkinObjectListener listener) {
        this.listeners_mon.enter();
        try {
            this.listeners.remove(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public SWTSkinObjectListener[] getListeners() {
        return this.listeners.toArray(new SWTSkinObjectListener[0]);
    }

    @Override
    public void triggerListeners(int eventType) {
        this.triggerListeners(eventType, null);
    }

    @Override
    public void triggerListeners(int eventType, Object params) {
        String initClass;
        if (eventType == 0 || eventType == 1) {
            if (!this.initialized) {
                return;
            }
            if (eventType == 0 && !this.isVisible()) {
                return;
            }
            if (eventType == 1 && this.isVisible()) {
                return;
            }
        } else if (eventType == 4) {
            this.initialized = true;
        } else if (eventType == 7) {
            this.datasource = params;
        } else if (eventType == 3 && this.isVisible == 1) {
            this.triggerListenersRaw(1, null);
        }
        this.triggerListenersRaw(eventType, params);
        if (eventType == 4 && this.isVisible >= 0) {
            this.triggerListeners(this.isVisible() ? 0 : 1);
        }
        if (eventType == 0 && this.skinView == null && (initClass = this.properties.getStringValue(String.valueOf(this.sConfigID) + ".onshow.skinviewclass")) != null) {
            try {
                String[] initClassItems = RegExUtil.PAT_SPLIT_COMMA.split(initClass);
                ClassLoader claLoader = this.getClass().getClassLoader();
                if (initClassItems.length > 1) {
                    try {
                        PluginInterface pi = PluginInitializer.getDefaultInterface().getPluginManager().getPluginInterfaceByID(initClassItems[1]);
                        if (pi != null) {
                            claLoader = pi.getPluginClassLoader();
                        }
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                }
                Class<?> cla = Class.forName(initClassItems[0], true, claLoader);
                this.setSkinView((SkinView)cla.newInstance());
                this.skinView.setMainSkinObject(this);
                this.addListener(this.skinView);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    private void triggerListenersRaw(int eventType, Object params) {
        SWTSkinObjectListener[] listeners;
        SWTSkinObjectListener[] listenersArray = this.getListeners();
        if (listenersArray.length > 0) {
            SWTSkinObjectListener[] sWTSkinObjectListenerArray = listenersArray;
            int n = listenersArray.length;
            int n2 = 0;
            while (n2 < n) {
                SWTSkinObjectListener l = sWTSkinObjectListenerArray[n2];
                try {
                    l.eventOccured(this, eventType, params);
                }
                catch (Exception e) {
                    Debug.out("Skin Event " + SWTSkinObjectListener.NAMES[eventType] + " caused an error for listener added locally", e);
                }
                ++n2;
            }
        }
        if ((listeners = this.skin.getSkinObjectListeners(this.sViewID)).length > 0) {
            int i = 0;
            while (i < listeners.length) {
                try {
                    SWTSkinObjectListener l = listeners[i];
                    l.eventOccured(this, eventType, params);
                }
                catch (Exception e) {
                    Debug.out("Skin Event " + SWTSkinObjectListener.NAMES[eventType] + " caused an error for listener added to skin", e);
                }
                ++i;
            }
        }
    }

    protected void setViewID(String viewID) {
        this.sViewID = viewID;
    }

    @Override
    public String getViewID() {
        return this.sViewID;
    }

    @Override
    public void dispose() {
        Utils.disposeSWTObjects(this.bgImage);
        if (this.disposed) {
            return;
        }
        Utils.disposeSWTObjects(this.control);
        if (this.skinView != null) {
            this.removeListener(this.skinView);
            if (this.skinView instanceof UIUpdatable) {
                UIUpdatable updateable = (UIUpdatable)((Object)this.skinView);
                try {
                    UIUpdater updater = UIUpdaterSWT.getInstance();
                    if (updater != null) {
                        updater.removeUpdater(updateable);
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void setTooltipID(String id) {
        if (this.isDisposed()) {
            return;
        }
        if (StringCompareUtils.equals(id, this.tooltipID)) {
            return;
        }
        this.tooltipID = id;
        this.customTooltipID = true;
    }

    @Override
    public String getTooltipID(boolean walkup) {
        if (this.tooltipID != null || !walkup) {
            return this.tooltipID;
        }
        if (this.parent != null) {
            return this.parent.getTooltipID(true);
        }
        return null;
    }

    public void paintControl(GC gc) {
    }

    public final void paintControl(PaintEvent e) {
        Rectangle bounds;
        if (this.bgColor != null) {
            e.gc.setBackground(this.bgColor);
        }
        this.paintControl(e.gc);
        try {
            e.gc.setAdvanced(true);
            e.gc.setAntialias(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.colorFillType > 0) {
            Rectangle rectangle = bounds = this.control instanceof Composite ? ((Composite)this.control).getClientArea() : this.control.getBounds();
            if (this.colorFillParams != null) {
                if (this.colorFillType == 2) {
                    e.gc.fillRoundRectangle(0, 0, bounds.width - 1, bounds.height - 1, this.colorFillParams[0], this.colorFillParams[1]);
                    e.gc.drawRoundRectangle(0, 0, bounds.width - 1, bounds.height - 1, this.colorFillParams[0], this.colorFillParams[1]);
                } else if (this.colorFillType == 1) {
                    Color oldFG = e.gc.getForeground();
                    e.gc.setForeground(this.bgColor);
                    e.gc.drawRoundRectangle(0, 0, bounds.width - 1, bounds.height - 1, this.colorFillParams[0], this.colorFillParams[1]);
                    e.gc.setForeground(oldFG);
                }
            }
        }
        if (this.colorBorder != null) {
            e.gc.setForeground(this.colorBorder);
            bounds = this.control instanceof Composite ? ((Composite)this.control).getClientArea() : this.control.getBounds();
            --bounds.width;
            --bounds.height;
            if (this.colorBorderParams == null) {
                e.gc.drawRectangle(bounds);
            } else {
                e.gc.drawRoundRectangle(bounds.x, bounds.y, bounds.width, bounds.height, this.colorBorderParams[0], this.colorBorderParams[1]);
            }
        }
    }

    public boolean isAlwaysHookPaintListener() {
        return this.alwaysHookPaintListener;
    }

    public void setAlwaysHookPaintListener(boolean alwaysHookPaintListener) {
        this.alwaysHookPaintListener = alwaysHookPaintListener;
        if (alwaysHookPaintListener && !this.paintListenerHooked) {
            this.control.addPaintListener((PaintListener)this);
            this.paintListenerHooked = true;
        }
    }

    @Override
    public Object getData(String id) {
        return this.mapData.get(id);
    }

    @Override
    public void setData(String id, Object data) {
        if (this.mapData == Collections.EMPTY_MAP) {
            this.mapData = new HashMap(1);
        }
        this.mapData.put(id, data);
    }

    @Override
    public Image obfuscatedImage(Image image) {
        if (!this.isVisible()) {
            return image;
        }
        this.triggerListeners(8, image);
        Point ourOfs = Utils.getLocationRelativeToShell(this.control);
        if (this.obfuscatedImageGenerator == null) {
            if (this.skinView instanceof ObfuscateImage) {
                return ((ObfuscateImage)((Object)this.skinView)).obfuscatedImage(image);
            }
            return image;
        }
        return this.obfuscatedImageGenerator.obfuscatedImage(image);
    }

    @Override
    public void setObfuscatedImageGenerator(ObfuscateImage obfuscatedImageGenerator) {
        this.obfuscatedImageGenerator = obfuscatedImageGenerator;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void relayout() {
        if (!this.disposed) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    if (SWTSkinObjectBasic.this.control.isDisposed()) {
                        return;
                    }
                    SWTSkinObjectBasic.this.control.getShell().layout(new Control[]{SWTSkinObjectBasic.this.control});
                }
            });
        }
    }

    @Override
    public void layoutComplete() {
        if (!this.layoutComplete) {
            this.layoutComplete = true;
            if (this.control != null && !this.control.isDisposed()) {
                this.control.setVisible(this.firstVisibility);
            }
        }
    }

    private Color getColor_SuffixWalkback(String id) {
        int max = this.suffixes == null ? 0 : this.suffixes.length;
        while (max >= 0) {
            String suffix = "";
            int i = 0;
            while (i < max) {
                if (this.suffixes[i] != null) {
                    suffix = String.valueOf(suffix) + this.suffixes[i];
                }
                ++i;
            }
            Color color = this.properties.getColor(String.valueOf(id) + suffix);
            if (color != null) {
                return color;
            }
            --max;
        }
        return null;
    }

    @Override
    public SkinView getSkinView() {
        return this.skinView;
    }

    @Override
    public void setSkinView(SkinView skinView) {
        this.skinView = skinView;
    }

    static class GradientInfo {
        public Color color;
        public double startPoint;

        public GradientInfo(Color c, double d) {
            this.color = c;
            this.startPoint = d;
        }
    }
}

