/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.skin;

import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinObjectExpandBar;
import com.biglybt.ui.swt.skin.SWTSkinObjectExpandItem1;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import com.biglybt.ui.swt.utils.FontUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Listener;

public class SWTSkinObjectExpandBar1
extends SWTSkinObjectContainer
implements SWTSkinObjectExpandBar {
    private ExpandBar expandBar;
    private List<SWTSkinObjectExpandItem1> expandItems = new ArrayList<SWTSkinObjectExpandItem1>();
    private List<SWTSkinObjectExpandItem1> fillHeightItems = new ArrayList<SWTSkinObjectExpandItem1>();

    public SWTSkinObjectExpandBar1(SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parent) {
        super(skin, properties, null, sID, sConfigID, "expandbar", parent);
        this.createExpandBar();
    }

    @Override
    public boolean isNative() {
        return true;
    }

    private void createExpandBar() {
        Composite createOn = this.parent == null ? this.skin.getShell() : (Composite)this.parent.getControl();
        int style = 0;
        if (this.properties.getIntValue(String.valueOf(this.sConfigID) + ".border", 0) == 1) {
            style = 2048;
        }
        this.expandBar = new ExpandBar(createOn, style);
        this.expandBar.setLayout(null);
        this.expandBar.setSpacing(1);
        if (!Utils.isGTK3) {
            if (!Utils.isDarkAppearanceNativeWindows()) {
                this.expandBar.setFont(createOn.getFont());
            }
        } else {
            FontData[] fontData;
            FontData[] fontDataArray = fontData = createOn.getFont().getFontData();
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData fd = fontDataArray[n2];
                fd.setStyle(1);
                float height = FontUtils.getHeight(fontData) * 1.2f;
                FontUtils.setFontDataHeight(fontData, height);
                ++n2;
            }
            final Font font = new Font((Device)createOn.getDisplay(), fontData);
            this.expandBar.setFont(font);
            this.expandBar.setSpacing(3);
            this.expandBar.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Utils.disposeSWTObjects(font);
                }
            });
        }
        this.expandBar.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                SWTSkinObjectExpandBar1.this.handleResize(null);
            }
        });
        this.triggerListeners(4);
        this.setControl((Control)this.expandBar);
    }

    protected void handleResize(ExpandItem itemResizing) {
        SWTSkinObjectExpandItem1 foundItem = null;
        if (itemResizing != null) {
            SWTSkinObjectExpandItem1[] children;
            SWTSkinObjectExpandItem1[] sWTSkinObjectExpandItem1Array = children = this.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                SWTSkinObjectExpandItem1 item = sWTSkinObjectExpandItem1Array[n2];
                if (item.getExpandItem() == itemResizing) {
                    foundItem = item;
                    item.resizeComposite();
                    break;
                }
                ++n2;
            }
        }
        for (SWTSkinObjectExpandItem1 autoItem : this.fillHeightItems) {
            if (autoItem == foundItem) continue;
            autoItem.resizeComposite();
        }
    }

    @Override
    public void relayout() {
        super.relayout();
        this.handleResize(null);
    }

    protected void addExpandItem(SWTSkinObjectExpandItem1 item) {
        this.expandItems.add(item);
        if (item.fillsHeight()) {
            this.fillHeightItems.add(item);
        }
    }

    protected void removeExpandItem(SWTSkinObjectExpandItem1 item) {
        this.expandItems.remove(item);
        this.fillHeightItems.remove(item);
    }

    public SWTSkinObjectExpandItem1[] getChildren() {
        return this.expandItems.toArray(new SWTSkinObjectExpandItem1[0]);
    }

    public ExpandBar getExpandbar() {
        return this.expandBar;
    }
}

