/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.skin;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.SystemTime;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinObjectExpandBar1;
import com.biglybt.ui.swt.skin.SWTSkinObjectExpandItem;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Listener;

public class SWTSkinObjectExpandItem1
extends SWTSkinObjectContainer
implements ExpandListener,
SWTSkinObjectExpandItem {
    private ExpandItem expandItem;
    private boolean expanded;
    private boolean textOverride;
    private Composite composite;
    private boolean fillHeight;

    public SWTSkinObjectExpandItem1(SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parent) {
        super(skin, properties, null, sID, sConfigID, "expanditem", parent);
        this.createExpandItem();
    }

    private void createExpandItem() {
        if (!(this.parent instanceof SWTSkinObjectExpandBar1)) {
            return;
        }
        final SWTSkinObjectExpandBar1 soExpandBar = (SWTSkinObjectExpandBar1)this.parent;
        int style = 0;
        if (this.properties.getIntValue(String.valueOf(this.sConfigID) + ".border", 0) == 1) {
            style = 2048;
        }
        ExpandBar expandBar = soExpandBar.getExpandbar();
        expandBar.addExpandListener((ExpandListener)this);
        this.expandItem = new ExpandItem(expandBar, style);
        String lastExpandStateID = "ui.skin." + this.sConfigID + ".expanded";
        if (COConfigurationManager.hasParameter(lastExpandStateID, true)) {
            boolean lastExpandState = COConfigurationManager.getBooleanParameter(lastExpandStateID, false);
            this.setExpanded(lastExpandState);
        } else if (this.properties.getBooleanValue(String.valueOf(this.sConfigID) + ".expanded", false)) {
            this.setExpanded(true);
        }
        this.composite = this.createComposite(soExpandBar.getComposite());
        this.expandItem.setControl((Control)this.composite);
        this.composite.setLayoutData(null);
        this.composite.setData("skin.layedout", (Object)true);
        soExpandBar.addExpandItem(this);
        this.expandItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                soExpandBar.removeExpandItem(SWTSkinObjectExpandItem1.this);
            }
        });
        this.composite.addListener(11, new Listener(){
            private Map<Rectangle, Long> resize_history = new HashMap<Rectangle, Long>();

            public void handleEvent(Event event2) {
                Rectangle bounds = SWTSkinObjectExpandItem1.this.composite.getBounds();
                long now = SystemTime.getMonotonousTime();
                Long prev = this.resize_history.get(bounds);
                if (prev != null && now - prev < 500L) {
                    return;
                }
                Iterator<Long> it = this.resize_history.values().iterator();
                while (it.hasNext()) {
                    if (now - it.next() < 500L) continue;
                    it.remove();
                }
                this.resize_history.put(bounds, now);
                Utils.execSWTThreadLater(0, new AERunnable(){

                    @Override
                    public void runSupport() {
                        SWTSkinObjectExpandBar1 soExpandBar = (SWTSkinObjectExpandBar1)(this).SWTSkinObjectExpandItem1.this.parent;
                        if (!SWTSkinObjectExpandItem1.this.expandItem.isDisposed()) {
                            soExpandBar.handleResize(SWTSkinObjectExpandItem1.this.expandItem);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void relayout() {
        super.relayout();
        SWTSkinObjectExpandBar1 soExpandBar = (SWTSkinObjectExpandBar1)this.parent;
        soExpandBar.handleResize(this.expandItem);
    }

    protected void resizeComposite() {
        int newHeight;
        SWTSkinObjectExpandBar1 soExpandBar = (SWTSkinObjectExpandBar1)this.parent;
        ExpandBar expandBar = soExpandBar.getExpandbar();
        if (this.composite.isDisposed()) {
            return;
        }
        if (!this.composite.isVisible()) {
            return;
        }
        Rectangle clientArea = expandBar.getClientArea();
        if (this.properties.getBooleanValue(String.valueOf(this.sConfigID) + ".fillheight", false)) {
            ExpandItem[] items = expandBar.getItems();
            int h = expandBar.getSpacing();
            ExpandItem[] expandItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                ExpandItem item = expandItemArray[n2];
                h += expandBar.getSpacing();
                int hh = item.getHeaderHeight();
                int ih = item.getHeight();
                if (hh < 0) {
                    hh += item.getHeight();
                } else if (hh > ih) {
                    hh -= ih;
                }
                h += hh;
                if (this.expandItem != item && item.getExpanded() && item.getControl().isVisible()) {
                    h += item.getHeight();
                }
                ++n2;
            }
            newHeight = clientArea.height - h;
            int min = this.properties.getIntValue(String.valueOf(this.sConfigID) + ".fillheightmin", 0);
            if (min > 0 && newHeight < min) {
                newHeight = min;
            }
        } else {
            newHeight = this.composite.computeSize((int)clientArea.width, (int)-1, (boolean)true).y;
            expandBar.computeSize(-1, -1, true);
        }
        if (this.expandItem.getHeight() != newHeight) {
            this.expandItem.setHeight(newHeight);
        }
    }

    @Override
    public Composite getParentComposite() {
        return this.getExpandItem().getParent().getParent();
    }

    public ExpandItem getExpandItem() {
        return this.expandItem;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    private void setExpandedVariable(boolean expand) {
        this.expanded = expand;
        String lastExpandStateID = "ui.skin." + this.sConfigID + ".expanded";
        COConfigurationManager.setParameter(lastExpandStateID, expand);
    }

    @Override
    public void setExpanded(final boolean expand) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                SWTSkinObjectExpandItem1.this.expandItem.setExpanded(expand);
                SWTSkinObjectExpandItem1.this.setExpandedVariable(expand);
                Utils.execSWTThreadLater(0, new AERunnable(){

                    @Override
                    public void runSupport() {
                        SWTSkinObjectExpandBar1 soExpandBar = (SWTSkinObjectExpandBar1)(this).SWTSkinObjectExpandItem1.this.parent;
                        soExpandBar.handleResize(SWTSkinObjectExpandItem1.this.expandItem);
                    }
                });
            }
        });
    }

    public void itemCollapsed(ExpandEvent e) {
        if (e.item == this.expandItem) {
            this.setExpandedVariable(false);
            Utils.execSWTThreadLater(0, new AERunnable(){

                @Override
                public void runSupport() {
                    SWTSkinObjectExpandBar1 soExpandBar = (SWTSkinObjectExpandBar1)SWTSkinObjectExpandItem1.this.parent;
                    soExpandBar.handleResize(SWTSkinObjectExpandItem1.this.expandItem);
                }
            });
        }
    }

    public void itemExpanded(ExpandEvent e) {
        if (e.item == this.expandItem) {
            this.setExpandedVariable(true);
            Utils.execSWTThreadLater(0, new AERunnable(){

                @Override
                public void runSupport() {
                    SWTSkinObjectExpandBar1 soExpandBar = (SWTSkinObjectExpandBar1)SWTSkinObjectExpandItem1.this.parent;
                    soExpandBar.handleResize(SWTSkinObjectExpandItem1.this.expandItem);
                }
            });
        }
    }

    @Override
    public String switchSuffix(String suffix, int level, boolean walkUp, boolean walkDown) {
        if ((suffix = super.switchSuffix(suffix, level, walkUp, walkDown)) == null) {
            return null;
        }
        String sPrefix = String.valueOf(this.sConfigID) + ".text";
        String text = this.properties.getStringValue(String.valueOf(sPrefix) + suffix);
        if (text != null) {
            this.setText(text, true);
        }
        this.fillHeight = this.properties.getBooleanValue(String.valueOf(this.sConfigID) + ".fillheight", false);
        return suffix;
    }

    @Override
    public void setText(String text) {
        this.setText(text, false);
    }

    @Override
    public void setHeight(int h) {
        this.getExpandItem().setHeight(h);
    }

    private void setText(final String text, boolean auto) {
        if (!auto) {
            this.textOverride = true;
        } else if (this.textOverride) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectExpandItem1.this.expandItem != null && !SWTSkinObjectExpandItem1.this.expandItem.isDisposed()) {
                    if (Constants.isWindows) {
                        SWTSkinObjectExpandItem1.this.expandItem.setText(text.replaceAll("&", "&&"));
                    } else {
                        SWTSkinObjectExpandItem1.this.expandItem.setText(text);
                    }
                }
            }
        });
    }

    public boolean fillsHeight() {
        return this.fillHeight;
    }

    @Override
    public void dispose() {
        SWTSkinObjectExpandBar1 soExpandBar;
        ExpandBar expandbar;
        super.dispose();
        if (this.parent instanceof SWTSkinObjectExpandBar1 && (expandbar = (soExpandBar = (SWTSkinObjectExpandBar1)this.parent).getExpandbar()) != null && !expandbar.isDisposed()) {
            expandbar.removeExpandListener((ExpandListener)this);
        }
    }
}

