/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.skin;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.CompositeMinSize;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinObjectExpandBar2;
import com.biglybt.ui.swt.skin.SWTSkinObjectExpandItem;
import com.biglybt.ui.swt.skin.SWTSkinObjectText;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class SWTSkinObjectExpandItem2
extends SWTSkinObjectContainer
implements SWTSkinObjectExpandItem {
    static Boolean canUseExpanderUnicode = null;
    private SWTSkinObjectExpandBar2 bar;
    private Composite composite;
    private boolean expanded;
    private boolean fillHeight;
    private int bodyHeightCache = -1;

    public SWTSkinObjectExpandItem2(SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parent) {
        super(skin, properties, sID, sConfigID, parent);
        this.type = "expanditem2";
        this.composite = this.getComposite();
        this.bar = (SWTSkinObjectExpandBar2)parent;
        this.fillHeight = properties.getBooleanValue(String.valueOf(sConfigID) + ".fillheight", false);
        this.bar.addItem(this);
        this.addListener((obj, event2, params) -> {
            if (event2 == 4) {
                String lastExpandStateID = "ui.skin." + sConfigID + ".expanded";
                if (COConfigurationManager.hasParameter(lastExpandStateID, true)) {
                    boolean lastExpandState = COConfigurationManager.getBooleanParameter(lastExpandStateID, false);
                    this.setExpanded(lastExpandState);
                } else {
                    this.setExpanded(properties.getBooleanValue(String.valueOf(sConfigID) + ".expanded", false));
                }
                this.getHeader().getControl().addListener(4, ev -> this.setExpanded(!this.getExpanded()));
            }
            return null;
        });
    }

    private SWTSkinObjectContainer getHeaderContainer() {
        SWTSkinObject[] kids = this.getChildren();
        return (SWTSkinObjectContainer)kids[0];
    }

    private SWTSkinObjectText getHeader() {
        return (SWTSkinObjectText)this.getHeaderContainer().getChildren()[0];
    }

    private SWTSkinObjectContainer getBodyContainer() {
        SWTSkinObject[] kids = this.getChildren();
        return (SWTSkinObjectContainer)kids[1];
    }

    private String fixupExpander(String text) {
        String arrowRight = "\u2b9e";
        String arrowDown = "\u2b9f";
        if (canUseExpanderUnicode == null) {
            SWTSkinObjectText header = this.getHeader();
            canUseExpanderUnicode = Utils.canDisplayCharacters(header.getControl().getFont(), arrowRight.charAt(0), arrowDown.charAt(0));
        }
        if (canUseExpanderUnicode.booleanValue()) {
            if (text.startsWith(arrowRight)) {
                text = text.substring(arrowRight.length());
            } else if (text.startsWith(arrowDown)) {
                text = text.substring(arrowDown.length());
            }
            return String.valueOf(this.expanded ? arrowDown : arrowRight) + " " + text.trim();
        }
        return text;
    }

    @Override
    public void setText(String text) {
        text = this.fixupExpander(text);
        SWTSkinObjectText header = this.getHeader();
        header.setText(text);
        header.relayout();
    }

    @Override
    public Composite getParentComposite() {
        return (Composite)this.getParent().getControl();
    }

    @Override
    public void setExpanded(boolean b) {
        this.expanded = b;
        SWTSkinObjectText header = this.getHeader();
        String text = header.getText();
        text = this.fixupExpander(text);
        header.setText(text);
        header.relayout();
        String lastExpandStateID = "ui.skin." + this.sConfigID + ".expanded";
        COConfigurationManager.setParameter(lastExpandStateID, this.expanded);
        this.getBodyContainer().setVisible(b);
        this.bar.handleResize(this);
        this.relayout();
        Utils.relayoutUp(this.getComposite());
    }

    private boolean getExpanded() {
        return this.expanded;
    }

    @Override
    public void setHeight(int height) {
        this.bar.handleResize(this);
        this.relayout();
        Utils.relayoutUp(this.getComposite());
    }

    private void setBodyHeight(int h) {
        ((CompositeMinSize)this.getBodyContainer().getControl()).setMinSize(new Point(-1, h));
    }

    private int getHeaderHeight() {
        return this.getHeaderContainer().getComposite().getClientArea().height;
    }

    private int getBodyHeight() {
        if (!this.expanded) {
            return 0;
        }
        Composite bodyComposite = this.getBodyContainer().getComposite();
        int height = bodyComposite.getBounds().height;
        if (height <= 0 && this.bodyHeightCache > 0) {
            return this.bodyHeightCache;
        }
        return height;
    }

    protected boolean fillsHeight() {
        return this.fillHeight;
    }

    @Override
    public String switchSuffix(String suffix, int level, boolean walkUp, boolean walkDown) {
        if ((suffix = super.switchSuffix(suffix, level, walkUp, walkDown)) == null) {
            return null;
        }
        String sPrefix = String.valueOf(this.sConfigID) + ".text";
        String text = this.properties.getStringValue(String.valueOf(sPrefix) + suffix);
        if (text != null) {
            this.setText(text);
        }
        this.fillHeight = this.properties.getBooleanValue(String.valueOf(this.sConfigID) + ".fillheight", false);
        return suffix;
    }

    protected boolean resizeComposite() {
        if (this.composite.isDisposed() || !this.getExpanded()) {
            return false;
        }
        Rectangle clientArea = this.bar.getComposite().getParent().getClientArea();
        if (this.properties.getBooleanValue(String.valueOf(this.sConfigID) + ".fillheight", false)) {
            SWTSkinObjectExpandItem2[] items = this.bar.getChildren();
            int h = this.bar.getSpacing();
            SWTSkinObjectExpandItem2[] sWTSkinObjectExpandItem2Array = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                SWTSkinObjectExpandItem2 item = sWTSkinObjectExpandItem2Array[n2];
                h += this.bar.getSpacing();
                int hh = item.getHeaderHeight();
                int ih = item.getBodyHeight();
                h += hh;
                if (this != item && item.getExpanded()) {
                    h += ih;
                }
                ++n2;
            }
            int newHeight = clientArea.height - h;
            int min = this.properties.getIntValue(String.valueOf(this.sConfigID) + ".fillheightmin", 0);
            if (min > 0 && newHeight < min) {
                newHeight = min;
            }
            if (this.getBodyHeight() != newHeight) {
                this.setBodyHeight(newHeight);
                return true;
            }
        } else if (this.expanded) {
            Composite bodyComposite = this.getBodyContainer().getComposite();
            int height = bodyComposite.computeSize((int)clientArea.width, (int)-1, (boolean)true).y;
            if (height > 0) {
                this.bodyHeightCache = height;
            }
        }
        return false;
    }
}

