/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.subscriptions;

import com.biglybt.activities.LocalActivityManager;
import com.biglybt.core.category.Category;
import com.biglybt.core.category.CategoryManager;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.metasearch.Engine;
import com.biglybt.core.metasearch.impl.web.WebEngine;
import com.biglybt.core.metasearch.impl.web.rss.RSSEngine;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.SubscriptionException;
import com.biglybt.core.subs.SubscriptionHistory;
import com.biglybt.core.subs.SubscriptionListener;
import com.biglybt.core.subs.SubscriptionManager;
import com.biglybt.core.subs.SubscriptionManagerFactory;
import com.biglybt.core.subs.SubscriptionManagerListener;
import com.biglybt.core.subs.SubscriptionPopularityListener;
import com.biglybt.core.subs.SubscriptionResult;
import com.biglybt.core.subs.SubscriptionScheduler;
import com.biglybt.core.subs.SubscriptionUtils;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagFeatureLimits;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.vuzefile.VuzeFile;
import com.biglybt.core.vuzefile.VuzeFileHandler;
import com.biglybt.pif.PluginConfigListener;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.ui.Graphic;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.UIInstance;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.UIManagerListener;
import com.biglybt.pif.ui.UIPluginView;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.pif.ui.config.HyperlinkParameter;
import com.biglybt.pif.ui.config.IntParameter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterListener;
import com.biglybt.pif.ui.config.StringParameter;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.menus.MenuManager;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnCreationListener;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.pif.ui.tables.TableManager;
import com.biglybt.pif.ui.tables.TableRow;
import com.biglybt.pif.utils.DelayedTask;
import com.biglybt.pif.utils.Utilities;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.utils.FormattersImpl;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.biglybt.ui.mdi.MdiCloseListener;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MdiEntryCreationListener;
import com.biglybt.ui.mdi.MdiEntryCreationListener2;
import com.biglybt.ui.mdi.MdiEntryVitalityImage;
import com.biglybt.ui.mdi.MdiEntryVitalityImageListener;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.PropertiesWindow;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.mdi.MdiEntrySWT;
import com.biglybt.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.biglybt.ui.swt.pif.UISWTGraphic;
import com.biglybt.ui.swt.pif.UISWTInstance;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pif.UISWTViewEventListener;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.subscriptions.SubscriptionListWindow;
import com.biglybt.ui.swt.subscriptions.SubscriptionMDIEntry;
import com.biglybt.ui.swt.subscriptions.SubscriptionView;
import com.biglybt.ui.swt.subscriptions.SubscriptionWizard;
import com.biglybt.ui.swt.subscriptions.SubscriptionsView;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.utils.CategoryUIUtils;
import com.biglybt.ui.swt.views.utils.TagUIUtils;
import com.biglybt.util.MapUtils;
import com.biglybt.util.StringCompareUtils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Widget;

public class SubscriptionManagerUI {
    private static final String CONFIG_SECTION_ID = "Subscriptions";
    public static final Object SUB_ENTRYINFO_KEY = new Object();
    public static final Object SUB_EDIT_MODE_KEY = new Object();
    private static final String ALERT_IMAGE_ID = "image.sidebar.vitality.alert";
    private static final String INFO_IMAGE_ID = "image.sidebar.vitality.info";
    static final String EDIT_MODE_MARKER = "&editMode=1";
    private Graphic icon_rss_big;
    private Graphic icon_rss_small;
    private Graphic icon_rss_all_add_small;
    private Graphic icon_rss_all_add_big;
    private Graphic icon_rss_some_add_small;
    private Graphic icon_rss_some_add_big;
    private final List<Image> icon_list = new ArrayList<Image>();
    private final List<TableColumn> columns = new ArrayList<TableColumn>();
    protected UISWTInstance swt;
    private UIManager ui_manager;
    private PluginInterface default_pi;
    private MdiEntry mdiEntryOverview;
    private boolean sidebar_setup_done;
    private final Map<String, MdiEntry> parent_views = new TreeMap<String, MdiEntry>(new FormattersImpl().getAlphanumericComparator(true));
    private SubscriptionManagerListener subman_listener_quick;
    private SubscriptionManagerListener subman_listener_delayed;
    private TableColumnCreationListener columnCreationSubs;
    private TableColumnCreationListener columnCreationSubsLink;
    private PluginConfigListener pluginConfigListener;
    private BasicPluginConfigModel configModel;

    public SubscriptionManagerUI() {
        this.default_pi = PluginInitializer.getDefaultInterface();
        TableManager table_manager = this.default_pi.getUIManager().getTableManager();
        Utils.getOffOfSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                SubscriptionManagerFactory.getSingleton();
            }
        });
        if (Constants.isCVSVersion()) {
            TableContextMenuItem menu_item_itorrents = table_manager.addContextMenuItem("MyTorrents", "azsubs.contextmenu.lookupassoc");
            TableContextMenuItem menu_item_ctorrents = table_manager.addContextMenuItem("MySeeders", "azsubs.contextmenu.lookupassoc");
            menu_item_itorrents.setStyle(1);
            menu_item_itorrents.setHeaderCategory("Social");
            menu_item_itorrents.setDisposeWithUIDetach("swt");
            menu_item_ctorrents.setStyle(1);
            menu_item_ctorrents.setHeaderCategory("Social");
            menu_item_ctorrents.setDisposeWithUIDetach("swt");
            MenuItemListener listener = new MenuItemListener(){

                @Override
                public void selected(MenuItem menu, Object target) {
                    TableRow[] rows = (TableRow[])target;
                    if (rows.length > 0) {
                        Download download = (Download)rows[0].getDataSource();
                        String[] networks = PluginCoreUtils.unwrap(download).getDownloadState().getListAttribute("networks");
                        new SubscriptionListWindow(UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell(), download.getName(), download.getTorrentHash(), networks, false);
                    }
                }
            };
            menu_item_itorrents.addMultiListener(listener);
            menu_item_ctorrents.addMultiListener(listener);
        }
        this.createSubsColumns(table_manager);
        this.ui_manager = this.default_pi.getUIManager();
        this.ui_manager.addUIListener(new UIManagerListener(){

            @Override
            public void UIAttached(UIInstance instance) {
                if (!(instance instanceof UISWTInstance)) {
                    return;
                }
                SubscriptionManagerUI.this.swt = (UISWTInstance)instance;
                SubscriptionManagerUI.this.uiQuickInit();
                Utilities utilities = SubscriptionManagerUI.this.default_pi.getUtilities();
                DelayedTask dt = utilities.createDelayedTask(new Runnable(){

                    @Override
                    public void run() {
                        Utils.execSWTThread(new AERunnable(){

                            @Override
                            public void runSupport() {
                                SubscriptionManagerUI.this.delayedInit();
                            }
                        });
                    }
                });
                dt.queue();
            }

            @Override
            public void UIDetached(UIInstance instance) {
                if (!(instance instanceof UISWTInstance)) {
                    return;
                }
                SubscriptionManagerUI.this.uiDestroy();
                SubscriptionManagerUI.this.ui_manager.removeUIListener(this);
            }
        });
    }

    void uiQuickInit() {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        this.icon_rss_big = this.icon_rss_small = this.loadGraphic(this.swt, "subscription_icon.png");
        this.icon_rss_all_add_big = this.icon_rss_all_add_small = this.loadGraphic(this.swt, "subscription_icon_inactive.png");
        this.icon_rss_some_add_big = this.icon_rss_some_add_small = this.icon_rss_all_add_small;
        mdi.registerEntry(CONFIG_SECTION_ID, new MdiEntryCreationListener(){

            @Override
            public MdiEntry createMDiEntry(String id) {
                SubscriptionManagerUI.this.setupSideBar(SubscriptionManagerUI.this.swt);
                return SubscriptionManagerUI.this.mdiEntryOverview;
            }
        });
        mdi.registerEntry("Subscription_.*", new MdiEntryCreationListener2(){

            @Override
            public MdiEntry createMDiEntry(MultipleDocumentInterface mdi, String id, Object datasource, Map<?, ?> params) {
                Subscription sub = null;
                if (datasource instanceof Subscription) {
                    sub = (Subscription)datasource;
                } else if (id.length() > 13) {
                    Subscription[] subscriptions;
                    String publicKey = id.substring(13);
                    byte[] decodedPublicKey = ByteFormatter.decodeString(publicKey);
                    SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                    Subscription[] subscriptionArray = subscriptions = subs_man.getSubscriptions();
                    int n = subscriptions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Subscription subscription = subscriptionArray[n2];
                        if (Arrays.equals(subscription.getPublicKey(), decodedPublicKey)) {
                            sub = subscription;
                            break;
                        }
                        ++n2;
                    }
                }
                if (sub != null && sub.isSearchTemplate()) {
                    return null;
                }
                return sub == null ? null : SubscriptionManagerUI.this.createSubscriptionMdiEntry(sub);
            }
        });
        SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
        this.subman_listener_quick = new SubscriptionManagerListener(){

            @Override
            public void subscriptionAdded(Subscription subscription) {
            }

            @Override
            public void subscriptionChanged(Subscription sub, int reason) {
                SubscriptionManagerUI.this.changeSubscription(sub, reason);
            }

            @Override
            public void subscriptionSelected(Subscription sub) {
                SubscriptionManagerUI.this.showSubscriptionMDI(sub);
            }

            @Override
            public void subscriptionRemoved(Subscription subscription) {
                SubscriptionManagerUI.this.removeSubscription(subscription);
            }

            @Override
            public void associationsChanged(byte[] association_hash) {
            }

            @Override
            public void subscriptionRequested(URL url, Map<String, Object> options) {
            }
        };
        subs_man.addListener(this.subman_listener_quick);
    }

    void uiDestroy() {
        for (Image image : this.icon_list) {
            image.dispose();
        }
        this.icon_list.clear();
        SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
        if (subs_man != null) {
            if (this.subman_listener_delayed != null) {
                subs_man.removeListener(this.subman_listener_delayed);
            }
            if (this.subman_listener_quick != null) {
                subs_man.removeListener(this.subman_listener_quick);
            }
        }
        this.subman_listener_quick = null;
        this.subman_listener_delayed = null;
        try {
            TableManager tableManager = PluginInitializer.getDefaultInterface().getUIManager().getTableManager();
            if (this.columnCreationSubs != null) {
                tableManager.unregisterColumn(Download.class, "azsubs.ui.column.subs");
                this.columnCreationSubs = null;
            }
            if (this.columnCreationSubsLink != null) {
                tableManager.unregisterColumn(Download.class, "azsubs.ui.column.subs_link");
                this.columnCreationSubsLink = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.pluginConfigListener != null) {
            this.default_pi.getPluginconfig().removeListener(this.pluginConfigListener);
            this.pluginConfigListener = null;
        }
        if (this.configModel != null) {
            this.configModel.destroy();
            this.configModel = null;
        }
    }

    void delayedInit() {
        Subscription[] subs;
        if (this.swt == null) {
            return;
        }
        SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
        this.subman_listener_delayed = new SubscriptionManagerListener(){

            @Override
            public void subscriptionAdded(Subscription subscription) {
                SubscriptionManagerUI.this.checkSubscriptionForStuff(subscription);
            }

            @Override
            public void subscriptionChanged(Subscription subscription, int reason) {
                SubscriptionManagerUI.this.changeSubscription(subscription, reason);
            }

            @Override
            public void subscriptionSelected(Subscription subscription) {
            }

            @Override
            public void subscriptionRemoved(Subscription subscription) {
            }

            @Override
            public void associationsChanged(byte[] hash) {
                SubscriptionManagerUI.this.refreshColumns();
            }

            @Override
            public void subscriptionRequested(final URL url, final Map<String, Object> options) {
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        new SubscriptionWizard(url, options);
                    }
                });
            }
        };
        subs_man.addListener(this.subman_listener_delayed);
        Subscription[] subscriptionArray = subs = subs_man.getSubscriptions();
        int n = subs.length;
        int n2 = 0;
        while (n2 < n) {
            Subscription sub = subscriptionArray[n2];
            this.checkSubscriptionForStuff(sub);
            ++n2;
        }
        this.createConfigModel();
    }

    private void checkSubscriptionForStuff(Subscription sub) {
        if (sub.isSearchTemplate()) {
            return;
        }
        if (sub.isSubscribed() && sub.getAddType() != 2) {
            return;
        }
        try {
            Map<String, String> chat_args;
            String chat_key;
            int pos;
            String arg;
            String[] bits;
            String chat_protocol;
            String q;
            Map<String, String> args;
            String id;
            RSSEngine re;
            String url_str;
            URL url;
            String prot;
            Engine engine = sub.getEngine();
            if (engine instanceof RSSEngine && (prot = (url = new URL(url_str = (re = (RSSEngine)engine).getSearchUrl(true))).getProtocol()).equals("azplug") && (id = (args = UrlUtils.decodeArgs(q = url.getQuery())).get("id")).equals("azbuddy") && (chat_protocol = (bits = (arg = args.get("arg")).split(":", 2))[0]).startsWith("chat") && (pos = (chat_key = (chat_args = UrlUtils.decodeArgs(bits[1])).get("")).toLowerCase(Locale.US).indexOf("website[pk=")) != -1) {
                HashMap<String, String> cb_data = new HashMap<String, String>();
                cb_data.put("subname", sub.getName());
                cb_data.put("subid", sub.getID());
                LocalActivityManager.addLocalActivity("Website:" + sub.getID(), "rss", MessageText.getString("subs.activity.website.found", new String[]{sub.getName()}), new String[]{MessageText.getString("subscriptions.listwindow.subscribe")}, ActivityCallback.class, cb_data);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void createConfigModel() {
        final SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
        this.configModel = this.ui_manager.createBasicPluginConfigModel("root", CONFIG_SECTION_ID);
        final IntParameter max_results = this.configModel.addIntParameter2("subscriptions.config.maxresults", "subscriptions.config.maxresults", subs_man.getMaxNonDeletedResults());
        final BooleanParameter search_enable = this.configModel.addBooleanParameter2("subscriptions.search.enable", "subscriptions.search.enable", subs_man.isSearchEnabled());
        search_enable.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                subs_man.setSearchEnabled(search_enable.getValue());
            }
        });
        final BooleanParameter download_subs_enable = this.configModel.addBooleanParameter2("subscriptions.dl_subs.enable", "subscriptions.dl_subs.enable", subs_man.isSubsDownloadEnabled());
        download_subs_enable.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                subs_man.setSubsDownloadEnabled(download_subs_enable.getValue());
            }
        });
        final BooleanParameter activate_subs_enable = this.configModel.addBooleanParameter2("subscriptions.activate.on.change.enable", "subscriptions.activate.on.change.enable", subs_man.getActivateSubscriptionOnChange());
        activate_subs_enable.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                subs_man.setActivateSubscriptionOnChange(activate_subs_enable.getValue());
            }
        });
        final BooleanParameter mark_lib_results_read = this.configModel.addBooleanParameter2("subscriptions.mark_results_in_lib.enable", "subscriptions.mark_results_in_lib.enable", subs_man.getMarkResultsInLibraryRead());
        mark_lib_results_read.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                subs_man.setMarkResultsInLibraryRead(mark_lib_results_read.getValue());
            }
        });
        final IntParameter def_check = this.configModel.addIntParameter2("subscriptions.config.def.check", "subscriptions.config.def.check", subs_man.getDefaultCheckFrequencyMins());
        def_check.setMinValue(5);
        def_check.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                subs_man.setDefaultCheckFrequencyMins(def_check.getValue());
            }
        });
        final StringParameter rate_limits = this.configModel.addStringParameter2("subscriptions.config.ratelimits", "subscriptions.config.ratelimits", subs_man.getRateLimits());
        rate_limits.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                subs_man.setRateLimits(rate_limits.getValue());
            }
        });
        final BooleanParameter auto_start = this.configModel.addBooleanParameter2("subscriptions.config.autostartdls", "subscriptions.config.autostartdls", subs_man.getAutoStartDownloads());
        auto_start.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                subs_man.setAutoStartDownloads(auto_start.getValue());
            }
        });
        final IntParameter min_auto_start_size = this.configModel.addIntParameter2("subscriptions.config.autostart.min", "subscriptions.config.autostart.min", subs_man.getAutoStartMinMB());
        final IntParameter max_auto_start_size = this.configModel.addIntParameter2("subscriptions.config.autostart.max", "subscriptions.config.autostart.max", subs_man.getAutoStartMaxMB());
        auto_start.addEnabledOnSelection((Parameter)min_auto_start_size);
        auto_start.addEnabledOnSelection((Parameter)max_auto_start_size);
        final IntParameter mark_as_read_after = this.configModel.addIntParameter2("subscriptions.config.mark.read.after", "subscriptions.config.mark.read.after", subs_man.getAutoDownloadMarkReadAfterDays());
        final BooleanParameter hash_dirs = this.configModel.addBooleanParameter2("subscriptions.config.addhashdirs", "subscriptions.config.addhashdirs", subs_man.getAddHashDirs());
        hash_dirs.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                subs_man.setAddHashDirs(hash_dirs.getValue());
            }
        });
        this.configModel.createGroup("subscriptions.config.auto", auto_start, min_auto_start_size, max_auto_start_size, mark_as_read_after, hash_dirs);
        this.pluginConfigListener = new PluginConfigListener(){

            @Override
            public void configSaved() {
                subs_man.setMaxNonDeletedResults(max_results.getValue());
                subs_man.setAutoStartMinMB(min_auto_start_size.getValue());
                subs_man.setAutoStartMaxMB(max_auto_start_size.getValue());
                subs_man.setAutoDownloadMarkReadAfterDays(mark_as_read_after.getValue());
            }
        };
        this.default_pi.getPluginconfig().addListener(this.pluginConfigListener);
        final BooleanParameter rss_enable = this.configModel.addBooleanParameter2("subscriptions.rss.enable", "subscriptions.rss.enable", subs_man.isRSSPublishEnabled());
        rss_enable.addListener(new ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                subs_man.setRSSPublishEnabled(rss_enable.getValue());
            }
        });
        HyperlinkParameter rss_view = this.configModel.addHyperlinkParameter2("device.rss.view", subs_man.getRSSLink());
        rss_enable.addEnabledOnSelection((Parameter)rss_view);
        this.configModel.createGroup("device.rss.group", rss_enable, rss_view);
    }

    private void createSubsColumns(TableManager table_manager) {
        final TableCellRefreshListener subs_refresh_listener = new TableCellRefreshListener(){

            @Override
            public void refresh(TableCell _cell) {
                TableCellSWT cell = (TableCellSWT)_cell;
                SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                Download dl = (Download)cell.getDataSource();
                if (dl == null) {
                    return;
                }
                Torrent torrent = dl.getTorrent();
                if (torrent != null) {
                    String tooltip;
                    Graphic graphic;
                    Subscription[] subs = subs_man.getKnownSubscriptions(torrent.getHash());
                    int num_subscribed = 0;
                    int num_unsubscribed = 0;
                    int i = 0;
                    while (i < subs.length) {
                        if (subs[i].isSubscribed()) {
                            ++num_subscribed;
                        } else {
                            ++num_unsubscribed;
                        }
                        ++i;
                    }
                    int height = cell.getHeight();
                    int sort_order = 0;
                    if (subs.length == 0) {
                        graphic = null;
                        tooltip = null;
                    } else if (num_subscribed == subs.length) {
                        graphic = height >= 22 ? SubscriptionManagerUI.this.icon_rss_all_add_big : SubscriptionManagerUI.this.icon_rss_all_add_small;
                        tooltip = MessageText.getString("subscript.all.subscribed");
                    } else if (num_subscribed > 0) {
                        graphic = height >= 22 ? SubscriptionManagerUI.this.icon_rss_some_add_big : SubscriptionManagerUI.this.icon_rss_some_add_small;
                        tooltip = MessageText.getString("subscript.some.subscribed");
                        sort_order = 10000;
                    } else {
                        graphic = height >= 22 ? SubscriptionManagerUI.this.icon_rss_big : SubscriptionManagerUI.this.icon_rss_small;
                        tooltip = MessageText.getString("subscript.none.subscribed");
                        sort_order = 1000000;
                    }
                    cell.setMarginHeight(0);
                    cell.setGraphic(graphic);
                    cell.setToolTip(tooltip);
                    cell.setSortValue(sort_order += 1000 * num_unsubscribed + num_subscribed);
                    cell.setCursorID(graphic == null ? 0 : 21);
                } else {
                    cell.setCursorID(0);
                    cell.setSortValue(0L);
                }
                TableColumn tableColumn = cell.getTableColumn();
                if (tableColumn != null && tableColumn.getPreferredWidth() < 32) {
                    cell.getTableColumn().setPreferredWidth(32);
                }
            }
        };
        final TableCellMouseListener subs_mouse_listener = new TableCellMouseListener(){

            @Override
            public void cellMouseTrigger(TableCellMouseEvent event2) {
                SubscriptionManager subs_man;
                Subscription[] subs;
                TableCell cell;
                Download dl;
                Torrent torrent;
                if (event2.eventType == 0 && (torrent = (dl = (Download)(cell = event2.cell).getDataSource()).getTorrent()) != null && (subs = (subs_man = SubscriptionManagerFactory.getSingleton()).getKnownSubscriptions(torrent.getHash())).length > 0) {
                    event2.skipCoreFunctionality = true;
                    new SubscriptionWizard(PluginCoreUtils.unwrap(dl));
                    SubscriptionManagerUI.this.refreshTitles(SubscriptionManagerUI.this.mdiEntryOverview);
                }
            }
        };
        this.columnCreationSubs = new TableColumnCreationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tableColumnCreated(TableColumn result) {
                result.setAlignment(3);
                result.setPosition(-2);
                result.setWidth(32);
                result.setRefreshInterval(-3);
                result.setType(2);
                result.addCellRefreshListener(subs_refresh_listener);
                result.addCellMouseListener(subs_mouse_listener);
                result.setIconReference("image.subscription.column", true);
                List list = SubscriptionManagerUI.this.columns;
                synchronized (list) {
                    SubscriptionManagerUI.this.columns.add(result);
                }
            }
        };
        table_manager.registerColumn(Download.class, "azsubs.ui.column.subs", this.columnCreationSubs);
        final TableCellRefreshListener link_refresh_listener = new TableCellRefreshListener(){

            @Override
            public void refresh(TableCell _cell) {
                TableCellSWT cell = (TableCellSWT)_cell;
                SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                Download dl = (Download)cell.getDataSource();
                if (dl == null) {
                    return;
                }
                String str = "";
                Torrent torrent = dl.getTorrent();
                if (torrent != null) {
                    byte[] hash = torrent.getHash();
                    Subscription[] subs = subs_man.getKnownSubscriptions(hash);
                    int i = 0;
                    while (i < subs.length) {
                        Subscription sub = subs[i];
                        if (sub.hasAssociation(hash)) {
                            str = String.valueOf(str) + (str.length() == 0 ? "" : "; ") + sub.getName();
                        }
                        ++i;
                    }
                }
                cell.setCursorID(str.length() > 0 ? 21 : 0);
                cell.setText(str);
            }
        };
        final TableCellMouseListener link_mouse_listener = new TableCellMouseListener(){

            @Override
            public void cellMouseTrigger(TableCellMouseEvent event2) {
                if (event2.eventType == 0) {
                    TableCell cell = event2.cell;
                    Download dl = (Download)cell.getDataSource();
                    Torrent torrent = dl.getTorrent();
                    SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                    if (torrent != null) {
                        byte[] hash = torrent.getHash();
                        Subscription[] subs = subs_man.getKnownSubscriptions(hash);
                        int i = 0;
                        while (i < subs.length) {
                            Subscription sub = subs[i];
                            if (sub.hasAssociation(hash)) {
                                SubscriptionManagerUI.this.showSubscriptionMDI(sub);
                                break;
                            }
                            ++i;
                        }
                    }
                }
            }
        };
        this.columnCreationSubsLink = new TableColumnCreationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tableColumnCreated(TableColumn result) {
                result.setAlignment(1);
                result.setPosition(-1);
                result.setWidth(85);
                result.setRefreshInterval(-3);
                result.setType(3);
                result.addCellRefreshListener(link_refresh_listener);
                result.addCellMouseListener(link_mouse_listener);
                result.setMinimumRequiredUserMode(1);
                List list = SubscriptionManagerUI.this.columns;
                synchronized (list) {
                    SubscriptionManagerUI.this.columns.add(result);
                }
            }
        };
        table_manager.registerColumn(Download.class, "azsubs.ui.column.subs_link", this.columnCreationSubsLink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupSideBar(UISWTInstance swt_ui) {
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi == null) {
            return;
        }
        if (this.sidebar_setup_done && (this.mdiEntryOverview == null || this.mdiEntryOverview.isEntryDisposed())) {
            this.sidebar_setup_done = false;
        }
        this.mdiEntryOverview = mdi.createEntry(new UISWTViewBuilderCore(CONFIG_SECTION_ID, null, SubscriptionsView.class).setParentEntryID("header.discovery").setPreferredAfterID("~ChatOverview"), false);
        if (this.mdiEntryOverview == null) {
            return;
        }
        this.mdiEntryOverview.setDefaultExpanded(true);
        SubscriptionManagerUI subscriptionManagerUI = this;
        synchronized (subscriptionManagerUI) {
            if (this.sidebar_setup_done) {
                return;
            }
            this.sidebar_setup_done = true;
        }
        this.mdiEntryOverview.setImageLeftID("image.sidebar.subscriptions");
        this.setupHeader(mdi, this.mdiEntryOverview);
        String parentID = "sidebar.Subscriptions";
        MenuManager menu_manager = this.ui_manager.getMenuManager();
        MenuItem mi = menu_manager.addMenuItem(parentID, "menu.update.all.now");
        mi.setDisposeWithUIDetach("swt");
        mi.addListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                Subscription[] subs;
                SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                SubscriptionScheduler sched = subs_man.getScheduler();
                Subscription[] subscriptionArray = subs = subs_man.getSubscriptions(true);
                int n = subs.length;
                int n2 = 0;
                while (n2 < n) {
                    Subscription sub = subscriptionArray[n2];
                    if (!sub.isSearchTemplate()) {
                        try {
                            sched.downloadAsync(sub, false);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                    ++n2;
                }
            }
        });
        mi = menu_manager.addMenuItem(parentID, "Subscription.menu.clearall");
        mi.setDisposeWithUIDetach("swt");
        mi.addListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                Subscription[] subs;
                SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                Subscription[] subscriptionArray = subs = subs_man.getSubscriptions(true);
                int n = subs.length;
                int n2 = 0;
                while (n2 < n) {
                    Subscription sub = subscriptionArray[n2];
                    if (!sub.isSearchTemplate()) {
                        sub.getHistory().markAllResultsRead();
                    }
                    ++n2;
                }
            }
        });
        mi = menu_manager.addMenuItem(parentID, "sep1");
        mi.setDisposeWithUIDetach("swt");
        mi.setStyle(4);
        mi = menu_manager.addMenuItem(parentID, "MainWindow.menu.view.configuration");
        mi.setDisposeWithUIDetach("swt");
        mi.addListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    uif.getMDI().showEntryByID("ConfigView", SubscriptionManagerUI.CONFIG_SECTION_ID);
                }
            }
        });
    }

    private void setupHeader(MultipleDocumentInterface mdi, MdiEntry headerEntry) {
        MdiEntryVitalityImage infoSub;
        MdiEntryVitalityImage warnSub;
        MdiEntryVitalityImage addSub = headerEntry.addVitalityImage("image.sidebar.subs.add");
        if (addSub != null) {
            addSub.setToolTip(MessageText.getString("subscriptions.add.tooltip"));
            addSub.addListener(new MdiEntryVitalityImageListener(){

                @Override
                public void mdiEntryVitalityImage_clicked(int x, int y) {
                    new SubscriptionWizard();
                    SubscriptionManagerUI.this.refreshTitles(SubscriptionManagerUI.this.mdiEntryOverview);
                }
            });
        }
        if ((warnSub = headerEntry.addVitalityImage(ALERT_IMAGE_ID)) != null) {
            warnSub.setVisible(false);
        }
        if ((infoSub = headerEntry.addVitalityImage(INFO_IMAGE_ID)) != null) {
            infoSub.setVisible(false);
        }
        headerEntry.setViewTitleInfo(new ViewTitleInfo(){
            private long last_avail_calc = -1L;
            private int last_avail;

            @Override
            public Object getTitleInfoProperty(int propertyID) {
                String result = null;
                if (propertyID == 0) {
                    boolean expanded = false;
                    SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                    Subscription[] subs = subs_man.getSubscriptions(true);
                    if (expanded) {
                        if (warnSub != null) {
                            warnSub.setVisible(false);
                        }
                    } else {
                        int total = 0;
                        boolean warn = false;
                        String error_str = "";
                        Subscription[] subscriptionArray = subs;
                        int n = subs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Subscription s = subscriptionArray[n2];
                            SubscriptionHistory history = s.getHistory();
                            total += history.getNumUnread();
                            String last_error = history.getLastError();
                            if (last_error != null && last_error.length() > 0) {
                                boolean auth_fail = history.isAuthFail();
                                if (history.getConsecFails() >= 3 || auth_fail) {
                                    warn = true;
                                    if (error_str.length() > 128) {
                                        if (!error_str.endsWith(", ...")) {
                                            error_str = String.valueOf(error_str) + ", ...";
                                        }
                                    } else {
                                        error_str = String.valueOf(error_str) + (error_str.length() == 0 ? "" : ", ") + last_error;
                                    }
                                }
                            }
                            ++n2;
                        }
                        if (warnSub != null) {
                            warnSub.setVisible(warn);
                            warnSub.setToolTip(error_str);
                        }
                        if (total > 0) {
                            result = String.valueOf(total);
                        }
                    }
                    if (infoSub != null) {
                        if (subs.length == 0 && !COConfigurationManager.getBooleanParameter("subscriptions.wizard.shown", false)) {
                            long now = SystemTime.getMonotonousTime();
                            if (this.last_avail_calc == -1L || now - this.last_avail_calc > 60000L) {
                                this.last_avail = subs_man.getKnownSubscriptionCount();
                                this.last_avail_calc = now;
                            }
                            if (this.last_avail > 0) {
                                infoSub.setVisible(true);
                                infoSub.setToolTip(MessageText.getString("subscriptions.info.avail", new String[]{String.valueOf(this.last_avail)}));
                            }
                        } else {
                            infoSub.setVisible(false);
                        }
                    }
                }
                return result;
            }
        });
    }

    protected void changeSubscription(Subscription subs, int reason) {
        this.refreshTitles(this.mdiEntryOverview);
        if (subs.isSubscribed()) {
            String parent;
            String cp;
            SubscriptionMDIEntry data;
            MultipleDocumentInterface mdi;
            if (SubscriptionManagerFactory.getSingleton().getActivateSubscriptionOnChange() && (mdi = UIFunctionsManager.getUIFunctions().getMDI()) != null) {
                mdi.loadEntryByID(this.getKey(subs), true, true, subs);
            }
            if (!((data = (SubscriptionMDIEntry)subs.getUserData(SUB_ENTRYINFO_KEY)) == null || data.isDisposed() || (cp = data.getCurrentParent()) == (parent = subs.getParent()) || cp != null && parent != null && cp.equals(parent))) {
                this.reloadSubscriptionMDI(subs);
            }
        } else {
            this.removeSubscription(subs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MdiEntry createSubscriptionMdiEntry(final Subscription subs) {
        MdiEntrySWT entry;
        MdiEntrySWT[] existing;
        if (!subs.isSubscribed()) {
            return null;
        }
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi == null) {
            return null;
        }
        String parent_name = subs.getParent();
        if (parent_name != null && parent_name.length() == 0) {
            parent_name = null;
        }
        String key = this.getKey(subs);
        String subs_name = subs.getName();
        TreeMap<String, String> name_map = new TreeMap<String, String>(new FormattersImpl().getAlphanumericComparator(true));
        name_map.put(subs_name, key);
        Object object = existing = mdi.getEntries();
        int n = existing.length;
        int n2 = 0;
        while (n2 < n) {
            Object ds;
            MdiEntrySWT e = object[n2];
            String id = e.getViewID();
            if (id.startsWith("Subscription_") && (ds = e.getDataSource()) instanceof Subscription) {
                String sp = ((Subscription)ds).getParent();
                if (sp != null && sp.length() == 0) {
                    sp = null;
                }
                if (sp == parent_name || sp != null && parent_name != null && sp.equals(parent_name)) {
                    name_map.put(e.getTitle(), id);
                }
            }
            ++n2;
        }
        String prev_id = null;
        for (String this_id : name_map.values()) {
            if (this_id == key) break;
            prev_id = this_id;
        }
        if (prev_id == null && name_map.size() > 1) {
            Iterator it = name_map.values().iterator();
            it.next();
            prev_id = "~" + (String)it.next();
        }
        if (parent_name == null || parent_name.length() == 0) {
            entry = mdi.createEntry(new UISWTViewBuilderCore(key, null, SubscriptionView.class).setParentEntryID(CONFIG_SECTION_ID).setInitialDatasource(subs).setPreferredAfterID(prev_id), true);
        } else {
            MdiEntry parent_entry;
            object = this.parent_views;
            synchronized (object) {
                parent_entry = this.parent_views.get(parent_name);
                if (parent_entry == null) {
                    boolean is_before;
                    SubsParentView parent = new SubsParentView(parent_name);
                    String parent_key = this.getParentKey(parent_name);
                    String parent_prev_id = null;
                    this.parent_views.put(parent_name, parent_entry);
                    String parent_prev = null;
                    for (String pn : this.parent_views.keySet()) {
                        if (pn == parent_name) break;
                        parent_prev = pn;
                    }
                    if (parent_prev == null && this.parent_views.size() > 1) {
                        Iterator<String> it = this.parent_views.keySet().iterator();
                        it.next();
                        parent_prev = it.next();
                        is_before = true;
                    } else {
                        is_before = false;
                    }
                    if (parent_prev != null) {
                        parent_prev_id = this.getParentKey(parent_prev);
                        if (is_before) {
                            parent_prev_id = "~" + parent_prev_id;
                        }
                    }
                    parent_entry = mdi.createEntryFromSkinRef(CONFIG_SECTION_ID, parent_key, null, parent_name, parent, null, false, parent_prev_id);
                    this.parent_views.put(parent_name, parent_entry);
                }
            }
            entry = mdi.createEntry(new UISWTViewBuilderCore(key, null, SubscriptionView.class).setParentEntryID(parent_entry.getViewID()).setInitialDatasource(subs).setPreferredAfterID(prev_id), true);
        }
        SubscriptionMDIEntry entryInfo = new SubscriptionMDIEntry(subs, entry);
        subs.setUserData(SUB_ENTRYINFO_KEY, entryInfo);
        entry.addListener(new MdiCloseListener(){

            @Override
            public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                subs.setUserData(SUB_ENTRYINFO_KEY, null);
            }
        });
        return entry;
    }

    private String getKey(Subscription subs) {
        String key = "Subscription_" + ByteFormatter.encodeString(subs.getPublicKey());
        return key;
    }

    private void showSubscriptionMDI(Subscription sub) {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi != null) {
            String key = this.getKey(sub);
            mdi.showEntryByID(key, sub);
        }
    }

    private void reloadSubscriptionMDI(Subscription sub) {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi != null) {
            String key = this.getKey(sub);
            mdi.closeEntryByID(key);
            mdi.showEntryByID(key, sub);
        }
    }

    private void removeSubscriptionMDI(Subscription sub) {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi != null) {
            String key = this.getKey(sub);
            mdi.closeEntryByID(key);
        }
    }

    private String getParentKey(String parent_name) {
        byte[] bytes;
        try {
            bytes = parent_name.getBytes("UTF-8");
        }
        catch (Throwable e) {
            bytes = parent_name.getBytes();
        }
        return "SubscriptionParent_" + ByteFormatter.encodeString(bytes);
    }

    /*
     * Unable to fully structure code
     */
    protected void refreshTitles(MdiEntry entry) {
        mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi != null) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            entry.redraw();
            ViewTitleInfoManager.refreshTitleInfo(entry.getViewTitleInfo());
            key = entry.getParentID();
            if (key == null) {
                return;
            }
            entry = mdi.getEntry(key);
lbl10:
            // 2 sources

            ** while (entry != null)
        }
lbl11:
        // 1 sources

    }

    protected void removeSubscription(Subscription subs) {
        this.removeSubscriptionMDI(subs);
        this.refreshColumns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshColumns() {
        List<TableColumn> list = this.columns;
        synchronized (list) {
            for (TableColumn column : this.columns) {
                column.invalidateCells();
            }
        }
    }

    protected Graphic loadGraphic(UISWTInstance swt, String name) {
        Image image = swt.loadImage("com/biglybt/ui/images/" + name);
        UISWTGraphic graphic = swt.createGraphic(image);
        this.icon_list.add(image);
        return graphic;
    }

    protected static void createMenus(MenuManager menu_manager, MenuCreator menu_creator, SubsLists createFor) {
        Subscription firstSub;
        String key;
        MenuItem mi;
        boolean hasSingleSub;
        int total = createFor.templates.size() + createFor.subs.size();
        if (total == 0) {
            return;
        }
        boolean hasSubs = !createFor.subs.isEmpty();
        boolean hasMany = total > 1;
        boolean bl = hasSingleSub = !hasMany && hasSubs;
        if (hasSubs) {
            menu_creator.newItem("Subscription.menu.forcecheck", (menu, sub) -> sub.getManager().getScheduler().downloadAsync(sub, true));
            menu_creator.newSeparator();
            menu_creator.newItem("Subscription.menu.clearall", subs -> {
                for (Subscription sub : subs) {
                    try {
                        sub.getHistory().markAllResultsRead();
                    }
                    catch (Throwable t) {
                        Debug.out(t);
                    }
                }
                menu_creator.refreshView();
            });
            menu_creator.newItem("Subscription.menu.dirtyall", subs -> {
                for (Subscription sub : subs) {
                    try {
                        sub.getHistory().markAllResultsUnread();
                    }
                    catch (Throwable t) {
                        Debug.out(t);
                    }
                }
                menu_creator.refreshView();
            });
            menu_creator.newItem("Subscription.menu.deleteall", subs -> {
                for (Subscription sub : subs) {
                    try {
                        sub.getHistory().deleteAllResults();
                    }
                    catch (Throwable t) {
                        Debug.out(t);
                    }
                }
                menu_creator.refreshView();
            });
            menu_creator.newItem("Subscription.menu.reset", (menu, sub) -> {
                sub.getHistory().reset();
                try {
                    sub.getEngine().reset();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                try {
                    sub.getManager().getScheduler().downloadAsync(sub, true);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            });
            try {
                boolean anyNeedsAuth = false;
                for (Subscription sub2 : createFor.subs) {
                    Engine engine = sub2.getEngine();
                    if (!(engine instanceof WebEngine) || !((WebEngine)engine).isNeedsAuth()) continue;
                    anyNeedsAuth = true;
                    break;
                }
                if (anyNeedsAuth) {
                    menu_creator.newItem("Subscription.menu.resetauth", (menu, sub) -> SubscriptionManagerUI.resetAuth(sub));
                    menu_creator.newItem("Subscription.menu.setcookies", SubscriptionManagerUI::setCookies);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            menu_creator.newSeparator();
            mi = menu_creator.newItem("MyTorrentsView.menu.setCategory");
            mi.setStyle(5);
            mi.addFillListener((menu, data) -> SubscriptionManagerUI.addCategorySubMenu(menu_manager, menu, SubscriptionManagerUI.getSubsFromTarget((Object)data).subs));
            mi = menu_creator.newItem("label.tag");
            mi.setStyle(5);
            mi.addFillListener((menu, data) -> SubscriptionManagerUI.addTagSubMenu(menu_manager, menu, SubscriptionManagerUI.getSubsFromTarget((Object)data).subs));
            menu_creator.newItem("menu.set.parent", SubscriptionManagerUI::requestSetParentGroup);
            Subscription[] all_subs = createFor.subs.toArray(new Subscription[0]);
            SubscriptionManagerUI.addExecOnNewResultSubMenu(menu_manager, menu_creator, all_subs);
            SubscriptionManagerUI.addDependsOnSubMenu(menu_manager, menu_creator, all_subs);
            SubscriptionManagerUI.addViewOptionsSubMenu(menu_manager, menu_creator, all_subs);
        }
        if (hasSingleSub && (key = SubscriptionUtils.getSubscriptionChatKey(firstSub = createFor.subs.get(0))) != null) {
            MenuItem menuItem = menu_creator.newItem("label.chat");
            menuItem.setHeaderCategory("Social");
            MenuBuildUtils.addChatMenu(menu_manager, menuItem, new MenuBuildUtils.ChatKeyResolver(){

                @Override
                public String getResourceKey() {
                    return "menu.discuss.subs";
                }

                @Override
                public String getChatKey(Object object) {
                    return key;
                }
            });
        }
        if (hasSubs) {
            menu_creator.newItem("MyTorrentsView.menu.rename", SubscriptionManagerUI::renameSubs);
            menu_creator.newItem("Subscription.menu.upgrade", (menu, sub) -> {
                if (sub.getHighestVersion() > sub.getVersion()) {
                    sub.resetHighestVersion();
                }
            }).addFillListener((menu, data) -> {
                boolean visible = false;
                SubsLists subsLists = SubscriptionManagerUI.getSubsFromTarget(data);
                for (Subscription sub : subsLists.subs) {
                    if (sub.getHighestVersion() <= sub.getVersion()) continue;
                    visible = true;
                    break;
                }
                menu.setVisible(visible);
            });
        }
        if (!hasMany) {
            menu_creator.newItem("label.copy.uri.to.clip").addListener((menu, target) -> {
                SubsLists subsLists = SubscriptionManagerUI.getSubsFromTarget(target);
                Subscription sub = subsLists.subs.isEmpty() ? subsLists.templates.get(0) : subsLists.subs.get(0);
                ClipboardCopy.copyToClipBoard(sub.getURI());
            });
            menu_creator.newItem("Subscription.menu.export").addListener((menu, target) -> {
                SubsLists subsLists = SubscriptionManagerUI.getSubsFromTarget(target);
                Subscription sub = subsLists.subs.isEmpty() ? subsLists.templates.get(0) : subsLists.subs.get(0);
                SubscriptionManagerUI.export(sub);
            });
            menu_creator.newSeparator();
        }
        if (hasSingleSub) {
            firstSub = createFor.subs.get(0);
            try {
                Engine engine = firstSub.getEngine();
                if (engine instanceof WebEngine) {
                    menu_creator.newItem("menu.change.url", (menu, sub) -> SubscriptionManagerUI.requestChangeEngineURL(sub));
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (hasSubs) {
            menu_creator.newCheckItem("subs.prop.is_public", (item, sub) -> {
                if (sub.isUpdateable()) {
                    sub.setPublic(item.isSelected());
                }
            }).addFillListener((menu, data) -> {
                SubsLists subsFromTarget = SubscriptionManagerUI.getSubsFromTarget(data);
                boolean checked = false;
                boolean allUpdateable = true;
                for (Subscription sub : subsFromTarget.subs) {
                    if (!sub.isUpdateable()) {
                        allUpdateable = false;
                        break;
                    }
                    if (checked || !sub.isPublic()) continue;
                    checked = true;
                }
                menu.setVisible(allUpdateable);
                menu.setData(checked);
            });
            menu_creator.newCheckItem("subs.prop.enabled", (menu, sub) -> sub.getHistory().setEnabled(menu.isSelected())).addFillListener((menu, data) -> {
                SubsLists subsFromTarget = SubscriptionManagerUI.getSubsFromTarget(data);
                boolean checked = false;
                for (Subscription sub : subsFromTarget.subs) {
                    if (!sub.getHistory().isEnabled()) continue;
                    checked = true;
                    break;
                }
                menu.setData(checked);
            });
            menu_creator.newCheckItem("subs.prop.is_auto", (menu, sub) -> sub.getHistory().setAutoDownload(menu.isSelected())).addFillListener((menu, data) -> {
                SubsLists subsFromTarget = SubscriptionManagerUI.getSubsFromTarget(data);
                boolean checked = false;
                boolean anySupported = false;
                for (Subscription sub : subsFromTarget.subs) {
                    if (!sub.isAutoDownloadSupported()) continue;
                    anySupported = true;
                    if (!sub.getHistory().isAutoDownload()) continue;
                    checked = true;
                    break;
                }
                menu.setVisible(anySupported);
                menu.setData(checked);
            });
            menu_creator.newItem("subs.prop.update_period", SubscriptionManagerUI::requestSetRefreshPeriod).addFillListener((menu, data) -> {
                int check_freq;
                String text = MessageText.getString("subs.prop.update_period");
                SubsLists subsFromTarget = SubscriptionManagerUI.getSubsFromTarget(data);
                if (subsFromTarget.subs.size() == 1 && (check_freq = subsFromTarget.subs.get(0).getHistory().getCheckFrequencyMins()) != Integer.MAX_VALUE) {
                    text = String.valueOf(text) + " (" + check_freq + " " + MessageText.getString("ConfigView.text.minutes") + ")";
                }
                menu.setText(String.valueOf(text) + "...");
            });
            menu_creator.newCheckItem("subs.prop.is_dl_anon", (menu, sub) -> sub.getHistory().setDownloadNetworks((String[])(menu.isSelected() ? AENetworkClassifier.AT_NON_PUBLIC : null))).addFillListener((menu, data) -> menu.setData(SubscriptionManagerUI.getSubsFromTarget((Object)data).subs.stream().anyMatch(sub -> sub.getHistory().getDownloadNetworks() != null)));
            menu_creator.newCheckItem("subs.noti.post", (menu, sub) -> sub.getHistory().setNotificationPostEnabled(menu.isSelected())).addFillListener((menu, data) -> menu.setData(SubscriptionManagerUI.getSubsFromTarget((Object)data).subs.stream().anyMatch(sub -> sub.getHistory().getNotificationPostEnabled())));
            menu_creator.newItem("label.set.max.results", SubscriptionManagerUI::requestSetMaxResults).addFillListener((menu, data) -> {
                String text = MessageText.getString("label.set.max.results");
                SubsLists subsFromTarget = SubscriptionManagerUI.getSubsFromTarget(data);
                if (subsFromTarget.subs.size() == 1) {
                    int max_results = subsFromTarget.subs.get(0).getHistory().getMaxNonDeletedResults();
                    if (max_results < 0) {
                        SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                        max_results = subs_man.getMaxNonDeletedResults();
                    }
                    String max_results_str = max_results == 0 ? MessageText.getString("ConfigView.unlimited") : String.valueOf(max_results);
                    text = String.valueOf(text) + " (" + max_results_str + ")";
                }
                menu.setText(String.valueOf(text) + "...");
            });
        }
        mi = menu_creator.newItem("Subscription.menu.remove", (menu, target) -> SubscriptionManagerUI.removeWithConfirm(SubscriptionManagerUI.getSubsFromTarget((Object)target, (SubsLists)SubsLists.createOneList()).subs));
        Utils.setMenuItemImage(mi, "delete");
        menu_creator.newSeparator();
        if (total == 1) {
            menu_creator.newItem("Subscription.menu.properties", (menu, target) -> Utils.execSWTThread(() -> SubscriptionManagerUI.showProperties(SubscriptionManagerUI.getSubsFromTarget((Object)object, (SubsLists)SubsLists.createOneList()).subs.get(0))));
        }
    }

    private static void renameSubs(List<Subscription> subs) {
        if (subs.isEmpty()) {
            return;
        }
        Subscription sub = subs.remove(0);
        SimpleTextEntryWindow inputReceiver = new SimpleTextEntryWindow();
        inputReceiver.setPreenteredText(sub.getName(), false);
        inputReceiver.maintainWhitespace(false);
        inputReceiver.allowEmptyInput(false);
        inputReceiver.setLocalisedTitle(MessageText.getString("label.rename", new String[]{sub.getName()}));
        inputReceiver.prompt(entry -> {
            if (!entry.hasSubmittedInput()) {
                return;
            }
            String input = entry.getSubmittedInput();
            if (!input.isEmpty()) {
                try {
                    if (sub.isUpdateable()) {
                        sub.setName(input);
                    } else {
                        sub.setLocalName(input);
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            if (!subs.isEmpty()) {
                SubscriptionManagerUI.renameSubs(subs);
            }
        });
    }

    private static void addViewOptionsSubMenu(MenuManager menu_manager, MenuCreator menu_creator, Subscription[] all_subs) {
        if (all_subs.length == 0) {
            return;
        }
        MenuItem menuItem = menu_creator.newItem("menu.view.options");
        menuItem.setStyle(5);
        menuItem.addFillListener((menu, data) -> {
            menu.removeAllChildItems();
            boolean allFull = true;
            boolean allHide = true;
            Subscription[] subscriptionArray2 = all_subs;
            int n = all_subs.length;
            int n2 = 0;
            while (n2 < n) {
                Subscription sub2 = subscriptionArray2[n2];
                int vo = sub2.getViewOptions();
                if (allFull && vo != 0) {
                    allFull = false;
                    if (!allHide) break;
                }
                if (allHide && vo != 1) {
                    allHide = false;
                    if (!allFull) break;
                }
                ++n2;
            }
            MenuItem m = menu_manager.addMenuItem(menu, "label.full");
            m.setStyle(3);
            m.setData(allFull);
            m.addListener((mi, sub) -> sub.setViewOptions(0));
            m = menu_manager.addMenuItem(menu, "label.no.header");
            m.setStyle(3);
            m.setData(allHide);
            m.addListener((mi, sub) -> sub.setViewOptions(1));
        });
    }

    private static void addExecOnNewResultSubMenu(final MenuManager menu_manager, MenuCreator menu_creator, Subscription[] menu_subs) {
        if (menu_subs.length != 1) {
            return;
        }
        final Subscription subs = menu_subs[0];
        MenuItem menuItem = menu_creator.newItem("menu.exec.on.new.result");
        menuItem.setStyle(5);
        menuItem.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.removeAllChildItems();
                MenuItem mi = menu_manager.addMenuItem(menu, "label.script");
                String script = subs.getExecuteOnNewResult();
                if (script == null) {
                    script = "";
                }
                String f_script = script;
                if (script.length() > 30) {
                    script = script.substring(0, 30);
                }
                String msg = MessageText.getString("label.script");
                if (script.length() > 0) {
                    msg = String.valueOf(msg) + ": " + script;
                }
                msg = String.valueOf(msg) + "...";
                mi.setText(msg);
                mi.addListener((m, ev) -> {
                    String msg2 = MessageText.getString("UpdateScript.message");
                    SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("UpdateScript.title", "!" + msg2 + "!");
                    entryWindow.setPreenteredText(f_script, false);
                    entryWindow.selectPreenteredText(true);
                    entryWindow.prompt(new UIInputReceiverListener(){

                        @Override
                        public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                            if (entryWindow.hasSubmittedInput()) {
                                String text = entryWindow.getSubmittedInput().trim();
                                subs.setExecuteOnNewResult(text);
                            }
                        }
                    });
                });
            }
        });
    }

    private static void addDependsOnSubMenu(final MenuManager menu_manager, MenuCreator menu_creator, final Subscription[] menu_subs) {
        MenuItem menuItem = menu_creator.newItem("menu.depends.on");
        menuItem.setStyle(5);
        menuItem.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.removeAllChildItems();
                SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                Subscription[] all_subs = subs_man.getSubscriptions(true);
                ArrayList<Subscription> templates = new ArrayList<Subscription>();
                Subscription[] subscriptionArray = all_subs;
                int n = all_subs.length;
                int n2 = 0;
                while (n2 < n) {
                    Subscription sub = subscriptionArray[n2];
                    if (sub.isSubscriptionTemplate()) {
                        templates.add(sub);
                    }
                    ++n2;
                }
                if (templates.isEmpty()) {
                    MenuItem mi = menu_manager.addMenuItem(menu, "menu.no.subs.templates");
                    mi.setStyle(3);
                    mi.setData(true);
                    mi.setEnabled(false);
                    mi = menu_manager.addMenuItem(menu, "sep");
                    mi.setStyle(4);
                    mi = menu_manager.addMenuItem(menu, "!" + MessageText.getString("Wizard.Subscription.template.title") + "...!");
                    mi.addListener((m, ev) -> new SubscriptionWizard(5));
                } else {
                    HashSet<Subscription> enabled = new HashSet<Subscription>();
                    ArrayList<Subscription> menu_templates = new ArrayList<Subscription>();
                    ArrayList<Subscription> menu_search = new ArrayList<Subscription>();
                    Subscription[] subscriptionArray2 = menu_subs;
                    int n3 = menu_subs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Subscription subs = subscriptionArray2[n4];
                        if (subs.isSearchTemplate()) {
                            menu_search.add(subs);
                        } else {
                            List<Subscription> depends_on;
                            if (subs.isSubscriptionTemplate()) {
                                menu_templates.add(subs);
                            }
                            if ((depends_on = subs.getDependsOn()).isEmpty()) {
                                enabled.clear();
                                break;
                            }
                            if (enabled.isEmpty()) {
                                enabled.addAll(depends_on);
                            } else {
                                enabled.retainAll(depends_on);
                                if (enabled.isEmpty()) break;
                            }
                        }
                        ++n4;
                    }
                    if (menu_search.size() == menu_subs.length) {
                        return;
                    }
                    Collections.sort(templates, (t1, t2) -> t1.getName().compareTo(t2.getName()));
                    for (Subscription sub : templates) {
                        if (menu_templates.contains(sub)) continue;
                        MenuItem mi = menu_manager.addMenuItem(menu, "!" + sub.getName() + "!");
                        mi.setStyle(2);
                        boolean enable = enabled.contains(sub);
                        mi.setData(enable);
                        mi.addMultiListener((m, target) -> {
                            Subscription[] subscriptionArray2 = menu_subs;
                            int n = menu_subs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Subscription s = subscriptionArray2[n2];
                                if (!s.isSearchTemplate()) {
                                    List<Subscription> deps = s.getDependsOn();
                                    if (enable) {
                                        deps.remove(sub);
                                    } else {
                                        deps.add(sub);
                                    }
                                    s.setDependsOn(deps);
                                }
                                ++n2;
                            }
                        });
                    }
                }
            }
        });
    }

    private static void addCategorySubMenu(MenuManager menu_manager, MenuItem menu, List<Subscription> subs) {
        MenuItem m;
        menu.removeAllChildItems();
        if (subs.isEmpty()) {
            return;
        }
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        if (categories.length > 0) {
            String assigned_category = null;
            for (Subscription sub : subs) {
                String cat = sub.getCategory();
                if (assigned_category == null) {
                    if (cat == null) break;
                    assigned_category = cat;
                    continue;
                }
                if (StringCompareUtils.equals(cat, assigned_category)) continue;
                assigned_category = null;
                break;
            }
            Category uncat = CategoryManager.getCategory(2);
            if (uncat != null) {
                m = menu_manager.addMenuItem(menu, uncat.getName());
                m.setStyle(3);
                m.setData(assigned_category == null);
                m.addListener((menu1, target) -> SubscriptionManagerUI.assignSelectedToCategory(subs, uncat));
                m = menu_manager.addMenuItem(menu, "sep1");
                m.setStyle(4);
            }
            Object[] objectArray = categories;
            int n = categories.length;
            int n2 = 0;
            while (n2 < n) {
                Object cat = objectArray[n2];
                if (cat.getType() == 0) {
                    m = menu_manager.addMenuItem(menu, "!" + cat.getName() + "!");
                    m.setStyle(3);
                    m.setData(assigned_category != null && assigned_category.equals(cat.getName()));
                    TagUIUtils.setMenuIcon(m, (Tag)cat);
                    m.addListener((arg_0, arg_1) -> SubscriptionManagerUI.lambda$40(subs, (Category)cat, arg_0, arg_1));
                }
                ++n2;
            }
            m = menu_manager.addMenuItem(menu, "sep2");
            m.setStyle(4);
        }
        m = menu_manager.addMenuItem(menu, "MyTorrentsView.menu.setCategory.add");
        m.addMultiListener((menu3, target) -> SubscriptionManagerUI.addCategory(SubscriptionManagerUI.getSubsFromTarget((Object)target).subs));
    }

    private static void addCategory(List<Subscription> subs) {
        CategoryUIUtils.showCreateCategoryDialog(tags -> {
            if (tags.length == 1 && tags[0] instanceof Category) {
                SubscriptionManagerUI.assignSelectedToCategory(subs, (Category)tags[0]);
            }
        });
    }

    private static void assignSelectedToCategory(List<Subscription> subs, Category category) {
        for (Subscription sub : subs) {
            if (category.getType() == 2) {
                sub.setCategory(null);
                continue;
            }
            sub.setCategory(category.getName());
        }
    }

    private static void addTagSubMenu(MenuManager menu_manager, MenuItem menu, List<Subscription> subs) {
        menu.removeAllChildItems();
        TagManager tm = TagManagerFactory.getTagManager();
        HashMap<Tag, Integer> mapTaggableCount = new HashMap<Tag, Integer>();
        for (Subscription sub : subs) {
            Tag tag2 = tm.lookupTagByUID(sub.getTagID());
            if (tag2 == null) continue;
            mapTaggableCount.compute(tag2, (t, num) -> num == null ? 1 : num + 1);
        }
        MenuItem menuNoTag = menu_manager.addMenuItem(menu, "label.no.tag");
        menuNoTag.setStyle(3);
        menuNoTag.setData(mapTaggableCount.isEmpty());
        menuNoTag.addListener((menu1, target) -> {
            SubsLists subsLists = SubscriptionManagerUI.getSubsFromTarget(target);
            for (Subscription sub : subsLists.subs) {
                sub.setTagID(-1L);
            }
        });
        TagUIUtils.TagMenuOptions tagMenuOptions = TagUIUtils.TagMenuOptions.Builder().setParentPluginMenuItem(menu).setMenuManager(menu_manager).setMapTaggableCount(mapTaggableCount, subs.size()).setTagSelectionListener((tag, checked) -> {
            long tagUID = tag.getTagUID();
            for (Subscription sub : subs) {
                if (checked) {
                    sub.setTagID(tagUID);
                    continue;
                }
                if (sub.getTagID() != tagUID) continue;
                sub.setTagID(-1L);
            }
        }).build();
        TagUIUtils.createTagMenu(tagMenuOptions);
    }

    protected static void export(final Subscription subs) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                FileDialog dialog = new FileDialog(Utils.findAnyShell(), 139264);
                dialog.setFilterPath(TorrentOpener.getFilterPathData());
                dialog.setText(MessageText.getString("subscript.export.select.template.file"));
                dialog.setFilterExtensions(VuzeFileHandler.getVuzeFileFilterExtensions());
                dialog.setFilterNames(VuzeFileHandler.getVuzeFileFilterExtensions());
                String path = TorrentOpener.setFilterPathData(dialog.open());
                if (path != null) {
                    if (!VuzeFileHandler.isAcceptedVuzeFileName(path)) {
                        path = VuzeFileHandler.getVuzeFileName(path);
                    }
                    try {
                        VuzeFile vf = subs.getVuzeFile();
                        List<Subscription> deps = SubscriptionUtils.getDependsOnClosure(subs);
                        if (!deps.isEmpty()) {
                            for (Subscription dep : deps) {
                                vf.addComponents(dep.getVuzeFile());
                            }
                        }
                        vf.write(new File(path));
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    protected static void removeWithConfirm(List<Subscription> subs) {
        int numLeft = subs.size();
        if (numLeft == 0) {
            return;
        }
        Subscription subToRemove = subs.get(0);
        MessageBoxShell mb = new MessageBoxShell(MessageText.getString("message.confirm.delete.title"), MessageText.getString("message.confirm.delete.text", new String[]{subToRemove.getName()}), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
        if (numLeft > 1) {
            String sDeleteAll = MessageText.getString("v3.deleteContent.applyToAll", new String[]{"" + numLeft});
            mb.addCheckBox("!" + sDeleteAll + "!", 0, false);
        }
        mb.open(result -> {
            if (result == -1) {
                return;
            }
            boolean remove = result == 0;
            boolean doAll = mb.getCheckBoxEnabled();
            if (doAll) {
                if (remove) {
                    for (Subscription sub : subs) {
                        sub.remove();
                    }
                }
            } else {
                if (remove) {
                    subToRemove.remove();
                }
                subs.remove(0);
                SubscriptionManagerUI.removeWithConfirm(subs);
            }
        });
    }

    protected static void showProperties(Subscription subs) {
        int max_results;
        String engine_str;
        SubscriptionHistory history = subs.getHistory();
        String last_error = history.getLastError();
        if (last_error == null) {
            last_error = "";
        }
        String auth_str = String.valueOf(false);
        try {
            WebEngine web_engine;
            Engine engine = subs.getEngine();
            engine_str = engine.getNameEx();
            if (engine instanceof WebEngine && (web_engine = (WebEngine)engine).isNeedsAuth()) {
                auth_str = String.valueOf(String.valueOf(true)) + ": cookies=" + SubscriptionManagerUI.toString(web_engine.getRequiredCookies());
            }
            engine_str = String.valueOf(engine_str) + ", eid=" + engine.getId();
        }
        catch (Throwable e) {
            engine_str = "Unknown";
            auth_str = "";
        }
        String[] keys = new String[]{"subs.prop.enabled", "subs.prop.is_public", "subs.prop.is_auto", "subs.prop.is_auto_ok", "subs.prop.is_dl_anon", "subs.prop.update_period", "subs.prop.last_scan", "subs.prop.last_result", "subs.prop.next_scan", "subs.prop.last_error", "subs.prop.num_read", "subs.prop.num_unread", "label.max.results", "subs.prop.assoc", "subs.prop.version", "subs.prop.high_version", "subscriptions.listwindow.popularity", "subs.prop.template", "subs.prop.auth", "TableColumn.header.category", "TableColumn.header.tag.name", "subs.prop.query"};
        String category = subs.getCategory();
        String category_str = category == null ? MessageText.getString("Categories.uncategorized") : category;
        Tag tag = TagManagerFactory.getTagManager().lookupTagByUID(subs.getTagID());
        String tag_str = tag == null ? "" : tag.getTagName(true);
        int check_freq = history.getCheckFrequencyMins();
        long last_new_result = history.getLastNewResultTime();
        long next_scan = history.getNextScanTime();
        long next_sched = history.getNextScheduledUpdate();
        if (next_sched > 0L) {
            next_scan = next_sched;
        }
        if ((max_results = history.getMaxNonDeletedResults()) < 0) {
            SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
            max_results = subs_man.getMaxNonDeletedResults();
        }
        String max_results_str = max_results == 0 ? MessageText.getString("ConfigView.unlimited") : String.valueOf(max_results);
        String[] values = new String[]{String.valueOf(history.isEnabled()), String.valueOf(String.valueOf(subs.isPublic())) + "/" + !subs.isAnonymous(), String.valueOf(history.isAutoDownload()), String.valueOf(subs.isAutoDownloadSupported()), String.valueOf(history.getDownloadNetworks() != null), check_freq == Integer.MAX_VALUE ? "" : String.valueOf(String.valueOf(history.getCheckFrequencyMins()) + " " + MessageText.getString("ConfigView.text.minutes")), DisplayFormatters.formatDateYMDHM(history.getLastScanTime()), last_new_result == 0L ? "" : DisplayFormatters.formatDateYMDHM(last_new_result), next_scan == Long.MAX_VALUE ? "" : DisplayFormatters.formatDateYMDHM(next_scan), last_error.length() == 0 ? MessageText.getString("label.none") : String.valueOf(DisplayFormatters.formatDateYMDHM(history.getLastErrorTime())) + ": " + last_error, String.valueOf(history.getNumRead()), String.valueOf(history.getNumUnread()), max_results_str, String.valueOf(subs.getAssociationCount()), String.valueOf(subs.getVersion()), subs.getHighestVersion() > subs.getVersion() ? String.valueOf(subs.getHighestVersion()) : null, subs.getCachedPopularity() <= 1L ? "-" : String.valueOf(subs.getCachedPopularity()), String.valueOf(engine_str) + ", sid=" + subs.getID(), auth_str, category_str, tag_str, subs.getQueryKey()};
        final PropertiesWindow pw = new PropertiesWindow(subs.getName(), keys, values);
        try {
            subs.getPopularity(new SubscriptionPopularityListener(){

                @Override
                public void gotPopularity(long popularity) {
                    pw.updateProperty("subscriptions.listwindow.popularity", String.valueOf(popularity));
                }

                @Override
                public void failed(SubscriptionException error) {
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void resetAuth(Subscription sub) {
        try {
            Engine engine = sub.getEngine();
            if (engine instanceof WebEngine) {
                ((WebEngine)engine).setCookies(null);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        try {
            sub.getManager().getScheduler().downloadAsync(sub, true);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    private static void requestSetParentGroup(List<Subscription> subs) {
        SimpleTextEntryWindow receiver = new SimpleTextEntryWindow();
        receiver.maintainWhitespace(false);
        receiver.allowEmptyInput(true);
        receiver.setLocalisedTitle(MessageText.getString("label.set.parent"));
        HashMap<String, Integer> mapExisting = new HashMap<String, Integer>();
        for (Subscription sub : subs) {
            String parent = sub.getParent();
            if (parent == null) continue;
            mapExisting.merge(parent, 1, (oldVal, val) -> oldVal + 1);
        }
        String[] nameItems = (String[])MapUtils.sortCount(mapExisting, 10);
        if (nameItems != null) {
            if (nameItems.length == 1) {
                receiver.setPreenteredText(nameItems[0], false);
            } else {
                receiver.setSelectableItems(nameItems, 0, true);
            }
        }
        receiver.prompt(entry -> {
            if (!entry.hasSubmittedInput()) {
                return;
            }
            String input = entry.getSubmittedInput().trim();
            if (input.isEmpty()) {
                input = null;
            }
            for (Subscription sub : subs) {
                sub.setParent(input);
            }
        });
    }

    private static void requestChangeEngineURL(Subscription sub) {
        SimpleTextEntryWindow entry = new SimpleTextEntryWindow();
        try {
            WebEngine web_engine = (WebEngine)sub.getEngine();
            entry.setPreenteredText(web_engine.getSearchUrl(true), false);
            entry.maintainWhitespace(false);
            entry.allowEmptyInput(false);
            entry.setLocalisedTitle(MessageText.getString("change.url.msg.title", new String[]{sub.getName()}));
            entry.setMessage("change.url.msg.desc");
            entry.prompt(entry1 -> {
                if (!entry1.hasSubmittedInput()) {
                    return;
                }
                String input = entry1.getSubmittedInput().trim();
                if (!input.isEmpty()) {
                    Utils.getOffOfSWTThread(() -> {
                        try {
                            WebEngine web_engine1 = (WebEngine)sub.getEngine();
                            web_engine1 = web_engine1.getClone();
                            web_engine1.setSearchUrl(input);
                            sub.cloneWithNewEngine(web_engine1);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    });
                }
            });
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    private static void requestSetRefreshPeriod(List<Subscription> subs) {
        SimpleTextEntryWindow receiver = new SimpleTextEntryWindow();
        receiver.maintainWhitespace(false);
        receiver.allowEmptyInput(false);
        HashMap<String, Integer> mapExisting = new HashMap<String, Integer>();
        for (Subscription sub : subs) {
            int check_freq = sub.getHistory().getCheckFrequencyMins();
            mapExisting.merge(String.valueOf(check_freq), 1, (oldVal, val) -> oldVal + 1);
        }
        String[] nameItems = (String[])MapUtils.sortCount(mapExisting, 10);
        if (nameItems != null) {
            if (nameItems.length == 1) {
                receiver.setPreenteredText(nameItems[0], false);
            } else {
                receiver.setSelectableItems(nameItems, 0, true);
            }
        }
        receiver.setLocalisedTitle(MessageText.getString("subscriptions.enter.freq"));
        receiver.prompt(e -> {
            if (!e.hasSubmittedInput()) {
                return;
            }
            String input = e.getSubmittedInput().trim();
            if (input.isEmpty()) {
                return;
            }
            for (Subscription sub : subs) {
                try {
                    sub.getHistory().setCheckFrequencyMins(Integer.parseInt(input));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    private static void requestSetMaxResults(List<Subscription> subs) {
        SimpleTextEntryWindow receiver = new SimpleTextEntryWindow();
        receiver.maintainWhitespace(false);
        receiver.allowEmptyInput(true);
        HashMap<String, Integer> mapExisting = new HashMap<String, Integer>();
        for (Subscription sub : subs) {
            int max_results = sub.getHistory().getMaxNonDeletedResults();
            if (max_results < 0) {
                SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                max_results = subs_man.getMaxNonDeletedResults();
            }
            if (max_results < 0) continue;
            mapExisting.merge(String.valueOf(max_results), 1, (oldVal, val) -> oldVal + 1);
        }
        String[] nameItems = (String[])MapUtils.sortCount(mapExisting, 10);
        if (nameItems != null) {
            if (nameItems.length == 1) {
                receiver.setPreenteredText(nameItems[0], false);
            } else {
                receiver.setSelectableItems(nameItems, 0, true);
            }
        }
        receiver.setLocalisedTitle(MessageText.getString("subscriptions.enter.max.results"));
        receiver.prompt(entry -> {
            if (!entry.hasSubmittedInput()) {
                return;
            }
            String input = entry.getSubmittedInput().trim();
            for (Subscription sub : subs) {
                try {
                    sub.getHistory().setMaxNonDeletedResults(input.isEmpty() ? -1 : Math.abs(Integer.parseInt(input)));
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        });
    }

    private static void setCookies(List<Subscription> subs) {
        try {
            SimpleTextEntryWindow entry = new SimpleTextEntryWindow();
            HashMap<String, Integer> mapExisting = new HashMap<String, Integer>();
            for (Subscription sub : subs) {
                Engine engine = sub.getEngine();
                if (!(engine instanceof WebEngine)) continue;
                String[] req = ((WebEngine)engine).getRequiredCookies();
                String req_str = "";
                String[] stringArray = req;
                int n = req.length;
                int n2 = 0;
                while (n2 < n) {
                    String r = stringArray[n2];
                    req_str = String.valueOf(req_str) + (req_str.isEmpty() ? "" : ";") + r + "=?";
                    ++n2;
                }
                mapExisting.merge(req_str, 1, (oldVal, val) -> oldVal + 1);
            }
            String[] nameItems = (String[])MapUtils.sortCount(mapExisting, 10);
            if (nameItems != null) {
                if (nameItems.length == 1) {
                    entry.setPreenteredText(nameItems[0], true);
                } else {
                    entry.setSelectableItems(nameItems, 0, true);
                }
            }
            entry.maintainWhitespace(false);
            entry.allowEmptyInput(false);
            entry.setTitle("general.enter.cookies");
            entry.prompt(entry1 -> {
                if (!entry1.hasSubmittedInput()) {
                    return;
                }
                String input = entry1.getSubmittedInput().trim();
                if (input.isEmpty()) {
                    return;
                }
                for (Subscription sub : subs) {
                    try {
                        Engine engine = sub.getEngine();
                        if (!(engine instanceof WebEngine)) continue;
                        ((WebEngine)engine).setCookies(input);
                        sub.getManager().getScheduler().downloadAsync(sub, true);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    private static String toString(String[] strs) {
        String res = "";
        int i = 0;
        while (i < strs.length) {
            res = String.valueOf(res) + (i == 0 ? "" : ",") + strs[i];
            ++i;
        }
        return res;
    }

    public static SubsLists getSubsFromTarget(Object target) {
        return SubscriptionManagerUI.getSubsFromTarget(target, new SubsLists(new Subscription[0]));
    }

    private static SubsLists getSubsFromTarget(Object target, SubsLists lists) {
        if (target instanceof MdiEntry) {
            MdiEntry info = (MdiEntry)target;
            Subscription sub = (Subscription)info.getDataSource();
            try {
                (sub.isSearchTemplate() ? lists.templates : lists.subs).add(sub);
            }
            catch (Throwable t) {
                Debug.out(t);
            }
        } else if (target instanceof TableRow) {
            Object ds = ((TableRow)target).getDataSource();
            if (ds instanceof Subscription) {
                try {
                    Subscription sub = (Subscription)ds;
                    (sub.isSearchTemplate() ? lists.templates : lists.subs).add(sub);
                }
                catch (Throwable t) {
                    Debug.out(t);
                }
            }
        } else if (target instanceof TableRow[]) {
            TableRow[] rows;
            TableRow[] tableRowArray = rows = (TableRow[])target;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                TableRow row = tableRowArray[n2];
                Object ds = row.getDataSource();
                if (ds instanceof Subscription) {
                    Subscription sub = (Subscription)ds;
                    (sub.isSearchTemplate() ? lists.templates : lists.subs).add(sub);
                }
                ++n2;
            }
        } else if (target instanceof Subscription) {
            Subscription sub = (Subscription)target;
            (sub.isSearchTemplate() ? lists.templates : lists.subs).add(sub);
        } else if (target.getClass().isArray()) {
            Object[] entries;
            Object[] objectArray = entries = (Object[])target;
            int n = entries.length;
            int n3 = 0;
            while (n3 < n) {
                Object ds;
                Object entry = objectArray[n3];
                if (entry instanceof Subscription) {
                    Subscription sub = (Subscription)entry;
                    (sub.isSearchTemplate() ? lists.templates : lists.subs).add(sub);
                } else if (entry instanceof MdiEntry && (ds = ((UIPluginView)entry).getDataSource()) instanceof Subscription) {
                    Subscription sub = (Subscription)ds;
                    (sub.isSearchTemplate() ? lists.templates : lists.subs).add(sub);
                }
                ++n3;
            }
        } else {
            Debug.out("target " + target + " not handled");
        }
        return lists;
    }

    private static /* synthetic */ void lambda$40(List list, Category category, MenuItem menu2, Object target) {
        SubscriptionManagerUI.assignSelectedToCategory(list, category);
    }

    public static class ActivityCallback
    implements LocalActivityManager.LocalActivityCallback {
        @Override
        public void actionSelected(String action, Map<String, String> data) {
            String sub_id;
            SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
            final Subscription sub = subs_man.getSubscriptionByID(sub_id = data.get("subid"));
            if (sub != null) {
                TagManager tag_man = TagManagerFactory.getTagManager();
                if (tag_man != null && tag_man.isEnabled()) {
                    try {
                        String tag_name = String.valueOf(sub.getName()) + ": " + MessageText.getString("label.versions");
                        TagType tt = tag_man.getTagType(3);
                        Tag tag = tt.getTag(tag_name, true);
                        if (tag == null) {
                            tag = tt.createTag(tag_name, true);
                        }
                        TagFeatureLimits tfl = (TagFeatureLimits)((Object)tag);
                        tfl.setMaximumTaggables(5);
                        tfl.setRemovalStrategy(3);
                        sub.setTagID(tag.getTagUID());
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                SubscriptionHistory history = sub.getHistory();
                history.setCheckFrequencyMins(10);
                history.setMaxNonDeletedResults(20);
                history.setAutoDownload(true);
                SubscriptionResult[] results = sub.getResults(false);
                if (results.length > 0) {
                    results[results.length - 1].setRead(false);
                    int i = 0;
                    while (i < results.length - 1) {
                        results[i].setRead(true);
                        ++i;
                    }
                } else {
                    sub.addListener(new SubscriptionListener(){

                        @Override
                        public void subscriptionDownloaded(Subscription subs) {
                            SubscriptionResult[] results = subs.getResults(false);
                            if (results.length > 0) {
                                sub.removeListener(this);
                                results[results.length - 1].setRead(false);
                                int i = 0;
                                while (i < results.length - 1) {
                                    results[i].setRead(true);
                                    ++i;
                                }
                            }
                        }

                        @Override
                        public void subscriptionChanged(Subscription subs, int reason) {
                        }
                    });
                }
                sub.setSubscribed(true);
                sub.requestAttention();
            } else {
                MessageBoxShell mb = new MessageBoxShell(MessageText.getString("subs.deleted.title"), MessageText.getString("subs.deleted.msg", new String[]{data.get("subname")}), new String[]{MessageText.getString("Button.ok")}, 0);
                mb.open(new UserPrompterResultListener(){

                    @Override
                    public void prompterClosed(int result) {
                    }
                });
            }
        }
    }

    protected static abstract class MenuCreator {
        long sepID = 0L;

        protected MenuCreator() {
        }

        public final MenuItem newItem(String resource_id) {
            return this.newItem(resource_id, null);
        }

        public final MenuItem newCheckItem(String resource_id, MenuItemListener multiListener) {
            MenuItem menuItem = this.newItem(resource_id, multiListener);
            menuItem.setStyle(2);
            return menuItem;
        }

        public final MenuItem newSeparator() {
            MenuItem menuItem = this.newItem("subsep-" + this.sepID++, null);
            menuItem.setStyle(4);
            return menuItem;
        }

        public abstract MenuItem newItem(String var1, MenuItemListener var2);

        public abstract void refreshView();
    }

    private static interface SelectionList_NoTemplates
    extends MenuItemListener {
        @Override
        default public void selected(MenuItem menu, Object target) {
            Utils.getOffOfSWTThread(() -> this.selected(SubscriptionManagerUI.getSubsFromTarget((Object)object).subs));
        }

        public void selected(List<Subscription> var1);
    }

    private static interface Selection_NoTemplates
    extends MenuItemListener {
        @Override
        default public void selected(MenuItem menu, Object target) {
            Utils.getOffOfSWTThread(() -> {
                SubsLists subsLists = SubscriptionManagerUI.getSubsFromTarget(target);
                for (Subscription s : subsLists.subs) {
                    try {
                        this.selected(menu, s);
                    }
                    catch (Throwable t) {
                        Debug.out(t);
                    }
                }
            });
        }

        public void selected(MenuItem var1, Subscription var2) throws Throwable;
    }

    public static class SubsLists {
        List<Subscription> subs = new ArrayList<Subscription>();
        List<Subscription> templates = new ArrayList<Subscription>();

        public SubsLists(Subscription ... subs) {
            Collections.addAll(this.subs, subs);
        }

        public static SubsLists createOneList() {
            SubsLists subsLists = new SubsLists(new Subscription[0]);
            subsLists.subs = subsLists.templates;
            return subsLists;
        }
    }

    protected static class SubsParentView
    implements ViewTitleInfo,
    UISWTViewEventListener {
        private UISWTView swtView;
        private String title;
        private Composite parent_composite;
        private Composite composite;

        private SubsParentView(String _title) {
            this.title = _title;
        }

        @Override
        public boolean builderNotRequired() {
            return true;
        }

        public String getTitle() {
            return this.title;
        }

        @Override
        public Object getTitleInfoProperty(int propertyID) {
            if (propertyID == 5) {
                return this.getTitle();
            }
            return null;
        }

        public void initialize(Composite _parent_composite) {
            this.parent_composite = _parent_composite;
            this.composite = new Composite(this.parent_composite, 0);
        }

        public Composite getComposite() {
            return this.composite;
        }

        private void delete() {
        }

        @Override
        public boolean eventOccurred(UISWTViewEvent event2) {
            switch (event2.getType()) {
                case 0: {
                    this.swtView = (UISWTView)event2.getData();
                    this.swtView.setTitle(this.getTitle());
                    break;
                }
                case 7: {
                    this.delete();
                    break;
                }
                case 2: {
                    this.initialize((Composite)event2.getData());
                    break;
                }
                case 6: {
                    Messages.updateLanguageForControl((Widget)this.getComposite());
                    this.swtView.setTitle(this.getTitle());
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    break;
                }
            }
            return true;
        }
    }
}

