/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.subscriptions;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.metasearch.Engine;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.SubscriptionManagerFactory;
import com.biglybt.core.subs.SubscriptionManagerListener;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.vuzefile.VuzeFile;
import com.biglybt.core.vuzefile.VuzeFileComponent;
import com.biglybt.core.vuzefile.VuzeFileHandler;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.menus.MenuManager;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.pif.ui.tables.TableManager;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableLifeCycleListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableSelectionAdapter;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.table.TableViewFilterCheck;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionActions;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionAutoDownload;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionCategory;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionDependsOn;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionEnabled;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionError;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionLastChecked;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionMaxResults;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionName;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionNbNewResults;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionNbResults;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionNew;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionNewestDate;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionNextUpdate;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionParent;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionProtocol;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionPublic;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionSubscribers;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionTag;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionURL;
import com.biglybt.ui.swt.columns.subscriptions.ColumnSubscriptionUpdatePeriod;
import com.biglybt.ui.swt.components.BubbleTextBox;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.subscriptions.SubscriptionManagerUI;
import com.biglybt.ui.swt.subscriptions.SubscriptionSelectedContent;
import com.biglybt.ui.swt.subscriptions.SubscriptionWizard;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.TableViewSWTMenuFillListener;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import com.biglybt.ui.swt.views.table.utils.TableColumnFilterHelper;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class SubscriptionsView
implements SubscriptionManagerListener,
UIPluginViewToolBarListener,
UISWTViewCoreEventListener,
TableViewFilterCheck<Subscription> {
    protected static final String TABLE_ID = "subscriptions";
    private TableViewSWT<Subscription> view;
    private Composite viewComposite;
    private Font textFont0;
    private Font textFont1;
    private Font textFont2;
    private UISWTView swtView;
    private TableColumnFilterHelper<Subscription> col_filter_helper;

    @Override
    public void associationsChanged(byte[] association_hash) {
    }

    @Override
    public void subscriptionSelected(Subscription subscription) {
    }

    @Override
    public void subscriptionRequested(URL url, Map<String, Object> options) {
    }

    @Override
    public void subscriptionAdded(Subscription subscription) {
        if (subscription.isSubscribed()) {
            this.view.addDataSource(subscription);
        }
    }

    @Override
    public void subscriptionRemoved(Subscription subscription) {
        this.view.removeDataSource(subscription);
    }

    @Override
    public void subscriptionChanged(Subscription subscription, int reason) {
        if (!subscription.isSubscribed()) {
            this.subscriptionRemoved(subscription);
        } else {
            TableRowCore row = this.view.getRow(subscription);
            if (row == null) {
                this.subscriptionAdded(subscription);
            } else {
                row.invalidate(true);
                this.view.refreshTable(true);
            }
        }
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        if (this.view == null) {
            return;
        }
        int numRows = this.view.getSelectedRowsSize();
        list.put("remove", numRows > 0 ? 1L : 0L);
        list.put("share", numRows == 1 ? 1L : 0L);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        if ("remove".equals(item.getID())) {
            this.removeSelected();
            return true;
        }
        return false;
    }

    private void removeSelected() {
        TableRowCore[] rows = this.view.getSelectedRows();
        Subscription[] subs = new Subscription[rows.length];
        int i = 0;
        Subscription[] subscriptionArray = subs;
        int n = subs.length;
        int n2 = 0;
        while (n2 < n) {
            Subscription subscription = subscriptionArray[n2];
            subs[i] = (Subscription)rows[i++].getDataSource();
            ++n2;
        }
        this.removeSubs(subs, 0);
    }

    private void removeSubs(final Subscription[] toRemove, final int startIndex) {
        if (toRemove == null || startIndex >= toRemove.length) {
            return;
        }
        if (toRemove[startIndex] == null) {
            int nextIndex = startIndex + 1;
            if (nextIndex < toRemove.length) {
                this.removeSubs(toRemove, nextIndex);
            }
            return;
        }
        MessageBoxShell mb = new MessageBoxShell(MessageText.getString("message.confirm.delete.title"), MessageText.getString("message.confirm.delete.text", new String[]{toRemove[startIndex].getName()}));
        if (startIndex == toRemove.length - 1) {
            mb.setButtons(0, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, new Integer[]{0, 1});
        } else {
            mb.setButtons(1, new String[]{MessageText.getString("Button.removeAll"), MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, new Integer[]{2, 0, 1});
        }
        mb.open(new UserPrompterResultListener(){

            @Override
            public void prompterClosed(int result) {
                if (result == 0) {
                    toRemove[startIndex].remove();
                } else if (result == 2) {
                    int i = startIndex;
                    while (i < toRemove.length) {
                        if (toRemove[i] != null) {
                            toRemove[i].remove();
                        }
                        ++i;
                    }
                    return;
                }
                int nextIndex = startIndex + 1;
                if (nextIndex < toRemove.length) {
                    SubscriptionsView.this.removeSubs(toRemove, nextIndex);
                }
            }
        });
    }

    private void delete() {
        if (this.view != null && !this.view.isDisposed()) {
            this.view.delete();
        }
        this.col_filter_helper = null;
        if (this.viewComposite != null && !this.viewComposite.isDisposed()) {
            this.viewComposite.dispose();
        }
        if (this.textFont0 != null && !this.textFont0.isDisposed()) {
            this.textFont0.dispose();
        }
        if (this.textFont1 != null && !this.textFont1.isDisposed()) {
            this.textFont1.dispose();
        }
        if (this.textFont2 != null && !this.textFont2.isDisposed()) {
            this.textFont2.dispose();
        }
    }

    private Composite getComposite() {
        return this.viewComposite;
    }

    private String getFullTitle() {
        return MessageText.getString("subscriptions.overview");
    }

    private void initialize(Composite parent) {
        Color fg;
        this.viewComposite = new Composite(parent, 0);
        this.viewComposite.setLayout((Layout)new FormLayout());
        Font font = this.viewComposite.getFont();
        this.textFont0 = FontUtils.getFontWithStyle(font, 1, 1.0f);
        this.textFont1 = FontUtils.getFontWithStyle(font, Constants.isWindows ? 1 : 0, 1.5f);
        this.textFont2 = FontUtils.getFontWithStyle(font, 0, 1.2f);
        boolean dark = Utils.isDarkAppearanceNative();
        Composite topComposite = new Composite(this.viewComposite, 0);
        topComposite.setLayout((Layout)new FormLayout());
        final Composite tableComposite = new Composite(this.viewComposite, 0);
        tableComposite.setLayout((Layout)new FormLayout());
        final Composite bottomComposite = new Composite(this.viewComposite, dark ? 0 : 2048);
        bottomComposite.setLayout((Layout)new FormLayout());
        Label lblHeader = new Label(topComposite, 0);
        lblHeader.setFont(this.textFont0);
        lblHeader.setText(MessageText.getString("subscriptions.overview"));
        Button btnAdd = new Button(topComposite, 0);
        btnAdd.setText(String.valueOf(MessageText.getString("subscriptions.add.tooltip")) + "...");
        btnAdd.addListener(13, ev -> new SubscriptionWizard());
        BubbleTextBox bubbleTextBox = new BubbleTextBox(topComposite, 2948);
        Composite mainBubbleWidget = bubbleTextBox.getMainWidget();
        String tooltip = MessageText.getString("filter.tt.start");
        tooltip = String.valueOf(tooltip) + MessageText.getString("column.filter.tt.line1");
        tooltip = String.valueOf(tooltip) + MessageText.getString("column.filter.tt.line2");
        bubbleTextBox.setTooltip(tooltip);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.top = new FormAttachment((Control)btnAdd, 0, 0x1000000);
        lblHeader.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment((Control)mainBubbleWidget, -10);
        btnAdd.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment(100, -5);
        fd.bottom = new FormAttachment((Control)btnAdd, 0, 0x1000000);
        fd.width = 140;
        bubbleTextBox.setMessageAndLayout(MessageText.getString("Button.search2"), fd);
        TableColumn[] columns = new TableColumnCore[]{new ColumnSubscriptionNew(TABLE_ID), new ColumnSubscriptionName(TABLE_ID), new ColumnSubscriptionActions(TABLE_ID), new ColumnSubscriptionNbNewResults(TABLE_ID), new ColumnSubscriptionNbResults(TABLE_ID), new ColumnSubscriptionAutoDownload(TABLE_ID), new ColumnSubscriptionURL(TABLE_ID), new ColumnSubscriptionMaxResults(TABLE_ID), new ColumnSubscriptionLastChecked(TABLE_ID), new ColumnSubscriptionSubscribers(TABLE_ID), new ColumnSubscriptionEnabled(TABLE_ID), new ColumnSubscriptionCategory(TABLE_ID), new ColumnSubscriptionTag(TABLE_ID), new ColumnSubscriptionParent(TABLE_ID), new ColumnSubscriptionError(TABLE_ID), new ColumnSubscriptionNewestDate(TABLE_ID), new ColumnSubscriptionDependsOn(TABLE_ID), new ColumnSubscriptionPublic(TABLE_ID), new ColumnSubscriptionUpdatePeriod(TABLE_ID), new ColumnSubscriptionProtocol(TABLE_ID), new ColumnSubscriptionNextUpdate(TABLE_ID)};
        TableColumnManager tcm = TableColumnManager.getInstance();
        tcm.setDefaultColumnNames(TABLE_ID, columns);
        tcm.setDefaultSortColumnName(TABLE_ID, "name");
        this.view = TableViewFactory.createTableViewSWT(Subscription.class, TABLE_ID, "subscriptions.view", (TableColumnCore[])columns, "name", 0x10010002);
        this.col_filter_helper = new TableColumnFilterHelper<Subscription>(this.view, "subsv");
        this.view.enableFilterCheck(bubbleTextBox, (TableViewFilterCheck<Subscription>)this);
        this.view.addLifeCycleListener(new TableLifeCycleListener(){

            @Override
            public void tableLifeCycleEventOccurred(TableView tv, int eventType, Map<String, Object> data) {
                switch (eventType) {
                    case 0: {
                        SubscriptionManagerFactory.getSingleton().addListener(SubscriptionsView.this);
                        SubscriptionsView.this.view.addDataSources(SubscriptionManagerFactory.getSingleton().getSubscriptions(true));
                        break;
                    }
                    case 1: {
                        SubscriptionManagerFactory.getSingleton().removeListener(SubscriptionsView.this);
                    }
                }
            }
        });
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        final MenuManager menu_manager = uim.getMenuManager();
        final TableManager table_manager = uim.getTableManager();
        final ArrayList menu_items = new ArrayList();
        final SubscriptionManagerUI.MenuCreator menu_creator = new SubscriptionManagerUI.MenuCreator(){

            @Override
            public MenuItem newItem(String resource_id, MenuItemListener multiListener) {
                TableContextMenuItem menu = table_manager.addContextMenuItem(SubscriptionsView.TABLE_ID, resource_id);
                menu.setDisposeWithUIDetach("swt");
                menu_items.add(menu);
                if (multiListener != null) {
                    menu.addMultiListener(multiListener);
                }
                return menu;
            }

            @Override
            public void refreshView() {
            }
        };
        this.view.addSelectionListener(new TableSelectionAdapter(){

            @Override
            public void defaultSelected(TableRowCore[] rows, int stateMask) {
                if (rows.length == 1) {
                    TableRowCore row = rows[0];
                    Subscription sub = (Subscription)row.getDataSource();
                    if (sub == null) {
                        return;
                    }
                    if (sub.isSearchTemplate()) {
                        try {
                            VuzeFile vf = sub.getSearchTemplateVuzeFile();
                            if (vf != null) {
                                sub.setSubscribed(true);
                                VuzeFileHandler.getSingleton().handleFiles(new VuzeFile[]{vf}, 0);
                                VuzeFileComponent[] vuzeFileComponentArray = vf.getComponents();
                                int n = vuzeFileComponentArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    VuzeFileComponent comp2 = vuzeFileComponentArray[n2];
                                    Engine engine = (Engine)comp2.getData(Engine.VUZE_FILE_COMPONENT_ENGINE_KEY);
                                    if (engine != null && (engine.getSelectionState() == 0 || engine.getSelectionState() == 3)) {
                                        engine.setSelectionState(2);
                                    }
                                    ++n2;
                                }
                            }
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    } else {
                        String key = "Subscription_" + ByteFormatter.encodeString(sub.getPublicKey());
                        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                        if (mdi != null) {
                            mdi.showEntryByID(key);
                        }
                    }
                }
            }

            @Override
            public void selectionChanged(TableRowCore[] selected_rows, TableRowCore[] deselected_rows) {
                TableRowCore[] rows = SubscriptionsView.this.view.getSelectedRows();
                ISelectedContent[] sels = new ISelectedContent[rows.length];
                int i = 0;
                while (i < rows.length) {
                    sels[i] = new SubscriptionSelectedContent((Subscription)rows[i].getDataSource());
                    ++i;
                }
                SelectedContentManager.changeCurrentlySelectedContent(SubscriptionsView.this.view.getTableID(), sels, SubscriptionsView.this.view);
            }
        }, false);
        this.view.addMenuFillListener(new TableViewSWTMenuFillListener(){

            @Override
            public void fillMenu(String sColumnName, Menu menu) {
                SubscriptionManagerUI.SubsLists subsLists = SubscriptionManagerUI.getSubsFromTarget(SubscriptionsView.this.view.getSelectedRows());
                for (TableContextMenuItem mi : menu_items) {
                    mi.remove();
                }
                menu_items.clear();
                SubscriptionManagerUI.createMenus(menu_manager, menu_creator, subsLists);
            }

            @Override
            public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
            }
        });
        this.view.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event2) {
            }

            public void keyReleased(KeyEvent event2) {
                if (event2.keyCode == 127) {
                    SubscriptionsView.this.removeSelected();
                }
            }
        });
        this.view.setRowDefaultHeightEM(1.4f);
        this.view.initialize(tableComposite);
        Display display = bottomComposite.getDisplay();
        if (dark) {
            Utils.setSkinnedBackground((Control)bottomComposite, Colors.getSystemColor((Device)display, Utils.isDarkAppearanceNativeWindows() ? 19 : 20), true);
        } else {
            bottomComposite.setBackground(ColorCache.getColor((Device)display, "#F1F9F8"));
        }
        Label preText = new Label(bottomComposite, 0);
        preText.setFont(this.textFont1);
        preText.setText(MessageText.getString("subscriptions.view.help.1"));
        Label image = new Label(bottomComposite, 0);
        ImageLoader.getInstance().setLabelImage(image, "btn_rss_add");
        Link postText = new Link(bottomComposite, 0);
        postText.setFont(this.textFont2);
        postText.setText(MessageText.getString("subscriptions.view.help.2"));
        if (dark) {
            Utils.setSkinnedBackground((Control)preText, (Control)bottomComposite);
            Utils.setSkinnedBackground((Control)postText, (Control)bottomComposite);
            fg = Colors.getSystemColor((Device)display, 21);
            preText.setForeground(fg);
            postText.setForeground(fg);
        } else {
            fg = ColorCache.getColor((Device)display, "#6D6F6E");
            preText.setForeground(fg);
            postText.setForeground(fg);
        }
        ClipboardCopy.addCopyToClipMenu((Control)postText);
        postText.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                if (event2.text != null && (event2.text.startsWith("http://") || event2.text.startsWith("https://"))) {
                    Utils.launch(event2.text);
                }
            }
        });
        Label close = new Label(bottomComposite, 0);
        ImageLoader.getInstance().setLabelImage(close, "image.dismissX");
        close.setCursor(display.getSystemCursor(21));
        FormData data = new FormData();
        data.left = new FormAttachment(0, 15);
        data.top = new FormAttachment(0, 20);
        data.bottom = new FormAttachment((Control)postText, -5);
        preText.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)preText, 5);
        data.top = new FormAttachment((Control)preText, 0, 0x1000000);
        image.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)preText, 0, 16384);
        data.bottom = new FormAttachment(100, -20);
        postText.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100, -10);
        data.top = new FormAttachment(0, 10);
        close.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        topComposite.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)topComposite, 0);
        data.bottom = new FormAttachment((Control)bottomComposite, 0);
        tableComposite.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        bottomComposite.setLayoutData((Object)data);
        close.addListener(4, new Listener(){

            public void handleEvent(Event arg0) {
                COConfigurationManager.setParameter("subscriptions.view.showhelp", false);
                bottomComposite.setVisible(false);
                FormData data = (FormData)tableComposite.getLayoutData();
                data.bottom = new FormAttachment(100, 0);
                SubscriptionsView.this.viewComposite.layout(true);
            }
        });
        COConfigurationManager.setBooleanDefault("subscriptions.view.showhelp", true);
        if (!COConfigurationManager.getBooleanParameter("subscriptions.view.showhelp")) {
            bottomComposite.setVisible(false);
            data = (FormData)tableComposite.getLayoutData();
            data.bottom = new FormAttachment(100, 0);
            this.viewComposite.layout(true);
        }
    }

    @Override
    public boolean filterCheck(Subscription ds, String filter2, boolean regex, boolean confusable) {
        if (confusable) {
            filter2 = GeneralUtils.getConfusableEquivalent(filter2, true);
        }
        String name = ds.getName();
        if (confusable) {
            name = GeneralUtils.getConfusableEquivalent(name, false);
        }
        return this.col_filter_helper.filterCheck(ds, filter2, regex, name, false);
    }

    @Override
    public void filterSet(String filter2) {
        this.col_filter_helper.filterSet(filter2);
    }

    private void refresh() {
        if (this.view != null) {
            this.view.refreshTable(false);
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }
}

