/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.systray;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.TagDownload;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.updater.UIUpdatableAlways;
import com.biglybt.ui.common.util.MenuItemManager;
import com.biglybt.ui.swt.Alerts;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.SelectableSpeedMenu;
import com.biglybt.ui.swt.systray.TrayDelegate;
import com.biglybt.ui.swt.systray.TrayDelegateFactory;
import com.biglybt.ui.swt.systray.TrayItemDelegate;
import com.biglybt.ui.swt.systray.TraySWT;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import com.biglybt.util.JSONUtils;
import java.io.File;
import java.util.Locale;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.json.simple.JSONObject;

public class SystemTraySWT
implements UIUpdatableAlways,
MessageText.MessageTextListener {
    private static SystemTraySWT singleton;
    private final MenuBuildUtils.MenuBuilder menuBuilder;
    private final ParameterListener paramTooltipListener;
    private final ParameterListener paramToolipETAListener;
    private final String trayIconImageID;
    private long lastUnixVal = -1L;
    protected static Core core;
    Display display;
    UIFunctionsSWT uiFunctions;
    TrayDelegate tray;
    TrayItemDelegate trayItem;
    Menu menu;
    protected GlobalManager gm = null;
    private String seedingKeyVal;
    private String downloadingKeyVal;
    private String etaKeyVal;
    private String dlAbbrKeyVal;
    private String ulAbbrKeyVal;
    private String alertsKeyVal;
    long interval = 0L;
    protected boolean enableTooltip;
    protected boolean enableTooltipNextETA;

    static {
        core = null;
    }

    public static synchronized boolean hasTray() {
        return singleton != null;
    }

    public static synchronized SystemTraySWT getTray() {
        if (singleton == null) {
            singleton = new SystemTraySWT();
        }
        return singleton;
    }

    private SystemTraySWT() {
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                SystemTraySWT.core = core;
                SystemTraySWT.this.gm = core.getGlobalManager();
            }
        });
        this.paramTooltipListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                SystemTraySWT.this.enableTooltip = COConfigurationManager.getBooleanParameter(parameterName);
                if (SystemTraySWT.this.enableTooltip) {
                    MessageText.addAndFireListener(SystemTraySWT.this);
                    SystemTraySWT.this.interval = 0L;
                } else {
                    MessageText.removeListener(SystemTraySWT.this);
                    if (SystemTraySWT.this.trayItem != null && !SystemTraySWT.this.trayItem.isDisposed()) {
                        Utils.setTT(SystemTraySWT.this.trayItem, null);
                    }
                }
            }
        };
        this.paramToolipETAListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                SystemTraySWT.this.enableTooltipNextETA = COConfigurationManager.getBooleanParameter(parameterName);
                SystemTraySWT.this.interval = 0L;
            }
        };
        COConfigurationManager.addAndFireParameterListener("ui.systray.tooltip.enable", this.paramTooltipListener);
        COConfigurationManager.addAndFireParameterListener("ui.systray.tooltip.next.eta.enable", this.paramToolipETAListener);
        this.uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        this.display = Utils.getDisplay();
        this.tray = TrayDelegateFactory.getTray(this.display);
        this.trayItem = TrayDelegateFactory.createTrayItem(this.tray);
        File imageFile = new File(SystemProperties.getApplicationPath(), "biglybt-lightgray.svg");
        this.trayIconImageID = Constants.isOSX ? "osx_tray" : (Constants.isUnix ? "nix_tray" : "logo32");
        this.trayItem.setImage(this.trayIconImageID, imageFile);
        this.trayItem.setVisible(true);
        this.menu = new Menu((Decorations)this.uiFunctions.getMainShell(), 8);
        this.menuBuilder = new MenuBuildUtils.MenuBuilder(){

            @Override
            public void buildMenu(Menu root_menu, MenuEvent menuEvent) {
                SystemTraySWT.this.fillMenu(SystemTraySWT.this.menu);
            }
        };
        this.trayItem.setMenu(this.menu, this.menuBuilder);
        this.trayItem.addListener(14, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.showMainWindow();
            }
        });
        this.trayItem.addListener(13, new Listener(){
            long lastTime = 0L;

            public void handleEvent(Event arg0) {
                if (Constants.isWindows) {
                    long now = SystemTime.getCurrentTime();
                    if (now - this.lastTime < 200L) {
                        SystemTraySWT.this.showMainWindow();
                    } else {
                        this.lastTime = now;
                    }
                } else if (Constants.isOSX) {
                    SystemTraySWT.this.menu.setVisible(true);
                }
            }
        });
        this.trayItem.addListener(35, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.menu.setVisible(true);
            }
        });
        this.uiFunctions.getUIUpdater().addUpdater(this);
    }

    public void fillMenu(Menu menu) {
        MenuItem itemShow = new MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemShow, "SystemTray.menu.show");
        new MenuItem(menu, 2);
        MenuItem itemAddTorrent = new MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemAddTorrent, "menu.open.torrent");
        new MenuItem(menu, 2);
        MenuItem itemCloseAll = new MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemCloseAll, "SystemTray.menu.closealldownloadbars");
        MenuItem itemShowGlobalTransferBar = new MenuItem(menu, 32);
        Messages.setLanguageText((Widget)itemShowGlobalTransferBar, "SystemTray.menu.open_global_transfer_bar");
        new MenuItem(menu, 2);
        com.biglybt.pif.ui.menus.MenuItem[] menu_items = MenuItemManager.getInstance().getAllAsArray("systray");
        if (menu_items.length > 0) {
            MenuBuildUtils.addPluginMenuItems(menu_items, menu, true, true, MenuBuildUtils.BASIC_MENU_ITEM_CONTROLLER);
            new MenuItem(menu, 2);
        }
        this.createUploadLimitMenu(menu);
        this.createDownloadLimitMenu(menu);
        new MenuItem(menu, 2);
        MenuItem itemStartAll = new MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemStartAll, "SystemTray.menu.startalltransfers");
        MenuItem itemStopAll = new MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemStopAll, "SystemTray.menu.stopalltransfers");
        MenuItem itemPause = new MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemPause, "SystemTray.menu.pausetransfers");
        MenuItem itemResume = new MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemResume, "SystemTray.menu.resumetransfers");
        new MenuItem(menu, 2);
        Menu optionsMenu = new Menu((Decorations)menu.getShell(), 4);
        MenuItem optionsItem = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)optionsItem, "tray.options");
        optionsItem.setMenu(optionsMenu);
        final MenuItem itemShowToolTip = new MenuItem(optionsMenu, 32);
        Messages.setLanguageText((Widget)itemShowToolTip, "show.tooltip.label");
        MenuItem itemMoreOptions = new MenuItem(optionsMenu, 8);
        Messages.setLanguageText((Widget)itemMoreOptions, "label.more.dot");
        new MenuItem(menu, 2);
        MenuItem itemExit = new MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemExit, "SystemTray.menu.exit");
        itemShow.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.showMainWindow();
            }
        });
        itemAddTorrent.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.uiFunctions.openTorrentWindow();
            }
        });
        itemStartAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (SystemTraySWT.this.gm == null) {
                    return;
                }
                SystemTraySWT.this.gm.startAllDownloads();
            }
        });
        itemStopAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ManagerUtils.asyncStopAll();
            }
        });
        itemPause.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ManagerUtils.asyncPause();
            }
        });
        itemResume.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (SystemTraySWT.this.gm == null) {
                    return;
                }
                SystemTraySWT.this.gm.resumeDownloads();
            }
        });
        itemPause.setEnabled(this.gm != null && this.gm.canPauseDownloads());
        itemResume.setEnabled(this.gm != null && this.gm.canResumeDownloads());
        itemCloseAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.uiFunctions.closeDownloadBars();
            }
        });
        itemShowGlobalTransferBar.setSelection(this.uiFunctions.isGlobalTransferBarShown());
        itemShowGlobalTransferBar.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (SystemTraySWT.this.uiFunctions.isGlobalTransferBarShown()) {
                    SystemTraySWT.this.uiFunctions.closeGlobalTransferBar();
                } else {
                    SystemTraySWT.this.uiFunctions.showGlobalTransferBar();
                }
            }
        });
        itemShowToolTip.setSelection(this.enableTooltip);
        itemShowToolTip.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                COConfigurationManager.setParameter("ui.systray.tooltip.enable", itemShowToolTip.getSelection());
            }
        });
        itemMoreOptions.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    SystemTraySWT.this.showMainWindow();
                    JSONObject args = new JSONObject();
                    args.put("select", "interface-systyray");
                    String args_str = JSONUtils.encodeToJSON(args);
                    uif.getMDI().showEntryByID("ConfigView", "style" + args_str);
                }
            }
        });
        itemMoreOptions.setEnabled(this.uiFunctions.getVisibilityState() != 1);
        itemExit.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                Utils.execSWTThreadLater(0, new AERunnable(){

                    @Override
                    public void runSupport() {
                        (this).SystemTraySWT.this.uiFunctions.dispose(false);
                    }
                });
            }
        });
    }

    private final void createUploadLimitMenu(Menu parent) {
        if (this.gm == null) {
            return;
        }
        MenuItem uploadSpeedItem = new MenuItem(parent, 64);
        uploadSpeedItem.setText(MessageText.getString("GeneralView.label.maxuploadspeed"));
        final Menu uploadSpeedMenu = new Menu((Decorations)this.uiFunctions.getMainShell(), 4);
        uploadSpeedMenu.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                SelectableSpeedMenu.generateMenuItems(uploadSpeedMenu, core, SystemTraySWT.this.gm, true);
            }
        });
        uploadSpeedItem.setMenu(uploadSpeedMenu);
    }

    private final void createDownloadLimitMenu(Menu parent) {
        if (this.gm == null) {
            return;
        }
        MenuItem downloadSpeedItem = new MenuItem(parent, 64);
        downloadSpeedItem.setText(MessageText.getString("GeneralView.label.maxdownloadspeed"));
        final Menu downloadSpeedMenu = new Menu((Decorations)this.uiFunctions.getMainShell(), 4);
        downloadSpeedMenu.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                SelectableSpeedMenu.generateMenuItems(downloadSpeedMenu, core, SystemTraySWT.this.gm, false);
            }
        });
        downloadSpeedItem.setMenu(downloadSpeedMenu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        COConfigurationManager.removeParameterListener("ui.systray.tooltip.enable", this.paramTooltipListener);
        COConfigurationManager.removeParameterListener("ui.systray.tooltip.next.eta.enable", this.paramToolipETAListener);
        this.uiFunctions.getUIUpdater().removeUpdater(this);
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SystemTraySWT.this.trayItem != null && !SystemTraySWT.this.trayItem.isDisposed()) {
                    SystemTraySWT.this.trayItem.dispose();
                }
                if (SystemTraySWT.this.trayIconImageID != null) {
                    ImageLoader imageLoader = ImageLoader.getInstance();
                    imageLoader.releaseImage(SystemTraySWT.this.trayIconImageID);
                }
            }
        });
        Class<SystemTraySWT> clazz = SystemTraySWT.class;
        synchronized (SystemTraySWT.class) {
            singleton = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void updateUI() {
        this.updateUI(true);
    }

    @Override
    public void updateUI(boolean is_visible) {
        long l;
        GlobalManagerStats stats2;
        if (this.interval++ % 10L > 0L) {
            return;
        }
        if (this.trayItem.isDisposed()) {
            this.uiFunctions.getUIUpdater().removeUpdater(this);
            return;
        }
        if (core == null || !core.isStarted()) {
            return;
        }
        if (this.enableTooltip) {
            TagType tt;
            stats2 = this.gm.getStats();
            StringBuilder toolTip = new StringBuilder();
            int seeding = 0;
            int downloading = 0;
            DownloadManager next_download = null;
            long next_download_eta = Long.MAX_VALUE;
            TagManager tm = TagManagerFactory.getTagManager();
            if (tm != null && tm.isEnabled() && (tt = tm.getTagType(2)) != null) {
                TagDownload dl_tag = (TagDownload)tt.getTag(1);
                downloading = dl_tag.getTaggedCount();
                seeding = tt.getTag(2).getTaggedCount();
                if (this.enableTooltipNextETA && downloading > 0) {
                    for (DownloadManager dl : dl_tag.getTaggedDownloads()) {
                        DownloadManagerStats dl_stats = dl.getStats();
                        long eta = dl_stats.getSmoothedETA();
                        if (eta >= next_download_eta) continue;
                        next_download_eta = eta;
                        next_download = dl;
                    }
                }
            }
            String seeding_text = this.seedingKeyVal.replaceAll("%1", "" + seeding);
            String downloading_text = this.downloadingKeyVal.replaceAll("%1", "" + downloading);
            toolTip.append(seeding_text).append(downloading_text).append("\n");
            if (next_download != null) {
                String dl_name = next_download.getDisplayName();
                if (dl_name.length() > 80) {
                    dl_name = String.valueOf(dl_name.substring(0, 77)) + "...";
                }
                dl_name = dl_name.replaceAll("&", "&&");
                toolTip.append("  ");
                toolTip.append(dl_name);
                toolTip.append(": ");
                toolTip.append(this.etaKeyVal);
                toolTip.append("=");
                toolTip.append(DisplayFormatters.formatETA(next_download_eta));
                toolTip.append("\n");
            }
            toolTip.append(this.dlAbbrKeyVal).append(" ");
            toolTip.append(DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(stats2.getDataReceiveRate(), stats2.getProtocolReceiveRate()));
            toolTip.append(", ").append(this.ulAbbrKeyVal).append(" ");
            toolTip.append(DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(stats2.getDataSendRate(), stats2.getProtocolSendRate()));
            int alerts = Alerts.getUnviewedLogAlertCount();
            if (alerts > 0) {
                toolTip.append("\n");
                toolTip.append(this.alertsKeyVal.replaceAll("%1", "" + alerts));
            }
            Utils.setTT(this.trayItem, toolTip.toString());
        }
        if (!(this.tray instanceof TraySWT) && (l = (long)(((stats2 = this.gm.getStats()).getDataReceiveRate() + stats2.getDataSendRate()) / 1024)) != this.lastUnixVal) {
            this.lastUnixVal = l;
            this.trayItem.setMenu(this.menu, this.menuBuilder);
        }
        this.trayItem.setVisible(true);
    }

    private void showMainWindow() {
        this.uiFunctions.bringToFront(false);
        this.uiFunctions.getMainShell().forceActive();
        this.uiFunctions.getMainShell().forceFocus();
    }

    public void updateLanguage() {
        if (this.menu != null) {
            Messages.updateLanguageForControl((Widget)this.menu);
        }
        this.updateUI();
    }

    @Override
    public String getUpdateUIName() {
        return "SystemTraySWT";
    }

    @Override
    public void localeChanged(Locale oldLocale, Locale newLocale) {
        this.seedingKeyVal = MessageText.getString("SystemTray.tooltip.seeding");
        this.downloadingKeyVal = MessageText.getString("SystemTray.tooltip.downloading");
        if (!this.downloadingKeyVal.startsWith(" ")) {
            this.downloadingKeyVal = " " + this.downloadingKeyVal;
        }
        this.etaKeyVal = MessageText.getString("TableColumn.header.eta");
        this.dlAbbrKeyVal = MessageText.getString("ConfigView.download.abbreviated");
        this.ulAbbrKeyVal = MessageText.getString("ConfigView.upload.abbreviated");
        this.alertsKeyVal = MessageText.getString("label.alertnum");
    }
}

