/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.uiupdater;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.common.updater.UIUpdatableAlways;
import com.biglybt.ui.common.updater.UIUpdater;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.IMainStatusBar;
import com.biglybt.ui.swt.utils.SWTRunnable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UIUpdaterSWT
extends AEThread2
implements ParameterListener,
UIUpdater {
    private static final LogIDs LOGID = LogIDs.UI3;
    private static final String CFG_REFRESH_INTERVAL = "GUI Refresh";
    private static final String CFG_REFRESH_INACTIVE_FACTOR = "Refresh When Inactive";
    private static final boolean DEBUG_TIMER = Constants.isCVSVersion();
    private static final boolean DEBUG_UPDATEABLES = Constants.IS_CVS_VERSION;
    private static UIUpdater updater = null;
    private int waitTimeMS;
    private boolean finished = false;
    private CopyOnWriteList<UIUpdatable> updateables = new CopyOnWriteList();
    private WeakHashMap<UIUpdatable, String> debug_Updateables;
    private CopyOnWriteList<UIUpdatable> alwaysUpdateables = new CopyOnWriteList();
    private AEMonitor updateables_mon = new AEMonitor("updateables");
    private int inactiveFactor;
    private int inactiveTicks;
    WeakHashMap<UIUpdatable, Long[]> averageTimes = DEBUG_TIMER ? new WeakHashMap() : null;
    private int update_count = 0;
    private CopyOnWriteList<UIUpdater.UIUpdaterListener> listeners = new CopyOnWriteList();
    private CopyOnWriteList<UIUpdatable> perioidic_updateables = new CopyOnWriteList();
    private int pu_counter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UIUpdater getInstance() {
        Class<UIUpdaterSWT> clazz = UIUpdaterSWT.class;
        synchronized (UIUpdaterSWT.class) {
            if (updater == null) {
                if (Utils.isDisplayDisposed()) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return null;
                }
                updater = new UIUpdaterSWT();
                updater.start();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return updater;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyInstance() {
        Class<UIUpdaterSWT> clazz = UIUpdaterSWT.class;
        synchronized (UIUpdaterSWT.class) {
            if (updater != null) {
                try {
                    updater.stopIt();
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
                updater = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public UIUpdaterSWT() {
        super("UI Updater", true);
        if (DEBUG_UPDATEABLES) {
            this.debug_Updateables = new WeakHashMap();
        }
        COConfigurationManager.addAndFireParameterListeners(new String[]{CFG_REFRESH_INTERVAL, CFG_REFRESH_INACTIVE_FACTOR}, this);
    }

    @Override
    public void run() {
        final AESemaphore sem = new AESemaphore("UI Updater");
        while (!this.finished) {
            Utils.execSWTThread(new SWTRunnable(){

                @Override
                public void runWithDisplay(Display display) {
                    block53: {
                        block52: {
                            block47: {
                                block48: {
                                    block49: {
                                        block45: {
                                            if (!UIUpdaterSWT.this.finished) break block45;
                                            try {
                                                for (UIUpdater.UIUpdaterListener l : UIUpdaterSWT.this.listeners) {
                                                    try {
                                                        UIUpdaterSWT uIUpdaterSWT = UIUpdaterSWT.this;
                                                        int n = uIUpdaterSWT.update_count + 1;
                                                        uIUpdaterSWT.update_count = n;
                                                        l.updateComplete(n);
                                                    }
                                                    catch (Throwable e) {
                                                        Debug.out(e);
                                                    }
                                                }
                                            }
                                            finally {
                                                sem.release();
                                            }
                                            return;
                                        }
                                        if (display.getActiveShell() != null) break block47;
                                        Shell[] shells = display.getShells();
                                        boolean noneVisible = true;
                                        int i = 0;
                                        while (i < shells.length) {
                                            if (shells[i].isVisible() && !shells[i].getMinimized()) {
                                                noneVisible = false;
                                                break;
                                            }
                                            ++i;
                                        }
                                        if (!noneVisible) break block48;
                                        if (UIUpdaterSWT.this.alwaysUpdateables.size() <= 0) break block49;
                                        UIUpdaterSWT.this.update(UIUpdaterSWT.this.alwaysUpdateables, false);
                                    }
                                    try {
                                        for (UIUpdater.UIUpdaterListener l : UIUpdaterSWT.this.listeners) {
                                            try {
                                                UIUpdaterSWT uIUpdaterSWT = UIUpdaterSWT.this;
                                                int n = uIUpdaterSWT.update_count + 1;
                                                uIUpdaterSWT.update_count = n;
                                                l.updateComplete(n);
                                            }
                                            catch (Throwable e) {
                                                Debug.out(e);
                                            }
                                        }
                                    }
                                    finally {
                                        sem.release();
                                    }
                                    return;
                                }
                                UIUpdaterSWT uIUpdaterSWT = UIUpdaterSWT.this;
                                int n = uIUpdaterSWT.inactiveTicks;
                                uIUpdaterSWT.inactiveTicks = n + 1;
                                if (n % UIUpdaterSWT.this.inactiveFactor == 0) break block47;
                                try {
                                    for (UIUpdater.UIUpdaterListener l : UIUpdaterSWT.this.listeners) {
                                        try {
                                            UIUpdaterSWT uIUpdaterSWT2 = UIUpdaterSWT.this;
                                            int n2 = uIUpdaterSWT2.update_count + 1;
                                            uIUpdaterSWT2.update_count = n2;
                                            l.updateComplete(n2);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                }
                                finally {
                                    sem.release();
                                }
                                return;
                            }
                            try {
                                try {
                                    UIUpdaterSWT.this.update(UIUpdaterSWT.this.updateables, true);
                                    break block52;
                                }
                                catch (Exception e) {
                                    Logger.log(new LogEvent(LOGID, "Error while trying to update GUI", e));
                                    try {
                                        for (UIUpdater.UIUpdaterListener l : UIUpdaterSWT.this.listeners) {
                                            try {
                                                UIUpdaterSWT uIUpdaterSWT = UIUpdaterSWT.this;
                                                int n = uIUpdaterSWT.update_count + 1;
                                                uIUpdaterSWT.update_count = n;
                                                l.updateComplete(n);
                                            }
                                            catch (Throwable e2) {
                                                Debug.out(e2);
                                            }
                                        }
                                        break block53;
                                    }
                                    finally {
                                        sem.release();
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    for (UIUpdater.UIUpdaterListener l : UIUpdaterSWT.this.listeners) {
                                        try {
                                            UIUpdaterSWT uIUpdaterSWT = UIUpdaterSWT.this;
                                            int n = uIUpdaterSWT.update_count + 1;
                                            uIUpdaterSWT.update_count = n;
                                            l.updateComplete(n);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                }
                                finally {
                                    sem.release();
                                }
                            }
                            throw throwable;
                        }
                        try {
                            for (UIUpdater.UIUpdaterListener l : UIUpdaterSWT.this.listeners) {
                                try {
                                    UIUpdaterSWT uIUpdaterSWT = UIUpdaterSWT.this;
                                    int n = uIUpdaterSWT.update_count + 1;
                                    uIUpdaterSWT.update_count = n;
                                    l.updateComplete(n);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                        finally {
                            sem.release();
                        }
                    }
                }

                @Override
                public void runNoDisplay() {
                    sem.release();
                }
            });
            long start = SystemTime.getHighPrecisionCounter();
            sem.reserve();
            long elapsed = SystemTime.getHighPrecisionCounter() - start;
            long to_sleep = (long)this.waitTimeMS - elapsed / 1000000L;
            if (to_sleep < 10L) {
                to_sleep = 10L;
            } else if (to_sleep > 25000L) {
                to_sleep = 25000L;
            }
            try {
                Thread.sleep(to_sleep);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void parameterChanged(String parameterName) {
        this.waitTimeMS = COConfigurationManager.getIntParameter(CFG_REFRESH_INTERVAL);
        this.inactiveFactor = COConfigurationManager.getIntParameter(CFG_REFRESH_INACTIVE_FACTOR);
        if (this.inactiveFactor == 0) {
            this.inactiveFactor = 1;
        }
    }

    @Override
    public void addUpdater(UIUpdatable updateable) {
        this.updateables_mon.enter();
        try {
            if (updateable instanceof UIUpdatableAlways && !this.alwaysUpdateables.contains(updateable)) {
                this.alwaysUpdateables.add(updateable);
            }
            if (!this.updateables.contains(updateable)) {
                this.updateables.add(updateable);
                if (DEBUG_UPDATEABLES) {
                    this.debug_Updateables.put(updateable, String.valueOf(Debug.getCompressedStackTrace()) + "\n");
                }
            } else if (DEBUG_UPDATEABLES) {
                System.out.println("WARNING: already added UIUpdatable " + updateable + "\n\t" + this.debug_Updateables.get(updateable) + "\t" + Debug.getCompressedStackTrace());
            } else {
                System.out.println("WARNING: already added UIUpdatable " + updateable);
            }
        }
        finally {
            this.updateables_mon.exit();
        }
    }

    @Override
    public boolean isAdded(UIUpdatable updateable) {
        this.updateables_mon.enter();
        try {
            boolean bl = this.updateables.contains(updateable);
            return bl;
        }
        finally {
            this.updateables_mon.exit();
        }
    }

    @Override
    public void removeUpdater(UIUpdatable updateable) {
        this.updateables_mon.enter();
        try {
            this.updateables.remove(updateable);
            if (updateable instanceof UIUpdatableAlways) {
                this.alwaysUpdateables.remove(updateable);
            }
        }
        finally {
            this.updateables_mon.exit();
        }
    }

    @Override
    public void stopIt() {
        this.finished = true;
        COConfigurationManager.removeParameterListener(CFG_REFRESH_INTERVAL, this);
        COConfigurationManager.removeParameterListener(CFG_REFRESH_INACTIVE_FACTOR, this);
    }

    private void update(CopyOnWriteList<UIUpdatable> updateables, boolean is_visible) {
        long start = 0L;
        HashMap<UIUpdatable, Long> mapTimeMap = DEBUG_TIMER ? new HashMap<UIUpdatable, Long>() : null;
        Display display = Utils.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        boolean enabled = Utils.isUIUpdateEnabled();
        for (UIUpdatable updateable : updateables) {
            try {
                long diff;
                if (DEBUG_TIMER) {
                    start = SystemTime.getCurrentTime();
                }
                if (updateable instanceof UIUpdatableAlways) {
                    ((UIUpdatableAlways)updateable).updateUI(is_visible);
                } else if (enabled) {
                    updateable.updateUI();
                }
                if (!DEBUG_TIMER || (diff = SystemTime.getCurrentTime() - start) <= 0L) continue;
                mapTimeMap.put(updateable, new Long(diff));
            }
            catch (Throwable t) {
                Logger.log(new LogEvent(LOGID, "Error while trying to update UI Element " + updateable.getUpdateUIName(), t));
            }
        }
        if (DEBUG_TIMER) {
            this.makeDebugToolTip(mapTimeMap);
        }
    }

    private void makeDebugToolTip(Map<UIUpdatable, Long> timeMap) {
        IMainStatusBar mainStatusBar;
        boolean IDX_AVG = false;
        boolean IDX_SIZE = true;
        int IDX_MAX = 2;
        int IDX_LAST = 3;
        int IDX_TIME = 4;
        long ttl = 0L;
        for (UIUpdatable key : timeMap.keySet()) {
            if (!this.averageTimes.containsKey(key)) {
                this.averageTimes.put(key, new Long[]{0L, 0L, 0L, 0L, System.currentTimeMillis()});
            }
            Long[] average = this.averageTimes.get(key);
            long diff = timeMap.get(key);
            if (diff > 0L) {
                long count = average[1];
                if (count >= 20L) {
                    count = 19L;
                }
                long lNewAverage = (average[0] * count + diff) / (count + 1L);
                average[0] = lNewAverage;
                average[1] = count + 1L;
                if (diff > average[2]) {
                    average[2] = diff;
                }
                average[3] = diff;
                average[4] = System.currentTimeMillis();
            } else {
                average[3] = diff;
            }
            ttl += diff;
            this.averageTimes.put(key, average);
        }
        UIFunctionsSWT uiFunctionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
        IMainStatusBar iMainStatusBar = mainStatusBar = uiFunctionsSWT == null ? null : uiFunctionsSWT.getMainStatusBar();
        if (mainStatusBar != null && mainStatusBar.isMouseOver()) {
            StringBuilder sb = new StringBuilder();
            Iterator<UIUpdatable> iter = this.averageTimes.keySet().iterator();
            while (iter.hasNext()) {
                UIUpdatable key = iter.next();
                Object[] average = this.averageTimes.get(key);
                long lLastUpdated = (Long)average[4];
                if (System.currentTimeMillis() - lLastUpdated > 10000L) {
                    iter.remove();
                    continue;
                }
                long lTime = (Long)average[0];
                if (lTime <= 0L) continue;
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(lTime * 100L / (long)this.waitTimeMS);
                sb.append("% ");
                sb.append(lTime).append("ms avg: ");
                sb.append("[").append(key.getUpdateUIName()).append("]");
                sb.append(average[1]).append(" samples");
                sb.append("; max:").append(average[2]);
                sb.append("; last:").append(average[3]);
            }
            mainStatusBar.setDebugInfo(sb.toString());
        }
    }

    @Override
    public void addListener(UIUpdater.UIUpdaterListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(UIUpdater.UIUpdaterListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPeriodicUpdater(UIUpdatable updateable) {
        CopyOnWriteList<UIUpdatable> copyOnWriteList = this.perioidic_updateables;
        synchronized (copyOnWriteList) {
            this.perioidic_updateables.add(updateable);
            if (this.perioidic_updateables.size() == 1) {
                final int fpu = ++this.pu_counter;
                new AEThread2("pu"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    @Override
                    public void run() {
                        block7: while (true) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Throwable var1_2) {
                                // empty catch block
                            }
                            var1_1 = UIUpdaterSWT.access$11(UIUpdaterSWT.this);
                            synchronized (var1_1) {
                                if (UIUpdaterSWT.access$12(UIUpdaterSWT.this) != fpu) {
                                    break;
                                }
                            }
                            if (!Utils.isUIUpdateEnabled()) continue;
                            var2_3 = UIUpdaterSWT.access$11(UIUpdaterSWT.this).iterator();
                            while (true) {
                                if (var2_3.hasNext()) ** break;
                                continue block7;
                                u = (UIUpdatable)var2_3.next();
                                try {
                                    u.updateUI();
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                            break;
                        }
                    }
                }.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePeriodicUpdater(UIUpdatable updateable) {
        CopyOnWriteList<UIUpdatable> copyOnWriteList = this.perioidic_updateables;
        synchronized (copyOnWriteList) {
            this.perioidic_updateables.remove(updateable);
            if (this.perioidic_updateables.isEmpty()) {
                ++this.pu_counter;
            }
        }
    }

    static /* synthetic */ CopyOnWriteList access$11(UIUpdaterSWT uIUpdaterSWT) {
        return uIUpdaterSWT.perioidic_updateables;
    }

    static /* synthetic */ int access$12(UIUpdaterSWT uIUpdaterSWT) {
        return uIUpdaterSWT.pu_counter;
    }
}

