/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.update;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.swt.BrowserWrapper;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FullUpdateWindow {
    static Shell current_shell = null;
    static BrowserWrapper.BrowserFunction browserFunction;

    public static void handleUpdate(final String url, final UIFunctions.actionListener listener) {
        try {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    FullUpdateWindow.open(url, listener);
                }
            });
        }
        catch (Throwable e) {
            Debug.out(e);
            listener.actionComplete(false);
        }
    }

    public static void open(String url, final UIFunctions.actionListener listener) {
        boolean ok = false;
        final boolean[] listener_informed = new boolean[1];
        try {
            if (current_shell != null && !current_shell.isDisposed()) {
                return;
            }
            final Shell parentShell = Utils.findAnyShell();
            current_shell = ShellFactory.createShell(parentShell, 67696);
            final Shell shell = current_shell;
            if (shell == null) {
                return;
            }
            shell.setLayout((Layout)new FillLayout());
            if (parentShell != null) {
                parentShell.setCursor(shell.getDisplay().getSystemCursor(1));
            }
            shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    try {
                        if (parentShell != null) {
                            parentShell.setCursor(e.display.getSystemCursor(0));
                        }
                        if (browserFunction != null && !browserFunction.isDisposed()) {
                            browserFunction.dispose();
                        }
                        current_shell = null;
                    }
                    finally {
                        if (!listener_informed[0]) {
                            try {
                                listener.actionComplete(false);
                            }
                            catch (Throwable f) {
                                Debug.out(f);
                            }
                        }
                    }
                }
            });
            BrowserWrapper browser = Utils.createSafeBrowser((Composite)shell, 0);
            if (browser == null) {
                shell.dispose();
                return;
            }
            browser.addTitleListener(new TitleListener(){

                public void changed(TitleEvent event2) {
                    if (shell.isDisposed()) {
                        return;
                    }
                    shell.setText(event2.title);
                }
            });
            browser.addOpenWindowListener(new BrowserWrapper.OpenWindowListener(){

                @Override
                public void open(BrowserWrapper.WindowEvent event2) {
                    final BrowserWrapper subBrowser = Utils.createSafeBrowser((Composite)shell, 0);
                    if (subBrowser == null) {
                        return;
                    }
                    subBrowser.addLocationListener(new LocationListener(){

                        public void changed(LocationEvent arg0) {
                        }

                        public void changing(LocationEvent event2) {
                            if (event2.location == null || !event2.location.startsWith("http")) {
                                return;
                            }
                            event2.doit = false;
                            Utils.launch(event2.location);
                            Utils.execSWTThreadLater(1000, new AERunnable(){

                                @Override
                                public void runSupport() {
                                    subBrowser.dispose();
                                }
                            });
                        }
                    });
                    subBrowser.setBrowser(event2);
                }
            });
            browserFunction = browser.addBrowserFunction("sendVuzeUpdateEvent", new BrowserWrapper.BrowserFunction(){
                private String last = null;

                @Override
                public Object function(Object[] arguments) {
                    if (shell.isDisposed()) {
                        return null;
                    }
                    if (arguments == null) {
                        Debug.out("Invalid sendVuzeUpdateEvent null ");
                        return null;
                    }
                    if (arguments.length < 1) {
                        Debug.out("Invalid sendVuzeUpdateEvent length " + arguments.length + " not 1");
                        return null;
                    }
                    if (!(arguments[0] instanceof String)) {
                        Debug.out("Invalid sendVuzeUpdateEvent " + (arguments[0] == null ? "NULL" : arguments.getClass().getSimpleName()) + " not String");
                        return null;
                    }
                    String text = ((String)arguments[0]).toLowerCase();
                    if (this.last != null && this.last.equals(text)) {
                        return null;
                    }
                    this.last = text;
                    if (text.contains("page-loaded")) {
                        Utils.centreWindow(shell);
                        if (parentShell != null) {
                            parentShell.setCursor(shell.getDisplay().getSystemCursor(0));
                        }
                        shell.open();
                    } else if (text.startsWith("set-size")) {
                        String[] strings = text.split(" ");
                        if (strings.length > 2) {
                            try {
                                int w = Integer.parseInt(strings[1]);
                                int h = Integer.parseInt(strings[2]);
                                Rectangle computeTrim = shell.computeTrim(0, 0, w, h);
                                shell.setSize(computeTrim.width, computeTrim.height);
                            }
                            catch (Exception exception) {}
                        }
                    } else if (text.contains("decline") || text.contains("close")) {
                        Utils.execSWTThreadLater(0, new AERunnable(){

                            @Override
                            public void runSupport() {
                                shell.dispose();
                            }
                        });
                    } else if (text.contains("accept")) {
                        Utils.execSWTThreadLater(0, new AERunnable(){

                            @Override
                            public void runSupport() {
                                listener_informed[0] = true;
                                try {
                                    listener.actionComplete(true);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                                shell.dispose();
                            }
                        });
                    }
                    return null;
                }
            });
            browser.addStatusTextListener(new StatusTextListener(){

                public void changed(StatusTextEvent event2) {
                    if (browserFunction != null) {
                        browserFunction.function(new Object[]{event2.text});
                    }
                }
            });
            browser.addLocationListener(new LocationListener(){

                public void changing(LocationEvent event2) {
                }

                public void changed(LocationEvent event2) {
                }
            });
            String final_url = String.valueOf(url) + (url.indexOf(63) == -1 ? "?" : "&") + "locale=" + MessageText.getCurrentLocale().toString() + "&azv=" + "3.9.0.0";
            SimpleTimer.addEvent("fullupdate.pageload", SystemTime.getOffsetTime(5000L), new TimerEventPerformer(){

                @Override
                public void perform(TimerEvent event2) {
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            if (!shell.isDisposed()) {
                                shell.open();
                            }
                        }
                    });
                }
            });
            browser.setUrl(final_url);
            if (browser.isFake()) {
                shell.setSize(400, 500);
                Utils.centreWindow(shell);
                browser.setUrl("https://www.biglybt.com/");
                browser.setText("Update available, please go to www.biglybt.com to update.");
                shell.open();
            }
            ok = true;
        }
        finally {
            if (!ok) {
                try {
                    listener.actionComplete(false);
                }
                catch (Throwable f) {
                    Debug.out(f);
                }
            }
        }
    }
}

