/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.updater2;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.update.UpdatableComponent;
import com.biglybt.pif.update.Update;
import com.biglybt.pif.update.UpdateCheckInstance;
import com.biglybt.pif.update.UpdateChecker;
import com.biglybt.pif.update.UpdateInstaller;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderAdapter;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderException;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderFactory;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import com.biglybt.ui.swt.updater2.SWTVersionGetter;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.swt.SWT;

public class SWTUpdateChecker
implements UpdatableComponent {
    private static final LogIDs LOGID = LogIDs.GUI;
    public static final String RES_EXPLICIT_FILE = "SWTUpdateChecker.explicit";

    public static void initialize() {
        PluginInitializer.getDefaultInterface().getUpdateManager().registerUpdatableComponent(new SWTUpdateChecker(), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkForUpdate(final UpdateChecker checker) {
        try {
            int update_prevented_revision;
            int update_prevented_version;
            String[] update_desc;
            String update_name;
            SWTVersionGetter versionGetter;
            ResourceDownloaderFactory factory;
            block27: {
                factory = ResourceDownloaderFactoryImpl.getSingleton();
                versionGetter = new SWTVersionGetter(checker);
                String extra = "";
                if (Constants.isWindows && Constants.is64Bit) {
                    extra = " (64-bit)";
                }
                update_name = "SWT Library for " + versionGetter.getPlatform() + extra;
                update_desc = new String[]{"SWT is the graphical library used by " + Constants.APP_NAME};
                UpdateCheckInstance check_inst = checker.getCheckInstance();
                Map overrides = (Map)check_inst.getProperty(7);
                if (overrides != null && overrides.containsKey(RES_EXPLICIT_FILE)) {
                    File file = (File)overrides.get(RES_EXPLICIT_FILE);
                    ResourceDownloader rd = factory.create(file);
                    final Update update = checker.addUpdate(update_name, update_desc, versionGetter.getCurrentVersionAndRevision(), "explicit", rd, 2);
                    rd.addListener(new ResourceDownloaderAdapter(){

                        @Override
                        public boolean completed(ResourceDownloader downloader, InputStream data) {
                            return SWTUpdateChecker.this.processData(checker, update, downloader, data);
                        }

                        @Override
                        public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
                            Debug.out(String.valueOf(downloader.getName()) + " failed", e);
                            update.complete(false);
                        }
                    });
                    return;
                }
                boolean update_required = System.getProperty(SystemProperties.SYSPROP_SKIP_SWTCHECK) == null && versionGetter.needsUpdate();
                if (!update_required) return;
                update_prevented_version = COConfigurationManager.getIntParameter("swt.update.prevented.version", -1);
                update_prevented_revision = COConfigurationManager.getIntParameter("swt.update.prevented.revision", -1);
                try {
                    boolean force;
                    String url_str;
                    URL swt_url = SWT.class.getClassLoader().getResource("org/eclipse/swt/SWT.class");
                    if (swt_url == null || !(url_str = swt_url.toExternalForm()).startsWith("jar:file:")) break block27;
                    File jar_file = FileUtil.getJarFileFromURL(url_str);
                    File expected_dir = new File(checker.getCheckInstance().getManager().getInstallDir());
                    File jar_file_dir = jar_file.getParentFile();
                    if (!expected_dir.exists() || !jar_file_dir.exists()) break block27;
                    expected_dir = expected_dir.getCanonicalFile();
                    jar_file_dir = jar_file_dir.getCanonicalFile();
                    if (Constants.isUnix) {
                        if (expected_dir.equals(jar_file_dir)) {
                            return;
                        }
                        expected_dir = new File(expected_dir, "swt");
                    }
                    if (expected_dir.equals(jar_file_dir) || FileUtil.isAncestorOf(expected_dir, jar_file_dir)) {
                        if (update_prevented_version != -1) {
                            update_prevented_version = -1;
                            update_prevented_revision = -1;
                            COConfigurationManager.setParameter("swt.update.prevented.version", update_prevented_version);
                            COConfigurationManager.setParameter("swt.update.prevented.revision", update_prevented_revision);
                        }
                        break block27;
                    }
                    String alert = MessageText.getString("swt.alert.cant.update", new String[]{versionGetter.getCurrentVersionAndRevision(), versionGetter.getLatestVersionAndRevision(), jar_file_dir.toString(), expected_dir.toString()});
                    checker.reportProgress(alert);
                    long last_prompt = COConfigurationManager.getLongParameter("swt.update.prevented.version.time", 0L);
                    long now = SystemTime.getCurrentTime();
                    boolean bl = force = now < last_prompt || now - last_prompt > 604800000L;
                    if (!checker.getCheckInstance().isAutomatic()) {
                        force = true;
                    }
                    if (force || update_prevented_version != versionGetter.getCurrentVersion() || update_prevented_version == versionGetter.getCurrentVersion() && update_prevented_revision != versionGetter.getCurrentRevision()) {
                        Logger.log(new LogAlert(true, 3, alert));
                        update_prevented_version = versionGetter.getCurrentVersion();
                        update_prevented_revision = versionGetter.getCurrentRevision();
                        COConfigurationManager.setParameter("swt.update.prevented.version", update_prevented_version);
                        COConfigurationManager.setParameter("swt.update.prevented.revision", update_prevented_revision);
                        COConfigurationManager.setParameter("swt.update.prevented.version.time", now);
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            if (update_prevented_version == versionGetter.getCurrentVersion() && update_prevented_revision == versionGetter.getCurrentRevision()) {
                String err = "SWT update aborted due to previously reported issues regarding its install location";
                Logger.log(new LogEvent(LOGID, 3, err));
                checker.setFailed(new Exception(err));
                checker.getCheckInstance().cancel();
                return;
            }
            String[] mirrors = versionGetter.getMirrors();
            ResourceDownloader swtDownloader = null;
            ArrayList<ResourceDownloader> downloaders = new ArrayList<ResourceDownloader>();
            int i = 0;
            while (i < mirrors.length) {
                block28: {
                    try {
                        downloaders.add(factory.getSuffixBasedDownloader(factory.create(new URL(mirrors[i]))));
                    }
                    catch (MalformedURLException e) {
                        if (!Logger.isEnabled()) break block28;
                        Logger.log(new LogEvent(LOGID, 1, "Cannot use URL " + mirrors[i] + " (not valid)"));
                    }
                }
                ++i;
            }
            i = 0;
            while (i < mirrors.length) {
                try {
                    downloaders.add(factory.getSuffixBasedDownloader(factory.createWithAutoPluginProxy(new URL(mirrors[i]))));
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                ++i;
            }
            ResourceDownloader[] resourceDownloaders = downloaders.toArray(new ResourceDownloader[downloaders.size()]);
            swtDownloader = factory.getAlternateDownloader(resourceDownloaders);
            try {
                swtDownloader.getSize();
            }
            catch (ResourceDownloaderException e) {
                Debug.printStackTrace(e);
            }
            final Update update = checker.addUpdate(update_name, update_desc, versionGetter.getCurrentVersionAndRevision(), versionGetter.getLatestVersionAndRevision(), swtDownloader, 2);
            update.setDescriptionURL(versionGetter.getInfoURL());
            swtDownloader.addListener(new ResourceDownloaderAdapter(){

                @Override
                public boolean completed(ResourceDownloader downloader, InputStream data) {
                    return SWTUpdateChecker.this.processData(checker, update, downloader, data);
                }

                @Override
                public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
                    Debug.out(String.valueOf(downloader.getName()) + " failed", e);
                    update.complete(false);
                }
            });
            return;
        }
        catch (Throwable e) {
            String err = "SWT Version check failed";
            Logger.log(new LogAlert(false, err, e));
            checker.setFailed(new Exception(err, e));
            return;
        }
        finally {
            checker.completed();
        }
    }

    private boolean processData(UpdateChecker checker, Update update, ResourceDownloader rd, InputStream data) {
        ZipInputStream zip = null;
        try {
            try {
                data = update.verifyData(data, true);
                rd.reportActivity("Data verified successfully");
                UpdateInstaller installer = checker.createInstaller();
                zip = new ZipInputStream(data);
                ZipEntry entry = null;
                while ((entry = zip.getNextEntry()) != null) {
                    String name = entry.getName();
                    if (name.endsWith(".jar")) {
                        installer.addResource(name, zip, false);
                        if (Constants.isUnix) {
                            installer.addMoveAction(name, String.valueOf(installer.getInstallDir()) + File.separator + "swt" + File.separator + name);
                            continue;
                        }
                        installer.addMoveAction(name, String.valueOf(installer.getInstallDir()) + File.separator + name);
                        continue;
                    }
                    if (name.endsWith(".jnilib") && Constants.isOSX) {
                        installer.addResource(name, zip, false);
                        installer.addMoveAction(name, String.valueOf(installer.getInstallDir()) + "/dll/" + name);
                        continue;
                    }
                    if (name.endsWith(".dll") || name.endsWith(".so") || name.contains(".so.")) {
                        installer.addResource(name, zip, false);
                        installer.addMoveAction(name, String.valueOf(installer.getInstallDir()) + File.separator + name);
                        continue;
                    }
                    if (name.equals("javaw.exe.manifest") || name.equals("azureus.sig")) continue;
                    Debug.outNoStack("SWTUpdate: ignoring zip entry '" + name + "'");
                }
                update.complete(true);
            }
            catch (Throwable e) {
                update.complete(false);
                Logger.log(new LogAlert(false, "SWT Update failed", e));
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return "SWT library";
    }

    @Override
    public int getMaximumCheckTime() {
        return 30;
    }
}

