/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.utils;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagException;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinCheckboxListener;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectCheckbox;
import com.biglybt.ui.swt.skin.SWTSkinObjectCombo;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinObjectTextbox;
import com.biglybt.ui.swt.views.skin.SkinnedDialog;
import com.biglybt.ui.swt.views.skin.StandardButtonsArea;
import com.biglybt.ui.swt.views.utils.TagButtonsUI;
import com.biglybt.ui.swt.widgets.TagCanvas;
import com.biglybt.ui.swt.widgets.TagPainter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TagUIUtilsV3 {
    public static void showCreateTagDialog(final UIFunctions.TagReturner tagReturner) {
        SWTSkinObject soButtonArea;
        final SkinnedDialog dialog = new SkinnedDialog("skin3_dlg_addtag", "shell", 2144);
        SWTSkin skin = dialog.getSkin();
        final SWTSkinObjectTextbox tb = (SWTSkinObjectTextbox)skin.getSkinObject("tag-name");
        final SWTSkinObjectCheckbox cb = (SWTSkinObjectCheckbox)skin.getSkinObject("tag-share");
        final SWTSkinObjectCheckbox ss = (SWTSkinObjectCheckbox)skin.getSkinObject("tag-customize");
        if (tb == null || cb == null) {
            return;
        }
        SWTSkinObjectContainer soGroupBox = (SWTSkinObjectContainer)skin.getSkinObject("tag-group-area");
        final SWTSkinObjectCombo soGroup = (SWTSkinObjectCombo)skin.getSkinObject("tag-group");
        if (soGroupBox != null && soGroup != null) {
            List<String> listGroups = new ArrayList<String>();
            TagManager tagManager = TagManagerFactory.getTagManager();
            TagType tt = tagManager.getTagType(3);
            List<Tag> tags = tt.getTags();
            for (Tag tag : tags) {
                String group = tag.getGroup();
                if (group == null || group.length() <= 0 || listGroups.contains(group)) continue;
                listGroups.add(group);
            }
            soGroupBox.setVisible((listGroups = TagUtils.sortTagGroups(listGroups)).size() > 0);
            soGroup.setList(listGroups.toArray(new String[0]));
        }
        cb.setChecked(COConfigurationManager.getBooleanParameter("tag.sharing.default.checked"));
        cb.addSelectionListener(new SWTSkinCheckboxListener(){

            @Override
            public void checkboxChanged(SWTSkinObjectCheckbox so, boolean checked) {
                COConfigurationManager.setParameter("tag.sharing.default.checked", checked);
            }
        });
        if (ss != null) {
            ss.setChecked(COConfigurationManager.getBooleanParameter("tag.add.customize.default.checked"));
            ss.addSelectionListener(new SWTSkinCheckboxListener(){

                @Override
                public void checkboxChanged(SWTSkinObjectCheckbox so, boolean checked) {
                    COConfigurationManager.setParameter("tag.add.customize.default.checked", checked);
                }
            });
        }
        if ((soButtonArea = skin.getSkinObject("bottom-area")) instanceof SWTSkinObjectContainer) {
            StandardButtonsArea buttonsArea = new StandardButtonsArea(){

                @Override
                protected void clicked(int buttonValue) {
                    if (buttonValue == 32) {
                        String tag_name = tb.getText().trim();
                        TagType tt = TagManagerFactory.getTagManager().getTagType(3);
                        Tag tag = tt.getTag(tag_name, true);
                        if (tag == null) {
                            try {
                                String group;
                                tag = tt.createTag(tag_name, false);
                                tag.setPublic(cb.isChecked());
                                if (soGroup != null && (group = soGroup.getText()) != null && group.length() > 0) {
                                    tag.setGroup(group);
                                }
                                tt.addTag(tag);
                            }
                            catch (TagException e) {
                                Debug.out(e);
                            }
                        }
                        if (tagReturner != null && tag != null) {
                            tagReturner.returnedTags(new Tag[]{tag});
                        }
                        if (ss.isChecked()) {
                            tag.setTransientProperty("Settings Requested", true);
                            UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("TagsOverview");
                        }
                    }
                    dialog.close();
                }
            };
            buttonsArea.setButtonIDs(new String[]{MessageText.getString("Button.add"), MessageText.getString("Button.cancel")});
            buttonsArea.setButtonVals(new Integer[]{32, 256});
            buttonsArea.swt_createButtons(((SWTSkinObjectContainer)soButtonArea).getComposite());
        }
        dialog.open();
    }

    public static void showManualTagSelectionDialog(TagSelectionListener listener) {
        TagManager tagManager = TagManagerFactory.getTagManager();
        TagType tt = tagManager.getTagType(3);
        ArrayList<Tag> all_tags = new ArrayList<Tag>(tt.getTags());
        TagUIUtilsV3.showTagSelectionDialog(all_tags, Collections.emptyList(), listener);
    }

    public static void showTagSelectionDialog(List<Tag> tags, List<Tag> selected_tags, TagSelectionListener listener) {
        TagUIUtilsV3.showTagSelectionDialog(tags, selected_tags, true, listener);
    }

    public static void showTagSelectionDialog(List<Tag> tags, List<Tag> selected_tags, boolean disable_auto, final TagSelectionListener listener) {
        final SkinnedDialog dialog = new SkinnedDialog("skin3_dlg_selecttags", "shell", 2160);
        SWTSkin skin = dialog.getSkin();
        SWTSkinObject so = skin.getSkinObject("main-area");
        if (so instanceof SWTSkinObjectContainer) {
            Composite main = ((SWTSkinObjectContainer)so).getComposite();
            main.setLayout((Layout)new GridLayout(1, true));
            Composite comp2 = Utils.createScrolledComposite(main);
            comp2.setLayout((Layout)new FillLayout());
            comp2.setLayoutData((Object)new GridData(1808));
            final TagButtonsUI tagButtonsUI = new TagButtonsUI();
            tagButtonsUI.setDisableAuto(disable_auto);
            tagButtonsUI.buildTagGroup(tags, comp2, false, new TagCanvas.TagButtonTrigger(){

                @Override
                public Boolean tagSelectedOverride(Tag tag) {
                    return null;
                }

                @Override
                public void tagButtonTriggered(TagPainter painter, int stateMask, boolean longPress) {
                    boolean doTag = !painter.isSelected();
                    painter.setSelected(doTag);
                }
            });
            tagButtonsUI.setSelectedTags(selected_tags);
            SWTSkinObject soButtonArea = skin.getSkinObject("bottom-area");
            if (soButtonArea instanceof SWTSkinObjectContainer) {
                StandardButtonsArea buttonsArea = new StandardButtonsArea(){

                    @Override
                    protected void clicked(int buttonValue) {
                        if (buttonValue == 32) {
                            listener.selected(tagButtonsUI.getSelectedTags());
                        }
                        dialog.close();
                    }
                };
                buttonsArea.setButtonIDs(new String[]{MessageText.getString("Button.ok"), MessageText.getString("Button.cancel")});
                buttonsArea.setButtonVals(new Integer[]{32, 256});
                buttonsArea.swt_createButtons(((SWTSkinObjectContainer)soButtonArea).getComposite());
            }
        }
        dialog.open("skin3_dlg_selecttags", true);
    }

    public static interface TagSelectionListener {
        public void selected(List<Tag> var1);
    }
}

