/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.pif.download.DownloadStub;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableDataSourceChangedListener;
import com.biglybt.ui.common.table.TableLifeCycleListener;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.TableViewSWTMenuFillListener;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import com.biglybt.ui.swt.views.table.impl.TableViewTab;
import com.biglybt.ui.swt.views.tableitems.archivedfiles.NameItem;
import com.biglybt.ui.swt.views.tableitems.archivedfiles.SizeItem;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class ArchivedFilesView
extends TableViewTab<DownloadStub.DownloadStubFile>
implements TableLifeCycleListener,
TableDataSourceChangedListener,
TableViewSWTMenuFillListener {
    private static final String TABLE_ID = "ArchivedFiles";
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem("ArchivedFiles"), new SizeItem("ArchivedFiles")};
    public static final String MSGID_PREFIX = "ArchivedFilesView";
    private TableViewSWT<DownloadStub.DownloadStubFile> tv;
    private DownloadStub current_download;

    static {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.setDefaultColumnNames(TABLE_ID, basicItems);
    }

    public ArchivedFilesView() {
        super(MSGID_PREFIX);
    }

    @Override
    public TableViewSWT<DownloadStub.DownloadStubFile> initYourTableView() {
        this.tv = TableViewFactory.createTableViewSWT(DownloadStub.DownloadStubFile.class, TABLE_ID, this.getTextPrefixID(), basicItems, basicItems[0].getName(), 0x10010002);
        this.tv.addLifeCycleListener(this);
        this.tv.addMenuFillListener(this);
        this.tv.addTableDataSourceChangedListener(this, true);
        return this.tv;
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        List<Object> ds = this.tv.getSelectedDataSources();
        final ArrayList<DownloadStub.DownloadStubFile> files = new ArrayList<DownloadStub.DownloadStubFile>();
        for (Object o : ds) {
            files.add((DownloadStub.DownloadStubFile)o);
        }
        boolean hasSelection = files.size() > 0;
        final boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
        MenuItem itemExplore = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemExplore, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"));
        itemExplore.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                for (DownloadStub.DownloadStubFile file : files) {
                    ManagerUtils.open(new File(file.getFile().getAbsolutePath()), use_open_containing_folder);
                }
            }
        });
        itemExplore.setEnabled(hasSelection);
        new MenuItem(menu, 2);
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
        if (columnName.equals("name")) {
            new MenuItem(menuThisColumn, 2);
            final MenuItem path_item = new MenuItem(menuThisColumn, 32);
            boolean show_full_path = COConfigurationManager.getBooleanParameter("ArchivedFilesView.show.full.path");
            path_item.setSelection(show_full_path);
            Messages.setLanguageText((Widget)path_item, "FilesView.menu.showfullpath");
            path_item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    boolean show_full_path = path_item.getSelection();
                    ArchivedFilesView.this.tv.columnInvalidate("name");
                    ArchivedFilesView.this.tv.refreshTable(false);
                    COConfigurationManager.setParameter("ArchivedFilesView.show.full.path", show_full_path);
                }
            });
        }
    }

    @Override
    public void tableDataSourceChanged(Object ds) {
        if (ds == this.current_download) {
            this.tv.setEnabled(ds != null);
            return;
        }
        boolean enabled = true;
        if (ds instanceof DownloadStub) {
            this.current_download = (DownloadStub)ds;
        } else if (ds instanceof Object[]) {
            Object[] objs = (Object[])ds;
            if (objs.length != 1) {
                enabled = false;
            } else {
                DownloadStub stub = (DownloadStub)objs[0];
                if (stub == this.current_download) {
                    return;
                }
                this.current_download = stub;
            }
        } else {
            this.current_download = null;
            enabled = false;
        }
        if (!this.tv.isDisposed()) {
            this.tv.removeAllTableRows();
            this.tv.setEnabled(enabled);
            if (enabled && this.current_download != null) {
                this.addExistingDatasources();
            }
        }
    }

    @Override
    public void tableLifeCycleEventOccurred(TableView tv, int eventType, Map<String, Object> data) {
        switch (eventType) {
            case 0: {
                if (this.current_download != null) {
                    this.addExistingDatasources();
                    break;
                }
                this.tv.setEnabled(false);
            }
        }
    }

    private void addExistingDatasources() {
        if (this.current_download == null || this.tv.isDisposed()) {
            return;
        }
        DownloadStub.DownloadStubFile[] files = this.current_download.getStubFiles();
        this.tv.addDataSources((DownloadStub.DownloadStubFile[])files);
        this.tv.processDataSourceQueueSync();
    }
}

