/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.core.util.average.AverageFactory;
import com.biglybt.core.util.average.MovingImmediateAverage;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo2;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.selectedcontent.SelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.Legend;
import com.biglybt.ui.swt.components.graphics.MultiPlotGraphic;
import com.biglybt.ui.swt.components.graphics.ValueFormater;
import com.biglybt.ui.swt.components.graphics.ValueSource;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mdi.MdiSWTMenuHackListener;
import com.biglybt.ui.swt.mdi.TabbedEntry;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.views.ViewUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class DownloadActivityView
implements UISWTViewCoreEventListener,
UIPluginViewToolBarListener,
MdiSWTMenuHackListener,
ParameterListener,
ViewTitleInfo2 {
    public static final String MSGID_PREFIX = "DownloadActivityView";
    private static Color[] mpg_colors = new Color[]{Colors.fadedGreen, Colors.fadedGreen, Colors.blues[9], Colors.blues[9], Colors.light_grey};
    private static final int ETA_AVERAGE_TICKS = 30;
    private static Color[] eta_colors = new Color[]{Colors.fadedGreen, Colors.light_grey};
    private UISWTView swtView;
    private boolean legend_at_bottom = true;
    private Composite panel;
    private boolean viewBuilt;
    private MultiPlotGraphic mpg;
    private MultiPlotGraphic eta;
    private List<DownloadManager> managers = new ArrayList<DownloadManager>();
    private Composite parent;
    private boolean show_time = true;
    private boolean comp_visible;
    private Object visible_pending_ds;

    private String getFullTitle() {
        return MessageText.getString("DownloadActivityView.title.full");
    }

    @Override
    public Object getTitleInfoProperty(int propertyID) {
        return null;
    }

    public void initialize(Composite parent) {
        this.parent = parent;
        if (this.panel == null || this.panel.isDisposed()) {
            this.viewBuilt = false;
        }
        this.panel = new Composite(parent, 0);
        this.panel.setLayout((Layout)new FormLayout());
    }

    private void fillPanel() {
        GridData gridData;
        Utils.disposeComposite(this.panel, false);
        Composite mpg_panel = new Composite(this.panel, 0);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(this.show_time ? 75 : 100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        mpg_panel.setLayoutData((Object)formData);
        mpg_panel.setLayout((Layout)new GridLayout(this.legend_at_bottom ? 1 : 2, false));
        ValueFormater formatter = new ValueFormater(){

            @Override
            public String format(int value) {
                return DisplayFormatters.formatByteCountToKiBEtcPerSec(value);
            }
        };
        ValueSource[] sources = new ValueSourceImpl[]{new ValueSourceImpl("Up", 0, mpg_colors, true, false, false){

            @Override
            public int getValue() {
                List dms = DownloadActivityView.this.managers;
                int res = 0;
                for (DownloadManager dm : dms) {
                    DownloadManagerStats stats2 = dm.getStats();
                    res += (int)stats2.getDataSendRate();
                }
                return res;
            }
        }, new ValueSourceImpl("Up Smooth", 1, mpg_colors, true, false, true){

            @Override
            public int getValue() {
                List dms = DownloadActivityView.this.managers;
                int res = 0;
                for (DownloadManager dm : dms) {
                    DownloadManagerStats stats2 = dm.getStats();
                    res += (int)stats2.getSmoothedDataSendRate();
                }
                return res;
            }
        }, new ValueSourceImpl("Down", 2, mpg_colors, false, false, false){

            @Override
            public int getValue() {
                List dms = DownloadActivityView.this.managers;
                int res = 0;
                for (DownloadManager dm : dms) {
                    DownloadManagerStats stats2 = dm.getStats();
                    res += (int)stats2.getDataReceiveRate();
                }
                return res;
            }
        }, new ValueSourceImpl("Down Smooth", 3, mpg_colors, false, false, true){

            @Override
            public int getValue() {
                List dms = DownloadActivityView.this.managers;
                int res = 0;
                for (DownloadManager dm : dms) {
                    DownloadManagerStats stats2 = dm.getStats();
                    res += (int)stats2.getSmoothedDataReceiveRate();
                }
                return res;
            }
        }, new ValueSourceImpl("Swarm Peer Average", 4, mpg_colors, false, true, false){

            @Override
            public int getValue() {
                List dms = DownloadActivityView.this.managers;
                int res = 0;
                for (DownloadManager dm : dms) {
                    res += (int)dm.getStats().getTotalAveragePerPeer();
                }
                return res;
            }
        }};
        if (this.mpg != null) {
            this.mpg.dispose();
        }
        MultiPlotGraphic f_mpg = this.mpg = MultiPlotGraphic.getInstance(sources, formatter);
        String[] color_configs = new String[]{"DownloadActivityView.legend.up", "DownloadActivityView.legend.up_smooth", "DownloadActivityView.legend.down", "DownloadActivityView.legend.down_smooth", "DownloadActivityView.legend.peeraverage"};
        Legend.LegendListener legend_listener = new Legend.LegendListener((ValueSourceImpl[])sources, f_mpg){
            private int hover_index = -1;
            private final /* synthetic */ ValueSourceImpl[] val$sources;
            private final /* synthetic */ MultiPlotGraphic val$f_mpg;
            {
                this.val$sources = valueSourceImplArray;
                this.val$f_mpg = multiPlotGraphic;
            }

            @Override
            public void hoverChange(boolean entry, int index) {
                if (this.hover_index != -1) {
                    this.val$sources[this.hover_index].setHover(false);
                }
                if (entry) {
                    this.hover_index = index;
                    this.val$sources[index].setHover(true);
                }
                this.val$f_mpg.refresh(true);
            }

            @Override
            public void visibilityChange(boolean visible, int index) {
                this.val$sources[index].setVisible(visible);
                this.val$f_mpg.refresh(true);
            }
        };
        if (!this.legend_at_bottom) {
            gridData = new GridData(1040);
            gridData.verticalAlignment = 0x1000000;
            Legend.createLegendComposite(mpg_panel, mpg_colors, color_configs, null, gridData, false, legend_listener);
        }
        Composite gSpeed = new Composite(mpg_panel, 0);
        gridData = new GridData(1808);
        gSpeed.setLayoutData((Object)gridData);
        gSpeed.setLayout((Layout)new GridLayout());
        if (this.legend_at_bottom) {
            gridData = new GridData(768);
            Legend.createLegendComposite(mpg_panel, mpg_colors, color_configs, null, gridData, true, legend_listener);
        }
        Canvas speedCanvas = new Canvas(gSpeed, 262144);
        gridData = new GridData(1808);
        speedCanvas.setLayoutData((Object)gridData);
        this.mpg.initialize(speedCanvas, false);
        if (this.show_time) {
            Composite time_panel = new Composite(this.panel, 0);
            FormData formData2 = new FormData();
            formData2.left = new FormAttachment((Control)mpg_panel, 0);
            formData2.right = new FormAttachment(100, 0);
            formData2.top = new FormAttachment(0, 0);
            formData2.bottom = new FormAttachment(100, 0);
            time_panel.setLayoutData((Object)formData2);
            time_panel.setLayout((Layout)new GridLayout(this.legend_at_bottom ? 1 : 2, false));
            ValueFormater formatter2 = new ValueFormater(){

                @Override
                public String format(int value) {
                    return TimeFormatter.format(value);
                }
            };
            ValueSource[] sources2 = new ValueSourceImpl[]{new ValueSourceImpl("ETA", 0, eta_colors, 128, false, false){

                @Override
                public int getValue() {
                    List dms = DownloadActivityView.this.managers;
                    int res = 0;
                    for (DownloadManager dm : dms) {
                        DownloadManagerStats stats2 = dm.getStats();
                        res = Math.max(res, Math.max((int)stats2.getETA(), 0));
                    }
                    return res;
                }
            }, new ValueSourceImpl("ETA Average", 1, eta_colors, 128, true, false){

                @Override
                public int getValue() {
                    return DownloadActivityView.this.eta.getAverage(30)[0];
                }
            }};
            if (this.eta != null) {
                this.eta.dispose();
            }
            MultiPlotGraphic f_eta = this.eta = MultiPlotGraphic.getInstance(500, sources2, formatter2);
            String[] color_configs2 = new String[]{"DownloadActivityView.legend.eta", "DownloadActivityView.legend.etaAverage"};
            Legend.LegendListener legend_listener2 = new Legend.LegendListener((ValueSourceImpl[])sources2, f_eta){
                private int hover_index = -1;
                private final /* synthetic */ ValueSourceImpl[] val$sources;
                private final /* synthetic */ MultiPlotGraphic val$f_eta;
                {
                    this.val$sources = valueSourceImplArray;
                    this.val$f_eta = multiPlotGraphic;
                }

                @Override
                public void hoverChange(boolean entry, int index) {
                    if (this.hover_index != -1) {
                        this.val$sources[this.hover_index].setHover(false);
                    }
                    if (entry) {
                        this.hover_index = index;
                        this.val$sources[index].setHover(true);
                    }
                    this.val$f_eta.refresh(true);
                }

                @Override
                public void visibilityChange(boolean visible, int index) {
                    this.val$sources[index].setVisible(visible);
                    this.val$f_eta.refresh(true);
                }
            };
            if (!this.legend_at_bottom) {
                gridData = new GridData(1040);
                gridData.verticalAlignment = 0x1000000;
                Legend.createLegendComposite(time_panel, eta_colors, color_configs2, null, gridData, false, legend_listener2);
            }
            Composite gSpeed2 = new Composite(time_panel, 0);
            gridData = new GridData(1808);
            gSpeed2.setLayoutData((Object)gridData);
            gSpeed2.setLayout((Layout)new GridLayout());
            if (this.legend_at_bottom) {
                gridData = new GridData(768);
                Legend.createLegendComposite(time_panel, eta_colors, color_configs2, null, gridData, true, legend_listener2);
            }
            Canvas speedCanvas2 = new Canvas(gSpeed2, 262144);
            gridData = new GridData(1808);
            speedCanvas2.setLayoutData((Object)gridData);
            this.eta.initialize(speedCanvas2, false);
        }
    }

    private void refresh(boolean force) {
        if (this.mpg != null) {
            this.mpg.refresh(force);
        }
        if (this.eta != null) {
            this.eta.refresh(force);
        }
    }

    public Composite getComposite() {
        return this.panel;
    }

    private void setVisible(boolean vis) {
        if (vis) {
            this.comp_visible = true;
            this.dataSourceChanged(this.visible_pending_ds);
        } else {
            this.visible_pending_ds = this.managers;
            this.dataSourceChanged(null);
            this.comp_visible = false;
        }
    }

    public void dataSourceChanged(Object newDataSource) {
        if (!this.comp_visible) {
            this.visible_pending_ds = newDataSource;
            return;
        }
        List<DownloadManager> newManagers = ViewUtils.getDownloadManagersFromDataSource(newDataSource, this.managers);
        if (this.viewBuilt && newManagers.size() == this.managers.size()) {
            boolean same = true;
            int i = 0;
            while (i < this.managers.size()) {
                if (newManagers.get(i) != this.managers.get(i)) {
                    same = false;
                    break;
                }
                ++i;
            }
            if (same) {
                return;
            }
        }
        this.managers = newManagers;
        this.viewBuilt = true;
        this.rebuild();
    }

    private void rebuild() {
        Utils.execSWTThread(() -> {
            if (this.panel == null || this.panel.isDisposed()) {
                return;
            }
            Utils.disposeComposite(this.panel, false);
            List<DownloadManager> dms = this.managers;
            if (!dms.isEmpty()) {
                this.fillPanel();
                this.parent.layout(true, true);
                int min_history_secs = Integer.MAX_VALUE;
                for (DownloadManager dm : this.managers) {
                    DownloadManagerStats stats2 = dm.getStats();
                    stats2.setRecentHistoryRetention(true);
                    int[][] _history = stats2.getRecentHistory();
                    int[] send_history = _history[0];
                    min_history_secs = Math.min(min_history_secs, send_history.length);
                }
                int[] t_recv = new int[min_history_secs];
                int[] t_send = new int[min_history_secs];
                int[] t_swarm_peer_av = new int[min_history_secs];
                int[] t_eta = new int[min_history_secs];
                for (DownloadManager dm : this.managers) {
                    DownloadManagerStats stats3 = dm.getStats();
                    int[][] _history = stats3.getRecentHistory();
                    int[] send_history = _history[0];
                    int[] recv_history = _history[1];
                    int[] sp_history = _history[2];
                    int[] eta_history = _history[3];
                    int i = 0;
                    while (i < min_history_secs) {
                        int n = i;
                        t_send[n] = t_send[n] + send_history[i];
                        int n2 = i;
                        t_recv[n2] = t_recv[n2] + recv_history[i];
                        int n3 = i;
                        t_swarm_peer_av[n3] = t_swarm_peer_av[n3] + sp_history[i];
                        t_eta[i] = Math.max(t_eta[i], eta_history[i]);
                        ++i;
                    }
                }
                int[] t_smoothed_recv = new int[min_history_secs];
                int[] t_smoothed_send = new int[min_history_secs];
                GeneralUtils.SmoothAverage send_average = GeneralUtils.getSmoothAverageForReplay();
                GeneralUtils.SmoothAverage recv_average = GeneralUtils.getSmoothAverageForReplay();
                int smooth_interval = GeneralUtils.getSmoothUpdateInterval();
                int current_smooth_send = 0;
                int current_smooth_recv = 0;
                int pending_smooth_send = 0;
                int pending_smooth_recv = 0;
                int i = 0;
                while (i < min_history_secs) {
                    pending_smooth_send += t_send[i];
                    pending_smooth_recv += t_recv[i];
                    if (i % smooth_interval == 0) {
                        send_average.addValue(pending_smooth_send);
                        current_smooth_send = (int)send_average.getAverage();
                        recv_average.addValue(pending_smooth_recv);
                        current_smooth_recv = (int)recv_average.getAverage();
                        pending_smooth_send = 0;
                        pending_smooth_recv = 0;
                    }
                    t_smoothed_send[i] = current_smooth_send;
                    t_smoothed_recv[i] = current_smooth_recv;
                    ++i;
                }
                int[][] mpg_history = new int[][]{t_send, t_smoothed_send, t_recv, t_smoothed_recv, t_swarm_peer_av};
                this.mpg.reset(mpg_history);
                this.mpg.setActive(true);
                if (this.eta != null) {
                    int[] t_eta_average = new int[min_history_secs];
                    MovingImmediateAverage eta_average = AverageFactory.MovingImmediateAverage(30);
                    int i2 = 0;
                    while (i2 < min_history_secs) {
                        eta_average.update(t_eta[i2]);
                        t_eta_average[i2] = (int)eta_average.getAverage();
                        ++i2;
                    }
                    int[][] eta_history = new int[][]{t_eta, t_eta_average};
                    this.eta.reset(eta_history);
                    this.eta.setActive(true);
                }
            } else {
                ViewUtils.setViewRequiresOneOrMoreDownloads(this.panel);
                if (this.mpg != null) {
                    this.mpg.setActive(false);
                    this.mpg.reset(new int[5][0]);
                }
                if (this.eta != null) {
                    this.eta.setActive(false);
                    this.eta.reset(new int[2][0]);
                }
            }
        });
    }

    @Override
    public void menuWillBeShown(MdiEntry entry, Menu menu) {
        MenuItem mi = new MenuItem(menu, 32);
        mi.setSelection(this.show_time);
        mi.setText(MessageText.getString("ColumnProgressETA.showETA"));
        mi.addListener(13, ev -> COConfigurationManager.setParameter("DownloadActivity.show.eta", !this.show_time));
        new MenuItem(menu, 2);
    }

    @Override
    public void parameterChanged(String parameterName) {
        this.show_time = COConfigurationManager.getBooleanParameter("DownloadActivity.show.eta");
        this.rebuild();
    }

    private void create() {
        COConfigurationManager.addParameterListener("DownloadActivity.show.eta", (ParameterListener)this);
        this.show_time = COConfigurationManager.getBooleanParameter("DownloadActivity.show.eta");
    }

    private void setSwtView(UISWTView swtView) {
        if (this.swtView == swtView) {
            return;
        }
        this.swtView = swtView;
        swtView.setTitle(this.getFullTitle());
        swtView.setToolBarListener(this);
        if (swtView instanceof TabbedEntry) {
            TabbedEntry tabView = (TabbedEntry)swtView;
            tabView.addListener(this);
            this.legend_at_bottom = tabView.getMDI().getAllowSubViews();
        }
    }

    private void delete() {
        Utils.disposeComposite(this.panel);
        COConfigurationManager.removeParameterListener("DownloadActivity.show.eta", this);
        if (this.mpg != null) {
            this.mpg.dispose();
            this.mpg = null;
        }
        if (this.eta != null) {
            this.eta.dispose();
            this.eta = null;
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.setSwtView(event2.getView());
                this.create();
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 5: {
                this.refresh(false);
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                String id = "DMDetails_DownloadGraph";
                this.setVisible(true);
                if (this.managers != null) {
                    ArrayList<SelectedContent> sc = new ArrayList<SelectedContent>();
                    for (DownloadManager dm : this.managers) {
                        sc.add(new SelectedContent(dm));
                        id = dm.getTorrent() != null ? String.valueOf(id) + "." + dm.getInternalName() : String.valueOf(id) + ":" + dm.getSize();
                    }
                    SelectedContentManager.changeCurrentlySelectedContent(id, sc.toArray(new SelectedContent[0]));
                } else {
                    SelectedContentManager.changeCurrentlySelectedContent(id, null);
                }
                this.refresh(true);
                break;
            }
            case 4: {
                this.setVisible(false);
                SelectedContentManager.clearCurrentlySelectedContent();
            }
        }
        return true;
    }

    @Override
    public void titleInfoLinked(MultipleDocumentInterface mdi, MdiEntry mdiEntry) {
        if (mdiEntry instanceof UISWTView) {
            this.setSwtView((UISWTView)((Object)mdiEntry));
        }
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        return false;
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        Map<String, Long> states = TorrentUtil.calculateToolbarStates(SelectedContentManager.getCurrentlySelectedContent(), null);
        list.putAll(states);
    }

    private static abstract class ValueSourceImpl
    implements ValueSource {
        private String name;
        private int index;
        private Color[] colours;
        private int base_style;
        private boolean trimmable;
        private boolean is_hover;
        private boolean is_invisible;
        private boolean is_dotted;

        private ValueSourceImpl(String _name, int _index, Color[] _colours, boolean _is_up, boolean _trimmable, boolean _is_dotted) {
            this.name = _name;
            this.index = _index;
            this.colours = _colours;
            this.trimmable = _trimmable;
            this.is_dotted = _is_dotted;
            this.base_style = _is_up ? 1 : 2;
        }

        private ValueSourceImpl(String _name, int _index, Color[] _colours, int _base_style, boolean _trimmable, boolean _is_dotted) {
            this.name = _name;
            this.index = _index;
            this.colours = _colours;
            this.trimmable = _trimmable;
            this.is_dotted = _is_dotted;
            this.base_style = _base_style;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Color getLineColor() {
            return this.colours[this.index];
        }

        @Override
        public boolean isTrimmable() {
            return this.trimmable;
        }

        private void setHover(boolean h) {
            this.is_hover = h;
        }

        private void setVisible(boolean visible) {
            this.is_invisible = !visible;
        }

        @Override
        public int getStyle() {
            if (this.is_invisible) {
                return 16;
            }
            int style = this.base_style;
            if (this.is_hover) {
                style |= 8;
            }
            if (this.is_dotted) {
                style |= 0x40;
            }
            return style;
        }

        @Override
        public int getAlpha() {
            return this.is_dotted ? 128 : 255;
        }
    }
}

