/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.internat.MessageText;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.views.stats.XferStatsPanel;
import com.biglybt.util.DataSourceUtils;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class DownloadXferStatsView
implements UISWTViewCoreEventListener {
    public static final String MSGID_PREFIX = "DownloadXferStatsView";
    private Composite composite;
    private XferStatsPanel local_stats;
    private UISWTView swtView;
    private GlobalManagerStats gm_stats;
    private DownloadManager current_dm;

    public void initialize(Composite _composite) {
        this.composite = _composite;
        Composite local_composite = new Composite(this.composite, 0);
        local_composite.setLayout((Layout)new FillLayout());
        local_composite.setLayoutData((Object)Utils.getFilledFormData());
        Composite local_panel = new Composite(local_composite, 0);
        local_panel.setLayout((Layout)new FillLayout());
        this.local_stats = new XferStatsPanel(local_panel, false);
        CoreFactory.addCoreRunningListener(core -> Utils.execSWTThread(() -> {
            this.gm_stats = core.getGlobalManager().getStats();
            this.local_stats.init(this.current_dm == null ? null : this.gm_stats.getAggregateLocalStats(this.current_dm));
        }));
    }

    private String getTitleID() {
        return "DownloadXferStatsView.title.full";
    }

    private void dataSourceChanged(Object ds) {
        DownloadManager[] dms = DataSourceUtils.getDMs(ds);
        this.current_dm = dms.length == 1 ? dms[0] : null;
        Utils.execSWTThread(() -> {
            if (this.gm_stats != null) {
                this.local_stats.init(this.current_dm == null ? null : this.gm_stats.getAggregateLocalStats(this.current_dm));
            }
        });
    }

    public void delete() {
        if (this.local_stats != null) {
            this.local_stats.delete();
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(MessageText.getString(this.getTitleID()));
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.composite);
                if (this.swtView == null) break;
                this.swtView.setTitle(MessageText.getString(this.getTitleID()));
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                if (this.local_stats == null) break;
                this.local_stats.requestRefresh();
                break;
            }
            case 5: {
                if (this.local_stats == null) break;
                this.local_stats.refreshView();
            }
        }
        return true;
    }
}

