/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfoListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerListener;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagListener;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.IdentityHashSet;
import com.biglybt.core.util.StringInterner;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.ui.tables.TableRow;
import com.biglybt.pif.ui.tables.TableRowRefreshListener;
import com.biglybt.pifimpl.local.utils.FormattersImpl;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableDataSourceChangedListener;
import com.biglybt.ui.common.table.TableExpansionChangeListener;
import com.biglybt.ui.common.table.TableLifeCycleListener;
import com.biglybt.ui.common.table.TableRefreshListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableSelectionListener;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.table.TableViewFilterCheck;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BubbleTextBox;
import com.biglybt.ui.swt.components.BufferedLabel;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.shells.PopOutManager;
import com.biglybt.ui.swt.views.FilesViewMenuUtil;
import com.biglybt.ui.swt.views.ViewManagerSWT;
import com.biglybt.ui.swt.views.file.FileInfoView;
import com.biglybt.ui.swt.views.table.TableRowSWT;
import com.biglybt.ui.swt.views.table.TableRowSWTChildController;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.TableViewSWTMenuFillListener;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import com.biglybt.ui.swt.views.table.impl.TableViewTab;
import com.biglybt.ui.swt.views.table.utils.TableColumnFilterHelper;
import com.biglybt.ui.swt.views.table.utils.TableColumnSWTUtils;
import com.biglybt.ui.swt.views.tableitems.files.DoneItem;
import com.biglybt.ui.swt.views.tableitems.files.DownloadNameItem;
import com.biglybt.ui.swt.views.tableitems.files.FileAvailabilityItem;
import com.biglybt.ui.swt.views.tableitems.files.FileCRC32Item;
import com.biglybt.ui.swt.views.tableitems.files.FileCreationItem;
import com.biglybt.ui.swt.views.tableitems.files.FileETAItem;
import com.biglybt.ui.swt.views.tableitems.files.FileExtensionItem;
import com.biglybt.ui.swt.views.tableitems.files.FileIndexItem;
import com.biglybt.ui.swt.views.tableitems.files.FileIndexPlus1Item;
import com.biglybt.ui.swt.views.tableitems.files.FileMD5Item;
import com.biglybt.ui.swt.views.tableitems.files.FileModifiedItem;
import com.biglybt.ui.swt.views.tableitems.files.FileReadSpeedItem;
import com.biglybt.ui.swt.views.tableitems.files.FileSHA1Item;
import com.biglybt.ui.swt.views.tableitems.files.FileWriteSpeedItem;
import com.biglybt.ui.swt.views.tableitems.files.FirstPieceItem;
import com.biglybt.ui.swt.views.tableitems.files.LastPieceItem;
import com.biglybt.ui.swt.views.tableitems.files.ModeItem;
import com.biglybt.ui.swt.views.tableitems.files.NameItem;
import com.biglybt.ui.swt.views.tableitems.files.PathItem;
import com.biglybt.ui.swt.views.tableitems.files.PathNameItem;
import com.biglybt.ui.swt.views.tableitems.files.PercentItem;
import com.biglybt.ui.swt.views.tableitems.files.PieceCountItem;
import com.biglybt.ui.swt.views.tableitems.files.PiecesDoneAndCountItem;
import com.biglybt.ui.swt.views.tableitems.files.PriorityItem;
import com.biglybt.ui.swt.views.tableitems.files.ProgressGraphItem;
import com.biglybt.ui.swt.views.tableitems.files.RelocatedItem;
import com.biglybt.ui.swt.views.tableitems.files.RemainingPiecesItem;
import com.biglybt.ui.swt.views.tableitems.files.SizeBytesItem;
import com.biglybt.ui.swt.views.tableitems.files.SizeItem;
import com.biglybt.ui.swt.views.tableitems.files.StorageTypeItem;
import com.biglybt.ui.swt.views.tableitems.files.TorrentRelativePathItem;
import com.biglybt.ui.swt.views.tableitems.files.TorrentV2RootHashItem;
import com.biglybt.ui.swt.views.tableitems.mytorrents.AlertsItem;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import com.biglybt.util.DataSourceUtils;
import com.biglybt.util.MapUtils;
import com.biglybt.util.PlayUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class FilesView
extends TableViewTab<com.biglybt.core.disk.DiskManagerFileInfo>
implements TableDataSourceChangedListener,
TableSelectionListener,
TableViewSWTMenuFillListener,
TableRefreshListener,
TableExpansionChangeListener,
DownloadManagerListener,
TableLifeCycleListener,
TableViewFilterCheck<com.biglybt.core.disk.DiskManagerFileInfo>,
KeyListener,
ParameterListener,
UISWTViewCoreEventListener,
ViewTitleInfo {
    private static final Object KEY_DM_TREE_STATE = new Object();
    private static final Object KEY_DM_SELECTION_STATE = new Object();
    private static final int ACTION_EXPAND = 0;
    private static final int ACTION_COLLAPSE = 1;
    public static final Class<DiskManagerFileInfo> PLUGIN_DS_TYPE = DiskManagerFileInfo.class;
    boolean refreshing = false;
    private static TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem(), new PathItem(), new PathNameItem(), new SizeItem(), new SizeBytesItem(), new DoneItem(), new PercentItem(), new FirstPieceItem(), new LastPieceItem(), new PieceCountItem(), new RemainingPiecesItem(), new PiecesDoneAndCountItem(), new ProgressGraphItem(), new ModeItem(), new PriorityItem(), new StorageTypeItem(), new FileExtensionItem(), new FileIndexItem(), new FileIndexPlus1Item(), new TorrentRelativePathItem(), new FileCRC32Item(), new FileMD5Item(), new FileSHA1Item(), new TorrentV2RootHashItem(), new FileAvailabilityItem(), new AlertsItem("Files"), new FileReadSpeedItem(), new FileWriteSpeedItem(), new FileETAItem(), new RelocatedItem(), new FileModifiedItem(), new FileCreationItem(), new DownloadNameItem()};
    public static final String MSGID_PREFIX = "FilesView";
    private DownloadManager[] managers = new DownloadManager[0];
    public boolean hide_dnd_files;
    public boolean tree_view;
    private boolean viewActive;
    private volatile long selection_size;
    private volatile long selection_size_with_dnd;
    private volatile long selection_done;
    MenuItem path_item;
    TableViewSWT<com.biglybt.core.disk.DiskManagerFileInfo> tv;
    TableColumnFilterHelper<com.biglybt.core.disk.DiskManagerFileInfo> col_filter_helper;
    Button btnShowDND;
    Button btnTreeView;
    BufferedLabel lblHeader;
    BubbleTextBox bubbleTextBox;
    private boolean disableTableWhenEmpty = true;
    private Object datasource;
    private Tag[] tags;
    private TagListener tag_listener = null;
    private Map<Object, Object> filter_cache;
    private String last_filter_str = "";
    private boolean last_filter_regex;
    private boolean update_header_pending;
    private boolean force_refresh = false;
    private Map<DownloadManager, Set<Integer>> selection_outstanding = null;
    private FilesViewNodeInner current_root;
    private Map<TOTorrentFile, FilesViewNodeLeaf> tree_file_map = new IdentityHashMap<TOTorrentFile, FilesViewNodeLeaf>();
    private static Comparator<String> tree_comp;

    static {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.setDefaultColumnNames("Files", basicItems);
        tree_comp = new FormattersImpl().getAlphanumericComparator(true);
    }

    public FilesView() {
        super(MSGID_PREFIX);
    }

    @Override
    public TableViewSWT<com.biglybt.core.disk.DiskManagerFileInfo> initYourTableView() {
        FilesView.registerPluginViews();
        this.tv = TableViewFactory.createTableViewSWT(PLUGIN_DS_TYPE, "Files", this.getTextPrefixID(), basicItems, "firstpiece", 0x10010002);
        this.tv.setExpandEnabled(true);
        basicItems = new TableColumnCore[0];
        this.tv.addTableDataSourceChangedListener(this, true);
        this.tv.addRefreshListener(this, true);
        this.tv.addSelectionListener(this, false);
        this.tv.addMenuFillListener(this);
        this.tv.addLifeCycleListener(this);
        this.tv.addKeyListener(this);
        this.tv.addExpansionChangeListener(this);
        this.tv.addRefreshListener(new TableRowRefreshListener(){

            @Override
            public void rowRefresh(TableRow row) {
                Object ds;
                if (row instanceof TableRowSWT && (ds = ((TableRowSWT)row).getDataSource(true)) instanceof FilesViewNodeInner) {
                    ((TableRowSWT)row).setFontStyle(2);
                    ((TableRowSWT)row).setAlpha(220);
                }
            }
        });
        this.col_filter_helper = new TableColumnFilterHelper<com.biglybt.core.disk.DiskManagerFileInfo>(this.tv, "fv:search");
        return this.tv;
    }

    private static void registerPluginViews() {
        ViewManagerSWT vm = ViewManagerSWT.getInstance();
        if (vm.areCoreViewsRegistered(PLUGIN_DS_TYPE)) {
            return;
        }
        vm.registerView(PLUGIN_DS_TYPE, new UISWTViewBuilderCore("FileInfoView", null, FileInfoView.class));
        vm.setCoreViewsRegistered(PLUGIN_DS_TYPE);
    }

    @Override
    public Composite initComposite(Composite composite) {
        Composite parent = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        Layout compositeLayout = composite.getLayout();
        if (compositeLayout instanceof GridLayout) {
            parent.setLayoutData((Object)new GridData(4, 4, true, true));
        } else if (compositeLayout instanceof FormLayout) {
            parent.setLayoutData((Object)Utils.getFilledFormData());
        }
        Composite cTop = new Composite(parent, 0);
        cTop.setLayoutData((Object)new GridData(4, 1, true, false));
        cTop.setLayout((Layout)new FormLayout());
        this.btnShowDND = new Button(cTop, 32);
        Messages.setLanguageText((Widget)this.btnShowDND, "FilesView.hide.dnd");
        this.btnShowDND.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                COConfigurationManager.setParameter("FilesView.hide.dnd", !FilesView.this.hide_dnd_files);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.hide_dnd_files = COConfigurationManager.getBooleanParameter("FilesView.hide.dnd");
        this.btnShowDND.setSelection(this.hide_dnd_files);
        this.btnTreeView = new Button(cTop, 32);
        Messages.setLanguageText((Widget)this.btnTreeView, "OpenTorrentWindow.tree.view");
        this.btnTreeView.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FilesView.this.tree_view = FilesView.this.btnTreeView.getSelection();
                COConfigurationManager.setParameter("FilesView.use.tree", FilesView.this.tree_view);
                FilesView.this.prepareSelectionState();
                if (FilesView.this.tree_view) {
                    TableColumnSWTUtils.changeColumnVisiblity(FilesView.this.tv, FilesView.this.tv.getTableColumn("name"), true);
                }
                FilesView.this.force_refresh = true;
                FilesView.this.tableRefresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tree_view = COConfigurationManager.getBooleanParameter("FilesView.use.tree");
        this.btnTreeView.setSelection(this.tree_view);
        this.lblHeader = new BufferedLabel(cTop, 0x1000000 | (Constants.isLinux ? 0 : 0x20000000));
        this.bubbleTextBox = new BubbleTextBox(cTop, 2948);
        Composite mainBubbleWidget = this.bubbleTextBox.getMainWidget();
        FormData fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.width = 140;
        this.bubbleTextBox.setMessageAndLayout(MessageText.getString("TorrentDetailsView.filter"), fd);
        String tooltip = MessageText.getString("filter.tt.start");
        tooltip = String.valueOf(tooltip) + MessageText.getString("filesview.filter.tt.line1");
        tooltip = String.valueOf(tooltip) + MessageText.getString("column.filter.tt.line1");
        tooltip = String.valueOf(tooltip) + MessageText.getString("column.filter.tt.line2");
        this.bubbleTextBox.setTooltip(tooltip);
        fd = new FormData();
        fd.top = new FormAttachment((Control)mainBubbleWidget, 10, 0x1000000);
        fd.left = new FormAttachment(0, 0);
        this.btnShowDND.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)mainBubbleWidget, 10, 0x1000000);
        fd.left = new FormAttachment((Control)this.btnShowDND, 10);
        this.btnTreeView.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)mainBubbleWidget, 10, 0x1000000);
        fd.left = new FormAttachment((Control)this.btnTreeView, 10);
        fd.right = new FormAttachment((Control)mainBubbleWidget, -10);
        this.lblHeader.setLayoutData(fd);
        this.tv.enableFilterCheck(this.bubbleTextBox, this, true);
        Composite tableParent = new Composite(parent, 0);
        tableParent.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        tableParent.setLayout((Layout)gridLayout);
        parent.setTabList(new Control[]{tableParent, cTop});
        parent.addListener(26, ev -> {
            this.viewActive = true;
            this.updateSelectedContent();
        });
        parent.addListener(27, ev -> {
            this.viewActive = false;
        });
        return tableParent;
    }

    private void addManagerListeners(DownloadManager[] managers) {
        if (managers == null) {
            return;
        }
        DownloadManager[] downloadManagerArray = managers;
        int n = managers.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadManager manager = downloadManagerArray[n2];
            manager.addListener(this);
            ++n2;
        }
    }

    private void removeManagerListeners(DownloadManager[] managers) {
        if (managers == null) {
            return;
        }
        DownloadManager[] downloadManagerArray = managers;
        int n = managers.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadManager manager = downloadManagerArray[n2];
            manager.removeListener(this);
            ++n2;
        }
    }

    @Override
    public void tableDataSourceChanged(Object newDataSource) {
        int n;
        Object[] newTags = DataSourceUtils.getTags(newDataSource);
        Object[] newManagers = DataSourceUtils.getDMs(newDataSource);
        if (Arrays.deepEquals(newTags, this.tags) && Arrays.equals(newManagers, this.managers)) {
            return;
        }
        this.force_refresh = true;
        if (this.tv != null) {
            this.removeManagerListeners(this.managers);
        }
        if (this.tags != null && this.tags.length > 0 && this.tag_listener != null) {
            Tag[] tagArray = this.tags;
            n = this.tags.length;
            int n2 = 0;
            while (n2 < n) {
                Tag tag = tagArray[n2];
                tag.removeTagListener(this.tag_listener);
                ++n2;
            }
        }
        DownloadManager[] oldManagers = this.managers;
        this.managers = newManagers;
        this.tags = newTags;
        this.datasource = newDataSource;
        ViewTitleInfoManager.refreshTitleInfo(this);
        if (this.tags != null && this.tags.length > 0) {
            if (this.tag_listener == null) {
                this.tag_listener = new TagListener(){

                    @Override
                    public void taggableSync(Tag tag) {
                    }

                    @Override
                    public void taggableRemoved(Tag t, Taggable tagged) {
                        FilesView.this.tableDataSourceChanged(FilesView.this.datasource);
                    }

                    @Override
                    public void taggableAdded(Tag t, Taggable tagged) {
                        FilesView.this.tableDataSourceChanged(FilesView.this.datasource);
                    }
                };
            }
            Tag[] tagArray = this.tags;
            int n3 = this.tags.length;
            n = 0;
            while (n < n3) {
                Tag tag = tagArray[n];
                tag.addTagListener(this.tag_listener, false);
                ++n;
            }
        }
        if (this.tv == null) {
            return;
        }
        this.prepareSelectionState();
        this.addManagerListeners(this.managers);
        if (!this.tv.isDisposed()) {
            String overall_filter = null;
            boolean overall_regex = false;
            boolean has_clash = false;
            DownloadManager[] downloadManagerArray = this.managers;
            int n4 = this.managers.length;
            int n5 = 0;
            while (n5 < n4) {
                Map view;
                DownloadManager manager = downloadManagerArray[n5];
                DownloadManagerState state = manager.getDownloadState();
                Map map = state.getMapAttribute("vfilt");
                String filter2 = null;
                boolean regex = false;
                if (map != null && (view = (Map)map.get(MSGID_PREFIX)) != null) {
                    filter2 = MapUtils.getMapString(view, "filter", null);
                    regex = MapUtils.getMapBoolean(view, "regex", false);
                }
                if (filter2 == null) {
                    if (overall_filter != null) {
                        has_clash = true;
                        break;
                    }
                    overall_filter = null;
                } else if (overall_filter == null) {
                    if (!has_clash) {
                        overall_filter = filter2;
                        overall_regex = regex;
                    }
                } else if (!overall_filter.equals(filter2) || overall_regex != regex) {
                    overall_filter = null;
                    has_clash = true;
                    break;
                }
                ++n5;
            }
            if (has_clash) {
                this.bubbleTextBox.setState("", false);
            } else if (overall_filter != null) {
                this.bubbleTextBox.setState(overall_filter, overall_regex);
                this.tv.refilter();
            }
            if (this.tree_view) {
                this.tv.removeAllTableRows();
                this.current_root = null;
            } else {
                if (oldManagers.length == 1 && newManagers.length == 1) {
                    this.tv.removeAllTableRows();
                }
                this.updateTable();
            }
            if (this.disableTableWhenEmpty) {
                this.tv.setEnabled(this.managers.length > 0);
            }
            this.updateHeader();
        }
    }

    @Override
    public void deselected(TableRowCore[] rows) {
    }

    @Override
    public void focusChanged(TableRowCore focus) {
    }

    @Override
    public void selected(TableRowCore[] rows) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareSelectionState() {
        if (this.managers == null) {
            return;
        }
        IdentityHashMap<DownloadManager, Set> pending = null;
        Object object = KEY_DM_SELECTION_STATE;
        synchronized (object) {
            DownloadManager[] downloadManagerArray = this.managers;
            int n = this.managers.length;
            int n2 = 0;
            while (n2 < n) {
                DownloadManager dm = downloadManagerArray[n2];
                Set sel = (Set)dm.getUserData(KEY_DM_SELECTION_STATE);
                if (sel != null) {
                    if (pending == null) {
                        pending = new IdentityHashMap<DownloadManager, Set>();
                    }
                    pending.put(dm, sel);
                }
                ++n2;
            }
        }
        this.selection_outstanding = pending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectionChanged(TableRowCore[] selected_rows, TableRowCore[] deselected_rows) {
        DownloadManager dm;
        HashMap sel_map = new HashMap();
        IdentityHashSet<DownloadManager> unselected_dms = new IdentityHashSet<DownloadManager>();
        if (this.managers != null) {
            unselected_dms.addAll(Arrays.asList(this.managers));
        }
        List<Object> selected_objects = this.tv.getSelectedDataSources();
        for (Object selected : selected_objects) {
            com.biglybt.core.disk.DiskManagerFileInfo file = (com.biglybt.core.disk.DiskManagerFileInfo)selected;
            dm = file.getDownloadManager();
            if (dm == null) continue;
            HashSet<Integer> sel = (HashSet<Integer>)sel_map.get(dm);
            if (sel == null) {
                sel = new HashSet<Integer>();
                sel_map.put(dm, sel);
            }
            if (file instanceof FilesViewNodeInner) {
                int uid = ((FilesViewNodeInner)file).getUID();
                sel.add(uid + 1000000000);
                continue;
            }
            sel.add(file.getIndex());
        }
        Object object = KEY_DM_SELECTION_STATE;
        synchronized (object) {
            for (Map.Entry entry : sel_map.entrySet()) {
                dm = (DownloadManager)entry.getKey();
                dm.setUserData(KEY_DM_SELECTION_STATE, entry.getValue());
                unselected_dms.remove(dm);
            }
            for (DownloadManager dm2 : unselected_dms) {
                dm2.setUserData(KEY_DM_SELECTION_STATE, null);
            }
        }
        this.updateSelectedContent();
    }

    @Override
    public void stateChanged(DownloadManager manager, int state) {
    }

    @Override
    public void downloadComplete(DownloadManager manager) {
    }

    @Override
    public void completionChanged(DownloadManager manager, boolean bCompleted) {
    }

    @Override
    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filePriorityChanged(DownloadManager download, com.biglybt.core.disk.DiskManagerFileInfo file) {
        if (this.hide_dnd_files) {
            this.tv.refilter();
        }
        if (this.tree_view) {
            Map<TOTorrentFile, FilesViewNodeLeaf> map = this.tree_file_map;
            synchronized (map) {
                file = this.tree_file_map.get(file.getTorrentFile());
            }
        }
        if (file != null) {
            TableRowCore[] rows = this.tree_view ? this.tv.getRowsAndSubRows(true) : this.tv.getVisibleRows();
            TableRowCore[] tableRowCoreArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                TableRowCore row = tableRowCoreArray[n2];
                com.biglybt.core.disk.DiskManagerFileInfo row_file = (com.biglybt.core.disk.DiskManagerFileInfo)row.getDataSource(true);
                if (row_file == file || row_file.getIndex() == file.getIndex() && row_file.getDownloadManager() == file.getDownloadManager()) {
                    while (row != null) {
                        row.redraw();
                        row = row.getParentRowCore();
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public void fileLocationChanged(DownloadManager download, com.biglybt.core.disk.DiskManagerFileInfo file) {
        if (file == null) {
            this.tv.columnInvalidate("path", true);
            this.tv.columnInvalidate("pathname", true);
            this.tv.refreshTable(false);
        } else {
            TableRowCore row = this.getRowForFile(file);
            if (row != null) {
                row.invalidate(true);
                row.refresh(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableRowCore getRowForFile(com.biglybt.core.disk.DiskManagerFileInfo file) {
        if (this.tree_view) {
            Map<TOTorrentFile, FilesViewNodeLeaf> map = this.tree_file_map;
            synchronized (map) {
                file = this.tree_file_map.get(file.getTorrentFile());
            }
        }
        if (file != null) {
            TableRowCore[] rows = this.tree_view ? this.tv.getRowsAndSubRows(false) : this.tv.getVisibleRows();
            TableRowCore[] tableRowCoreArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                TableRowCore row = tableRowCoreArray[n2];
                com.biglybt.core.disk.DiskManagerFileInfo row_file = (com.biglybt.core.disk.DiskManagerFileInfo)row.getDataSource(true);
                if (row_file == file || row_file.getIndex() == file.getIndex() && row_file.getDownloadManager() == file.getDownloadManager()) {
                    return row;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void setRefilterCache(Map<Object, Object> cache) {
        this.filter_cache = cache;
    }

    @Override
    public boolean filterCheck(com.biglybt.core.disk.DiskManagerFileInfo ds, String filter2, boolean regex, boolean confusable) {
        Boolean r;
        Boolean[] entry;
        Map<Object, Object> cache = this.filter_cache;
        if (cache != null && (entry = (Boolean[])cache.get(ds)) != null && (r = entry[confusable ? 0 : 1]) != null) {
            return r;
        }
        boolean result = this.filterCheckSupport(ds, filter2, regex, confusable);
        if (cache != null) {
            Boolean[] entry2 = (Boolean[])cache.get(ds);
            if (entry2 == null) {
                entry2 = new Boolean[2];
                cache.put(ds, entry2);
            }
            entry2[confusable ? 0 : 1] = result;
        }
        return result;
    }

    private boolean filterCheckSupport(com.biglybt.core.disk.DiskManagerFileInfo ds, String filter2, boolean regex, boolean confusable) {
        if (this.hide_dnd_files) {
            TOTorrentFile tf;
            if (ds.isSkipped()) {
                return false;
            }
            if (ds instanceof FilesViewNodeInner ? ((FilesViewNodeInner)ds).getSkippedState() == 0 : (tf = ds.getTorrentFile()) != null && tf.isPadFile()) {
                return false;
            }
        }
        if (filter2 == null || filter2.length() == 0) {
            return true;
        }
        if (!this.tv.hasFilterControl()) {
            return true;
        }
        if (this.tree_view && ds instanceof FilesViewNodeInner) {
            List<FilesViewTreeNode> kids = ((FilesViewNodeInner)ds).getKids();
            boolean visible = false;
            for (FilesViewTreeNode kid : kids) {
                if (kid instanceof com.biglybt.core.disk.DiskManagerFileInfo) {
                    if (!this.filterCheck((com.biglybt.core.disk.DiskManagerFileInfo)((Object)kid), filter2, regex, confusable)) continue;
                    visible = true;
                    break;
                }
                visible = true;
                break;
            }
            return visible;
        }
        if (confusable) {
            filter2 = GeneralUtils.getConfusableEquivalent(filter2, true);
        }
        try {
            String name;
            File file = ds.getFile(true);
            boolean filter_on_path = false;
            if (filter2.startsWith("p:")) {
                filter_on_path = true;
                filter2 = filter2.substring(2);
            } else if (filter2.startsWith(File.separator)) {
                filter_on_path = true;
                filter2 = filter2.substring(1);
            }
            String string = name = filter_on_path ? file.getAbsolutePath() : file.getName();
            if (confusable) {
                name = GeneralUtils.getConfusableEquivalent(name, false);
            }
            return this.col_filter_helper.filterCheck(ds, filter2, regex, name, filter_on_path);
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public void filterSet(String filter2, boolean regex) {
        if (!filter2.equals(this.last_filter_str) || regex != this.last_filter_regex) {
            DownloadManager[] downloadManagerArray = this.managers;
            int n = this.managers.length;
            int n2 = 0;
            while (n2 < n) {
                DownloadManager manager = downloadManagerArray[n2];
                DownloadManagerState state = manager.getDownloadState();
                HashMap map = state.getMapAttribute("vfilt");
                map = map == null ? new HashMap() : new HashMap(map);
                HashMap view = (HashMap)map.get(MSGID_PREFIX);
                if (view == null) {
                    view = new HashMap();
                    map.put(MSGID_PREFIX, view);
                }
                MapUtils.setMapString(view, "filter", filter2);
                MapUtils.setMapBoolean(view, "regex", regex);
                state.setMapAttribute("vfilt", map);
                ++n2;
            }
            this.last_filter_str = filter2;
            this.last_filter_regex = regex;
        }
        this.col_filter_helper.filterSet(filter2);
    }

    @Override
    public void viewChanged(TableView<com.biglybt.core.disk.DiskManagerFileInfo> view) {
        if (this.update_header_pending) {
            return;
        }
        this.updateHeader();
    }

    public void updateSelectedContent() {
        long total_size = 0L;
        long total_dnd = 0L;
        long total_done = 0L;
        if (this.tv == null) {
            return;
        }
        Object[] dataSources = this.tv.getSelectedDataSources(true);
        ArrayList<SelectedContent> listSelected = new ArrayList<SelectedContent>(dataSources.length);
        Object[] objectArray = dataSources;
        int n = dataSources.length;
        int n2 = 0;
        while (n2 < n) {
            Object ds = objectArray[n2];
            if (ds instanceof com.biglybt.core.disk.DiskManagerFileInfo) {
                com.biglybt.core.disk.DiskManagerFileInfo fileInfo2 = (com.biglybt.core.disk.DiskManagerFileInfo)ds;
                listSelected.add(new SelectedContent(fileInfo2.getDownloadManager(), fileInfo2.getIndex()));
                if (fileInfo2.isSkipped()) {
                    total_dnd += fileInfo2.getLength();
                } else {
                    total_size += fileInfo2.getLength();
                    total_done += fileInfo2.getDownloaded();
                }
            }
            ++n2;
        }
        this.selection_size = total_size;
        this.selection_size_with_dnd = total_dnd + total_size;
        this.selection_done = total_done;
        this.updateHeader();
        if (this.viewActive) {
            ISelectedContent[] sc = listSelected.toArray(new SelectedContent[0]);
            SelectedContentManager.changeCurrentlySelectedContent(this.tv.getTableID(), sc, this.tv);
        }
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask, int origin) {
        String enter_mode;
        com.biglybt.core.disk.DiskManagerFileInfo fileInfo2 = (com.biglybt.core.disk.DiskManagerFileInfo)this.tv.getFirstSelectedDataSource();
        if (fileInfo2 == null) {
            return;
        }
        if (fileInfo2 instanceof FilesViewNodeInner) {
            FilesViewNodeInner node = (FilesViewNodeInner)fileInfo2;
            List<FilesViewNodeInner> nodes = Arrays.asList(node);
            try {
                this.tv.setRedrawEnabled(false);
                if (node.isExpanded()) {
                    this.doTreeAction(nodes, 1, false);
                } else {
                    this.doTreeAction(nodes, 0, false);
                }
            }
            finally {
                this.tv.setRedrawEnabled(true);
            }
            return;
        }
        if (fileInfo2.getIndex() == -1) {
            return;
        }
        boolean webInBrowser = COConfigurationManager.getBooleanParameter("Library.LaunchWebsiteInBrowser");
        if (webInBrowser && ManagerUtils.browseWebsite(fileInfo2)) {
            return;
        }
        String mode = COConfigurationManager.getStringParameter("list.dm.dblclick");
        if (origin == 1 && !(enter_mode = COConfigurationManager.getStringParameter("list.dm.enteraction")).equals("-1")) {
            mode = enter_mode;
        }
        switch (mode) {
            case "1": {
                DownloadManager dm = fileInfo2.getDownloadManager();
                if (dm == null) break;
                UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("DMDetails", dm);
                break;
            }
            case "2": {
                boolean openMode = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
                ManagerUtils.open(fileInfo2, openMode);
                break;
            }
            case "3": 
            case "4": 
            case "7": {
                if (fileInfo2.getAccessMode() != 1) break;
                if (mode.equals("4") && fileInfo2.getDownloaded() == fileInfo2.getLength() && Utils.isQuickViewSupported(fileInfo2)) {
                    Utils.setQuickViewActive(fileInfo2, true);
                    break;
                }
                Utils.launch(fileInfo2);
                break;
            }
            case "5": {
                ManagerUtils.browse(fileInfo2);
                break;
            }
            case "6": {
                DownloadManager dm = fileInfo2.getDownloadManager();
                if (dm == null) break;
                UIFunctionsManager.getUIFunctions().getMDI().popoutEntryByID("DMDetails", dm, PopOutManager.OPT_MAP_ON_TOP);
                break;
            }
            default: {
                int file_index = fileInfo2.getIndex();
                DownloadManager dm = fileInfo2.getDownloadManager();
                boolean canPlay = PlayUtils.canPlayDS(dm, file_index, true) || PlayUtils.canStreamDS(dm, file_index, true);
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    uif.playOrStreamDataSource(fileInfo2, "playdownloadmanager", false, false);
                    return;
                }
                if (fileInfo2.getAccessMode() != 1) break;
                Utils.launch(fileInfo2);
            }
        }
    }

    private boolean doTreeAction(List<FilesViewNodeInner> nodes, int action, boolean test_only) {
        if (!Utils.isSWTThread()) {
            Debug.out("eh?");
        }
        try {
            this.update_header_pending = true;
            TableRowCore[] tv_rows = this.tv.getRowsAndSubRows(true);
            HashMap<FilesViewNodeInner, TableRowCore> node_to_row_map = new HashMap<FilesViewNodeInner, TableRowCore>();
            TableRowCore[] tableRowCoreArray = tv_rows;
            int n = tv_rows.length;
            int n2 = 0;
            while (n2 < n) {
                TableRowCore tv_row = tableRowCoreArray[n2];
                com.biglybt.core.disk.DiskManagerFileInfo ds_file = (com.biglybt.core.disk.DiskManagerFileInfo)tv_row.getDataSource(true);
                if (ds_file instanceof FilesViewNodeInner) {
                    node_to_row_map.put((FilesViewNodeInner)ds_file, tv_row);
                }
                ++n2;
            }
            for (FilesViewNodeInner node : nodes) {
                if (!this.doTreeAction(node_to_row_map, node, action, true, test_only) || !test_only) continue;
                return true;
            }
        }
        finally {
            this.update_header_pending = false;
            this.updateHeader();
        }
        return false;
    }

    private boolean doTreeAction(Map<FilesViewNodeInner, TableRowCore> node_to_row_map, FilesViewNodeInner node, int action, boolean recursive, boolean test_only) {
        if (!node.isExpanded() && action == 0) {
            if (test_only) {
                return true;
            }
            TableRowCore row = node_to_row_map.get(node);
            if (row != null) {
                row.setExpanded(true);
            }
        }
        if (recursive) {
            List<FilesViewTreeNode> kids = node.getKids();
            for (FilesViewTreeNode kid : kids) {
                if (!(kid instanceof FilesViewNodeInner) || !this.doTreeAction(node_to_row_map, (FilesViewNodeInner)kid, action, recursive, test_only) || !test_only) continue;
                return true;
            }
        }
        if (node.isExpanded() && action == 1) {
            if (test_only) {
                return true;
            }
            FilesViewNodeInner n = node.getParent();
            ArrayList<FilesViewNodeInner> path = new ArrayList<FilesViewNodeInner>();
            while (n != null) {
                path.add(n);
                n = n.getParent();
            }
            int i = path.size() - 1;
            while (i >= 0) {
                n = (FilesViewNodeInner)path.get(i);
                if (!n.isExpanded()) {
                    TableRowCore r = node_to_row_map.get(n);
                    r.setExpanded(true);
                }
                --i;
            }
            TableRowCore row = node_to_row_map.get(node);
            if (row != null) {
                row.setExpanded(false);
            }
        }
        return false;
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        if (this.managers.length != 0) {
            if (this.managers.length == 1) {
                Object[] data_sources = this.tv.getSelectedDataSources().toArray();
                ArrayList<com.biglybt.core.disk.DiskManagerFileInfo> files = new ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>();
                ArrayList<FilesViewNodeInner> inners = new ArrayList<FilesViewNodeInner>();
                ArrayList<com.biglybt.core.disk.DiskManagerFileInfo> inner_files = new ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>();
                HashMap<com.biglybt.core.disk.DiskManagerFileInfo, String> structure_map = new HashMap<com.biglybt.core.disk.DiskManagerFileInfo, String>();
                int i = 0;
                while (i < data_sources.length) {
                    com.biglybt.core.disk.DiskManagerFileInfo file = (com.biglybt.core.disk.DiskManagerFileInfo)data_sources[i];
                    if (file instanceof FilesViewNodeInner) {
                        FilesViewNodeInner inner = (FilesViewNodeInner)file;
                        List<com.biglybt.core.disk.DiskManagerFileInfo> temp = inner.getFiles(true);
                        String path = inner.getNodePath();
                        for (com.biglybt.core.disk.DiskManagerFileInfo f : temp) {
                            structure_map.put(f, path);
                        }
                        inner_files.addAll(temp);
                        inners.add(inner);
                    } else {
                        files.add(file);
                    }
                    ++i;
                }
                if (!files.isEmpty()) {
                    FilesViewMenuUtil.fillMenu(this.tv, sColumnName, menu, new DownloadManager[]{this.managers[0]}, new com.biglybt.core.disk.DiskManagerFileInfo[][]{files.toArray(new com.biglybt.core.disk.DiskManagerFileInfo[files.size()])}, null, false, false);
                } else if (!inners.isEmpty()) {
                    MenuItem mi = new MenuItem(menu, 8);
                    mi.setText(MessageText.getString("label.expand.all"));
                    mi.addListener(13, e -> this.doTreeAction(inners, 0, false));
                    mi.setEnabled(this.doTreeAction(inners, 0, true));
                    mi = new MenuItem(menu, 8);
                    mi.setText(MessageText.getString("menu.collapse.all"));
                    mi.addListener(13, e -> this.doTreeAction(inners, 1, false));
                    mi.setEnabled(this.doTreeAction(inners, 1, true));
                    new MenuItem(menu, 2);
                    if (!inner_files.isEmpty()) {
                        FilesViewMenuUtil.fillMenu(this.tv, sColumnName, menu, new DownloadManager[]{this.managers[0]}, new com.biglybt.core.disk.DiskManagerFileInfo[][]{inner_files.toArray(new com.biglybt.core.disk.DiskManagerFileInfo[inner_files.size()])}, structure_map, false, true);
                        MenuBuildUtils.addSeparator(menu);
                    }
                }
            } else {
                Object[] data_sources = this.tv.getSelectedDataSources().toArray();
                IdentityHashMap<DownloadManager, ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>> map = new IdentityHashMap<DownloadManager, ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>>();
                ArrayList<DownloadManager> dms = new ArrayList<DownloadManager>();
                Object[] file = data_sources;
                int mi = data_sources.length;
                int structure_map = 0;
                while (structure_map < mi) {
                    Object ds = file[structure_map];
                    com.biglybt.core.disk.DiskManagerFileInfo file2 = (com.biglybt.core.disk.DiskManagerFileInfo)ds;
                    if (!(file2 instanceof FilesViewNodeInner)) {
                        DownloadManager dm = file2.getDownloadManager();
                        ArrayList<com.biglybt.core.disk.DiskManagerFileInfo> list = (ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>)map.get(dm);
                        if (list == null) {
                            list = new ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>(dm.getDiskManagerFileInfoSet().nbFiles());
                            map.put(dm, list);
                            dms.add(dm);
                        }
                        list.add(file2);
                    }
                    ++structure_map;
                }
                DownloadManager[] manager_list = dms.toArray(new DownloadManager[dms.size()]);
                com.biglybt.core.disk.DiskManagerFileInfo[][] files_list = new com.biglybt.core.disk.DiskManagerFileInfo[manager_list.length][];
                int i = 0;
                while (i < manager_list.length) {
                    List list = (List)map.get(manager_list[i]);
                    files_list[i] = list.toArray(new com.biglybt.core.disk.DiskManagerFileInfo[list.size()]);
                    ++i;
                }
                if (files_list.length > 0) {
                    FilesViewMenuUtil.fillMenu(this.tv, sColumnName, menu, manager_list, files_list, null, true, false);
                }
            }
        }
    }

    @Override
    public void tableRefresh() {
        if (this.refreshing) {
            return;
        }
        try {
            this.refreshing = true;
            if (this.tv.isDisposed()) {
                return;
            }
            this.updateTable();
        }
        finally {
            this.refreshing = false;
        }
    }

    @Override
    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
        switch (sColumnName) {
            case "path": {
                this.path_item = new MenuItem(menuThisColumn, 32);
                boolean show_full_path = COConfigurationManager.getBooleanParameter("FilesView.show.full.path");
                this.path_item.setSelection(show_full_path);
                Messages.setLanguageText((Widget)this.path_item, "FilesView.menu.showfullpath");
                this.path_item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        boolean show_full_path = FilesView.this.path_item.getSelection();
                        FilesView.this.tv.columnInvalidate("path");
                        FilesView.this.tv.refreshTable(false);
                        COConfigurationManager.setParameter("FilesView.show.full.path", show_full_path);
                    }
                });
                break;
            }
            case "file_eta": {
                boolean eta_absolute = COConfigurationManager.getBooleanParameter("mtv.eta.show_absolute", false);
                final MenuItem item = new MenuItem(menuThisColumn, 32);
                Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.eta.abs");
                item.setSelection(eta_absolute);
                item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        boolean eta_absolute = item.getSelection();
                        FilesView.this.tv.columnInvalidate("eta");
                        FilesView.this.tv.refreshTable(false);
                        COConfigurationManager.setParameter("mtv.eta.show_absolute", eta_absolute);
                    }
                });
                break;
            }
            case "priority": {
                final MenuItem item = new MenuItem(menuThisColumn, 32);
                Messages.setLanguageText((Widget)item, "FilesView.hide.dnd");
                item.setSelection(this.hide_dnd_files);
                item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        FilesView.this.hide_dnd_files = item.getSelection();
                        COConfigurationManager.setParameter("FilesView.hide.dnd", FilesView.this.hide_dnd_files);
                    }
                });
            }
        }
    }

    @Override
    public void tableLifeCycleEventOccurred(TableView tv, int eventType, Map<String, Object> data) {
        switch (eventType) {
            case 0: {
                this.createDragDrop();
                this.hide_dnd_files = COConfigurationManager.getBooleanParameter("FilesView.hide.dnd");
                COConfigurationManager.addParameterListener("FilesView.hide.dnd", (ParameterListener)this);
                this.addManagerListeners(this.managers);
                break;
            }
            case 1: {
                COConfigurationManager.removeParameterListener("FilesView.hide.dnd", this);
                this.removeManagerListeners(this.managers);
                this.tree_file_map.clear();
            }
        }
    }

    @Override
    public void tableViewTabInitComplete() {
        this.updateSelectedContent();
        super.tableViewTabInitComplete();
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    private void createDragDrop() {
        try {
            Transfer[] types = new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance()};
            DragSource dragSource = this.tv.createDragSource(3);
            if (dragSource != null) {
                dragSource.setTransfer(types);
                dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){
                    private String eventData1;
                    private String[] eventData2;

                    public void dragStart(DragSourceEvent event2) {
                        TableRowCore[] rows = FilesView.this.tv.getSelectedRows();
                        if (rows.length == 0 || FilesView.this.managers.length <= 0) {
                            event2.doit = false;
                            return;
                        }
                        event2.doit = true;
                        Object[] selectedDownloads = FilesView.this.tv.getSelectedDataSources().toArray();
                        this.eventData2 = new String[selectedDownloads.length];
                        this.eventData1 = "DiskManagerFileInfo\n";
                        int i = 0;
                        while (i < selectedDownloads.length) {
                            com.biglybt.core.disk.DiskManagerFileInfo fi = (com.biglybt.core.disk.DiskManagerFileInfo)selectedDownloads[i];
                            try {
                                TOTorrent torrent = fi.getDownloadManager().getTorrent();
                                if (torrent != null) {
                                    this.eventData1 = String.valueOf(this.eventData1) + torrent.getHashWrapper().toBase32String() + ";" + fi.getIndex() + "\n";
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                this.eventData2[i] = fi.getFile(true).getAbsolutePath();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++i;
                        }
                    }

                    public void dragSetData(DragSourceEvent event2) {
                        event2.data = FileTransfer.getInstance().isSupportedType(event2.dataType) ? this.eventData2 : this.eventData1;
                    }
                });
            }
        }
        catch (Throwable t) {
            Logger.log(new LogEvent(LogIDs.GUI, "failed to init drag-n-drop", t));
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        boolean b = super.eventOccurred(event2);
        int type = event2.getType();
        if (type == 3) {
            this.updateSelectedContent();
        } else if (type == 4) {
            SelectedContentManager.clearCurrentlySelectedContent();
        } else if (type == 7) {
            this.col_filter_helper = null;
        }
        return b;
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 0x100000B && (e.stateMask & SWT.MODIFIER_MASK) == 0) {
            FilesViewMenuUtil.rename(this.tv, this.tv.getSelectedDataSources(true), null, true, false, false, false);
            e.doit = false;
        } else {
            Composite table_composite = this.tv.getComposite();
            char character = e.character;
            if (e.widget == table_composite && (character == ' ' || character == '+' || character == '-')) {
                Object[] data_sources = this.tv.getSelectedDataSources().toArray();
                ArrayList<com.biglybt.core.disk.DiskManagerFileInfo> files = new ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>();
                boolean all_skipped = true;
                int i = 0;
                while (i < data_sources.length) {
                    com.biglybt.core.disk.DiskManagerFileInfo file = (com.biglybt.core.disk.DiskManagerFileInfo)data_sources[i];
                    if (file instanceof FilesViewNodeInner) {
                        int state;
                        FilesViewNodeInner inner = (FilesViewNodeInner)file;
                        inner.getFiles(files, true);
                        if (all_skipped && (state = inner.getSkippedState()) != 0) {
                            all_skipped = false;
                        }
                    } else {
                        files.add(file);
                        if (all_skipped && !file.isSkipped()) {
                            all_skipped = false;
                        }
                    }
                    ++i;
                }
                if (character == ' ') {
                    FilesViewMenuUtil.setSkipped(files, !all_skipped, 2, true);
                } else {
                    for (com.biglybt.core.disk.DiskManagerFileInfo file : files) {
                        int pri = file.getPriority();
                        file.setPriority(character == '+' ? pri + 1 : pri - 1);
                    }
                }
                e.doit = false;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void parameterChanged(String parameterName) {
        if ("FilesView.hide.dnd".equals(parameterName)) {
            this.hide_dnd_files = COConfigurationManager.getBooleanParameter(parameterName);
            if (this.btnShowDND != null && !this.btnShowDND.isDisposed()) {
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (FilesView.this.btnShowDND != null && !FilesView.this.btnShowDND.isDisposed()) {
                            FilesView.this.btnShowDND.setSelection(FilesView.this.hide_dnd_files);
                        }
                    }
                });
            }
            if (this.tv == null || this.tv.isDisposed()) {
                return;
            }
            this.tv.refilter();
        }
    }

    private void updateHeader() {
        int visible_rows;
        if (this.managers.length == 0) {
            if (this.lblHeader != null) {
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (FilesView.this.lblHeader == null || FilesView.this.lblHeader.isDisposed()) {
                            return;
                        }
                        FilesView.this.lblHeader.setText("");
                    }
                });
            }
            return;
        }
        int total_rows = 0;
        if (this.tree_view) {
            int[] nums = this.tv.getRowAndSubRowCount();
            total_rows = nums[0];
            visible_rows = nums[1];
        } else {
            DownloadManager[] downloadManagerArray = this.managers;
            int n = this.managers.length;
            int n2 = 0;
            while (n2 < n) {
                DownloadManager manager = downloadManagerArray[n2];
                total_rows += manager.getNumFileInfos();
                ++n2;
            }
            visible_rows = this.tv.getRowCount();
        }
        String s = MessageText.getString("library.unopened.header" + (total_rows > 1 ? ".p" : ""), new String[]{String.valueOf(total_rows)});
        if (total_rows != visible_rows) {
            s = MessageText.getString("v3.MainWindow.xofx", new String[]{String.valueOf(visible_rows), s});
        }
        final String sHeader = s = String.valueOf(s) + this.getSelectionText();
        if (this.lblHeader != null) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    if (FilesView.this.lblHeader == null || FilesView.this.lblHeader.isDisposed()) {
                        return;
                    }
                    FilesView.this.lblHeader.setText(sHeader);
                }
            });
        }
    }

    private String getSelectionText() {
        int selection_count = this.tv.getSelectedRowsSize();
        if (selection_count == 0) {
            return "";
        }
        String str = ", " + MessageText.getString("label.num_selected", new String[]{String.valueOf(selection_count)});
        if (this.selection_size_with_dnd > 0L) {
            str = this.selection_size == this.selection_size_with_dnd ? (this.selection_size == this.selection_done ? String.valueOf(str) + " (" + DisplayFormatters.formatByteCountToKiBEtc(this.selection_size) + ")" : String.valueOf(str) + " (" + DisplayFormatters.formatByteCountToKiBEtc(this.selection_done) + "/" + DisplayFormatters.formatByteCountToKiBEtc(this.selection_size) + ")") : String.valueOf(str) + " (" + DisplayFormatters.formatByteCountToKiBEtc(this.selection_done) + "/" + DisplayFormatters.formatByteCountToKiBEtc(this.selection_size) + "/" + DisplayFormatters.formatByteCountToKiBEtc(this.selection_size_with_dnd) + ")";
        }
        return str;
    }

    public void setDisableWhenEmpty(boolean b) {
        this.disableTableWhenEmpty = b;
    }

    @Override
    public void rowExpanded(TableRowCore row) {
        this.updateTreeExpansionState(row, true);
    }

    @Override
    public void rowCollapsed(TableRowCore row) {
        this.updateTreeExpansionState(row, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTreeExpansionState(TableRowCore row, boolean expanded) {
        FilesViewNodeInner node;
        DownloadManager dm;
        Object ds = row.getDataSource(true);
        if (ds instanceof FilesViewNodeInner && (dm = (node = (FilesViewNodeInner)ds).getDownloadManager()) != null) {
            int uid = node.getUID();
            Object object = KEY_DM_TREE_STATE;
            synchronized (object) {
                HashMap<Integer, Boolean> map = (HashMap<Integer, Boolean>)dm.getUserData(KEY_DM_TREE_STATE);
                if (map == null) {
                    map = new HashMap<Integer, Boolean>();
                    dm.setUserData(KEY_DM_TREE_STATE, map);
                }
                if (expanded) {
                    map.remove(uid);
                } else {
                    map.put(uid, Boolean.TRUE);
                }
            }
        }
    }

    private void updateTable() {
        Map<DownloadManager, Set<Integer>> to_select;
        boolean sync = false;
        if (this.selection_outstanding != null) {
            sync = true;
            to_select = this.selection_outstanding;
            this.selection_outstanding = null;
        } else {
            to_select = null;
        }
        if (!this.tree_view) {
            this.updateFlatView(sync);
        } else {
            this.updateTreeView(sync);
        }
        if (to_select != null) {
            AEThread2.createAndStartDaemon("TableSelector", () -> {
                long start = SystemTime.getMonotonousTime();
                while (this.tv.hasChangesPending()) {
                    if (SystemTime.getMonotonousTime() - start > 5000L) {
                        return;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                Utils.execSWTThread(() -> {
                    TableRowCore[] tv_rows;
                    ArrayList<TableRowCore> selected_rows = new ArrayList<TableRowCore>();
                    TableRowCore[] tableRowCoreArray = tv_rows = this.tv.getRowsAndSubRows(false);
                    int n = tv_rows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableRowCore tv_row = tableRowCoreArray[n2];
                        com.biglybt.core.disk.DiskManagerFileInfo ds_file = (com.biglybt.core.disk.DiskManagerFileInfo)tv_row.getDataSource(true);
                        Set sel = (Set)to_select.get(ds_file.getDownloadManager());
                        if (sel != null) {
                            if (ds_file instanceof FilesViewNodeInner) {
                                FilesViewNodeInner node = (FilesViewNodeInner)ds_file;
                                if (sel.contains(node.getUID() + 1000000000)) {
                                    selected_rows.add(tv_row);
                                }
                            } else if (sel.contains(ds_file.getIndex())) {
                                selected_rows.add(tv_row);
                            }
                        }
                        ++n2;
                    }
                    if (!selected_rows.isEmpty()) {
                        this.tv.setSelectedRows(selected_rows.toArray(new TableRowCore[0]));
                    }
                });
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTreeView(boolean sync) {
        int num_managers = this.managers.length;
        boolean wait_until_idle = false;
        if (num_managers == 0) {
            if (this.tv.getRowCount() > 0) {
                this.tv.removeAllTableRows();
                if (sync) {
                    this.tv.processDataSourceQueueSync();
                } else {
                    this.tv.processDataSourceQueue();
                }
            }
            this.current_root = null;
        } else if (num_managers == 1) {
            wait_until_idle = this.force_refresh;
            DownloadManager dm = this.managers[0];
            if (this.force_refresh || this.current_root == null || this.current_root.dm != dm || this.tv.getRowCount() == 0) {
                this.force_refresh = false;
                this.tv.removeAllTableRows();
                char file_separator = File.separatorChar;
                int uid = 0;
                FilesViewNodeInner root = this.current_root = new FilesViewNodeInner(dm, uid, dm.getDisplayName(), new StringInterner.FileKey(""), null);
                Map<TOTorrentFile, FilesViewNodeLeaf> map = this.tree_file_map;
                synchronized (map) {
                    com.biglybt.core.disk.DiskManagerFileInfo[] files;
                    HashMap expansion_state;
                    this.tree_file_map.clear();
                    Object object = KEY_DM_TREE_STATE;
                    synchronized (object) {
                        expansion_state = (HashMap)dm.getUserData(KEY_DM_TREE_STATE);
                        expansion_state = expansion_state == null ? new HashMap() : new HashMap(expansion_state);
                    }
                    if (expansion_state.containsKey(uid)) {
                        root.setExpanded(false);
                    }
                    ++uid;
                    com.biglybt.core.disk.DiskManagerFileInfo[] diskManagerFileInfoArray = files = dm.getDiskManagerFileInfoSet().getFiles();
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        com.biglybt.core.disk.DiskManagerFileInfo file = diskManagerFileInfoArray[n2];
                        FilesViewNodeInner node = root;
                        TOTorrentFile t_file = file.getTorrentFile();
                        String path = t_file.getRelativePath();
                        int pos = 0;
                        StringInterner.DirKey subfolder = new StringInterner.DirKey("");
                        while (true) {
                            int p;
                            if ((p = path.indexOf(file_separator, pos)) == -1) break;
                            String bit = path.substring(pos, p);
                            pos = p + 1;
                            FilesViewNodeInner n3 = (FilesViewNodeInner)node.getChild(bit);
                            if (n3 == null) {
                                n3 = new FilesViewNodeInner(dm, uid, bit, subfolder, node);
                                if (expansion_state.containsKey(uid)) {
                                    n3.setExpanded(false);
                                }
                                ++uid;
                                node.addChild(n3);
                            }
                            subfolder = subfolder.isEmpty() ? new StringInterner.DirKey(bit) : new StringInterner.DirKey(subfolder, bit);
                            node = n3;
                        }
                        FilesViewNodeLeaf leaf = new FilesViewNodeLeaf(path, file, node);
                        node.addFile(leaf);
                        this.tree_file_map.put(t_file, leaf);
                        ++n2;
                    }
                }
                this.tv.addDataSource(root);
                this.tv.processDataSourceQueueSync();
            }
        } else {
            int n;
            if (this.current_root != null) {
                Object[] kids = this.current_root.getChildDataSources();
                if (kids.length != num_managers) {
                    this.force_refresh = true;
                } else {
                    IdentityHashSet<DownloadManager> kids_set = new IdentityHashSet<DownloadManager>();
                    Object[] objectArray = kids;
                    n = kids.length;
                    int root = 0;
                    while (root < n) {
                        Object k = objectArray[root];
                        kids_set.add(((FilesViewNodeInner)k).getDownloadManager());
                        ++root;
                    }
                    int i = 0;
                    while (i < num_managers) {
                        if (!kids_set.contains(this.managers[i])) {
                            this.force_refresh = true;
                        }
                        ++i;
                    }
                }
            }
            if (this.force_refresh || this.current_root == null || this.tv.getRowCount() == 0) {
                wait_until_idle = this.force_refresh;
                this.force_refresh = false;
                this.tv.removeAllTableRows();
                Map<TOTorrentFile, FilesViewNodeLeaf> map = this.tree_file_map;
                synchronized (map) {
                    this.current_root = new FilesViewNodeInner(null, -1, MessageText.getString("label.downloads"), new StringInterner.FileKey(""), null);
                    this.tree_file_map.clear();
                    char file_separator = File.separatorChar;
                    int num = 0;
                    DownloadManager[] downloadManagerArray = this.managers;
                    int n4 = this.managers.length;
                    n = 0;
                    while (n < n4) {
                        com.biglybt.core.disk.DiskManagerFileInfo[] files;
                        HashMap expansion_state;
                        DownloadManager dm = downloadManagerArray[n];
                        int uid = 0;
                        FilesViewNodeInner root = new FilesViewNodeInner(dm, uid, "(" + ++num + ") " + dm.getDisplayName(), new StringInterner.FileKey(""), this.current_root);
                        Object object = KEY_DM_TREE_STATE;
                        synchronized (object) {
                            expansion_state = (HashMap)dm.getUserData(KEY_DM_TREE_STATE);
                            expansion_state = expansion_state == null ? new HashMap() : new HashMap(expansion_state);
                        }
                        if (expansion_state.containsKey(uid)) {
                            root.setExpanded(false);
                        }
                        ++uid;
                        this.current_root.addChild(root);
                        com.biglybt.core.disk.DiskManagerFileInfo[] diskManagerFileInfoArray = files = dm.getDiskManagerFileInfoSet().getFiles();
                        int n5 = files.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            com.biglybt.core.disk.DiskManagerFileInfo file = diskManagerFileInfoArray[n6];
                            FilesViewNodeInner node = root;
                            TOTorrentFile t_file = file.getTorrentFile();
                            String path = t_file.getRelativePath();
                            int pos = 0;
                            StringInterner.DirKey subfolder = new StringInterner.DirKey("");
                            while (true) {
                                int p;
                                if ((p = path.indexOf(file_separator, pos)) == -1) break;
                                String bit = path.substring(pos, p);
                                pos = p + 1;
                                FilesViewNodeInner n7 = (FilesViewNodeInner)node.getChild(bit);
                                if (n7 == null) {
                                    n7 = new FilesViewNodeInner(dm, uid, bit, subfolder, node);
                                    if (expansion_state.containsKey(uid)) {
                                        n7.setExpanded(false);
                                    }
                                    ++uid;
                                    node.addChild(n7);
                                }
                                subfolder = subfolder.isEmpty() ? new StringInterner.DirKey(bit) : new StringInterner.DirKey(subfolder, bit);
                                node = n7;
                            }
                            FilesViewNodeLeaf leaf = new FilesViewNodeLeaf(path, file, node);
                            node.addFile(leaf);
                            this.tree_file_map.put(t_file, leaf);
                            ++n6;
                        }
                        ++n;
                    }
                }
                this.tv.addDataSource(this.current_root);
                this.tv.processDataSourceQueueSync();
            }
        }
        if (wait_until_idle) {
            AEThread2.createAndStartDaemon("TableSorter", () -> {
                long start = SystemTime.getMonotonousTime();
                while (this.tv.hasChangesPending()) {
                    if (SystemTime.getMonotonousTime() - start > 5000L) {
                        return;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
    }

    @Override
    public void parentDataSourceChanged(Object newParentDataSource) {
        super.parentDataSourceChanged(newParentDataSource);
        this.tableDataSourceChanged(newParentDataSource);
    }

    @Override
    public Object getTitleInfoProperty(int propertyID) {
        if (propertyID == 0) {
            int count = 0;
            DownloadManager[] downloadManagerArray = this.managers;
            int n = this.managers.length;
            int n2 = 0;
            while (n2 < n) {
                DownloadManager manager = downloadManagerArray[n2];
                count += manager.getNumFileInfos();
                ++n2;
            }
            return count == 0 ? null : "" + count;
        }
        return null;
    }

    private void updateFlatView(boolean sync) {
        if (!this.force_refresh) {
            return;
        }
        if (!sync && Utils.isSWTThread()) {
            Utils.getOffOfSWTThread(() -> this.updateFlatView(false));
            return;
        }
        this.force_refresh = false;
        List<com.biglybt.core.disk.DiskManagerFileInfo> files = this.getFileInfo();
        if (files.size() == 0) {
            this.tv.removeAllTableRows();
        } else {
            HashSet<Object> toRemove = this.tv.getDataSources(true);
            if (toRemove.size() - files.size() > 50000) {
                this.tv.removeAllTableRows();
                toRemove = new HashSet();
            }
            ArrayList<com.biglybt.core.disk.DiskManagerFileInfo> toAdd = new ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>();
            for (com.biglybt.core.disk.DiskManagerFileInfo info : files) {
                if (toRemove.contains(info)) {
                    toRemove.remove(info);
                    continue;
                }
                toAdd.add(info);
            }
            this.tv.removeDataSources((com.biglybt.core.disk.DiskManagerFileInfo[])toRemove.toArray(new com.biglybt.core.disk.DiskManagerFileInfo[0]));
            this.tv.addDataSources((com.biglybt.core.disk.DiskManagerFileInfo[])toAdd.toArray(new com.biglybt.core.disk.DiskManagerFileInfo[0]));
            this.tv.tableInvalidate();
            if (sync) {
                this.tv.processDataSourceQueueSync();
            } else {
                this.tv.processDataSourceQueue();
            }
            AEThread2.createAndStartDaemon("TableSorter", () -> {
                long start = SystemTime.getMonotonousTime();
                while (this.tv.hasChangesPending()) {
                    if (SystemTime.getMonotonousTime() - start > 5000L) {
                        return;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private List<com.biglybt.core.disk.DiskManagerFileInfo> getFileInfo() {
        ArrayList<com.biglybt.core.disk.DiskManagerFileInfo> temp = new ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>();
        if (this.managers.length == 0) {
            return temp;
        }
        if (this.managers.length == 1) {
            com.biglybt.core.disk.DiskManagerFileInfo[] files = this.managers[0].getDiskManagerFileInfoSet().getFiles();
            temp.addAll(Arrays.asList(files));
        } else {
            DownloadManager[] downloadManagerArray = this.managers;
            int n = this.managers.length;
            int n2 = 0;
            while (n2 < n) {
                DownloadManager dm = downloadManagerArray[n2];
                temp.addAll(Arrays.asList(dm.getDiskManagerFileInfoSet().getFiles()));
                ++n2;
            }
        }
        return temp;
    }

    static /* synthetic */ Comparator access$1() {
        return tree_comp;
    }

    private static class FilesViewNodeInner
    implements com.biglybt.core.disk.DiskManagerFileInfo,
    FilesViewTreeNode,
    TableRowSWTChildController {
        private final DownloadManager dm;
        private final int uid;
        private final String node_name;
        private final StringInterner.FileKey node_path;
        private final FilesViewNodeInner parent;
        private final Map<String, FilesViewTreeNode> kids = new TreeMap<String, FilesViewTreeNode>(FilesView.access$1());
        private boolean expanded = true;
        private long size;
        private int[] pieceInfo;

        private FilesViewNodeInner(DownloadManager _dm, int _uid, String _node_name, StringInterner.FileKey _node_path, FilesViewNodeInner _parent) {
            this.dm = _dm;
            this.uid = _uid;
            this.node_name = StringInterner.intern(_node_name);
            this.node_path = _node_path;
            this.parent = _parent;
        }

        protected int getUID() {
            return this.uid;
        }

        @Override
        public FilesViewNodeInner getParent() {
            return this.parent;
        }

        @Override
        public List<FilesViewTreeNode> getKids() {
            return new ArrayList<FilesViewTreeNode>(this.kids.values());
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        private FilesViewTreeNode getChild(String name) {
            return this.kids.get(name);
        }

        private void addChild(FilesViewNodeInner child) {
            this.kids.put(child.getName(), child);
        }

        protected List<com.biglybt.core.disk.DiskManagerFileInfo> getFiles(boolean recursive) {
            ArrayList<com.biglybt.core.disk.DiskManagerFileInfo> result = new ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>();
            this.getFiles(result, recursive);
            return result;
        }

        private void getFiles(List<com.biglybt.core.disk.DiskManagerFileInfo> files, boolean recursive) {
            for (FilesViewTreeNode kid : this.kids.values()) {
                if (kid.isLeaf()) {
                    files.add(((FilesViewNodeLeaf)kid).getTarget());
                    continue;
                }
                if (!recursive) continue;
                ((FilesViewNodeInner)kid).getFiles(files, recursive);
            }
        }

        @Override
        public String getName() {
            return this.node_name;
        }

        protected String getNodePath() {
            return String.valueOf(this.node_path.toString()) + File.separator + this.node_name;
        }

        @Override
        public boolean isExpanded() {
            return this.expanded;
        }

        @Override
        public void setExpanded(boolean e) {
            this.expanded = e;
        }

        @Override
        public int getDepth() {
            if (this.parent == null) {
                return 0;
            }
            return this.parent.getDepth() + 1;
        }

        private void addFile(FilesViewNodeLeaf f) {
            this.kids.put(f.getName(), f);
        }

        @Override
        public Object[] getChildDataSources() {
            return this.kids.values().toArray();
        }

        @Override
        public void setPriority(int p) {
        }

        @Override
        public void setSkipped(boolean b) {
            ArrayList<FilesViewNodeLeaf> leaves = new ArrayList<FilesViewNodeLeaf>();
            this.getLeaves(leaves);
            ArrayList<com.biglybt.core.disk.DiskManagerFileInfo> delegates = new ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>(leaves.size());
            for (FilesViewNodeLeaf l : leaves) {
                delegates.add(l.getTarget());
            }
            ManagerUtils.setFilesSkipped(delegates, b);
        }

        @Override
        public void getLeaves(List<FilesViewNodeLeaf> result) {
            for (FilesViewTreeNode kid : this.kids.values()) {
                kid.getLeaves(result);
            }
        }

        @Override
        public Boolean isSkipping() {
            Boolean result = null;
            for (FilesViewTreeNode kid : this.kids.values()) {
                Boolean k = kid.isSkipping();
                if (k == null) {
                    if (result == null) continue;
                    return null;
                }
                if (result == null) {
                    result = k;
                    continue;
                }
                if (result.booleanValue() == k.booleanValue()) continue;
                return null;
            }
            return result;
        }

        @Override
        public boolean setLink(File link_destination, boolean no_delete) {
            return false;
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public String getLastError() {
            return "Invalid operation on tree node";
        }

        @Override
        public boolean setLinkAtomic(File link_destination, boolean no_delete) {
            return false;
        }

        @Override
        public boolean setLinkAtomic(File link_destination, boolean no_delete, FileUtil.ProgressListener pl) {
            return false;
        }

        @Override
        public File getLink() {
            return null;
        }

        @Override
        public boolean setStorageType(int type, boolean force) {
            return false;
        }

        @Override
        public int getStorageType() {
            return -1;
        }

        @Override
        public int getAccessMode() {
            return -1;
        }

        @Override
        public long getDownloaded() {
            long temp = 0L;
            for (FilesViewTreeNode kid : this.kids.values()) {
                temp += kid.getDownloaded();
            }
            return temp;
        }

        @Override
        public long getLastModified() {
            return -1L;
        }

        @Override
        public String getExtension() {
            return "";
        }

        @Override
        public int getFirstPieceNumber() {
            if (this.dm == null) {
                return -1;
            }
            if (this.pieceInfo == null) {
                this.getPieceInfo();
            }
            return this.pieceInfo[0];
        }

        @Override
        public int getLastPieceNumber() {
            if (this.dm == null) {
                return -1;
            }
            if (this.pieceInfo == null) {
                this.getPieceInfo();
            }
            return this.pieceInfo[1];
        }

        private void getPieceInfo() {
            int[] nArray = new int[2];
            nArray[0] = Integer.MAX_VALUE;
            int[] temp = nArray;
            this.getPieceInfo(temp);
            this.pieceInfo = temp;
        }

        @Override
        public void getPieceInfo(int[] data) {
            for (FilesViewTreeNode kid : this.kids.values()) {
                kid.getPieceInfo(data);
            }
        }

        @Override
        public int getNbPieces() {
            if (this.dm == null) {
                return -1;
            }
            return this.getLastPieceNumber() - this.getFirstPieceNumber() + 1;
        }

        @Override
        public long getLength() {
            if (this.size == 0L) {
                long temp = 0L;
                for (FilesViewTreeNode kid : this.kids.values()) {
                    temp += kid.getLength();
                }
                this.size = temp;
            }
            return this.size;
        }

        @Override
        public int getPriority() {
            return -1;
        }

        @Override
        public boolean isSkipped() {
            return false;
        }

        @Override
        public int getSkippedState() {
            boolean all_skipped = true;
            boolean all_not_skipped = true;
            for (FilesViewTreeNode kid : this.kids.values()) {
                int state = kid.getSkippedState();
                if (state == 0) {
                    all_not_skipped = false;
                    continue;
                }
                if (state == 1) {
                    all_skipped = false;
                    continue;
                }
                return 2;
            }
            if (all_skipped) {
                return 0;
            }
            if (all_not_skipped) {
                return 1;
            }
            return 2;
        }

        @Override
        public int getIndex() {
            return -1;
        }

        @Override
        public DownloadManager getDownloadManager() {
            return this.dm;
        }

        @Override
        public DiskManager getDiskManager() {
            return this.dm == null ? null : this.dm.getDiskManager();
        }

        @Override
        public File getFile(boolean follow_link) {
            return this.node_path.isEmpty() ? new File(this.node_name) : new File(this.node_path.getFile(), this.node_name);
        }

        @Override
        public TOTorrentFile getTorrentFile() {
            return null;
        }

        @Override
        public DirectByteBuffer read(long offset, int length) throws IOException {
            throw new IOException("Not implemented");
        }

        @Override
        public void flushCache() throws Exception {
        }

        @Override
        public int getReadBytesPerSecond() {
            return -1;
        }

        @Override
        public int getWriteBytesPerSecond() {
            return -1;
        }

        @Override
        public long getETA() {
            return -1L;
        }

        @Override
        public void recheck() {
        }

        @Override
        public void close() {
        }

        @Override
        public void addListener(DiskManagerFileInfoListener listener) {
        }

        @Override
        public void removeListener(DiskManagerFileInfoListener listener) {
        }
    }

    private static class FilesViewNodeLeaf
    implements com.biglybt.core.disk.DiskManagerFileInfo,
    FilesViewTreeNode {
        private final String name;
        private final FilesViewNodeInner parent;
        private final com.biglybt.core.disk.DiskManagerFileInfo delegate;

        private FilesViewNodeLeaf(String _name, com.biglybt.core.disk.DiskManagerFileInfo _delegate, FilesViewNodeInner _parent) {
            this.name = _name;
            this.delegate = _delegate;
            this.parent = _parent;
        }

        protected com.biglybt.core.disk.DiskManagerFileInfo getTarget() {
            return this.delegate;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public FilesViewNodeInner getParent() {
            return this.parent;
        }

        @Override
        public List<FilesViewTreeNode> getKids() {
            return Collections.emptyList();
        }

        @Override
        public void getLeaves(List<FilesViewNodeLeaf> result) {
            result.add(this);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public int getDepth() {
            return this.parent.getDepth() + 1;
        }

        @Override
        public void setPriority(int p) {
            this.delegate.setPriority(p);
        }

        @Override
        public void setSkipped(boolean b) {
            ManagerUtils.setFileSkipped(this.delegate, b);
        }

        @Override
        public Boolean isSkipping() {
            return this.delegate.isSkipping();
        }

        @Override
        public boolean setLink(File link_destination, boolean no_delete) {
            return this.delegate.setLink(link_destination, no_delete);
        }

        @Override
        public String getLastError() {
            return this.delegate.getLastError();
        }

        @Override
        public boolean setLinkAtomic(File link_destination, boolean no_delete) {
            return this.delegate.setLinkAtomic(link_destination, no_delete);
        }

        @Override
        public boolean setLinkAtomic(File link_destination, boolean no_delete, FileUtil.ProgressListener pl) {
            return this.delegate.setLinkAtomic(link_destination, no_delete, pl);
        }

        @Override
        public File getLink() {
            return this.delegate.getLink();
        }

        @Override
        public boolean setStorageType(int type, boolean force) {
            return this.delegate.setStorageType(type, force);
        }

        @Override
        public int getStorageType() {
            return this.delegate.getStorageType();
        }

        @Override
        public int getAccessMode() {
            return this.delegate.getAccessMode();
        }

        @Override
        public long getDownloaded() {
            return this.delegate.getDownloaded();
        }

        @Override
        public long getLastModified() {
            return this.delegate.getLastModified();
        }

        @Override
        public String getExtension() {
            return this.delegate.getExtension();
        }

        @Override
        public int getFirstPieceNumber() {
            return this.delegate.getFirstPieceNumber();
        }

        @Override
        public int getLastPieceNumber() {
            return this.delegate.getLastPieceNumber();
        }

        @Override
        public void getPieceInfo(int[] data) {
            int first = this.getFirstPieceNumber();
            int last = this.getLastPieceNumber();
            if (first < data[0]) {
                data[0] = first;
            }
            if (last > data[1]) {
                data[1] = last;
            }
        }

        @Override
        public long getLength() {
            return this.delegate.getLength();
        }

        @Override
        public int getNbPieces() {
            return this.delegate.getNbPieces();
        }

        @Override
        public int getPriority() {
            return this.delegate.getPriority();
        }

        @Override
        public boolean isSkipped() {
            return this.delegate.isSkipped();
        }

        @Override
        public int getSkippedState() {
            if (this.delegate.isSkipped()) {
                return 0;
            }
            return 1;
        }

        @Override
        public boolean exists() {
            return this.delegate.exists();
        }

        @Override
        public int getIndex() {
            return this.delegate.getIndex();
        }

        @Override
        public DownloadManager getDownloadManager() {
            return this.delegate.getDownloadManager();
        }

        @Override
        public DiskManager getDiskManager() {
            return this.delegate.getDiskManager();
        }

        @Override
        public File getFile(boolean follow_link) {
            return this.delegate.getFile(follow_link);
        }

        @Override
        public TOTorrentFile getTorrentFile() {
            return this.delegate.getTorrentFile();
        }

        @Override
        public DirectByteBuffer read(long offset, int length) throws IOException {
            return this.delegate.read(offset, length);
        }

        @Override
        public void flushCache() throws Exception {
            this.delegate.flushCache();
        }

        @Override
        public int getReadBytesPerSecond() {
            return this.delegate.getReadBytesPerSecond();
        }

        @Override
        public int getWriteBytesPerSecond() {
            return this.delegate.getWriteBytesPerSecond();
        }

        @Override
        public long getETA() {
            return this.delegate.getETA();
        }

        @Override
        public void recheck() {
            this.delegate.recheck();
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public void addListener(DiskManagerFileInfoListener listener) {
            this.delegate.addListener(listener);
        }

        @Override
        public void removeListener(DiskManagerFileInfoListener listener) {
            this.delegate.removeListener(listener);
        }
    }

    public static interface FilesViewTreeNode {
        public String getName();

        public FilesViewNodeInner getParent();

        public List<FilesViewTreeNode> getKids();

        public void getLeaves(List<FilesViewNodeLeaf> var1);

        public int getDepth();

        public boolean isLeaf();

        public int getSkippedState();

        public void setSkipped(boolean var1);

        public Boolean isSkipping();

        public void recheck();

        public long getLength();

        public long getDownloaded();

        public void getPieceInfo(int[] var1);
    }
}

