/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.ILogEventListener;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.LogRelation;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.logging.impl.FileLogging;
import com.biglybt.core.util.AERunnable;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import java.io.PrintStream;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class LoggerView
implements ILogEventListener,
ParameterListener,
UISWTViewCoreEventListener {
    public static final String VIEW_ID = "LoggerView";
    private static final int COLOR_INFO = 0;
    private static final int COLOR_WARN = 1;
    private static final int COLOR_ERR = 2;
    private static Color[] colors = null;
    private static final int PREFERRED_LINES = 256;
    private static final int MAX_LINES = 1280;
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("[HH:mm:ss.SSS] ");
    private static final FieldPosition formatPos = new FieldPosition(0);
    public static final String MSGID_PREFIX = "ConsoleView";
    private Display display;
    private Composite main_panel;
    private StyledText consoleText = null;
    private Button buttonAutoScroll = null;
    private Object[] filter = null;
    private LinkedList<LogEvent> buffer = new LinkedList();
    private boolean bPaused = false;
    private boolean bRealtime = false;
    private boolean bEnabled = false;
    private boolean bAutoScroll = true;
    private Pattern inclusionFilter;
    private Pattern exclusionFilter;
    private ArrayList[] ignoredComponents = new ArrayList[3];
    private boolean stopOnNull = false;
    private UISWTView swtView;

    public LoggerView() {
        this(false);
        this.setEnabled(true);
    }

    public LoggerView(boolean stopOnNull) {
        int i = 0;
        while (i < this.ignoredComponents.length) {
            this.ignoredComponents[i] = new ArrayList();
            ++i;
        }
        this.stopOnNull = stopOnNull;
    }

    public LoggerView(List<? extends LogEvent> initialList) {
        this();
        if (initialList != null) {
            this.buffer.addAll(initialList);
        }
        this.setEnabled(true);
    }

    private LoggerView(LoggerView other) {
        this.buffer.addAll(other.buffer);
        int i = 0;
        while (i < this.ignoredComponents.length) {
            this.ignoredComponents[i] = new ArrayList();
            ++i;
        }
        this.stopOnNull = other.stopOnNull;
        this.setEnabled(other.bEnabled);
    }

    private void initialize(Composite composite) {
        this.display = composite.getDisplay();
        Colors.getInstance().addColorsChangedListener(this);
        this.parameterChanged("Color");
        this.main_panel = new Composite(composite, 0);
        this.main_panel.setLayout((Layout)Utils.getSimpleGridLayout(1));
        this.consoleText = new StyledText(this.main_panel, 776);
        GridData gd = new GridData(1808);
        this.consoleText.setLayoutData((Object)gd);
        this.consoleText.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                GC gc = new GC((Drawable)LoggerView.this.consoleText);
                int charWidth = gc.getFontMetrics().getAverageCharWidth();
                gc.dispose();
                int areaWidth = ((LoggerView)LoggerView.this).consoleText.getBounds().width;
                LoggerView.this.consoleText.setTabs(areaWidth / 6 / charWidth);
            }
        });
        this.consoleText.addListener(1, new Listener(){

            public void handleEvent(Event event2) {
                int key = event2.character;
                if (key <= 26 && key > 0) {
                    key += 96;
                }
                if ((event2.stateMask & SWT.MOD1) > 0 && key == 97) {
                    ((StyledText)event2.widget).selectAll();
                }
            }
        });
        ScrollBar sb = this.consoleText.getVerticalBar();
        sb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggerView.this.bAutoScroll = false;
                if (LoggerView.this.buttonAutoScroll != null && !LoggerView.this.buttonAutoScroll.isDisposed()) {
                    LoggerView.this.buttonAutoScroll.setSelection(false);
                }
            }
        });
        CTabFolder tab_folder = new CTabFolder(this.main_panel, 16384);
        tab_folder.setMinimizeVisible(true);
        final Consumer<Boolean> set_minimized = min -> {
            COConfigurationManager.setParameter("loggerview.filter.minimized", min);
            tab_folder.setMinimized(min.booleanValue());
            tab_folder.getParent().layout(true);
        };
        set_minimized.accept(COConfigurationManager.getBooleanParameter("loggerview.filter.minimized"));
        tab_folder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void minimize(CTabFolderEvent event2) {
                set_minimized.accept(true);
            }

            public void restore(CTabFolderEvent event2) {
                this.maximize(event2);
            }

            public void maximize(CTabFolderEvent event2) {
                set_minimized.accept(false);
            }
        });
        tab_folder.addListener(8, e -> set_minimized.accept(!tab_folder.getMinimized()));
        GridData grid_data = new GridData(768);
        tab_folder.setLayoutData((Object)grid_data);
        CTabItem settings_tab = new CTabItem(tab_folder, 0);
        tab_folder.setSelection(settings_tab);
        settings_tab.setText(MessageText.getString("LoggerView.filter"));
        Composite settings_panel = new Composite((Composite)tab_folder, 0);
        settings_tab.setControl((Control)settings_panel);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 2;
        layout.numColumns = 2;
        settings_panel.setLayout((Layout)layout);
        grid_data = new GridData(768);
        settings_panel.setLayoutData((Object)grid_data);
        Composite cLeft = new Composite(settings_panel, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 1;
        cLeft.setLayout((Layout)layout);
        gd = new GridData(128, 16384, false, false);
        cLeft.setLayoutData((Object)gd);
        Button buttonPause = new Button(cLeft, 32);
        Messages.setLanguageText((Widget)buttonPause, "LoggerView.pause");
        gd = new GridData();
        buttonPause.setLayoutData((Object)gd);
        buttonPause.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == null || !(e.widget instanceof Button)) {
                    return;
                }
                Button btn = (Button)e.widget;
                LoggerView.this.bPaused = btn.getSelection();
                if (!LoggerView.this.bPaused && LoggerView.this.buffer != null) {
                    LoggerView.this.refresh();
                }
            }
        });
        Button buttonRealtime = new Button(cLeft, 32);
        Messages.setLanguageText((Widget)buttonRealtime, "LoggerView.realtime");
        gd = new GridData();
        buttonRealtime.setLayoutData((Object)gd);
        buttonRealtime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == null || !(e.widget instanceof Button)) {
                    return;
                }
                Button btn = (Button)e.widget;
                LoggerView.this.bRealtime = btn.getSelection();
            }
        });
        this.buttonAutoScroll = new Button(cLeft, 32);
        Messages.setLanguageText((Widget)this.buttonAutoScroll, "LoggerView.autoscroll");
        gd = new GridData();
        this.buttonAutoScroll.setLayoutData((Object)gd);
        this.buttonAutoScroll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == null || !(e.widget instanceof Button)) {
                    return;
                }
                Button btn = (Button)e.widget;
                LoggerView.this.bAutoScroll = btn.getSelection();
            }
        });
        this.buttonAutoScroll.setSelection(true);
        Button buttonClear = new Button(cLeft, 8);
        Messages.setLanguageText((Widget)buttonClear, "LoggerView.clear");
        gd = new GridData();
        buttonClear.setLayoutData((Object)gd);
        buttonClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggerView.this.consoleText.setText("");
            }
        });
        String sFilterPrefix = "ConfigView.section.logging.filter";
        Group gLogIDs = Utils.createSkinnedGroup(settings_panel, 0);
        Messages.setLanguageText((Widget)gLogIDs, "LoggerView.filter");
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.numColumns = 2;
        gLogIDs.setLayout((Layout)layout);
        gd = new GridData();
        gLogIDs.setLayoutData((Object)gd);
        Label label = new Label((Composite)gLogIDs, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.logging.level");
        label.setLayoutData((Object)new GridData());
        final Label labelCatFilter = new Label((Composite)gLogIDs, 0);
        labelCatFilter.setLayoutData((Object)new GridData(256));
        final org.eclipse.swt.widgets.List listLogTypes = new org.eclipse.swt.widgets.List((Composite)gLogIDs, 2564);
        gd = new GridData(0, 1, false, false);
        listLogTypes.setLayoutData((Object)gd);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 3;
        final int[] logTypes = nArray;
        int i = 0;
        while (i < logTypes.length) {
            listLogTypes.add(MessageText.getString("ConfigView.section.logging.log" + i + "type"));
            ++i;
        }
        listLogTypes.select(0);
        LogIDs[] logIDs = FileLogging.configurableLOGIDs;
        Composite cChecksAndButtons = new Composite((Composite)gLogIDs, 0);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cChecksAndButtons.setLayout((Layout)layout);
        cChecksAndButtons.setLayoutData((Object)new GridData());
        final Composite cChecks = new Composite(cChecksAndButtons, 0);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.wrap = true;
        rowLayout.marginLeft = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        cChecks.setLayout((Layout)rowLayout);
        SelectionAdapter buttonClickListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = listLogTypes.getSelectionIndex();
                if (index < 0 || index >= logTypes.length) {
                    return;
                }
                Button item = (Button)e.widget;
                if (item.getSelection()) {
                    LoggerView.this.ignoredComponents[index].remove(item.getData("LOGID"));
                } else {
                    LoggerView.this.ignoredComponents[index].add(item.getData("LOGID"));
                }
            }
        };
        int i2 = 0;
        while (i2 < logIDs.length) {
            Button btn = new Button(cChecks, 32);
            btn.setText(MessageText.getString("ConfigView.section.logging.filter." + logIDs[i2], logIDs[i2].toString()));
            btn.setData("LOGID", (Object)logIDs[i2]);
            btn.addSelectionListener((SelectionListener)buttonClickListener);
            if (i2 == 0) {
                gd = new GridData(4, 4, false, false, 1, 2);
                gd.heightHint = (btn.computeSize((int)-1, (int)-1).y + 2) * 3;
                cChecks.setLayoutData((Object)gd);
            }
            ++i2;
        }
        listLogTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = listLogTypes.getSelectionIndex();
                if (index < 0 || index >= logTypes.length) {
                    return;
                }
                labelCatFilter.setText(MessageText.getString("ConfigView.section.logging.showLogsFor", listLogTypes.getSelection()));
                Control[] items = cChecks.getChildren();
                int i = 0;
                while (i < items.length) {
                    LogIDs ID;
                    if (items[i] instanceof Button && (ID = (LogIDs)items[i].getData("LOGID")) != null) {
                        boolean checked = !LoggerView.this.ignoredComponents[index].contains(ID);
                        ((Button)items[i]).setSelection(checked);
                    }
                    ++i;
                }
            }
        });
        listLogTypes.notifyListeners(13, null);
        Button btnCheckAll = new Button(cChecksAndButtons, 8);
        gd = new GridData();
        btnCheckAll.setLayoutData((Object)gd);
        Messages.setLanguageText((Widget)btnCheckAll, "LoggerView.filter.checkAll");
        btnCheckAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = listLogTypes.getSelectionIndex();
                Control[] items = cChecks.getChildren();
                int i = 0;
                while (i < items.length) {
                    LogIDs ID;
                    if (items[i] instanceof Button && (ID = (LogIDs)items[i].getData("LOGID")) != null && LoggerView.this.ignoredComponents[index].contains(ID)) {
                        ((Button)items[i]).setSelection(true);
                        LoggerView.this.ignoredComponents[index].remove(ID);
                    }
                    ++i;
                }
            }
        });
        Button btnUncheckAll = new Button(cChecksAndButtons, 8);
        gd = new GridData();
        btnUncheckAll.setLayoutData((Object)gd);
        Messages.setLanguageText((Widget)btnUncheckAll, "LoggerView.filter.uncheckAll");
        btnUncheckAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = listLogTypes.getSelectionIndex();
                Control[] items = cChecks.getChildren();
                int i = 0;
                while (i < items.length) {
                    LogIDs ID;
                    if (items[i] instanceof Button && (ID = (LogIDs)items[i].getData("LOGID")) != null && !LoggerView.this.ignoredComponents[index].contains(ID)) {
                        ((Button)items[i]).setSelection(false);
                        LoggerView.this.ignoredComponents[index].add(ID);
                    }
                    ++i;
                }
            }
        });
        Utils.makeButtonsEqualWidth(btnCheckAll, btnUncheckAll);
        Composite cBottom = new Composite(settings_panel, 0);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        cBottom.setLayoutData((Object)gd);
        cBottom.setLayout((Layout)new GridLayout(4, false));
        label = new Label(cBottom, 0);
        label.setLayoutData((Object)new GridData());
        Messages.setLanguageText((Widget)label, "LoggerView.includeOnly");
        final Text inclText = new Text(cBottom, 2048);
        gd = new GridData();
        gd.widthHint = 200;
        inclText.setLayoutData((Object)gd);
        inclText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newExpression = inclText.getText();
                Color bg = null;
                if (newExpression.length() == 0) {
                    LoggerView.this.inclusionFilter = null;
                } else {
                    try {
                        LoggerView.this.inclusionFilter = Pattern.compile(newExpression, 66);
                    }
                    catch (PatternSyntaxException e1) {
                        bg = Colors.colorErrorBG;
                    }
                }
                Utils.setSkinnedBackground((Control)inclText, bg);
            }
        });
        label = new Label(cBottom, 0);
        label = new Label(cBottom, 0);
        label = new Label(cBottom, 0);
        label.setLayoutData((Object)new GridData());
        Messages.setLanguageText((Widget)label, "LoggerView.excludeAll");
        final Text exclText = new Text(cBottom, 2048);
        gd = new GridData();
        gd.widthHint = 200;
        exclText.setLayoutData((Object)gd);
        exclText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newExpression = exclText.getText();
                Color bg = null;
                if (newExpression.length() == 0) {
                    LoggerView.this.exclusionFilter = null;
                } else {
                    try {
                        LoggerView.this.exclusionFilter = Pattern.compile(newExpression, 66);
                    }
                    catch (PatternSyntaxException e1) {
                        bg = Colors.colorErrorBG;
                    }
                }
                Utils.setSkinnedBackground((Control)exclText, bg);
            }
        });
        label = new Label(cBottom, 0);
        gd = new GridData(768);
        label.setLayoutData((Object)gd);
        Button buttonOptions = new Button(cBottom, 8);
        buttonOptions.setText(String.valueOf(MessageText.getString("plugins.basicview.config")) + "...");
        gd = new GridData();
        buttonOptions.setLayoutData((Object)gd);
        buttonOptions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    uif.getMDI().showEntryByID("ConfigView", "logging");
                }
            }
        });
        Utils.makeButtonsEqualWidth(buttonClear, buttonOptions);
        if (!Logger.isEnabled()) {
            this.consoleText.setText(String.valueOf(MessageText.getString("LoggerView.loggingDisabled")) + "\n");
        }
    }

    private Composite getComposite() {
        return this.main_panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        if (this.bPaused) {
            return;
        }
        LinkedList<LogEvent> linkedList = this.buffer;
        synchronized (linkedList) {
            if (this.consoleText == null || this.consoleText.isDisposed()) {
                return;
            }
            int i = 0;
            while (i < this.buffer.size()) {
                block24: {
                    try {
                        LogEvent event2 = this.buffer.get(i);
                        int nbLinesBefore = this.consoleText.getLineCount();
                        if (nbLinesBefore > 1280) {
                            this.consoleText.replaceTextRange(0, this.consoleText.getOffsetAtLine(256), "");
                            nbLinesBefore = this.consoleText.getLineCount();
                        }
                        StringBuffer buf = new StringBuffer();
                        buf.append('\n');
                        dateFormatter.format(event2.timeStamp, buf, formatPos);
                        buf.append("{").append(event2.logID).append("} ");
                        buf.append(event2.text);
                        if (event2.relatedTo != null) {
                            buf.append("; \t| ");
                            int j = 0;
                            while (j < event2.relatedTo.length) {
                                Object obj = event2.relatedTo[j];
                                if (j > 0) {
                                    buf.append("; ");
                                }
                                if (obj instanceof LogRelation) {
                                    buf.append(((LogRelation)obj).getRelationText());
                                } else if (obj != null) {
                                    buf.append(obj.getClass().getName()).append(": '").append(obj.toString()).append("'");
                                }
                                ++j;
                            }
                        }
                        String toAppend = buf.toString();
                        if (!(this.inclusionFilter != null && !this.inclusionFilter.matcher(toAppend).find() || this.exclusionFilter != null && this.exclusionFilter.matcher(toAppend).find())) {
                            int start = this.consoleText.getText().length();
                            this.consoleText.append(toAppend);
                            int nbLinesNow = this.consoleText.getLineCount();
                            int colorIdx = -1;
                            if (event2.entryType == 0) {
                                colorIdx = 0;
                            } else if (event2.entryType == 1) {
                                colorIdx = 1;
                            } else if (event2.entryType == 3) {
                                colorIdx = 2;
                            }
                            if (colors != null && colorIdx >= 0) {
                                boolean useBlack;
                                this.consoleText.setLineBackground(nbLinesBefore, nbLinesNow - nbLinesBefore, colors[colorIdx]);
                                if (Utils.isDarkAppearanceNative() && (useBlack = Colors.isBlackTextReadable(colors[colorIdx]))) {
                                    StyleRange styleRange = new StyleRange();
                                    styleRange.start = start;
                                    styleRange.length = toAppend.length();
                                    styleRange.foreground = Colors.black;
                                    this.consoleText.setStyleRange(styleRange);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        PrintStream ps = Logger.getOldStdErr();
                        if (ps == null) break block24;
                        ps.println("Error writing event to console:");
                        e.printStackTrace(ps);
                    }
                }
                ++i;
            }
            this.buffer.clear();
            if (this.bAutoScroll) {
                this.consoleText.setTopIndex(this.consoleText.getLineCount());
            }
        }
    }

    private void delete() {
        Colors instance;
        Logger.removeListener(this);
        if (this.main_panel != null && !this.main_panel.isDisposed()) {
            this.main_panel.dispose();
        }
        if ((instance = Colors.getInstance()) != null) {
            instance.removeColorsChangedListener(this);
        }
    }

    private String getFullTitle() {
        return MessageText.getString("ConsoleView.title.full");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void log(LogEvent event2) {
        boolean bMatch;
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        if (this.ignoredComponents[this.logTypeToIndex(event2.entryType)].contains(event2.logID)) {
            return;
        }
        boolean bl = bMatch = event2.logID == LogIDs.STDERR || this.filter == null;
        if (!bMatch && event2.relatedTo != null) {
            int i = 0;
            while (!bMatch && i < event2.relatedTo.length) {
                Object obj = event2.relatedTo[i];
                if (obj != null) {
                    int j = 0;
                    while (!bMatch && j < this.filter.length) {
                        Object newObj;
                        if (obj instanceof LogRelation && (newObj = ((LogRelation)obj).queryForClass(this.filter[j].getClass())) != null) {
                            obj = newObj;
                        }
                        if (obj == this.filter[j]) {
                            bMatch = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (bMatch) {
            LinkedList<LogEvent> linkedList = this.buffer;
            synchronized (linkedList) {
                if (this.buffer.size() >= 200) {
                    this.buffer.removeFirst();
                }
                this.buffer.add(event2);
            }
            if (this.bRealtime && !this.bPaused) {
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        LoggerView.this.refresh();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(Object[] _filter) {
        LoggerView loggerView = this;
        synchronized (loggerView) {
            this.filter = _filter;
        }
        this.clearConsole();
    }

    private void clearConsole() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (LoggerView.this.consoleText != null && !LoggerView.this.consoleText.isDisposed()) {
                    LoggerView.this.consoleText.setText("");
                }
            }
        });
    }

    public void setEnabled(boolean on) {
        if (this.bEnabled == on) {
            return;
        }
        this.bEnabled = on;
        if (on) {
            Logger.addListener(this);
        } else {
            Logger.removeListener(this);
        }
    }

    public String getPluginViewName() {
        return "Console";
    }

    private void dataSourceChanged(Object newDataSource) {
        if (newDataSource == null) {
            if (this.stopOnNull) {
                this.setEnabled(false);
                return;
            }
            this.setFilter(null);
        } else if (newDataSource instanceof Object[]) {
            this.setFilter((Object[])newDataSource);
        } else {
            if (newDataSource instanceof Boolean) {
                this.stopOnNull = (Boolean)newDataSource;
                if (this.stopOnNull && this.filter == null) {
                    this.setEnabled(false);
                }
                return;
            }
            this.setFilter(new Object[]{newDataSource});
        }
        this.setEnabled(true);
    }

    private int logTypeToIndex(int entryType) {
        switch (entryType) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void parameterChanged(String parameterName) {
        if (parameterName.startsWith("Color")) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    if (LoggerView.this.display == null || LoggerView.this.display.isDisposed()) {
                        return;
                    }
                    if (colors == null) {
                        colors = new Color[3];
                    }
                    Color[] newColors = new Color[]{Colors.blues[2], Colors.colorWarning, Colors.red_ConsoleView};
                    boolean bColorChanged = false;
                    int i = 0;
                    while (i < newColors.length) {
                        if (colors[i] == null || colors[i].isDisposed()) {
                            colors[i] = newColors[i];
                            bColorChanged = true;
                        }
                        ++i;
                    }
                    if (bColorChanged && LoggerView.this.consoleText != null) {
                        String text = LoggerView.this.consoleText.getText();
                        LoggerView.this.consoleText.setText(text);
                    }
                }
            });
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                event2.getView().setDestroyOnDeactivate(false);
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }
}

