/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.category.Category;
import com.biglybt.core.category.CategoryManager;
import com.biglybt.core.category.CategoryManagerListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.tracker.host.TRHostListener;
import com.biglybt.core.tracker.host.TRHostTorrent;
import com.biglybt.core.tracker.host.TRHostTorrentRemovalVetoException;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AsyncController;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pif.tracker.TrackerTorrent;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.pifimpl.local.torrent.TorrentManagerImpl;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableGroupRowRunner;
import com.biglybt.ui.common.table.TableLifeCycleListener;
import com.biglybt.ui.common.table.TableRefreshListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableSelectionListener;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.shells.CoreWaiterSWT;
import com.biglybt.ui.swt.views.table.TableRowSWT;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.TableViewSWTMenuFillListener;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import com.biglybt.ui.swt.views.table.impl.TableViewTab;
import com.biglybt.ui.swt.views.tableitems.mytracker.AnnounceCountItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.AverageBytesInItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.AverageBytesOutItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.BadNATCountItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.CategoryItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.CompletedCountItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.DateAddedItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.DownloadedItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.ExternalItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.LeftItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.NameItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.PassiveItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.PeerCountItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.PersistentItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.ScrapeCountItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.SeedCountItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.StatusItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.TotalBytesInItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.TotalBytesOutItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.TrackerItem;
import com.biglybt.ui.swt.views.tableitems.mytracker.UploadedItem;
import com.biglybt.ui.swt.views.utils.CategoryUIUtils;
import com.biglybt.ui.swt.views.utils.TagUIUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class MyTrackerView
extends TableViewTab<TRHostTorrent>
implements TRHostListener,
CategoryManagerListener,
TableLifeCycleListener,
TableSelectionListener,
TableViewSWTMenuFillListener,
TableRefreshListener,
UIPluginViewToolBarListener,
UISWTViewCoreEventListener {
    protected static final TorrentAttribute category_attribute = TorrentManagerImpl.getSingleton().getAttribute("Category");
    private static TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem(), new TrackerItem(), new StatusItem(), new CategoryItem(), new PassiveItem(), new ExternalItem(), new PersistentItem(), new SeedCountItem(), new PeerCountItem(), new BadNATCountItem(), new AnnounceCountItem(), new ScrapeCountItem(), new CompletedCountItem(), new UploadedItem(), new DownloadedItem(), new LeftItem(), new TotalBytesInItem(), new AverageBytesInItem(), new TotalBytesOutItem(), new AverageBytesOutItem(), new DateAddedItem()};
    private static TableViewSWT.ColorRequester color_requester;
    private Menu menuCategory;
    private TableViewSWT<TRHostTorrent> tv = TableViewFactory.createTableViewSWT(TrackerTorrent.class, "MyTracker", this.getTextPrefixID(), basicItems, "name", 268503042);

    static {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.setDefaultColumnNames("MyTracker", basicItems);
        color_requester = () -> 20;
    }

    public MyTrackerView() {
        super("MyTrackerView");
        this.tv.addLifeCycleListener(this);
        this.tv.addSelectionListener(this, false);
        this.tv.addMenuFillListener(this);
        this.tv.addRefreshListener(this, false);
    }

    @Override
    public TableViewSWT<TRHostTorrent> initYourTableView() {
        return this.tv;
    }

    @Override
    public void tableLifeCycleEventOccurred(TableView tv, int eventType, Map<String, Object> data) {
        switch (eventType) {
            case 0: {
                CoreFactory.addCoreRunningListener(new CoreRunningListener(){

                    @Override
                    public void coreRunning(Core core) {
                        core.getTrackerHost().addListener(MyTrackerView.this);
                    }
                });
                break;
            }
            case 1: {
                try {
                    CoreFactory.getSingleton().getTrackerHost().removeListener(this);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        final TRHostTorrent torrent = (TRHostTorrent)this.tv.getFirstSelectedDataSource();
        if (torrent == null) {
            return;
        }
        CoreWaiterSWT.waitForCoreRunning(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                UIFunctions uiFunctions;
                DownloadManager dm = core.getGlobalManager().getDownloadManager(torrent.getTorrent());
                if (dm != null && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
                    uiFunctions.getMDI().showEntryByID("DMDetails", dm);
                }
            }
        });
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        this.menuCategory = new Menu((Decorations)this.getComposite().getShell(), 4);
        MenuItem itemCategory = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemCategory, "MyTorrentsView.menu.setCategory");
        itemCategory.setMenu(this.menuCategory);
        this.addCategorySubMenu();
        new MenuItem(menu, 2);
        MenuItem itemStart = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemStart, "MyTorrentsView.menu.start");
        Utils.setMenuItemImage(itemStart, "start");
        MenuItem itemStop = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemStop, "MyTorrentsView.menu.stop");
        Utils.setMenuItemImage(itemStop, "stop");
        MenuItem itemRemove = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRemove, "MyTorrentsView.menu.remove");
        Utils.setMenuItemImage(itemRemove, "delete");
        Object[] hostTorrents = this.tv.getSelectedDataSources().toArray();
        itemStart.setEnabled(false);
        itemStop.setEnabled(false);
        itemRemove.setEnabled(false);
        if (hostTorrents.length > 0) {
            boolean start_ok = true;
            boolean stop_ok = true;
            boolean remove_ok = true;
            int i = 0;
            while (i < hostTorrents.length) {
                TRHostTorrent host_torrent = (TRHostTorrent)hostTorrents[i];
                int status = host_torrent.getStatus();
                if (status != 1) {
                    start_ok = false;
                }
                if (status != 2) {
                    stop_ok = false;
                }
                ++i;
            }
            itemStart.setEnabled(start_ok);
            itemStop.setEnabled(stop_ok);
            itemRemove.setEnabled(remove_ok);
        }
        itemStart.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MyTrackerView.this.startSelectedTorrents();
            }
        });
        itemStop.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MyTrackerView.this.stopSelectedTorrents();
            }
        });
        itemRemove.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MyTrackerView.this.removeSelectedTorrents();
            }
        });
        new MenuItem(menu, 2);
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
    }

    @Override
    public void torrentAdded(TRHostTorrent host_torrent) {
        this.tv.addDataSource(host_torrent);
    }

    @Override
    public void torrentChanged(TRHostTorrent t) {
    }

    @Override
    public void torrentRemoved(TRHostTorrent host_torrent) {
        this.tv.removeDataSource(host_torrent);
    }

    @Override
    public boolean handleExternalRequest(InetSocketAddress client, String user, String url, URL absolute_url, String header, InputStream is, OutputStream os, AsyncController async) throws IOException {
        return false;
    }

    @Override
    public void tableRefresh() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
        TableRowCore[] rows = this.tv.getRows();
        int x = 0;
        while (x < rows.length) {
            TRHostTorrent host_torrent;
            TableRowSWT row = (TableRowSWT)rows[x];
            if (row != null && (host_torrent = (TRHostTorrent)rows[x].getDataSource(true)) != null) {
                int seed_count = host_torrent.getSeedCount();
                if (seed_count != 0) {
                    Color target_fg;
                    Color fg = row.getForeground();
                    Color color = target_fg = Utils.isDarkAppearanceNativeWindows() ? Colors.bluesFixed[7] : Colors.blues[7];
                    if (fg == null || !fg.equals((Object)target_fg)) {
                        row.requestForegroundColor(color_requester, target_fg);
                    }
                } else {
                    row.requestForegroundColor(color_requester, null);
                }
            }
            ++x;
        }
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        boolean start = false;
        boolean stop = false;
        boolean remove = false;
        Object[] hostTorrents = this.tv.getSelectedDataSources().toArray();
        if (hostTorrents.length > 0) {
            remove = true;
            int i = 0;
            while (i < hostTorrents.length) {
                TRHostTorrent host_torrent = (TRHostTorrent)hostTorrents[i];
                int status = host_torrent.getStatus();
                if (status == 1) {
                    start = true;
                }
                if (status == 2) {
                    stop = true;
                }
                ++i;
            }
        }
        list.put("start", start ? 1L : 0L);
        list.put("stop", stop ? 1L : 0L);
        list.put("remove", remove ? 1L : 0L);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        String itemKey = item.getID();
        if (itemKey.equals("start")) {
            this.startSelectedTorrents();
            return true;
        }
        if (itemKey.equals("stop")) {
            this.stopSelectedTorrents();
            return true;
        }
        if (itemKey.equals("remove")) {
            this.removeSelectedTorrents();
            return true;
        }
        return false;
    }

    private void stopSelectedTorrents() {
        this.tv.runForSelectedRows(new TableGroupRowRunner(){

            @Override
            public void run(TableRowCore row) {
                TRHostTorrent torrent = (TRHostTorrent)row.getDataSource(true);
                if (torrent.getStatus() == 2) {
                    torrent.stop();
                }
            }
        });
    }

    private void startSelectedTorrents() {
        this.tv.runForSelectedRows(new TableGroupRowRunner(){

            @Override
            public void run(TableRowCore row) {
                TRHostTorrent torrent = (TRHostTorrent)row.getDataSource(true);
                if (torrent.getStatus() == 1) {
                    torrent.start();
                }
            }
        });
    }

    private void removeSelectedTorrents() {
        this.tv.runForSelectedRows(new TableGroupRowRunner(){

            @Override
            public void run(TableRowCore row) {
                TRHostTorrent torrent = (TRHostTorrent)row.getDataSource(true);
                try {
                    torrent.remove();
                }
                catch (TRHostTorrentRemovalVetoException f) {
                    Logger.log(new LogAlert((Object)torrent, false, "{globalmanager.download.remove.veto}", (Throwable)f));
                }
            }
        });
    }

    private void addCategorySubMenu() {
        MenuItem[] items = this.menuCategory.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        if (categories.length > 0) {
            MenuItem itemCategory;
            Category catUncat = CategoryManager.getCategory(2);
            if (catUncat != null) {
                itemCategory = new MenuItem(this.menuCategory, 8);
                Messages.setLanguageText((Widget)itemCategory, catUncat.getName());
                itemCategory.setData("Category", (Object)catUncat);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        MenuItem item = (MenuItem)event2.widget;
                        MyTrackerView.this.assignSelectedToCategory((Category)item.getData("Category"));
                    }
                });
                new MenuItem(this.menuCategory, 2);
            }
            i = 0;
            while (i < categories.length) {
                if (categories[i].getType() == 0) {
                    itemCategory = new MenuItem(this.menuCategory, 8);
                    itemCategory.setText(categories[i].getName());
                    itemCategory.setData("Category", categories[i]);
                    TagUIUtils.setMenuIcon(itemCategory, (Tag)categories[i]);
                    itemCategory.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            MenuItem item = (MenuItem)event2.widget;
                            MyTrackerView.this.assignSelectedToCategory((Category)item.getData("Category"));
                        }
                    });
                }
                ++i;
            }
            new MenuItem(this.menuCategory, 2);
        }
        MenuItem itemAddCategory = new MenuItem(this.menuCategory, 8);
        Messages.setLanguageText((Widget)itemAddCategory, "MyTorrentsView.menu.setCategory.add");
        itemAddCategory.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                MyTrackerView.this.addCategory();
            }
        });
    }

    @Override
    public void categoryAdded(Category category) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                MyTrackerView.this.addCategorySubMenu();
            }
        });
    }

    @Override
    public void categoryRemoved(Category category) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                MyTrackerView.this.addCategorySubMenu();
            }
        });
    }

    @Override
    public void categoryChanged(Category category) {
    }

    private void addCategory() {
        CategoryUIUtils.showCreateCategoryDialog(new UIFunctions.TagReturner(){

            @Override
            public void returnedTags(Tag[] tags) {
                if (tags.length == 1 && tags[0] instanceof Category) {
                    MyTrackerView.this.assignSelectedToCategory((Category)tags[0]);
                }
            }
        });
    }

    private void assignSelectedToCategory(final Category category) {
        CoreWaiterSWT.waitForCoreRunning(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                MyTrackerView.this.assignSelectedToCategory(core, category);
            }
        });
    }

    private void assignSelectedToCategory(final Core core, final Category category) {
        this.tv.runForSelectedRows(new TableGroupRowRunner(){

            @Override
            public void run(TableRowCore row) {
                TRHostTorrent tr_torrent = (TRHostTorrent)row.getDataSource(true);
                TOTorrent torrent = tr_torrent.getTorrent();
                DownloadManager dm = core.getGlobalManager().getDownloadManager(torrent);
                if (dm != null) {
                    dm.getDownloadState().setCategory(category);
                } else {
                    String cat_str = category == null ? null : (category == CategoryManager.getCategory(2) ? null : category.getName());
                    TorrentUtils.setPluginStringProperty(torrent, "azcoreplugins.category", cat_str);
                    try {
                        TorrentUtils.writeToFile(torrent);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        });
    }

    @Override
    public void deselected(TableRowCore[] rows) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void focusChanged(TableRowCore focus) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void selected(TableRowCore[] rows) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }
}

