/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerPeerListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPeerStats;
import com.biglybt.core.peer.impl.PEPeerTransport;
import com.biglybt.core.peer.util.PeerUtils;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.selectedcontent.SelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.ImageRepository;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.Legend;
import com.biglybt.ui.swt.components.graphics.PieUtils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pif.UISWTViewEventListener;
import com.biglybt.ui.swt.pifimpl.UISWTViewCore;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.views.PeersView;
import com.biglybt.ui.swt.views.PeersViewBase;
import com.biglybt.ui.swt.views.ViewUtils;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class PeersGraphicView
implements UIPluginViewToolBarListener,
UISWTViewCoreEventListener {
    public static String MSGID_PREFIX = "PeersGraphicView";
    private static final boolean FORCE_FULL_REPAINT = true;
    private final Object DM_DATA_CACHE_KEY = new Object();
    private final Object PEER_DATA_KEY = new Object();
    private static final int BLOCKCOLOR_DOWN_SMALL = 0;
    private static final int BLOCKCOLOR_DOWN_BIG = 1;
    private static final int BLOCKCOLOR_UP_SMALL = 2;
    private static final int BLOCKCOLOR_UP_BIG = 3;
    private static final Color[] blockColors = new Color[]{Colors.bluesFixed[7], Colors.maroon, Colors.fadedGreen, Colors.orange};
    private static final String[] legendKeys = new String[]{"SwarmView.block.downsmall", "SwarmView.block.downbig", "SwarmView.block.upsmall", "SwarmView.block.upbig"};
    private static final int PEER_SIZE = 18;
    private static final int OWN_SIZE_DEFAULT = 75;
    private static final int OWN_SIZE_MIN = 30;
    private static final int OWN_SIZE_MAX = 75;
    private static int OWN_SIZE = 75;
    private static final int NB_ANGLES = 1000;
    private static final double[] angles = new double[1000];
    private static final double[] deltaXXs = new double[1000];
    private static final double[] deltaXYs = new double[1000];
    private static final double[] deltaYXs = new double[1000];
    private static final double[] deltaYYs = new double[1000];
    private double perimeter;
    private double[] rs = new double[1000];
    private PeerComparator peerComparator;
    private Image my_flag;
    private Display display;
    private Canvas canvas;
    private Image img;
    private Point mySizeCache;
    private TimerEventPeriodic arrow_refresher;
    private boolean arrow_redraw_pending;
    private boolean full_redraw_pending;
    private Object dm_data_lock = new Object();
    private ManagerData[] dm_data = new ManagerData[0];
    private boolean always_show_dm_name;
    private final PeerFilter peer_filter;
    private boolean comp_focused;
    private Object focus_pending_ds;
    static final int BUCKET_LENGTH = 1000;
    static final int BUCKET_CAPACITY = 16384;
    static final int BIG_BUCKET_CAPACITY_MULT = 20;
    static final int BIG_BUCKET_CAPACITY = 327680;
    static final int MAX_BUCKETS = 10;
    static final int BLOB_R = 3;
    private UISWTView swtView;

    static {
        int i = 0;
        while (i < 1000) {
            PeersGraphicView.angles[i] = (double)(2 * i) * Math.PI / 1000.0 - Math.PI;
            PeersGraphicView.deltaXXs[i] = Math.cos(angles[i]);
            PeersGraphicView.deltaXYs[i] = Math.sin(angles[i]);
            PeersGraphicView.deltaYXs[i] = Math.cos(angles[i] + 1.5707963267948966);
            PeersGraphicView.deltaYYs[i] = Math.sin(angles[i] + 1.5707963267948966);
            ++i;
        }
    }

    public PeersGraphicView() {
        this(new PeerFilter(){

            @Override
            public boolean acceptPeer(PEPeer peer) {
                return true;
            }
        });
    }

    public PeersGraphicView(PeerFilter _pf) {
        this.peer_filter = _pf;
        this.peerComparator = new PeerComparator();
    }

    public void setAlwaysShowDownloadName(boolean b) {
        this.always_show_dm_name = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFocused(boolean foc) {
        if (foc) {
            this.comp_focused = true;
            this.dataSourceChanged(this.focus_pending_ds);
        } else {
            Object object = this.dm_data_lock;
            synchronized (object) {
                DownloadManager[] temp = new DownloadManager[this.dm_data.length];
                int i = 0;
                while (i < temp.length) {
                    temp[i] = this.dm_data[i].manager;
                    ++i;
                }
                this.focus_pending_ds = temp;
            }
            this.dataSourceChanged(null);
            this.comp_focused = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dataSourceChanged(Object newDataSource) {
        InetAddress ia;
        if (!this.comp_focused) {
            this.focus_pending_ds = newDataSource;
            return;
        }
        if (this.my_flag == null && (ia = NetworkAdmin.getSingleton().getDefaultPublicAddress()) != null) {
            this.my_flag = ImageRepository.getCountryFlag(ia, false);
        }
        ArrayList<DownloadManager> existing = new ArrayList<DownloadManager>();
        Object object = this.dm_data_lock;
        synchronized (object) {
            ManagerData[] managerDataArray = this.dm_data;
            int n = this.dm_data.length;
            int n2 = 0;
            while (n2 < n) {
                ManagerData data = managerDataArray[n2];
                existing.add(data.manager);
                ++n2;
            }
        }
        List<DownloadManager> newManagers = ViewUtils.getDownloadManagersFromDataSource(newDataSource, existing);
        Object object2 = this.dm_data_lock;
        synchronized (object2) {
            IdentityHashMap<DownloadManager, ManagerData> map = new IdentityHashMap<DownloadManager, ManagerData>();
            ManagerData[] managerDataArray = this.dm_data;
            int n = this.dm_data.length;
            int n3 = 0;
            while (n3 < n) {
                ManagerData data = managerDataArray[n3];
                map.put(data.manager, data);
                ++n3;
            }
            ManagerData[] new_data = new ManagerData[newManagers.size()];
            boolean changed = new_data.length != this.dm_data.length;
            int i = 0;
            while (i < new_data.length) {
                DownloadManager dm = newManagers.get(i);
                ManagerData existing_data = (ManagerData)map.remove(dm);
                if (existing_data != null) {
                    new_data[i] = existing_data;
                    if (i < this.dm_data.length && this.dm_data[i] != existing_data) {
                        changed = true;
                    }
                } else {
                    new_data[i] = new ManagerData(dm);
                    changed = true;
                }
                ++i;
            }
            if (map.size() > 0) {
                changed = true;
                for (ManagerData data : map.values()) {
                    data.delete();
                }
            }
            if (!changed) {
                return;
            }
            Arrays.sort(new_data, (a, b) -> Long.compare(a.getAddTime(), b.getAddTime()));
            this.dm_data = new_data;
            Utils.execSWTThread(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    Object object = PeersGraphicView.this.dm_data_lock;
                    synchronized (object) {
                        if (PeersGraphicView.this.dm_data.length > 0) {
                            Utils.disposeComposite((Composite)PeersGraphicView.this.canvas, false);
                        } else {
                            ViewUtils.setViewRequiresOneDownload((Composite)PeersGraphicView.this.canvas);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete() {
        Object object = this.dm_data_lock;
        synchronized (object) {
            ManagerData[] managerDataArray = this.dm_data;
            int n = this.dm_data.length;
            int n2 = 0;
            while (n2 < n) {
                ManagerData data = managerDataArray[n2];
                data.delete();
                ++n2;
            }
            this.dm_data = new ManagerData[0];
        }
    }

    protected Composite getComposite() {
        return this.canvas;
    }

    private String getData() {
        return "PeersGraphicView.title.full";
    }

    protected void initialize(Composite parent, boolean showLegend) {
        this.display = parent.getDisplay();
        Composite comp2 = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp2.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        comp2.setLayoutData((Object)gridData);
        if (!Utils.isDarkAppearanceNative()) {
            comp2.setBackground(Colors.white);
        }
        this.canvas = new Canvas(comp2, 262144);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.addListener(32, new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(Event event2) {
                int x = event2.x;
                int y = event2.y;
                String tt = "";
                Object object = PeersGraphicView.this.dm_data_lock;
                synchronized (object) {
                    ManagerData[] managerDataArray = PeersGraphicView.this.dm_data;
                    int n = managerDataArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ManagerData data = managerDataArray[n2];
                        DownloadManager manager = data.manager;
                        if (x >= data.me_hit_x && x <= data.me_hit_x + OWN_SIZE && y >= data.me_hit_y && y <= data.me_hit_y + OWN_SIZE) {
                            if (PeersGraphicView.this.always_show_dm_name || PeersGraphicView.this.dm_data.length > 1) {
                                tt = String.valueOf(manager.getDisplayName()) + "\r\n";
                            }
                            tt = String.valueOf(tt) + DisplayFormatters.formatDownloadStatus(manager) + ", " + DisplayFormatters.formatPercentFromThousands(manager.getStats().getCompleted());
                            break;
                        }
                        PEPeer target = null;
                        for (Map.Entry entry : data.peer_hit_map.entrySet()) {
                            int[] loc = (int[])entry.getValue();
                            int loc_x = loc[0];
                            int loc_y = loc[1];
                            if (x < loc_x || x > loc_x + 18 || y < loc_y || y > loc_y + 18) continue;
                            target = (PEPeer)entry.getKey();
                            break;
                        }
                        if (target != null) {
                            PEPeerStats stats2 = target.getStats();
                            String[] details = PeerUtils.getCountryDetails(target);
                            String dstr = details == null || details.length < 2 ? "" : " - " + details[0] + "/" + details[1];
                            tt = String.valueOf(target.getIp()) + dstr + ", " + DisplayFormatters.formatPercentFromThousands(target.getPercentDoneInThousandNotation()) + "\r\n" + "Up=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(stats2.getDataSendRate() + stats2.getProtocolSendRate()) + ", " + "Down=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(stats2.getDataReceiveRate() + stats2.getProtocolReceiveRate());
                            break;
                        }
                        ++n2;
                    }
                }
                Utils.setTT((Control)PeersGraphicView.this.canvas, tt);
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseUp(MouseEvent event2) {
                if (event2.button == 3) {
                    int x = event2.x;
                    int y = event2.y;
                    PEPeer target = null;
                    ArrayList<DownloadManager> target_managers = new ArrayList<DownloadManager>();
                    Object object = PeersGraphicView.this.dm_data_lock;
                    synchronized (object) {
                        ManagerData[] managerDataArray = PeersGraphicView.this.dm_data;
                        int n = managerDataArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ManagerData data = managerDataArray[n2];
                            DownloadManager manager = data.manager;
                            for (Map.Entry entry : data.peer_hit_map.entrySet()) {
                                int[] loc = (int[])entry.getValue();
                                int loc_x = loc[0];
                                int loc_y = loc[1];
                                if (x < loc_x || x > loc_x + 18 || y < loc_y || y > loc_y + 18) continue;
                                target = (PEPeer)entry.getKey();
                                target_managers.add(manager);
                                break;
                            }
                            if (target != null) break;
                            ++n2;
                        }
                    }
                    if (target == null) {
                        return;
                    }
                    Menu menu = PeersGraphicView.this.canvas.getMenu();
                    if (menu != null && !menu.isDisposed()) {
                        menu.dispose();
                    }
                    menu = new Menu((Control)PeersGraphicView.this.canvas);
                    PeersViewBase.fillMenu(menu, target, target_managers);
                    Point cursorLocation = Display.getCurrent().getCursorLocation();
                    menu.setLocation(cursorLocation.x, cursorLocation.y);
                    menu.setVisible(true);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseDoubleClick(MouseEvent event2) {
                int x = event2.x;
                int y = event2.y;
                Object object = PeersGraphicView.this.dm_data_lock;
                synchronized (object) {
                    ManagerData[] managerDataArray = PeersGraphicView.this.dm_data;
                    int n = managerDataArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block13: {
                            DownloadManager manager;
                            ManagerData data;
                            block12: {
                                data = managerDataArray[n2];
                                manager = data.manager;
                                if (x < data.me_hit_x || x > data.me_hit_x + OWN_SIZE || y < data.me_hit_y || y > data.me_hit_y + OWN_SIZE) break block12;
                                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                                if (uiFunctions == null) break block13;
                                uiFunctions.getMDI().showEntryByID("DMDetails", manager);
                                break block13;
                            }
                            for (Map.Entry entry : data.peer_hit_map.entrySet()) {
                                int[] loc = (int[])entry.getValue();
                                int loc_x = loc[0];
                                int loc_y = loc[1];
                                if (x < loc_x || x > loc_x + 18 || y < loc_y || y > loc_y + 18) continue;
                                PEPeer target = (PEPeer)entry.getKey();
                                try {
                                    MdiEntry mdi_entry = UIFunctionsManager.getUIFunctions().getMDI().getEntry("DMDetails", manager);
                                    if (mdi_entry != null) {
                                        mdi_entry.setDatasource(new Object[]{manager});
                                    }
                                    Composite comp2 = PeersGraphicView.this.canvas.getParent();
                                    while (comp2 != null) {
                                        if (comp2 instanceof CTabFolder) {
                                            CTabItem[] items;
                                            CTabFolder tf = (CTabFolder)comp2;
                                            CTabItem[] cTabItemArray = items = tf.getItems();
                                            int n3 = items.length;
                                            int n4 = 0;
                                            while (n4 < n3) {
                                                CTabItem item = cTabItemArray[n4];
                                                UISWTViewCore view = (UISWTViewCore)item.getData("TabbedEntry");
                                                UISWTViewEventListener listener = view.getEventListener();
                                                if (listener instanceof PeersView) {
                                                    tf.setSelection(item);
                                                    Event ev = new Event();
                                                    ev.item = item;
                                                    tf.notifyListeners(13, ev);
                                                    ((PeersView)listener).selectPeer(target);
                                                    return;
                                                }
                                                ++n4;
                                            }
                                        }
                                        comp2 = comp2.getParent();
                                    }
                                }
                                catch (Throwable throwable) {}
                                break;
                            }
                        }
                        ++n2;
                    }
                }
            }
        });
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (PeersGraphicView.this.img != null && !PeersGraphicView.this.img.isDisposed()) {
                    Rectangle bounds = PeersGraphicView.this.img.getBounds();
                    GC gc = e.gc;
                    int x = e.x;
                    int y = e.y;
                    int width = e.width;
                    int height = e.height;
                    if (bounds.width >= width + x && bounds.height >= height + y) {
                        Image full_image = new Image((Device)PeersGraphicView.this.canvas.getDisplay(), bounds.width, bounds.height);
                        try {
                            GC full_gc = new GC((Drawable)full_image);
                            try {
                                full_gc.drawImage(PeersGraphicView.this.img, x, y, width, height, x, y, width, height);
                                full_gc.setClipping(x, y, width, height);
                                PeersGraphicView.this.refreshArrows(full_gc);
                                gc.drawImage(full_image, x, y, width, height, x, y, width, height);
                            }
                            finally {
                                full_gc.dispose();
                            }
                        }
                        finally {
                            full_image.dispose();
                        }
                        PeersGraphicView.this.full_redraw_pending = false;
                        PeersGraphicView.this.arrow_redraw_pending = false;
                        return;
                    }
                }
                e.gc.setBackground(Utils.isDarkAppearanceNative() ? PeersGraphicView.this.canvas.getBackground() : Colors.white);
                e.gc.fillRectangle(e.x, e.y, e.width, e.height);
            }
        });
        this.canvas.addListener(12, ev -> {
            if (this.img != null && !this.img.isDisposed()) {
                this.img.dispose();
                this.img = null;
            }
        });
        if (showLegend) {
            Legend.createLegendComposite(comp2, blockColors, legendKeys, new GridData(4, -1, true, false, 1, 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void refresh() {
        Object object = this.dm_data_lock;
        synchronized (object) {
            boolean clearImage;
            if (this.canvas == null) return;
            if (this.canvas.isDisposed()) {
                return;
            }
            Rectangle bounds = this.canvas.getClientArea();
            if (bounds.width <= 0) return;
            if (bounds.height <= 0) {
                return;
            }
            if (this.arrow_refresher == null) {
                this.arrow_refresher = SimpleTimer.addPeriodicEvent("PGV:AR", 100L, ev -> Utils.execSWTThread(() -> {
                    if (this.canvas.isDisposed()) {
                        Object object = this.dm_data_lock;
                        synchronized (object) {
                            if (this.arrow_refresher != null) {
                                this.arrow_refresher.cancel();
                                this.arrow_refresher = null;
                            }
                        }
                        return;
                    }
                    this.arrow_redraw_pending = true;
                    this.canvas.redraw();
                }));
            }
            Point panelSize = this.canvas.getSize();
            boolean bl = clearImage = this.img == null || this.img.isDisposed() || this.img.getBounds().width != bounds.width || this.img.getBounds().height != bounds.height;
            if (clearImage) {
                if (this.img != null && !this.img.isDisposed()) {
                    this.img.dispose();
                }
                this.img = new Image((Device)this.canvas.getDisplay(), bounds.width, bounds.height);
            }
            GC gc = new GC((Drawable)this.img);
            Color canvasBG = Utils.isDarkAppearanceNative() ? this.canvas.getBackground() : Colors.white;
            try {
                Point mySize;
                int factor;
                double f;
                int h_cells;
                int v_cells;
                int pw = panelSize.x;
                int ph = panelSize.y;
                int num_dms = this.dm_data.length;
                if (num_dms == 0 || pw == 0 || ph == 0) {
                    gc.setBackground(canvasBG);
                    gc.fillRectangle(bounds);
                    return;
                }
                if (ph <= pw) {
                    v_cells = 1;
                    h_cells = pw / ph;
                    f = Math.sqrt((double)num_dms / (double)(v_cells * h_cells));
                    factor = (int)Math.ceil(f);
                    h_cells *= factor;
                    v_cells = factor;
                } else {
                    v_cells = ph / pw;
                    h_cells = 1;
                    f = Math.sqrt((double)num_dms / (double)(v_cells * h_cells));
                    factor = (int)Math.ceil(f);
                    v_cells *= factor;
                    h_cells = factor;
                }
                ph = h_cells == 1 ? ph / num_dms : ph / v_cells;
                pw = v_cells == 1 ? pw / num_dms : pw / h_cells;
                this.mySizeCache = mySize = new Point(pw, ph);
                int num = 0;
                Point lastOffset = null;
                ManagerData[] managerDataArray = this.dm_data;
                int n = this.dm_data.length;
                int n2 = 0;
                while (true) {
                    PEPeer[] sortedPeers;
                    if (n2 >= n) {
                        int rem_y;
                        int rem_x = panelSize.x - (lastOffset.x + mySize.x);
                        if (rem_x > 0) {
                            gc.setBackground(canvasBG);
                            gc.fillRectangle(lastOffset.x + mySize.x, lastOffset.y, rem_x, mySize.y);
                        }
                        if ((rem_y = panelSize.y - (lastOffset.y + mySize.y)) <= 0) return;
                        gc.setBackground(canvasBG);
                        gc.fillRectangle(0, lastOffset.y + mySize.y, panelSize.x, rem_y);
                        break;
                    }
                    ManagerData data = managerDataArray[n2];
                    DownloadManager manager = data.manager;
                    try {
                        data.peers_mon.enter();
                        ArrayList<PEPeerTransport> connectedPeers = new ArrayList<PEPeerTransport>();
                        Iterator iterator = data.peers.iterator();
                        while (true) {
                            PEPeerTransport peerTransport;
                            if (!iterator.hasNext()) {
                                sortedPeers = connectedPeers.toArray(new PEPeer[connectedPeers.size()]);
                                break;
                            }
                            PEPeer peer = (PEPeer)iterator.next();
                            if (!this.peer_filter.acceptPeer(peer) || !(peer instanceof PEPeerTransport) || (peerTransport = (PEPeerTransport)peer).getConnectionState() != 4) continue;
                            connectedPeers.add(peerTransport);
                        }
                    }
                    finally {
                        data.peers_mon.exit();
                    }
                    if (sortedPeers == null) {
                        return;
                    }
                    int i = 0;
                    while (i < 3) {
                        try {
                            Arrays.sort(sortedPeers, this.peerComparator);
                            break;
                        }
                        catch (IllegalArgumentException peer) {
                            ++i;
                        }
                    }
                    int h = num % h_cells;
                    int v = num / h_cells;
                    Point myOffset = new Point(h * pw, v * ph);
                    manager.setUserData(this.DM_DATA_CACHE_KEY, new Object[]{myOffset, sortedPeers});
                    this.render(manager, data, gc, sortedPeers, mySize, myOffset);
                    ++num;
                    lastOffset = myOffset;
                    ++n2;
                }
            }
            finally {
                gc.dispose();
                this.full_redraw_pending = true;
                this.canvas.redraw();
            }
            return;
        }
    }

    private void render(DownloadManager manager, ManagerData data, GC gc, PEPeer[] sortedPeers, Point panelSize, Point panelOffset) {
        Color canvasBG = Utils.isDarkAppearanceNative() ? this.canvas.getBackground() : Colors.white;
        data.peer_hit_map.clear();
        int min_dim = Math.min(panelSize.x, panelSize.y);
        if (min_dim <= 100) {
            OWN_SIZE = 30;
        } else if (min_dim >= 400) {
            OWN_SIZE = 75;
        } else {
            int s_diff = 45;
            float rat = ((float)min_dim - 100.0f) / 300.0f;
            OWN_SIZE = 30 + (int)((float)s_diff * rat);
        }
        int x0 = panelSize.x / 2;
        int y0 = panelSize.y / 2;
        int a = x0 - 20;
        int b = y0 - 20;
        if (a < 10 || b < 10) {
            gc.setBackground(canvasBG);
            gc.fillRectangle(panelOffset.x, panelOffset.y, panelSize.x, panelSize.y);
            return;
        }
        if (data.oldSize == null || !data.oldSize.equals((Object)panelSize)) {
            data.oldSize = panelSize;
            this.perimeter = 0.0;
            int i = 0;
            while (i < 1000) {
                this.rs[i] = Math.sqrt(1.0 / (deltaYXs[i] * deltaYXs[i] / (double)(a * a) + deltaYYs[i] * deltaYYs[i] / (double)(b * b)));
                this.perimeter += this.rs[i];
                ++i;
            }
        }
        Image buffer = new Image((Device)this.display, panelSize.x, panelSize.y);
        GC gcBuffer = new GC((Drawable)buffer);
        gcBuffer.setBackground(canvasBG);
        gcBuffer.setForeground(Colors.blue);
        gcBuffer.fillRectangle(0, 0, panelSize.x, panelSize.y);
        try {
            gcBuffer.setTextAntialias(1);
            gcBuffer.setAntialias(1);
            gcBuffer.setLineAttributes(new LineAttributes(1.0f, 1, 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        gcBuffer.setBackground(Colors.bluesFixed[2]);
        int nbPeers = sortedPeers.length;
        int iAngle = 0;
        double currentPerimeter = 0.0;
        int i = 0;
        while (i < nbPeers) {
            double r;
            PEPeer peer = sortedPeers[i];
            do {
                r = this.rs[iAngle];
                currentPerimeter += r;
                if (iAngle + 1 >= 1000) continue;
                ++iAngle;
            } while (currentPerimeter < (double)i * this.perimeter / (double)nbPeers);
            int percent_received = peer.getPercentDoneOfCurrentIncomingRequest();
            int percent_sent = peer.getPercentDoneOfCurrentOutgoingRequest();
            boolean drawLine = false;
            if (!peer.isChokingMe() || percent_received >= 0) {
                gcBuffer.setForeground(Colors.bluesFixed[1]);
                drawLine = true;
            }
            if (!peer.isChokedByMe() || percent_sent >= 0) {
                gcBuffer.setForeground(Colors.bluesFixed[3]);
                drawLine = true;
            }
            if (!peer.isChokingMe() && peer.isUnchokeOverride() && peer.isInteresting()) {
                gcBuffer.setForeground(Colors.green);
                drawLine = true;
            }
            if (peer.isChokedByMe() && percent_sent >= 0) {
                gcBuffer.setForeground(Colors.green);
                drawLine = true;
            }
            int x1 = x0 + (int)(r * deltaYXs[iAngle]);
            int y1 = y0 + (int)(r * deltaYYs[iAngle]);
            PeerData peer_data = (PeerData)peer.getUserData(this.PEER_DATA_KEY);
            if (peer_data == null) {
                peer_data = new PeerData();
                peer.setUserData(this.PEER_DATA_KEY, peer_data);
            }
            peer_data.line_colour = drawLine ? gcBuffer.getForeground() : canvasBG;
            this.drawArrows(peer, gcBuffer, drawLine, x0, y0, x1, y1, r, iAngle, true);
            gcBuffer.setBackground(Colors.bluesFixed[7]);
            if (peer.isSnubbed()) {
                gcBuffer.setBackground(Colors.grey);
            }
            int peer_x = x1 - 9;
            int peer_y = y1 - 9;
            data.peer_hit_map.put(peer, new int[]{peer_x + panelOffset.x, peer_y + panelOffset.y});
            Image flag = ImageRepository.getCountryFlag(peer, false);
            if (flag != null) {
                PieUtils.drawPie(gcBuffer, flag, peer_x, peer_y, 18, 18, peer.getPercentDoneInThousandNotation() / 10, true);
            } else {
                PieUtils.drawPie(gcBuffer, canvasBG, peer_x, peer_y, 18, 18, peer.getPercentDoneInThousandNotation() / 10);
            }
            ++i;
        }
        gcBuffer.setBackground(Colors.bluesFixed[7]);
        data.me_hit_x = x0 - PeersGraphicView.OWN_SIZE / 2;
        data.me_hit_y = y0 - PeersGraphicView.OWN_SIZE / 2;
        PieUtils.drawPie(gcBuffer, canvasBG, data.me_hit_x, data.me_hit_y, OWN_SIZE, OWN_SIZE, manager.getStats().getCompleted() / 10);
        if (this.my_flag != null) {
            String[] nets;
            Image img = this.my_flag;
            String[] stringArray = nets = data.manager.getDownloadState().getNetworks();
            int n = nets.length;
            int n2 = 0;
            while (n2 < n) {
                String net = stringArray[n2];
                if (net == "Public") {
                    img = this.my_flag;
                    break;
                }
                img = ImageRepository.getCountryFlag("I2P", false);
                if (img == null) {
                    img = this.my_flag;
                }
                ++n2;
            }
            PieUtils.drawPie(gcBuffer, img, data.me_hit_x, data.me_hit_y, OWN_SIZE, OWN_SIZE, manager.getStats().getCompleted() / 10, false);
        }
        ManagerData managerData = data;
        managerData.me_hit_x = managerData.me_hit_x + panelOffset.x;
        ManagerData managerData2 = data;
        managerData2.me_hit_y = managerData2.me_hit_y + panelOffset.y;
        gcBuffer.dispose();
        gc.drawImage(buffer, panelOffset.x, panelOffset.y);
        buffer.dispose();
    }

    private void drawArrows(PEPeer peer, GC gc, boolean drawLine, int x0, int y0, int x1, int y1, double r, int iAngle, boolean lineOnly) {
        PeerData peer_data = (PeerData)peer.getUserData(this.PEER_DATA_KEY);
        if (peer_data == null) {
            return;
        }
        PEPeerStats stats2 = peer.getStats();
        if (stats2 == null) {
            return;
        }
        peer_data.update(stats2);
        Transform trans = new Transform(gc.getDevice());
        Color canvasBG = Utils.isDarkAppearanceNative() ? this.canvas.getBackground() : Colors.white;
        try {
            List[] data_buckets;
            float degrees = (float)(180.0 * angles[iAngle] / Math.PI) + 90.0f;
            trans.translate((float)x0, (float)y0);
            trans.rotate(degrees);
            gc.setTransform(trans);
            if (drawLine) {
                gc.setForeground(peer_data.line_colour);
                gc.drawLine(0, 0, (int)r, 0);
                if (lineOnly) {
                    return;
                }
            }
            LinkedList<BucketData> down_buckets = peer_data.down_data.buckets;
            List<BucketData> down_dead_buckets = peer_data.down_data.dead_buckets;
            LinkedList<BucketData> up_buckets = peer_data.up_data.buckets;
            List<BucketData> up_dead_buckets = peer_data.up_data.dead_buckets;
            if (down_buckets.isEmpty() && down_dead_buckets.isEmpty() && up_buckets.isEmpty() && up_dead_buckets.isEmpty()) {
                return;
            }
            down_dead_buckets.clear();
            up_dead_buckets.clear();
            List[] listArray = data_buckets = new List[]{down_buckets, up_buckets};
            int n = data_buckets.length;
            int n2 = 0;
            while (n2 < n) {
                List buckets = listArray[n2];
                boolean is_down = buckets == down_buckets;
                for (BucketData bd : buckets) {
                    boolean is_big;
                    boolean bl = is_big = bd.capacity == 327680;
                    Color bg = is_down ? blockColors[is_big ? 1 : 0] : blockColors[is_big ? 3 : 2];
                    gc.setBackground(bg);
                    int percent = bd.bytes * 100 / bd.capacity;
                    if (is_down) {
                        percent = 100 - percent;
                    }
                    double cx = (double)(OWN_SIZE / 2 + 3 + 2) + (r - 9.0 - (double)(OWN_SIZE / 2) - 6.0 - 4.0) * (double)percent / 100.0;
                    double cy = 0.0;
                    gc.fillOval((int)(cx - 3.0), (int)(cy - 3.0), 7, 7);
                    bd.cx = cx;
                }
                ++n2;
            }
        }
        finally {
            trans.dispose();
            gc.setTransform(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshArrows(GC gc) {
        Object object = this.dm_data_lock;
        synchronized (object) {
            if (this.canvas == null || this.canvas.isDisposed()) {
                return;
            }
            if (this.img == null || this.img.isDisposed()) {
                return;
            }
            if (this.mySizeCache == null) {
                return;
            }
            try {
                gc.setAntialias(1);
                gc.setLineAttributes(new LineAttributes(1.0f, 1, 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Color canvasBG = Utils.isDarkAppearanceNative() ? this.canvas.getBackground() : Colors.white;
            gc.setBackground(canvasBG);
            ManagerData[] managerDataArray = this.dm_data;
            int n = this.dm_data.length;
            int n2 = 0;
            while (n2 < n) {
                ManagerData data = managerDataArray[n2];
                DownloadManager manager = data.manager;
                Object[] cache = (Object[])manager.getUserData(this.DM_DATA_CACHE_KEY);
                if (cache != null) {
                    this.renderArrows(manager, data, gc, (PEPeer[])cache[1], this.mySizeCache, (Point)cache[0]);
                }
                ++n2;
            }
        }
    }

    private void renderArrows(DownloadManager manager, ManagerData data, GC gc, PEPeer[] sortedPeers, Point panelSize, Point panelOffset) {
        int x0 = panelOffset.x + panelSize.x / 2;
        int y0 = panelOffset.y + panelSize.y / 2;
        int nbPeers = sortedPeers.length;
        int iAngle = 0;
        double currentPerimeter = 0.0;
        int i = 0;
        while (i < nbPeers) {
            double r;
            PEPeer peer = sortedPeers[i];
            do {
                r = this.rs[iAngle];
                currentPerimeter += r;
                if (iAngle + 1 >= 1000) continue;
                ++iAngle;
            } while (currentPerimeter < (double)i * this.perimeter / (double)nbPeers);
            int x1 = x0 + (int)(r * deltaYXs[iAngle]);
            int y1 = y0 + (int)(r * deltaYYs[iAngle]);
            this.drawArrows(peer, gc, false, x0, y0, x1, y1, r, iAngle, false);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = event2.getView();
                this.swtView.setTitle(MessageText.getString(this.getData()));
                this.swtView.setToolBarListener(this);
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData(), true);
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(MessageText.getString(this.getData()));
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                String id = "DMDetails_Swarm";
                this.setFocused(true);
                Object object = this.dm_data_lock;
                synchronized (object) {
                    if (this.dm_data.length == 0) {
                        SelectedContentManager.changeCurrentlySelectedContent(id, null);
                    } else {
                        DownloadManager manager = this.dm_data[0].manager;
                        id = manager.getTorrent() != null ? String.valueOf(id) + "." + manager.getInternalName() : String.valueOf(id) + ":" + manager.getSize();
                        SelectedContentManager.changeCurrentlySelectedContent(id, new SelectedContent[]{new SelectedContent(manager)});
                    }
                    break;
                }
            }
            case 4: {
                this.setFocused(false);
                SelectedContentManager.clearCurrentlySelectedContent();
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        return false;
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        Map<String, Long> states = TorrentUtil.calculateToolbarStates(SelectedContentManager.getCurrentlySelectedContent(), null);
        list.putAll(states);
    }

    static class BucketData {
        int capacity;
        int bytes;
        int offset;
        double cx = -1.0;

        BucketData(int _capacity) {
            this.capacity = _capacity;
        }
    }

    private class ManagerData
    implements DownloadManagerPeerListener {
        private AEMonitor peers_mon = new AEMonitor("PeersGraphicView:peers");
        private final long add_time = SystemTime.getMonotonousTime();
        private DownloadManager manager;
        private Point oldSize;
        private List<PEPeer> peers;
        private Map<PEPeer, int[]> peer_hit_map = new HashMap<PEPeer, int[]>();
        private int me_hit_x;
        private int me_hit_y;

        private ManagerData(DownloadManager _manager) {
            this.manager = _manager;
            this.peers = new ArrayList<PEPeer>();
            this.manager.addPeerListener(this);
        }

        protected long getAddTime() {
            return this.add_time;
        }

        private void delete() {
            this.manager.removePeerListener(this);
            this.manager.setUserData(PeersGraphicView.this.DM_DATA_CACHE_KEY, null);
            this.peer_hit_map.clear();
        }

        @Override
        public void peerManagerWillBeAdded(PEPeerManager peer_manager) {
        }

        @Override
        public void peerManagerAdded(PEPeerManager manager) {
        }

        @Override
        public void peerManagerRemoved(PEPeerManager manager) {
        }

        @Override
        public void peerAdded(PEPeer peer) {
            try {
                this.peers_mon.enter();
                this.peers.add(peer);
            }
            finally {
                this.peers_mon.exit();
            }
        }

        @Override
        public void peerRemoved(PEPeer peer) {
            try {
                this.peers_mon.enter();
                this.peers.remove(peer);
            }
            finally {
                this.peers_mon.exit();
            }
        }
    }

    private static class PeerComparator
    implements Comparator<PEPeer> {
        private PeerComparator() {
        }

        @Override
        public int compare(PEPeer peer0, PEPeer peer1) {
            int percent1;
            int percent0 = peer0.getPercentDoneInThousandNotation();
            int result = percent0 - (percent1 = peer1.getPercentDoneInThousandNotation());
            if (result == 0) {
                long at1;
                long time1;
                long now = SystemTime.getMonotonousTime();
                long at0 = peer0.getConnectionEstablishedMonoTime();
                long time0 = at0 < 0L ? 0L : now - at0;
                long l = time0 - (time1 = (at1 = peer1.getConnectionEstablishedMonoTime()) < 0L ? 0L : now - at1);
                if (l < 0L) {
                    result = -1;
                } else if (l > 0L) {
                    result = 1;
                }
            }
            return result;
        }
    }

    static class PeerData {
        Color line_colour;
        PeerSubData up_data = new PeerSubData();
        PeerSubData down_data = new PeerSubData();

        PeerData() {
        }

        void update(PEPeerStats stats2) {
            this.up_data.update(stats2.getDataSendRate());
            this.down_data.update(stats2.getDataReceiveRate());
        }
    }

    protected static interface PeerFilter {
        public boolean acceptPeer(PEPeer var1);
    }

    static class PeerSubData {
        int bucket_capacity = 16384;
        long last_update = -1L;
        long bytes = 0L;
        LinkedList<BucketData> buckets = new LinkedList();
        long last_tbc_update;
        long last_tbc_bytes = -1L;
        int target_bucket_count;
        List<BucketData> dead_buckets = new ArrayList<BucketData>();
        Color line_colour;

        PeerSubData() {
        }

        void update(long rate_bytes_per_sec) {
            long now = SystemTime.getMonotonousTime();
            if (this.last_update == -1L) {
                this.last_update = now;
                return;
            }
            long time_diff = now - this.last_update;
            if (time_diff == 0L) {
                return;
            }
            this.last_update = now;
            long bytes_diff = rate_bytes_per_sec * time_diff / 1000L;
            if (bytes_diff == 0L && rate_bytes_per_sec > 0L) {
                bytes_diff = 1L;
            }
            this.bytes += bytes_diff;
            if (now - this.last_tbc_update > 1000L) {
                if (rate_bytes_per_sec > 163840L) {
                    this.bucket_capacity = 327680;
                } else if (rate_bytes_per_sec < 81920L) {
                    this.bucket_capacity = 16384;
                }
                this.last_tbc_update = now;
                long tbc_bytes_diff = this.last_tbc_bytes == -1L ? this.bytes : this.bytes - this.last_tbc_bytes;
                this.last_tbc_bytes = this.bytes;
                if (tbc_bytes_diff == 0L) {
                    this.target_bucket_count = 0;
                    this.dead_buckets.addAll(this.buckets);
                    this.buckets.clear();
                } else {
                    this.target_bucket_count = (int)((tbc_bytes_diff + (long)this.bucket_capacity - 1L) / (long)this.bucket_capacity);
                    this.target_bucket_count = Math.min(this.target_bucket_count, 10);
                    int bucket_diff = this.target_bucket_count - this.buckets.size();
                    if (bucket_diff > 0) {
                        int i = 0;
                        while (i < bucket_diff) {
                            this.buckets.add(new BucketData(this.bucket_capacity));
                            ++i;
                        }
                    }
                }
            }
            if (bytes_diff > 0L && this.target_bucket_count > 0) {
                if (this.buckets.size() > 1) {
                    long space_between_buckets = this.bucket_capacity / (this.target_bucket_count + 1);
                    int last_b = -1;
                    for (BucketData bd : this.buckets) {
                        int b = bd.bytes;
                        if (last_b == -1) {
                            last_b = b;
                            bd.offset = 0;
                            continue;
                        }
                        int diff = b - last_b;
                        if (diff > 0 && (long)diff < space_between_buckets) {
                            int max = bd.capacity == 327680 ? 5120 : 256;
                            bd.offset = Math.min(max, diff);
                            continue;
                        }
                        bd.offset = 0;
                    }
                } else {
                    this.buckets.getFirst().offset = 0;
                }
                long bytes_per_bucket = Math.max(1L, bytes_diff / (long)this.target_bucket_count);
                ListIterator<BucketData> it = null;
                while (bytes_diff > 0L) {
                    if (it == null || !it.hasPrevious()) {
                        it = this.buckets.listIterator(this.buckets.size());
                    }
                    BucketData bd = (BucketData)it.previous();
                    long avail = Math.min(bytes_diff, bytes_per_bucket + (long)bd.offset);
                    bd.offset = 0;
                    long bucket_bytes = bd.bytes;
                    long rem = (long)bd.capacity - bucket_bytes;
                    if (rem > avail) {
                        bd.bytes = (int)((long)bd.bytes + avail);
                        bytes_diff -= avail;
                        continue;
                    }
                    bytes_diff -= rem;
                    bd.bytes = 0;
                    it.remove();
                    if (this.buckets.size() < this.target_bucket_count) {
                        bd.capacity = this.bucket_capacity;
                        this.buckets.addFirst(bd);
                    }
                    it = null;
                }
            }
        }
    }
}

