/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerPeerListener;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.table.TableDataSourceChangedListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo2;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.views.PeersViewBase;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.util.DataSourceUtils;
import com.biglybt.util.StringCompareUtils;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class PeersView
extends PeersViewBase
implements DownloadManagerPeerListener,
TableDataSourceChangedListener,
ViewTitleInfo2,
UIPluginViewToolBarListener {
    public static final String MSGID_PREFIX = "PeersView";
    private final List<DownloadManager> managers = new ArrayList<DownloadManager>();
    private List<Reference<PEPeer>> select_peers_pending = new ArrayList<Reference<PEPeer>>();
    private TimerEventPeriodic timerPeerCountUI;
    private String textIndicator;
    private long countWentToZeroTime = -1L;

    public PeersView() {
        super(MSGID_PREFIX, false);
    }

    @Override
    public TableViewSWT<PEPeer> initYourTableView() {
        this.managers.clear();
        this.tv = this.initYourTableView("Peers");
        this.tv.addTableDataSourceChangedListener(this, false);
        return this.tv;
    }

    private void buildTitleInfoTimer() {
        if (this.managers.isEmpty()) {
            if (this.timerPeerCountUI != null) {
                this.timerPeerCountUI.cancel();
                this.timerPeerCountUI = null;
            }
            this.updateTitle(true);
        } else if (this.timerPeerCountUI == null) {
            this.timerPeerCountUI = SimpleTimer.addPeriodicEvent("PeerSumUI", 1000L, e -> this.updateTitle(false));
        }
    }

    private void updateTitle(boolean force) {
        String newTextIndicator;
        int count = 0;
        if (!this.managers.isEmpty()) {
            for (DownloadManager manager : this.managers) {
                PEPeerManager peerManager = manager.getPeerManager();
                if (peerManager == null) continue;
                count += peerManager.getNbPeers() + peerManager.getNbSeeds();
            }
        }
        if (force) {
            if (count == 0) {
                count = -1;
            }
        } else if (count == 0) {
            if (this.countWentToZeroTime == -1L) {
                count = -1;
            } else if (this.countWentToZeroTime == 0L) {
                this.countWentToZeroTime = SystemTime.getMonotonousTime();
            } else if (this.countWentToZeroTime > 0L && SystemTime.getMonotonousTime() - this.countWentToZeroTime > 30000L) {
                count = -1;
            }
        } else {
            this.countWentToZeroTime = 0L;
        }
        String string = newTextIndicator = count == -1 ? null : "" + count;
        if (!StringCompareUtils.equals(this.textIndicator, newTextIndicator)) {
            this.textIndicator = newTextIndicator;
            ViewTitleInfoManager.refreshTitleInfo(this);
        }
    }

    @Override
    public void parentDataSourceChanged(Object newParentDataSource) {
        super.parentDataSourceChanged(newParentDataSource);
        this.tableDataSourceChanged(newParentDataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableDataSourceChanged(Object newDataSource) {
        DownloadManager[] newManagers = DataSourceUtils.getDMs(newDataSource);
        List<DownloadManager> list = this.managers;
        synchronized (list) {
            if (newManagers.length == 0 && this.managers.size() == 0) {
                return;
            }
            if (newManagers.length == 1 && this.managers.size() == 1 && newManagers[0] == this.managers.get(0)) {
                return;
            }
            for (DownloadManager manager : this.managers) {
                manager.removePeerListener(this);
            }
            this.managers.clear();
            DownloadManager[] downloadManagerArray = newManagers;
            int n = newManagers.length;
            int n2 = 0;
            while (n2 < n) {
                DownloadManager manager;
                manager = downloadManagerArray[n2];
                this.managers.add(manager);
                ++n2;
            }
        }
        this.buildTitleInfoTimer();
        if (this.tv == null || this.tv.isDisposed()) {
            return;
        }
        this.tv.removeAllTableRows();
        for (DownloadManager manager : this.managers) {
            manager.addPeerListener(this, false);
        }
        this.addExistingDatasources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableLifeCycleEventOccurred(TableView tv, int eventType, Map<String, Object> data) {
        super.tableLifeCycleEventOccurred(tv, eventType, data);
        switch (eventType) {
            case 0: {
                for (DownloadManager manager : this.managers) {
                    manager.removePeerListener(this);
                    manager.addPeerListener(this, false);
                }
                this.addExistingDatasources();
                break;
            }
            case 1: {
                for (DownloadManager manager : this.managers) {
                    manager.removePeerListener(this);
                }
                this.buildTitleInfoTimer();
                Object[] selected = tv.getSelectedDataSources(true);
                List<Reference<PEPeer>> list = this.select_peers_pending;
                synchronized (list) {
                    this.select_peers_pending.clear();
                    Object[] objectArray = selected;
                    int n = selected.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object ds = objectArray[n2];
                        if (ds instanceof PEPeer) {
                            this.select_peers_pending.add(new WeakReference<PEPeer>((PEPeer)ds));
                        }
                        ++n2;
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        PeersView.fillMenu(menu, this.tv, this.shell, this.managers);
        new MenuItem(menu, 2);
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
        if (PeersView.addPeersMenu(this.managers, columnName, menuThisColumn, new PEPeer[0])) {
            new MenuItem(menuThisColumn, 2);
        }
    }

    @Override
    public void peerAdded(PEPeer created) {
        this.tv.addDataSource(created);
    }

    @Override
    public void peerRemoved(PEPeer removed) {
        this.tv.removeDataSource(removed);
    }

    public void selectPeer(PEPeer peer) {
        ArrayList<PEPeer> peers = new ArrayList<PEPeer>();
        peers.add(peer);
        this.showPeers(peers, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPeers(final List<PEPeer> peers, final int attempt) {
        if (attempt > 10 || peers.isEmpty()) {
            return;
        }
        if (this.tv == null) {
            List<Reference<PEPeer>> list = this.select_peers_pending;
            synchronized (list) {
                this.select_peers_pending.clear();
                for (PEPeer peer : peers) {
                    this.select_peers_pending.add(new WeakReference<PEPeer>(peer));
                }
            }
            return;
        }
        Utils.execSWTThreadLater(attempt == 0 ? 1 : 10, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TableRowCore row1 = PeersView.this.tv.getRow((PEPeer)peers.get(0));
                if (row1 == null) {
                    if (attempt == 0) {
                        List list = PeersView.this.select_peers_pending;
                        synchronized (list) {
                            PeersView.this.select_peers_pending.clear();
                            for (PEPeer peer : peers) {
                                PeersView.this.select_peers_pending.add(new WeakReference<PEPeer>(peer));
                            }
                        }
                        return;
                    }
                } else {
                    ArrayList<TableRowCore> rows = new ArrayList<TableRowCore>();
                    rows.add(row1);
                    for (PEPeer peer : peers.subList(1, peers.size())) {
                        TableRowCore row = PeersView.this.tv.getRow(peer);
                        if (row == null) continue;
                        rows.add(row);
                    }
                    PeersView.this.tv.setSelectedRows(rows.toArray(new TableRowCore[rows.size()]));
                    PeersView.this.tv.showRow(row1);
                    if (row1.isVisible()) {
                        return;
                    }
                }
                PeersView.this.showPeers(peers, attempt + 1);
            }
        });
    }

    @Override
    public void peerManagerWillBeAdded(PEPeerManager peer_manager) {
    }

    @Override
    public void peerManagerAdded(PEPeerManager manager) {
        if (this.getShowLocalPeer() && this.managers.size() == 1) {
            this.tv.addDataSource(manager.getMyPeer());
        }
    }

    @Override
    public void peerManagerRemoved(PEPeerManager manager) {
        this.tv.removeDataSource(manager.getMyPeer());
    }

    @Override
    protected void setShowLocalPeer(boolean b) {
        super.setShowLocalPeer(b);
        if (this.managers.size() != 1 || this.tv == null || this.tv.isDisposed()) {
            return;
        }
        PEPeerManager pm = this.managers.get(0).getPeerManager();
        if (pm != null) {
            PEPeer my_peer = pm.getMyPeer();
            if (b) {
                this.tv.addDataSource(my_peer);
            } else {
                this.tv.removeDataSource(my_peer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExistingDatasources() {
        if (this.managers.isEmpty() || this.tv == null || this.tv.isDisposed()) {
            return;
        }
        for (DownloadManager manager : this.managers) {
            PEPeerManager pm;
            PEPeer[] dataSources = manager.getCurrentPeers();
            if (dataSources != null && dataSources.length > 0) {
                this.tv.addDataSources(dataSources);
            }
            if (this.managers.size() != 1 || !this.getShowLocalPeer() || (pm = manager.getPeerManager()) == null) continue;
            this.tv.addDataSource(pm.getMyPeer());
        }
        ArrayList<PEPeer> to_show = new ArrayList<PEPeer>();
        List<Reference<PEPeer>> list = this.select_peers_pending;
        synchronized (list) {
            for (Reference<PEPeer> ref : this.select_peers_pending) {
                PEPeer peer = ref.get();
                if (peer == null) continue;
                to_show.add(peer);
            }
            this.select_peers_pending.clear();
        }
        if (!to_show.isEmpty()) {
            this.showPeers(to_show, 1);
        }
    }

    @Override
    protected void updateSelectedContent() {
        Object[] dataSources = this.tv.getSelectedDataSources(true);
        if (dataSources.length == 0) {
            String id = "DMDetails_Peers";
            if (!this.managers.isEmpty()) {
                id = this.managers.size() == 1 ? (this.managers.get(0).getTorrent() != null ? String.valueOf(id) + "." + this.managers.get(0).getInternalName() : String.valueOf(id) + ":" + this.managers.get(0).getSize()) : String.valueOf(id) + ":multi";
                ISelectedContent[] sc = new SelectedContent[this.managers.size()];
                int i = 0;
                while (i < sc.length) {
                    sc[i] = new SelectedContent(this.managers.get(i));
                    ++i;
                }
                SelectedContentManager.changeCurrentlySelectedContent(id, sc);
            } else {
                SelectedContentManager.changeCurrentlySelectedContent(id, null);
            }
        } else {
            ISelectedContent[] sc = new SelectedContent[dataSources.length];
            int i = 0;
            while (i < sc.length) {
                Object ds = dataSources[i];
                sc[i] = ds instanceof PEPiece ? new SelectedContent("peer: " + ((PEPeer)ds).getIp()) : new SelectedContent("peer: " + ds);
                ++i;
            }
            SelectedContentManager.changeCurrentlySelectedContent(this.tv.getTableID(), sc, this.tv);
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        if (event2.getType() == 0) {
            event2.getView().setDestroyOnDeactivate(true);
        } else if (event2.getType() == 7) {
            this.buildTitleInfoTimer();
        }
        return super.eventOccurred(event2);
    }

    @Override
    public void titleInfoLinked(MultipleDocumentInterface mdi, MdiEntry mdiEntry) {
    }

    @Override
    public Object getTitleInfoProperty(int propertyID) {
        if (propertyID == 0) {
            return this.textIndicator;
        }
        return null;
    }

    @Override
    public boolean isActive() {
        if (this.tv == null || !this.tv.isVisible()) {
            return false;
        }
        return !this.tv.getSelectedDataSources().isEmpty();
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        Object ds;
        List<Object> selectedDataSources;
        boolean hasPeer;
        boolean bl = hasPeer = this.tv != null && this.tv.getSelectedRowsSize() > 0;
        if (hasPeer && (selectedDataSources = this.tv.getSelectedDataSources()).size() == 1 && (ds = selectedDataSources.get(0)) instanceof PEPeer && ((PEPeer)ds).isMyPeer()) {
            hasPeer = false;
        }
        list.put("remove", hasPeer ? 1L : 0L);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        if (item.getID().equals("remove")) {
            List<Object> selectedDataSources = this.tv.getSelectedDataSources();
            for (Object dataSource : selectedDataSources) {
                PEPeer peer;
                if (!(dataSource instanceof PEPeer) || (peer = (PEPeer)dataSource).isMyPeer()) continue;
                peer.getManager().removePeer(peer, "Peer kicked", 14);
            }
            return true;
        }
        return false;
    }
}

