/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.ipfilter.IpFilter;
import com.biglybt.core.ipfilter.IpFilterManagerFactory;
import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.util.PeerUtils;
import com.biglybt.core.speedmanager.SpeedLimitHandler;
import com.biglybt.core.tag.TagGroup;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.IdentityHashSet;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.plugin.net.buddy.BuddyPlugin;
import com.biglybt.plugin.net.buddy.BuddyPluginUtils;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableLifeCycleListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableSelectionListener;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.table.TableViewFilterCheck;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BubbleTextBox;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.views.LoggerView;
import com.biglybt.ui.swt.views.PeersGraphicView;
import com.biglybt.ui.swt.views.PeersView;
import com.biglybt.ui.swt.views.ViewManagerSWT;
import com.biglybt.ui.swt.views.ViewUtils;
import com.biglybt.ui.swt.views.peer.PeerFilesView;
import com.biglybt.ui.swt.views.peer.PeerPieceMapView;
import com.biglybt.ui.swt.views.peer.RemotePieceDistributionView;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.TableViewSWTMenuFillListener;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import com.biglybt.ui.swt.views.table.impl.TableViewTab;
import com.biglybt.ui.swt.views.table.utils.TableColumnFilterHelper;
import com.biglybt.ui.swt.views.tableitems.peers.ASItem;
import com.biglybt.ui.swt.views.tableitems.peers.BytesQueuedForUpload;
import com.biglybt.ui.swt.views.tableitems.peers.ChokedItem;
import com.biglybt.ui.swt.views.tableitems.peers.ChokingItem;
import com.biglybt.ui.swt.views.tableitems.peers.ClientIdentificationItem;
import com.biglybt.ui.swt.views.tableitems.peers.ClientItem;
import com.biglybt.ui.swt.views.tableitems.peers.ColumnPeerNetwork;
import com.biglybt.ui.swt.views.tableitems.peers.ConnectedTimeItem;
import com.biglybt.ui.swt.views.tableitems.peers.DLedFromOthersItem;
import com.biglybt.ui.swt.views.tableitems.peers.DiscardedItem;
import com.biglybt.ui.swt.views.tableitems.peers.DownItem;
import com.biglybt.ui.swt.views.tableitems.peers.DownSpeedItem;
import com.biglybt.ui.swt.views.tableitems.peers.DownSpeedLimitItem;
import com.biglybt.ui.swt.views.tableitems.peers.DownloadNameItem;
import com.biglybt.ui.swt.views.tableitems.peers.EncryptionItem;
import com.biglybt.ui.swt.views.tableitems.peers.GainItem;
import com.biglybt.ui.swt.views.tableitems.peers.HandshakeReservedBytesItem;
import com.biglybt.ui.swt.views.tableitems.peers.HostNameItem;
import com.biglybt.ui.swt.views.tableitems.peers.IncomingRequestCountItem;
import com.biglybt.ui.swt.views.tableitems.peers.IndexItem;
import com.biglybt.ui.swt.views.tableitems.peers.InterestedItem;
import com.biglybt.ui.swt.views.tableitems.peers.InterestingItem;
import com.biglybt.ui.swt.views.tableitems.peers.IpItem;
import com.biglybt.ui.swt.views.tableitems.peers.LANItem;
import com.biglybt.ui.swt.views.tableitems.peers.LatencyItem;
import com.biglybt.ui.swt.views.tableitems.peers.LocalInterfaceItem;
import com.biglybt.ui.swt.views.tableitems.peers.MessagingItem;
import com.biglybt.ui.swt.views.tableitems.peers.OptimisticUnchokeItem;
import com.biglybt.ui.swt.views.tableitems.peers.OutgoingRequestCountItem;
import com.biglybt.ui.swt.views.tableitems.peers.PeerByteIDItem;
import com.biglybt.ui.swt.views.tableitems.peers.PeerIDItem;
import com.biglybt.ui.swt.views.tableitems.peers.PeerSourceItem;
import com.biglybt.ui.swt.views.tableitems.peers.PercentHaveTheyNeedItem;
import com.biglybt.ui.swt.views.tableitems.peers.PercentHaveWeNeedItem;
import com.biglybt.ui.swt.views.tableitems.peers.PercentItem;
import com.biglybt.ui.swt.views.tableitems.peers.PieceItem;
import com.biglybt.ui.swt.views.tableitems.peers.PiecesItem;
import com.biglybt.ui.swt.views.tableitems.peers.PortItem;
import com.biglybt.ui.swt.views.tableitems.peers.ProtocolItem;
import com.biglybt.ui.swt.views.tableitems.peers.SnubbedItem;
import com.biglybt.ui.swt.views.tableitems.peers.StatUpItem;
import com.biglybt.ui.swt.views.tableitems.peers.StateItem;
import com.biglybt.ui.swt.views.tableitems.peers.TimeToSendPieceItem;
import com.biglybt.ui.swt.views.tableitems.peers.TimeUntilCompleteItem;
import com.biglybt.ui.swt.views.tableitems.peers.TotalDownSpeedItem;
import com.biglybt.ui.swt.views.tableitems.peers.TypeItem;
import com.biglybt.ui.swt.views.tableitems.peers.UniquePieceItem;
import com.biglybt.ui.swt.views.tableitems.peers.UpDownRatioItem;
import com.biglybt.ui.swt.views.tableitems.peers.UpItem;
import com.biglybt.ui.swt.views.tableitems.peers.UpRatioItem;
import com.biglybt.ui.swt.views.tableitems.peers.UpSpeedItem;
import com.biglybt.ui.swt.views.tableitems.peers.UpSpeedLimitItem;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class PeersViewBase
extends TableViewTab<PEPeer>
implements UISWTViewCoreEventListener,
TableLifeCycleListener,
TableViewSWTMenuFillListener,
TableSelectionListener,
TableViewFilterCheck<PEPeer> {
    public static final Class<Peer> PLUGIN_DS_TYPE = Peer.class;
    private static final TableColumnCore[] basicItems = PeersViewBase.getBasicColumnItems("Peers");
    private BubbleTextBox bubbleTextBox;
    protected TableViewSWT<PEPeer> tv;
    private TableColumnFilterHelper<PEPeer> col_filter_helper;
    protected Shell shell;
    private boolean swarm_view_enable;
    private boolean local_peer_enable = true;
    private PeersGraphicView swarm_view;
    private Set<PEPeer> swarm_peers = new HashSet<PEPeer>();
    private volatile boolean peers_changed;
    private volatile boolean show_local_peer;

    static {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.setDefaultColumnNames("Peers", basicItems);
    }

    static TableColumnCore[] getBasicColumnItems(String table_id) {
        return new TableColumnCore[]{new IpItem(table_id), new ClientItem(table_id), new TypeItem(table_id), new MessagingItem(table_id), new EncryptionItem(table_id), new ProtocolItem(table_id), new PiecesItem(table_id), new PercentItem(table_id), new PercentHaveWeNeedItem(table_id), new PercentHaveTheyNeedItem(table_id), new DownSpeedItem(table_id), new UpSpeedItem(table_id), new PeerSourceItem(table_id), new HostNameItem(table_id), new PortItem(table_id), new InterestedItem(table_id), new ChokedItem(table_id), new DownItem(table_id), new InterestingItem(table_id), new ChokingItem(table_id), new OptimisticUnchokeItem(table_id), new UpItem(table_id), new UpDownRatioItem(table_id), new GainItem(table_id), new StatUpItem(table_id), new SnubbedItem(table_id), new TotalDownSpeedItem(table_id), new TimeUntilCompleteItem(table_id), new DiscardedItem(table_id), new UniquePieceItem(table_id), new TimeToSendPieceItem(table_id), new DLedFromOthersItem(table_id), new UpRatioItem(table_id), new StateItem(table_id), new ConnectedTimeItem(table_id), new LatencyItem(table_id), new PieceItem(table_id), new IncomingRequestCountItem(table_id), new OutgoingRequestCountItem(table_id), new UpSpeedLimitItem(table_id), new DownSpeedLimitItem(table_id), new LANItem(table_id), new PeerIDItem(table_id), new PeerByteIDItem(table_id), new HandshakeReservedBytesItem(table_id), new ClientIdentificationItem(table_id), new ASItem(table_id), new IndexItem(table_id), new ColumnPeerNetwork(table_id), new LocalInterfaceItem(table_id), new BytesQueuedForUpload(table_id)};
    }

    protected PeersViewBase(String id, boolean enable_swarm_view) {
        super(id);
        this.swarm_view_enable = enable_swarm_view;
    }

    @Override
    public Composite initComposite(Composite composite) {
        if (this.swarm_view_enable) {
            Composite parent = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            parent.setLayout((Layout)layout);
            Layout compositeLayout = composite.getLayout();
            if (compositeLayout instanceof GridLayout) {
                parent.setLayoutData((Object)new GridData(4, 4, true, true));
            } else if (compositeLayout instanceof FormLayout) {
                parent.setLayoutData((Object)Utils.getFilledFormData());
            }
            final CTabFolder tab_folder = new CTabFolder(parent, 0);
            tab_folder.setLayoutData((Object)new GridData(4, 4, true, true));
            CTabItem tab1 = new CTabItem(tab_folder, 0);
            Messages.setLanguageText((Widget)tab1, "label.table");
            Composite tableParent = new Composite((Composite)tab_folder, 0);
            tableParent.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout gridLayout = new GridLayout();
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            tableParent.setLayout((Layout)gridLayout);
            Composite cTop = new Composite(tableParent, 0);
            cTop.setLayoutData((Object)new GridData(4, 1, true, false));
            cTop.setLayout((Layout)new FormLayout());
            this.bubbleTextBox = new BubbleTextBox(cTop, 2948);
            FormData fd = new FormData();
            fd.right = new FormAttachment(100, 0);
            fd.width = 140;
            this.bubbleTextBox.setMessageAndLayout("", fd);
            String tooltip = MessageText.getString("filter.tt.start");
            tooltip = String.valueOf(tooltip) + MessageText.getString("peersview.filter.tt.line1");
            tooltip = String.valueOf(tooltip) + MessageText.getString("column.filter.tt.line2");
            this.bubbleTextBox.setTooltip(tooltip);
            if (this.tv != null) {
                this.tv.enableFilterCheck(this.bubbleTextBox, this, false);
            }
            tab1.setControl((Control)tableParent);
            final CTabItem tab2 = new CTabItem(tab_folder, 0);
            Messages.setLanguageText((Widget)tab2, "label.swarms");
            final Composite swarmParent = new Composite((Composite)tab_folder, 0);
            swarmParent.setLayoutData((Object)new GridData(4, 4, true, true));
            gridLayout = new GridLayout();
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            swarmParent.setLayout((Layout)gridLayout);
            tab2.setControl((Control)swarmParent);
            tab_folder.setSelection(tab1);
            tab_folder.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    if (tab_folder.getSelection() == tab2) {
                        Utils.disposeComposite(swarmParent, false);
                        PeersViewBase.this.createSwarmsView(swarmParent);
                    } else {
                        if (PeersViewBase.this.swarm_view != null) {
                            PeersViewBase.this.swarm_view.delete();
                        }
                        Utils.disposeComposite(swarmParent, false);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            return tableParent;
        }
        if (this.local_peer_enable) {
            Composite parent = new Composite(composite, 0);
            GridLayout layout = new GridLayout(1, true);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = 0;
            parent.setLayout((Layout)layout);
            Layout compositeLayout = composite.getLayout();
            if (compositeLayout instanceof GridLayout) {
                parent.setLayoutData((Object)new GridData(4, 4, true, true));
            } else if (compositeLayout instanceof FormLayout) {
                parent.setLayoutData((Object)Utils.getFilledFormData());
            }
            Composite header = new Composite(parent, 0);
            layout = new GridLayout(1, true);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            header.setLayout((Layout)layout);
            header.setLayoutData((Object)new GridData(768));
            final Button lp_enable = new Button(header, 32);
            lp_enable.setLayoutData((Object)new GridData(768));
            Messages.setLanguageText((Widget)lp_enable, "label.local.peer.show");
            lp_enable.addListener(13, ev -> COConfigurationManager.setParameter("Peers View Show Local Peer", lp_enable.getSelection()));
            COConfigurationManager.addAndFireParameterListener("Peers View Show Local Peer", new ParameterListener(){

                @Override
                public void parameterChanged(String n) {
                    if (lp_enable.isDisposed()) {
                        COConfigurationManager.removeParameterListener(n, this);
                        return;
                    }
                    boolean enabled = COConfigurationManager.getBooleanParameter(n);
                    lp_enable.setSelection(enabled);
                    PeersViewBase.this.setShowLocalPeer(enabled);
                }
            });
            Composite tableParent = new Composite(parent, 0);
            tableParent.setLayoutData((Object)new GridData(4, 4, true, true));
            layout = new GridLayout();
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            tableParent.setLayout((Layout)layout);
            return tableParent;
        }
        return super.initComposite(composite);
    }

    protected boolean getShowLocalPeer() {
        return this.show_local_peer;
    }

    protected void setShowLocalPeer(boolean b) {
        this.show_local_peer = b;
    }

    protected TableViewSWT<PEPeer> initYourTableView(String table_id) {
        if (table_id == "Peers") {
            this.tv = TableViewFactory.createTableViewSWT(PLUGIN_DS_TYPE, "Peers", this.getTextPrefixID(), basicItems, "pieces", 0x10010002);
        } else {
            TableColumnCore[] items = PeersView.getBasicColumnItems("AllPeers");
            TableColumn[] basicItems = new TableColumnCore[items.length + 1];
            System.arraycopy(items, 0, basicItems, 0, items.length);
            basicItems[items.length] = new DownloadNameItem("AllPeers");
            TableColumnManager tcManager = TableColumnManager.getInstance();
            tcManager.setDefaultColumnNames("AllPeers", basicItems);
            this.tv = TableViewFactory.createTableViewSWT(PLUGIN_DS_TYPE, "AllPeers", this.getTextPrefixID(), (TableColumnCore[])basicItems, "connected_time", 0x10010002);
        }
        this.col_filter_helper = new TableColumnFilterHelper<PEPeer>(this.tv, "pb:search");
        this.tv.setRowDefaultHeightEM(1.0f);
        PeersViewBase.registerPluginViews();
        this.tv.addLifeCycleListener(this);
        this.tv.addMenuFillListener(this);
        this.tv.addSelectionListener(this, false);
        return this.tv;
    }

    @Override
    public void tableViewTabInitComplete() {
        if (this.tv.getParentDataSource() instanceof TagGroup) {
            this.tv.setEnabled(false);
        }
    }

    private static void registerPluginViews() {
        ViewManagerSWT vm = ViewManagerSWT.getInstance();
        if (vm.areCoreViewsRegistered(PLUGIN_DS_TYPE)) {
            return;
        }
        vm.registerView(PLUGIN_DS_TYPE, new UISWTViewBuilderCore("PeerPieceMapView", null, PeerPieceMapView.class));
        vm.registerView(PLUGIN_DS_TYPE, new UISWTViewBuilderCore("RemotePieceDistributionView", null, RemotePieceDistributionView.class));
        vm.registerView(PLUGIN_DS_TYPE, new UISWTViewBuilderCore("PeerFilesView", null, PeerFilesView.class));
        vm.registerView(PLUGIN_DS_TYPE, new UISWTViewBuilderCore("LoggerView", null, LoggerView.class).setInitialDatasource(true));
        vm.setCoreViewsRegistered(PLUGIN_DS_TYPE);
    }

    @Override
    public void tableLifeCycleEventOccurred(TableView tv, int eventType, Map<String, Object> data) {
        switch (eventType) {
            case 0: {
                this.shell = this.tv.getComposite().getShell();
            }
        }
    }

    @Override
    public void filterSet(String filter2) {
        this.col_filter_helper.filterSet(filter2);
    }

    @Override
    public boolean filterCheck(PEPeer ds, String filter2, boolean regex, boolean confusable) {
        if (confusable) {
            return false;
        }
        return this.col_filter_helper.filterCheck(ds, filter2, regex, ds.getClient(), false);
    }

    protected void addPeer(PEPeer peer) {
        this.peers_changed = true;
        this.tv.addDataSource(peer);
    }

    protected void addPeers(PEPeer[] peers) {
        this.peers_changed = true;
        this.tv.addDataSources((PEPeer[])peers);
    }

    protected void removePeer(PEPeer peer) {
        this.peers_changed = true;
        this.tv.removeDataSource(peer);
    }

    private void createSwarmsView(Composite parent) {
        if (this.swarm_view != null) {
            this.swarm_view.delete();
        }
        this.swarm_view = new PeersGraphicView(new PeersGraphicView.PeerFilter(){

            @Override
            public boolean acceptPeer(PEPeer peer) {
                return PeersViewBase.this.swarm_peers.contains(peer);
            }
        });
        this.swarm_view.setAlwaysShowDownloadName(true);
        this.swarm_view.initialize(parent, false);
        this.swarm_view.getComposite().setLayoutData((Object)new GridData(4, 4, true, true));
        parent.getParent().layout(true, true);
        this.swarm_view.setFocused(true);
        this.peers_changed = true;
        this.updateSwarmPeers();
        this.swarm_view.refresh();
    }

    private void updateSwarmPeers() {
        if (this.peers_changed) {
            Utils.execSWTThread(new Runnable(){

                @Override
                public void run() {
                    PeersViewBase.this.peers_changed = false;
                    GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
                    PeersViewBase.this.swarm_peers = PeersViewBase.this.tv.getDataSources();
                    final HashMap<PEPeerManager, int[]> done_pms = new HashMap<PEPeerManager, int[]>();
                    ArrayList<DownloadManager> dms = new ArrayList<DownloadManager>();
                    for (PEPeer peer : PeersViewBase.this.swarm_peers) {
                        PEPeerManager pm = peer.getManager();
                        int[] count = (int[])done_pms.get(pm);
                        if (count == null) {
                            done_pms.put(pm, new int[]{1});
                            byte[] hash = pm.getHash();
                            DownloadManager dm = gm.getDownloadManager(new HashWrapper(hash));
                            if (dm == null) continue;
                            dms.add(dm);
                            continue;
                        }
                        count[0] = count[0] + 1;
                    }
                    Collections.sort(dms, new Comparator<DownloadManager>(){

                        @Override
                        public int compare(DownloadManager o1, DownloadManager o2) {
                            PEPeerManager pm1 = o1.getPeerManager();
                            PEPeerManager pm2 = o2.getPeerManager();
                            int[] c1 = (int[])done_pms.get(pm1);
                            int[] c2 = (int[])done_pms.get(pm2);
                            int n1 = c1 == null ? 0 : c1[0];
                            int n2 = c2 == null ? 0 : c2[0];
                            return n2 - n1;
                        }
                    });
                    PeersViewBase.this.swarm_view.dataSourceChanged(dms.toArray(new DownloadManager[dms.size()]));
                }
            });
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 5: {
                if (this.swarm_view == null) break;
                this.updateSwarmPeers();
                this.swarm_view.refresh();
                break;
            }
            case 3: {
                if (this.swarm_view == null) break;
                this.swarm_view.setFocused(true);
                break;
            }
            case 4: {
                if (this.swarm_view == null) break;
                this.swarm_view.setFocused(false);
            }
        }
        return super.eventOccurred(event2);
    }

    public static void fillMenu(Menu menu, PEPeer peer, List<DownloadManager> download_specific) {
        PEPeer[] peers = new PEPeer[]{peer};
        PeersViewBase.fillMenu(menu, peers, menu.getShell(), download_specific);
    }

    public static void fillMenu(Menu menu, TableView<PEPeer> tv, Shell shell, List<DownloadManager> download_specific) {
        List<Object> o_peers = tv.getSelectedDataSources();
        PEPeer[] peers = o_peers.toArray(new PEPeer[o_peers.size()]);
        PeersViewBase.fillMenu(menu, peers, shell, download_specific);
    }

    private static void fillMenu(Menu menu, final PEPeer[] peers, Shell shell, List<DownloadManager> download_specific) {
        MenuItem ban_item;
        BuddyPlugin bp;
        int maxdl;
        boolean hasSelection = peers.length > 0;
        final IdentityHashSet<DownloadManager> download_managers = new IdentityHashSet<DownloadManager>();
        final HashMap<PEPeer, DownloadManager> peer_dm_map = new HashMap<PEPeer, DownloadManager>();
        boolean downSpeedDisabled = false;
        boolean downSpeedUnlimited = false;
        long totalDownSpeed = 0L;
        long downSpeedSetMax = 0L;
        long maxDown = 0L;
        boolean upSpeedDisabled = false;
        boolean upSpeedUnlimited = false;
        long totalUpSpeed = 0L;
        long upSpeedSetMax = 0L;
        long maxUp = 0L;
        boolean onlyMyPeer = true;
        boolean hasIPv4 = false;
        boolean hasIPv6 = false;
        if (hasSelection) {
            GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
            int i = 0;
            while (i < peers.length) {
                DownloadManager dm;
                PEPeerManager m;
                PEPeer peer = peers[i];
                if (!peer.isMyPeer()) {
                    onlyMyPeer = false;
                    String ip = peer.getIp();
                    if (ip.indexOf(".") != -1) {
                        hasIPv4 = true;
                    } else {
                        hasIPv6 = true;
                    }
                    InetAddress alt = peer.getAlternativeIPv6();
                    if (alt != null) {
                        if (alt instanceof Inet4Address) {
                            hasIPv4 = true;
                        } else {
                            hasIPv6 = true;
                        }
                    }
                }
                if ((m = peer.getManager()) != null && gm != null && (dm = gm.getDownloadManager(new HashWrapper(m.getHash()))) != null) {
                    peer_dm_map.put(peer, dm);
                    download_managers.add(dm);
                }
                try {
                    int maxul = peer.getStats().getUploadRateLimitBytesPerSecond();
                    maxUp += (long)(maxul * 4);
                    if (maxul == 0) {
                        upSpeedUnlimited = true;
                    } else if ((long)maxul > upSpeedSetMax) {
                        upSpeedSetMax = maxul;
                    }
                    if (maxul == -1) {
                        maxul = 0;
                        upSpeedDisabled = true;
                    }
                    totalUpSpeed += (long)maxul;
                    maxdl = peer.getStats().getDownloadRateLimitBytesPerSecond();
                    maxDown += (long)(maxdl * 4);
                    if (maxdl == 0) {
                        downSpeedUnlimited = true;
                    } else if ((long)maxdl > downSpeedSetMax) {
                        downSpeedSetMax = maxdl;
                    }
                    if (maxdl == -1) {
                        maxdl = 0;
                        downSpeedDisabled = true;
                    }
                    totalDownSpeed += (long)maxdl;
                }
                catch (Exception ex) {
                    Debug.printStackTrace(ex);
                }
                ++i;
            }
        }
        if (!download_specific.isEmpty()) {
            PEPeer peer;
            MenuItem block_item = new MenuItem(menu, 32);
            PEPeer pEPeer = peer = peers.length == 0 ? null : peers[0];
            if (onlyMyPeer || peer == null || peer.getManager().getDiskManager().getRemainingExcludingDND() > 0L) {
                block_item.setSelection(false);
                block_item.setEnabled(false);
            } else {
                block_item.setEnabled(true);
                block_item.setSelection(peer.isSnubbed());
            }
            if (peer != null) {
                final boolean newSnubbedValue = !peer.isSnubbed();
                Messages.setLanguageText((Widget)block_item, "PeersView.menu.blockupload");
                block_item.addListener(13, (Listener)new PeersRunner(peers){

                    @Override
                    public void run(PEPeer peer) {
                        peer.setSnubbed(newSnubbedValue);
                    }
                });
            }
        } else if (download_managers.size() > 0) {
            MenuItem itemDetails = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemDetails, "PeersView.menu.showdownload");
            Utils.setMenuItemImage(itemDetails, "details");
            itemDetails.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions != null) {
                        for (DownloadManager dm : download_managers) {
                            uiFunctions.getMDI().showEntryByID("DMDetails", dm);
                        }
                    }
                }
            });
            new MenuItem(menu, 2);
        }
        if ((bp = BuddyPluginUtils.getPlugin()) != null) {
            boolean has_pb = false;
            boolean has_pb_potential = false;
            PEPeer[] pEPeerArray = peers;
            maxdl = peers.length;
            int ex = 0;
            while (ex < maxdl) {
                PEPeer peer = pEPeerArray[ex];
                if (!peer.isMyPeer()) {
                    DownloadManager dm = (DownloadManager)peer_dm_map.get(peer);
                    Peer p_peer = PluginCoreUtils.wrap(peer);
                    if (p_peer.getState() == 30 && !bp.isFullBuddy(p_peer)) {
                        has_pb_potential = true;
                        if (dm != null && bp.isPartialBuddy(PluginCoreUtils.wrap(dm), PluginCoreUtils.wrap(peer))) {
                            has_pb = true;
                        }
                    }
                }
                ++ex;
            }
            final MenuItem boost_item = new MenuItem(menu, 32);
            Messages.setLanguageText((Widget)boost_item, "PeersView.menu.boost");
            boost_item.setSelection(has_pb);
            boost_item.setEnabled(has_pb_potential);
            boost_item.addListener(13, (Listener)new PeersRunner(peers){

                @Override
                public void run(PEPeer peer) {
                    Peer p_peer = PluginCoreUtils.wrap(peer);
                    if (!bp.isFullBuddy(p_peer)) {
                        boolean sel = boost_item.getSelection();
                        DownloadManager dm = (DownloadManager)peer_dm_map.get(peer);
                        if (dm != null) {
                            bp.setPartialBuddy(PluginCoreUtils.wrap(dm), p_peer, sel, true);
                        }
                    }
                }
            });
        }
        HashMap<String, Object> menu_properties = new HashMap<String, Object>();
        menu_properties.put("enable_upload_disable", true);
        menu_properties.put("enable_download_disable", true);
        ViewUtils.addSpeedMenu(shell, menu, true, true, false, hasSelection, downSpeedDisabled, downSpeedUnlimited, totalDownSpeed, downSpeedSetMax, maxDown, upSpeedDisabled, upSpeedUnlimited, totalUpSpeed, upSpeedSetMax, maxUp, peers.length, menu_properties, new ViewUtils.SpeedAdapter(){

            @Override
            public void setDownSpeed(int speed) {
                if (peers.length > 0) {
                    int i = 0;
                    while (i < peers.length) {
                        try {
                            PEPeer peer = peers[i];
                            peer.getStats().setDownloadRateLimitBytesPerSecond(speed);
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                        }
                        ++i;
                    }
                }
            }

            @Override
            public void setUpSpeed(int speed) {
                if (peers.length > 0) {
                    int i = 0;
                    while (i < peers.length) {
                        try {
                            PEPeer peer = peers[i];
                            peer.getStats().setUploadRateLimitBytesPerSecond(speed);
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                        }
                        ++i;
                    }
                }
            }
        });
        MenuItem kick_item = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)kick_item, "PeersView.menu.kick");
        kick_item.addListener(13, (Listener)new PeersRunner(peers){

            @Override
            public void run(PEPeer peer) {
                if (!peer.isMyPeer()) {
                    peer.getManager().removePeer(peer, "Peer kicked", 14);
                }
            }
        });
        kick_item.setEnabled(!onlyMyPeer);
        if (hasIPv4 && hasIPv6) {
            Menu ban_menu = new Menu((Decorations)menu.getShell(), 4);
            ban_item = new MenuItem(menu, 64);
            ban_item.setMenu(ban_menu);
            Messages.setLanguageText((Widget)ban_item, "PeersView.menu.kickandban");
            final MenuItem ban_v4_item = new MenuItem(ban_menu, 8);
            ban_v4_item.setText("IPv4");
            final MenuItem ban_v6_item = new MenuItem(ban_menu, 8);
            ban_v6_item.setText("IPv6");
            final MenuItem ban_v4v6_item = new MenuItem(ban_menu, 8);
            ban_v4v6_item.setText("IPv4 + IPv6");
            PeersRunner l = new PeersRunner(peers){

                @Override
                public void run(Event e, PEPeer peer) {
                    if (!peer.isMyPeer()) {
                        boolean do_ia;
                        String msg = MessageText.getString("PeersView.menu.kickandban.reason");
                        boolean v4 = e.widget == ban_v4_item || e.widget == ban_v4v6_item;
                        boolean v6 = e.widget == ban_v6_item || e.widget == ban_v4v6_item;
                        String ip = peer.getIp();
                        InetAddress ia = peer.getAlternativeIPv6();
                        boolean do_ip = ip.indexOf(46) != -1 ? v4 : v6;
                        if (do_ip) {
                            IpFilterManagerFactory.getSingleton().getIPFilter().ban(ip, msg, true);
                        }
                        if (ia != null && (do_ia = ia instanceof Inet4Address ? v4 : v6)) {
                            IpFilterManagerFactory.getSingleton().getIPFilter().ban(ia.getHostAddress(), msg, true);
                        }
                        peer.getManager().removePeer(peer, "Peer kicked and banned", 5);
                    }
                }
            };
            ban_v4_item.addListener(13, (Listener)l);
            ban_v6_item.addListener(13, (Listener)l);
            ban_v4v6_item.addListener(13, (Listener)l);
        } else {
            ban_item = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)ban_item, "PeersView.menu.kickandban");
            ban_item.addListener(13, (Listener)new PeersRunner(peers){

                @Override
                public void run(PEPeer peer) {
                    if (!peer.isMyPeer()) {
                        String msg = MessageText.getString("PeersView.menu.kickandban.reason");
                        IpFilterManagerFactory.getSingleton().getIPFilter().ban(peer.getIp(), msg, true);
                        peer.getManager().removePeer(peer, "Peer kicked and banned", 5);
                    }
                }
            });
        }
        ban_item.setEnabled(!onlyMyPeer);
        MenuItem ban_for_item = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)ban_for_item, "PeersView.menu.kickandbanfor");
        ban_for_item.addListener(13, (Listener)new PeersRunner(peers){

            @Override
            public boolean run(final PEPeer[] peers) {
                String text = MessageText.getString("dialog.ban.for.period.text");
                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("dialog.ban.for.period.title", "!" + text + "!");
                int def = COConfigurationManager.getIntParameter("ban.for.period.default", 60);
                entryWindow.setPreenteredText(String.valueOf(def), false);
                entryWindow.prompt(new UIInputReceiverListener(){

                    @Override
                    public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                        if (!entryWindow.hasSubmittedInput()) {
                            return;
                        }
                        String sReturn = entryWindow.getSubmittedInput();
                        if (sReturn == null) {
                            return;
                        }
                        int mins = -1;
                        try {
                            mins = Integer.valueOf(sReturn);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (mins <= 0) {
                            MessageBox mb = new MessageBox(Utils.findAnyShell(), 33);
                            mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
                            mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
                            mb.open();
                            return;
                        }
                        COConfigurationManager.setParameter("ban.for.period.default", mins);
                        IpFilter filter2 = IpFilterManagerFactory.getSingleton().getIPFilter();
                        PEPeer[] pEPeerArray = peers;
                        int n = peers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            PEPeer peer = pEPeerArray[n2];
                            if (!peer.isMyPeer()) {
                                String msg = MessageText.getString("PeersView.menu.kickandbanfor.reason", new String[]{String.valueOf(mins)});
                                filter2.ban(peer.getIp(), msg, true, mins);
                                peer.getManager().removePeer(peer, "Peer kicked and banned", 5);
                            }
                            ++n2;
                        }
                    }
                });
                return true;
            }
        });
        ban_for_item.setEnabled(!onlyMyPeer);
        PeersViewBase.addPeersMenu(download_specific, "", menu, peers);
    }

    private static String getMyPeerDetails(List<DownloadManager> dms) {
        InetAddress ip = NetworkAdmin.getSingleton().getDefaultPublicAddress();
        InetAddress ip_v6 = NetworkAdmin.getSingleton().getDefaultPublicAddressV6();
        int port = dms.isEmpty() ? TCPNetworkManager.getSingleton().getDefaultTCPListeningPortNumber() : dms.get(0).getTCPListeningPortNumber();
        String str = "";
        if (port > 0) {
            if (ip != null) {
                str = String.valueOf(ip.getHostAddress()) + ":" + port;
            }
            if (ip_v6 != null) {
                str = String.valueOf(str) + (str.isEmpty() ? "" : ",") + ip_v6.getHostAddress() + ":" + port;
            }
        }
        return str;
    }

    protected static boolean addPeersMenu(final List<DownloadManager> managers, String column_name, Menu menu, PEPeer[] peers) {
        MenuBuildUtils.addSeparator(menu);
        MenuItem copy_me_item = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)copy_me_item, "menu.copy.my.peer");
        copy_me_item.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                String str = PeersViewBase.getMyPeerDetails(managers);
                if (str.isEmpty()) {
                    str = "<no usable peers>";
                }
                ClipboardCopy.copyToClipBoard(str);
            }
        });
        final ArrayList<DownloadManager> publicdms = new ArrayList<DownloadManager>();
        for (DownloadManager dm : managers) {
            if (TorrentUtils.isReallyPrivate(dm.getTorrent()) || dm.getPeerManager() == null) continue;
            publicdms.add(dm);
        }
        if (!publicdms.isEmpty()) {
            MenuItem copy_all_peers = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)copy_all_peers, "menu.copy.all.peers");
            copy_all_peers.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    String str = PeersViewBase.getMyPeerDetails(managers);
                    for (DownloadManager dm : publicdms) {
                        PEPeerManager pm = dm.getPeerManager();
                        if (pm == null) continue;
                        for (PEPeer peer : pm.getPeers()) {
                            int port = peer.getTCPListenPort();
                            if (port <= 0) continue;
                            String address = String.valueOf(peer.getIp()) + ":" + port;
                            str = String.valueOf(str) + (str.isEmpty() ? "" : ",") + address;
                        }
                        if (!str.isEmpty()) continue;
                        str = "<no usable peers>";
                    }
                    ClipboardCopy.copyToClipBoard(str);
                }
            });
            MenuItem add_peers_item = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)add_peers_item, "menu.add.peers");
            add_peers_item.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("dialog.add.peers.title", "dialog.add.peers.msg");
                    String def = COConfigurationManager.getStringParameter("add.peers.default", "");
                    entryWindow.setPreenteredText(String.valueOf(def), false);
                    entryWindow.addVerifyListener(new VerifyListener(){

                        public void verifyText(VerifyEvent e) {
                            String str = e.text.replaceAll("[\\r\\n]+", ",");
                            if (!str.equals(e.text)) {
                                while (str.contains(",,")) {
                                    str = str.replace(",,", ",");
                                }
                                str = str.trim();
                                while (str.endsWith(",")) {
                                    str = str.substring(0, str.length() - 1).trim();
                                }
                                while (str.startsWith(",")) {
                                    str = str.substring(1).trim();
                                }
                            }
                            e.text = str;
                        }
                    });
                    entryWindow.prompt(new UIInputReceiverListener(){

                        @Override
                        public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                            if (!entryWindow.hasSubmittedInput()) {
                                return;
                            }
                            final String sReturn = entryWindow.getSubmittedInput();
                            if (sReturn == null) {
                                return;
                            }
                            COConfigurationManager.setParameter("add.peers.default", sReturn);
                            for (DownloadManager dm : publicdms) {
                                final PEPeerManager pm = dm.getPeerManager();
                                if (pm == null) continue;
                                Utils.getOffOfSWTThread(new AERunnable(){

                                    @Override
                                    public void runSupport() {
                                        String[] bits;
                                        String[] stringArray = bits = sReturn.replace(';', ',').split(",");
                                        int n = bits.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String bit = stringArray[n2];
                                            if (!(bit = bit.trim()).isEmpty()) {
                                                int pos = bit.lastIndexOf(58);
                                                try {
                                                    if (pos != -1) {
                                                        String host = bit.substring(0, pos).trim();
                                                        String port = bit.substring(pos + 1).trim();
                                                        int i_port = Integer.parseInt(port);
                                                        pm.addPeer(host, i_port, 0, NetworkManager.getCryptoRequired(0), null);
                                                    } else {
                                                        pm.addPeer(bit, 6881, 0, NetworkManager.getCryptoRequired(0), null);
                                                    }
                                                }
                                                catch (Throwable e) {
                                                    Debug.out(e);
                                                }
                                            }
                                            ++n2;
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            });
        }
        PeersViewBase.addPeerSetMenu(menu, peers);
        return true;
    }

    public static void addPeerSetMenu(Menu menu, PEPeer[] peers) {
        String peer_cc = null;
        if (peers.length == 1) {
            String[] details = PeerUtils.getCountryDetails(peers[0]);
            peer_cc = details != null && details.length > 0 ? details[0] : "??";
        }
        PeersViewBase.addPeerSetMenu(menu, true, peer_cc);
    }

    public static void addPeerSetMenu(Menu menu, boolean do_auto_cat, String peer_cc) {
        MenuItem auto_cat_item;
        SpeedLimitHandler slh = SpeedLimitHandler.getSingleton(CoreFactory.getSingleton());
        List<SpeedLimitHandler.PeerSet> peer_sets = slh.getPeerSets();
        boolean has_auto_cat = false;
        boolean has_cc_peer_set = false;
        String peer_cc_set_name = peer_cc == null ? null : String.valueOf(peer_cc) + " " + MessageText.getString("TableColumn.header.peers");
        for (SpeedLimitHandler.PeerSet peer_set : peer_sets) {
            Pattern pattern;
            if (do_auto_cat && (pattern = peer_set.getClientPattern()) != null && pattern.pattern().equals("auto")) {
                has_auto_cat = true;
            }
            if (peer_cc_set_name == null || !peer_set.getName().equals(peer_cc_set_name)) continue;
            has_cc_peer_set = true;
        }
        if (do_auto_cat && !has_auto_cat) {
            auto_cat_item = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)auto_cat_item, "menu.add.auto.client.peerset");
            auto_cat_item.addListener(13, e -> slh.addConfigLine("peer_set Auto=all,client=auto", true));
        }
        if (peer_cc_set_name != null && !has_cc_peer_set) {
            auto_cat_item = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)auto_cat_item, "menu.add.peerset.for.cc", Utils.getCCString(peer_cc));
            auto_cat_item.addListener(13, e -> slh.addConfigLine("peer_set " + peer_cc_set_name + "=" + peer_cc + ",group=" + MessageText.getString("TableColumn.header.Country"), true));
        }
        if (has_auto_cat || has_cc_peer_set) {
            MenuItem edit_slh_item = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)edit_slh_item, "menu.edit.peer.set.config");
            edit_slh_item.addListener(13, e -> Utils.editSpeedLimitHandlerConfig(slh));
        }
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        PeersViewBase.fillMenu(menu, this.tv, this.shell, Collections.emptyList());
        new MenuItem(menu, 2);
    }

    @Override
    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
        if (PeersViewBase.addPeersMenu(new ArrayList<DownloadManager>(), sColumnName, menuThisColumn, new PEPeer[0])) {
            new MenuItem(menuThisColumn, 2);
        }
    }

    protected abstract void updateSelectedContent();

    @Override
    public void deselected(TableRowCore[] rows) {
        this.updateSelectedContent();
    }

    @Override
    public void focusChanged(TableRowCore focus) {
    }

    @Override
    public void selected(TableRowCore[] rows) {
        this.updateSelectedContent();
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        if (rows.length == 1) {
            PEPeer peer = (PEPeer)rows[0].getDataSource(true);
            DownloadManager dm = peer.getManager().getDiskManager().getDownload();
            UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
            if (uiFunctions != null) {
                uiFunctions.getMDI().showEntryByID("DMDetails", dm);
            }
        }
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    private static abstract class PeersRunner
    implements Listener {
        private PEPeer[] peers;

        private PeersRunner(PEPeer[] _peers) {
            this.peers = _peers;
        }

        public void handleEvent(Event e) {
            if (!this.run(e, this.peers)) {
                PEPeer[] pEPeerArray = this.peers;
                int n = this.peers.length;
                int n2 = 0;
                while (n2 < n) {
                    PEPeer peer = pEPeerArray[n2];
                    this.run(e, peer);
                    ++n2;
                }
            }
        }

        public void run(Event e, PEPeer peer) {
            this.run(peer);
        }

        public boolean run(Event e, PEPeer[] peers) {
            return this.run(peers);
        }

        public void run(PEPeer peer) {
        }

        public boolean run(PEPeer[] peers) {
            return false;
        }
    }
}

