/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerPeerListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPeerManagerListenerAdapter;
import com.biglybt.core.peer.PEPeerStats;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.pif.peers.PeerReadRequest;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.selectedcontent.SelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.Legend;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.views.ViewUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class PieceBlocksView
implements UIPluginViewToolBarListener,
UISWTViewCoreEventListener,
ParameterListener {
    public static String MSGID_PREFIX = "PieceBlocksView";
    private static final Color[] block_colours = new Color[]{Colors.bluesFixed[9], Colors.bluesFixed[2], Colors.green, Colors.fadedGreen};
    private static final String[] legend_keys = new String[]{"PieceBlocksView.block.done1", "PieceBlocksView.block.active1", "PieceBlocksView.block.done2", "PieceBlocksView.block.active2"};
    private int MAX_ACTIVE_BLOCKS;
    private Canvas canvas;
    private Image img;
    private TimerEventPeriodic block_refresher;
    private Object dm_data_lock = new Object();
    private ManagerData[] dm_data = new ManagerData[0];
    private volatile boolean all_blocks_view;
    private boolean comp_focused;
    private Object focus_pending_ds;
    private List<DownloadManager> abv_last_active = Collections.emptyList();
    private UISWTView swtView;
    private boolean last_left_to_right = true;
    private int last_alpha = 255;

    public PieceBlocksView() {
        COConfigurationManager.addAndFireParameterListener("blocks.view.max.active", this);
    }

    @Override
    public void parameterChanged(String parameterName) {
        this.MAX_ACTIVE_BLOCKS = COConfigurationManager.getIntParameter("blocks.view.max.active");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFocused(boolean foc) {
        if (foc) {
            this.comp_focused = true;
            this.dataSourceChanged(this.focus_pending_ds);
        } else {
            Object object = this.dm_data_lock;
            synchronized (object) {
                DownloadManager[] temp = new DownloadManager[this.dm_data.length];
                int i = 0;
                while (i < temp.length) {
                    temp[i] = this.dm_data[i].manager;
                    ++i;
                }
                this.focus_pending_ds = temp;
            }
            this.dataSourceChanged(null);
            this.comp_focused = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dataSourceChanged(Object newDataSource) {
        if (newDataSource instanceof String) {
            Object object = this.dm_data_lock;
            synchronized (object) {
                if (!this.all_blocks_view) {
                    this.all_blocks_view = true;
                    this.swtView.setTitle(MessageText.getString(this.getData()));
                }
            }
            return;
        }
        if (!this.comp_focused) {
            this.focus_pending_ds = newDataSource;
            return;
        }
        ArrayList<DownloadManager> existing = new ArrayList<DownloadManager>();
        Object object = this.dm_data_lock;
        synchronized (object) {
            ManagerData[] managerDataArray = this.dm_data;
            int n = this.dm_data.length;
            int n2 = 0;
            while (n2 < n) {
                ManagerData data = managerDataArray[n2];
                existing.add(data.manager);
                ++n2;
            }
        }
        List<DownloadManager> newManagers = newDataSource instanceof List ? (List<DownloadManager>)newDataSource : ViewUtils.getDownloadManagersFromDataSource(newDataSource, existing);
        Object object2 = this.dm_data_lock;
        synchronized (object2) {
            IdentityHashMap<DownloadManager, ManagerData> map = new IdentityHashMap<DownloadManager, ManagerData>();
            ManagerData[] managerDataArray = this.dm_data;
            int n = this.dm_data.length;
            int n3 = 0;
            while (n3 < n) {
                ManagerData data = managerDataArray[n3];
                map.put(data.manager, data);
                ++n3;
            }
            ManagerData[] new_data = new ManagerData[newManagers.size()];
            boolean changed = new_data.length != this.dm_data.length;
            int i = 0;
            while (i < new_data.length) {
                DownloadManager dm = newManagers.get(i);
                ManagerData existing_data = (ManagerData)map.remove(dm);
                if (existing_data != null) {
                    new_data[i] = existing_data;
                    if (i < this.dm_data.length && this.dm_data[i] != existing_data) {
                        changed = true;
                    }
                } else {
                    new_data[i] = new ManagerData(dm);
                    changed = true;
                }
                ++i;
            }
            if (map.size() > 0) {
                changed = true;
                for (ManagerData data : map.values()) {
                    data.delete();
                }
            }
            if (!changed) {
                return;
            }
            Arrays.sort(new_data, (a, b) -> Long.compare(a.getAddTime(), b.getAddTime()));
            this.dm_data = new_data;
            Utils.execSWTThread(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    Object object = PieceBlocksView.this.dm_data_lock;
                    synchronized (object) {
                        if (PieceBlocksView.this.dm_data.length > 0) {
                            Utils.disposeComposite((Composite)PieceBlocksView.this.canvas, false);
                        } else {
                            ViewUtils.setViewRequiresOneDownload((Composite)PieceBlocksView.this.canvas);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete() {
        COConfigurationManager.removeParameterListener("blocks.view.max.active", this);
        Object object = this.dm_data_lock;
        synchronized (object) {
            ManagerData[] managerDataArray = this.dm_data;
            int n = this.dm_data.length;
            int n2 = 0;
            while (n2 < n) {
                ManagerData data = managerDataArray[n2];
                data.delete();
                ++n2;
            }
            this.dm_data = new ManagerData[0];
        }
    }

    protected Composite getComposite() {
        return this.canvas;
    }

    private String getData() {
        return this.all_blocks_view ? "MainWindow.menu.view.allblocks" : "PieceBlocksView.title.full";
    }

    protected void initialize(Composite parent) {
        Composite comp2 = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp2.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        comp2.setLayoutData((Object)gridData);
        if (!Utils.isDarkAppearanceNative()) {
            comp2.setBackground(Colors.white);
        }
        this.canvas = new Canvas(comp2, 262144);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle client_bounds = PieceBlocksView.this.canvas.getClientArea();
                int x = e.x;
                int y = e.y;
                int width = e.width;
                int height = e.height;
                if (client_bounds.width > 0 && client_bounds.height > 0) {
                    PieceBlocksView.this.updateImage();
                    e.gc.drawImage(PieceBlocksView.this.img, x, y, width, height, x, y, width, height);
                }
            }
        });
        this.canvas.addListener(12, ev -> {
            if (this.img != null && !this.img.isDisposed()) {
                this.img.dispose();
                this.img = null;
            }
        });
        String[] legend_texts = new String[]{String.valueOf(MessageText.getString("FileView.BlockView.Done")) + " 1", String.valueOf(MessageText.getString("FileView.BlockView.Active")) + " 1", String.valueOf(MessageText.getString("FileView.BlockView.Done")) + " 2", String.valueOf(MessageText.getString("FileView.BlockView.Active")) + " 2"};
        Legend.createLegendComposite(comp2, block_colours, legend_keys, legend_texts, new GridData(4, -1, true, false, 1, 1), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        if (this.all_blocks_view) {
            ArrayList<DownloadManager> new_dms = null;
            Object object = this.dm_data_lock;
            synchronized (object) {
                boolean changed;
                List<DownloadManager> dms = CoreFactory.getSingleton().getGlobalManager().getDownloadManagers();
                ArrayList<DownloadManager> active = new ArrayList<DownloadManager>(dms.size());
                for (DownloadManager dm : dms) {
                    if (dm.getState() != 50) continue;
                    active.add(dm);
                }
                boolean bl = changed = this.abv_last_active.size() != active.size();
                if (!changed) {
                    int i = 0;
                    while (i < active.size()) {
                        if (this.abv_last_active.get(i) != active.get(i)) {
                            changed = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (changed) {
                    new_dms = active;
                    this.abv_last_active = active;
                }
            }
            if (new_dms != null) {
                this.dataSourceChanged(new_dms);
            }
        }
        Object object = this.dm_data_lock;
        synchronized (object) {
            if (this.canvas == null || this.canvas.isDisposed()) {
                return;
            }
            if (this.block_refresher == null) {
                this.block_refresher = SimpleTimer.addPeriodicEvent("PBV:AR", 100L, ev -> Utils.execSWTThread(() -> {
                    if (this.canvas.isDisposed()) {
                        Object object = this.dm_data_lock;
                        synchronized (object) {
                            if (this.block_refresher != null) {
                                this.block_refresher.cancel();
                                this.block_refresher = null;
                            }
                        }
                        return;
                    }
                    this.canvas.redraw();
                }));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void updateImage() {
        var1_1 = this.dm_data_lock;
        synchronized (var1_1) {
            block49: {
                if (this.canvas == null || this.canvas.isDisposed()) {
                    return;
                }
                bounds = this.canvas.getClientArea();
                width = bounds.width;
                height = bounds.height;
                if (width <= 0 || height <= 0) {
                    return;
                }
                if (this.block_refresher == null) {
                    this.block_refresher = SimpleTimer.addPeriodicEvent("PBV:AR", 100L, (TimerEventPerformer)LambdaMetafactory.metafactory(null, null, null, (Lcom/biglybt/core/util/TimerEvent;)V, lambda$4(com.biglybt.core.util.TimerEvent ), (Lcom/biglybt/core/util/TimerEvent;)V)((PieceBlocksView)this));
                }
                v0 = clearImage = this.img == null || this.img.isDisposed() != false || this.img.getBounds().width != bounds.width || this.img.getBounds().height != bounds.height;
                if (clearImage) {
                    if (this.img != null && !this.img.isDisposed()) {
                        this.img.dispose();
                    }
                    this.img = new Image((Device)this.canvas.getDisplay(), width, height);
                }
                gc = new GC((Drawable)this.img);
                gc.setBackground(Utils.isDarkAppearanceNative() != false ? this.canvas.getBackground() : Colors.white);
                gc.fillRectangle(0, 0, width, height);
                try {
                    gc.setTextAntialias(1);
                    gc.setAntialias(1);
                }
                catch (Exception var7_7) {
                    // empty catch block
                }
                try {
                    block50: {
                        piece_counts = new int[this.dm_data.length];
                        blocks_rem = this.MAX_ACTIVE_BLOCKS;
                        total_pieces = 0;
                        dms_with_pieces = 0;
                        i = 0;
                        while (i < this.dm_data.length && blocks_rem > 0) {
                            md = this.dm_data[i];
                            piece_data = md.update();
                            pieces = 0;
                            var18_21 = piece_data;
                            var17_20 = piece_data.length;
                            var16_19 = 0;
                            while (var16_19 < var17_20) {
                                active = var18_21[var16_19];
                                if (active > 0) {
                                    ++pieces;
                                    if (active >= blocks_rem) {
                                        blocks_rem = 0;
                                        break;
                                    }
                                    blocks_rem -= active;
                                }
                                ++var16_19;
                            }
                            if (pieces > 0) {
                                piece_counts[i] = pieces;
                                total_pieces += pieces;
                                ++dms_with_pieces;
                            }
                            ++i;
                        }
                        if (total_pieces == 0) {
                            return;
                        }
                        piece_space = height / 3;
                        block_space = height - piece_space;
                        piece_height = piece_space / total_pieces;
                        if (piece_height > 10) {
                            piece_height = 10;
                        } else if (piece_height < 1) {
                            piece_height = 1;
                        }
                        max_pieces = piece_space / piece_height;
                        if (total_pieces > max_pieces) {
                            pieces_per_dm = max_pieces / dms_with_pieces;
                            if (pieces_per_dm == 0) {
                                pieces_per_dm = 1;
                            }
                            used_pieces = 0;
                            dms_with_too_many_pieces = 0;
                            i = 0;
                            while (i < this.dm_data.length) {
                                pieces = piece_counts[i];
                                if (pieces > 0) {
                                    if (pieces <= pieces_per_dm) {
                                        used_pieces += pieces;
                                    } else {
                                        ++dms_with_too_many_pieces;
                                    }
                                }
                                ++i;
                            }
                            if (dms_with_too_many_pieces > 0) {
                                rem_pieces = max_pieces - used_pieces;
                                pieces_per_dm = rem_pieces / dms_with_too_many_pieces;
                                if (pieces_per_dm == 0) {
                                    pieces_per_dm = 1;
                                }
                                i = 0;
                                while (i < this.dm_data.length) {
                                    pieces = piece_counts[i];
                                    if (pieces > 0 && pieces > pieces_per_dm) {
                                        piece_counts[i] = pieces_per_dm;
                                    }
                                    ++i;
                                }
                            }
                        }
                        y_pos_start = height - piece_height;
                        dm_num = 0;
                        if (piece_height < 3) break block50;
                        gc.setAlpha(255);
                        y_pos = y_pos_start;
                        i = 0;
                        block16: while (i < piece_counts.length) {
                            piece_count = piece_counts[i];
                            if (piece_count != 0) ** GOTO lbl109
                            ** GOTO lbl110
                            while (y_pos >= block_space) {
                                --piece_count;
                                gc.drawRectangle(0, y_pos - 1, width - 1, piece_height);
                                y_pos -= piece_height;
lbl109:
                                // 2 sources

                                if (piece_count > 0) continue;
lbl110:
                                // 2 sources

                                ++i;
                                continue block16;
                            }
                            break block16;
                        }
                    }
                    y_pos = y_pos_start;
                    i = 0;
                    while (i < piece_counts.length) {
                        piece_count = piece_counts[i];
                        if (piece_count != 0) {
                            ++dm_num;
                            var20_27 = this.dm_data[i].lock;
                            synchronized (var20_27) {
                                for (PieceDetails piece_details : ManagerData.access$2(this.dm_data[i]).values()) {
                                    if (y_pos < block_space) {
                                        break block49;
                                    }
                                    if (piece_count == 0) break;
                                    --piece_count;
                                    odd = dm_num % 2 == 1;
                                    left_to_right = piece_details.left_to_right;
                                    downloaded = piece_details.getDownloaded();
                                    overall_block_width = (float)width / (float)downloaded.length;
                                    gc.setBackground(PieceBlocksView.block_colours[odd != false ? 1 : 3]);
                                    gc.setAlpha(piece_details.alpha);
                                    for (BlockDetails block : piece_details.blocks) {
                                        block_number = block.block_number;
                                        if (downloaded[block_number] || block.request.isCancelled()) continue;
                                        block_x = (int)(overall_block_width * (float)block_number);
                                        block_y = odd != false ? y_pos * block.done / block.size : (y_pos - piece_height) * block.done / block.size + piece_height;
                                        block_width = (int)(overall_block_width * (float)(block_number + 1)) - block_x;
                                        gc.fillRectangle(block_x, block_y, block_width, piece_height);
                                    }
                                    gc.setBackground(PieceBlocksView.block_colours[odd != false ? 0 : 2]);
                                    missing = null;
                                    if ((double)overall_block_width < 1.0) {
                                        missing = new boolean[(int)(overall_block_width * (float)downloaded.length)];
                                        j = 0;
                                        while (j < downloaded.length) {
                                            if (!downloaded[j]) {
                                                block_x = (int)(overall_block_width * (float)j);
                                                missing[block_x] = true;
                                            }
                                            ++j;
                                        }
                                    }
                                    j = 0;
                                    while (j < downloaded.length) {
                                        if (downloaded[j]) {
                                            block_x = (int)(overall_block_width * (float)j);
                                            if (missing == null || !missing[block_x]) {
                                                block_width = (int)(overall_block_width * (float)(j + 1)) - block_x;
                                                gc.fillRectangle(block_x, y_pos, block_width, piece_height);
                                            }
                                        }
                                        ++j;
                                    }
                                    y_pos -= piece_height;
                                }
                            }
                        }
                        ++i;
                    }
                }
                finally {
                    gc.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = event2.getView();
                this.swtView.setTitle(MessageText.getString(this.getData()));
                this.swtView.setToolBarListener(this);
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(MessageText.getString(this.getData()));
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                String id = "DMDetails_Swarm";
                this.setFocused(true);
                Object object = this.dm_data_lock;
                synchronized (object) {
                    if (this.dm_data.length == 0) {
                        SelectedContentManager.changeCurrentlySelectedContent(id, null);
                    } else {
                        DownloadManager manager = this.dm_data[0].manager;
                        id = manager.getTorrent() != null ? String.valueOf(id) + "." + manager.getInternalName() : String.valueOf(id) + ":" + manager.getSize();
                        SelectedContentManager.changeCurrentlySelectedContent(id, new SelectedContent[]{new SelectedContent(manager)});
                    }
                    break;
                }
            }
            case 4: {
                this.setFocused(false);
                SelectedContentManager.clearCurrentlySelectedContent();
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        return false;
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        Map<String, Long> states = TorrentUtil.calculateToolbarStates(SelectedContentManager.getCurrentlySelectedContent(), null);
        list.putAll(states);
    }

    private /* synthetic */ void lambda$4(TimerEvent ev) {
        Utils.execSWTThread(() -> {
            if (this.canvas.isDisposed()) {
                Object object = this.dm_data_lock;
                synchronized (object) {
                    if (this.block_refresher != null) {
                        this.block_refresher.cancel();
                        this.block_refresher = null;
                    }
                }
                return;
            }
            this.canvas.redraw();
        });
    }

    private class BlockDetails {
        final PieceDetails piece_details;
        final PeerReadRequest request;
        final PEPiece piece;
        final int block_number;
        final int size;
        int done;

        BlockDetails(PieceDetails _piece, PeerReadRequest _request, int _bn) {
            this.piece_details = _piece;
            this.request = _request;
            this.block_number = _bn;
            this.piece = this.piece_details.piece;
            this.size = this.piece.getBlockSize(this.block_number);
        }

        boolean isActuallyDone() {
            return this.piece.isDownloaded(this.block_number);
        }

        boolean checkDone() {
            if (this.done == this.size) {
                this.piece_details.setDone(this);
                return true;
            }
            if (this.request.isCancelled()) {
                return true;
            }
            return this.piece_details.isDone();
        }

        void setDone() {
            this.done = this.size;
            this.piece_details.setDone(this);
        }

        void peerRemoved() {
            if (this.isActuallyDone()) {
                this.done = this.size;
            }
            this.remove();
        }

        void remove() {
            this.piece_details.removeRequest(this);
        }
    }

    private class ManagerData
    extends PEPeerManagerListenerAdapter
    implements DownloadManagerPeerListener {
        final Object lock = this;
        private final long add_time = SystemTime.getMonotonousTime();
        private final DownloadManager manager;
        private final int blocks_per_piece;
        private PEPeerManager peer_manager;
        private Map<PEPeer, PeerDetails> peer_map = new HashMap<PEPeer, PeerDetails>();
        private Map<Integer, PieceDetails> piece_map = new LinkedHashMap<Integer, PieceDetails>();
        private boolean deleted;

        private ManagerData(DownloadManager _manager) {
            this.manager = _manager;
            int bpp = 1;
            try {
                bpp = (int)(this.manager.getTorrent().getPieceLength() / 16384L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.blocks_per_piece = bpp;
            this.manager.addPeerListener(this);
        }

        int getBlocksPerPiece() {
            return this.blocks_per_piece;
        }

        long getAddTime() {
            return this.add_time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void delete() {
            PEPeerManager pm;
            Object object = this.lock;
            synchronized (object) {
                pm = this.peer_manager;
                this.peer_map.clear();
                this.piece_map.clear();
                this.deleted = true;
            }
            if (pm != null) {
                pm.removeListener(this);
            }
            this.manager.removePeerListener(this);
        }

        @Override
        public void peerManagerWillBeAdded(PEPeerManager peer_manager) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void peerManagerAdded(PEPeerManager manager) {
            PEPeerManager old_pm;
            manager.addListener(this);
            ArrayList<PEPiece> initial_pieces = new ArrayList<PEPiece>(manager.getNbPieces());
            Object object = this.lock;
            synchronized (object) {
                if (this.deleted) {
                    return;
                }
                old_pm = this.peer_manager;
                this.peer_manager = manager;
                PEPiece[] pEPieceArray = manager.getPieces();
                int n = pEPieceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PEPiece piece = pEPieceArray[n2];
                    if (piece != null) {
                        initial_pieces.add(piece);
                    }
                    ++n2;
                }
            }
            for (PEPiece piece : initial_pieces) {
                this.pieceAdded(manager, piece, null);
            }
            if (old_pm != null) {
                old_pm.removeListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void peerManagerRemoved(PEPeerManager manager) {
            Object object = this.lock;
            synchronized (object) {
                if (manager == this.peer_manager) {
                    this.peer_manager = null;
                    this.peer_map.clear();
                    this.piece_map.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pieceAdded(PEPeerManager manager, PEPiece piece, PEPeer for_peer) {
            if (for_peer == null) {
                int pn = piece.getPieceNumber();
                Object object = this.lock;
                synchronized (object) {
                    if (this.deleted) {
                        return;
                    }
                    if (!this.piece_map.containsKey(pn)) {
                        this.piece_map.put(pn, new PieceDetails(piece, this.piece_map.size() % 2 == 0));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pieceRemoved(PEPeerManager manager, PEPiece piece) {
            int piece_number = piece.getPieceNumber();
            Object object = this.lock;
            synchronized (object) {
                PieceDetails details = this.piece_map.get(piece_number);
                if (details != null && details.remove()) {
                    this.piece_map.remove(piece_number);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestAdded(PEPeerManager manager, PEPiece piece, PEPeer peer, PeerReadRequest request2) {
            Object object = this.lock;
            synchronized (object) {
                int pn;
                PieceDetails piece_details;
                if (this.deleted) {
                    return;
                }
                PeerDetails peer_details = this.peer_map.get(peer);
                if (peer_details == null) {
                    peer_details = new PeerDetails(peer);
                    this.peer_map.put(peer, peer_details);
                }
                if ((piece_details = this.piece_map.get(pn = piece.getPieceNumber())) == null) {
                    piece_details = new PieceDetails(piece, peer_details.left_to_right);
                    this.piece_map.put(pn, piece_details);
                }
                BlockDetails block = peer_details.addRequest(piece_details, request2);
                piece_details.addRequest(block);
            }
        }

        @Override
        public void peerAdded(PEPeer peer) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void peerRemoved(PEPeer peer) {
            Object object = this.lock;
            synchronized (object) {
                PeerDetails details = this.peer_map.remove(peer);
                if (details != null) {
                    details.removePeer();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int[] update() {
            Object object = this.lock;
            synchronized (object) {
                for (PeerDetails peer : this.peer_map.values()) {
                    peer.update();
                }
                int[] result = new int[this.piece_map.size()];
                int pos = 0;
                Iterator<PieceDetails> it = this.piece_map.values().iterator();
                while (it.hasNext()) {
                    PieceDetails piece = it.next();
                    int active = piece.update();
                    if (piece.isDone()) {
                        it.remove();
                        result[pos] = 0;
                    } else {
                        result[pos] = active;
                    }
                    ++pos;
                }
                return result;
            }
        }

        static /* synthetic */ Map access$2(ManagerData managerData) {
            return managerData.piece_map;
        }
    }

    private class PeerDetails {
        final PEPeer peer;
        final PEPeerStats stats;
        final boolean left_to_right;
        final List<BlockDetails> blocks = new ArrayList<BlockDetails>();
        long last_update = SystemTime.getMonotonousTime();
        long stall_time = -1L;

        PeerDetails(PEPeer _peer) {
            this.peer = _peer;
            this.stats = this.peer.getStats();
            this.left_to_right = PieceBlocksView.this.last_left_to_right;
            PieceBlocksView.this.last_left_to_right = !PieceBlocksView.this.last_left_to_right;
        }

        BlockDetails addRequest(PieceDetails piece, PeerReadRequest request2) {
            int block_number = request2.getOffset() / 16384;
            BlockDetails block = new BlockDetails(piece, request2, block_number);
            this.blocks.add(block);
            return block;
        }

        void removePeer() {
            for (BlockDetails block : this.blocks) {
                block.peerRemoved();
            }
        }

        void update() {
            int num_blocks;
            long now = SystemTime.getMonotonousTime();
            long time_diff = now - this.last_update;
            if (time_diff == 0L) {
                return;
            }
            this.last_update = now;
            long receive_rate = this.stats.getDataReceiveRate();
            if (receive_rate == 0L) {
                if (this.stall_time == -1L) {
                    this.stall_time = now;
                }
            } else {
                this.stall_time = -1L;
            }
            if ((num_blocks = this.blocks.size()) == 0) {
                return;
            }
            int active_blocks = (int)(receive_rate + 16384L - 1L) / 16384;
            if (num_blocks < active_blocks) {
                active_blocks = num_blocks;
            }
            long bytes_diff = (receive_rate + 999L) * time_diff / 1000L;
            Iterator<BlockDetails> it = this.blocks.iterator();
            while (it.hasNext()) {
                BlockDetails block = it.next();
                if (block.checkDone()) {
                    block.remove();
                    it.remove();
                    continue;
                }
                if (this.stall_time >= 0L && now - this.stall_time > 10000L && block.isActuallyDone()) {
                    block.setDone();
                    block.remove();
                    it.remove();
                    continue;
                }
                if (bytes_diff <= 0L || active_blocks == 0) continue;
                int rem = block.size - block.done;
                long bytes_per_block = (bytes_diff + (long)active_blocks - 1L) / (long)active_blocks;
                if ((long)rem > bytes_per_block) {
                    block.done = (int)((long)block.done + bytes_per_block);
                    bytes_diff -= bytes_per_block;
                    continue;
                }
                block.done = block.size;
                bytes_diff -= (long)rem;
            }
        }
    }

    private class PieceDetails {
        final PEPiece piece;
        final int block_num;
        final int[] block_states;
        final boolean[] blocks_done;
        final List<BlockDetails> blocks = new LinkedList<BlockDetails>();
        final boolean left_to_right;
        final int alpha;
        int blocks_done_num;
        long complete_time = -1L;

        PieceDetails(PEPiece _piece, boolean _left_to_right) {
            this.piece = _piece;
            this.left_to_right = _left_to_right;
            this.block_num = this.piece.getNbBlocks();
            this.block_states = new int[this.block_num];
            this.blocks_done = new boolean[this.block_num];
            this.alpha = PieceBlocksView.this.last_alpha == 255 ? 180 : 255;
            PieceBlocksView.this.last_alpha = this.alpha;
            boolean[] downloaded = this.piece.getDownloaded();
            int i = 0;
            while (i < this.block_num) {
                if (downloaded[i]) {
                    this.blocks_done[i] = true;
                    ++this.blocks_done_num;
                }
                ++i;
            }
        }

        int update() {
            int active = 0;
            int i = 0;
            while (i < this.block_num) {
                if (!this.blocks_done[i]) {
                    int state = this.block_states[i];
                    if (state == 2) {
                        this.blocks_done[i] = true;
                        ++this.blocks_done_num;
                    } else if (state == 1) {
                        ++active;
                    }
                }
                ++i;
            }
            return active;
        }

        void addRequest(BlockDetails block) {
            int block_number = block.block_number;
            this.blocks.add(block);
            if (this.block_states[block_number] == 0) {
                this.block_states[block_number] = 1;
            }
        }

        void removeRequest(BlockDetails block) {
            int block_number = block.block_number;
            this.blocks.remove(block);
            if (block.done == block.size) {
                this.block_states[block_number] = 2;
            }
        }

        boolean[] getDownloaded() {
            return this.blocks_done;
        }

        void setDone(BlockDetails block) {
            this.block_states[block.block_number] = 2;
        }

        boolean isDone() {
            if (this.blocks_done_num == this.block_num && this.piece.isDownloaded()) {
                return true;
            }
            return this.complete_time >= 0L && SystemTime.getMonotonousTime() - this.complete_time > 10000L;
        }

        boolean remove() {
            if (this.piece.isDownloaded()) {
                this.complete_time = SystemTime.getMonotonousTime();
                return false;
            }
            return true;
        }
    }
}

