/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.DiskManagerReadRequest;
import com.biglybt.core.disk.impl.piecemapper.DMPieceList;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapEntry;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.peermanager.piecepicker.PiecePicker;
import com.biglybt.core.util.CopyOnWriteSet;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.IdentityHashSet;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableLifeCycleListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableSelectionListener;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.table.TableViewFilterCheck;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo2;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BubbleTextBox;
import com.biglybt.ui.swt.components.Legend;
import com.biglybt.ui.swt.mdi.MdiEntrySWT;
import com.biglybt.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pif.UISWTViewEventListener;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.views.PeersView;
import com.biglybt.ui.swt.views.ViewManagerSWT;
import com.biglybt.ui.swt.views.piece.MyPieceDistributionView;
import com.biglybt.ui.swt.views.piece.PieceMapView;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.TableViewSWTMenuFillListener;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import com.biglybt.ui.swt.views.table.impl.TableViewSWT_TabsCommon;
import com.biglybt.ui.swt.views.table.impl.TableViewTab;
import com.biglybt.ui.swt.views.tableitems.pieces.AvailabilityItem;
import com.biglybt.ui.swt.views.tableitems.pieces.BlockCountItem;
import com.biglybt.ui.swt.views.tableitems.pieces.BlocksItem;
import com.biglybt.ui.swt.views.tableitems.pieces.CompletedItem;
import com.biglybt.ui.swt.views.tableitems.pieces.DownloadNameItem;
import com.biglybt.ui.swt.views.tableitems.pieces.FilesItem;
import com.biglybt.ui.swt.views.tableitems.pieces.PieceNumberItem;
import com.biglybt.ui.swt.views.tableitems.pieces.PriorityItem;
import com.biglybt.ui.swt.views.tableitems.pieces.RequestedItem;
import com.biglybt.ui.swt.views.tableitems.pieces.ReservedByItem;
import com.biglybt.ui.swt.views.tableitems.pieces.SizeItem;
import com.biglybt.ui.swt.views.tableitems.pieces.SpeedItem;
import com.biglybt.ui.swt.views.tableitems.pieces.TypeItem;
import com.biglybt.ui.swt.views.tableitems.pieces.WritersItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public abstract class PiecesViewBase
extends TableViewTab<PEPiece>
implements TableLifeCycleListener,
TableViewSWTMenuFillListener,
TableSelectionListener,
UISWTViewCoreEventListener,
TableViewFilterCheck<PEPiece>,
ViewTitleInfo2 {
    public static final Class<PEPiece> PLUGIN_DS_TYPE = PEPiece.class;
    private static final TableColumnCore[] basicItems = PiecesViewBase.getBasicColumnItems("Pieces");
    private static String[] legendKeys;
    private BubbleTextBox bubbleTextBox;
    protected TableViewSWT<PEPiece> tv;
    private Composite legendComposite;
    private MultipleDocumentInterfaceSWT mdi;
    private boolean shown;
    private Map<Long, PEPieceUploading> uploading_pieces = new HashMap<Long, PEPieceUploading>();
    private boolean show_uploading;

    static {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.setDefaultColumnNames("Pieces", basicItems);
        legendKeys = new String[]{"PiecesView.legend.requested", "PiecesView.legend.written", "PiecesView.legend.downloaded", "PiecesView.legend.incache", "label.end.game.mode", "label.uploading"};
    }

    static TableColumnCore[] getBasicColumnItems(String table_id) {
        return new TableColumnCore[]{new PieceNumberItem(table_id), new SizeItem(table_id), new BlockCountItem(table_id), new BlocksItem(table_id), new CompletedItem(table_id), new AvailabilityItem(table_id), new TypeItem(table_id), new ReservedByItem(table_id), new WritersItem(table_id), new PriorityItem(table_id), new SpeedItem(table_id), new RequestedItem(table_id), new FilesItem(table_id)};
    }

    public static Color getLegendColor(String key) {
        return Legend.getLegendColor(key, legendKeys, BlocksItem.colors);
    }

    protected PiecesViewBase(String id) {
        super(id);
    }

    protected abstract String getTableID();

    @Override
    public Composite initComposite(Composite composite) {
        Composite parent = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        parent.setLayout((Layout)layout);
        Layout compositeLayout = composite.getLayout();
        if (compositeLayout instanceof GridLayout) {
            parent.setLayoutData((Object)new GridData(4, 4, true, true));
        } else if (compositeLayout instanceof FormLayout) {
            parent.setLayoutData((Object)Utils.getFilledFormData());
        }
        boolean hasFilter = this.getTableID() == "AllPieces";
        Composite header = new Composite(parent, 0);
        header.setLayout((Layout)new FormLayout());
        header.setLayoutData((Object)new GridData(768));
        final Button lp_enable = new Button(header, 32);
        FormData fd = Utils.getFilledFormData();
        fd.left = new FormAttachment(0, 10);
        fd.right = null;
        lp_enable.setLayoutData((Object)fd);
        Messages.setLanguageText((Widget)lp_enable, "label.show.uploading.pieces");
        lp_enable.addListener(13, ev -> COConfigurationManager.setParameter("Pieces View Show Uploading", lp_enable.getSelection()));
        COConfigurationManager.addAndFireParameterListener("Pieces View Show Uploading", new ParameterListener(){

            @Override
            public void parameterChanged(String n) {
                if (lp_enable.isDisposed()) {
                    COConfigurationManager.removeParameterListener(n, this);
                    return;
                }
                boolean enabled = COConfigurationManager.getBooleanParameter(n);
                lp_enable.setSelection(enabled);
                PiecesViewBase.this.setShowUploading(enabled);
            }
        });
        if (hasFilter) {
            this.bubbleTextBox = new BubbleTextBox(header, 2948);
            fd = Utils.getFilledFormData();
            fd.width = 150;
            fd.top = null;
            fd.right = new FormAttachment(100, -10);
            fd.left = null;
            this.bubbleTextBox.setMessageAndLayout("", fd);
            this.bubbleTextBox.setAllowRegex(true);
            if (this.tv != null) {
                this.tv.enableFilterCheck(this.bubbleTextBox, (TableViewFilterCheck<PEPiece>)this);
            }
        }
        Composite tableParent = new Composite(parent, 0);
        tableParent.setLayoutData((Object)new GridData(4, 4, true, true));
        layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tableParent.setLayout((Layout)layout);
        return tableParent;
    }

    protected TableViewSWT<PEPiece> initYourTableView(String table_id) {
        if (table_id == "Pieces") {
            this.tv = TableViewFactory.createTableViewSWT(PLUGIN_DS_TYPE, "Pieces", this.getTextPrefixID(), basicItems, basicItems[0].getName(), 0x10010004);
        } else {
            TableColumnCore[] items = PiecesViewBase.getBasicColumnItems("AllPieces");
            TableColumn[] basicItems = new TableColumnCore[items.length + 1];
            System.arraycopy(items, 0, basicItems, 0, items.length);
            basicItems[items.length] = new DownloadNameItem("AllPieces");
            TableColumnManager tcManager = TableColumnManager.getInstance();
            tcManager.setDefaultColumnNames("AllPieces", basicItems);
            this.tv = TableViewFactory.createTableViewSWT(PEPiece[].class, "AllPieces", this.getTextPrefixID(), (TableColumnCore[])basicItems, basicItems[0].getName(), 0x10010004);
        }
        if (this.bubbleTextBox != null) {
            this.tv.enableFilterCheck(this.bubbleTextBox, (TableViewFilterCheck<PEPiece>)this);
        }
        PiecesViewBase.registerPluginViews();
        this.tv.addMenuFillListener(this);
        this.tv.addLifeCycleListener(this);
        this.tv.addSelectionListener(this, false);
        return this.tv;
    }

    protected abstract List<PEPeerManager> getPeerManagers();

    private void setShowUploading(boolean enabled) {
        if (enabled == this.show_uploading) {
            return;
        }
        this.show_uploading = enabled;
        this.updateUploadingPieces(true);
    }

    private static void registerPluginViews() {
        ViewManagerSWT vm = ViewManagerSWT.getInstance();
        if (vm.areCoreViewsRegistered(PLUGIN_DS_TYPE)) {
            return;
        }
        vm.registerView(PLUGIN_DS_TYPE, new UISWTViewBuilderCore("PieceMapView", null, PieceMapView.class));
        vm.registerView(PLUGIN_DS_TYPE, new UISWTViewBuilderCore("MyPieceDistributionView", null, MyPieceDistributionView.class));
        vm.setCoreViewsRegistered(PLUGIN_DS_TYPE);
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        final List<Object> selected = this.tv.getSelectedDataSources();
        if (selected.size() == 0) {
            return;
        }
        List<PEPeerManager> pms = this.getPeerManagers();
        if (pms.isEmpty()) {
            return;
        }
        boolean has_undone = false;
        boolean has_unforced = false;
        boolean all_uploading = true;
        final IdentityHashSet<DownloadManager> download_managers = new IdentityHashSet<DownloadManager>();
        GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
        for (Object obj : selected) {
            DownloadManager dm;
            PEPiece piece = (PEPiece)obj;
            PEPeerManager pm = piece.getManager();
            if (pm != null && gm != null && (dm = gm.getDownloadManager(new HashWrapper(pm.getHash()))) != null) {
                download_managers.add(dm);
            }
            if (piece instanceof PEPieceUploading) continue;
            all_uploading = false;
            if (piece.getDMPiece().isDone()) continue;
            has_undone = true;
            if (!piece.getPiecePicker().isForcePiece(piece.getPieceNumber())) continue;
            has_unforced = true;
        }
        if (download_managers.size() > 0) {
            MenuItem itemDetails = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemDetails, "PeersView.menu.showdownload");
            Utils.setMenuItemImage(itemDetails, "details");
            itemDetails.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions != null) {
                        for (DownloadManager dm : download_managers) {
                            uiFunctions.getMDI().showEntryByID("DMDetails", dm);
                        }
                    }
                }
            });
            new MenuItem(menu, 2);
        }
        if (all_uploading) {
            if (selected.size() > 0) {
                PEPieceUploading piece = (PEPieceUploading)selected.get(0);
                CopyOnWriteSet<String> uploaders = piece.getUploadPeers();
                PEPeer peer = null;
                if (uploaders.size() == 1) {
                    String ip = uploaders.iterator().next();
                    List<PEPeer> peers = piece.getManager().getPeers(ip);
                    if (peers.size() == 1) {
                        peer = peers.get(0);
                    }
                }
                if (this.mdi != null && this.mdi.getEntry("PeersView") != null) {
                    MenuItem show_peer = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)show_peer, "menu.show.peer");
                    final PEPeer f_peer = peer;
                    show_peer.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            UISWTViewEventListener listener;
                            MdiEntrySWT entry;
                            if (PiecesViewBase.this.mdi != null && (entry = PiecesViewBase.this.mdi.getEntry("PeersView")) != null && (listener = entry.getEventListener()) instanceof PeersView) {
                                ((PeersView)listener).selectPeer(f_peer);
                                PiecesViewBase.this.mdi.showEntryByID("PeersView");
                            }
                        }
                    });
                    show_peer.setEnabled(peer != null);
                }
            }
        } else {
            final MenuItem force_piece = new MenuItem(menu, 32);
            Messages.setLanguageText((Widget)force_piece, "label.force.piece");
            force_piece.setEnabled(has_undone);
            if (has_undone) {
                force_piece.setSelection(has_unforced);
                force_piece.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean forced = force_piece.getSelection();
                        for (Object obj : selected) {
                            PEPiece piece = (PEPiece)obj;
                            if (piece.getDMPiece().isDone()) continue;
                            piece.getPiecePicker().setForcePiece(piece.getPieceNumber(), forced);
                        }
                    }
                });
            }
            MenuItem cancel_reqs_piece = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)cancel_reqs_piece, "label.rerequest.blocks");
            cancel_reqs_piece.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    for (Object obj : selected) {
                        PEPiece piece = (PEPiece)obj;
                        int i = 0;
                        while (i < piece.getNbBlocks()) {
                            if (piece.isRequested(i)) {
                                piece.clearRequested(i);
                            }
                            ++i;
                        }
                    }
                }
            });
            MenuItem reset_piece = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)reset_piece, "label.reset.piece");
            reset_piece.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    for (Object obj : selected) {
                        PEPiece piece = (PEPiece)obj;
                        piece.reset();
                    }
                }
            });
            new MenuItem(menu, 2);
        }
    }

    @Override
    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
    }

    @Override
    public void tableLifeCycleEventOccurred(TableView tv, int eventType, Map<String, Object> data) {
        switch (eventType) {
            case 0: {
                this.tableViewInitialized();
                break;
            }
            case 1: {
                this.tableViewDestroyed();
            }
        }
    }

    protected void tableViewInitialized() {
        if ((this.legendComposite == null || this.legendComposite.isDisposed()) && this.tv != null) {
            Composite composite = this.tv.getTableComposite();
            this.legendComposite = Legend.createLegendComposite(composite.getParent(), BlocksItem.colors, legendKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tableViewDestroyed() {
        if (this.legendComposite != null && this.legendComposite.isDisposed()) {
            this.legendComposite.dispose();
        }
        if (this.tv != null) {
            this.tv.removeAllTableRows();
        }
        Map<Long, PEPieceUploading> map = this.uploading_pieces;
        synchronized (map) {
            this.uploading_pieces.clear();
        }
    }

    @Override
    public void filterSet(String filter2) {
    }

    @Override
    public boolean filterCheck(PEPiece piece, String filter2, boolean regex, boolean confusable) {
        DiskManagerPiece dmp;
        if (confusable) {
            return false;
        }
        if (filter2.isEmpty()) {
            return true;
        }
        ArrayList<String> names = new ArrayList<String>();
        PEPeerManager manager = piece.getManager();
        if (manager != null) {
            names.add(manager.getDisplayName());
        }
        if ((dmp = piece.getDMPiece()) != null) {
            DMPieceList l = dmp.getManager().getPieceList(piece.getPieceNumber());
            int i = 0;
            while (i < l.size()) {
                DMPieceMapEntry entry = l.get(i);
                String name = entry.getFile().getTorrentFile().getRelativePath();
                names.add(name);
                ++i;
            }
        }
        String s = regex ? filter2 : RegExUtil.splitAndQuote(filter2, "\\s*[|;]\\s*");
        boolean match_result = true;
        if (regex && s.startsWith("!")) {
            s = s.substring(1);
            match_result = false;
        }
        Pattern pattern = RegExUtil.getCachedPattern("piecesview:search", s, 66);
        boolean result = !match_result;
        for (String name : names) {
            if (!pattern.matcher(name).find()) continue;
            result = match_result;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected boolean updateUploadingPieces(boolean process_queue) {
        List<PEPeerManager> pms = this.getPeerManagers();
        if (pms.isEmpty()) {
            return false;
        }
        boolean changed = false;
        boolean has_uploading_pieces = false;
        if (this.show_uploading) {
            long now = SystemTime.getMonotonousTime();
            HashMap<Long, Object[]> up_map = new HashMap<Long, Object[]>();
            for (PEPeerManager pm : pms) {
                long pm_id_mask = (long)pm.getUID() << 32;
                DiskManagerPiece[] dm_pieces = pm.getDiskManager().getPieces();
                for (PEPeer peer : pm.getPeers()) {
                    DiskManagerReadRequest[] pieces;
                    int raw_piece_number;
                    if (peer.isChokedByMe()) continue;
                    int[] peerRequestedPieces = peer.getIncomingRequestedPieceNumbers();
                    if (peerRequestedPieces != null && peerRequestedPieces.length > 0) {
                        int pieces_added = 0;
                        int i = 0;
                        while (i < peerRequestedPieces.length) {
                            HashSet<String> peers;
                            raw_piece_number = peerRequestedPieces[i];
                            long masked_piece_number = pm_id_mask | (long)raw_piece_number;
                            Object[] entry = (Object[])up_map.get(masked_piece_number);
                            if (entry == null) {
                                Object dm_piece = dm_pieces[raw_piece_number];
                                boolean[] blocks = new boolean[dm_piece.getNbBlocks()];
                                peers = new HashSet<String>();
                                up_map.put(masked_piece_number, new Object[]{blocks, peers, pm});
                                ++pieces_added;
                            } else {
                                peers = (HashSet<String>)entry[1];
                            }
                            peers.add(peer.getIp());
                            if (pieces_added >= 2) break;
                            ++i;
                        }
                    }
                    DiskManagerReadRequest[] diskManagerReadRequestArray = pieces = peer.getRecentPiecesSent();
                    int masked_piece_number = pieces.length;
                    raw_piece_number = 0;
                    while (raw_piece_number < masked_piece_number) {
                        DiskManagerReadRequest piece = diskManagerReadRequestArray[raw_piece_number];
                        long sent = piece.getTimeSent();
                        if (sent >= 0L && (sent <= 0L || now - sent <= 10000L)) {
                            HashSet<String> peers;
                            boolean[] blocks;
                            int raw_piece_number2 = piece.getPieceNumber();
                            long masked_piece_number2 = pm_id_mask | (long)raw_piece_number2;
                            Object[] entry = (Object[])up_map.get(masked_piece_number2);
                            if (entry == null) {
                                Object dm_piece = dm_pieces[raw_piece_number2];
                                blocks = new boolean[dm_piece.getNbBlocks()];
                                peers = new HashSet<String>();
                                up_map.put(masked_piece_number2, new Object[]{blocks, peers, pm});
                            } else {
                                blocks = (boolean[])entry[0];
                                peers = (HashSet<String>)entry[1];
                            }
                            blocks[piece.getOffset() / 16384] = true;
                            peers.add(peer.getIp());
                        }
                        ++raw_piece_number;
                    }
                }
            }
            ArrayList<PEPieceUploading> to_add = new ArrayList<PEPieceUploading>();
            HashSet<PEPieceUploading> to_remove = new HashSet<PEPieceUploading>();
            Map<Long, PEPieceUploading> map = this.uploading_pieces;
            synchronized (map) {
                to_remove.addAll(this.uploading_pieces.values());
                for (Map.Entry entry : up_map.entrySet()) {
                    long masked_piece_number = (Long)entry.getKey();
                    Object[] entry2 = (Object[])entry.getValue();
                    boolean[] blocks = (boolean[])entry2[0];
                    Set peers = (Set)entry2[1];
                    PEPieceUploading piece = this.uploading_pieces.get(masked_piece_number);
                    if (piece == null) {
                        PEPeerManager pm = (PEPeerManager)entry2[2];
                        int raw_piece_number = (int)(masked_piece_number & 0xFFFFFFFFFFFFFFFFL);
                        piece = new PEPieceUploading(pm, pm.getDiskManager().getPieces()[raw_piece_number], raw_piece_number);
                        to_add.add(piece);
                        this.uploading_pieces.put(masked_piece_number, piece);
                    } else {
                        to_remove.remove(piece);
                    }
                    piece.addUploading(blocks, peers);
                }
                if (!to_remove.isEmpty()) {
                    int n = this.uploading_pieces.size();
                    Iterator it = to_remove.iterator();
                    while (it.hasNext()) {
                        void var11_46;
                        PEPieceUploading piece = (PEPieceUploading)it.next();
                        if (piece.readyToRemove() || var11_46 > 50) {
                            int raw_piece_number = piece.getPieceNumber();
                            long masked_piece_number = (long)piece.getManager().getUID() << 32 | (long)raw_piece_number;
                            this.uploading_pieces.remove(masked_piece_number);
                            --var11_46;
                            continue;
                        }
                        it.remove();
                    }
                }
                has_uploading_pieces |= !this.uploading_pieces.isEmpty();
            }
            if (!to_add.isEmpty()) {
                this.tv.addDataSources((PEPiece[])to_add.toArray(new PEPiece[to_add.size()]));
                changed = true;
            }
            if (!to_remove.isEmpty()) {
                this.tv.removeDataSources((PEPiece[])to_remove.toArray(new PEPiece[to_remove.size()]));
                changed = true;
            }
        } else {
            HashSet<PEPieceUploading> to_remove = new HashSet<PEPieceUploading>();
            Map<Long, PEPieceUploading> map = this.uploading_pieces;
            synchronized (map) {
                to_remove.addAll(this.uploading_pieces.values());
                this.uploading_pieces.clear();
            }
            if (!to_remove.isEmpty()) {
                this.tv.removeDataSources((PEPiece[])to_remove.toArray(new PEPiece[to_remove.size()]));
                changed = true;
            }
        }
        if (process_queue && changed) {
            this.tv.processDataSourceQueue();
        }
        return has_uploading_pieces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUploadingPieceCount() {
        if (this.shown && this.show_uploading) {
            Map<Long, PEPieceUploading> map = this.uploading_pieces;
            synchronized (map) {
                return this.uploading_pieces.size();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearUploadingPieces() {
        Map<Long, PEPieceUploading> map = this.uploading_pieces;
        synchronized (map) {
            this.uploading_pieces.clear();
        }
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int keyMask, int origin) {
        MultipleDocumentInterfaceSWT mdi;
        TableViewSWT_TabsCommon tabsCommon = this.tv.getTabsCommon();
        if (tabsCommon != null && (mdi = tabsCommon.getMDI()) != null) {
            mdi.showEntryByID("PieceMapView");
            return;
        }
        if (rows.length != 1) {
            return;
        }
        if (this.mdi != null && this.mdi.getEntry("PieceMapView") != null) {
            this.mdi.showEntryByID("PieceMapView", rows[0].getDataSource());
        } else {
            UIFunctions uif = UIFunctionsManager.getUIFunctions();
            if (uif != null) {
                DownloadManager dm;
                GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
                PEPeerManager pm = ((PEPiece)rows[0].getDataSource()).getManager();
                DownloadManager downloadManager = dm = pm == null ? null : gm.getDownloadManager(new HashWrapper(pm.getHash()));
                if (dm != null) {
                    uif.getMDI().showEntryByID("DMDetails", dm);
                }
            }
        }
    }

    protected abstract void updateSelectedContent();

    @Override
    public void deselected(TableRowCore[] rows) {
        this.updateSelectedContent();
    }

    @Override
    public void focusChanged(TableRowCore focus) {
    }

    @Override
    public void selected(TableRowCore[] rows) {
        this.updateSelectedContent();
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        int type = event2.getType();
        if (type == 0) {
            event2.getView().setDestroyOnDeactivate(true);
        } else if (type == 5) {
            this.updateUploadingPieces(true);
        } else if (type == 3) {
            this.shown = true;
        } else if (type == 4) {
            this.shown = false;
        }
        return super.eventOccurred(event2);
    }

    @Override
    public void titleInfoLinked(MultipleDocumentInterface mdi, MdiEntry mdiEntry) {
        if (mdi instanceof MultipleDocumentInterfaceSWT) {
            this.mdi = (MultipleDocumentInterfaceSWT)mdi;
        }
    }

    @Override
    public Object getTitleInfoProperty(int propertyID) {
        return null;
    }

    public class PEPieceUploading
    implements PEPiece {
        private final PEPeerManager pm;
        private final DiskManagerPiece dm_piece;
        private final int piece_number;
        private final boolean[] blocks;
        private final CopyOnWriteSet<String> peers = new CopyOnWriteSet(false);
        private boolean complete;
        private volatile long last_active = SystemTime.getMonotonousTime();

        private PEPieceUploading(PEPeerManager _pm, DiskManagerPiece _dm_piece, int _piece_number) {
            this.pm = _pm;
            this.dm_piece = _dm_piece;
            this.piece_number = _piece_number;
            this.blocks = new boolean[this.dm_piece.getNbBlocks()];
        }

        @Override
        public PiecePicker getPiecePicker() {
            return this.pm.getPiecePicker();
        }

        @Override
        public PEPeerManager getManager() {
            return this.pm;
        }

        @Override
        public DiskManagerPiece getDMPiece() {
            return this.dm_piece;
        }

        @Override
        public int getPieceNumber() {
            return this.piece_number;
        }

        @Override
        public int getLength() {
            return this.dm_piece.getLength();
        }

        @Override
        public int getNbBlocks() {
            return this.dm_piece.getNbBlocks();
        }

        @Override
        public int getBlockNumber(int offset) {
            return offset / 16384;
        }

        @Override
        public int getBlockSize(int block_index) {
            return this.dm_piece.getBlockSize(block_index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addUploading(boolean[] b, Set<String> latest_peers) {
            this.last_active = SystemTime.getMonotonousTime();
            PEPieceUploading pEPieceUploading = this;
            synchronized (pEPieceUploading) {
                boolean done = true;
                int i = 0;
                while (i < b.length) {
                    if (b[i]) {
                        this.blocks[i] = true;
                    } else if (!this.blocks[i]) {
                        done = false;
                    }
                    ++i;
                }
                this.complete = done;
                this.peers.addAll(latest_peers);
            }
        }

        private boolean readyToRemove() {
            return SystemTime.getMonotonousTime() - this.last_active > 5000L;
        }

        public CopyOnWriteSet<String> getUploadPeers() {
            return this.peers;
        }

        @Override
        public long getCreationTime() {
            return 0L;
        }

        @Override
        public long getTimeSinceLastActivity() {
            return 0L;
        }

        @Override
        public long getLastDownloadTime(long now) {
            return 0L;
        }

        @Override
        public void addWrite(int blockNumber, String sender, byte[] hash, boolean correct) {
        }

        @Override
        public int getNbWritten() {
            return 0;
        }

        @Override
        public int getAvailability() {
            return this.pm.getAvailability(this.piece_number);
        }

        @Override
        public boolean hasUnrequestedBlock() {
            return false;
        }

        @Override
        public int[] getAndMarkBlocks(PEPeer peer, int nbWanted, int[] request_hint, boolean reverse_order) {
            return null;
        }

        @Override
        public void getAndMarkBlock(PEPeer peer, int index) {
        }

        @Override
        public Object getRealTimeData() {
            return null;
        }

        @Override
        public void setRealTimeData(Object o) {
        }

        @Override
        public boolean setRequested(PEPeer peer, int blockNumber) {
            return false;
        }

        @Override
        public void clearRequested(int blocNumber) {
        }

        @Override
        public boolean isRequested(int blockNumber) {
            return false;
        }

        @Override
        public boolean isRequested() {
            return false;
        }

        @Override
        public void setRequested() {
        }

        @Override
        public boolean isRequestable() {
            return false;
        }

        @Override
        public int getNbRequests() {
            return 0;
        }

        @Override
        public int getNbUnrequested() {
            return 0;
        }

        @Override
        public boolean isDownloaded(int blockNumber) {
            return this.blocks[blockNumber];
        }

        @Override
        public void setDownloaded(int offset) {
        }

        @Override
        public void clearDownloaded(int offset) {
        }

        @Override
        public boolean isDownloaded() {
            return this.complete;
        }

        @Override
        public boolean[] getDownloaded() {
            return this.blocks;
        }

        @Override
        public boolean hasUndownloadedBlock() {
            return false;
        }

        @Override
        public String getReservedBy() {
            return "";
        }

        @Override
        public void setReservedBy(String peer) {
        }

        @Override
        public int getResumePriority() {
            return 0;
        }

        @Override
        public void setResumePriority(int p) {
        }

        @Override
        public String[] getWriters() {
            return null;
        }

        @Override
        public void setWritten(String peer, int blockNumber) {
        }

        @Override
        public boolean isWritten() {
            return false;
        }

        @Override
        public boolean isWritten(int blockNumber) {
            return true;
        }

        @Override
        public int getSpeed() {
            return 0;
        }

        @Override
        public void setSpeed(int speed) {
        }

        @Override
        public void setLastRequestedPeerSpeed(int speed) {
        }

        @Override
        public void reset() {
        }

        @Override
        public String getString() {
            return "";
        }
    }
}

