/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagDownload;
import com.biglybt.core.tag.TagException;
import com.biglybt.core.tag.TagFeatureFileLocation;
import com.biglybt.core.tag.TagFeatureLimits;
import com.biglybt.core.tag.TagFeatureNotifications;
import com.biglybt.core.tag.TagFeatureProperties;
import com.biglybt.core.tag.TagFeatureRateLimit;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.TagTypeListener;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BooleanSwtParameter;
import com.biglybt.ui.swt.config.ColorSwtParameter;
import com.biglybt.ui.swt.config.FloatSwtParameter;
import com.biglybt.ui.swt.config.IconSwtParameter;
import com.biglybt.ui.swt.config.IntSwtParameter;
import com.biglybt.ui.swt.config.StringListSwtParameter;
import com.biglybt.ui.swt.config.SwtParameterValueProcessor;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.utils.FontUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TagSettingsView
implements UISWTViewCoreEventListener,
TagTypeListener {
    public static final String VIEW_ID = "TagSettingsView";
    private static final String CM_ADD_REMOVE = "am=0;";
    private static final String CM_ADD_ONLY = "am=1;";
    private static final String CM_REMOVE_ONLY = "am=2;";
    private static final String CM_NEW_DLS = "am=3;";
    private UISWTView swtView;
    private Composite parent;
    private Composite cMainComposite;
    private Tag[] tags;
    private Params params = null;
    private Button btnSaveConstraint;
    private Button btnResetConstraint;

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.parent = (Composite)event2.getData();
                this.buildUI();
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.cMainComposite);
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                Object ds = event2.getData();
                this.dataSourceChanged(ds);
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    private void delete() {
        this.dataSourceChanged(null);
        this.params = null;
    }

    private void refresh() {
    }

    private void dataSourceChanged(Object ds) {
        TagType tagType;
        Tag tag;
        int n;
        int n2;
        Tag[] tagArray;
        if (this.tags != null) {
            tagArray = this.tags;
            n2 = this.tags.length;
            n = 0;
            while (n < n2) {
                tag = tagArray[n];
                tagType = tag.getTagType();
                tagType.removeTagTypeListener(this);
                ++n;
            }
        }
        if (ds instanceof Tag) {
            this.tags = new Tag[]{(Tag)ds};
        } else if (ds instanceof Object[]) {
            Object[] objects = (Object[])ds;
            if (objects[0] instanceof Tag) {
                this.tags = new Tag[objects.length];
                System.arraycopy(objects, 0, this.tags, 0, this.tags.length);
            } else {
                this.tags = null;
            }
        } else {
            this.tags = null;
        }
        if (this.tags != null) {
            tagArray = this.tags;
            n2 = this.tags.length;
            n = 0;
            while (n < n2) {
                tag = tagArray[n];
                tagType = tag.getTagType();
                tagType.removeTagTypeListener(this);
                tagType.addTagTypeListener(this, false);
                ++n;
            }
        }
        this.buildUI();
    }

    private void addPadding(Composite comp2) {
        Composite cPad = new Composite(this.cMainComposite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        cPad.setLayout((Layout)gridLayout);
        cPad.setLayoutData((Object)new GridData(768));
    }

    private void buildUI() {
        if (Utils.runIfNotSWTThread(this::buildUI)) {
            return;
        }
        if (this.parent == null || this.parent.isDisposed()) {
            return;
        }
        Utils.disposeComposite(this.parent, false);
        this.cMainComposite = Utils.createScrolledComposite(this.parent, 768);
        if (this.tags == null) {
            this.params = null;
            this.cMainComposite.setLayout((Layout)new FillLayout());
            Label label = new Label(this.cMainComposite, 0);
            label.setText(MessageText.getString("tag.settings.select.tag"));
        } else {
            TagFeatureLimits tfl;
            TagFeatureFileLocation fl;
            final int numTags = this.tags.length;
            int isTagVisible = -1;
            int canBePublic = -1;
            int[] tagColor = this.tags[0].getColor();
            String tagIconFile = this.tags[0].getImageFile();
            boolean tagsAreTagFeatureRateLimit = true;
            HashSet<String> listTagTypes = new HashSet<String>();
            Tag[] tagArray = this.tags;
            int n = this.tags.length;
            int n2 = 0;
            while (n2 < n) {
                String next;
                int[] color;
                Tag tag = tagArray[n2];
                TagType tt = tag.getTagType();
                String s = tt.getTagTypeName(true);
                listTagTypes.add(s);
                if (tagsAreTagFeatureRateLimit && !(tag instanceof TagFeatureRateLimit)) {
                    tagsAreTagFeatureRateLimit = false;
                }
                isTagVisible = this.updateIntBoolean(tag.isVisible(), isTagVisible);
                canBePublic = this.updateIntBoolean(tag.canBePublic(), canBePublic);
                if (tagColor != null && !Arrays.equals(tagColor, color = tag.getColor())) {
                    tagColor = null;
                }
                if (!(tagIconFile == null || (next = tag.getImageFile()) != null && next.equals(tagIconFile))) {
                    tagIconFile = null;
                }
                ++n2;
            }
            String tagTypes = GeneralUtils.stringJoin(listTagTypes, ", ");
            this.params = new Params();
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            this.cMainComposite.setLayout((Layout)gridLayout);
            Composite cSection1 = new Composite(this.cMainComposite, 0);
            gridLayout = new GridLayout(6, false);
            gridLayout.marginHeight = 0;
            cSection1.setLayout((Layout)gridLayout);
            GridData gd = new GridData(4, 4, false, false);
            cSection1.setLayoutData((Object)gd);
            this.addPadding(this.cMainComposite);
            Composite cSection2 = new Composite(this.cMainComposite, 0);
            gridLayout = new GridLayout(4, false);
            cSection2.setLayout((Layout)gridLayout);
            gd = new GridData(4, 4, false, false);
            cSection2.setLayoutData((Object)gd);
            this.addPadding(this.cMainComposite);
            Label label = new Label(cSection1, 0);
            FontUtils.setFontHeight((Control)label, 12, 1);
            gd = new GridData();
            gd.horizontalSpan = 6;
            label.setLayoutData((Object)gd);
            label.setText(tagTypes);
            label = new Label(cSection1, 0);
            Messages.setLanguageText((Widget)label, "MinimizedWindow.name");
            gd = new GridData(1, 0x1000000, false, false);
            label.setLayoutData((Object)gd);
            if (numTags == 1 && !this.tags[0].getTagType().isTagTypeAuto()) {
                Text txtName = new Text(cSection1, 2048);
                this.params.cName = (Control)txtName;
                gd = new GridData(4, 0x1000000, true, false);
                gd.widthHint = 200;
                txtName.setLayoutData((Object)gd);
                txtName.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        try {
                            String newName = ((Text)e.widget).getText();
                            if (!TagSettingsView.this.tags[0].getTagName(true).equals(newName)) {
                                TagSettingsView.this.tags[0].setTagName(newName);
                            }
                        }
                        catch (TagException e1) {
                            Debug.out(e1);
                        }
                    }
                });
            } else {
                label = new Label(cSection1, 64);
                gd = Utils.getWrappableLabelGridData(1, 512);
                gd.widthHint = 200;
                label.setLayoutData((Object)gd);
                this.params.cName = (Control)label;
            }
            if (tagColor == null) {
                tagColor = new int[3];
            }
            int[] origTagColor = tagColor == null ? new int[3] : tagColor;
            final int[] defaultColor = this.tags[0].getTagType().getColorDefault();
            this.params.tagColor = new ColorSwtParameter(cSection1, "tagColor", "label.color", null, false, new SwtParameterValueProcessor<ColorSwtParameter, int[]>(origTagColor){
                int[] curColor;
                {
                    this.curColor = nArray;
                }

                @Override
                public int[] getValue(ColorSwtParameter p) {
                    return this.curColor;
                }

                @Override
                public boolean setValue(ColorSwtParameter p, int[] value) {
                    this.curColor = value;
                    if (Arrays.equals(value, defaultColor)) {
                        value = null;
                    }
                    Tag[] tagArray = TagSettingsView.this.tags;
                    int n = tagArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Tag tag = tagArray[n2];
                        tag.setColor(value);
                        ++n2;
                    }
                    return true;
                }

                @Override
                public boolean isDefaultValue(ColorSwtParameter p) {
                    return Arrays.equals(this.getValue(p), defaultColor);
                }

                @Override
                public boolean resetToDefault(ColorSwtParameter p) {
                    this.setValue(p, defaultColor);
                    return true;
                }
            });
            String finalTagIconFile = tagIconFile;
            this.params.tagIcon = new IconSwtParameter(cSection1, "tagIcon", "TableColumn.header.Thumbnail", new SwtParameterValueProcessor<IconSwtParameter, String>(finalTagIconFile){
                String curIconFile;
                {
                    this.curIconFile = string;
                }

                @Override
                public String getValue(IconSwtParameter p) {
                    return this.curIconFile;
                }

                @Override
                public boolean setValue(IconSwtParameter p, String value) {
                    this.curIconFile = value;
                    Tag[] tagArray = TagSettingsView.this.tags;
                    int n = tagArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Tag tag = tagArray[n2];
                        tag.setImageFile(value);
                        ++n2;
                    }
                    return true;
                }

                @Override
                public boolean isDefaultValue(IconSwtParameter p) {
                    return this.curIconFile == null;
                }

                @Override
                public boolean resetToDefault(IconSwtParameter p) {
                    this.setValue(p, null);
                    return true;
                }
            });
            boolean allManual = true;
            boolean hasCat = false;
            boolean hasSwarm = false;
            Tag[] tagArray2 = this.tags;
            int n3 = this.tags.length;
            int n4 = 0;
            while (n4 < n3) {
                Tag t = tagArray2[n4];
                int type = t.getTagType().getTagType();
                if (type != 3) {
                    allManual = false;
                }
                if (type == 1) {
                    hasCat = true;
                }
                if (type == 7) {
                    hasSwarm = true;
                }
                ++n4;
            }
            boolean hasVisibility = !hasCat;
            int cSection2Line1 = 0;
            if (hasVisibility && !hasSwarm) {
                this.params.viewInSideBar = new BooleanSwtParameter(cSection2, "viewInSidebar", "TagSettings.viewInSideBar", null, new BooleanSwtParameter.ValueProcessor(){

                    @Override
                    public Boolean getValue(BooleanSwtParameter p) {
                        int isTagVisible = -1;
                        Tag[] tagArray = TagSettingsView.this.tags;
                        int n = tagArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Tag tag = tagArray[n2];
                            isTagVisible = TagSettingsView.this.updateIntBoolean(tag.isVisible(), isTagVisible);
                            ++n2;
                        }
                        return isTagVisible == 2 ? null : Boolean.valueOf(isTagVisible == 1);
                    }

                    @Override
                    public boolean setValue(BooleanSwtParameter p, Boolean value) {
                        boolean changed = TagSettingsView.this.tags.length == 0;
                        Tag[] tagArray = TagSettingsView.this.tags;
                        int n = tagArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Tag tag = tagArray[n2];
                            if (!tag.isVisible() == value) {
                                tag.setVisible(value);
                                changed = true;
                            }
                            ++n2;
                        }
                        return changed;
                    }
                });
                gd = new GridData();
                gd.horizontalSpan = 1;
                cSection2Line1 += gd.horizontalSpan;
                this.params.viewInSideBar.setLayoutData(gd);
                this.params.hideWhenEmpty = new BooleanSwtParameter(cSection2, "hideWhenEmpty", "TagSettings.hideWhenEmpty", null, new BooleanSwtParameter.ValueProcessor(){

                    @Override
                    public Boolean getValue(BooleanSwtParameter p) {
                        int isHideWhenEMpty = -1;
                        Tag[] tagArray = TagSettingsView.this.tags;
                        int n = tagArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Tag tag = tagArray[n2];
                            isHideWhenEMpty = TagSettingsView.this.updateIntBoolean(tag.isHiddenWhenEmpty(), isHideWhenEMpty);
                            ++n2;
                        }
                        return isHideWhenEMpty == 2 ? null : Boolean.valueOf(isHideWhenEMpty == 1);
                    }

                    @Override
                    public boolean setValue(BooleanSwtParameter p, Boolean value) {
                        boolean changed = TagSettingsView.this.tags.length == 0;
                        Tag[] tagArray = TagSettingsView.this.tags;
                        int n = tagArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Tag tag = tagArray[n2];
                            if (!tag.isHiddenWhenEmpty() == value) {
                                tag.setHiddenWhenEmpty(value);
                                changed = true;
                            }
                            ++n2;
                        }
                        return changed;
                    }
                });
                gd = new GridData();
                gd.horizontalSpan = allManual ? 1 : 3;
                cSection2Line1 += gd.horizontalSpan;
                this.params.hideWhenEmpty.setLayoutData(gd);
            }
            if (allManual) {
                this.params.isFilter = new BooleanSwtParameter(cSection2, "isFilter", "TagSettings.isFilter", null, new BooleanSwtParameter.ValueProcessor(){

                    @Override
                    public Boolean getValue(BooleanSwtParameter p) {
                        int isFilter = -1;
                        Tag[] tagArray = TagSettingsView.this.tags;
                        int n = tagArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Tag tag = tagArray[n2];
                            isFilter = TagSettingsView.this.updateIntBoolean(tag.getFlag(1L), isFilter);
                            ++n2;
                        }
                        return isFilter == 2 ? null : Boolean.valueOf(isFilter == 1);
                    }

                    @Override
                    public boolean setValue(BooleanSwtParameter p, Boolean value) {
                        boolean changed = TagSettingsView.this.tags.length == 0;
                        Tag[] tagArray = TagSettingsView.this.tags;
                        int n = tagArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Tag tag = tagArray[n2];
                            if (!tag.getFlag(1L) == value) {
                                tag.setFlag(1L, value);
                                if (value.booleanValue() && !COConfigurationManager.getBooleanParameter("Library.ShowTagButtons.FiltersOnly")) {
                                    COConfigurationManager.setParameter("Library.ShowTagButtons", true);
                                    COConfigurationManager.setParameter("Library.ShowTagButtons.FiltersOnly", true);
                                    MessageBoxShell mb = new MessageBoxShell(34, MessageText.getString("tag.settings.filter.enabled.title"), MessageText.getString("tag.settings.filter.enabled.msg"));
                                    mb.setParent(TagSettingsView.this.parent.getShell());
                                    mb.open(null);
                                }
                                changed = true;
                            }
                            ++n2;
                        }
                        return changed;
                    }
                });
                gd = new GridData();
                gd.horizontalSpan = 4 - cSection2Line1;
                this.params.isFilter.setLayoutData(gd);
            }
            if (canBePublic == 1) {
                this.params.isPublic = new BooleanSwtParameter(cSection2, "tag.isPublic", "TagAddWindow.public.checkbox", null, new BooleanSwtParameter.ValueProcessor(){

                    @Override
                    public Boolean getValue(BooleanSwtParameter p) {
                        int val = -1;
                        Tag[] tagArray = TagSettingsView.this.tags;
                        int n = tagArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Tag tag = tagArray[n2];
                            val = TagSettingsView.this.updateIntBoolean(tag.isPublic(), val);
                            ++n2;
                        }
                        return val == 2 ? null : Boolean.valueOf(val == 1);
                    }

                    @Override
                    public boolean setValue(BooleanSwtParameter p, Boolean value) {
                        boolean changed = TagSettingsView.this.tags.length == 0;
                        Tag[] tagArray = TagSettingsView.this.tags;
                        int n = tagArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Tag tag = tagArray[n2];
                            if (tag.isPublic() != value.booleanValue()) {
                                tag.setPublic(value);
                                changed = true;
                            }
                            ++n2;
                        }
                        return changed;
                    }
                });
                gd = new GridData();
                gd.horizontalSpan = 4;
                this.params.isPublic.setLayoutData(gd);
            }
            if (tagsAreTagFeatureRateLimit) {
                Group gTransfer = Utils.createSkinnedGroup(this.cMainComposite, 0);
                gTransfer.setText(MessageText.getString("label.transfer.settings"));
                int gTransferCols = 8;
                gridLayout = new GridLayout(8, false);
                gTransfer.setLayout((Layout)gridLayout);
                gd = new GridData(4, 0, false, false, 1, 1);
                gTransfer.setLayoutData((Object)gd);
                this.addPadding(this.cMainComposite);
                final TagFeatureRateLimit[] rls = new TagFeatureRateLimit[this.tags.length];
                System.arraycopy(this.tags, 0, rls, 0, this.tags.length);
                boolean supportsTagDownloadLimit = true;
                boolean supportsTagUploadLimit = true;
                boolean hasTagUploadPriority = true;
                boolean supportsFPSeeding = true;
                boolean supportsMaxDLS = true;
                boolean supportsMaxCDS = true;
                boolean supportsBoost = true;
                TagFeatureRateLimit[] tagFeatureRateLimitArray = rls;
                int n5 = rls.length;
                int n6 = 0;
                while (n6 < n5) {
                    TagFeatureRateLimit rl = tagFeatureRateLimitArray[n6];
                    supportsTagDownloadLimit &= rl.supportsTagDownloadLimit();
                    supportsTagUploadLimit &= rl.supportsTagUploadLimit();
                    hasTagUploadPriority &= rl.getTagUploadPriority() >= 0;
                    int tt = rl.getTag().getTagType().getTagType();
                    if (tt != 3) {
                        supportsFPSeeding = false;
                        supportsMaxDLS = false;
                        supportsMaxCDS = false;
                    }
                    if (tt != 4) {
                        supportsBoost = false;
                    }
                    ++n6;
                }
                String k_unit = DisplayFormatters.getRateUnitBase10(1).trim();
                int cols_used = 0;
                if (supportsTagDownloadLimit) {
                    this.params.maxDownloadSpeed = new IntSwtParameter((Composite)gTransfer, "tag.maxDownloadSpeed", "", null, -1, Integer.MAX_VALUE, new IntSwtParameter.ValueProcessor(){

                        @Override
                        public Integer getValue(IntSwtParameter p) {
                            ArrayList<Integer> values = new ArrayList<Integer>();
                            int i = 0;
                            while (i < rls.length) {
                                int limit = rls[i].getTagDownloadLimit();
                                values.add(limit < 0 ? limit : limit / DisplayFormatters.getKinB());
                                ++i;
                            }
                            return this.getValue((List<Integer>)values);
                        }

                        @Override
                        public boolean setValue(IntSwtParameter p, Integer value) {
                            if (value == null) {
                                return false;
                            }
                            TagFeatureRateLimit[] tagFeatureRateLimitArray = rls;
                            int n = rls.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TagFeatureRateLimit rl = tagFeatureRateLimitArray[n2];
                                if (value == -1) {
                                    rl.setTagDownloadLimit(-1);
                                } else {
                                    rl.setTagDownloadLimit(value * DisplayFormatters.getKinB());
                                }
                                ++n2;
                            }
                            return true;
                        }

                        @Override
                        public boolean resetToDefault(IntSwtParameter p) {
                            return false;
                        }
                    });
                    this.params.maxDownloadSpeed.setLabelText(String.valueOf(k_unit) + " " + MessageText.getString("GeneralView.label.maxdownloadspeed.tooltip"));
                    cols_used += 2;
                }
                if (supportsTagUploadLimit) {
                    this.params.maxUploadSpeed = new IntSwtParameter((Composite)gTransfer, "tag.maxUploadSpeed", "", null, -1, Integer.MAX_VALUE, new IntSwtParameter.ValueProcessor(){

                        @Override
                        public Integer getValue(IntSwtParameter p) {
                            ArrayList<Integer> values = new ArrayList<Integer>();
                            int i = 0;
                            while (i < rls.length) {
                                int limit = rls[i].getTagUploadLimit();
                                values.add(limit < 0 ? limit : limit / DisplayFormatters.getKinB());
                                ++i;
                            }
                            return this.getValue((List<Integer>)values);
                        }

                        @Override
                        public boolean setValue(IntSwtParameter p, Integer value) {
                            TagFeatureRateLimit[] tagFeatureRateLimitArray = rls;
                            int n = rls.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TagFeatureRateLimit rl = tagFeatureRateLimitArray[n2];
                                if (value == -1) {
                                    rl.setTagUploadLimit(value);
                                } else {
                                    rl.setTagUploadLimit(value * DisplayFormatters.getKinB());
                                }
                                ++n2;
                            }
                            return true;
                        }

                        @Override
                        public boolean resetToDefault(IntSwtParameter p) {
                            return false;
                        }
                    });
                    this.params.maxUploadSpeed.setLabelText(String.valueOf(k_unit) + " " + MessageText.getString("GeneralView.label.maxuploadspeed.tooltip"));
                    cols_used += 2;
                }
                if (hasTagUploadPriority) {
                    this.params.uploadPriority = new BooleanSwtParameter((Composite)gTransfer, "tag.uploadPriority", "cat.upload.priority", null, new BooleanSwtParameter.ValueProcessor(){

                        @Override
                        public Boolean getValue(BooleanSwtParameter p) {
                            int value = -1;
                            TagFeatureRateLimit[] tagFeatureRateLimitArray = rls;
                            int n = rls.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TagFeatureRateLimit rl = tagFeatureRateLimitArray[n2];
                                value = TagSettingsView.this.updateIntBoolean(rl.getTagUploadPriority() > 0, value);
                                ++n2;
                            }
                            return value == 2 ? null : Boolean.valueOf(value == 1);
                        }

                        @Override
                        public boolean setValue(BooleanSwtParameter p, Boolean value) {
                            boolean changed = rls.length == 0;
                            int priority = value != false ? 1 : 0;
                            TagFeatureRateLimit[] tagFeatureRateLimitArray = rls;
                            int n = rls.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TagFeatureRateLimit rl = tagFeatureRateLimitArray[n2];
                                if (rl.getTagUploadPriority() != priority) {
                                    rl.setTagUploadPriority(priority);
                                    changed = true;
                                }
                                ++n2;
                            }
                            return changed;
                        }
                    });
                    cols_used += 2;
                }
                if (supportsBoost) {
                    this.params.boost = new BooleanSwtParameter((Composite)gTransfer, "tag.boost", "PeersView.menu.boost", null, new BooleanSwtParameter.ValueProcessor(){

                        @Override
                        public Boolean getValue(BooleanSwtParameter p) {
                            int value = -1;
                            TagFeatureRateLimit[] tagFeatureRateLimitArray = rls;
                            int n = rls.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TagFeatureRateLimit rl = tagFeatureRateLimitArray[n2];
                                value = TagSettingsView.this.updateIntBoolean(rl.getTagBoost(), value);
                                ++n2;
                            }
                            return value == 2 ? null : Boolean.valueOf(value == 1);
                        }

                        @Override
                        public boolean setValue(BooleanSwtParameter p, Boolean value) {
                            boolean changed = rls.length == 0;
                            boolean boost = value;
                            TagFeatureRateLimit[] tagFeatureRateLimitArray = rls;
                            int n = rls.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TagFeatureRateLimit rl = tagFeatureRateLimitArray[n2];
                                if (rl.getTagBoost() != boost) {
                                    rl.setTagBoost(boost);
                                    changed = true;
                                }
                                ++n2;
                            }
                            return changed;
                        }
                    });
                    cols_used += 2;
                }
                if (cols_used > 0 && cols_used < 8) {
                    Label lab = new Label((Composite)gTransfer, 0);
                    gd = new GridData();
                    gd.horizontalSpan = 8 - cols_used;
                    lab.setLayoutData((Object)gd);
                }
                cols_used = 0;
                final ArrayList<TagFeatureRateLimit> rlMinSR = new ArrayList<TagFeatureRateLimit>();
                final ArrayList<TagFeatureRateLimit> rlMaxSR = new ArrayList<TagFeatureRateLimit>();
                TagFeatureRateLimit[] tagFeatureRateLimitArray2 = rls;
                int n7 = rls.length;
                int n8 = 0;
                while (n8 < n7) {
                    TagFeatureRateLimit rl = tagFeatureRateLimitArray2[n8];
                    if (rl.getTagMinShareRatio() >= 0) {
                        rlMinSR.add(rl);
                    }
                    if (rl.getTagMaxShareRatio() >= 0) {
                        rlMaxSR.add(rl);
                    }
                    ++n8;
                }
                if (!rlMinSR.isEmpty()) {
                    this.params.min_sr = new FloatSwtParameter((Composite)gTransfer, "tag.min_sr", "TableColumn.header.min_sr", null, 0.0f, Float.MAX_VALUE, true, 3, new FloatSwtParameter.ValueProcessor(){

                        @Override
                        public Float getValue(FloatSwtParameter p) {
                            ArrayList<Float> values = new ArrayList<Float>();
                            for (TagFeatureRateLimit rl : rlMinSR) {
                                values.add(Float.valueOf((float)rl.getTagMinShareRatio() / 1000.0f));
                            }
                            return this.getValue((List<Float>)values);
                        }

                        @Override
                        public boolean setValue(FloatSwtParameter p, Float value) {
                            int newValue = (int)(value.floatValue() * 1000.0f);
                            boolean changed = false;
                            for (TagFeatureRateLimit rl : rlMinSR) {
                                if (rl.getTagMinShareRatio() == newValue) continue;
                                rl.setTagMinShareRatio(newValue);
                                changed = true;
                            }
                            return changed;
                        }
                    });
                    cols_used += 2;
                }
                if (!rlMaxSR.isEmpty()) {
                    this.params.max_sr = new FloatSwtParameter((Composite)gTransfer, "tag.max_sr", "TableColumn.header.max_sr", null, 0.0f, Float.MAX_VALUE, true, 3, new FloatSwtParameter.ValueProcessor(){

                        @Override
                        public Float getValue(FloatSwtParameter p) {
                            ArrayList<Float> values = new ArrayList<Float>();
                            for (TagFeatureRateLimit rl : rlMaxSR) {
                                values.add(Float.valueOf((float)rl.getTagMaxShareRatio() / 1000.0f));
                            }
                            return this.getValue((List<Float>)values);
                        }

                        @Override
                        public boolean setValue(FloatSwtParameter p, Float value) {
                            int newValue = (int)(value.floatValue() * 1000.0f);
                            boolean changed = false;
                            for (TagFeatureRateLimit rl : rlMaxSR) {
                                if (rl.getTagMaxShareRatio() == newValue) continue;
                                rl.setTagMaxShareRatio(newValue);
                                changed = true;
                            }
                            if (changed) {
                                TagSettingsView.this.updateTagSRParams(TagSettingsView.this.params);
                            }
                            return changed;
                        }
                    });
                    cols_used += 2;
                    String[] ST_ACTION_VALUES = new String[]{"0", "1", "2", "3", "4", "5"};
                    String[] ST_ACTION_LABELS = new String[]{MessageText.getString("ConfigView.section.queue"), MessageText.getString("v3.MainWindow.button.pause"), MessageText.getString("v3.MainWindow.button.stop"), MessageText.getString("MyTorrentsView.menu.archive"), MessageText.getString("Button.deleteContent.fromLibrary"), MessageText.getString("Button.deleteContent.fromComputer")};
                    this.params.max_sr_action = new StringListSwtParameter((Composite)gTransfer, "max_sr_action", "label.when.exceeded", null, ST_ACTION_VALUES, ST_ACTION_LABELS, true, new StringListSwtParameter.ValueProcessor(){

                        @Override
                        public String getValue(StringListSwtParameter p) {
                            ArrayList<String> values = new ArrayList<String>();
                            for (TagFeatureRateLimit rl : rlMaxSR) {
                                values.add("" + rl.getTagMaxShareRatioAction());
                            }
                            return this.getValue((List<String>)values);
                        }

                        @Override
                        public boolean setValue(StringListSwtParameter p, String value) {
                            int val = Integer.parseInt(value);
                            boolean changed = false;
                            for (TagFeatureRateLimit rl : rlMaxSR) {
                                if (rl.getTagMaxShareRatioAction() == val) continue;
                                rl.setTagMaxShareRatioAction(val);
                                changed = true;
                            }
                            return changed;
                        }
                    });
                    cols_used += 2;
                }
                if (cols_used > 0 && cols_used < 8) {
                    Label lab = new Label((Composite)gTransfer, 0);
                    gd = new GridData();
                    gd.horizontalSpan = 8 - cols_used;
                    lab.setLayoutData((Object)gd);
                }
                cols_used = 0;
                if (numTags == 1 && rls[0].getTagAggregateShareRatio() >= 0) {
                    this.params.max_aggregate_sr = new FloatSwtParameter((Composite)gTransfer, "tag.max_aggregate_sr", "TableColumn.header.max_aggregate_sr", null, 0.0f, Float.MAX_VALUE, true, 3, new FloatSwtParameter.ValueProcessor(){

                        @Override
                        public Float getValue(FloatSwtParameter p) {
                            return Float.valueOf((float)rls[0].getTagMaxAggregateShareRatio() / 1000.0f);
                        }

                        @Override
                        public boolean setValue(FloatSwtParameter p, Float value) {
                            int newValue = (int)(value.floatValue() * 1000.0f);
                            if (rls[0].getTagMaxAggregateShareRatio() == newValue) {
                                return false;
                            }
                            rls[0].setTagMaxAggregateShareRatio(newValue);
                            TagSettingsView.this.updateTagSRParams(TagSettingsView.this.params);
                            return true;
                        }
                    });
                    cols_used += 2;
                    String[] ST_ACTION_VALUES = new String[]{"1", "2"};
                    String[] ST_ACTION_LABELS = new String[]{MessageText.getString("v3.MainWindow.button.pause"), MessageText.getString("v3.MainWindow.button.stop")};
                    this.params.max_aggregate_sr_action = new StringListSwtParameter((Composite)gTransfer, "tag.max_aggregate_sr_action", "label.when.exceeded", null, ST_ACTION_VALUES, ST_ACTION_LABELS, true, new StringListSwtParameter.ValueProcessor(){

                        @Override
                        public String getValue(StringListSwtParameter p) {
                            return "" + rls[0].getTagMaxAggregateShareRatioAction();
                        }

                        @Override
                        public boolean setValue(StringListSwtParameter p, String value) {
                            int val = Integer.parseInt(value);
                            if (rls[0].getTagMaxAggregateShareRatioAction() != val) {
                                rls[0].setTagMaxAggregateShareRatioAction(val);
                                return true;
                            }
                            return false;
                        }
                    });
                    cols_used += 2;
                    this.params.max_aggregate_sr_action.getRelatedControl().setLayoutData((Object)new GridData(1, 0x1000000, false, false));
                    this.params.max_aggregate_sr_priority = new BooleanSwtParameter((Composite)gTransfer, "tag.max_aggregate_sr_priority", "label.aggregate.has.priority", null, new BooleanSwtParameter.ValueProcessor(){

                        @Override
                        public Boolean getValue(BooleanSwtParameter p) {
                            return rls[0].getTagMaxAggregateShareRatioHasPriority();
                        }

                        @Override
                        public boolean setValue(BooleanSwtParameter p, Boolean value) {
                            if (rls[0].getTagMaxAggregateShareRatioHasPriority() == value.booleanValue()) {
                                return false;
                            }
                            rls[0].setTagMaxAggregateShareRatioHasPriority(value);
                            return true;
                        }
                    });
                    cols_used += 2;
                    this.updateTagSRParams(this.params);
                }
                if (cols_used > 0 && cols_used < 8) {
                    Label lab = new Label((Composite)gTransfer, 0);
                    gd = new GridData();
                    gd.horizontalSpan = 8 - cols_used;
                    lab.setLayoutData((Object)gd);
                }
                cols_used = 0;
                if (numTags == 1) {
                    if (supportsMaxDLS) {
                        this.params.maxActiveDownloads = new IntSwtParameter((Composite)gTransfer, "tag.maxActiveDownloads", "ConfigView.label.maxdownloads.short", null, 0, Integer.MAX_VALUE, new IntSwtParameter.ValueProcessor(){

                            @Override
                            public Integer getValue(IntSwtParameter p) {
                                int limit = rls[0].getMaxActiveDownloads();
                                if (numTags > 1) {
                                    int i = 1;
                                    while (i < rls.length) {
                                        int nextLimit = rls[i].getMaxActiveDownloads();
                                        if (nextLimit != limit) {
                                            return 0;
                                        }
                                        ++i;
                                    }
                                }
                                return limit;
                            }

                            @Override
                            public boolean setValue(IntSwtParameter p, Integer value) {
                                if (value == null) {
                                    return false;
                                }
                                TagFeatureRateLimit[] tagFeatureRateLimitArray = rls;
                                int n = rls.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    TagFeatureRateLimit rl = tagFeatureRateLimitArray[n2];
                                    rl.setMaxActiveDownloads(value);
                                    ++n2;
                                }
                                return true;
                            }
                        });
                        cols_used += 2;
                    }
                    if (supportsMaxCDS) {
                        this.params.maxActiveSeeders = new IntSwtParameter((Composite)gTransfer, "tag.maxActiveSeeds", "ConfigView.label.maxseeding", null, 0, Integer.MAX_VALUE, new IntSwtParameter.ValueProcessor(){

                            @Override
                            public Integer getValue(IntSwtParameter p) {
                                int limit = rls[0].getMaxActiveSeeds();
                                if (numTags > 1) {
                                    int i = 1;
                                    while (i < rls.length) {
                                        int nextLimit = rls[i].getMaxActiveSeeds();
                                        if (nextLimit != limit) {
                                            return 0;
                                        }
                                        ++i;
                                    }
                                }
                                return limit;
                            }

                            @Override
                            public boolean setValue(IntSwtParameter p, Integer value) {
                                if (value == null) {
                                    return false;
                                }
                                TagFeatureRateLimit[] tagFeatureRateLimitArray = rls;
                                int n = rls.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    TagFeatureRateLimit rl = tagFeatureRateLimitArray[n2];
                                    rl.setMaxActiveSeeds(value);
                                    ++n2;
                                }
                                return true;
                            }
                        });
                        cols_used += 2;
                    }
                    if (supportsMaxDLS || supportsMaxCDS) {
                        this.params.activeLimitsStrict = new BooleanSwtParameter((Composite)gTransfer, "tag.activelimitsstrict", "label.strict.limits", null, new BooleanSwtParameter.ValueProcessor(){

                            @Override
                            public Boolean getValue(BooleanSwtParameter p) {
                                int value = -1;
                                TagFeatureRateLimit[] tagFeatureRateLimitArray = rls;
                                int n = rls.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    TagFeatureRateLimit rl = tagFeatureRateLimitArray[n2];
                                    value = TagSettingsView.this.updateIntBoolean(rl.getStrictActivityLimits(), value);
                                    ++n2;
                                }
                                return value == 2 ? null : Boolean.valueOf(value == 1);
                            }

                            @Override
                            public boolean setValue(BooleanSwtParameter p, Boolean value) {
                                boolean changed = rls.length == 0;
                                TagFeatureRateLimit[] tagFeatureRateLimitArray = rls;
                                int n = rls.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    TagFeatureRateLimit rl = tagFeatureRateLimitArray[n2];
                                    if (rl.getStrictActivityLimits() != value.booleanValue()) {
                                        rl.setStrictActivityLimits(value);
                                        changed = true;
                                    }
                                    ++n2;
                                }
                                return changed;
                            }
                        });
                        cols_used += 2;
                    }
                    if (cols_used > 0 && cols_used < 8) {
                        Label lab = new Label((Composite)gTransfer, 0);
                        gd = new GridData();
                        gd.horizontalSpan = 8 - cols_used;
                        lab.setLayoutData((Object)gd);
                        cols_used = 0;
                    }
                }
                if (supportsFPSeeding) {
                    this.params.firstPrioritySeeding = new BooleanSwtParameter((Composite)gTransfer, "tag.firstPrioritySeeding", "label.first.priority.seeding", null, new BooleanSwtParameter.ValueProcessor(){

                        @Override
                        public Boolean getValue(BooleanSwtParameter p) {
                            int value = -1;
                            TagFeatureRateLimit[] tagFeatureRateLimitArray = rls;
                            int n = rls.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TagFeatureRateLimit rl = tagFeatureRateLimitArray[n2];
                                value = TagSettingsView.this.updateIntBoolean(rl.getFirstPrioritySeeding(), value);
                                ++n2;
                            }
                            return value == 2 ? null : Boolean.valueOf(value == 1);
                        }

                        @Override
                        public boolean setValue(BooleanSwtParameter p, Boolean value) {
                            boolean changed = rls.length == 0;
                            TagFeatureRateLimit[] tagFeatureRateLimitArray = rls;
                            int n = rls.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TagFeatureRateLimit rl = tagFeatureRateLimitArray[n2];
                                if (rl.getFirstPrioritySeeding() != value.booleanValue()) {
                                    rl.setFirstPrioritySeeding(value);
                                    changed = true;
                                }
                                ++n2;
                            }
                            return changed;
                        }
                    });
                    cols_used += 2;
                    this.params.notFirstPrioritySeeding = new BooleanSwtParameter((Composite)gTransfer, "tag.notFirstPrioritySeeding", "label.not.first.priority.seeding", null, new BooleanSwtParameter.ValueProcessor(){

                        @Override
                        public Boolean getValue(BooleanSwtParameter p) {
                            int value = -1;
                            TagFeatureRateLimit[] tagFeatureRateLimitArray = rls;
                            int n = rls.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TagFeatureRateLimit rl = tagFeatureRateLimitArray[n2];
                                value = TagSettingsView.this.updateIntBoolean(rl.getNotFirstPrioritySeeding(), value);
                                ++n2;
                            }
                            return value == 2 ? null : Boolean.valueOf(value == 1);
                        }

                        @Override
                        public boolean setValue(BooleanSwtParameter p, Boolean value) {
                            boolean changed = rls.length == 0;
                            TagFeatureRateLimit[] tagFeatureRateLimitArray = rls;
                            int n = rls.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TagFeatureRateLimit rl = tagFeatureRateLimitArray[n2];
                                if (rl.getNotFirstPrioritySeeding() != value.booleanValue()) {
                                    rl.setNotFirstPrioritySeeding(value);
                                    changed = true;
                                }
                                ++n2;
                            }
                            return changed;
                        }
                    });
                    cols_used += 2;
                }
                if (cols_used > 0 && cols_used < 8) {
                    Label lab = new Label((Composite)gTransfer, 0);
                    gd = new GridData();
                    gd.horizontalSpan = 8 - cols_used;
                    lab.setLayoutData((Object)gd);
                }
            }
            if (numTags == 1 && this.tags[0] instanceof TagFeatureFileLocation && ((fl = (TagFeatureFileLocation)((Object)this.tags[0])).supportsTagCopyOnComplete() || fl.supportsTagInitialSaveFolder() || fl.supportsTagMoveOnComplete() || fl.supportsTagMoveOnRemove() || fl.supportsTagMoveOnAssign())) {
                Group gFiles = Utils.createSkinnedGroup(this.cMainComposite, 0);
                gFiles.setText(MessageText.getString("label.file.settings"));
                gridLayout = new GridLayout(8, false);
                gFiles.setLayout((Layout)gridLayout);
                gd = new GridData(4, 0, false, false, 1, 1);
                gFiles.setLayoutData((Object)gd);
                this.addPadding(this.cMainComposite);
                this.params.preventDeletion = new BooleanSwtParameter((Composite)gFiles, "tag.prevent_delete", "label.prevent.dl.delete", null, new BooleanSwtParameter.ValueProcessor(){

                    @Override
                    public Boolean getValue(BooleanSwtParameter p) {
                        return fl.getPreventDelete();
                    }

                    @Override
                    public boolean setValue(BooleanSwtParameter p, Boolean value) {
                        if (fl.getPreventDelete() == value.booleanValue()) {
                            return false;
                        }
                        fl.setPreventDelete(value);
                        return true;
                    }
                });
                gd = new GridData();
                gd.horizontalSpan = 8;
                this.params.preventDeletion.setLayoutData(gd);
                if (fl.supportsTagInitialSaveFolder()) {
                    this.params.initalSaveFolder = new folderOption((Composite)gFiles, "label.init.save.loc"){

                        @Override
                        public void setFolder(File folder) {
                            ((TagSettingsView)TagSettingsView.this).params.initalSaveData.setEnabled(folder != null);
                            ((TagSettingsView)TagSettingsView.this).params.initalSaveTorrent.setEnabled(folder != null);
                            fl.setTagInitialSaveFolder(folder);
                        }

                        @Override
                        public File getFolder() {
                            File result = fl.getTagInitialSaveFolder();
                            ((TagSettingsView)TagSettingsView.this).params.initalSaveData.setEnabled(result != null);
                            ((TagSettingsView)TagSettingsView.this).params.initalSaveTorrent.setEnabled(result != null);
                            return result;
                        }
                    };
                    this.params.initalSaveData = new BooleanSwtParameter((Composite)gFiles, "tag.initalSaveData", "label.move.data", null, new BooleanSwtParameter.ValueProcessor(){

                        @Override
                        public Boolean getValue(BooleanSwtParameter p) {
                            if ((fl.getTagInitialSaveOptions() & 1L) != 0L) {
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public boolean setValue(BooleanSwtParameter p, Boolean value) {
                            long flags = fl.getTagInitialSaveOptions();
                            flags = value.booleanValue() ? (flags |= 1L) : (flags &= 0xFFFFFFFFFFFFFFFEL);
                            if (fl.getTagInitialSaveOptions() != flags) {
                                fl.setTagInitialSaveOptions(flags);
                                return true;
                            }
                            return false;
                        }
                    });
                    this.params.initalSaveTorrent = new BooleanSwtParameter((Composite)gFiles, "tag.initalSaveTorrent", "label.move.torrent", null, new BooleanSwtParameter.ValueProcessor(){

                        @Override
                        public Boolean getValue(BooleanSwtParameter p) {
                            if ((fl.getTagInitialSaveOptions() & 2L) != 0L) {
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public boolean setValue(BooleanSwtParameter p, Boolean value) {
                            long flags = fl.getTagInitialSaveOptions();
                            flags = value.booleanValue() ? (flags |= 2L) : (flags &= 0xFFFFFFFFFFFFFFFDL);
                            if (fl.getTagInitialSaveOptions() != flags) {
                                fl.setTagInitialSaveOptions(flags);
                                return true;
                            }
                            return false;
                        }
                    });
                }
                if (fl.supportsTagMoveOnComplete()) {
                    this.params.moveOnCompleteFolder = new folderOption((Composite)gFiles, "label.move.on.comp"){

                        @Override
                        public void setFolder(File folder) {
                            ((TagSettingsView)TagSettingsView.this).params.moveOnCompleteData.setEnabled(folder != null);
                            ((TagSettingsView)TagSettingsView.this).params.moveOnCompleteTorrent.setEnabled(folder != null);
                            fl.setTagMoveOnCompleteFolder(folder);
                        }

                        @Override
                        public File getFolder() {
                            File result = fl.getTagMoveOnCompleteFolder();
                            ((TagSettingsView)TagSettingsView.this).params.moveOnCompleteData.setEnabled(result != null);
                            ((TagSettingsView)TagSettingsView.this).params.moveOnCompleteTorrent.setEnabled(result != null);
                            return result;
                        }
                    };
                    this.params.moveOnCompleteData = new BooleanSwtParameter((Composite)gFiles, "tag.moveOnCompleteData", "label.move.data", null, new BooleanSwtParameter.ValueProcessor(){

                        @Override
                        public Boolean getValue(BooleanSwtParameter p) {
                            if ((fl.getTagMoveOnCompleteOptions() & 1L) != 0L) {
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public boolean setValue(BooleanSwtParameter p, Boolean value) {
                            long flags = fl.getTagMoveOnCompleteOptions();
                            flags = value.booleanValue() ? (flags |= 1L) : (flags &= 0xFFFFFFFFFFFFFFFEL);
                            if (fl.getTagMoveOnCompleteOptions() != flags) {
                                fl.setTagMoveOnCompleteOptions(flags);
                                return true;
                            }
                            return false;
                        }
                    });
                    this.params.moveOnCompleteTorrent = new BooleanSwtParameter((Composite)gFiles, "tag.moveOnCompleteTorrent", "label.move.torrent", null, new BooleanSwtParameter.ValueProcessor(){

                        @Override
                        public Boolean getValue(BooleanSwtParameter p) {
                            if ((fl.getTagMoveOnCompleteOptions() & 2L) != 0L) {
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public boolean setValue(BooleanSwtParameter p, Boolean value) {
                            long flags = fl.getTagMoveOnCompleteOptions();
                            flags = value.booleanValue() ? (flags |= 2L) : (flags &= 0xFFFFFFFFFFFFFFFDL);
                            if (fl.getTagMoveOnCompleteOptions() != flags) {
                                fl.setTagMoveOnCompleteOptions(flags);
                                return true;
                            }
                            return false;
                        }
                    });
                }
                if (fl.supportsTagCopyOnComplete()) {
                    this.params.copyOnCompleteFolder = new folderOption((Composite)gFiles, "label.copy.on.comp"){

                        @Override
                        public void setFolder(File folder) {
                            ((TagSettingsView)TagSettingsView.this).params.copyOnCompleteData.setEnabled(folder != null);
                            ((TagSettingsView)TagSettingsView.this).params.copyOnCompleteTorrent.setEnabled(folder != null);
                            fl.setTagCopyOnCompleteFolder(folder);
                        }

                        @Override
                        public File getFolder() {
                            File result = fl.getTagCopyOnCompleteFolder();
                            ((TagSettingsView)TagSettingsView.this).params.copyOnCompleteData.setEnabled(result != null);
                            ((TagSettingsView)TagSettingsView.this).params.copyOnCompleteTorrent.setEnabled(result != null);
                            return result;
                        }
                    };
                    this.params.copyOnCompleteData = new BooleanSwtParameter((Composite)gFiles, "tag.copyOnCompleteData", "label.copy.data", null, new BooleanSwtParameter.ValueProcessor(){

                        @Override
                        public Boolean getValue(BooleanSwtParameter p) {
                            if ((fl.getTagCopyOnCompleteOptions() & 1L) != 0L) {
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public boolean setValue(BooleanSwtParameter p, Boolean value) {
                            long flags = fl.getTagCopyOnCompleteOptions();
                            flags = value.booleanValue() ? (flags |= 1L) : (flags &= 0xFFFFFFFFFFFFFFFEL);
                            if (fl.getTagCopyOnCompleteOptions() != flags) {
                                fl.setTagCopyOnCompleteOptions(flags);
                                return true;
                            }
                            return false;
                        }
                    });
                    this.params.copyOnCompleteTorrent = new BooleanSwtParameter((Composite)gFiles, "tag.copyOnCompleteTorrent", "label.copy.torrent", null, new BooleanSwtParameter.ValueProcessor(){

                        @Override
                        public Boolean getValue(BooleanSwtParameter p) {
                            if ((fl.getTagCopyOnCompleteOptions() & 2L) != 0L) {
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public boolean setValue(BooleanSwtParameter p, Boolean value) {
                            long flags = fl.getTagCopyOnCompleteOptions();
                            flags = value.booleanValue() ? (flags |= 2L) : (flags &= 0xFFFFFFFFFFFFFFFDL);
                            if (fl.getTagCopyOnCompleteOptions() != flags) {
                                fl.setTagCopyOnCompleteOptions(flags);
                                return true;
                            }
                            return false;
                        }
                    });
                }
                if (fl.supportsTagMoveOnRemove()) {
                    this.params.moveOnRemoveFolder = new folderOption((Composite)gFiles, "label.move.on.rem"){

                        @Override
                        public void setFolder(File folder) {
                            ((TagSettingsView)TagSettingsView.this).params.moveOnRemoveData.setEnabled(folder != null);
                            ((TagSettingsView)TagSettingsView.this).params.moveOnRemoveTorrent.setEnabled(folder != null);
                            fl.setTagMoveOnRemoveFolder(folder);
                        }

                        @Override
                        public File getFolder() {
                            File result = fl.getTagMoveOnRemoveFolder();
                            ((TagSettingsView)TagSettingsView.this).params.moveOnRemoveData.setEnabled(result != null);
                            ((TagSettingsView)TagSettingsView.this).params.moveOnRemoveTorrent.setEnabled(result != null);
                            return result;
                        }
                    };
                    this.params.moveOnRemoveData = new BooleanSwtParameter((Composite)gFiles, "tag.moveOnRemoveData", "label.move.data", null, new BooleanSwtParameter.ValueProcessor(){

                        @Override
                        public Boolean getValue(BooleanSwtParameter p) {
                            if ((fl.getTagMoveOnRemoveOptions() & 1L) != 0L) {
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public boolean setValue(BooleanSwtParameter p, Boolean value) {
                            long flags = fl.getTagMoveOnRemoveOptions();
                            flags = value.booleanValue() ? (flags |= 1L) : (flags &= 0xFFFFFFFFFFFFFFFEL);
                            if (fl.getTagMoveOnRemoveOptions() != flags) {
                                fl.setTagMoveOnRemoveOptions(flags);
                                return true;
                            }
                            return false;
                        }
                    });
                    this.params.moveOnRemoveTorrent = new BooleanSwtParameter((Composite)gFiles, "tag.moveOnRemoveTorrent", "label.move.torrent", null, new BooleanSwtParameter.ValueProcessor(){

                        @Override
                        public Boolean getValue(BooleanSwtParameter p) {
                            if ((fl.getTagMoveOnRemoveOptions() & 2L) != 0L) {
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public boolean setValue(BooleanSwtParameter p, Boolean value) {
                            long flags = fl.getTagMoveOnRemoveOptions();
                            flags = value.booleanValue() ? (flags |= 2L) : (flags &= 0xFFFFFFFFFFFFFFFDL);
                            if (fl.getTagMoveOnRemoveOptions() != flags) {
                                fl.setTagMoveOnRemoveOptions(flags);
                                return true;
                            }
                            return false;
                        }
                    });
                }
                if (fl.supportsTagMoveOnAssign()) {
                    this.params.moveOnAssignFolder = new folderOption((Composite)gFiles, "label.move.on.assign"){

                        @Override
                        public void setFolder(File folder) {
                            ((TagSettingsView)TagSettingsView.this).params.moveOnAssignData.setEnabled(folder != null);
                            ((TagSettingsView)TagSettingsView.this).params.moveOnAssignTorrent.setEnabled(folder != null);
                            fl.setTagMoveOnAssignFolder(folder);
                        }

                        @Override
                        public File getFolder() {
                            File result = fl.getTagMoveOnAssignFolder();
                            ((TagSettingsView)TagSettingsView.this).params.moveOnAssignData.setEnabled(result != null);
                            ((TagSettingsView)TagSettingsView.this).params.moveOnAssignTorrent.setEnabled(result != null);
                            return result;
                        }
                    };
                    this.params.moveOnAssignData = new BooleanSwtParameter((Composite)gFiles, "tag.moveOnAssignData", "label.move.data", null, new BooleanSwtParameter.ValueProcessor(){

                        @Override
                        public Boolean getValue(BooleanSwtParameter p) {
                            if ((fl.getTagMoveOnAssignOptions() & 1L) != 0L) {
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public boolean setValue(BooleanSwtParameter p, Boolean value) {
                            long flags = fl.getTagMoveOnAssignOptions();
                            flags = value.booleanValue() ? (flags |= 1L) : (flags &= 0xFFFFFFFFFFFFFFFEL);
                            if (fl.getTagMoveOnAssignOptions() != flags) {
                                fl.setTagMoveOnAssignOptions(flags);
                                return true;
                            }
                            return false;
                        }
                    });
                    this.params.moveOnAssignTorrent = new BooleanSwtParameter((Composite)gFiles, "tag.moveOnAssignTorrent", "label.move.torrent", null, new BooleanSwtParameter.ValueProcessor(){

                        @Override
                        public Boolean getValue(BooleanSwtParameter p) {
                            if ((fl.getTagMoveOnAssignOptions() & 2L) != 0L) {
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public boolean setValue(BooleanSwtParameter p, Boolean value) {
                            long flags = fl.getTagMoveOnAssignOptions();
                            flags = value.booleanValue() ? (flags |= 2L) : (flags &= 0xFFFFFFFFFFFFFFFDL);
                            if (fl.getTagMoveOnAssignOptions() != flags) {
                                fl.setTagMoveOnAssignOptions(flags);
                                return true;
                            }
                            return false;
                        }
                    });
                }
            }
            if (numTags == 1 && this.tags[0].getTagType().hasTagTypeFeature(32L) && this.tags[0] instanceof TagFeatureProperties) {
                TagDownload tag_dl;
                TagFeatureProperties tfp = (TagFeatureProperties)((Object)this.tags[0]);
                final TagFeatureProperties.TagProperty propConstraint = tfp.getProperty("constraint");
                TagDownload tagDownload = tag_dl = this.tags[0] instanceof TagDownload ? (TagDownload)this.tags[0] : null;
                if (propConstraint != null) {
                    Group gConstraint = Utils.createSkinnedGroup(this.cMainComposite, 0);
                    Messages.setLanguageText((Widget)gConstraint, "tag.property.constraint");
                    gridLayout = new GridLayout();
                    gConstraint.setLayout((Layout)gridLayout);
                    gd = new GridData(4, 0, false, false, 1, 1);
                    gConstraint.setLayoutData((Object)gd);
                    this.addPadding(this.cMainComposite);
                    this.params.constraints = new Text((Composite)gConstraint, 2626);
                    gd = new GridData(4, 0, true, false, 1, 1);
                    gd.heightHint = (int)((double)FontUtils.getFontHeightInPX(this.params.constraints.getFont()) * 2.5);
                    this.params.constraints.setLayoutData((Object)gd);
                    this.params.constraints.addKeyListener(new KeyListener(){

                        public void keyReleased(KeyEvent e) {
                        }

                        public void keyPressed(KeyEvent e) {
                            int key = e.character;
                            if (key <= 26 && key > 0) {
                                key += 96;
                            }
                            if (key == 97 && e.stateMask == SWT.MOD1) {
                                e.doit = false;
                                ((TagSettingsView)TagSettingsView.this).params.constraints.selectAll();
                            }
                        }
                    });
                    this.params.constraints.addModifyListener(e -> {
                        String[] stringList = propConstraint.getStringList();
                        if (stringList.length > 0) {
                            String existing_text = stringList[0];
                            if (!existing_text.equals(this.params.constraints.getText())) {
                                this.params.constraints.setData("skipset", (Object)1);
                                if (this.btnSaveConstraint != null && !this.btnSaveConstraint.isDisposed()) {
                                    this.btnSaveConstraint.setEnabled(true);
                                    this.btnResetConstraint.setEnabled(true);
                                }
                            } else {
                                this.params.constraints.setData("skipset", null);
                                if (this.btnSaveConstraint != null && !this.btnSaveConstraint.isDisposed()) {
                                    this.btnSaveConstraint.setEnabled(false);
                                    this.btnResetConstraint.setEnabled(false);
                                }
                            }
                        }
                    });
                    this.params.constraints.addListener(31, e -> {
                        if (e.detail == 16 && (e.stateMask & SWT.MOD1) != 0) {
                            e.doit = true;
                        }
                    });
                    this.params.constraintError = new Label((Composite)gConstraint, 0);
                    this.params.constraintError.setLayoutData((Object)new GridData(768));
                    Utils.setSkinnedForeground((Control)this.params.constraintError, Colors.colorError, true);
                    Composite cConstraintOptions = new Composite((Composite)gConstraint, 0);
                    cConstraintOptions.setLayoutData((Object)new GridData(768));
                    gridLayout = new GridLayout(11, false);
                    gridLayout.marginWidth = 0;
                    gridLayout.marginRight = 0;
                    gridLayout.marginLeft = 0;
                    gridLayout.marginHeight = 0;
                    gridLayout.marginBottom = 0;
                    gridLayout.marginTop = 0;
                    cConstraintOptions.setLayout((Layout)gridLayout);
                    this.btnSaveConstraint = new Button(cConstraintOptions, 8);
                    this.btnSaveConstraint.setEnabled(false);
                    this.btnSaveConstraint.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            String constraint = ((TagSettingsView)TagSettingsView.this).params.constraints.getText().trim();
                            String[] old_value = propConstraint.getStringList();
                            if (constraint.length() == 0) {
                                propConstraint.setStringList(null);
                            } else {
                                String old_options;
                                String string = old_options = old_value.length > 1 && old_value[1] != null ? old_value[1] : "";
                                if (old_options.length() == 0) {
                                    old_options = TagSettingsView.CM_ADD_REMOVE;
                                }
                                propConstraint.setStringList(new String[]{constraint, old_options});
                            }
                            if (TagSettingsView.this.btnSaveConstraint != null && !TagSettingsView.this.btnSaveConstraint.isDisposed()) {
                                TagSettingsView.this.btnSaveConstraint.setEnabled(false);
                                TagSettingsView.this.btnResetConstraint.setEnabled(false);
                            }
                        }
                    });
                    Messages.setLanguageText((Widget)this.btnSaveConstraint, "Button.save");
                    this.btnResetConstraint = new Button(cConstraintOptions, 8);
                    this.btnResetConstraint.setEnabled(false);
                    this.btnResetConstraint.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            ((TagSettingsView)TagSettingsView.this).params.constraints.setData("skipset", null);
                            TagSettingsView.this.swt_updateFields();
                            if (TagSettingsView.this.btnSaveConstraint != null && !TagSettingsView.this.btnSaveConstraint.isDisposed()) {
                                TagSettingsView.this.btnSaveConstraint.setEnabled(false);
                                TagSettingsView.this.btnResetConstraint.setEnabled(false);
                            }
                        }
                    });
                    Messages.setLanguageText((Widget)this.btnResetConstraint, "Button.reset");
                    this.params.constraintEnabled = new BooleanSwtParameter(cConstraintOptions, "tag.constraintEnabled", "label.enabled", null, new BooleanSwtParameter.ValueProcessor(){

                        @Override
                        public Boolean getValue(BooleanSwtParameter p) {
                            return propConstraint.isEnabled();
                        }

                        @Override
                        public boolean setValue(BooleanSwtParameter p, Boolean value) {
                            if (propConstraint.isEnabled() == value.booleanValue()) {
                                return false;
                            }
                            propConstraint.setEnabled(value);
                            return true;
                        }
                    });
                    String[] CM_VALUES = new String[]{CM_ADD_REMOVE, CM_ADD_ONLY, CM_REMOVE_ONLY, CM_NEW_DLS};
                    String[] CM_LABELS = new String[]{MessageText.getString("label.addition.and.removal"), MessageText.getString("label.addition.only"), MessageText.getString("label.removal.only"), MessageText.getString("label.new.downloads")};
                    this.params.constraintMode = new StringListSwtParameter(cConstraintOptions, "tag_constraint_action_mode", "label.scope", null, CM_VALUES, CM_LABELS, true, new StringListSwtParameter.ValueProcessor(){

                        @Override
                        public String getValue(StringListSwtParameter p) {
                            String[] list = propConstraint.getStringList();
                            if (list.length > 1 && list[1] != null) {
                                return list[1];
                            }
                            return TagSettingsView.CM_ADD_REMOVE;
                        }

                        @Override
                        public boolean setValue(StringListSwtParameter p, String value) {
                            if (value == null || value.length() == 0) {
                                value = TagSettingsView.CM_ADD_REMOVE;
                            }
                            String[] list = propConstraint.getStringList();
                            propConstraint.setStringList(new String[]{list != null && list.length > 0 ? list[0] : "", value});
                            return true;
                        }
                    });
                    this.params.constraintWeight = new IntSwtParameter(cConstraintOptions, "tag_constraint_weight", "tag.constraints.weight", null, Integer.MIN_VALUE, Integer.MAX_VALUE, new IntSwtParameter.ValueProcessor(){

                        @Override
                        public Integer getValue(IntSwtParameter p) {
                            return ((TagDownload)TagSettingsView.this.tags[0]).getWeight();
                        }

                        @Override
                        public boolean setValue(IntSwtParameter p, Integer value) {
                            ((TagDownload)TagSettingsView.this.tags[0]).setWeight(value);
                            return true;
                        }
                    });
                    this.params.constraintWeight.setEnabled(tag_dl != null);
                    Link lblAboutConstraint = new Link(cConstraintOptions, 64);
                    lblAboutConstraint.setText(MessageText.getString("tag.constraints.info"));
                    lblAboutConstraint.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            if (event2.text != null && (event2.text.startsWith("http://") || event2.text.startsWith("https://"))) {
                                Utils.launch(event2.text);
                            }
                        }
                    });
                    ClipboardCopy.addCopyToClipMenu((Control)lblAboutConstraint);
                    Composite cApplySort = new Composite((Composite)gConstraint, 0);
                    cApplySort.setLayoutData((Object)new GridData(768));
                    gridLayout = new GridLayout(10, false);
                    gridLayout.marginWidth = 0;
                    gridLayout.marginRight = 0;
                    gridLayout.marginLeft = 0;
                    gridLayout.marginHeight = 0;
                    gridLayout.marginBottom = 0;
                    gridLayout.marginTop = 0;
                    cApplySort.setLayout((Layout)gridLayout);
                    Label lApplySort = new Label(cApplySort, 0);
                    lApplySort.setText(MessageText.getString("tag.constraints.sort.apply.manual"));
                    Button btnApply = new Button(cApplySort, 8);
                    btnApply.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            tag_dl.applySort();
                        }
                    });
                    Messages.setLanguageText((Widget)btnApply, "Button.apply");
                    btnApply.setEnabled(tag_dl != null);
                    this.params.constraintTagSortAuto = new IntSwtParameter(cApplySort, "tag_constraint_tag_sort_auto", "tag.constraints.sort.apply.auto", null, 0, Integer.MAX_VALUE, new IntSwtParameter.ValueProcessor(){

                        @Override
                        public Integer getValue(IntSwtParameter p) {
                            return ((TagDownload)TagSettingsView.this.tags[0]).getAutoApplySortInterval();
                        }

                        @Override
                        public boolean setValue(IntSwtParameter p, Integer value) {
                            ((TagDownload)TagSettingsView.this.tags[0]).setAutoApplySortInterval(value);
                            return true;
                        }
                    });
                    this.params.constraintTagSortAuto.setEnabled(tag_dl != null);
                }
            }
            if (numTags == 1 && this.tags[0].getTagType().hasTagTypeFeature(128L) && (tfl = (TagFeatureLimits)((Object)this.tags[0])).getMaximumTaggables() >= 0) {
                Group gLimits = Utils.createSkinnedGroup(this.cMainComposite, 0);
                gLimits.setText(MessageText.getString("label.limit.settings"));
                gridLayout = new GridLayout(6, false);
                gLimits.setLayout((Layout)gridLayout);
                gd = new GridData(4, 0, false, false, 1, 1);
                gLimits.setLayoutData((Object)gd);
                this.addPadding(this.cMainComposite);
                this.params.tfl_max_taggables = new IntSwtParameter((Composite)gLimits, "tag.tfl_max_taggables", "TableColumn.header.max_taggables", null, 0, Integer.MAX_VALUE, new IntSwtParameter.ValueProcessor(){

                    @Override
                    public Integer getValue(IntSwtParameter p) {
                        return tfl.getMaximumTaggables();
                    }

                    @Override
                    public boolean setValue(IntSwtParameter p, Integer value) {
                        tfl.setMaximumTaggables(value);
                        return true;
                    }
                });
                this.params.tfl_max_taggables.disableTimedSave();
                this.params.tfl_removal_policy = new StringListSwtParameter((Composite)gLimits, "tag.tfl_removal_policy", "label.removal.policy", null, new String[]{"0", "1", "2", "3", "4"}, new String[]{"", MessageText.getString("MyTorrentsView.menu.archive"), MessageText.getString("Button.deleteContent.fromLibrary"), MessageText.getString("Button.deleteContent.fromComputer"), MessageText.getString("label.move.to.old.tag")}, true, new StringListSwtParameter.ValueProcessor(){

                    @Override
                    public String getValue(StringListSwtParameter p) {
                        return String.valueOf(tfl.getRemovalStrategy());
                    }

                    @Override
                    public boolean setValue(StringListSwtParameter p, String value) {
                        int val;
                        int n = val = value == null ? 0 : Integer.parseInt(value);
                        if (tfl.getRemovalStrategy() != val) {
                            tfl.setRemovalStrategy(val);
                            return true;
                        }
                        return false;
                    }
                });
                this.params.tfl_ordering = new StringListSwtParameter((Composite)gLimits, "tag.tfl_ordering", "label.ordering", null, new String[]{"0", "1"}, new String[]{MessageText.getString("label.time.added.to.vuze"), MessageText.getString("label.time.added.to.tag")}, true, new StringListSwtParameter.ValueProcessor(){

                    @Override
                    public String getValue(StringListSwtParameter p) {
                        return String.valueOf(tfl.getOrdering());
                    }

                    @Override
                    public boolean setValue(StringListSwtParameter p, String value) {
                        int val;
                        int n = val = value == null ? 0 : Integer.parseInt(value);
                        if (tfl.getOrdering() != val) {
                            tfl.setOrdering(val);
                            return true;
                        }
                        return false;
                    }
                });
            }
            if (numTags == 1 && this.tags[0].getTagType().hasTagTypeFeature(256L)) {
                final TagFeatureNotifications tfn = (TagFeatureNotifications)((Object)this.tags[0]);
                Group gNotifications = Utils.createSkinnedGroup(this.cMainComposite, 0);
                gNotifications.setText(MessageText.getString("v3.MainWindow.tab.events"));
                gridLayout = new GridLayout(6, false);
                gNotifications.setLayout((Layout)gridLayout);
                gd = new GridData(4, 0, false, false, 1, 1);
                gNotifications.setLayoutData((Object)gd);
                this.addPadding(this.cMainComposite);
                label = new Label((Composite)gNotifications, 0);
                label.setText(String.valueOf(MessageText.getString("tag.notification.post")) + ":");
                this.params.notification_post_add = new BooleanSwtParameter((Composite)gNotifications, "tag.notification_post_add", "label.on.addition", null, new BooleanSwtParameter.ValueProcessor(){

                    @Override
                    public Boolean getValue(BooleanSwtParameter p) {
                        if ((tfn.getPostingNotifications() & 1) != 0) {
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public boolean setValue(BooleanSwtParameter p, Boolean value) {
                        int flags = tfn.getPostingNotifications();
                        flags = value.booleanValue() ? (flags |= 1) : (flags &= 0xFFFFFFFE);
                        if (tfn.getPostingNotifications() != flags) {
                            tfn.setPostingNotifications(flags);
                            return true;
                        }
                        return false;
                    }
                });
                this.params.notification_post_remove = new BooleanSwtParameter((Composite)gNotifications, "tag.notification_post_remove", "label.on.removal", null, new BooleanSwtParameter.ValueProcessor(){

                    @Override
                    public Boolean getValue(BooleanSwtParameter p) {
                        if ((tfn.getPostingNotifications() & 2) != 0) {
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public boolean setValue(BooleanSwtParameter p, Boolean value) {
                        int flags = tfn.getPostingNotifications();
                        flags = value.booleanValue() ? (flags |= 2) : (flags &= 0xFFFFFFFD);
                        if (tfn.getPostingNotifications() != flags) {
                            tfn.setPostingNotifications(flags);
                            return true;
                        }
                        return false;
                    }
                });
            }
            this.swt_updateFields();
        }
        this.parent.layout(true, true);
    }

    private void updateTagSRParams(Params params) {
        boolean has_individual = ((Float)params.max_sr.getValue()).floatValue() > 0.0f;
        boolean has_aggregate = ((Float)params.max_aggregate_sr.getValue()).floatValue() > 0.0f;
        params.max_aggregate_sr_priority.getMainControl().setEnabled(has_individual && has_aggregate);
    }

    private int updateIntBoolean(boolean b, int intB) {
        if (intB == -1) {
            intB = b ? 1 : 0;
        } else if (intB == 1 != b) {
            intB = 2;
        }
        return intB;
    }

    private String getFullTitle() {
        return MessageText.getString("TagSettingsView.title");
    }

    private void swt_updateFields() {
        if (this.tags == null || this.params == null) {
            this.buildUI();
            return;
        }
        int[] tagColor = this.tags[0].getColor();
        HashSet<String> listTagNames = new HashSet<String>();
        Tag[] tagArray = this.tags;
        int n = this.tags.length;
        int n2 = 0;
        while (n2 < n) {
            int[] color;
            Tag tag = tagArray[n2];
            String s = tag.getTagName(true);
            listTagNames.add(s);
            if (tagColor != null && !Arrays.equals(tagColor, color = tag.getColor())) {
                tagColor = null;
            }
            ++n2;
        }
        String name = GeneralUtils.stringJoin(listTagNames, ", ");
        if (this.params.cName != null && !this.params.cName.isDisposed()) {
            if (this.params.cName instanceof Text) {
                Text txt = (Text)this.params.cName;
                if (!txt.getText().equals(name)) {
                    txt.setText(name);
                }
            } else if (this.params.cName instanceof Label) {
                Label lbl = (Label)this.params.cName;
                lbl.setText(name);
            }
        }
        if (this.params.tagColor != null && tagColor != null) {
            this.params.tagColor.setColor(tagColor[0], tagColor[1], tagColor[2]);
        }
        if (this.params.viewInSideBar != null) {
            this.params.viewInSideBar.refreshControl();
        }
        if (this.params.hideWhenEmpty != null) {
            this.params.hideWhenEmpty.refreshControl();
        }
        if (this.params.isPublic != null) {
            this.params.isPublic.refreshControl();
        }
        if (this.params.isFilter != null) {
            this.params.isFilter.refreshControl();
        }
        if (this.params.maxDownloadSpeed != null) {
            this.params.maxDownloadSpeed.resetToDefault();
        }
        if (this.params.maxUploadSpeed != null) {
            this.params.maxUploadSpeed.resetToDefault();
        }
        if (this.params.uploadPriority != null) {
            this.params.uploadPriority.refreshControl();
        }
        if (this.params.min_sr != null) {
            this.params.min_sr.refreshControl();
        }
        if (this.params.max_sr != null) {
            this.params.max_sr.refreshControl();
        }
        if (this.params.initalSaveFolder != null) {
            this.params.initalSaveFolder.update();
        }
        if (this.params.moveOnCompleteFolder != null) {
            this.params.moveOnCompleteFolder.update();
        }
        if (this.params.copyOnCompleteFolder != null) {
            this.params.copyOnCompleteFolder.update();
        }
        if (this.params.moveOnRemoveFolder != null) {
            this.params.moveOnRemoveFolder.update();
        }
        if (this.params.moveOnAssignFolder != null) {
            this.params.moveOnAssignFolder.update();
        }
        if (this.params.constraints != null) {
            String error;
            Tag tag = this.tags[0];
            if (this.params.constraints.getData("skipset") == null) {
                TagFeatureProperties tfp;
                TagFeatureProperties.TagProperty propConstraint;
                String text = "";
                String mode = CM_ADD_REMOVE;
                if (tag.getTagType().hasTagTypeFeature(32L) && tag instanceof TagFeatureProperties && (propConstraint = (tfp = (TagFeatureProperties)((Object)tag)).getProperty("constraint")) != null) {
                    String[] stringList = propConstraint.getStringList();
                    if (stringList.length > 0) {
                        text = stringList[0];
                    }
                    if (stringList.length > 1 && stringList[1] != null) {
                        mode = stringList[1];
                    }
                }
                this.params.constraints.setText(text);
                this.params.constraintMode.setValue(mode);
            }
            if ((error = (String)tag.getTransientProperty("Constraint Error")) == null) {
                this.params.constraintError.setText("");
            } else {
                this.params.constraintError.setText(error.replace('\r', ' ').replace('\n', ' '));
            }
        }
        if (this.params.tfl_max_taggables != null) {
            this.params.tfl_max_taggables.refreshControl();
        }
    }

    @Override
    public void tagTypeChanged(TagType tag_type) {
    }

    @Override
    public void tagEventOccurred(TagTypeListener.TagEvent event2) {
        int type = event2.getEventType();
        Tag tag = event2.getTag();
        if (type == 1 || type == 4) {
            this.tagChanged(tag);
        }
    }

    public void tagChanged(Tag changedTag) {
        Utils.execSWTThread(() -> {
            if (this.tags == null) {
                return;
            }
            Tag[] tagArray = this.tags;
            int n = this.tags.length;
            int n2 = 0;
            while (n2 < n) {
                Tag tag2 = tagArray[n2];
                if (changedTag.equals(tag2)) {
                    this.swt_updateFields();
                    break;
                }
                ++n2;
            }
        });
    }

    public static class Params {
        private Control cName;
        private ColorSwtParameter tagColor;
        private IntSwtParameter maxDownloadSpeed;
        private IntSwtParameter maxUploadSpeed;
        private IconSwtParameter tagIcon;
        private BooleanSwtParameter viewInSideBar;
        private BooleanSwtParameter hideWhenEmpty;
        private BooleanSwtParameter isPublic;
        private BooleanSwtParameter isFilter;
        public BooleanSwtParameter uploadPriority;
        public BooleanSwtParameter boost;
        public IntSwtParameter maxActiveDownloads;
        public IntSwtParameter maxActiveSeeders;
        public BooleanSwtParameter activeLimitsStrict;
        public BooleanSwtParameter firstPrioritySeeding;
        public BooleanSwtParameter notFirstPrioritySeeding;
        public FloatSwtParameter min_sr;
        public FloatSwtParameter max_sr;
        public StringListSwtParameter max_sr_action;
        public FloatSwtParameter max_aggregate_sr;
        public StringListSwtParameter max_aggregate_sr_action;
        public BooleanSwtParameter max_aggregate_sr_priority;
        private BooleanSwtParameter preventDeletion;
        public folderOption initalSaveFolder;
        public BooleanSwtParameter initalSaveData;
        public BooleanSwtParameter initalSaveTorrent;
        public folderOption moveOnCompleteFolder;
        public BooleanSwtParameter moveOnCompleteData;
        public BooleanSwtParameter moveOnCompleteTorrent;
        public folderOption copyOnCompleteFolder;
        public BooleanSwtParameter copyOnCompleteData;
        public BooleanSwtParameter copyOnCompleteTorrent;
        public folderOption moveOnRemoveFolder;
        public BooleanSwtParameter moveOnRemoveData;
        public BooleanSwtParameter moveOnRemoveTorrent;
        public folderOption moveOnAssignFolder;
        public BooleanSwtParameter moveOnAssignData;
        public BooleanSwtParameter moveOnAssignTorrent;
        public Text constraints;
        public Label constraintError;
        public BooleanSwtParameter constraintEnabled;
        public StringListSwtParameter constraintMode;
        public IntSwtParameter constraintWeight;
        public IntSwtParameter constraintTagSortAuto;
        public IntSwtParameter tfl_max_taggables;
        public StringListSwtParameter tfl_removal_policy;
        public StringListSwtParameter tfl_ordering;
        public BooleanSwtParameter notification_post_add;
        public BooleanSwtParameter notification_post_remove;
    }

    private static abstract class folderOption {
        private Button btnClear;
        private Text lblValue;

        public folderOption(final Composite parent, String labelTextID) {
            ImageLoader imageLoader = ImageLoader.getInstance();
            Image imgOpenFolder = imageLoader.getImage("openFolderButton");
            GridData gd = new GridData();
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)gd);
            Messages.setLanguageText((Widget)label, labelTextID);
            Button browse = new Button(parent, 8);
            browse.setImage(imgOpenFolder);
            imgOpenFolder.setBackground(browse.getBackground());
            Utils.setTT((Control)browse, MessageText.getString("ConfigView.button.browse"));
            browse.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 65536);
                    File tagInitialSaveFolder = this.getFolder();
                    String filterPath = tagInitialSaveFolder != null ? tagInitialSaveFolder.toString() : COConfigurationManager.getStringParameter("Default save path");
                    dialog.setFilterPath(filterPath);
                    dialog.setMessage(MessageText.getString("label.init.save.loc"));
                    dialog.setText(MessageText.getString("label.init.save.loc"));
                    final String path = dialog.open();
                    if (path != null) {
                        Utils.getOffOfSWTThread(new AERunnable(){

                            @Override
                            public void runSupport() {
                                this.setFolder(new File(path));
                            }
                        });
                    }
                }
            });
            this.lblValue = new Text(parent, 2112);
            gd = Utils.getWrappableLabelGridData(1, 768);
            gd.verticalAlignment = 0x1000000;
            this.lblValue.setLayoutData((Object)gd);
            this.lblValue.addTraverseListener(e -> {
                if (e.detail == 16) {
                    e.doit = true;
                }
            });
            this.lblValue.addListener(16, ev -> {
                String str = this.lblValue.getText().trim();
                Utils.getOffOfSWTThread(() -> {
                    if (str.isEmpty()) {
                        this.setFolder(null);
                    } else {
                        File f = new File(str);
                        this.setFolder(f);
                    }
                });
            });
            this.btnClear = new Button(parent, 8);
            Messages.setLanguageText((Widget)this.btnClear, "Button.clear");
            this.btnClear.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    this.setFolder(null);
                }
            });
        }

        public void update() {
            File folder = this.getFolder();
            if (folder == null) {
                if (!this.lblValue.getText().isEmpty()) {
                    this.lblValue.setText("");
                }
            } else {
                String str = folder.toString();
                if (!this.lblValue.getText().equals(str)) {
                    this.lblValue.setText(str);
                }
            }
            this.btnClear.setVisible(folder != null);
        }

        public abstract File getFolder();

        public abstract void setFolder(File var1);
    }
}

