/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.LocaleTorrentUtil;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentAnnounceURLGroup;
import com.biglybt.core.torrent.TOTorrentAnnounceURLSet;
import com.biglybt.core.tracker.client.TRTrackerAnnouncer;
import com.biglybt.core.tracker.client.TRTrackerScraperResponse;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.download.DownloadTypeComplete;
import com.biglybt.pif.download.DownloadTypeIncomplete;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.selectedcontent.SelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BufferedLabel;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mdi.TabbedEntry;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.utils.DragDropUtils;
import com.biglybt.ui.swt.views.ViewUtils;
import com.biglybt.ui.swt.views.table.impl.FakeTableCell;
import com.biglybt.util.DataSourceUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class TorrentInfoView
implements UISWTViewCoreEventListener,
UIPluginViewToolBarListener,
DragSourceListener {
    public static final String MSGID_PREFIX = "TorrentInfoView";
    private DownloadManager download_manager;
    private Composite outer_panel;
    private Font headerFont;
    private FakeTableCell[] cells;
    private Composite parent;
    private UISWTView swtView;

    private void initialize(Composite composite) {
        this.parent = composite;
        Utils.disposeComposite(this.parent, false);
        if (this.download_manager == null) {
            ViewUtils.setViewRequiresOneDownload(composite);
            return;
        }
        Composite panel = Utils.createScrolledComposite(composite);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        boolean showHeader = true;
        if (this.swtView instanceof TabbedEntry) {
            showHeader = ((TabbedEntry)this.swtView).getMDI().getAllowSubViews();
        }
        if (showHeader) {
            Composite cHeader = new Composite(panel, Utils.isDarkAppearanceNativeWindows() ? 0 : 2048);
            GridLayout configLayout = new GridLayout();
            configLayout.marginHeight = 3;
            configLayout.marginWidth = 0;
            cHeader.setLayout((Layout)configLayout);
            GridData gridData = new GridData(772);
            cHeader.setLayoutData((Object)gridData);
            Display d = panel.getDisplay();
            cHeader.setBackground(Colors.getSystemColor((Device)d, 26));
            cHeader.setForeground(Colors.getSystemColor((Device)d, 27));
            Label lHeader = new Label(cHeader, 0);
            lHeader.setBackground(Colors.getSystemColor((Device)d, 26));
            lHeader.setForeground(Colors.getSystemColor((Device)d, 27));
            FontData[] fontData = lHeader.getFont().getFontData();
            fontData[0].setStyle(1);
            int fontHeight = (int)((double)fontData[0].getHeight() * 1.2);
            fontData[0].setHeight(fontHeight);
            this.headerFont = new Font((Device)d, fontData);
            lHeader.setFont(this.headerFont);
            lHeader.setText(" " + MessageText.getString("authenticator.torrent") + " : " + this.download_manager.getDisplayName().replaceAll("&", "&&"));
            gridData = new GridData(772);
            lHeader.setLayoutData((Object)gridData);
        }
        Composite gTorrentInfo = new Composite(panel, 0);
        GridData gridData = new GridData(272);
        gTorrentInfo.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        gTorrentInfo.setLayout((Layout)layout);
        Label label = new Label(gTorrentInfo, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(MessageText.getString("TorrentInfoView.torrent.encoding")) + ": ");
        TOTorrent torrent = this.download_manager.getTorrent();
        BufferedLabel blabel = new BufferedLabel(gTorrentInfo, 0);
        gridData = new GridData();
        blabel.setLayoutData(gridData);
        if (torrent == null) {
            blabel.setText("");
        } else {
            int tt = torrent.getTorrentType();
            String tt_str = String.valueOf(MessageText.getString("label.torrent.type")) + ": " + MessageText.getString("label.torrent.type." + tt);
            int ett = torrent.getEffectiveTorrentType();
            if (ett != tt) {
                tt_str = String.valueOf(tt_str) + ", " + MessageText.getString("label.effective") + ": " + MessageText.getString("label.torrent.type." + ett);
            }
            blabel.setText(String.valueOf(LocaleTorrentUtil.getCurrentTorrentEncoding(torrent)) + "; " + tt_str);
        }
        label = new Label(gTorrentInfo, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(MessageText.getString("label.tracker")) + ": ");
        String trackers = "";
        if (torrent != null) {
            TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
            TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
            ArrayList<String> tracker_list = new ArrayList<String>();
            URL url = torrent.getAnnounceURL();
            tracker_list.add(String.valueOf(url.getHost()) + (url.getPort() == -1 ? "" : ":" + url.getPort()));
            int i = 0;
            while (i < sets.length) {
                TOTorrentAnnounceURLSet set = sets[i];
                URL[] urls = set.getAnnounceURLs();
                int j = 0;
                while (j < urls.length) {
                    url = urls[j];
                    String str = String.valueOf(url.getHost()) + (url.getPort() == -1 ? "" : ":" + url.getPort());
                    if (!tracker_list.contains(str)) {
                        tracker_list.add(str);
                    }
                    ++j;
                }
                ++i;
            }
            TRTrackerAnnouncer announcer = this.download_manager.getTrackerClient();
            URL active_url = null;
            if (announcer != null) {
                active_url = announcer.getTrackerURL();
            } else {
                TRTrackerScraperResponse scrape = this.download_manager.getTrackerScrapeResponse();
                if (scrape != null) {
                    active_url = scrape.getURL();
                }
            }
            if (active_url == null) {
                active_url = torrent.getAnnounceURL();
            }
            trackers = String.valueOf(active_url.getHost()) + (active_url.getPort() == -1 ? "" : ":" + active_url.getPort());
            tracker_list.remove(trackers);
            if (tracker_list.size() > 0) {
                trackers = String.valueOf(trackers) + " (";
                int i2 = 0;
                while (i2 < tracker_list.size()) {
                    trackers = String.valueOf(trackers) + (i2 == 0 ? "" : ", ") + (String)tracker_list.get(i2);
                    ++i2;
                }
                trackers = String.valueOf(trackers) + ")";
            }
        }
        blabel = new BufferedLabel(gTorrentInfo, 64);
        blabel.setLayoutData(Utils.getWrappableLabelGridData(1, 768));
        blabel.setText(trackers);
        Group gColumns = Utils.createSkinnedGroup(panel, 0);
        Messages.setLanguageText((Widget)gColumns, "TorrentInfoView.columns");
        gridData = new GridData(1808);
        gColumns.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 4;
        gColumns.setLayout((Layout)layout);
        HashMap<String, FakeTableCell> usable_cols = new HashMap<String, FakeTableCell>();
        TableColumnManager col_man = TableColumnManager.getInstance();
        TableColumnCore[][] cols_sets = new TableColumnCore[][]{col_man.getAllTableColumnCoreAsArray(DownloadTypeIncomplete.class, "MyTorrents"), col_man.getAllTableColumnCoreAsArray(DownloadTypeComplete.class, "MySeeders")};
        int i = 0;
        while (i < cols_sets.length) {
            TableColumnCore[] cols = cols_sets[i];
            int j = 0;
            while (j < cols.length) {
                TableColumnCore col = cols[j];
                String id = col.getName();
                if (!usable_cols.containsKey(id)) {
                    FakeTableCell fakeTableCell = null;
                    try {
                        fakeTableCell = new FakeTableCell(col, this.download_manager);
                        fakeTableCell.setOrentation(16384);
                        fakeTableCell.setWrapText(false);
                        col.invokeCellAddedListeners(fakeTableCell);
                        fakeTableCell.refresh();
                        usable_cols.put(id, fakeTableCell);
                    }
                    catch (Throwable t) {
                        try {
                            if (fakeTableCell != null) {
                                fakeTableCell.dispose();
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        Collection values = usable_cols.values();
        this.cells = new FakeTableCell[values.size()];
        values.toArray(this.cells);
        Arrays.sort(this.cells, new Comparator<FakeTableCell>(){

            @Override
            public int compare(FakeTableCell o1, FakeTableCell o2) {
                TableColumnCore c1 = (TableColumnCore)o1.getTableColumn();
                TableColumnCore c2 = (TableColumnCore)o2.getTableColumn();
                String key1 = MessageText.getString(c1.getTitleLanguageKey());
                String key2 = MessageText.getString(c2.getTitleLanguageKey());
                return key1.compareToIgnoreCase(key2);
            }
        });
        int i3 = 0;
        while (i3 < this.cells.length) {
            final FakeTableCell cell = this.cells[i3];
            CLabel cLabel = new CLabel((Composite)gColumns, 0);
            gridData = new GridData();
            if (i3 % 2 == 1) {
                gridData.horizontalIndent = 16;
            }
            cLabel.setLayoutData((Object)gridData);
            TableColumnCore tc = (TableColumnCore)cell.getTableColumn();
            String key = tc.getTitleLanguageKey();
            cLabel.setText(String.valueOf(MessageText.getString(key)) + ": ");
            Utils.setTT((Control)cLabel, MessageText.getString(String.valueOf(key) + ".info", ""));
            String iconReference = tc.getIconReference();
            if (iconReference != null) {
                Utils.setMenuItemImage(cLabel, iconReference);
            }
            cLabel.setData("ColumnName", (Object)tc.getName());
            DragSource dragSource = DragDropUtils.createDragSource((Control)cLabel, 3);
            dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
            dragSource.addDragListener((DragSourceListener)this);
            final Composite c = new Composite((Composite)gColumns, 0x20000000);
            gridData = new GridData(768);
            gridData.heightHint = 16;
            c.setLayoutData((Object)gridData);
            cell.setControl(c);
            cell.invalidate();
            cell.refresh();
            c.addListener(32, new Listener(){

                public void handleEvent(Event event2) {
                    Object toolTip = cell.getToolTip();
                    if (toolTip instanceof String) {
                        String s = (String)toolTip;
                        Utils.setTT((Control)c, s);
                    }
                }
            });
            ++i3;
        }
        this.refresh();
        composite.layout();
    }

    private void refresh() {
        if (this.cells != null) {
            int i = 0;
            while (i < this.cells.length) {
                FakeTableCell cell = this.cells[i];
                try {
                    cell.refresh();
                    cell.redraw();
                }
                catch (Exception e) {
                    Debug.printStackTrace(e, "Error refreshing cell: " + this.cells[i].getTableColumn().getName());
                }
                ++i;
            }
        }
    }

    private Composite getComposite() {
        return this.outer_panel;
    }

    private String getFullTitle() {
        return MessageText.getString("TorrentInfoView.title.full");
    }

    private void delete() {
        if (this.headerFont != null) {
            this.headerFont.dispose();
        }
        if (this.cells != null) {
            int i = 0;
            while (i < this.cells.length) {
                FakeTableCell cell = this.cells[i];
                cell.dispose();
                ++i;
            }
        }
    }

    private void dataSourceChanged(Object newDataSource) {
        DownloadManager[] dms = DataSourceUtils.getDMs(newDataSource);
        this.download_manager = dms.length != 1 ? null : dms[0];
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (TorrentInfoView.this.parent != null && !TorrentInfoView.this.parent.isDisposed()) {
                    TorrentInfoView.this.initialize(TorrentInfoView.this.parent);
                }
            }
        });
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                this.swtView.setToolBarListener(this);
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                String id = "DMDetails_Info";
                if (this.download_manager != null) {
                    id = this.download_manager.getTorrent() != null ? String.valueOf(id) + "." + this.download_manager.getInternalName() : String.valueOf(id) + ":" + this.download_manager.getSize();
                    SelectedContentManager.changeCurrentlySelectedContent(id, new SelectedContent[]{new SelectedContent(this.download_manager)});
                    break;
                }
                SelectedContentManager.changeCurrentlySelectedContent(id, null);
                break;
            }
            case 4: {
                SelectedContentManager.clearCurrentlySelectedContent();
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        return false;
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        Map<String, Long> states = TorrentUtil.calculateToolbarStates(SelectedContentManager.getCurrentlySelectedContent(), null);
        list.putAll(states);
    }

    public void dragStart(DragSourceEvent event2) {
        if (this.swtView == null || this.swtView.isContentDisposed()) {
            return;
        }
    }

    public void dragSetData(DragSourceEvent event2) {
        DragSource dragSource = (DragSource)event2.widget;
        Control control = dragSource.getControl();
        event2.data = control.getData("ColumnName");
    }

    public void dragFinished(DragSourceEvent event2) {
    }
}

