/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.download.DownloadManagerAvailability;
import com.biglybt.core.tracker.TrackerPeerSource;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableDataSourceChangedListener;
import com.biglybt.ui.common.table.TableLifeCycleListener;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.TableViewSWTMenuFillListener;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import com.biglybt.ui.swt.views.table.impl.TableViewTab;
import com.biglybt.ui.swt.views.tableitems.tracker.CompletedItem;
import com.biglybt.ui.swt.views.tableitems.tracker.LeechersItem;
import com.biglybt.ui.swt.views.tableitems.tracker.NameItem;
import com.biglybt.ui.swt.views.tableitems.tracker.PeersItem;
import com.biglybt.ui.swt.views.tableitems.tracker.SeedsItem;
import com.biglybt.ui.swt.views.tableitems.tracker.StatusItem;
import com.biglybt.ui.swt.views.tableitems.tracker.TypeItem;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Menu;

public class TrackerAvailView
extends TableViewTab<TrackerPeerSource>
implements TableLifeCycleListener,
TableDataSourceChangedListener,
TableViewSWTMenuFillListener {
    private static final String TABLE_ID = "TrackerAvail";
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new TypeItem("TrackerAvail"), new NameItem("TrackerAvail"), new StatusItem("TrackerAvail"), new SeedsItem("TrackerAvail"), new LeechersItem("TrackerAvail"), new PeersItem("TrackerAvail"), new CompletedItem("TrackerAvail")};
    public static final String MSGID_PREFIX = "TrackerView";
    private DownloadManagerAvailability availability;
    private TableViewSWT<TrackerPeerSource> tv;

    public TrackerAvailView() {
        super(MSGID_PREFIX);
    }

    @Override
    public TableViewSWT<TrackerPeerSource> initYourTableView() {
        this.tv = TableViewFactory.createTableViewSWT(TrackerPeerSource.class, TABLE_ID, this.getTextPrefixID(), basicItems, basicItems[0].getName(), 0x10010002);
        this.tv.addLifeCycleListener(this);
        this.tv.addMenuFillListener(this);
        this.tv.addTableDataSourceChangedListener(this, true);
        return this.tv;
    }

    public boolean isUpdating() {
        HashSet peer_sources = this.tv.getDataSources();
        for (TrackerPeerSource p : peer_sources) {
            int status = p.getStatus();
            if (status != 9 && status != 3 && status != 4) continue;
            return true;
        }
        return false;
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void tableDataSourceChanged(Object newDataSource) {
        DownloadManagerAvailability old_avail = this.availability;
        if (newDataSource == null) {
            this.availability = null;
        } else if (newDataSource instanceof Object[]) {
            Object temp = ((Object[])newDataSource)[0];
            if (!(temp instanceof DownloadManagerAvailability)) return;
            this.availability = (DownloadManagerAvailability)temp;
        } else {
            if (!(newDataSource instanceof DownloadManagerAvailability)) return;
            this.availability = (DownloadManagerAvailability)newDataSource;
        }
        if (old_avail == this.availability) {
            return;
        }
        if (this.tv.isDisposed()) return;
        this.tv.removeAllTableRows();
        if (this.availability == null) return;
        this.addExistingDatasources();
    }

    @Override
    public void tableLifeCycleEventOccurred(TableView tv, int eventType, Map<String, Object> data) {
        switch (eventType) {
            case 0: {
                if (this.availability == null) break;
                this.addExistingDatasources();
            }
        }
    }

    private void addExistingDatasources() {
        if (this.availability == null || this.tv.isDisposed()) {
            return;
        }
        List<TrackerPeerSource> tps = this.availability.getTrackerPeerSources();
        this.tv.addDataSources((TrackerPeerSource[])tps.toArray(new TrackerPeerSource[tps.size()]));
        this.tv.processDataSourceQueueSync();
    }
}

