/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerTPSListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.tracker.TrackerPeerSource;
import com.biglybt.core.tracker.client.TRTrackerAnnouncer;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.plugin.net.buddy.BuddyPluginUtils;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableDataSourceChangedListener;
import com.biglybt.ui.common.table.TableLifeCycleListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableSelectionListener;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.maketorrent.MultiTrackerEditor;
import com.biglybt.ui.swt.maketorrent.TrackerEditorListener;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.views.ScrapeInfoView;
import com.biglybt.ui.swt.views.ViewManagerSWT;
import com.biglybt.ui.swt.views.ViewUtils;
import com.biglybt.ui.swt.views.table.TableSelectedRowsListener;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.TableViewSWTMenuFillListener;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import com.biglybt.ui.swt.views.table.impl.TableViewSWT_TabsCommon;
import com.biglybt.ui.swt.views.table.impl.TableViewTab;
import com.biglybt.ui.swt.views.tableitems.tracker.CompletedItem;
import com.biglybt.ui.swt.views.tableitems.tracker.IntervalItem;
import com.biglybt.ui.swt.views.tableitems.tracker.LastUpdateItem;
import com.biglybt.ui.swt.views.tableitems.tracker.LeechersItem;
import com.biglybt.ui.swt.views.tableitems.tracker.NameItem;
import com.biglybt.ui.swt.views.tableitems.tracker.PeersItem;
import com.biglybt.ui.swt.views.tableitems.tracker.ReportedDownItem;
import com.biglybt.ui.swt.views.tableitems.tracker.ReportedUpItem;
import com.biglybt.ui.swt.views.tableitems.tracker.SeedsItem;
import com.biglybt.ui.swt.views.tableitems.tracker.StatusItem;
import com.biglybt.ui.swt.views.tableitems.tracker.TypeItem;
import com.biglybt.ui.swt.views.tableitems.tracker.UpdateInItem;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class TrackerView
extends TableViewTab<TrackerPeerSource>
implements TableLifeCycleListener,
TableDataSourceChangedListener,
DownloadManagerTPSListener,
TableViewSWTMenuFillListener,
TableSelectionListener,
UIPluginViewToolBarListener {
    public static final Class<TrackerPeerSource> PLUGIN_DS_TYPE = TrackerPeerSource.class;
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new TypeItem("Trackers"), new NameItem("Trackers"), new StatusItem("Trackers"), new PeersItem("Trackers"), new SeedsItem("Trackers"), new LeechersItem("Trackers"), new CompletedItem("Trackers"), new UpdateInItem("Trackers"), new IntervalItem("Trackers"), new LastUpdateItem("Trackers"), new ReportedUpItem("Trackers"), new ReportedDownItem("Trackers")};
    public static final String MSGID_PREFIX = "TrackerView";
    private DownloadManager manager;
    private TableViewSWT<TrackerPeerSource> tv;

    static {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.setDefaultColumnNames("Trackers", basicItems);
    }

    public TrackerView() {
        super(MSGID_PREFIX);
    }

    @Override
    public TableViewSWT<TrackerPeerSource> initYourTableView() {
        TrackerView.registerPluginViews();
        this.tv = TableViewFactory.createTableViewSWT(PLUGIN_DS_TYPE, "Trackers", this.getTextPrefixID(), basicItems, basicItems[0].getName(), 0x10010002);
        this.tv.addLifeCycleListener(this);
        this.tv.addMenuFillListener(this);
        this.tv.addTableDataSourceChangedListener(this, true);
        this.tv.addSelectionListener(this, false);
        this.tv.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 0 && e.keyCode == 127) {
                    TrackerView.removeTrackerPeerSources(TrackerView.this.tv.getSelectedDataSources().toArray());
                    e.doit = false;
                }
            }
        });
        return this.tv;
    }

    private static void removeTrackerPeerSources(Object[] datasources) {
        ArrayList<TrackerPeerSource> list = new ArrayList<TrackerPeerSource>();
        Object[] objectArray = datasources;
        int n = datasources.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof TrackerPeerSource && ((TrackerPeerSource)o).canDelete()) {
                list.add((TrackerPeerSource)o);
            }
            ++n2;
        }
        TrackerView.removeTrackerPeerSources(list);
    }

    private static void removeTrackerPeerSources(List<TrackerPeerSource> list) {
        int numLeft = list.size();
        if (numLeft == 0) {
            return;
        }
        TrackerPeerSource toRemove = list.get(0);
        if (toRemove == null) {
            return;
        }
        MessageBoxShell mb = new MessageBoxShell(MessageText.getString("message.confirm.delete.title"), MessageText.getString("message.confirm.delete.text", new String[]{toRemove.getName()}), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
        if (numLeft > 1) {
            String sDeleteAll = MessageText.getString("v3.deleteContent.applyToAll", new String[]{"" + numLeft});
            mb.addCheckBox("!" + sDeleteAll + "!", 0, false);
        }
        mb.setRememberOnlyIfButton(0);
        mb.setRemember("removeTracker", false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
        mb.open(result -> {
            if (result == -1) {
                return;
            }
            boolean remove = result == 0;
            boolean doAll = mb.getCheckBoxEnabled();
            if (doAll) {
                if (remove) {
                    for (TrackerPeerSource tps : list) {
                        if (!tps.canDelete()) continue;
                        tps.delete();
                    }
                }
            } else {
                if (remove) {
                    toRemove.delete();
                }
                list.remove(0);
                TrackerView.removeTrackerPeerSources(list);
            }
        });
    }

    private static void registerPluginViews() {
        ViewManagerSWT vm = ViewManagerSWT.getInstance();
        if (vm.areCoreViewsRegistered(PLUGIN_DS_TYPE)) {
            return;
        }
        vm.registerView(PLUGIN_DS_TYPE, new UISWTViewBuilderCore("ScrapeInfoView", null, ScrapeInfoView.class));
        vm.setCoreViewsRegistered(PLUGIN_DS_TYPE);
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        boolean found_tracker;
        if (this.tv == null) {
            return;
        }
        final Object[] sources = this.tv.getSelectedDataSources().toArray();
        ArrayList<TrackerPeerSource> found_trackers = new ArrayList<TrackerPeerSource>();
        boolean found_dht_tracker = false;
        boolean found_http_seed = false;
        boolean update_ok = false;
        boolean delete_ok = false;
        Object[] objectArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            TrackerPeerSource ps = (TrackerPeerSource)o;
            int type = ps.getType();
            if (type == 1) {
                found_trackers.add(ps);
            } else if (type == 3) {
                found_dht_tracker = true;
            } else if (type == 2) {
                found_http_seed = true;
            }
            int state = ps.getStatus();
            if ((state == 5 || state == 3 || state == 2 || state == 6) && !ps.isUpdating() && ps.canManuallyUpdate()) {
                update_ok = true;
            }
            if (ps.canDelete()) {
                delete_ok = true;
            }
            ++n2;
        }
        final DownloadManager dm = this.manager;
        boolean needs_sep = false;
        boolean bl = found_tracker = !found_trackers.isEmpty();
        if (found_tracker || found_dht_tracker || found_http_seed) {
            TrackerPeerSource tps;
            if (found_tracker || found_dht_tracker) {
                MenuItem update_item = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)update_item, "GeneralView.label.trackerurlupdate");
                update_item.setEnabled(update_ok);
                update_item.addListener(13, (Listener)new TableSelectedRowsListener(this.tv){

                    @Override
                    public void run(TableRowCore row) {
                        Object[] objectArray = sources;
                        int n = sources.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            TrackerPeerSource ps = (TrackerPeerSource)o;
                            if (ps.canManuallyUpdate()) {
                                ps.manualUpdate();
                            }
                            ++n2;
                        }
                    }
                });
            }
            if (found_tracker) {
                URL url;
                if (dm != null) {
                    boolean clearPeerCache = false;
                    if (!dm.getDownloadState().getTrackerResponseCache().isEmpty()) {
                        clearPeerCache = true;
                    } else {
                        TRTrackerAnnouncer tc = dm.getTrackerClient();
                        if (tc != null && !tc.getTrackerResponseCache().isEmpty()) {
                            clearPeerCache = true;
                        }
                    }
                    MenuItem itemClearPeerCache = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)itemClearPeerCache, "GeneralView.label.clearpeercache");
                    itemClearPeerCache.addListener(13, ev -> dm.getDownloadState().clearTrackerResponseCache());
                    itemClearPeerCache.setEnabled(clearPeerCache);
                }
                MenuItem edit_item = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)edit_item, "MyTorrentsView.menu.editTracker");
                edit_item.addListener(13, (Listener)new TableSelectedRowsListener(this.tv){

                    @Override
                    public boolean run(TableRowCore[] rows) {
                        final TOTorrent torrent = dm.getTorrent();
                        if (torrent != null) {
                            Utils.execSWTThread(new Runnable(){

                                @Override
                                public void run() {
                                    List<List<String>> group = TorrentUtils.announceGroupsToList(torrent);
                                    new MultiTrackerEditor(null, null, group, new TrackerEditorListener(){

                                        @Override
                                        public void trackersChanged(String str, String str2, List<List<String>> _group) {
                                            TorrentUtils.listToAnnounceGroups(_group, torrent);
                                            try {
                                                TorrentUtils.writeToFile(torrent);
                                            }
                                            catch (Throwable e2) {
                                                Debug.printStackTrace(e2);
                                            }
                                            TRTrackerAnnouncer tc = dm.getTrackerClient();
                                            if (tc != null) {
                                                tc.resetTrackerUrl(true);
                                            }
                                        }
                                    }, true, true);
                                }
                            });
                        }
                        return true;
                    }
                });
                String tracker_key = null;
                if (sources.length == 1 && (url = ((TrackerPeerSource)sources[0]).getURL()) != null) {
                    tracker_key = BuddyPluginUtils.getTrackerChatKey(url.toExternalForm());
                }
                MenuBuildUtils.addChatMenu(menu, "menu.discuss.tracker", tracker_key);
                TOTorrent torrent = dm.getTorrent();
                edit_item.setEnabled(torrent != null && !TorrentUtils.isReallyPrivate(torrent));
            }
            if (found_http_seed && dm != null) {
                TorrentUtil.addEditWebseeds(menu, new DownloadManager[]{dm});
            }
            if (found_trackers.size() == 1 && (tps = (TrackerPeerSource)found_trackers.get(0)).getURL() != null) {
                MenuItem allt_item = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)allt_item, "menu.show.in.all.trackers");
                allt_item.addListener(13, ev -> this.showInAllTrackers(tps));
            }
            needs_sep = true;
        }
        if (delete_ok) {
            MenuItem delete_item = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)delete_item, "Button.remove");
            Utils.setMenuItemImage(delete_item, "delete");
            delete_item.addListener(13, event2 -> TrackerView.removeTrackerPeerSources(sources));
            needs_sep = true;
        }
        if (needs_sep) {
            new MenuItem(menu, 2);
        }
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
    }

    @Override
    public void trackerPeerSourcesChanged() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (TrackerView.this.manager == null || TrackerView.this.tv.isDisposed()) {
                    return;
                }
                TrackerView.this.tv.removeAllTableRows();
                TrackerView.this.addExistingDatasources();
            }
        });
    }

    @Override
    public void tableDataSourceChanged(Object newDataSource) {
        DownloadManager newManager = ViewUtils.getDownloadManagerFromDataSource(newDataSource, this.manager);
        if (newManager == this.manager) {
            this.tv.setEnabled(this.manager != null);
            return;
        }
        if (this.manager != null) {
            this.manager.removeTPSListener(this);
        }
        this.manager = newManager;
        if (this.tv.isDisposed()) {
            return;
        }
        this.tv.removeAllTableRows();
        this.tv.setEnabled(this.manager != null);
        if (this.manager != null) {
            this.manager.addTPSListener(this);
            this.addExistingDatasources();
        }
    }

    @Override
    public void tableLifeCycleEventOccurred(TableView tv, int eventType, Map<String, Object> data) {
        switch (eventType) {
            case 0: {
                this.tableViewInitialized();
                break;
            }
            case 1: {
                this.tableViewDestroyed();
            }
        }
    }

    public void tableViewInitialized() {
        if (this.manager != null) {
            this.manager.addTPSListener(this);
            this.addExistingDatasources();
            TableViewSWT_TabsCommon tabs = this.tv.getTabsCommon();
            if (tabs != null) {
                tabs.triggerTabViewsDataSourceChanged(this.tv);
            }
        }
    }

    public void tableViewDestroyed() {
        if (this.manager != null) {
            this.manager.removeTPSListener(this);
        }
    }

    private void addExistingDatasources() {
        if (this.manager == null || this.tv.isDisposed()) {
            return;
        }
        List<TrackerPeerSource> tps = this.manager.getTrackerPeerSources();
        this.tv.addDataSources((TrackerPeerSource[])tps.toArray(new TrackerPeerSource[tps.size()]));
        this.tv.processDataSourceQueueSync();
    }

    protected void updateSelectedContent() {
        if (this.tv == null) {
            return;
        }
        Object[] dataSources = this.tv.getSelectedDataSources(true);
        if (dataSources.length == 0) {
            String id = "DMDetails_Sources";
            if (this.manager != null) {
                id = this.manager.getTorrent() != null ? String.valueOf(id) + "." + this.manager.getInternalName() : String.valueOf(id) + ":" + this.manager.getSize();
                SelectedContentManager.changeCurrentlySelectedContent(id, new SelectedContent[]{new SelectedContent(this.manager)});
            } else {
                SelectedContentManager.changeCurrentlySelectedContent(id, null);
            }
        } else {
            ISelectedContent[] sc = new SelectedContent[dataSources.length];
            int i = 0;
            while (i < sc.length) {
                Object ds = dataSources[i];
                sc[i] = ds instanceof TrackerPeerSource ? new SelectedContent("Source: " + ((TrackerPeerSource)ds).getName()) : new SelectedContent("Source: " + ds);
                ++i;
            }
            SelectedContentManager.changeCurrentlySelectedContent(this.tv.getTableID(), sc, this.tv);
        }
    }

    @Override
    public void deselected(TableRowCore[] rows) {
        this.updateSelectedContent();
    }

    @Override
    public void focusChanged(TableRowCore focus) {
    }

    @Override
    public void selected(TableRowCore[] rows) {
        this.updateSelectedContent();
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        if (rows.length == 1) {
            TrackerPeerSource source = (TrackerPeerSource)rows[0].getDataSource();
            this.showInAllTrackers(source);
        }
    }

    private void showInAllTrackers(TrackerPeerSource source) {
        UIFunctions uif;
        URL url = source.getURL();
        if (url != null && (uif = UIFunctionsManager.getUIFunctions()) != null) {
            uif.getMDI().showEntryByID("AllTrackers", url);
        }
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 3: {
                this.updateSelectedContent();
                break;
            }
            case 4: {
                SelectedContentManager.clearCurrentlySelectedContent();
            }
        }
        return super.eventOccurred(event2);
    }

    @Override
    public boolean isActive() {
        if (this.tv == null || !this.tv.isVisible()) {
            return false;
        }
        return !this.tv.getSelectedDataSources().isEmpty();
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        Object[] datasources;
        if (this.tv == null || !this.tv.isVisible()) {
            return;
        }
        boolean canEnable = false;
        Object[] objectArray = datasources = this.tv.getSelectedDataSources().toArray();
        int n = datasources.length;
        int n2 = 0;
        while (n2 < n) {
            TrackerPeerSource tps;
            Object object = objectArray[n2];
            if (object instanceof TrackerPeerSource && (tps = (TrackerPeerSource)object).canDelete()) {
                canEnable = true;
                break;
            }
            ++n2;
        }
        list.put("remove", canEnable ? 1L : 0L);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        if (this.tv == null || !this.tv.isVisible()) {
            return false;
        }
        if ("remove".equals(item.getID())) {
            TrackerView.removeTrackerPeerSources(this.tv.getSelectedDataSources().toArray());
            return true;
        }
        return false;
    }
}

