/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.graphics.SpeedGraphic;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class ViewDownSpeedGraph
implements UISWTViewCoreEventListener {
    GlobalManager manager = null;
    GlobalManagerStats stats = null;
    Canvas downSpeedCanvas;
    SpeedGraphic downSpeedGraphic;
    TimerEventPeriodic timerEvent;
    private boolean everRefreshed = false;
    private UISWTView swtView;

    public ViewDownSpeedGraph() {
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                ViewDownSpeedGraph.this.manager = core.getGlobalManager();
                ViewDownSpeedGraph.this.stats = ViewDownSpeedGraph.this.manager.getStats();
            }
        });
    }

    private void periodicUpdate() {
        if (this.manager == null || this.stats == null) {
            return;
        }
        int swarms_peer_speed = (int)this.stats.getTotalSwarmsPeerRate(true, false);
        this.downSpeedGraphic.addIntsValue(new int[]{this.stats.getDataReceiveRate() + this.stats.getProtocolReceiveRate(), this.stats.getProtocolReceiveRate(), COConfigurationManager.getIntParameter("Max Download Speed KBs") * DisplayFormatters.getKinB(), swarms_peer_speed});
    }

    private void initialize(Composite composite) {
        composite.setLayout((Layout)Utils.getSimpleGridLayout(1));
        this.downSpeedCanvas = new Canvas(composite, 0x20000000);
        GridData gridData = new GridData(1808);
        this.downSpeedCanvas.setLayoutData((Object)gridData);
        this.downSpeedGraphic = SpeedGraphic.getInstance();
        this.downSpeedGraphic.initialize(this.downSpeedCanvas);
    }

    private void delete() {
        Utils.disposeComposite((Composite)this.downSpeedCanvas);
        if (this.downSpeedGraphic != null) {
            this.downSpeedGraphic.dispose();
        }
    }

    private String getFullTitle() {
        return MessageText.getString("TableColumn.header.downspeed");
    }

    private Composite getComposite() {
        return this.downSpeedCanvas;
    }

    private void refresh() {
        if (this.downSpeedGraphic == null) {
            return;
        }
        if (!this.everRefreshed) {
            this.everRefreshed = true;
            this.timerEvent = SimpleTimer.addPeriodicEvent("TopBarSpeedGraphicView", 1000L, new TimerEventPerformer(){

                @Override
                public void perform(TimerEvent event2) {
                    if (ViewDownSpeedGraph.this.downSpeedCanvas.isDisposed()) {
                        ViewDownSpeedGraph.this.timerEvent.cancel();
                    } else if (Utils.isUIUpdateEnabled()) {
                        ViewDownSpeedGraph.this.periodicUpdate();
                    }
                }
            });
        }
        this.downSpeedGraphic.refresh(false);
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = event2.getView();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }
}

