/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreLifecycleAdapter;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.ui.config.ConfigSectionStartShutdown;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BufferedLabel;
import com.biglybt.ui.swt.config.FileSwtParameter;
import com.biglybt.ui.swt.config.IntSwtParameter;
import com.biglybt.ui.swt.config.ParameterChangeListener;
import com.biglybt.ui.swt.config.StringListSwtParameter;
import com.biglybt.ui.swt.config.SwtParameter;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class ViewQuickConfig
implements UISWTViewCoreEventListener {
    private UISWTView swtView;
    Composite composite;

    public ViewQuickConfig() {
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
            }
        });
    }

    private void initialize(Composite oparent) {
        GridLayout layout = Utils.getSimpleGridLayout(1);
        oparent.setLayout((Layout)layout);
        Composite parent = new Composite(oparent, 0);
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        this.composite = Utils.createScrolledComposite(parent);
        gridData = new GridData(1808);
        this.composite.setLayoutData((Object)gridData);
        layout = new GridLayout(4, false);
        this.composite.setLayout((Layout)layout);
        ViewQuickConfig.addDoneDownloadingOption(this.composite, false);
        Label label = new Label(this.composite, 0);
        gridData = new GridData();
        gridData.horizontalIndent = 8;
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "ConfigView.label.maxdownloads.short");
        IntSwtParameter maxDLs = new IntSwtParameter(this.composite, "max downloads", null, null, null);
        maxDLs.addChangeListener(p -> COConfigurationManager.setDirty());
        this.addTemporaryRates(this.composite);
        this.addTemporaryData(this.composite);
    }

    private void addTemporaryRates(final Composite composite) {
        Group temp_rates = Utils.createSkinnedGroup(composite, 0);
        Messages.setLanguageText((Widget)temp_rates, "label.temporary.rates");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        temp_rates.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(10, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        temp_rates.setLayout((Layout)layout);
        Label label = new Label((Composite)temp_rates, 0);
        gridData = new GridData();
        gridData.horizontalIndent = 4;
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "label.upload.kbps", DisplayFormatters.getRateUnit(1));
        final IntSwtParameter tempULRate = new IntSwtParameter((Composite)temp_rates, "global.download.rate.temp.kbps", null, null, 0, Integer.MAX_VALUE, null);
        label = new Label((Composite)temp_rates, 0);
        Messages.setLanguageText((Widget)label, "label.download.kbps", DisplayFormatters.getRateUnit(1));
        final IntSwtParameter tempDLRate = new IntSwtParameter((Composite)temp_rates, "global.upload.rate.temp.kbps", null, null, 0, Integer.MAX_VALUE, null);
        label = new Label((Composite)temp_rates, 0);
        Messages.setLanguageText((Widget)label, "label.duration.mins");
        final IntSwtParameter tempMins = new IntSwtParameter((Composite)temp_rates, "global.rate.temp.min", null, null, 0, Integer.MAX_VALUE, null);
        final Button activate = new Button((Composite)temp_rates, 2);
        Messages.setLanguageText((Widget)activate, "label.activate");
        final BufferedLabel remLabel = new BufferedLabel((Composite)temp_rates, 0x20000000);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        remLabel.setLayoutData(gridData);
        activate.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private CoreLifecycleAdapter listener;
            private TimerEventPeriodic event;
            private boolean auto_up_enabled;
            private boolean auto_up_seeding_enabled;
            private boolean seeding_limits_enabled;
            private int up_limit;
            private int down_limit;
            private long end_time;

            public void widgetSelected(SelectionEvent e) {
                if (activate.getSelection()) {
                    this.listener = new CoreLifecycleAdapter(){

                        @Override
                        public void stopping(Core core) {
                            this.deactivate(true);
                        }
                    };
                    CoreFactory.getSingleton().addLifecycleListener(this.listener);
                    Messages.setLanguageText((Widget)activate, "FileView.BlockView.Active");
                    tempDLRate.setEnabled(false);
                    tempULRate.setEnabled(false);
                    tempMins.setEnabled(false);
                    this.auto_up_enabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Enabled");
                    this.auto_up_seeding_enabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Seeding Enabled");
                    this.seeding_limits_enabled = COConfigurationManager.getBooleanParameter("enable.seedingonly.upload.rate");
                    this.up_limit = COConfigurationManager.getIntParameter("Max Upload Speed KBs");
                    this.down_limit = COConfigurationManager.getIntParameter("Max Download Speed KBs");
                    COConfigurationManager.setParameter("Auto Upload Speed Enabled", false);
                    COConfigurationManager.setParameter("Auto Upload Speed Seeding Enabled", false);
                    COConfigurationManager.setParameter("enable.seedingonly.upload.rate", false);
                    COConfigurationManager.setParameter("Max Upload Speed KBs", (Integer)tempULRate.getValue());
                    COConfigurationManager.setParameter("Max Download Speed KBs", (Integer)tempDLRate.getValue());
                    this.end_time = SystemTime.getCurrentTime() + (long)((Integer)tempMins.getValue() * 60 * 1000);
                    this.event = SimpleTimer.addPeriodicEvent("TempRates", 1000L, new TimerEventPerformer(){

                        @Override
                        public void perform(TimerEvent e) {
                            Utils.execSWTThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (event == null) {
                                        return;
                                    }
                                    long now = SystemTime.getCurrentTime();
                                    long rem = end_time - now;
                                    if (rem < 1000L || composite.isDisposed()) {
                                        this.deactivate(false);
                                    } else {
                                        remLabel.setText(String.valueOf(MessageText.getString("TableColumn.header.remaining")) + ": " + DisplayFormatters.formatTime(rem));
                                    }
                                }
                            });
                        }
                    });
                } else {
                    this.deactivate(false);
                }
            }

            private void deactivate(boolean closing) {
                COConfigurationManager.setParameter("Auto Upload Speed Enabled", this.auto_up_enabled);
                COConfigurationManager.setParameter("Auto Upload Speed Seeding Enabled", this.auto_up_seeding_enabled);
                COConfigurationManager.setParameter("enable.seedingonly.upload.rate", this.seeding_limits_enabled);
                COConfigurationManager.setParameter("Max Upload Speed KBs", this.up_limit);
                COConfigurationManager.setParameter("Max Download Speed KBs", this.down_limit);
                if (!closing) {
                    if (this.listener != null) {
                        CoreFactory.getSingleton().removeLifecycleListener(this.listener);
                        this.listener = null;
                    }
                    if (!composite.isDisposed()) {
                        Messages.setLanguageText((Widget)activate, "label.activate");
                        activate.setSelection(false);
                        tempDLRate.setEnabled(true);
                        tempULRate.setEnabled(true);
                        tempMins.setEnabled(true);
                        remLabel.setText("");
                    }
                }
                if (this.event != null) {
                    this.event.cancel();
                    this.event = null;
                }
            }
        });
        tempMins.addAndFireChangeListener(p -> {
            boolean bl = Utils.execSWTThread(() -> activate.setEnabled((Integer)p.getValue() > 0));
        });
    }

    private void addTemporaryData(final Composite composite) {
        final Group temp_rates = Utils.createSkinnedGroup(composite, 0);
        Messages.setLanguageText((Widget)temp_rates, "label.temporary.data");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        temp_rates.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(10, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        temp_rates.setLayout((Layout)layout);
        Label label = new Label((Composite)temp_rates, 0);
        gridData = new GridData();
        gridData.horizontalIndent = 4;
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "label.upload.mb", DisplayFormatters.getUnit(2));
        final IntSwtParameter tempULLimit = new IntSwtParameter((Composite)temp_rates, "global.upload.limit.temp.mb", null, null, 0, Integer.MAX_VALUE, null);
        label = new Label((Composite)temp_rates, 0);
        Messages.setLanguageText((Widget)label, "label.download.mb", DisplayFormatters.getUnit(2));
        final IntSwtParameter tempDLLimit = new IntSwtParameter((Composite)temp_rates, "global.download.limit.temp.mb", null, null, 0, Integer.MAX_VALUE, null);
        final Button activate = new Button((Composite)temp_rates, 2);
        Messages.setLanguageText((Widget)activate, "label.activate");
        final BufferedLabel remLabel = new BufferedLabel((Composite)temp_rates, 0x20000000);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        remLabel.setLayoutData(gridData);
        activate.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private CoreLifecycleAdapter listener;
            private TimerEventPeriodic event;
            private long end_upload;
            private long end_download;

            public void widgetSelected(SelectionEvent e) {
                if (activate.getSelection()) {
                    this.listener = new CoreLifecycleAdapter(){

                        @Override
                        public void stopping(Core core) {
                            this.deactivate(true);
                        }
                    };
                    final Core core = CoreFactory.getSingleton();
                    core.addLifecycleListener(this.listener);
                    Messages.setLanguageText((Widget)activate, "FileView.BlockView.Active");
                    final GlobalManagerStats stats2 = core.getGlobalManager().getStats();
                    tempULLimit.setEnabled(false);
                    tempDLLimit.setEnabled(false);
                    long u_limit = ((Integer)tempULLimit.getValue()).intValue();
                    this.end_upload = u_limit > 0L ? stats2.getTotalDataProtocolBytesSent() + u_limit * DisplayFormatters.getMinB() : 0L;
                    long d_limit = ((Integer)tempDLLimit.getValue()).intValue();
                    this.end_download = d_limit > 0L ? stats2.getTotalDataProtocolBytesReceived() + d_limit * DisplayFormatters.getMinB() : 0L;
                    this.event = SimpleTimer.addPeriodicEvent("TempData", 5000L, new TimerEventPerformer(){

                        @Override
                        public void perform(TimerEvent e) {
                            Utils.execSWTThread(new Runnable(){

                                @Override
                                public void run() {
                                    int state;
                                    List<DownloadManager> dms;
                                    if (event == null) {
                                        return;
                                    }
                                    long rem_up = 0L;
                                    long rem_down = 0L;
                                    if (end_upload > 0L) {
                                        rem_up = end_upload - stats2.getTotalDataProtocolBytesSent();
                                    }
                                    if (end_download > 0L) {
                                        rem_down = end_download - stats2.getTotalDataProtocolBytesReceived();
                                    }
                                    if (end_upload > 0L && rem_up <= 0L) {
                                        dms = core.getGlobalManager().getDownloadManagers();
                                        for (DownloadManager dm : dms) {
                                            if (dm.isForceStart() || (state = dm.getState()) == 70 || state == 100 || dm.isPaused()) continue;
                                            ManagerUtils.stop(dm, null);
                                            dm.setStopReason(MessageText.getString("label.temporary.data"));
                                        }
                                    }
                                    if (end_download > 0L && rem_down <= 0L) {
                                        dms = core.getGlobalManager().getDownloadManagers();
                                        for (DownloadManager dm : dms) {
                                            if (dm.isForceStart() || (state = dm.getState()) == 70 || state == 100 || dm.isPaused() || dm.isDownloadComplete(false)) continue;
                                            ManagerUtils.stop(dm, null);
                                            dm.setStopReason(MessageText.getString("label.temporary.data"));
                                        }
                                    }
                                    if (rem_up <= 0L && rem_down <= 0L || composite.isDisposed()) {
                                        this.deactivate(false);
                                    } else {
                                        remLabel.setText(String.valueOf(MessageText.getString("TableColumn.header.remaining")) + ": " + DisplayFormatters.formatByteCountToKiBEtc(rem_up < 0L ? 0L : rem_up) + "/" + DisplayFormatters.formatByteCountToKiBEtc(rem_down < 0L ? 0L : rem_down));
                                        temp_rates.layout(new Control[]{remLabel.getControl()});
                                    }
                                }
                            });
                        }
                    });
                } else {
                    this.deactivate(false);
                }
            }

            private void deactivate(boolean closing) {
                if (!closing) {
                    if (this.listener != null) {
                        CoreFactory.getSingleton().removeLifecycleListener(this.listener);
                        this.listener = null;
                    }
                    if (!composite.isDisposed()) {
                        Messages.setLanguageText((Widget)activate, "label.activate");
                        activate.setSelection(false);
                        tempULLimit.setEnabled(true);
                        tempDLLimit.setEnabled(true);
                        remLabel.setText("");
                        temp_rates.layout(true);
                    }
                }
                if (this.event != null) {
                    this.event.cancel();
                    this.event = null;
                }
            }
        });
        activate.setEnabled((Integer)tempULLimit.getValue() > 0 || (Integer)tempDLLimit.getValue() > 0);
        ParameterChangeListener<SwtParameter> adapter = p -> {
            boolean bl = Utils.execSWTThread(() -> activate.setEnabled((Integer)tempULLimit.getValue() > 0 || (Integer)tempDLLimit.getValue() > 0));
        };
        tempULLimit.addChangeListener(adapter);
        tempDLLimit.addChangeListener(adapter);
    }

    private void delete() {
        Utils.disposeComposite(this.composite);
    }

    private String getFullTitle() {
        return MessageText.getString("label.quick.config");
    }

    private Composite getComposite() {
        return this.composite;
    }

    private void refresh() {
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = event2.getView();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    public static void addDoneDownloadingOption(Composite comp2, boolean include_script_setting) {
        String[][] action_details = ConfigSectionStartShutdown.getActionDetails(false);
        StringListSwtParameter dc = new StringListSwtParameter(comp2, "On Downloading Complete Do", "ConfigView.label.stop.downcomp", null, action_details[1], action_details[0], true, null);
        if (include_script_setting) {
            FileSwtParameter dc_script = new FileSwtParameter(comp2, "On Downloading Complete Script", "label.script.to.run", new String[0], null);
            boolean is_script = ((String)dc.getValue()).startsWith("RunScript");
            dc_script.setEnabled(is_script);
            dc.addChangeListener(p -> dc_script.setEnabled(((String)dc.getValue()).startsWith("RunScript")));
        }
    }
}

