/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.impl.TransferSpeedValidator;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.graphics.SpeedGraphic;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class ViewUpSpeedGraph
implements UISWTViewCoreEventListener {
    GlobalManager manager = null;
    GlobalManagerStats stats = null;
    Canvas upSpeedCanvas;
    SpeedGraphic upSpeedGraphic;
    TimerEventPeriodic timerEvent;
    private boolean everRefreshed = false;
    private UISWTView swtView;

    public ViewUpSpeedGraph() {
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                ViewUpSpeedGraph.this.manager = core.getGlobalManager();
                ViewUpSpeedGraph.this.stats = ViewUpSpeedGraph.this.manager.getStats();
            }
        });
    }

    private void initialize(Composite composite) {
        composite.setLayout((Layout)Utils.getSimpleGridLayout(1));
        this.upSpeedCanvas = new Canvas(composite, 0x20000000);
        GridData gridData = new GridData(1808);
        this.upSpeedCanvas.setLayoutData((Object)gridData);
        this.upSpeedGraphic = SpeedGraphic.getInstance();
        this.upSpeedGraphic.initialize(this.upSpeedCanvas);
    }

    private void periodicUpdate() {
        if (this.stats == null || this.manager == null) {
            return;
        }
        int swarms_peer_speed = (int)this.stats.getTotalSwarmsPeerRate(true, false);
        this.upSpeedGraphic.addIntsValue(new int[]{this.stats.getDataSendRate() + this.stats.getProtocolSendRate(), this.stats.getProtocolSendRate(), COConfigurationManager.getIntParameter(TransferSpeedValidator.getActiveUploadParameter(this.manager)) * DisplayFormatters.getKinB(), swarms_peer_speed});
    }

    private void delete() {
        Utils.disposeComposite((Composite)this.upSpeedCanvas);
        if (this.upSpeedGraphic != null) {
            this.upSpeedGraphic.dispose();
        }
    }

    private String getFullTitle() {
        return MessageText.getString("TableColumn.header.upspeed");
    }

    private Composite getComposite() {
        return this.upSpeedCanvas;
    }

    private void refresh() {
        if (this.upSpeedGraphic == null) {
            return;
        }
        if (!this.everRefreshed) {
            this.everRefreshed = true;
            this.timerEvent = SimpleTimer.addPeriodicEvent("TopBarSpeedGraphicView", 1000L, new TimerEventPerformer(){

                @Override
                public void perform(TimerEvent event2) {
                    if (ViewUpSpeedGraph.this.upSpeedCanvas.isDisposed()) {
                        ViewUpSpeedGraph.this.timerEvent.cancel();
                    } else if (Utils.isUIUpdateEnabled()) {
                        ViewUpSpeedGraph.this.periodicUpdate();
                    }
                }
            });
        }
        this.upSpeedGraphic.refresh(false);
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }
}

