/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.clientstats;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerPeerListener;
import com.biglybt.core.global.GlobalManagerListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerListener;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.impl.PEPeerTransport;
import com.biglybt.core.peermanager.peerdb.PeerItem;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.bloom.BloomFilter;
import com.biglybt.core.util.bloom.BloomFilterFactory;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnCreationListener;
import com.biglybt.pif.ui.tables.TableManager;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableLifeCycleListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.table.TableViewFilterCheck;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BubbleTextBox;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.views.clientstats.ClientStatsDataSource;
import com.biglybt.ui.swt.views.clientstats.ClientStatsOverall;
import com.biglybt.ui.swt.views.clientstats.ColumnCS_Count;
import com.biglybt.ui.swt.views.clientstats.ColumnCS_Discarded;
import com.biglybt.ui.swt.views.clientstats.ColumnCS_Name;
import com.biglybt.ui.swt.views.clientstats.ColumnCS_Pct;
import com.biglybt.ui.swt.views.clientstats.ColumnCS_Received;
import com.biglybt.ui.swt.views.clientstats.ColumnCS_ReceivedPer;
import com.biglybt.ui.swt.views.clientstats.ColumnCS_Sent;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import com.biglybt.ui.swt.views.table.impl.TableViewTab;
import com.biglybt.util.MapUtils;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class ClientStatsView
extends TableViewTab<ClientStatsDataSource>
implements TableLifeCycleListener,
GlobalManagerListener,
DownloadManagerPeerListener,
TableViewFilterCheck<ClientStatsDataSource> {
    private static final String CONFIG_FILE = "ClientStats.dat";
    private static final String CONFIG_FILE_ARCHIVE = "ClientStats_%1.dat";
    private static final int BLOOMFILTER_SIZE = 100000;
    private static final int BLOOMFILTER_PEERID_SIZE = 50000;
    private static final String TABLEID = "ClientStats";
    private Core core;
    private TableViewSWT<ClientStatsDataSource> tv;
    private boolean columnsAdded;
    private final Map<String, ClientStatsDataSource> mapData = new HashMap<String, ClientStatsDataSource>();
    private Composite parent;
    private BloomFilter bloomFilter;
    private BloomFilter bloomFilterPeerId;
    private ClientStatsOverall overall;
    private long startedListeningOn;
    private long totalTime;
    private long lastAdd;
    private GregorianCalendar calendar = new GregorianCalendar();
    private int lastAddMonth;
    private static boolean registered = false;

    public ClientStatsView() {
        super(TABLEID);
        this.initAndLoad();
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                ClientStatsView.this.initColumns(core);
                ClientStatsView.this.register(core);
            }
        });
    }

    @Override
    public Composite initComposite(Composite composite) {
        Composite parent = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        Layout compositeLayout = composite.getLayout();
        if (compositeLayout instanceof GridLayout) {
            parent.setLayoutData((Object)new GridData(4, 4, true, true));
        } else if (compositeLayout instanceof FormLayout) {
            parent.setLayoutData((Object)Utils.getFilledFormData());
        }
        Composite cTop = new Composite(parent, 0);
        cTop.setLayoutData((Object)new GridData(4, 1, true, false));
        cTop.setLayout((Layout)new FormLayout());
        Button btnCopy = new Button(cTop, 8);
        Messages.setLanguageText((Widget)btnCopy, "label.copy");
        btnCopy.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TableRowCore[] rows = ClientStatsView.this.tv.getRows();
                StringBuilder sb = new StringBuilder();
                sb.append(new SimpleDateFormat("MMM yyyy").format(new Date()));
                sb.append("\n");
                sb.append("Hits,Client,Bytes Sent,Bytes Received,Bad Bytes\n");
                TableRowCore[] tableRowCoreArray = rows;
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    TableRowCore row = tableRowCoreArray[n2];
                    ClientStatsDataSource stat = (ClientStatsDataSource)row.getDataSource();
                    if (stat != null) {
                        sb.append(stat.count);
                        sb.append(",");
                        sb.append(stat.client.replaceAll(",", ""));
                        sb.append(",");
                        sb.append(stat.bytesSent);
                        sb.append(",");
                        sb.append(stat.bytesReceived);
                        sb.append(",");
                        sb.append(stat.bytesDiscarded);
                        sb.append("\n");
                    }
                    ++n2;
                }
                ClipboardCopy.copyToClipBoard(sb.toString());
            }
        });
        Button btnCopyShort = new Button(cTop, 8);
        btnCopyShort.setText(String.valueOf(MessageText.getString("label.copy")) + " > 1%");
        btnCopyShort.addListener(13, new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(Event event2) {
                ClientStatsDataSource stat;
                ClientStatsDataSource[] stats2;
                StringBuilder sb = new StringBuilder();
                sb.append(new SimpleDateFormat("MMM ''yy").format(new Date()));
                sb.append("] ");
                sb.append(((ClientStatsView)ClientStatsView.this).overall.count);
                sb.append(": ");
                Map map = ClientStatsView.this.mapData;
                synchronized (map) {
                    stats2 = ClientStatsView.this.mapData.values().toArray(new ClientStatsDataSource[0]);
                }
                Arrays.sort(stats2, new Comparator<ClientStatsDataSource>(){

                    @Override
                    public int compare(ClientStatsDataSource o1, ClientStatsDataSource o2) {
                        if (o1.count == o2.count) {
                            return 0;
                        }
                        return o1.count > o2.count ? -1 : 1;
                    }
                });
                boolean first = true;
                ClientStatsDataSource[] clientStatsDataSourceArray = stats2;
                int n = stats2.length;
                int n2 = 0;
                while (n2 < n) {
                    ClientStatsDataSource stat2 = clientStatsDataSourceArray[n2];
                    int pct = (int)((long)(stat2.count * 1000) / ((ClientStatsView)ClientStatsView.this).overall.count);
                    if (pct >= 10) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(", ");
                        }
                        sb.append(DisplayFormatters.formatPercentFromThousands(pct));
                        sb.append(" ");
                        sb.append(stat2.client);
                    }
                    ++n2;
                }
                Arrays.sort(stats2, new Comparator<ClientStatsDataSource>(){

                    @Override
                    public int compare(ClientStatsDataSource o1, ClientStatsDataSource o2) {
                        float v1 = (float)o1.bytesReceived / (float)o1.count;
                        float v2 = (float)o2.bytesReceived / (float)o2.count;
                        if (v1 == v2) {
                            return 0;
                        }
                        return v1 > v2 ? -1 : 1;
                    }
                });
                int top = 5;
                first = true;
                sb.append("\nBest Seeders (");
                long total = 0L;
                ClientStatsDataSource[] clientStatsDataSourceArray2 = stats2;
                int n3 = stats2.length;
                int n4 = 0;
                while (n4 < n3) {
                    stat = clientStatsDataSourceArray2[n4];
                    total += stat.bytesReceived;
                    ++n4;
                }
                sb.append(DisplayFormatters.formatByteCountToKiBEtc(total, false, true, 0));
                sb.append(" Downloaded): ");
                clientStatsDataSourceArray2 = stats2;
                n3 = stats2.length;
                n4 = 0;
                while (n4 < n3) {
                    stat = clientStatsDataSourceArray2[n4];
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(DisplayFormatters.formatByteCountToKiBEtc(stat.bytesReceived / (long)stat.count, false, true, 0));
                    sb.append(" per ");
                    sb.append(stat.client);
                    sb.append("(x");
                    sb.append(stat.count);
                    sb.append(")");
                    if (--top <= 0) break;
                    ++n4;
                }
                Arrays.sort(stats2, new Comparator<ClientStatsDataSource>(){

                    @Override
                    public int compare(ClientStatsDataSource o1, ClientStatsDataSource o2) {
                        float v1 = (float)o1.bytesDiscarded / (float)o1.count;
                        float v2 = (float)o2.bytesDiscarded / (float)o2.count;
                        if (v1 == v2) {
                            return 0;
                        }
                        return v1 > v2 ? -1 : 1;
                    }
                });
                top = 5;
                first = true;
                sb.append("\nMost Discarded (");
                total = 0L;
                clientStatsDataSourceArray2 = stats2;
                n3 = stats2.length;
                n4 = 0;
                while (n4 < n3) {
                    stat = clientStatsDataSourceArray2[n4];
                    total += stat.bytesDiscarded;
                    ++n4;
                }
                sb.append(DisplayFormatters.formatByteCountToKiBEtc(total, false, true, 0));
                sb.append(" Discarded): ");
                clientStatsDataSourceArray2 = stats2;
                n3 = stats2.length;
                n4 = 0;
                while (n4 < n3) {
                    stat = clientStatsDataSourceArray2[n4];
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(DisplayFormatters.formatByteCountToKiBEtc(stat.bytesDiscarded / (long)stat.count, false, true, 0));
                    sb.append(" per ");
                    sb.append(stat.client);
                    sb.append("(x");
                    sb.append(stat.count);
                    sb.append(")");
                    if (--top <= 0) break;
                    ++n4;
                }
                Arrays.sort(stats2, new Comparator<ClientStatsDataSource>(){

                    @Override
                    public int compare(ClientStatsDataSource o1, ClientStatsDataSource o2) {
                        float v1 = (float)o1.bytesSent / (float)o1.count;
                        float v2 = (float)o2.bytesSent / (float)o2.count;
                        if (v1 == v2) {
                            return 0;
                        }
                        return v1 > v2 ? -1 : 1;
                    }
                });
                top = 5;
                first = true;
                sb.append("\nMost Fed (");
                total = 0L;
                clientStatsDataSourceArray2 = stats2;
                n3 = stats2.length;
                n4 = 0;
                while (n4 < n3) {
                    stat = clientStatsDataSourceArray2[n4];
                    total += stat.bytesSent;
                    ++n4;
                }
                sb.append(DisplayFormatters.formatByteCountToKiBEtc(total, false, true, 0));
                sb.append(" Sent): ");
                clientStatsDataSourceArray2 = stats2;
                n3 = stats2.length;
                n4 = 0;
                while (n4 < n3) {
                    stat = clientStatsDataSourceArray2[n4];
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(DisplayFormatters.formatByteCountToKiBEtc(stat.bytesSent / (long)stat.count, false, true, 0));
                    sb.append(" per ");
                    sb.append(stat.client);
                    sb.append("(x");
                    sb.append(stat.count);
                    sb.append(")");
                    if (--top <= 0) break;
                    ++n4;
                }
                ClipboardCopy.copyToClipBoard(sb.toString());
            }
        });
        BubbleTextBox bubbleTextBox = new BubbleTextBox(cTop, 2948);
        FormData fd = new FormData();
        btnCopy.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)btnCopy, 5);
        btnCopyShort.setLayoutData((Object)fd);
        fd = Utils.getFilledFormData();
        fd.width = 150;
        fd.top = null;
        fd.left = null;
        bubbleTextBox.setMessageAndLayout(String.valueOf(MessageText.getString("Button.search")) + "...", fd);
        this.tv.enableFilterCheck(bubbleTextBox, this, true);
        Composite tableParent = new Composite(parent, 0);
        tableParent.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        tableParent.setLayout((Layout)gridLayout);
        parent.setTabList(new Control[]{tableParent, cTop});
        return tableParent;
    }

    @Override
    public void tableViewTabInitComplete() {
    }

    @Override
    public TableViewSWT<ClientStatsDataSource> initYourTableView() {
        this.tv = TableViewFactory.createTableViewSWT(ClientStatsDataSource.class, TABLEID, this.getTextPrefixID(), new TableColumnCore[0], "count", 0x10010002);
        this.tv.addLifeCycleListener(this);
        return this.tv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumns(Core core) {
        Class<ClientStatsView> clazz = ClientStatsView.class;
        synchronized (ClientStatsView.class) {
            if (this.columnsAdded) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.columnsAdded = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            UIManager uiManager = PluginInitializer.getDefaultInterface().getUIManager();
            TableManager tableManager = uiManager.getTableManager();
            tableManager.registerColumn(ClientStatsDataSource.class, "name", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnCS_Name(column);
                }
            });
            tableManager.registerColumn(ClientStatsDataSource.class, "count", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnCS_Count(column);
                }
            });
            tableManager.registerColumn(ClientStatsDataSource.class, "discarded", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnCS_Discarded(column);
                }
            });
            tableManager.registerColumn(ClientStatsDataSource.class, "received", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnCS_Received(column);
                }
            });
            tableManager.registerColumn(ClientStatsDataSource.class, "received.per", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnCS_ReceivedPer(column);
                }
            });
            tableManager.registerColumn(ClientStatsDataSource.class, "sent", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnCS_Sent(column);
                }
            });
            tableManager.registerColumn(ClientStatsDataSource.class, "percent", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnCS_Pct(column);
                }
            });
            String[] stringArray = AENetworkClassifier.AT_NETWORKS;
            int n = AENetworkClassifier.AT_NETWORKS.length;
            int n2 = 0;
            while (n2 < n) {
                final String network = stringArray[n2];
                tableManager.registerColumn(ClientStatsDataSource.class, String.valueOf(network) + "." + "sent", new TableColumnCreationListener(){

                    @Override
                    public void tableColumnCreated(TableColumn column) {
                        column.setUserData("network", network);
                        new ColumnCS_Sent(column);
                    }
                });
                tableManager.registerColumn(ClientStatsDataSource.class, String.valueOf(network) + "." + "discarded", new TableColumnCreationListener(){

                    @Override
                    public void tableColumnCreated(TableColumn column) {
                        column.setUserData("network", network);
                        new ColumnCS_Discarded(column);
                    }
                });
                tableManager.registerColumn(ClientStatsDataSource.class, String.valueOf(network) + "." + "received", new TableColumnCreationListener(){

                    @Override
                    public void tableColumnCreated(TableColumn column) {
                        column.setUserData("network", network);
                        new ColumnCS_Received(column);
                    }
                });
                tableManager.registerColumn(ClientStatsDataSource.class, String.valueOf(network) + "." + "count", new TableColumnCreationListener(){

                    @Override
                    public void tableColumnCreated(TableColumn column) {
                        column.setUserData("network", network);
                        new ColumnCS_Count(column);
                    }
                });
                ++n2;
            }
            TableColumnManager tcManager = TableColumnManager.getInstance();
            tcManager.setDefaultColumnNames(TABLEID, new String[]{"name", "percent", "count", "received", "sent", "discarded"});
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAndLoad() {
        Map<String, ClientStatsDataSource> map = this.mapData;
        synchronized (map) {
            Map map2 = FileUtil.readResilientConfigFile(CONFIG_FILE);
            this.totalTime = MapUtils.getMapLong(map2, "time", 0L);
            this.lastAdd = MapUtils.getMapLong(map2, "lastadd", 0L);
            if (this.lastAdd != 0L) {
                this.calendar.setTimeInMillis(this.lastAdd);
                this.lastAddMonth = this.calendar.get(2);
                Map mapBloom = MapUtils.getMapMap(map2, "bloomfilter", null);
                if (mapBloom != null) {
                    this.bloomFilter = BloomFilterFactory.deserialiseFromMap(mapBloom);
                }
                if ((mapBloom = MapUtils.getMapMap(map2, "bloomfilterPeerId", null)) != null) {
                    this.bloomFilterPeerId = BloomFilterFactory.deserialiseFromMap(mapBloom);
                }
            }
            if (this.bloomFilter == null) {
                this.bloomFilter = BloomFilterFactory.createRotating(BloomFilterFactory.createAddOnly(100000), 2);
            }
            if (this.bloomFilterPeerId == null) {
                this.bloomFilterPeerId = BloomFilterFactory.createRotating(BloomFilterFactory.createAddOnly(50000), 2);
            }
            this.overall = new ClientStatsOverall();
            List listSavedData = MapUtils.getMapList(map2, "data", null);
            if (listSavedData != null) {
                for (Object val : listSavedData) {
                    try {
                        Map mapVal = (Map)val;
                        if (mapVal == null) continue;
                        ClientStatsDataSource ds = new ClientStatsDataSource(mapVal);
                        ds.overall = this.overall;
                        if (this.mapData.containsKey(ds.client)) continue;
                        this.mapData.put(ds.client, ds);
                        this.overall.count += (long)ds.count;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public boolean filterCheck(ClientStatsDataSource ds, String filter2, boolean regex, boolean confusable) {
        if (confusable) {
            return false;
        }
        try {
            Pattern pattern;
            String name = ds.client;
            String s = regex ? filter2 : RegExUtil.splitAndQuote(filter2, "\\s*[|;]\\s*");
            boolean match_result = true;
            if (regex && s.startsWith("!")) {
                s = s.substring(1);
                match_result = false;
            }
            return (pattern = RegExUtil.getCachedPattern("csv:search", s, 66)).matcher(name).find() == match_result;
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public void filterSet(String filter2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String filename) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<String, ClientStatsDataSource> map2 = this.mapData;
        synchronized (map2) {
            map.put("data", new ArrayList<ClientStatsDataSource>(this.mapData.values()));
            map.put("bloomfilter", this.bloomFilter.serialiseToMap());
            map.put("bloomfilterPeerId", this.bloomFilterPeerId.serialiseToMap());
            map.put("lastadd", SystemTime.getCurrentTime());
            if (this.startedListeningOn > 0L) {
                map.put("time", this.totalTime + (SystemTime.getCurrentTime() - this.startedListeningOn));
            } else {
                map.put("time", this.totalTime);
            }
        }
        FileUtil.writeResilientConfigFile(filename, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableLifeCycleEventOccurred(TableView tv, int eventype, Map<String, Object> data) {
        switch (eventype) {
            case 0: {
                Map<String, ClientStatsDataSource> map = this.mapData;
                synchronized (map) {
                    if (this.mapData.values().size() > 0) {
                        tv.addDataSources(this.mapData.values().toArray(new ClientStatsDataSource[0]));
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(Core core) {
        this.core = core;
        if (registered) {
            return;
        }
        core.getGlobalManager().addListener(this);
        Map<String, ClientStatsDataSource> map = this.mapData;
        synchronized (map) {
            this.startedListeningOn = SystemTime.getCurrentTime();
        }
        registered = true;
    }

    @Override
    public void destroyInitiated() {
        if (this.core == null) {
            return;
        }
        this.core.getGlobalManager().removeListener(this);
        List<DownloadManager> downloadManagers = this.core.getGlobalManager().getDownloadManagers();
        for (DownloadManager object : downloadManagers) {
            object.removePeerListener(this);
        }
        registered = false;
        this.save(CONFIG_FILE);
    }

    @Override
    public void destroyed() {
    }

    @Override
    public void downloadManagerAdded(DownloadManager dm) {
        if (!dm.getDownloadState().getFlag(16L)) {
            dm.addPeerListener(this, true);
        }
    }

    @Override
    public void downloadManagerRemoved(DownloadManager dm) {
        dm.removePeerListener(this);
    }

    @Override
    public void seedingStatusChanged(boolean seedingOnlyMode, boolean potentiallySeedingOnlyMode) {
    }

    @Override
    public void peerAdded(PEPeer peer) {
        peer.addListener(new PEPeerListener(){

            @Override
            public void stateChanged(PEPeer peer, int newState) {
                if (newState == 30) {
                    ClientStatsView.this.addPeer(peer);
                } else if (newState == 40 || newState == 50) {
                    peer.removeListener(this);
                }
            }

            @Override
            public void sentBadChunk(PEPeer peer, int pieceNum, int totalBadChunks) {
            }

            @Override
            public void removeAvailability(PEPeer peer, BitFlags peerHavePieces) {
            }

            @Override
            public void addAvailability(PEPeer peer, BitFlags peerHavePieces) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPeer(PEPeer peer) {
        byte[] bloomId;
        long now = SystemTime.getCurrentTime();
        byte[] address = null;
        byte[] peerId = peer.getId();
        InetAddress ip = peer.getAlternativeIPv6();
        if (ip == null) {
            try {
                ip = AddressUtils.getByName(peer.getIp());
                address = ip.getAddress();
            }
            catch (Throwable e) {
                String ipString = peer.getIp();
                if (ipString != null) {
                    address = ByteFormatter.intToByteArray(ipString.hashCode());
                }
            }
        } else {
            address = ip.getAddress();
        }
        if (address == null) {
            bloomId = peerId;
        } else {
            bloomId = new byte[8 + address.length];
            System.arraycopy(peerId, 0, bloomId, 0, 8);
            System.arraycopy(address, 0, bloomId, 8, address.length);
        }
        Map<String, ClientStatsDataSource> map = this.mapData;
        synchronized (map) {
            String network;
            PeerItem identity;
            boolean inBloomFilter;
            String id;
            ClientStatsDataSource stat;
            boolean needNew;
            this.calendar.setTimeInMillis(now);
            int thisMonth = this.calendar.get(2);
            if (thisMonth != this.lastAddMonth) {
                if (this.lastAddMonth == 0) {
                    this.lastAddMonth = thisMonth;
                } else {
                    String s = new SimpleDateFormat("yyyy-MM").format(new Date(this.lastAdd));
                    String filename = CONFIG_FILE_ARCHIVE.replace("%1", s);
                    this.save(filename);
                    this.lastAddMonth = thisMonth;
                    this.lastAdd = 0L;
                    this.bloomFilter = BloomFilterFactory.createRotating(BloomFilterFactory.createAddOnly(100000), 2);
                    this.bloomFilterPeerId = BloomFilterFactory.createRotating(BloomFilterFactory.createAddOnly(50000), 2);
                    this.overall = new ClientStatsOverall();
                    this.mapData.clear();
                    if (this.tv != null) {
                        this.tv.removeAllTableRows();
                    }
                    this.totalTime = 0L;
                    this.startedListeningOn = 0L;
                }
            }
            boolean bl = needNew = (stat = this.mapData.get(id = this.getID(peer))) == null;
            if (needNew) {
                stat = new ClientStatsDataSource();
                stat.overall = this.overall;
                stat.client = id;
                this.mapData.put(id, stat);
            }
            boolean bl2 = inBloomFilter = this.bloomFilter.contains(bloomId) || this.bloomFilterPeerId.contains(peerId);
            if (!inBloomFilter) {
                this.bloomFilter.add(bloomId);
                this.bloomFilterPeerId.add(peerId);
                this.lastAdd = now;
                ClientStatsOverall clientStatsOverall = this.overall;
                synchronized (clientStatsOverall) {
                    ++this.overall.count;
                }
                ++stat.count;
            }
            ++stat.current;
            long existingBytesReceived = peer.getStats().getTotalDataBytesReceived();
            long existingBytesSent = peer.getStats().getTotalDataBytesSent();
            long existingBytesDiscarded = peer.getStats().getTotalBytesDiscarded();
            if (existingBytesReceived > 0L) {
                stat.bytesReceived -= existingBytesReceived;
                if (stat.bytesReceived < 0L) {
                    stat.bytesReceived = 0L;
                }
            }
            if (existingBytesSent > 0L) {
                stat.bytesSent -= existingBytesSent;
                if (stat.bytesSent < 0L) {
                    stat.bytesSent = 0L;
                }
            }
            if (existingBytesDiscarded > 0L) {
                stat.bytesDiscarded -= existingBytesDiscarded;
                if (stat.bytesDiscarded < 0L) {
                    stat.bytesDiscarded = 0L;
                }
            }
            if (peer instanceof PEPeerTransport && (identity = ((PEPeerTransport)peer).getPeerItemIdentity()) != null && (network = identity.getNetwork()) != null) {
                Map<String, Object> map2 = stat.perNetworkStats.get(network);
                if (map2 == null) {
                    map2 = new HashMap<String, Object>();
                    stat.perNetworkStats.put(network, map2);
                }
                if (!inBloomFilter) {
                    long count = MapUtils.getMapLong(map2, "count", 0L);
                    map2.put("count", count + 1L);
                }
                if (existingBytesReceived > 0L) {
                    long bytesReceived = MapUtils.getMapLong(map2, "bytesReceived", 0L);
                    if ((bytesReceived -= existingBytesReceived) < 0L) {
                        bytesReceived = 0L;
                    }
                    map2.put("bytesReceived", bytesReceived);
                }
                if (existingBytesSent > 0L) {
                    long bytesSent = MapUtils.getMapLong(map2, "bytesSent", 0L);
                    if ((bytesSent -= existingBytesSent) < 0L) {
                        bytesSent = 0L;
                    }
                    map2.put("bytesSent", bytesSent);
                }
                if (existingBytesDiscarded > 0L) {
                    long bytesDiscarded = MapUtils.getMapLong(map2, "bytesDiscarded", 0L);
                    if ((bytesDiscarded -= existingBytesDiscarded) < 0L) {
                        bytesDiscarded = 0L;
                    }
                    map2.put("bytesDiscarded", bytesDiscarded);
                }
            }
            if (this.tv != null) {
                if (needNew) {
                    this.tv.addDataSource(stat);
                } else {
                    TableRowCore row = this.tv.getRow(stat);
                    if (row != null) {
                        row.invalidate();
                    }
                }
            }
        }
    }

    @Override
    public void peerManagerAdded(PEPeerManager manager) {
    }

    @Override
    public void peerManagerRemoved(PEPeerManager manager) {
    }

    @Override
    public void peerManagerWillBeAdded(PEPeerManager manager) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void peerRemoved(PEPeer peer) {
        Map<String, ClientStatsDataSource> map = this.mapData;
        synchronized (map) {
            ClientStatsDataSource stat = this.mapData.get(this.getID(peer));
            if (stat != null) {
                TableRowCore row;
                PeerItem identity;
                --stat.current;
                String network = null;
                if (peer instanceof PEPeerTransport && (identity = ((PEPeerTransport)peer).getPeerItemIdentity()) != null) {
                    network = identity.getNetwork();
                }
                stat.bytesReceived += peer.getStats().getTotalDataBytesReceived();
                stat.bytesSent += peer.getStats().getTotalDataBytesSent();
                stat.bytesDiscarded += peer.getStats().getTotalBytesDiscarded();
                if (network != null) {
                    Map<String, Object> map2 = stat.perNetworkStats.get(network);
                    if (map2 == null) {
                        map2 = new HashMap<String, Object>();
                        stat.perNetworkStats.put(network, map2);
                    }
                    long bytesReceived = MapUtils.getMapLong(map2, "bytesReceived", 0L);
                    map2.put("bytesReceived", bytesReceived + peer.getStats().getTotalDataBytesReceived());
                    long bytesSent = MapUtils.getMapLong(map2, "bytesSent", 0L);
                    map2.put("bytesSent", bytesSent + peer.getStats().getTotalDataBytesSent());
                    long bytesDiscarded = MapUtils.getMapLong(map2, "bytesDiscarded", 0L);
                    map2.put("bytesDiscarded", bytesDiscarded + peer.getStats().getTotalBytesDiscarded());
                }
                if (this.tv != null && (row = this.tv.getRow(stat)) != null) {
                    row.invalidate();
                }
            }
        }
    }

    private String getID(PEPeer peer) {
        String s = peer.getClientNameFromPeerID();
        if (s == null && (s = peer.getClient()).startsWith("HTTP Seed")) {
            return "HTTP Seed";
        }
        if (s.startsWith("Unknown [") && s.length() >= 11) {
            s = String.valueOf(s.substring(0, 11)) + "]";
        }
        return s.replaceAll(" v?[0-9._]+", "");
    }
}

