/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.clientstats;

import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.ui.swt.views.clientstats.ClientStatsDataSource;

public class ColumnCS_Pct
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "percent";

    public ColumnCS_Pct(TableColumn column) {
        column.initialize(2, -2, 50);
        column.addListeners(this);
        column.setType(3);
        column.setRefreshInterval(-2);
    }

    @Override
    public void refresh(TableCell cell) {
        ClientStatsDataSource ds = (ClientStatsDataSource)cell.getDataSource();
        if (ds == null) {
            return;
        }
        float val = (float)ds.count * 1000.0f / (float)ds.overall.count;
        if (cell.setSortValue(val) || !cell.isValid()) {
            cell.setText(DisplayFormatters.formatPercentFromThousands((int)val));
        }
    }
}

