/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.clientstats;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.ui.swt.views.clientstats.ClientStatsDataSource;
import com.biglybt.util.MapUtils;
import java.util.Map;

public class ColumnCS_Received
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "received";

    public ColumnCS_Received(TableColumn column) {
        column.initialize(2, -2, 80);
        column.addListeners(this);
        column.setType(3);
        String network = column.getUserDataString("network");
        if (network != null) {
            column.setVisible(false);
            column.setNameOverride(String.valueOf(network) + " " + MessageText.getString("ClientStats.column.received"));
        }
    }

    @Override
    public void refresh(TableCell cell) {
        String network;
        ClientStatsDataSource ds = (ClientStatsDataSource)cell.getDataSource();
        if (ds == null) {
            return;
        }
        long val = ds.bytesReceived;
        TableColumn column = cell.getTableColumn();
        if (column != null && (network = column.getUserDataString("network")) != null) {
            Map<String, Object> map = ds.perNetworkStats.get(network);
            val = map != null ? MapUtils.getMapLong(map, "bytesReceived", 0L) : 0L;
        }
        if (cell.setSortValue(val) || !cell.isValid()) {
            cell.setText(DisplayFormatters.formatByteCountToKiBEtc(val));
        }
    }
}

