/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.columnsetup;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellClipboardListener;
import com.biglybt.pif.ui.tables.TableCellDisposeListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellVisibilityListener;
import com.biglybt.ui.common.table.TableCellCore;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.swt.views.columnsetup.TableColumnSetupWindow;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.impl.FakeTableCell;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class ColumnTC_Sample
extends CoreTableColumnSWT
implements TableCellAddedListener {
    public static final String COLUMN_ID = "TableColumnSample";

    public ColumnTC_Sample(String tableID) {
        super(COLUMN_ID, tableID);
        String existing;
        this.setPosition(-1);
        this.setRefreshInterval(-2);
        this.setWidth(120);
        if (tableID.equals("RowDetails") && ((existing = this.getNameOverride()) == null || existing.isEmpty())) {
            this.setNameOverride(MessageText.getString("label.value"));
        }
    }

    @Override
    public void cellAdded(TableCell cell) {
        TableColumnCore column = (TableColumnCore)cell.getDataSource();
        TableViewSWT tv = (TableViewSWT)((TableCellCore)cell).getTableRowCore().getView();
        TableColumnSetupWindow tvs = (TableColumnSetupWindow)tv.getParentDataSource();
        TableRowCore sampleRow = (TableRowCore)tvs.getSampleRow();
        Cell c = new Cell(cell, column, tv.getTableComposite(), sampleRow);
        cell.addListeners(c);
        cell.setData("Cell", c);
    }

    @Override
    public int compare(TableRowCore row1, TableRowCore row2) {
        String IS_GRAPHIC = "GRAPHIC";
        TableCell cell1 = row1.getTableCell(this);
        TableCell cell2 = row2.getTableCell(this);
        Cell c1 = (Cell)cell1.getData("Cell");
        Cell c2 = (Cell)cell2.getData("Cell");
        String str1 = null;
        String str2 = null;
        if (c1 != null) {
            FakeTableCell fc1 = c1.sampleCell;
            str1 = fc1.getText();
            if (str1 == null) {
                str1 = fc1.getTextEquivalent();
            }
            if (str1 == null) {
                str1 = fc1.getClipboardText();
            }
            if (str1 == null || str1.isEmpty()) {
                str1 = fc1.getIcon() != null || fc1.getGraphic() != null ? "GRAPHIC" : "";
            }
        }
        if (c2 != null) {
            FakeTableCell fc2 = c2.sampleCell;
            str2 = fc2.getText();
            if (str2 == null) {
                str2 = fc2.getTextEquivalent();
            }
            if (str2 == null || str2.isEmpty()) {
                str2 = fc2.getClipboardText();
            }
            if (str2 == null || str2.isEmpty()) {
                str2 = fc2.getIcon() != null || fc2.getGraphic() != null ? "GRAPHIC" : "";
            }
        }
        if (str1 == null) {
            str1 = cell1.getClipboardText();
        }
        if (str2 == null) {
            str2 = cell2.getClipboardText();
        }
        int res = 0;
        if (str1 != "GRAPHIC" || str2 != "GRAPHIC") {
            res = str1 == "GRAPHIC" ? 1 : (str2 == "GRAPHIC" ? -1 : str1.compareTo(str2));
        }
        return (this.isSortAscending() ? 1 : -1) * res;
    }

    private static class Cell
    implements TableCellRefreshListener,
    TableCellSWTPaintListener,
    TableCellVisibilityListener,
    TableCellDisposeListener,
    TableCellClipboardListener {
        private final TableColumnCore column;
        private FakeTableCell sampleCell;

        public Cell(TableCell parentCell, TableColumnCore column, Composite c, TableRowCore sampleRow) {
            this.column = column;
            if (sampleRow == null) {
                return;
            }
            Object ds = sampleRow.getDataSource(true);
            this.sampleCell = new FakeTableCell(column, ds);
            this.sampleCell.setOrentation(16384);
            Rectangle bounds = ((TableCellSWT)parentCell).getBounds();
            this.sampleCell.setControl(c, bounds, false);
        }

        @Override
        public void dispose(TableCell cell) {
            this.sampleCell = null;
        }

        @Override
        public void cellPaint(GC gc, TableCellSWT cell) {
            FakeTableCell sampleCell = this.sampleCell;
            if (sampleCell == null) {
                return;
            }
            Rectangle bounds = cell.getBounds();
            bounds.x += 2;
            bounds.width -= 4;
            sampleCell.setCellArea(bounds);
            try {
                sampleCell.refresh();
                sampleCell.doPaint(gc);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }

        @Override
        public void cellVisibilityChanged(TableCell cell, int visibility) {
            FakeTableCell sampleCell = this.sampleCell;
            if (sampleCell == null) {
                return;
            }
            try {
                this.column.invokeCellVisibilityListeners(sampleCell, visibility);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }

        @Override
        public String getClipboardText(TableCell cell) {
            FakeTableCell sampleCell = this.sampleCell;
            if (sampleCell == null) {
                return null;
            }
            return sampleCell.getClipboardText();
        }

        @Override
        public void refresh(TableCell cell) {
            FakeTableCell sampleCell = this.sampleCell;
            if (sampleCell == null) {
                return;
            }
            if (!cell.isShown()) {
                return;
            }
            sampleCell.refresh(true, true, true);
            cell.setSortValue(sampleCell.getSortValue());
            cell.invalidate();
            if (cell instanceof TableCellSWT) {
                ((TableCellSWT)cell).redraw();
            }
        }
    }
}

