/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.configsections;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.util.Constants;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ColorParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterImpl;
import com.biglybt.ui.config.ConfigSectionImpl;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.UI;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.config.ColorSwtParameter;
import com.biglybt.ui.swt.config.SwtParameterValueProcessor;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.views.configsections.BaseConfigSectionSWT;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public class ConfigSectionInterfaceColorSWT
extends ConfigSectionImpl
implements BaseConfigSectionSWT {
    private static final String[] sColorsToOverride = new String[]{"progressBar", "error", "warning", "altRow"};
    public static final String SECTION_ID = "color";

    public ConfigSectionInterfaceColorSWT() {
        super(SECTION_ID, "style");
    }

    @Override
    public void build() {
        this.setDefaultUITypesForAdd("swt");
        if (UI.canUseSystemTheme()) {
            String res = Constants.isWindows ? "ConfigView.section.style.usedarktheme" : "ConfigView.section.style.usesystemtheme";
            this.add(new BooleanParameterImpl("Use System Theme", res), new List[0]);
        }
        if (Constants.isLinux) {
            this.add(new BooleanParameterImpl("Force Dark Theme", "ConfigView.section.style.forcedarktheme"), new List[0]);
        }
        ColorParameterImpl colorScheme = new ColorParameterImpl("Color Scheme", "ConfigView.section.color");
        this.add(colorScheme, new List[0]);
        colorScheme.setSuffixLabelKey("restart.required.for.some");
        BooleanParameterImpl gradient_sel = new BooleanParameterImpl("Gradient Fill Selection", "ConfigView.section.style.gradient.selection");
        this.add(gradient_sel, new List[0]);
        ArrayList listOverride = new ArrayList();
        this.add(new BooleanParameterImpl("ForceNoColor", "ConfigView.section.style.forceGrayscale"), listOverride);
        String[] stringArray = sColorsToOverride;
        int n = sColorsToOverride.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!Utils.TABLE_GRIDLINE_IS_ALTERNATING_COLOR || !s.equals("altRow")) {
                String sConfigID = "Colors." + s;
                ColorParameterImpl colorParm = new ColorParameterImpl(sConfigID, "ConfigView.section.style.colorOverride." + s);
                this.add(colorParm, listOverride);
            }
            ++n2;
        }
        BooleanParameterImpl dark_tables = new BooleanParameterImpl("Dark Table Colors", "ConfigView.section.style.dark.tables");
        this.add(dark_tables, listOverride);
        BooleanParameterImpl dark_misc = new BooleanParameterImpl("Dark Misc Colors", "ConfigView.section.style.dark.misc");
        this.add(dark_misc, listOverride);
        this.add(new ParameterGroupImpl("ConfigView.section.style.colorOverrides", listOverride), new List[0]);
    }

    @Override
    public void configSectionCreate(Composite parent, Map<ParameterImpl, BaseSwtParameter> mapParamToSwtParam) {
        boolean isAZ3 = COConfigurationManager.getStringParameter("ui").equals("az3");
        if (!isAZ3) {
            return;
        }
        BaseSwtParameter pg = mapParamToSwtParam.get(this.getPluginParam("ConfigView.section.style.colorOverrides"));
        if (pg == null) {
            return;
        }
        Composite cColorOverride = (Composite)pg.getMainControl();
        Display display = cColorOverride.getDisplay();
        String[][] override_keys_blocks = new String[][]{{"config.skin.color.sidebar.bg"}, {"config.skin.color.library.header"}};
        SkinColorValueProcessor skinColorValueProcessor = new SkinColorValueProcessor(display);
        int i = 0;
        while (i < override_keys_blocks.length) {
            String[] override_keys;
            if (i == 1) {
                Label label = new Label(cColorOverride, 0);
                GridData gridData = new GridData(768);
                gridData.horizontalSpan = 2;
                label.setLayoutData((Object)gridData);
                label = new Label(cColorOverride, 0);
                Messages.setLanguageText((Widget)label, "restart.required.for.following");
                gridData = new GridData(768);
                gridData.horizontalSpan = 2;
                label.setLayoutData((Object)gridData);
            }
            String[] stringArray = override_keys = override_keys_blocks[i];
            int n = override_keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                new ColorSwtParameter(cColorOverride, key, key, null, true, skinColorValueProcessor);
                ++n2;
            }
            ++i;
        }
    }

    private static class SkinColorValueProcessor
    implements SwtParameterValueProcessor<ColorSwtParameter, int[]> {
        private final Display display;

        public SkinColorValueProcessor(Display display) {
            this.display = display;
        }

        @Override
        public int[] getValue(ColorSwtParameter p) {
            int[] nArray;
            boolean is_override;
            String key = p.getParamID();
            boolean bl = is_override = COConfigurationManager.getStringParameter(key).length() > 0;
            if (!is_override) {
                return this.getDefaultValue(p);
            }
            Color existing = ColorCache.getSchemedColor((Device)this.display, key);
            if (existing == null) {
                nArray = null;
            } else {
                int[] nArray2 = new int[3];
                nArray2[0] = existing.getRed();
                nArray2[1] = existing.getGreen();
                nArray = nArray2;
                nArray2[2] = existing.getBlue();
            }
            return nArray;
        }

        @Override
        public int[] getDefaultValue(ColorSwtParameter p) {
            return null;
        }

        @Override
        public boolean isDefaultValue(ColorSwtParameter p) {
            String key = p.getParamID();
            return COConfigurationManager.getStringParameter(key).isEmpty();
        }

        @Override
        public boolean setValue(ColorSwtParameter p, int[] value) {
            String key = p.getParamID();
            if (COConfigurationManager.setParameter(key, String.valueOf(value[0]) + "," + value[1] + "," + value[2])) {
                p.informChanged();
                return true;
            }
            return false;
        }

        @Override
        public boolean resetToDefault(ColorSwtParameter p) {
            String key = p.getParamID();
            if (COConfigurationManager.removeParameter(key)) {
                p.informChanged();
                return true;
            }
            return false;
        }
    }
}

